
// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/block_store.h,v 1.8 2002/01/09 14:50:13 weldon Exp $
//

#ifndef _block_store_H_
#define _block_store_H_

// The garbage collected heap is divided into blocks of size 2-power-k,
// aligned on 2-power-k bounderies. The specific 'k' will be tuned,
// but initially we may pick something like 16. 
// All the garbage collected regions (cars, steps, LOS) are composed
// from blocks that are managed by the block manager.
//

#include "platform.h"
#include "object_layout.h"

#include "gc_space.h"
#include "gc_consts.h"

#define NURSERY_TYPE 0
#define INVALID_TYPE 255

class Block_List;
class Car;
class Gc_Fast_Hooks;
class Gc_Space;
class Gc_Plan;
//class Generation;
class Large_Object_Store;
class Nursery;
class Obsolete_Space;
class Remembered_Set;
class Step;
class Train;
class Train_Generation;
class Step_Plus_Nursery_Generation;
class LOS_Container;

extern POINTER_SIZE_INT global_heap_base; // in gc_globals.

    
	// The Block Store is being asked to extend the heap
	// by the specified number of bytes. 
	//
	bool _extend_heap(int block_size_bytes);

    block_info *p_get_new_block(bool extend, bool collect_returns_null, bool in_a_gc);
#if 1
#define MAX_BUCKET 10
#define MAX_BUCKET_OBJECT_SIZE (GC_BLOCK_ALLOC_SIZE/2)
#define MIN_BUCKET_OBJECT_SIZE 64
#else 
    // The rule here is that we need enough buckets so that
    // each multiple of two between MIN_BUCKET_OBJECT_SIZE
    // and MAX_BUCKET_OBJECT_SIZE has a bucket.
    // 64K means MAX_BUCKET_OBJECT_SIZE is 32 K
    // so we need 11 buckets to have buckets for 32 byte objects.
    // but only 10 buckets for objects of 64 bytes.
    // Each object must have a mark byte in the block_info table
    // so using 2K bytes allows for the minimum object size to be 32 
    // bytes. 16 byte objects are not possible given the max size of
    // the byte table.
    // 16, 32, 64, 128, 256, 512, 1024, 2K, 4K, 8K, 16K, 32K
#define MAX_BUCKET 11
#define MAX_BUCKET_OBJECT_SIZE (GC_BLOCK_ALLOC_SIZE/2)
#define MIN_BUCKET_OBJECT_SIZE 32
#endif

    // A list of free blocks.
    extern block_info *free_blocks[MAX_BUCKET];

    // A Null terminated list where each element holds the list of blocks linked through
    // all_blocks_next. This can be used to coalesce adjacent blocks.
    extern block_group_link *block_group_list;

class Block_Store {
public:

    Block_Store(Gc_Fast_Hooks *p_gc_hooks,
                Gc_Plan *p_gc_plan,
		        unsigned int block_size_bytes);

    virtual ~Block_Store();

    inline bool is_object_in_large_object_space(Java_java_lang_Object *p_obj) {
		return GC_BLOCK_INFO(p_obj)->in_los_p;
	}

	bool is_obsolete_object(Java_java_lang_Object *p_obj);


    void init_block (block_info *the_block, unsigned int size_in_blocks);
    // p_get_head_mt
    //  This routine takes the address of the head of a list and delinks
    //  the first item on the list. It is a thread safe routine.
    // If the head of the list is NULL return NULL;
    block_info *p_get_head_ts (block_info **head);
    // This must be thread safe...
    block_info *p_get_multi_block(unsigned int size, bool extend, bool collect_returns_null, bool in_a_gc);
    void link_block_ts (block_info **head, block_info *block);
    void link_free_blocks (block_info *freed_block, unsigned int blocks);
    void coalesce_free_blocks();

    bool is_block_available (unsigned int size);
	
	//
    // Card table logic needs to know where heap starts to calculate
	// card.
	//
	Byte * get_heap_base();

    unsigned int size_up_to_los_block_size (unsigned int number_of_bytes);

	// The Block Store is being asked to extend the heap
	// by the specified number of bytes. 
	//
	bool _extend_heap(int block_size_bytes);

    // A list of free blocks.
    block_info *free_blocks[MAX_BUCKET];

    // A Null terminated list where each element holds the list of blocks linked through
    // all_blocks_next. This can be used to coalesce adjacent blocks.
    block_group_link *block_group_list;

private:

    int _number_of_tables;

	Train_Generation *_p_mature_generation;

	Step_Plus_Nursery_Generation *_p_young_generation;

	LOS_Container *_p_los_container;

	//
	// When creating the block store, create one large super
	// block out of all the blocks.
	//
	void _initialize_block_tables(void *p_start,
		                          void *p_last_block);

	//
	//
	// Private copy of the plan object.
	//
	Gc_Plan *_p_gc_plan;

    //
	// For bounds checking, we maintain the upper bound of the 
	// meta information tables in the block store.
	// NOTE: This reflects the maximum heap size.
	//
	int _maximum_table_index;

    //
    // This is a global that we can use for performance, instead
    // of creating a new one each time on demand.
    //
    Obsolete_Space *_p_global_obsolete_space;

	//
	// Get relevant information about the underlying machine/os
	// (ex: page size, number of active processors, etc..)
	//
	void _get_system_info();
    //
    // Protecting the block store from concurrent access.
    //
    CRITICAL_SECTION _lock;

	//
	// A pointer to the blocks that are in the garbage_collected
	// portion of the heap.
	//
	void * _gc_free_list;

    //
    // This is the size of blocks doled out to steps and cars.
    //
	unsigned int _sub_block_size_bytes;

	//
	// This is the base of the allocated region, including the
	// meta data region.
	//
	void *_p_real_heap_base;
	//
	// THis is the base of the actual garbage collected portion of
	// the allocated heap.
	//
	void *_p_effective_heap_base;
	//
	// This is just the garbage collected heap size, not including
	// the ancilliary meta information.
	//
	unsigned long _effective_heap_size_bytes;

	//
	// Pointer to the last block in committed space.
	//
	void *_p_last_block;

	//
	// The machine (OS) page size.
	//
	unsigned int _machine_page_size_bytes;
	//
	// The ENABLED processors on this machine.
	//
	unsigned int _number_of_active_processors;

	//
	// The number of entries in the table.
	// NOTE: this reflects the final heap size.	
	//
    unsigned long _table_size_entries;
	//
	// The corresponding table size in bytes
	// NOTE: this reflects the final heap size.
	//
	unsigned long _table_size_bytes;
	//
	// This is a count of the total number of blocks in the 
	// block store.
	// NOTE: this reflects the CURRENT heap size.	
	//
	int _total_current_sub_blocks;
	
	//
	// This is a count of the free blocks in the block store.
	//
	unsigned long _free_sub_blocks;

};

#endif // _Block_Store_H_
