// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/root_set_enum.h,v 1.3 2001/12/07 00:16:00 xli18 Exp $
//



#ifndef _ROOT_SET_ENUM_H_
#define _ROOT_SET_ENUM_H_


#include "orp_types.h"
#include "object_layout.h"

//////////////////////////////////////////////////////////////////////////
//////// begin GC-ORE interface

//
// The scenario for multi-threaded GC is:
// The thread which runs out of memory, performs GC in the following steps:
// 1. orp_enumerate_root_set_all_threads suspends all threads and enumerates
//    the root set.
// 2. The heap is scanned and memory reclaimed.
// 3. The threads are resumed by calling orp_resume_threads_after
//


// Root set enumeration for all Java threads.
ORPExport void orp_enumerate_root_set_all_threads();


// This function resumes all threads suspended by 
// orp_enumerate_root_set_all_threads
ORPExport void orp_resume_threads_after(bool debug_breakpoint);

void orp_gc_done_for_current_thread();

 

// for debug only.  If gc determines an object is unreachable
// this api lets orp synchronization code verify that there are no
// outstanding locks against the object
void orp_check_monitor_lock_consistency(void *p_obj);

//////// end GC-ORE interface
//////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////
//////// begin GC native interface

//
// GC can only be disabled in native code.  In jitted code GC is always
// "enabled."  Of course it doesn't mean that GC can happen at any point
// in jitted code -- only at GC-safe points.
//

//
// orp_enable_gc and orp_disable_gc return the previous state of the gc-enable state,
// i.e., true for enabled and false for disabled.
// In normal use the return value is discarded.
//

//
// Enable GC.  Also check is the thread is in the state of being moved
// to a GC-safe point.  If it is, orp_disable_gc() will block until the master thread releases it.

ORPExport bool orp_enable_gc();

// Disable GC.
ORPExport bool orp_disable_gc();


enum gc_enable_disable_state {
    disabled,
    enabled,
    enabled_will_block,
    enabled_hijack,
    bogus,
};

gc_enable_disable_state gc_if_disabled_then_enable(gc_enable_disable_state *p_en_dis);

gc_enable_disable_state gc_if_enabled_then_EWB(gc_enable_disable_state *p_en_dis);

gc_enable_disable_state gc_if_EWB_then_enable(gc_enable_disable_state *p_en_dis);

gc_enable_disable_state gc_if_enabled_then_disable(gc_enable_disable_state *p_en_dis);

gc_enable_disable_state gc_if_enabled_hijack_then_disable(gc_enable_disable_state *p_en_dis);

gc_enable_disable_state gc_if_disabled_then_enabled_hijack(gc_enable_disable_state *p_en_dis);

struct GC_Frame {
    void *gc_block;
    int gc_block_len;
    GC_Frame *next;
};

ORPExport void orp_push_gc_frame(GC_Frame *frame, void *gc_block, int gc_block_len);
ORPExport void orp_pop_gc_frame(GC_Frame *frame);

// For internal ORP use only.
#ifdef USE_GC_DLL
ORPExport
#endif
Boolean orp_is_gc_enabled(void *thread_id);
#ifdef USE_GC_DLL
ORPExport
#endif
bool orp_get_gc_enabled_state();
void orp_set_gc_enabled_state(bool state);

void *orp_malloc_gc_safe(unsigned size);
void orp_free_gc_safe(void *);



//////// end GC native interface
//////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////
//////// begin object handles

struct Object_Handle_Struct {
    Java_java_lang_Object *java_reference;
    Object_Handle_Struct *prev;
    Object_Handle_Struct *next;
    Boolean allocated_on_the_stack;
};

typedef Object_Handle_Struct *Object_Handle;


ORPExport Object_Handle orp_create_local_object_handle();
Object_Handle orp_allocate_object_handle();
void orp_free_object_handle(Object_Handle);


//////// end object handles
//////////////////////////////////////////////////////////////////////////




//////// Stuff below is for internal ORP use only

void orp_at_a_jit_breakpoint();

void *getaddress__orp_at_a_jit_breakpoint();


void orp_enumerate_root_set_verbose();


void orp_enumerate_static_fields();

// To be called within an assert to make sure enumeration is possible at
// critical points.
bool stack_enumeration_is_possible ();

#endif
