/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;

public abstract class Type
implements Serializable {
    protected byte type;
    protected String signature;
    public static final BasicType VOID = new BasicType(12);
    public static final BasicType BOOLEAN = new BasicType(4);
    public static final BasicType INT = new BasicType(10);
    public static final BasicType SHORT = new BasicType(9);
    public static final BasicType BYTE = new BasicType(8);
    public static final BasicType LONG = new BasicType(11);
    public static final BasicType DOUBLE = new BasicType(7);
    public static final BasicType FLOAT = new BasicType(6);
    public static final BasicType CHAR = new BasicType(5);
    public static final ObjectType OBJECT = new ObjectType("java.lang.Object");
    public static final ObjectType CLASS = new ObjectType("java.lang.Class");
    public static final ObjectType STRING = new ObjectType("java.lang.String");
    public static final ObjectType STRINGBUFFER = new ObjectType("java.lang.StringBuffer");
    public static final ObjectType THROWABLE = new ObjectType("java.lang.Throwable");
    public static final Type[] NO_ARGS = new Type[0];
    public static final ReferenceType NULL = new ReferenceType(){};
    public static final Type UNKNOWN = new Type(15, "<unknown object>"){};
    private static ThreadLocal consumed_chars = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(0);
        }
    };

    protected Type(byte by, String string) {
        this.type = by;
        this.signature = string;
    }

    public int hashCode() {
        return this.type ^ this.signature.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Type) {
            Type type = (Type)object;
            return this.type == type.type && this.signature.equals(type.signature);
        }
        return false;
    }

    public String getSignature() {
        return this.signature;
    }

    public byte getType() {
        return this.type;
    }

    public int getSize() {
        switch (this.type) {
            case 7: 
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    public String toString() {
        return this.equals(NULL) || this.type >= 15 ? this.signature : Utility.signatureToString(this.signature, false);
    }

    public static String getMethodSignature(Type type, Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = typeArray == null ? 0 : typeArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(typeArray[i].getSignature());
        }
        stringBuffer.append(')');
        stringBuffer.append(type.getSignature());
        return stringBuffer.toString();
    }

    private static int unwrap(ThreadLocal threadLocal) {
        return (Integer)threadLocal.get();
    }

    private static void wrap(ThreadLocal threadLocal, int n) {
        threadLocal.set(new Integer(n));
    }

    public static final Type getType(String string) throws StringIndexOutOfBoundsException {
        byte by = Utility.typeOfSignature(string);
        if (by <= 12) {
            Type.wrap(consumed_chars, 1);
            return BasicType.getType(by);
        }
        if (by == 13) {
            int n = 0;
            while (string.charAt(++n) == '[') {
            }
            Type type = Type.getType(string.substring(n));
            int n2 = Type.unwrap(consumed_chars) + n;
            Type.wrap(consumed_chars, n2);
            return new ArrayType(type, n);
        }
        int n = string.indexOf(59);
        if (n < 0) {
            throw new ClassFormatException("Invalid signature: " + string);
        }
        Type.wrap(consumed_chars, n + 1);
        return new ObjectType(string.substring(1, n).replace('/', '.'));
    }

    public static Type getReturnType(String string) {
        try {
            int n = string.lastIndexOf(41) + 1;
            return Type.getType(string.substring(n));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
    }

    public static Type[] getArgumentTypes(String string) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            int n = 1;
            while (string.charAt(n) != ')') {
                arrayList.add(Type.getType(string.substring(n)));
                n += Type.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
        Type[] typeArray = new Type[arrayList.size()];
        arrayList.toArray(typeArray);
        return typeArray;
    }

    public static Type getType(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (clazz.isArray()) {
            return Type.getType(clazz.getName());
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT;
            }
            if (clazz == Void.TYPE) {
                return VOID;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (clazz == Byte.TYPE) {
                return BYTE;
            }
            if (clazz == Short.TYPE) {
                return SHORT;
            }
            if (clazz == Byte.TYPE) {
                return BYTE;
            }
            if (clazz == Long.TYPE) {
                return LONG;
            }
            if (clazz == Character.TYPE) {
                return CHAR;
            }
            throw new IllegalStateException("Ooops, what primitive type is " + clazz);
        }
        return new ObjectType(clazz.getName());
    }

    public static Type[] getTypes(Class[] classArray) {
        Type[] typeArray = new Type[classArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = Type.getType(classArray[i]);
        }
        return typeArray;
    }

    public static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(Type.getType(classArray[i]).getSignature());
        }
        stringBuffer.append(")");
        stringBuffer.append(Type.getType(method.getReturnType()).getSignature());
        return stringBuffer.toString();
    }
}

