/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of SableCC.                             *
 * See the file "LICENSE" for copyright information and the  *
 * terms and conditions for copying, distribution and        *
 * modification of SableCC.                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package org.sablecc.sablecc.node;

import org.sablecc.sablecc.Switch;
import org.sablecc.sablecc.analysis.Analysis;

public final class PSet1 extends PSet
{
    public void apply(Switch sw)
    {
        ((Analysis) sw).casePSet1(this);
    }

    public String toString()
    {
        return ""
            + node1
            + node2
            + node3
            + node4
            + node5;
    }

    private TLBkt node1;

    public TLBkt getNode1()
    {
        return node1;
    }

    public void setNode1(TLBkt node)
    {
        if(node1 != null)
        {
            node1.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node1 = node;
    }

    private Basic node2;

    public Basic getNode2()
    {
        return node2;
    }

    public void setNode2(Basic node)
    {
        if(node2 != null)
        {
            node2.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node2 = node;
    }

    private BinOp node3;

    public BinOp getNode3()
    {
        return node3;
    }

    public void setNode3(BinOp node)
    {
        if(node3 != null)
        {
            node3.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node3 = node;
    }

    private Basic node4;

    public Basic getNode4()
    {
        return node4;
    }

    public void setNode4(Basic node)
    {
        if(node4 != null)
        {
            node4.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node4 = node;
    }

    private TRBkt node5;

    public TRBkt getNode5()
    {
        return node5;
    }

    public void setNode5(TRBkt node)
    {
        if(node5 != null)
        {
            node5.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node5 = node;
    }

    void removeChild(Node child)
    {
        if(node1 == child)
        {
            node1 = null;
        }

        if(node2 == child)
        {
            node2 = null;
        }

        if(node3 == child)
        {
            node3 = null;
        }

        if(node4 == child)
        {
            node4 = null;
        }

        if(node5 == child)
        {
            node5 = null;
        }

    }
}

