/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of SableCC.                             *
 * See the file "LICENSE" for copyright information and the  *
 * terms and conditions for copying, distribution and        *
 * modification of SableCC.                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package org.sablecc.sablecc.node;

import org.sablecc.sablecc.Switch;
import org.sablecc.sablecc.analysis.Analysis;

public final class TokenDef1 extends TokenDef
{
    public void apply(Switch sw)
    {
        ((Analysis) sw).caseTokenDef1(this);
    }

    public String toString()
    {
        return ""
            + node1
            + node2
            + node3
            + node4
            + node5
            + node6;
    }

    private StateListOpt node1;

    public StateListOpt getNode1()
    {
        return node1;
    }

    public void setNode1(StateListOpt node)
    {
        if(node1 != null)
        {
            node1.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node1 = node;
    }

    private TId node2;

    public TId getNode2()
    {
        return node2;
    }

    public void setNode2(TId node)
    {
        if(node2 != null)
        {
            node2.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node2 = node;
    }

    private TEqual node3;

    public TEqual getNode3()
    {
        return node3;
    }

    public void setNode3(TEqual node)
    {
        if(node3 != null)
        {
            node3.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node3 = node;
    }

    private RegExp node4;

    public RegExp getNode4()
    {
        return node4;
    }

    public void setNode4(RegExp node)
    {
        if(node4 != null)
        {
            node4.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node4 = node;
    }

    private LookAheadOpt node5;

    public LookAheadOpt getNode5()
    {
        return node5;
    }

    public void setNode5(LookAheadOpt node)
    {
        if(node5 != null)
        {
            node5.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node5 = node;
    }

    private TSemicolon node6;

    public TSemicolon getNode6()
    {
        return node6;
    }

    public void setNode6(TSemicolon node)
    {
        if(node6 != null)
        {
            node6.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node6 = node;
    }

    void removeChild(Node child)
    {
        if(node1 == child)
        {
            node1 = null;
        }

        if(node2 == child)
        {
            node2 = null;
        }

        if(node3 == child)
        {
            node3 = null;
        }

        if(node4 == child)
        {
            node4 = null;
        }

        if(node5 == child)
        {
            node5 = null;
        }

        if(node6 == child)
        {
            node6 = null;
        }

    }
}

