dnl Checks for the --with-extra-includes option on ./configure.

AC_DEFUN([XTRA_INC], [
AC_MSG_CHECKING(for extra include locations)
AC_ARG_WITH(extra-includes,
  [  --with-extra-includes=dir Check dir for extra include files],[
  if test x$withval = xyes; then
    AC_MSG_WARN(Usage is: --with-extra-includes=dir)
    else
      if test x$withval = xno; then
        AC_MSG_WARN(Usage is: --with-extra-includes=dir)
        else
	  AC_MSG_RESULT($withval)
          extra_includes="-I$withval"
        fi
    fi]
 ,
    AC_MSG_RESULT(none specified)
)
AC_PATH_XTRA
CPPFLAGS="$extra_includes $CPPFLAGS $X_CFLAGS"
])


dnl Checks for the --with-extra-libraries option on ./configure.

AC_DEFUN([XTRA_LIB], [
AC_MSG_CHECKING(for extra library locations)
AC_ARG_WITH(extra-libraries,
  [  --with-extra-libraries=dir Check dir for extra libraries],[
  if test x$withval = xyes; then
    AC_MSG_WARN(Usage is: --with-extra-libraries=dir)
    else
      if test x$withval = xno; then
        AC_MSG_WARN(Usage is: --with-extra-libraries=dir)
        else
          case "`(uname -sr) 2>/dev/null`" in
          "SunOS 5"*)
             extra_libraries="-R $withval" ;;
          "Linux"*)
             extra_libraries="-Wl,-rpath,$withval" ;;
          esac
          extra_libraries="-L$withval $extra_libraries"
	  AC_MSG_RESULT($withval)
      fi
  fi]
 ,
    AC_MSG_RESULT(none specified)
)
LIBS="$extra_libraries -L/usr/local/lib $X_PRE_LIBS $LIBS $X_LIBS -lX11 $X_EXTRA_LIBS -lm"
])
