// Coordinates: 25.574723, 50.670750
// Map Width: 180km

RMS.LoadLibrary("rmgen");
RMS.LoadLibrary("rmgen2");

InitMap();

log("Initializing tile classes...");
setBiome(3);
initMapSettings();
initTileClasses(["island"]);

log("Initializing environment...");

setSunColor(0.733, 0.746, 0.574);
setSkySet("cloudless");

setWaterTint(0.37, 0.67, 0.73);
setWaterColor(0.24, 0.44, 0.56);
setWaterWaviness(9);
setWaterMurkiness(0.8);
setWaterType("lake");

setTerrainAmbientColor(0.521, 0.475, 0.322);

setSunRotation(-1 * PI);
setSunElevation(PI / 6.25);

setFogFactor(0);
setFogThickness(0);
setFogColor(0.69, 0.616, 0.541);

setPPEffect("hdr");
setPPContrast(0.67);
setPPSaturation(0.42);
setPPBloom(0.23);

log("Initializing biome...");

g_Terrains.mainTerrain = "desert_dirt_rough_2";
g_Terrains.forestFloor1 = "grass_dead";
g_Terrains.forestFloor2 = "desert_dirt_persia_1";
g_Terrains.tier1Terrain = "desert_sand_dunes_stones";
g_Terrains.tier2Terrain = "desert_sand_scrub";
g_Terrains.tier3Terrain = "desert_plants_b";
g_Terrains.tier4Terrain = "medit_dirt_dry";
g_Terrains.roadWild = "desert_city_tile_pers_dirt";
g_Terrains.road = "desert_city_tile_pers";
g_Gaia.mainHuntableAnimal = "gaia/fauna_camel";
g_Gaia.secondaryHuntableAnimal =  "gaia/fauna_gazelle";
g_Gaia.fish = "gaia/fauna_fish";
g_Gaia.tree1 = "gaia/flora_tree_cretan_date_palm_tall";
g_Gaia.tree2 = "gaia/flora_tree_cretan_date_palm_short";
g_Gaia.tree3 = "gaia/flora_tree_cretan_date_palm_patch";
g_Gaia.tree4 = "gaia/flora_tree_cretan_date_palm_tall";
g_Gaia.tree5 = "gaia/flora_tree_cretan_date_palm_short";
g_Gaia.fruitBush = "gaia/flora_bush_grapes";
g_Decoratives.grass = "actor|props/flora/grass_field_parched_short.xml";
g_Decoratives.grassShort = "actor|props/flora/grass_field_parched_short.xml";
g_Decoratives.rockLarge = "actor|geology/stone_savanna_med.xml";
g_Decoratives.rockMedium = "actor|geology/stone_granite_greek_small.xml";
g_Decoratives.bushMedium = "actor|props/flora/bush_desert_dry_a.xml";
g_Decoratives.bushSmall = "actor|props/flora/bush_medit_la_dry";

initBiome();
RMS.SetProgress(5);

log("Resetting terrain...");
resetTerrain(g_Terrains.mainTerrain, g_TileClasses.land, 1);
RMS.SetProgress(10);

log("Copying heightmap...");
var scale = paintHeightmap(getHeightMap(), getTileMap(), getTilePallet(), (tile, x, y) => {
	if (tile == "sand")
		addToClass(x, y, g_TileClasses.island);
});
RMS.SetProgress(20);


log("Paint tile classes...");
paintTileClassBasedOnHeight(-100, -1, 3, g_TileClasses.water);
RMS.SetProgress(40);

log("Placing players...");
//Coordinate system of the heightmap
var singleBases = [
	[30, 220],
	[230, 30],
	[75, 130],
	[120, 35],
	[210, 110],
	[240, 220]
];

if (g_MapInfo.numPlayers > singleBases.length)
	singleBases.push(
		[40, 55],
		[280, 150]
	);

var strongholdBases = [
	[75, 55],
	[250, 55]
];

if (g_MapInfo.teams.length > strongholdBases.length)
	strongholdBases.push(
		[45, 180],
		[260, 195]
	);

randomPlayerPlacementAt(singleBases, strongholdBases, scale, 0.06);
RMS.SetProgress(50);

log("Render mainland...");
addElements([
	{
		"func": addLayeredPatches,
		"avoid": [
			g_TileClasses.dirt, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	},
	{
		"func": addDecoration,
		"avoid": [
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["small"],
		"mixes": ["same"],
		"amounts": ["many"]
	}
]);

addElements(shuffleArray([
	{
		"func": addMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 30,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 30,
			g_TileClasses.metal, 20,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal"]
	}
]));

addElements([
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 35,
			g_TileClasses.metal, 3,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2,
			g_TileClasses.island, 2
		],
		"sizes": ["big"],
		"mixes": ["similar"],
		"amounts": ["few"]
	},
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 18,
			g_TileClasses.metal, 3,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["similar"],
		"amounts": ["many"]
	},
]);

addElements(shuffleArray([
	{
		"func": addBerries,
		"avoid": [
			g_TileClasses.berries, 30,
			g_TileClasses.forest, 5,
			g_TileClasses.metal, 10,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 10,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["few"]
	},
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	},
	{
		"func": addFish,
		"avoid": [
			g_TileClasses.fish, 12,
			g_TileClasses.player, 8
		],
		"stay": [g_TileClasses.water, 4],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 7,
			g_TileClasses.metal, 2,
			g_TileClasses.player, 12,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 5,
			g_TileClasses.island, 2
		],
		"sizes": ["small"],
		"mixes": ["same"],
		"amounts": ["normal"]
	}
]));
RMS.SetProgress(65);

g_Terrains.mainTerrain = "sand";
g_Terrains.forestFloor1 = "desert_wave";
g_Terrains.forestFloor2 = "desert_sahara";
g_Terrains.tier1Terrain = "sand_scrub_25";
g_Terrains.tier2Terrain = "sand_scrub_75";
g_Terrains.tier3Terrain = "sand_scrub_50";
g_Terrains.tier4Terrain = "sand";
initBiome();

log("Render island...");
addElements([
	{
		"func": addLayeredPatches,
		"avoid": [
			g_TileClasses.dirt, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["few"]
	},
	{
		"func": addDecoration,
		"avoid": [
			g_TileClasses.forest, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["tiny"],
		"mixes": ["same"],
		"amounts": ["scarce"]
	}
]);

addElements(shuffleArray([
	{
		"func": addMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 7,
			g_TileClasses.metal, 7,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 7,
			g_TileClasses.metal, 7,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	}
]));

addElements(shuffleArray([
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 10,
			g_TileClasses.metal, 3,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["normal"],
		"mixes": ["similar"],
		"amounts": ["normal"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 7,
			g_TileClasses.metal, 2,
			g_TileClasses.player, 12,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 5
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	}
]));

RMS.SetProgress(80);

log("Adding more decoratives...");
createObjectGroups(
	new SimpleGroup(
		[
			new SimpleObject("actor|props/special/eyecandy/awning_wood_small.xml", 1, 1, 1, 7),
			new SimpleObject("actor|props/special/eyecandy/barrels_buried.xml", 1, 2, 1, 7)
		],
		true,
		g_TileClasses.dirt
	),
	0,
	avoidClasses(
		g_TileClasses.water, 2,
		g_TileClasses.player, 10,
		g_TileClasses.mountain, 2,
		g_TileClasses.forest, 2
	),
	2 * scaleByMapSize(1, 4),
	200
);
RMS.SetProgress(85);

log("Creating food treasures...");
for (let treasure of ["wood", "food_bin"])
{
	createObjectGroups(
		new SimpleGroup(
			[new SimpleObject("gaia/special_treasure_" + treasure, 1, 1, 0, 2)],
			true
		),
		0,
		avoidClasses(
			g_TileClasses.water, 2,
			g_TileClasses.player, 25,
			g_TileClasses.forest, 2
		),
		3 * g_MapInfo.numPlayers,
		200
	);
}
RMS.SetProgress(90);

log("Creating shipwrecks...");
createObjectGroups(
	new SimpleGroup(
		[new SimpleObject("other/special_treasure_shipwreck_sail_boat_cut", 1, 1, 0, 1)],
		true
	),
	0,
	stayClasses(g_TileClasses.water, 2),
	g_MapInfo.numPlayers,
	200
);
RMS.SetProgress(95);

ExportMap();

// MapTiles - Do Not Edit Below This Line
function getHeightMap()
{
	return [17.98,17,16.07,16,16,16,16,16,16,16,16.10,16.25,16.47,16.67,16.76,16.75,16.66,16.46,16.25,16.10,16,15.99,15.99,15.97,15.92,15.85,15.70,15.47,15.23,15.07,14.97,14.87,14.72,14.49,14.24,14.04,13.97,13.95,13.95,13.97,14.02,14.14,14.35,14.37,14.16,14.04,14,14,14,13.99,13.98,13.96,13.95,13.91,13.89,13.86,13.75,13.61,13.40,13.24,13.12,13.09,13.12,13.25,13.45,13.65,13.90,14.13,14.34,14.40,14.29,14.01,13.65,13.23,12.78,12.40,12.15,12.03,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,11.99,11.99,11.99,11.98,11.98,11.96,11.89,11.78,11.63,11.42,11.24,11.10,11.01,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.98,9.96,9.86,9.57,9.26,9.02,9,9,9,9,9,8.99,8.99,8.99,8.98,8.98,8.97,8.97,8.96,8.95,8.91,8.87,8.83,8.75,8.64,8.50,8.34,8.16,8.01,7.87,7.70,7.48,7.22,6.95,6.65,6.41,6.23,6.10,6.02,5.99,5.97,5.95,5.88,5.82,5.67,5.52,5.37,5.23,5.11,5.02,4.99,4.95,4.89,4.83,4.77,4.49,4.23,4.07,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.97,3.95,3.89,3.83,3.71,3.54,3.37,3.23,3.11,3.02,3,2.99,2.99,2.99,2.98,2.98,2.98,2.91,2.87,2.76,2.65,2.59,2.53,2.54,2.61,2.67,2.74,2.75,2.74,2.67,2.60,2.50,2.38,2.28,2.22,2.20,2.25,2.38,2.58,2.79,3,3.21,3.37,3.50,3.62,3.70,3.73,3.71,3.63,3.52,3.37,3.17,2.97,2.75,2.57,2.38,2.25,2.13,2.08,2.02,2,1.99,1.99,1.99,1.99,1.99,1.99,1.99,1.99,2,1.99,1.98,1.95,1.89,1.86,1.84,1.76,1.62,1.40,1.21,1.07,0.95,0.84,0.73,0.57,0.37,0.22,0.11,0.02,0,0,0,0,0.07,0.20,0.36,17.96,17.09,16.11,16.11,16.01,16,16,16,16,16,16.07,16.17,16.35,16.50,16.59,16.58,16.49,16.35,16.17,16.07,16,15.98,15.97,15.92,15.87,15.75,15.58,15.36,15.15,15.02,14.95,14.83,14.62,14.36,14.11,13.92,13.85,13.84,13.85,13.87,13.95,14.03,14.12,14.13,14.11,14.02,14,14,13.99,13.97,13.92,13.88,13.86,13.83,13.77,13.72,13.62,13.49,13.34,13.20,13.10,13.07,13.11,13.23,13.39,13.61,13.83,14.03,14.21,14.25,14.17,13.97,13.63,13.23,12.79,12.42,12.16,12.03,12,12,12,12,12,12,12,12,12,12.01,12.01,12.01,12.01,12.01,12.01,12,12,12,12,12,11.99,11.99,11.99,11.98,11.97,11.92,11.87,11.75,11.58,11.38,11.22,11.09,11.01,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.97,9.95,9.86,9.67,9.40,9.17,9.02,9,9,9,9,9,8.99,8.99,8.99,8.98,8.98,8.97,8.97,8.96,8.92,8.90,8.86,8.78,8.70,8.60,8.45,8.28,8.12,7.97,7.79,7.62,7.38,7.12,6.86,6.59,6.36,6.20,6.09,6.01,5.98,5.96,5.91,5.87,5.76,5.63,5.49,5.33,5.20,5.09,5.01,4.97,4.91,4.85,4.75,4.58,4.36,4.14,4.03,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.97,3.96,3.91,3.86,3.76,3.63,3.49,3.33,3.17,3.09,3.01,3,2.99,2.99,2.99,2.98,2.98,2.97,2.89,2.84,2.72,2.62,2.52,2.50,2.50,2.54,2.61,2.65,2.66,2.65,2.61,2.52,2.42,2.35,2.25,2.17,2.15,2.21,2.33,2.48,2.65,2.86,3.02,3.21,3.36,3.48,3.57,3.60,3.59,3.51,3.39,3.25,3.08,2.87,2.67,2.50,2.35,2.23,2.12,2.07,2.02,2,1.99,1.99,1.98,1.98,1.99,1.99,1.99,1.98,1.99,1.98,1.95,1.87,1.78,1.72,1.66,1.61,1.49,1.32,1.12,0.99,0.87,0.75,0.62,0.47,0.32,0.17,0.09,0.01,0,0,0,0,0.07,0.20,0.36,17.90,17.11,16.87,16.14,16.13,16.03,16.03,16.01,16,16,16.02,16.10,16.20,16.28,16.35,16.35,16.28,16.20,16.10,16.01,15.99,15.96,15.91,15.87,15.75,15.60,15.39,15.23,15.09,14.99,14.88,14.73,14.46,14.14,13.87,13.72,13.63,13.62,13.64,13.70,13.75,13.84,13.89,13.90,13.91,13.92,13.96,13.95,13.92,13.88,13.82,13.75,13.67,13.62,13.58,13.51,13.42,13.33,13.22,13.12,13.07,13.03,13.08,13.16,13.32,13.50,13.70,13.87,14,14.07,14.01,13.86,13.59,13.23,12.82,12.45,12.17,12.07,12.02,12.03,12.04,12.04,12.04,12.04,12.04,12.04,12.07,12.09,12.10,12.11,12.12,12.11,12.10,12.08,12.03,12.01,12,12,11.99,11.99,11.98,11.98,11.96,11.89,11.82,11.66,11.50,11.33,11.16,11.07,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,10.99,10.99,11,11,11,11,10.99,11,11,11,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.98,9.97,9.92,9.84,9.66,9.41,9.22,9.08,9.01,9,9,9,9,9,8.99,8.99,8.98,8.98,8.97,8.97,8.96,8.95,8.91,8.87,8.82,8.73,8.62,8.48,8.34,8.20,8.03,7.87,7.70,7.49,7.24,6.98,6.71,6.47,6.26,6.13,6.04,6,5.97,5.95,5.88,5.82,5.71,5.57,5.40,5.25,5.14,5.07,5,4.95,4.88,4.78,4.64,4.47,4.25,4.07,4,4,4,4,4,4,4,4,4,3.99,3.99,3.97,3.96,3.91,3.87,3.77,3.66,3.52,3.37,3.25,3.12,3.04,3,3,2.99,2.99,2.98,2.98,2.96,2.92,2.85,2.75,2.62,2.52,2.46,2.40,2.40,2.45,2.49,2.51,2.53,2.51,2.48,2.40,2.34,2.25,2.17,2.12,2.11,2.13,2.21,2.32,2.45,2.59,2.74,2.89,3.07,3.21,3.29,3.35,3.34,3.26,3.15,3.02,2.87,2.71,2.53,2.39,2.27,2.16,2.11,2.04,2.01,2,1.99,1.98,1.98,1.98,1.98,1.98,1.99,1.98,1.98,1.96,1.87,1.75,1.62,1.51,1.45,1.37,1.28,1.15,1.01,0.87,0.74,0.62,0.49,0.36,0.24,0.12,0.04,0,0,0,0,0,0.08,0.20,0.36,17.88,17.87,17.85,16.83,16.17,16.21,16.12,16.08,16.03,16.01,16,16.02,16.08,16.13,16.17,16.21,16.15,16.10,16.02,15.99,15.95,15.88,15.83,15.73,15.60,15.42,15.27,15.14,15.03,14.96,14.84,14.61,14.28,13.95,13.64,13.49,13.41,13.39,13.41,13.47,13.51,13.58,13.62,13.63,13.65,13.73,13.76,13.79,13.77,13.72,13.63,13.53,13.47,13.40,13.36,13.32,13.25,13.17,13.12,13.07,13.02,13.01,13.04,13.12,13.23,13.37,13.52,13.66,13.77,13.84,13.82,13.71,13.50,13.17,12.79,12.45,12.20,12.12,12.11,12.12,12.14,12.15,12.16,12.15,12.15,12.16,12.20,12.23,12.25,12.28,12.28,12.27,12.25,12.20,12.12,12.08,12.02,12,12,11.99,11.98,11.97,11.95,11.87,11.76,11.62,11.45,11.26,11.12,11.03,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,10.99,10.98,10.96,10.92,10.95,10.96,10.96,10.97,10.86,10.87,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.98,9.96,9.90,9.83,9.65,9.42,9.24,9.10,9.03,9,9,9,9,9,9,8.99,8.99,8.98,8.98,8.97,8.97,8.96,8.92,8.88,8.84,8.75,8.64,8.51,8.37,8.23,8.07,7.91,7.75,7.54,7.32,7.04,6.78,6.53,6.33,6.16,6.08,6.01,5.99,5.96,5.91,5.86,5.75,5.62,5.48,5.33,5.20,5.10,5.01,4.97,4.91,4.85,4.74,4.58,4.37,4.17,4.04,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.91,3.87,3.78,3.66,3.53,3.39,3.26,3.14,3.08,3.01,3,2.99,2.99,2.98,2.98,2.96,2.92,2.87,2.75,2.63,2.51,2.41,2.35,2.32,2.29,2.32,2.35,2.37,2.37,2.36,2.33,2.26,2.22,2.15,2.11,2.07,2.04,2.04,2.09,2.12,2.20,2.27,2.38,2.52,2.70,2.85,2.96,3,3,2.95,2.85,2.73,2.61,2.48,2.36,2.25,2.16,2.11,2.07,2.02,2,1.99,1.98,1.97,1.97,1.97,1.97,1.98,1.97,1.96,1.96,1.87,1.75,1.58,1.41,1.29,1.24,1.17,1.12,1,0.87,0.73,0.60,0.47,0.36,0.25,0.14,0.08,0.02,0,0,0,0,0,0.08,0.20,0.36,17.87,17.85,17.16,16.98,16.71,16.33,16.21,16.13,16.10,16.03,16,16,16.01,16.08,16.12,16.14,16.12,16.04,15.99,15.92,15.87,15.76,15.65,15.53,15.41,15.32,15.23,15.12,15.03,14.92,14.76,14.51,14.15,13.79,13.51,13.37,13.29,13.27,13.27,13.28,13.33,13.36,13.37,13.37,13.38,13.46,13.52,13.57,13.54,13.50,13.41,13.34,13.25,13.21,13.16,13.14,13.12,13.09,13.07,13.03,13.01,13.01,13.02,13.08,13.14,13.25,13.37,13.48,13.54,13.60,13.59,13.51,13.36,13.11,12.77,12.47,12.32,12.23,12.24,12.26,12.29,12.33,12.35,12.35,12.36,12.37,12.39,12.45,12.49,12.50,12.51,12.50,12.42,12.35,12.24,12.14,12.09,12.02,12,11.99,11.98,11.97,11.92,11.87,11.75,11.59,11.39,11.24,11.11,11.02,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,10.99,11,10.99,10.98,10.96,10.88,10.79,10.73,10.67,10.65,10.62,10.62,10.26,10.12,10,10,10,10,10,10,9.99,9.99,9.98,9.98,9.96,9.89,9.82,9.64,9.45,9.25,9.11,9.03,9,9,9,9,9,8.99,8.99,8.99,8.99,8.98,8.98,8.97,8.96,8.95,8.90,8.87,8.78,8.67,8.57,8.40,8.25,8.10,7.95,7.76,7.60,7.37,7.13,6.87,6.61,6.38,6.22,6.10,6.02,6,5.97,5.95,5.88,5.82,5.70,5.53,5.38,5.24,5.12,5.03,4.99,4.95,4.88,4.79,4.67,4.51,4.33,4.15,4.04,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.91,3.87,3.78,3.66,3.53,3.39,3.26,3.15,3.09,3.02,3,2.99,2.99,2.98,2.98,2.96,2.91,2.87,2.78,2.64,2.51,2.40,2.32,2.25,2.21,2.20,2.20,2.22,2.23,2.23,2.22,2.20,2.14,2.12,2.08,2.02,2,1.99,1.97,1.97,1.96,1.96,1.98,2.03,2.14,2.28,2.45,2.54,2.61,2.61,2.57,2.49,2.39,2.29,2.22,2.13,2.09,2.03,2,1.99,1.98,1.97,1.96,1.96,1.96,1.96,1.95,1.92,1.95,1.95,1.89,1.87,1.75,1.58,1.39,1.24,1.12,1.09,1.03,0.97,0.85,0.72,0.58,0.45,0.33,0.23,0.14,0.09,0.03,0,0,0,0,0,0,0.08,0.20,0.35,17.85,17.16,17.12,16.95,16.65,16.40,16.25,16.17,16.12,16.04,16,16,16,16.04,16.12,16.14,16.11,16.03,15.95,15.86,15.74,15.60,15.46,15.34,15.25,15.23,15.20,15.12,15.02,14.90,14.74,14.48,14.14,13.84,13.61,13.49,13.41,13.37,13.33,13.28,13.27,13.27,13.26,13.24,13.22,13.28,13.33,13.34,13.33,13.27,13.23,13.15,13.11,13.08,13.07,13.04,13.04,13.03,13.03,13.03,13.03,13.03,13.04,13.08,13.11,13.16,13.24,13.29,13.35,13.37,13.37,13.32,13.21,13.01,12.76,12.53,12.45,12.38,12.41,12.47,12.50,12.53,12.57,12.58,12.60,12.62,12.65,12.70,12.73,12.74,12.73,12.70,12.62,12.50,12.37,12.25,12.13,12.08,12.01,12,11.98,11.97,11.91,11.86,11.74,11.58,11.38,11.23,11.10,11.02,11,11,11,11,11,11,10.99,10.99,10.99,11,11,10.99,10.99,10.99,10.99,10.99,10.99,10.98,10.98,10.96,10.87,10.75,10.61,10.49,10.40,10.36,10.33,10.25,10.15,10.07,10,10,10,10,10,9.99,9.99,9.98,9.98,9.96,9.90,9.79,9.64,9.46,9.26,9.12,9.04,9,9,9,9,9,8.99,8.99,8.99,8.99,8.99,8.98,8.98,8.97,8.96,8.92,8.89,8.84,8.75,8.62,8.48,8.32,8.14,7.98,7.82,7.62,7.42,7.22,6.97,6.71,6.47,6.26,6.12,6.03,6,5.98,5.96,5.90,5.86,5.75,5.62,5.47,5.29,5.16,5.08,5,4.96,4.90,4.85,4.75,4.62,4.47,4.28,4.14,4.04,4,4,4,4,4,4,4,3.99,3.98,3.96,3.91,3.87,3.78,3.66,3.53,3.39,3.26,3.15,3.09,3.02,3,2.99,2.99,2.98,2.97,2.96,2.91,2.87,2.78,2.67,2.52,2.39,2.29,2.22,2.14,2.12,2.10,2.10,2.11,2.11,2.11,2.10,2.09,2.04,2.02,2,1.97,1.95,1.91,1.88,1.85,1.79,1.75,1.73,1.74,1.79,1.91,2.04,2.14,2.21,2.21,2.16,2.12,2.07,2,1.96,1.90,1.88,1.87,1.87,1.87,1.88,1.88,1.89,1.90,1.90,1.90,1.89,1.88,1.88,1.87,1.83,1.75,1.58,1.38,1.22,1.11,1.03,0.99,0.91,0.83,0.70,0.54,0.41,0.28,0.21,0.12,0.09,0.03,0.01,0,0,0,0,0,0.01,0.08,0.20,0.35,17.83,17.20,17.03,16.89,16.63,16.39,16.24,16.14,16.10,16.03,16,16,16,16.03,16.09,16.11,16.07,15.99,15.87,15.74,15.58,15.40,15.25,15.15,15.12,15.12,15.12,15.09,15,14.89,14.74,14.51,14.25,14.01,13.86,13.76,13.71,13.62,13.53,13.48,13.42,13.39,13.36,13.28,13.25,13.22,13.20,13.16,13.14,13.12,13.09,13.04,13.02,13.01,13.01,13.01,13.02,13.03,13.04,13.07,13.09,13.10,13.11,13.12,13.13,13.15,13.17,13.21,13.21,13.21,13.20,13.14,13.08,12.97,12.82,12.70,12.62,12.62,12.63,12.67,12.73,12.75,12.77,12.79,12.84,12.87,12.90,12.92,12.91,12.90,12.87,12.83,12.75,12.62,12.49,12.34,12.22,12.11,12.03,12,11.98,11.96,11.91,11.85,11.73,11.57,11.37,11.23,11.11,11.02,11,11,11,11,11,11,10.99,10.99,10.99,10.99,10.99,10.99,10.99,10.99,10.98,10.98,10.98,10.97,10.96,10.86,10.73,10.58,10.41,10.27,10.20,10.13,10.12,10.09,10.04,10.01,10,10,10,10,10,9.99,9.99,9.98,9.97,9.91,9.85,9.71,9.50,9.32,9.14,9.07,9.01,9,9,9,9,9,8.99,8.99,8.99,8.99,8.99,8.98,8.98,8.97,8.96,8.92,8.87,8.79,8.70,8.57,8.39,8.22,8.03,7.87,7.67,7.50,7.28,7.08,6.83,6.59,6.37,6.20,6.09,6.01,5.98,5.96,5.92,5.87,5.79,5.67,5.53,5.37,5.24,5.12,5.02,4.98,4.91,4.87,4.78,4.70,4.57,4.40,4.25,4.12,4.03,4,3.99,3.99,3.99,3.99,3.99,3.99,3.98,3.97,3.92,3.87,3.78,3.66,3.53,3.39,3.26,3.15,3.09,3.02,3,2.99,2.99,2.98,2.97,2.96,2.91,2.87,2.78,2.67,2.53,2.39,2.28,2.20,2.12,2.07,2.02,2.01,2.01,2.01,2.02,2.02,2.01,2,1.99,1.96,1.92,1.89,1.87,1.84,1.78,1.73,1.64,1.58,1.50,1.50,1.52,1.62,1.72,1.78,1.83,1.84,1.83,1.78,1.75,1.73,1.70,1.67,1.67,1.70,1.72,1.74,1.75,1.77,1.82,1.84,1.85,1.85,1.84,1.79,1.78,1.75,1.66,1.57,1.37,1.22,1.11,1.02,0.98,0.89,0.79,0.67,0.53,0.39,0.27,0.16,0.11,0.07,0.03,0.01,0,0,0,0,0,0,0.01,0.08,0.20,0.34,17.16,17.12,16.99,16.84,16.60,16.36,16.17,16.09,16.03,16.01,16,16,16,16,16.02,16.02,15.98,15.87,15.74,15.58,15.39,15.24,15.12,15.04,15.03,15.04,15.07,15.03,14.99,14.89,14.77,14.61,14.41,14.26,14.16,14.11,14.02,13.92,13.83,13.73,13.65,13.61,13.53,13.45,13.35,13.25,13.15,13.10,13.04,13.02,13.01,13,13,13,13,13.01,13.02,13.04,13.08,13.11,13.12,13.15,13.17,13.22,13.23,13.23,13.22,13.20,13.15,13.12,13.09,13.04,13,12.96,12.89,12.85,12.82,12.83,12.85,12.88,12.90,12.92,12.96,12.99,13.02,13.09,13.12,13.12,13.09,13.02,12.97,12.89,12.82,12.71,12.57,12.40,12.26,12.14,12.07,12,11.98,11.96,11.90,11.84,11.72,11.54,11.37,11.23,11.11,11.02,11,11,11,11,11,11,10.99,10.99,10.98,10.99,10.99,10.99,10.99,10.98,10.97,10.96,10.95,10.90,10.82,10.71,10.54,10.40,10.26,10.15,10.10,10.04,10.03,10.02,10,10,10,10,10,10,9.99,9.99,9.99,9.98,9.96,9.89,9.78,9.62,9.40,9.23,9.11,9.02,9,9,9,9,8.99,8.99,8.99,8.99,8.98,8.98,8.98,8.98,8.98,8.97,8.96,8.91,8.87,8.76,8.64,8.50,8.32,8.12,7.92,7.75,7.57,7.37,7.16,6.96,6.73,6.50,6.29,6.15,6.07,6,5.97,5.95,5.89,5.84,5.74,5.61,5.46,5.29,5.16,5.08,5,4.95,4.88,4.83,4.73,4.62,4.48,4.34,4.21,4.10,4.02,3.99,3.99,3.99,3.99,3.99,3.99,3.98,3.97,3.92,3.87,3.78,3.66,3.53,3.39,3.26,3.15,3.09,3.02,3,2.99,2.98,2.98,2.97,2.96,2.91,2.87,2.78,2.67,2.53,2.39,2.27,2.17,2.10,2.03,1.99,1.97,1.96,1.96,1.97,1.98,1.98,1.97,1.95,1.91,1.88,1.86,1.82,1.77,1.73,1.66,1.60,1.50,1.40,1.35,1.33,1.35,1.39,1.46,1.50,1.51,1.52,1.51,1.50,1.50,1.48,1.47,1.47,1.48,1.50,1.52,1.57,1.61,1.63,1.67,1.73,1.74,1.75,1.72,1.66,1.63,1.59,1.48,1.36,1.21,1.10,1.02,0.98,0.89,0.78,0.66,0.53,0.39,0.26,0.16,0.10,0.03,0.01,0,0,0,0,0,0,0,0,0.01,0.08,0.17,0.33,17.01,16.99,16.89,16.73,16.50,16.28,16.12,16.02,16,16,16,16,16,15.99,15.98,15.95,15.87,15.74,15.58,15.39,15.24,15.12,15.03,15,15,15,15,15,14.97,14.90,14.82,14.70,14.57,14.46,14.38,14.34,14.25,14.13,14.02,13.95,13.87,13.83,13.75,13.61,13.47,13.34,13.21,13.12,13.04,13.01,13.01,13.01,13.01,13.01,13.02,13.03,13.04,13.08,13.10,13.13,13.17,13.24,13.28,13.35,13.37,13.37,13.34,13.27,13.21,13.12,13.07,13.01,13,12.98,12.97,12.97,12.97,12.99,13,13.01,13.03,13.04,13.08,13.12,13.16,13.23,13.25,13.24,13.17,13.10,13,12.92,12.85,12.75,12.62,12.48,12.33,12.17,12.09,12.01,11.99,11.95,11.89,11.83,11.71,11.54,11.37,11.23,11.12,11.03,11,11,11,11,11,10.99,10.99,10.99,10.98,10.98,10.99,10.98,10.98,10.97,10.95,10.90,10.85,10.76,10.66,10.53,10.39,10.25,10.14,10.08,10.02,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.98,9.97,9.95,9.87,9.75,9.59,9.38,9.22,9.10,9.02,9,9,9,8.99,8.99,8.99,8.99,8.99,8.98,8.98,8.98,8.98,8.97,8.97,8.95,8.89,8.84,8.73,8.60,8.41,8.23,8.02,7.84,7.63,7.46,7.26,7.08,6.87,6.65,6.45,6.26,6.12,6.03,5.99,5.96,5.91,5.87,5.77,5.65,5.51,5.37,5.23,5.12,5.02,4.97,4.90,4.85,4.75,4.64,4.51,4.38,4.25,4.14,4.08,4.01,3.99,3.98,3.98,3.98,3.98,3.98,3.97,3.95,3.87,3.77,3.66,3.53,3.39,3.26,3.15,3.09,3.02,3,2.99,2.98,2.98,2.96,2.95,2.90,2.86,2.77,2.66,2.53,2.39,2.25,2.16,2.09,2,1.96,1.91,1.89,1.89,1.90,1.91,1.92,1.92,1.91,1.89,1.87,1.83,1.77,1.73,1.65,1.60,1.52,1.45,1.36,1.27,1.23,1.21,1.23,1.25,1.27,1.28,1.28,1.27,1.27,1.27,1.26,1.25,1.25,1.25,1.28,1.33,1.36,1.39,1.42,1.49,1.52,1.58,1.61,1.61,1.58,1.51,1.46,1.37,1.27,1.15,1.08,1.02,0.98,0.89,0.79,0.67,0.53,0.39,0.27,0.16,0.09,0.03,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.17,0.33,16.99,16.95,16.77,16.60,16.37,16.20,16.08,16,16,16,16,16,15.99,15.98,15.92,15.86,15.74,15.58,15.39,15.24,15.12,15.03,15,15,14.99,14.99,14.99,14.98,14.96,14.89,14.83,14.73,14.61,14.50,14.45,14.37,14.29,14.21,14.11,14.03,13.99,13.95,13.87,13.75,13.61,13.47,13.32,13.20,13.12,13.09,13.08,13.08,13.08,13.08,13.08,13.08,13.09,13.10,13.12,13.15,13.22,13.29,13.39,13.49,13.53,13.53,13.50,13.40,13.29,13.17,13.09,13.01,13,13,13,13.01,13.04,13.07,13.08,13.09,13.10,13.11,13.12,13.16,13.24,13.28,13.32,13.28,13.22,13.12,13.02,12.96,12.87,12.77,12.64,12.50,12.35,12.21,12.10,12.02,11.99,11.95,11.89,11.82,11.70,11.53,11.37,11.24,11.12,11.04,11,11,11,11,10.99,10.99,10.99,10.99,10.98,10.98,10.98,10.98,10.97,10.91,10.87,10.82,10.74,10.63,10.52,10.39,10.25,10.14,10.08,10.01,10,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.98,9.97,9.92,9.86,9.74,9.58,9.38,9.22,9.10,9.02,9,9,9,8.99,8.99,8.99,8.98,8.98,8.98,8.98,8.97,8.97,8.97,8.95,8.91,8.87,8.78,8.66,8.51,8.34,8.12,7.91,7.73,7.52,7.35,7.16,6.99,6.79,6.61,6.41,6.25,6.12,6.03,5.99,5.95,5.89,5.82,5.72,5.58,5.41,5.27,5.15,5.07,5,4.95,4.87,4.78,4.67,4.57,4.42,4.29,4.20,4.11,4.03,4,3.98,3.97,3.97,3.97,3.97,3.95,3.91,3.88,3.78,3.66,3.53,3.39,3.26,3.15,3.09,3.02,3,2.98,2.97,2.96,2.95,2.91,2.88,2.83,2.75,2.64,2.52,2.38,2.25,2.14,2.08,2,1.91,1.87,1.84,1.83,1.83,1.85,1.87,1.88,1.88,1.87,1.85,1.79,1.75,1.67,1.61,1.53,1.47,1.37,1.29,1.23,1.16,1.13,1.12,1.14,1.15,1.15,1.13,1.12,1.10,1.09,1.08,1.08,1.08,1.08,1.10,1.12,1.16,1.21,1.24,1.27,1.33,1.37,1.41,1.45,1.42,1.39,1.34,1.26,1.16,1.11,1.03,1,0.97,0.91,0.82,0.67,0.53,0.40,0.27,0.17,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.17,0.33,16.99,16.87,16.70,16.47,16.25,16.12,16.02,16,16,16,16,16,15.99,15.97,15.89,15.76,15.61,15.40,15.24,15.12,15.03,15,15,14.99,14.99,14.99,14.98,14.96,14.91,14.87,14.77,14.66,14.53,14.42,14.36,14.28,14.23,14.15,14.10,14.03,14.01,14,13.92,13.86,13.74,13.61,13.47,13.34,13.25,13.21,13.20,13.17,13.16,13.14,13.13,13.12,13.12,13.12,13.13,13.16,13.25,13.36,13.49,13.61,13.67,13.70,13.64,13.54,13.39,13.25,13.12,13.03,13,13,13.01,13.03,13.07,13.08,13.09,13.09,13.09,13.11,13.12,13.17,13.24,13.27,13.29,13.27,13.21,13.12,13.02,12.96,12.88,12.78,12.66,12.52,12.37,12.22,12.11,12.02,11.99,11.95,11.88,11.79,11.67,11.53,11.37,11.24,11.12,11.04,11,11,11,11,10.99,10.99,10.99,10.98,10.98,10.97,10.97,10.97,10.91,10.86,10.78,10.71,10.62,10.50,10.38,10.26,10.15,10.08,10.01,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.98,9.97,9.91,9.86,9.73,9.57,9.38,9.23,9.11,9.02,9,9,9,8.99,8.99,8.98,8.98,8.98,8.98,8.97,8.97,8.96,8.95,8.91,8.87,8.82,8.73,8.59,8.41,8.23,8.01,7.79,7.61,7.41,7.25,7.09,6.91,6.75,6.58,6.39,6.24,6.12,6.02,5.98,5.92,5.87,5.77,5.64,5.50,5.35,5.21,5.10,5.02,4.97,4.89,4.84,4.74,4.62,4.49,4.36,4.24,4.13,4.07,4,3.98,3.96,3.95,3.92,3.92,3.91,3.88,3.86,3.77,3.65,3.53,3.39,3.26,3.15,3.09,3.02,3,2.98,2.96,2.92,2.90,2.88,2.85,2.78,2.71,2.61,2.49,2.37,2.25,2.13,2.07,2,1.90,1.84,1.77,1.75,1.74,1.75,1.77,1.82,1.84,1.85,1.83,1.77,1.73,1.64,1.58,1.50,1.40,1.34,1.25,1.17,1.12,1.09,1.08,1.08,1.09,1.10,1.07,1.01,0.98,0.92,0.90,0.89,0.89,0.91,0.95,0.98,1.01,1.04,1.09,1.12,1.14,1.17,1.23,1.25,1.26,1.25,1.22,1.14,1.09,1,0.99,0.98,0.97,0.92,0.84,0.67,0.53,0.40,0.28,0.20,0.12,0.07,0.02,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.20,0.33,16.98,16.86,16.63,16.38,16.17,16.07,16,16,16,16,16,15.99,15.99,15.95,15.85,15.70,15.49,15.27,15.13,15.04,15,15,14.99,14.99,14.98,14.97,14.95,14.90,14.86,14.77,14.67,14.54,14.40,14.29,14.22,14.15,14.12,14.08,14.03,14.01,14.01,14.01,13.99,13.92,13.85,13.75,13.62,13.51,13.42,13.38,13.37,13.35,13.32,13.26,13.23,13.17,13.14,13.13,13.14,13.17,13.25,13.37,13.52,13.65,13.75,13.78,13.75,13.64,13.49,13.32,13.15,13.04,13,13,13,13.02,13.03,13.04,13.04,13.04,13.04,13.08,13.11,13.14,13.21,13.24,13.25,13.23,13.15,13.10,13.01,12.96,12.88,12.79,12.67,12.53,12.37,12.23,12.11,12.02,11.99,11.95,11.87,11.79,11.67,11.52,11.37,11.24,11.12,11.04,11,11,11,11,10.99,10.99,10.98,10.98,10.98,10.97,10.95,10.91,10.87,10.78,10.71,10.60,10.49,10.37,10.26,10.15,10.09,10.02,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.98,9.96,9.91,9.85,9.73,9.54,9.38,9.23,9.11,9.03,9,9,9,8.99,8.99,8.98,8.98,8.97,8.97,8.96,8.95,8.92,8.90,8.87,8.83,8.75,8.62,8.49,8.29,8.10,7.88,7.67,7.49,7.32,7.15,7.01,6.87,6.72,6.54,6.38,6.24,6.12,6.02,5.98,5.91,5.85,5.75,5.61,5.45,5.27,5.14,5.04,5,4.95,4.87,4.77,4.66,4.54,4.41,4.28,4.17,4.10,4.02,3.98,3.95,3.91,3.88,3.87,3.86,3.83,3.78,3.74,3.62,3.51,3.39,3.27,3.15,3.09,3.02,3,2.97,2.92,2.89,2.86,2.83,2.77,2.73,2.64,2.54,2.45,2.33,2.23,2.12,2.04,1.99,1.92,1.83,1.74,1.66,1.62,1.62,1.64,1.70,1.74,1.76,1.77,1.75,1.71,1.62,1.54,1.47,1.38,1.32,1.24,1.16,1.11,1.04,1.01,1,1.01,1.01,1,0.97,0.89,0.84,0.77,0.74,0.74,0.75,0.78,0.84,0.88,0.92,0.98,1,1.01,1.03,1.08,1.10,1.12,1.12,1.09,1.03,0.97,0.89,0.86,0.86,0.90,0.90,0.86,0.71,0.54,0.40,0.28,0.21,0.13,0.10,0.07,0.02,0,0,0,0,0,0,0,0,0,0,0,0.01,0.09,0.20,0.34,16.98,16.85,16.62,16.37,16.14,16.03,16,16,16,16,15.99,15.99,15.98,15.91,15.82,15.62,15.40,15.22,15.09,15.01,15,14.99,14.99,14.98,14.96,14.91,14.87,14.82,14.75,14.65,14.52,14.39,14.26,14.16,14.10,14.07,14.03,14.01,14,14,14,14.01,14,13.99,13.95,13.87,13.78,13.71,13.63,13.60,13.57,13.52,13.48,13.41,13.34,13.25,13.21,13.16,13.15,13.17,13.25,13.37,13.51,13.66,13.77,13.84,13.79,13.71,13.52,13.35,13.16,13.07,13,13,13,13,13,13.01,13.01,13.01,13.01,13.03,13.07,13.11,13.13,13.16,13.16,13.14,13.11,13.04,13,12.96,12.88,12.79,12.70,12.53,12.37,12.23,12.11,12.02,11.98,11.92,11.87,11.77,11.65,11.51,11.37,11.25,11.12,11.07,11.01,11,11,10.99,10.99,10.98,10.98,10.98,10.97,10.95,10.91,10.87,10.79,10.72,10.60,10.49,10.37,10.25,10.16,10.10,10.03,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.97,9.96,9.90,9.84,9.72,9.54,9.38,9.23,9.12,9.03,9,9,8.99,8.99,8.99,8.98,8.98,8.97,8.96,8.95,8.91,8.89,8.87,8.83,8.75,8.65,8.52,8.36,8.16,7.96,7.75,7.54,7.37,7.23,7.09,6.97,6.84,6.70,6.53,6.37,6.24,6.12,6.02,5.97,5.90,5.84,5.72,5.57,5.39,5.25,5.12,5.03,4.97,4.90,4.84,4.74,4.62,4.50,4.36,4.24,4.12,4.03,3.99,3.95,3.89,3.87,3.83,3.76,3.73,3.66,3.62,3.57,3.48,3.37,3.25,3.15,3.09,3.01,2.98,2.96,2.91,2.87,2.82,2.75,2.70,2.62,2.57,2.49,2.38,2.27,2.17,2.10,2.02,1.97,1.90,1.85,1.72,1.62,1.53,1.50,1.50,1.53,1.60,1.64,1.67,1.67,1.65,1.60,1.51,1.45,1.37,1.29,1.24,1.16,1.12,1.07,1,0.98,0.96,0.95,0.91,0.88,0.83,0.75,0.66,0.61,0.59,0.59,0.62,0.70,0.75,0.83,0.87,0.90,0.92,0.95,0.97,0.98,0.99,1,0.98,0.92,0.87,0.78,0.72,0.67,0.70,0.76,0.78,0.72,0.54,0.40,0.28,0.20,0.13,0.12,0.10,0.08,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0.03,0.11,0.23,0.37,16.98,16.84,16.61,16.36,16.14,16.02,16,16,16,16,15.99,15.99,15.97,15.90,15.77,15.60,15.37,15.20,15.08,15,14.99,14.99,14.98,14.96,14.90,14.85,14.76,14.67,14.60,14.50,14.37,14.25,14.15,14.09,14.02,14,14,14,14,14,14,14.01,14.02,14.02,14,13.98,13.92,13.87,13.84,13.77,13.75,13.71,13.63,13.57,13.46,13.36,13.26,13.22,13.20,13.21,13.25,13.35,13.48,13.62,13.74,13.79,13.79,13.71,13.54,13.36,13.17,13.08,13,13,13,13,13,13,13,13,13,13,13.02,13.07,13.09,13.11,13.11,13.09,13.07,13.02,13,12.96,12.89,12.79,12.70,12.53,12.37,12.24,12.12,12.03,11.98,11.92,11.87,11.77,11.65,11.51,11.37,11.25,11.12,11.07,11.01,11,11,10.99,10.99,10.98,10.98,10.97,10.95,10.92,10.88,10.83,10.74,10.62,10.50,10.37,10.26,10.17,10.11,10.04,10.01,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.97,9.95,9.89,9.83,9.71,9.54,9.37,9.24,9.12,9.04,9,9,8.99,8.99,8.99,8.98,8.97,8.97,8.95,8.91,8.89,8.87,8.82,8.75,8.65,8.54,8.39,8.23,8.02,7.82,7.62,7.42,7.27,7.13,7.02,6.91,6.79,6.66,6.52,6.37,6.24,6.11,6.01,5.96,5.89,5.82,5.70,5.53,5.37,5.24,5.12,5.02,4.96,4.87,4.79,4.70,4.58,4.45,4.29,4.17,4.08,4,3.92,3.88,3.84,3.77,3.72,3.64,3.58,3.50,3.45,3.37,3.32,3.23,3.13,3.07,3,2.95,2.90,2.88,2.85,2.77,2.70,2.61,2.51,2.46,2.38,2.32,2.23,2.13,2.04,1.99,1.91,1.87,1.78,1.72,1.59,1.49,1.40,1.37,1.38,1.42,1.49,1.53,1.58,1.59,1.54,1.49,1.40,1.35,1.27,1.24,1.20,1.13,1.09,1.02,0.98,0.92,0.88,0.86,0.79,0.74,0.65,0.58,0.50,0.46,0.42,0.46,0.51,0.61,0.71,0.76,0.83,0.86,0.87,0.87,0.87,0.88,0.88,0.87,0.85,0.78,0.71,0.62,0.51,0.47,0.48,0.57,0.60,0.49,0.38,0.26,0.17,0.12,0.10,0.10,0.10,0.08,0.04,0.01,0,0,0,0,0,0,0,0,0.01,0.03,0.09,0.16,0.28,0.41,16.95,16.82,16.59,16.35,16.14,16.03,16,16,16,16,15.99,15.98,15.96,15.88,15.76,15.59,15.37,15.20,15.08,15,14.99,14.98,14.97,14.92,14.87,14.76,14.64,14.53,14.42,14.34,14.24,14.14,14.08,14.02,14,14,14,14,14,14,14,14.02,14.03,14.04,14.07,14.07,14.04,14.01,13.99,13.95,13.88,13.84,13.76,13.67,13.58,13.47,13.36,13.28,13.25,13.24,13.25,13.33,13.41,13.53,13.65,13.74,13.75,13.67,13.52,13.35,13.17,13.08,13,13,13,13,13,13,13,13,13,13,13,13.01,13.03,13.03,13.03,13.02,13.01,13,12.97,12.92,12.87,12.77,12.65,12.51,12.37,12.24,12.12,12.03,11.98,11.92,11.87,11.77,11.65,11.51,11.37,11.25,11.13,11.07,11.01,11,11,10.99,10.99,10.98,10.97,10.96,10.92,10.88,10.84,10.76,10.66,10.53,10.40,10.28,10.17,10.11,10.04,10.01,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.97,9.95,9.89,9.83,9.71,9.53,9.37,9.24,9.12,9.04,9.01,9,8.99,8.98,8.98,8.98,8.97,8.96,8.92,8.89,8.86,8.79,8.74,8.65,8.54,8.41,8.26,8.09,7.88,7.67,7.50,7.33,7.20,7.08,6.98,6.87,6.77,6.65,6.50,6.37,6.23,6.11,6.01,5.96,5.88,5.79,5.67,5.51,5.37,5.23,5.11,5,4.92,4.86,4.76,4.64,4.51,4.37,4.25,4.12,4.02,3.95,3.87,3.82,3.75,3.66,3.59,3.50,3.40,3.35,3.27,3.23,3.16,3.11,3.03,2.98,2.90,2.86,2.82,2.76,2.73,2.63,2.53,2.42,2.35,2.26,2.22,2.14,2.09,2.01,1.95,1.87,1.79,1.73,1.64,1.54,1.42,1.35,1.28,1.25,1.27,1.33,1.37,1.42,1.47,1.47,1.42,1.37,1.29,1.25,1.21,1.17,1.14,1.12,1.08,1,0.95,0.87,0.82,0.74,0.65,0.58,0.48,0.39,0.34,0.29,0.29,0.36,0.42,0.52,0.62,0.71,0.75,0.76,0.77,0.77,0.77,0.77,0.77,0.75,0.72,0.63,0.54,0.45,0.34,0.23,0.25,0.33,0.36,0.32,0.25,0.16,0.11,0.08,0.08,0.08,0.08,0.07,0.03,0.01,0,0,0,0,0,0,0,0.01,0.04,0.10,0.16,0.26,0.38,0.51,16.90,16.73,16.51,16.33,16.16,16.08,16.01,16,16,15.99,15.99,15.98,15.96,15.88,15.75,15.58,15.37,15.20,15.08,15.01,14.99,14.98,14.96,14.89,14.82,14.67,14.53,14.40,14.29,14.21,14.12,14.08,14.02,14,14,14,14,14,14,14,14.01,14.03,14.04,14.08,14.09,14.11,14.12,14.12,14.09,14.03,13.99,13.91,13.87,13.77,13.66,13.58,13.48,13.39,13.35,13.32,13.29,13.33,13.37,13.47,13.57,13.63,13.66,13.62,13.49,13.33,13.16,13.07,13,13,13,13,13,13,13,13,13,12.99,12.99,13,13,13,13,13,13,12.98,12.96,12.91,12.86,12.76,12.64,12.51,12.37,12.25,12.12,12.03,11.98,11.91,11.86,11.77,11.65,11.52,11.37,11.25,11.13,11.07,11.01,11,11,10.99,10.99,10.98,10.96,10.95,10.90,10.86,10.78,10.71,10.60,10.47,10.34,10.22,10.12,10.07,10.02,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.97,9.95,9.89,9.82,9.70,9.53,9.37,9.24,9.12,9.04,9.01,9,8.99,8.98,8.98,8.97,8.96,8.95,8.90,8.87,8.79,8.74,8.64,8.54,8.42,8.28,8.12,7.96,7.75,7.58,7.38,7.25,7.12,7.01,6.92,6.85,6.75,6.62,6.49,6.35,6.21,6.10,6,5.95,5.87,5.77,5.64,5.49,5.35,5.21,5.09,5,4.91,4.84,4.73,4.61,4.47,4.33,4.20,4.08,3.97,3.87,3.79,3.72,3.62,3.53,3.45,3.35,3.25,3.20,3.14,3.11,3.04,3,2.95,2.87,2.82,2.74,2.66,2.62,2.54,2.48,2.37,2.27,2.20,2.12,2.08,2.01,1.96,1.88,1.82,1.74,1.64,1.57,1.47,1.37,1.27,1.22,1.16,1.15,1.17,1.23,1.27,1.33,1.35,1.35,1.32,1.25,1.21,1.15,1.13,1.12,1.12,1.09,1.03,0.97,0.87,0.78,0.70,0.60,0.50,0.39,0.32,0.25,0.20,0.17,0.21,0.26,0.35,0.45,0.52,0.60,0.63,0.65,0.65,0.65,0.65,0.65,0.64,0.62,0.58,0.50,0.39,0.28,0.16,0.09,0.09,0.13,0.15,0.16,0.13,0.11,0.07,0.03,0.03,0.03,0.03,0.03,0.01,0,0,0,0,0,0,0.01,0.03,0.07,0.12,0.20,0.28,0.40,0.52,0.63,16.78,16.60,16.41,16.27,16.17,16.10,16.03,16,16,15.99,15.99,15.98,15.95,15.87,15.75,15.58,15.37,15.20,15.09,15.01,14.99,14.97,14.95,14.87,14.76,14.62,14.48,14.33,14.22,14.12,14.07,14.02,14,14,14,14,14,14,14,14,14.02,14.03,14.07,14.08,14.10,14.12,14.14,14.14,14.12,14.09,14.02,13.98,13.91,13.85,13.75,13.66,13.60,13.52,13.48,13.42,13.38,13.37,13.37,13.39,13.46,13.51,13.54,13.51,13.40,13.26,13.14,13.04,13,13,13,13,13,13,13,12.99,12.99,12.98,12.98,12.98,12.99,12.99,12.99,12.98,12.98,12.97,12.95,12.90,12.85,12.75,12.64,12.51,12.37,12.25,12.12,12.03,11.98,11.91,11.86,11.76,11.65,11.52,11.38,11.25,11.14,11.07,11.01,11,10.99,10.99,10.98,10.97,10.96,10.91,10.88,10.84,10.75,10.64,10.52,10.39,10.26,10.15,10.09,10.02,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.98,9.97,9.95,9.89,9.82,9.70,9.53,9.37,9.24,9.12,9.04,9,8.99,8.99,8.98,8.97,8.96,8.95,8.91,8.87,8.82,8.74,8.64,8.53,8.42,8.29,8.15,8,7.83,7.63,7.47,7.32,7.16,7.07,6.98,6.89,6.82,6.72,6.60,6.47,6.33,6.17,6.08,6,5.91,5.85,5.73,5.60,5.46,5.32,5.17,5.08,4.99,4.89,4.82,4.71,4.57,4.41,4.26,4.12,4,3.89,3.79,3.71,3.61,3.50,3.39,3.29,3.21,3.13,3.09,3.03,3,2.96,2.89,2.85,2.76,2.67,2.60,2.51,2.46,2.38,2.32,2.23,2.14,2.08,2,1.95,1.88,1.82,1.74,1.64,1.57,1.47,1.37,1.28,1.21,1.14,1.11,1.09,1.09,1.11,1.14,1.17,1.23,1.24,1.23,1.21,1.15,1.12,1.10,1.09,1.08,1.07,1.03,0.98,0.88,0.78,0.66,0.57,0.45,0.35,0.25,0.17,0.12,0.10,0.10,0.12,0.17,0.25,0.35,0.41,0.47,0.50,0.50,0.50,0.50,0.50,0.50,0.50,0.48,0.42,0.36,0.25,0.16,0.08,0,0,0.03,0.04,0.08,0.08,0.04,0.03,0.01,0.01,0.01,0.01,0,0,0,0,0,0.01,0.03,0.07,0.08,0.11,0.14,0.23,0.34,0.46,0.58,0.70,0.77,16.70,16.40,16.28,16.22,16.16,16.11,16.04,16,16,15.99,15.99,15.98,15.95,15.87,15.75,15.58,15.37,15.21,15.09,15.01,14.99,14.97,14.92,14.86,14.75,14.60,14.42,14.28,14.16,14.10,14.03,14,14,14,14,14,14,14,14,14,14.03,14.03,14.07,14.08,14.10,14.12,14.12,14.13,14.12,14.09,14.02,13.99,13.95,13.88,13.84,13.76,13.72,13.65,13.62,13.58,13.50,13.45,13.38,13.37,13.37,13.40,13.41,13.38,13.32,13.21,13.11,13.02,13,13,13,13,13,12.99,12.99,12.98,12.98,12.98,12.98,12.98,12.98,12.98,12.97,12.97,12.97,12.96,12.92,12.89,12.85,12.75,12.63,12.50,12.37,12.25,12.12,12.04,11.98,11.91,11.85,11.77,11.66,11.53,11.39,11.26,11.14,11.08,11.01,11,10.99,10.99,10.98,10.97,10.95,10.90,10.87,10.82,10.73,10.62,10.49,10.36,10.23,10.12,10.04,10.01,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.99,9.98,9.97,9.95,9.89,9.82,9.70,9.53,9.37,9.24,9.12,9.04,9,8.99,8.98,8.97,8.97,8.96,8.91,8.88,8.84,8.75,8.65,8.54,8.42,8.29,8.16,8.02,7.87,7.71,7.53,7.37,7.24,7.12,7.02,6.95,6.87,6.77,6.67,6.57,6.41,6.28,6.15,6.04,5.98,5.89,5.78,5.67,5.54,5.40,5.26,5.14,5.04,4.97,4.87,4.77,4.65,4.51,4.37,4.22,4.07,3.92,3.83,3.72,3.61,3.50,3.38,3.27,3.17,3.11,3.03,3,2.96,2.90,2.86,2.79,2.73,2.63,2.53,2.45,2.36,2.28,2.23,2.16,2.11,2.03,1.98,1.90,1.84,1.75,1.65,1.57,1.48,1.37,1.28,1.22,1.14,1.09,1.07,1.03,1.02,1.02,1.04,1.09,1.12,1.13,1.14,1.13,1.12,1.09,1.04,1.03,1.02,1.01,1,0.97,0.88,0.78,0.66,0.53,0.41,0.29,0.21,0.13,0.09,0.04,0.02,0.03,0.07,0.12,0.16,0.24,0.28,0.33,0.35,0.36,0.36,0.36,0.36,0.36,0.36,0.34,0.28,0.23,0.15,0.09,0.01,0,0,0,0.01,0.02,0.02,0.02,0.01,0,0,0,0,0,0,0,0,0.03,0.08,0.12,0.15,0.20,0.23,0.27,0.37,0.50,0.62,0.75,0.85,0.89,16.25,16.24,16.16,16.13,16.12,16.09,16.03,16,15.99,15.98,15.98,15.97,15.92,15.86,15.73,15.54,15.37,15.21,15.09,15.01,14.99,14.97,14.91,14.85,14.74,14.59,14.41,14.27,14.16,14.10,14.03,14.01,14,14,14,14,14,14,14,14,14.02,14.02,14.03,14.04,14.07,14.09,14.10,14.10,14.09,14.04,14.01,13.99,13.96,13.91,13.88,13.86,13.82,13.77,13.75,13.70,13.62,13.53,13.47,13.40,13.37,13.35,13.32,13.26,13.21,13.13,13.08,13.01,13,13,13,13,12.99,12.99,12.99,12.98,12.98,12.98,12.97,12.97,12.97,12.97,12.97,12.96,12.96,12.95,12.91,12.88,12.84,12.75,12.63,12.50,12.37,12.24,12.12,12.04,11.99,11.91,11.86,11.77,11.66,11.54,11.41,11.27,11.16,11.09,11.02,11,10.99,10.98,10.97,10.96,10.95,10.90,10.86,10.78,10.70,10.59,10.46,10.33,10.21,10.11,10.03,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.98,9.98,9.97,9.95,9.89,9.82,9.70,9.53,9.37,9.24,9.12,9.03,9,8.99,8.98,8.97,8.96,8.92,8.89,8.85,8.77,8.67,8.57,8.45,8.32,8.17,8.03,7.89,7.75,7.60,7.45,7.29,7.17,7.09,7,6.91,6.84,6.75,6.63,6.51,6.37,6.25,6.12,6.01,5.95,5.85,5.75,5.62,5.49,5.36,5.23,5.12,5.02,4.95,4.86,4.75,4.62,4.47,4.29,4.13,3.99,3.86,3.73,3.61,3.50,3.37,3.26,3.16,3.10,3.01,2.97,2.90,2.86,2.79,2.74,2.66,2.59,2.50,2.39,2.29,2.23,2.14,2.11,2.04,2,1.95,1.88,1.79,1.71,1.59,1.48,1.37,1.28,1.22,1.14,1.10,1.04,1.01,1,1,1,1,1.01,1.03,1.04,1.08,1.08,1.07,1.03,1.02,1,0.99,0.98,0.97,0.91,0.87,0.77,0.66,0.53,0.39,0.27,0.17,0.11,0.04,0.02,0,0,0,0.02,0.04,0.10,0.13,0.16,0.20,0.21,0.22,0.22,0.22,0.22,0.22,0.22,0.21,0.16,0.12,0.08,0.03,0,0,0.01,0.01,0.01,0.01,0,0,0,0,0,0,0,0,0,0,0.02,0.09,0.14,0.23,0.28,0.35,0.38,0.46,0.53,0.66,0.79,0.91,1,1.01,16.10,16.09,16.08,16.07,16.07,16.03,16,15.99,15.97,15.96,15.96,15.92,15.89,15.83,15.70,15.51,15.35,15.20,15.10,15.02,15,14.97,14.91,14.85,14.74,14.60,14.45,14.32,14.21,14.12,14.08,14.02,14.01,14,14,14,14,14,14,14,14.01,14.01,14.02,14.02,14.02,14.03,14.03,14.03,14.02,14.01,14,13.98,13.96,13.95,13.91,13.89,13.87,13.86,13.84,13.76,13.71,13.62,13.53,13.48,13.39,13.34,13.27,13.22,13.14,13.10,13.03,13,13,13,13,13,12.99,12.99,12.98,12.98,12.97,12.97,12.97,12.97,12.97,12.96,12.96,12.96,12.95,12.95,12.91,12.87,12.83,12.74,12.62,12.50,12.37,12.24,12.13,12.04,11.99,11.92,11.87,11.78,11.67,11.57,11.45,11.29,11.20,11.10,11.03,11,10.99,10.98,10.97,10.96,10.92,10.89,10.86,10.77,10.67,10.57,10.42,10.29,10.20,10.11,10.03,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.98,9.98,9.97,9.95,9.89,9.82,9.70,9.53,9.37,9.24,9.12,9.03,9,8.99,8.98,8.97,8.95,8.90,8.87,8.79,8.71,8.60,8.47,8.34,8.20,8.04,7.90,7.76,7.63,7.50,7.36,7.24,7.12,7.03,6.97,6.88,6.82,6.72,6.60,6.47,6.34,6.20,6.08,5.98,5.88,5.78,5.67,5.57,5.42,5.29,5.17,5.08,4.99,4.89,4.82,4.71,4.57,4.39,4.23,4.04,3.89,3.75,3.62,3.50,3.38,3.27,3.16,3.10,3.01,2.96,2.88,2.83,2.75,2.66,2.60,2.51,2.45,2.36,2.26,2.17,2.11,2.04,2,1.96,1.89,1.85,1.76,1.66,1.54,1.41,1.32,1.22,1.14,1.10,1.04,1.01,1,0.99,0.99,0.99,0.99,0.99,1,1,1.01,1.01,1.01,1,1,0.99,0.98,0.96,0.92,0.89,0.85,0.75,0.65,0.52,0.39,0.27,0.16,0.10,0.04,0.01,0,0,0,0,0,0.01,0.03,0.07,0.09,0.10,0.11,0.11,0.11,0.11,0.12,0.12,0.11,0.10,0.08,0.04,0.02,0,0,0.01,0.03,0.07,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0.04,0.12,0.23,0.34,0.41,0.50,0.54,0.62,0.71,0.82,0.95,1.04,1.11,1.11,16.01,16.01,16.01,16.01,16,16,15.98,15.96,15.92,15.90,15.89,15.87,15.84,15.75,15.62,15.47,15.32,15.17,15.10,15.03,15,14.98,14.92,14.87,14.76,14.63,14.50,14.37,14.25,14.17,14.12,14.08,14.03,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.98,13.97,13.96,13.95,13.92,13.91,13.90,13.88,13.86,13.83,13.78,13.74,13.67,13.62,13.53,13.46,13.37,13.27,13.20,13.12,13.08,13.02,13,13,13,13,12.99,12.99,12.98,12.98,12.98,12.97,12.97,12.96,12.97,12.96,12.96,12.96,12.95,12.95,12.91,12.90,12.87,12.79,12.72,12.62,12.49,12.36,12.24,12.12,12.04,12,11.92,11.87,11.79,11.71,11.59,11.46,11.33,11.21,11.12,11.04,11.01,11,10.98,10.97,10.96,10.92,10.90,10.86,10.78,10.70,10.58,10.45,10.32,10.21,10.12,10.07,10.02,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.98,9.97,9.97,9.95,9.89,9.82,9.70,9.54,9.38,9.24,9.12,9.03,9,8.98,8.97,8.96,8.92,8.88,8.83,8.74,8.62,8.50,8.36,8.22,8.07,7.91,7.78,7.64,7.51,7.39,7.27,7.16,7.09,7,6.95,6.87,6.77,6.67,6.57,6.41,6.27,6.14,6.02,5.91,5.84,5.74,5.62,5.49,5.36,5.24,5.12,5.02,4.95,4.86,4.75,4.62,4.48,4.29,4.12,3.95,3.77,3.63,3.50,3.38,3.27,3.17,3.10,3.01,2.96,2.87,2.79,2.71,2.61,2.51,2.45,2.37,2.28,2.22,2.14,2.08,2.01,1.96,1.89,1.85,1.77,1.71,1.62,1.51,1.38,1.26,1.16,1.10,1.04,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,0.99,0.99,0.98,0.97,0.95,0.91,0.87,0.83,0.75,0.63,0.52,0.39,0.27,0.16,0.10,0.03,0,0,0,0,0,0,0,0,0,0.01,0.01,0.02,0.02,0.03,0.03,0.03,0.03,0.04,0.03,0.03,0.02,0.01,0,0,0.01,0.07,0.09,0.12,0.04,0.01,0,0,0,0,0,0,0,0,0,0.01,0.07,0.14,0.25,0.37,0.50,0.59,0.65,0.73,0.82,0.91,1.01,1.11,1.14,1.13,16,16,15.99,15.99,15.98,15.97,15.92,15.89,15.86,15.84,15.82,15.77,15.73,15.63,15.51,15.38,15.25,15.16,15.10,15.04,15.01,14.99,14.95,14.88,14.82,14.71,14.59,14.47,14.36,14.26,14.21,14.14,14.10,14.07,14.02,14,14,14,13.99,13.99,13.99,13.99,13.99,13.98,13.98,13.98,13.97,13.96,13.95,13.95,13.92,13.91,13.89,13.88,13.87,13.87,13.83,13.79,13.77,13.76,13.75,13.72,13.66,13.61,13.52,13.42,13.33,13.23,13.13,13.08,13.02,13,13,13,12.99,12.99,12.99,12.98,12.98,12.97,12.97,12.97,12.96,12.96,12.96,12.96,12.95,12.95,12.92,12.90,12.88,12.85,12.77,12.70,12.59,12.47,12.34,12.23,12.12,12.04,12,11.95,11.88,11.82,11.72,11.61,11.48,11.35,11.23,11.13,11.07,11.01,11,10.99,10.98,10.97,10.95,10.90,10.87,10.79,10.71,10.60,10.47,10.35,10.24,10.14,10.10,10.07,10.02,10.02,10.01,10.01,10.01,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.98,9.97,9.96,9.92,9.88,9.82,9.71,9.54,9.39,9.25,9.12,9.04,9,8.98,8.97,8.95,8.90,8.86,8.77,8.66,8.53,8.39,8.25,8.10,7.95,7.79,7.66,7.53,7.40,7.29,7.21,7.12,7.03,6.98,6.90,6.85,6.75,6.64,6.51,6.37,6.24,6.10,5.98,5.87,5.76,5.65,5.53,5.40,5.28,5.16,5.07,4.97,4.87,4.77,4.65,4.51,4.36,4.16,3.99,3.82,3.64,3.50,3.38,3.27,3.17,3.10,3.01,2.95,2.87,2.78,2.67,2.57,2.46,2.36,2.28,2.23,2.15,2.11,2.04,2,1.92,1.87,1.78,1.72,1.63,1.54,1.46,1.36,1.25,1.14,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.96,0.95,0.91,0.87,0.82,0.74,0.63,0.51,0.39,0.27,0.16,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.09,0.14,0.09,0.03,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.13,0.24,0.36,0.48,0.59,0.67,0.76,0.86,0.96,1.03,1.10,1.12,1.12,15.99,15.99,15.98,15.98,15.96,15.91,15.87,15.82,15.75,15.71,15.65,15.63,15.59,15.50,15.39,15.28,15.20,15.13,15.10,15.07,15.02,15,14.98,14.92,14.87,14.78,14.70,14.59,14.49,14.39,14.32,14.25,14.16,14.12,14.07,14.02,14,14,13.99,13.99,13.99,13.98,13.98,13.97,13.96,13.95,13.92,13.91,13.89,13.88,13.87,13.86,13.84,13.83,13.78,13.75,13.74,13.72,13.71,13.71,13.71,13.70,13.67,13.64,13.59,13.50,13.38,13.27,13.17,13.11,13.04,13.01,13,13,12.99,12.99,12.98,12.98,12.98,12.97,12.97,12.97,12.96,12.96,12.95,12.95,12.95,12.92,12.91,12.89,12.87,12.83,12.75,12.65,12.54,12.42,12.32,12.21,12.12,12.04,12,11.95,11.89,11.83,11.74,11.62,11.49,11.37,11.25,11.14,11.08,11.02,11,11,10.99,10.97,10.96,10.91,10.87,10.83,10.74,10.63,10.51,10.40,10.29,10.22,10.15,10.12,10.11,10.09,10.08,10.08,10.07,10.04,10.04,10.04,10.04,10.03,10.02,10.01,10,10,9.99,9.98,9.98,9.97,9.96,9.92,9.88,9.82,9.71,9.57,9.40,9.25,9.13,9.04,9,8.98,8.96,8.92,8.88,8.83,8.73,8.61,8.46,8.28,8.12,7.97,7.83,7.67,7.54,7.41,7.32,7.22,7.13,7.07,7,6.96,6.88,6.82,6.73,6.61,6.48,6.34,6.17,6.03,5.91,5.79,5.70,5.58,5.46,5.34,5.22,5.10,5,4.89,4.79,4.67,4.54,4.38,4.22,4.01,3.84,3.65,3.50,3.37,3.26,3.16,3.09,3,2.95,2.87,2.77,2.66,2.53,2.40,2.28,2.22,2.15,2.11,2.08,2.02,1.98,1.91,1.85,1.76,1.66,1.58,1.48,1.37,1.28,1.22,1.12,1.07,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.95,0.91,0.87,0.83,0.74,0.63,0.51,0.38,0.26,0.16,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.07,0.12,0.09,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.12,0.21,0.29,0.40,0.51,0.63,0.75,0.86,0.95,1,1.04,1.07,1.07,15.99,15.98,15.97,15.96,15.91,15.87,15.78,15.70,15.61,15.53,15.49,15.46,15.41,15.35,15.26,15.20,15.13,15.10,15.08,15.07,15.03,15.01,15,14.99,14.96,14.88,14.82,14.73,14.62,14.53,14.46,14.37,14.27,14.20,14.12,14.08,14.02,14,13.99,13.99,13.98,13.97,13.97,13.96,13.95,13.92,13.88,13.87,13.84,13.79,13.76,13.75,13.72,13.67,13.64,13.62,13.60,13.59,13.59,13.59,13.60,13.62,13.64,13.63,13.61,13.52,13.45,13.34,13.23,13.13,13.08,13.02,13,13,12.99,12.99,12.98,12.98,12.98,12.97,12.97,12.96,12.96,12.96,12.95,12.92,12.91,12.91,12.89,12.87,12.84,12.77,12.71,12.61,12.50,12.38,12.26,12.16,12.10,12.03,11.99,11.95,11.89,11.84,11.74,11.62,11.50,11.37,11.25,11.15,11.09,11.03,11.01,11,10.99,10.98,10.97,10.92,10.89,10.85,10.77,10.70,10.59,10.49,10.38,10.32,10.25,10.22,10.20,10.16,10.15,10.14,10.13,10.13,10.12,10.12,10.12,10.11,10.09,10.07,10.02,10,10,9.99,9.98,9.97,9.96,9.92,9.88,9.83,9.72,9.58,9.41,9.27,9.15,9.07,9,8.98,8.96,8.91,8.87,8.78,8.67,8.52,8.37,8.20,8.01,7.85,7.70,7.57,7.42,7.33,7.23,7.13,7.08,7.01,6.98,6.91,6.87,6.78,6.70,6.57,6.41,6.27,6.12,5.98,5.85,5.72,5.61,5.48,5.36,5.24,5.12,5.01,4.90,4.79,4.70,4.54,4.39,4.23,4.03,3.86,3.66,3.50,3.37,3.25,3.15,3.09,3,2.92,2.86,2.75,2.65,2.52,2.38,2.25,2.15,2.11,2.07,2.02,2,1.97,1.90,1.85,1.75,1.64,1.53,1.41,1.33,1.24,1.15,1.11,1.04,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.96,0.92,0.88,0.84,0.75,0.63,0.51,0.38,0.26,0.16,0.10,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.07,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0.02,0.08,0.12,0.20,0.27,0.37,0.49,0.60,0.72,0.83,0.90,0.97,1,1,1,15.99,15.98,15.96,15.91,15.87,15.78,15.67,15.57,15.46,15.37,15.33,15.28,15.25,15.22,15.15,15.12,15.09,15.07,15.07,15.07,15.04,15.03,15.03,15.02,15.01,14.99,14.92,14.86,14.76,14.67,14.60,14.50,14.38,14.28,14.21,14.12,14.07,14.02,14,13.99,13.98,13.97,13.96,13.95,13.91,13.89,13.86,13.79,13.75,13.72,13.66,13.62,13.59,13.54,13.50,13.49,13.47,13.46,13.46,13.47,13.49,13.51,13.53,13.54,13.54,13.51,13.45,13.36,13.25,13.16,13.11,13.04,13.01,13,12.99,12.99,12.98,12.98,12.97,12.97,12.97,12.96,12.96,12.95,12.95,12.92,12.90,12.88,12.87,12.85,12.78,12.73,12.63,12.53,12.42,12.33,12.23,12.13,12.08,12.01,11.99,11.95,11.89,11.84,11.74,11.62,11.50,11.37,11.25,11.16,11.10,11.04,11.01,11,11,10.99,10.97,10.96,10.91,10.87,10.83,10.75,10.66,10.59,10.50,10.41,10.37,10.33,10.29,10.27,10.26,10.25,10.25,10.25,10.24,10.24,10.22,10.20,10.15,10.12,10.08,10.03,10,9.99,9.98,9.97,9.96,9.92,9.88,9.83,9.72,9.59,9.45,9.29,9.16,9.09,9.01,8.98,8.95,8.90,8.85,8.75,8.62,8.46,8.27,8.09,7.89,7.74,7.58,7.45,7.34,7.23,7.14,7.08,7.02,6.99,6.95,6.88,6.84,6.75,6.64,6.51,6.37,6.22,6.04,5.89,5.75,5.62,5.50,5.37,5.25,5.14,5.02,4.91,4.82,4.70,4.57,4.40,4.24,4.04,3.86,3.67,3.50,3.37,3.25,3.14,3.07,3,2.91,2.85,2.75,2.64,2.51,2.37,2.25,2.13,2.08,2.02,2,1.99,1.96,1.90,1.85,1.75,1.64,1.51,1.39,1.28,1.21,1.12,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.96,0.91,0.86,0.76,0.64,0.51,0.38,0.26,0.16,0.10,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0.01,0,0,0,0,0.01,0.02,0.01,0,0,0,0,0.01,0.04,0.11,0.16,0.25,0.36,0.46,0.53,0.63,0.74,0.84,0.89,0.95,0.97,0.97,0.97,15.99,15.97,15.92,15.87,15.78,15.67,15.54,15.41,15.32,15.24,15.20,15.16,15.14,15.12,15.09,15.07,15.04,15.03,15.04,15.04,15.07,15.07,15.07,15.08,15.08,15.07,15.01,14.97,14.88,14.82,14.73,14.62,14.51,14.39,14.28,14.20,14.11,14.04,14,13.99,13.98,13.96,13.96,13.92,13.90,13.87,13.82,13.75,13.66,13.61,13.54,13.50,13.46,13.40,13.37,13.36,13.34,13.33,13.34,13.35,13.37,13.40,13.42,13.46,13.46,13.42,13.38,13.34,13.25,13.17,13.12,13.07,13.02,13,12.99,12.98,12.98,12.97,12.97,12.97,12.97,12.96,12.96,12.95,12.92,12.91,12.89,12.87,12.84,12.79,12.74,12.65,12.57,12.47,12.36,12.25,12.16,12.10,12.03,12,11.98,11.95,11.89,11.84,11.74,11.62,11.50,11.37,11.25,11.16,11.10,11.04,11.01,11,11,11,10.99,10.97,10.95,10.90,10.87,10.82,10.75,10.66,10.61,10.53,10.49,10.46,10.42,10.40,10.39,10.39,10.38,10.38,10.37,10.37,10.35,10.32,10.25,10.21,10.13,10.08,10.02,10,9.98,9.97,9.96,9.92,9.88,9.83,9.73,9.61,9.47,9.32,9.20,9.10,9.01,8.97,8.92,8.87,8.82,8.71,8.54,8.37,8.17,7.99,7.78,7.62,7.47,7.35,7.24,7.14,7.09,7.02,6.99,6.96,6.90,6.87,6.79,6.72,6.60,6.46,6.29,6.13,5.98,5.82,5.65,5.51,5.38,5.26,5.14,5.03,4.92,4.83,4.70,4.57,4.40,4.24,4.04,3.87,3.67,3.50,3.37,3.24,3.13,3.04,2.99,2.90,2.84,2.75,2.63,2.50,2.37,2.25,2.13,2.07,2.01,2,1.98,1.96,1.91,1.85,1.75,1.64,1.51,1.39,1.27,1.17,1.11,1.04,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.95,0.88,0.79,0.66,0.52,0.38,0.26,0.16,0.10,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.02,0.01,0,0,0,0,0.03,0.10,0.16,0.27,0.39,0.51,0.62,0.70,0.75,0.82,0.87,0.90,0.92,0.92,0.91,0.90,15.99,15.96,15.88,15.78,15.67,15.54,15.40,15.28,15.21,15.15,15.13,15.12,15.10,15.07,15.04,15.02,15.02,15.03,15.03,15.04,15.07,15.07,15.08,15.10,15.11,15.10,15.08,15.03,14.99,14.91,14.85,14.75,14.63,14.50,14.37,14.26,14.15,14.09,14.02,14,13.98,13.97,13.95,13.92,13.88,13.85,13.76,13.67,13.60,13.50,13.45,13.37,13.34,13.28,13.26,13.25,13.23,13.23,13.23,13.24,13.25,13.28,13.33,13.34,13.35,13.34,13.29,13.25,13.22,13.15,13.11,13.07,13.02,13,13,12.98,12.98,12.97,12.97,12.97,12.96,12.96,12.95,12.92,12.90,12.88,12.87,12.84,12.78,12.73,12.65,12.58,12.48,12.37,12.27,12.20,12.12,12.07,12.01,11.99,11.97,11.95,11.89,11.84,11.74,11.62,11.50,11.37,11.25,11.16,11.10,11.04,11.01,11,11,11,10.99,10.98,10.97,10.95,10.90,10.87,10.82,10.75,10.71,10.64,10.62,10.59,10.57,10.53,10.53,10.53,10.53,10.53,10.53,10.51,10.49,10.42,10.37,10.28,10.20,10.12,10.04,10,9.99,9.97,9.96,9.92,9.88,9.84,9.74,9.62,9.48,9.34,9.21,9.10,9.01,8.97,8.90,8.86,8.76,8.63,8.48,8.28,8.09,7.87,7.67,7.50,7.37,7.25,7.15,7.09,7.02,6.99,6.96,6.91,6.88,6.84,6.76,6.65,6.53,6.39,6.23,6.04,5.87,5.71,5.54,5.40,5.27,5.15,5.04,4.92,4.83,4.70,4.57,4.39,4.24,4.04,3.86,3.67,3.50,3.36,3.24,3.13,3.04,2.98,2.89,2.83,2.74,2.62,2.50,2.37,2.25,2.13,2.07,2.01,2,1.98,1.97,1.92,1.87,1.77,1.65,1.51,1.39,1.27,1.16,1.10,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.90,0.83,0.71,0.53,0.38,0.25,0.14,0.09,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.07,0.04,0.02,0,0,0,0,0,0,0,0,0.01,0.02,0.01,0,0,0,0.02,0.09,0.15,0.27,0.40,0.54,0.70,0.78,0.85,0.86,0.87,0.87,0.89,0.88,0.87,0.84,0.82,15.98,15.92,15.83,15.70,15.54,15.39,15.27,15.20,15.14,15.12,15.12,15.10,15.08,15.03,15.02,15.02,15.02,15.03,15.03,15.04,15.04,15.07,15.08,15.10,15.11,15.11,15.10,15.08,15.03,14.99,14.91,14.85,14.74,14.61,14.48,14.35,14.23,14.12,14.07,14.01,13.99,13.97,13.95,13.91,13.87,13.82,13.73,13.62,13.51,13.42,13.35,13.27,13.24,13.20,13.16,13.14,13.13,13.13,13.14,13.15,13.16,13.20,13.21,13.23,13.23,13.23,13.22,13.17,13.14,13.12,13.09,13.04,13.02,13,12.99,12.98,12.98,12.97,12.97,12.96,12.96,12.95,12.92,12.91,12.89,12.87,12.83,12.78,12.73,12.64,12.59,12.49,12.37,12.28,12.21,12.12,12.08,12.02,12,11.98,11.96,11.92,11.88,11.83,11.74,11.62,11.50,11.37,11.25,11.15,11.10,11.03,11.01,11,11,11,11,10.99,10.98,10.97,10.95,10.90,10.87,10.84,10.78,10.75,10.73,10.70,10.67,10.66,10.65,10.66,10.66,10.67,10.67,10.66,10.62,10.54,10.47,10.37,10.25,10.15,10.09,10.01,9.99,9.97,9.96,9.92,9.89,9.84,9.75,9.62,9.49,9.35,9.22,9.11,9.01,8.96,8.88,8.82,8.72,8.58,8.39,8.20,7.98,7.76,7.58,7.40,7.27,7.17,7.11,7.03,7,6.97,6.92,6.89,6.86,6.79,6.73,6.62,6.48,6.33,6.14,5.97,5.77,5.61,5.45,5.29,5.16,5.04,4.92,4.83,4.70,4.54,4.39,4.23,4.03,3.86,3.66,3.50,3.36,3.23,3.12,3.04,2.98,2.89,2.83,2.74,2.62,2.50,2.37,2.25,2.13,2.07,2.01,1.99,1.98,1.97,1.95,1.89,1.79,1.67,1.52,1.38,1.26,1.16,1.10,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.91,0.85,0.73,0.57,0.38,0.24,0.13,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.09,0.14,0.14,0.10,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.12,0.24,0.37,0.53,0.70,0.83,0.91,0.92,0.92,0.87,0.84,0.79,0.76,0.71,0.67,0.67,15.97,15.89,15.75,15.59,15.41,15.27,15.16,15.12,15.11,15.12,15.12,15.10,15.07,15.03,15.02,15.02,15.03,15.03,15.03,15.03,15.03,15.04,15.07,15.08,15.09,15.09,15.09,15.08,15.04,15.01,14.98,14.90,14.82,14.70,14.57,14.41,14.28,14.17,14.11,14.03,14,13.98,13.96,13.91,13.86,13.78,13.70,13.59,13.47,13.36,13.26,13.21,13.15,13.12,13.11,13.10,13.09,13.09,13.09,13.10,13.11,13.11,13.12,13.12,13.12,13.12,13.12,13.12,13.10,13.08,13.04,13.02,13,13,12.99,12.98,12.97,12.97,12.96,12.96,12.95,12.92,12.91,12.89,12.87,12.84,12.77,12.72,12.65,12.58,12.48,12.38,12.28,12.22,12.13,12.08,12.02,12,11.99,11.97,11.96,11.91,11.88,11.83,11.74,11.62,11.50,11.37,11.25,11.15,11.09,11.03,11.01,11,11,11,11,11,10.99,10.98,10.97,10.95,10.90,10.88,10.86,10.84,10.82,10.78,10.77,10.76,10.76,10.76,10.78,10.78,10.79,10.78,10.75,10.65,10.54,10.42,10.29,10.20,10.11,10.03,10,9.97,9.96,9.92,9.89,9.84,9.75,9.63,9.50,9.36,9.23,9.12,9.01,8.95,8.87,8.77,8.65,8.50,8.32,8.11,7.88,7.66,7.49,7.34,7.22,7.12,7.04,7,6.97,6.92,6.90,6.87,6.83,6.75,6.66,6.54,6.40,6.25,6.07,5.87,5.67,5.50,5.35,5.20,5.07,4.95,4.83,4.70,4.54,4.38,4.23,4.03,3.86,3.66,3.50,3.36,3.23,3.12,3.03,2.97,2.89,2.83,2.73,2.62,2.50,2.37,2.24,2.12,2.04,2,1.98,1.97,1.95,1.92,1.89,1.83,1.71,1.53,1.38,1.25,1.15,1.09,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.96,0.88,0.75,0.59,0.37,0.24,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.11,0.15,0.16,0.11,0.03,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.11,0.20,0.33,0.49,0.65,0.82,0.91,0.97,0.97,0.90,0.83,0.74,0.64,0.59,0.53,0.52,0.54,15.96,15.87,15.67,15.50,15.32,15.17,15.10,15.07,15.09,15.10,15.11,15.09,15.07,15.03,15.02,15.03,15.03,15.03,15.03,15.03,15.03,15.03,15.03,15.04,15.04,15.07,15.04,15.04,15.03,15.02,15,14.95,14.87,14.75,14.62,14.49,14.36,14.24,14.14,14.08,14.02,13.99,13.96,13.90,13.86,13.76,13.66,13.54,13.42,13.32,13.23,13.14,13.11,13.08,13.07,13.04,13.04,13.04,13.04,13.04,13.04,13.04,13.04,13.04,13.07,13.07,13.04,13.04,13.03,13.02,13.01,13,13,12.99,12.98,12.97,12.96,12.96,12.95,12.95,12.92,12.91,12.89,12.87,12.84,12.78,12.73,12.64,12.58,12.49,12.38,12.29,12.22,12.13,12.09,12.03,12,11.99,11.98,11.97,11.95,11.91,11.87,11.82,11.73,11.62,11.50,11.37,11.25,11.15,11.09,11.03,11,11,11,11,11,11,11,10.99,10.98,10.96,10.95,10.91,10.89,10.88,10.87,10.87,10.86,10.85,10.85,10.85,10.87,10.87,10.87,10.87,10.82,10.73,10.61,10.48,10.34,10.22,10.12,10.04,10,9.98,9.96,9.92,9.89,9.84,9.75,9.63,9.50,9.37,9.24,9.12,9.01,8.92,8.85,8.75,8.62,8.45,8.25,8.02,7.82,7.60,7.41,7.27,7.16,7.09,7.02,6.98,6.95,6.90,6.87,6.84,6.77,6.71,6.61,6.49,6.34,6.15,5.98,5.77,5.60,5.40,5.25,5.10,4.96,4.83,4.70,4.53,4.38,4.22,4.03,3.86,3.66,3.50,3.36,3.23,3.12,3.03,2.97,2.89,2.83,2.73,2.62,2.49,2.36,2.23,2.12,2.02,1.98,1.95,1.91,1.90,1.87,1.85,1.77,1.67,1.53,1.38,1.25,1.14,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.92,0.82,0.62,0.41,0.23,0.12,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.09,0.12,0.12,0.09,0.02,0,0,0,0,0,0,0,0,0,0,0,0.02,0.08,0.14,0.25,0.39,0.59,0.75,0.87,0.92,0.95,0.89,0.82,0.71,0.59,0.48,0.39,0.37,0.38,0.45,15.95,15.85,15.64,15.41,15.24,15.12,15.04,15.02,15.04,15.07,15.08,15.07,15.03,15.02,15.02,15.02,15.03,15.04,15.04,15.03,15.03,15.02,15.02,15.02,15.02,15.02,15.02,15.01,15.01,15.01,15,14.96,14.88,14.79,14.70,14.54,14.41,14.29,14.21,14.12,14.07,14,13.97,13.90,13.86,13.76,13.65,13.52,13.39,13.28,13.20,13.12,13.08,13.03,13.02,13.02,13.02,13.01,13.01,13.01,13.01,13.01,13,13,13,13,13,13,13,13,12.99,12.99,12.98,12.98,12.97,12.96,12.95,12.92,12.92,12.91,12.90,12.89,12.87,12.84,12.78,12.73,12.64,12.57,12.48,12.38,12.29,12.22,12.14,12.09,12.03,12,11.99,11.98,11.97,11.96,11.95,11.91,11.87,11.82,11.73,11.62,11.49,11.37,11.25,11.14,11.09,11.02,11,11,11,11,11,11,11,10.99,10.98,10.97,10.96,10.95,10.92,10.91,10.90,10.90,10.89,10.89,10.89,10.89,10.91,10.91,10.91,10.90,10.86,10.76,10.63,10.50,10.37,10.24,10.12,10.07,10,9.98,9.96,9.92,9.89,9.84,9.75,9.64,9.50,9.37,9.24,9.12,9.01,8.91,8.84,8.72,8.58,8.40,8.21,7.99,7.75,7.57,7.38,7.25,7.14,7.07,7,6.97,6.91,6.88,6.85,6.79,6.74,6.64,6.53,6.40,6.25,6.09,5.88,5.71,5.50,5.32,5.13,4.99,4.84,4.70,4.53,4.38,4.22,4.02,3.85,3.66,3.50,3.35,3.22,3.12,3.02,2.97,2.89,2.83,2.73,2.62,2.49,2.36,2.23,2.11,2,1.91,1.86,1.82,1.78,1.76,1.73,1.65,1.59,1.48,1.36,1.23,1.12,1.07,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.96,0.87,0.72,0.50,0.28,0.12,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.07,0.07,0.03,0.01,0,0,0,0,0,0.01,0.01,0.03,0.03,0.03,0.03,0.04,0.10,0.16,0.28,0.45,0.63,0.78,0.87,0.87,0.83,0.75,0.64,0.53,0.40,0.29,0.24,0.23,0.26,0.37,15.91,15.83,15.60,15.34,15.17,15.08,15.01,15,15.01,15.02,15.02,15.02,15.01,15,15.01,15.01,15.03,15.04,15.04,15.04,15.03,15.02,15.02,15.01,15,15,15,15,15,15,14.99,14.97,14.90,14.84,14.73,14.61,14.49,14.37,14.25,14.16,14.10,14.03,13.98,13.91,13.86,13.76,13.64,13.51,13.38,13.26,13.16,13.10,13.04,13.01,13,13,13,13,13,13,13,12.99,12.99,12.99,12.99,12.99,12.98,12.98,12.98,12.98,12.98,12.97,12.97,12.96,12.96,12.92,12.91,12.90,12.89,12.88,12.87,12.86,12.83,12.77,12.73,12.64,12.58,12.48,12.38,12.29,12.22,12.14,12.10,12.03,12,12,11.98,11.97,11.97,11.96,11.95,11.90,11.87,11.79,11.72,11.61,11.48,11.36,11.24,11.14,11.08,11.02,11,11,11,11,11,11,11,10.99,10.99,10.98,10.97,10.96,10.96,10.95,10.95,10.92,10.92,10.92,10.92,10.92,10.95,10.95,10.95,10.91,10.87,10.78,10.64,10.51,10.37,10.25,10.13,10.07,10,9.98,9.96,9.91,9.88,9.84,9.75,9.64,9.50,9.37,9.24,9.12,9,8.91,8.83,8.72,8.58,8.39,8.20,7.98,7.75,7.57,7.38,7.25,7.14,7.07,7,6.96,6.90,6.87,6.83,6.75,6.67,6.59,6.47,6.33,6.16,6,5.82,5.61,5.40,5.22,5.02,4.87,4.70,4.53,4.37,4.22,4.02,3.85,3.65,3.50,3.35,3.22,3.11,3.01,2.95,2.87,2.82,2.73,2.62,2.49,2.36,2.23,2.11,2,1.89,1.76,1.65,1.58,1.57,1.54,1.50,1.42,1.35,1.25,1.17,1.10,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.92,0.84,0.63,0.37,0.21,0.08,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.01,0,0,0,0,0,0.02,0.08,0.10,0.12,0.13,0.13,0.12,0.10,0.09,0.11,0.15,0.26,0.40,0.59,0.78,0.75,0.70,0.62,0.53,0.46,0.36,0.25,0.16,0.12,0.12,0.21,0.33,15.88,15.75,15.52,15.27,15.12,15.04,15,15,15,15,15,15,15,15,15,15,15.02,15.03,15.04,15.07,15.04,15.03,15.02,15.01,15,14.99,14.99,14.98,14.98,14.98,14.98,14.96,14.91,14.86,14.76,14.66,14.57,14.45,14.34,14.23,14.13,14.08,14,13.92,13.86,13.76,13.64,13.51,13.38,13.26,13.15,13.09,13.03,13,13,13,13,12.99,12.99,12.99,12.98,12.98,12.98,12.98,12.97,12.97,12.97,12.97,12.97,12.97,12.96,12.96,12.95,12.92,12.91,12.90,12.88,12.87,12.85,12.83,12.82,12.78,12.75,12.72,12.64,12.57,12.48,12.38,12.29,12.22,12.14,12.09,12.03,12,12,11.99,11.98,11.97,11.97,11.96,11.92,11.90,11.86,11.78,11.70,11.59,11.47,11.34,11.23,11.13,11.08,11.02,11,11,11,11,11,11,11,10.99,10.99,10.98,10.97,10.97,10.96,10.96,10.96,10.96,10.96,10.96,10.96,10.95,10.96,10.96,10.95,10.91,10.87,10.77,10.64,10.51,10.37,10.25,10.13,10.07,10,9.98,9.96,9.91,9.88,9.84,9.75,9.63,9.50,9.37,9.24,9.12,9,8.91,8.84,8.73,8.59,8.41,8.23,8.01,7.79,7.61,7.42,7.28,7.16,7.09,7,6.96,6.89,6.85,6.77,6.72,6.62,6.50,6.38,6.24,6.09,5.90,5.72,5.51,5.32,5.11,4.90,4.74,4.54,4.37,4.21,4.01,3.85,3.65,3.50,3.35,3.21,3.10,3,2.91,2.86,2.78,2.71,2.61,2.48,2.35,2.22,2.11,2,1.89,1.75,1.59,1.41,1.34,1.32,1.32,1.28,1.24,1.16,1.11,1.04,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.92,0.82,0.62,0.36,0.14,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.20,0.32,0.34,0.33,0.28,0.27,0.17,0.10,0.09,0.12,0.20,0.32,0.45,0.52,0.52,0.47,0.38,0.33,0.26,0.21,0.14,0.09,0.04,0.08,0.16,0.32,15.87,15.70,15.45,15.23,15.10,15.02,15,14.99,14.99,14.99,14.99,14.99,14.98,14.98,14.98,14.99,15,15.01,15.02,15.04,15.04,15.03,15.02,15,14.99,14.98,14.97,14.97,14.97,14.97,14.96,14.95,14.91,14.87,14.79,14.73,14.62,14.51,14.39,14.28,14.20,14.11,14.02,13.96,13.87,13.76,13.64,13.50,13.37,13.25,13.15,13.09,13.02,13,12.99,12.99,12.99,12.98,12.98,12.98,12.98,12.98,12.97,12.97,12.97,12.97,12.96,12.96,12.96,12.95,12.95,12.95,12.91,12.90,12.87,12.87,12.84,12.79,12.76,12.75,12.73,12.71,12.65,12.62,12.54,12.47,12.38,12.29,12.23,12.14,12.10,12.03,12,12,11.99,11.98,11.98,11.97,11.96,11.95,11.92,11.89,11.85,11.76,11.66,11.57,11.45,11.33,11.22,11.12,11.07,11.02,11,11,11,11,11,11,11,10.99,10.99,10.98,10.97,10.97,10.97,10.97,10.96,10.96,10.96,10.96,10.96,10.96,10.96,10.96,10.95,10.91,10.87,10.78,10.65,10.51,10.37,10.25,10.13,10.07,10,9.98,9.96,9.91,9.88,9.83,9.75,9.63,9.50,9.37,9.24,9.12,9.01,8.92,8.85,8.75,8.62,8.47,8.27,8.09,7.87,7.67,7.50,7.35,7.23,7.12,7.03,6.97,6.89,6.84,6.75,6.65,6.54,6.42,6.29,6.14,5.99,5.82,5.62,5.40,5.20,4.99,4.78,4.59,4.39,4.21,4.01,3.85,3.65,3.50,3.34,3.21,3.09,2.99,2.89,2.82,2.74,2.65,2.58,2.47,2.34,2.22,2.11,2,1.89,1.75,1.59,1.38,1.25,1.16,1.16,1.16,1.25,1.22,1.15,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.92,0.82,0.62,0.35,0.13,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.10,0.26,0.67,0.82,0.22,0.62,0.48,0.20,0.09,0.04,0.07,0.11,0.17,0.25,0.29,0.28,0.25,0.20,0.14,0.12,0.12,0.10,0.07,0.03,0.07,0.15,0.32,15.87,15.65,15.38,15.17,15.07,15,15,14.99,14.98,14.98,14.98,14.97,14.97,14.96,14.95,14.95,14.95,14.97,14.99,15,15.01,15.01,15,14.99,14.97,14.95,14.95,14.92,14.92,14.95,14.95,14.92,14.90,14.87,14.84,14.76,14.67,14.58,14.47,14.35,14.25,14.14,14.07,13.98,13.88,13.77,13.64,13.50,13.37,13.25,13.15,13.09,13.02,13,12.99,12.98,12.98,12.98,12.98,12.97,12.97,12.97,12.97,12.97,12.96,12.96,12.96,12.95,12.95,12.92,12.91,12.91,12.89,12.87,12.84,12.78,12.75,12.71,12.65,12.62,12.61,12.59,12.54,12.50,12.45,12.37,12.28,12.22,12.14,12.10,12.03,12,12,11.99,11.98,11.98,11.97,11.97,11.96,11.95,11.91,11.87,11.83,11.74,11.63,11.52,11.40,11.29,11.20,11.12,11.07,11.01,11,11,11,11,11.01,11,11,10.99,10.99,10.98,10.98,10.97,10.97,10.97,10.97,10.97,10.96,10.96,10.96,10.96,10.96,10.96,10.92,10.90,10.86,10.77,10.64,10.50,10.37,10.25,10.13,10.07,10,9.98,9.96,9.91,9.88,9.83,9.74,9.62,9.50,9.37,9.24,9.12,9.02,8.95,8.87,8.77,8.65,8.52,8.37,8.17,7.99,7.78,7.61,7.42,7.28,7.16,7.08,6.99,6.89,6.82,6.73,6.62,6.49,6.36,6.21,6.04,5.87,5.70,5.50,5.27,5.07,4.85,4.63,4.42,4.23,4.02,3.85,3.66,3.50,3.35,3.21,3.09,2.98,2.87,2.77,2.67,2.60,2.50,2.40,2.32,2.21,2.10,2,1.89,1.75,1.59,1.38,1.25,1.15,1.23,1.22,1.21,1.21,1.64,1.13,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.92,0.82,0.62,0.35,0.13,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.25,0.53,0.33,0.22,0.22,0.24,0.14,0.04,0.01,0.01,0.03,0.08,0.11,0.12,0.12,0.09,0.07,0.04,0.07,0.09,0.09,0.07,0.03,0.07,0.15,0.32,15.87,15.58,15.34,15.14,15.03,15,15,14.99,14.98,14.98,14.97,14.96,14.95,14.91,14.89,14.87,14.87,14.87,14.89,14.91,14.96,14.97,14.97,14.95,14.91,14.90,14.89,14.89,14.90,14.91,14.91,14.92,14.90,14.89,14.86,14.79,14.72,14.62,14.51,14.39,14.28,14.17,14.09,14,13.89,13.77,13.65,13.51,13.38,13.25,13.15,13.09,13.02,13,12.98,12.98,12.98,12.97,12.97,12.97,12.97,12.97,12.97,12.97,12.96,12.96,12.95,12.95,12.92,12.91,12.89,12.88,12.87,12.83,12.76,12.71,12.64,12.60,12.53,12.50,12.49,12.47,12.42,12.38,12.34,12.26,12.21,12.13,12.09,12.03,12,12,11.99,11.98,11.98,11.97,11.97,11.96,11.95,11.91,11.89,11.86,11.78,11.71,11.60,11.49,11.37,11.26,11.16,11.10,11.04,11.01,11,11,11.01,11.01,11.02,11.01,11,11,10.99,10.98,10.98,10.97,10.97,10.97,10.96,10.96,10.96,10.96,10.96,10.95,10.96,10.95,10.92,10.89,10.85,10.76,10.64,10.50,10.37,10.25,10.13,10.07,10,9.98,9.95,9.91,9.87,9.82,9.74,9.62,9.50,9.37,9.24,9.12,9.02,8.96,8.88,8.79,8.72,8.60,8.45,8.27,8.10,7.90,7.72,7.53,7.37,7.24,7.12,7.01,6.90,6.82,6.70,6.57,6.41,6.26,6.11,5.95,5.75,5.57,5.36,5.13,4.90,4.70,4.48,4.25,4.03,3.85,3.66,3.50,3.36,3.22,3.09,2.98,2.87,2.76,2.64,2.53,2.45,2.35,2.25,2.16,2.09,1.99,1.89,1.75,1.59,1.37,1.24,1.16,1.24,1.32,1.57,1.21,1.17,1.14,1.12,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.92,0.83,0.62,0.34,0.12,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.14,0.20,0.17,0.11,0.07,0.07,0.04,0.01,0,0,0,0.01,0.01,0.02,0.02,0.01,0,0.01,0.03,0.07,0.09,0.07,0.03,0.07,0.15,0.32,15.75,15.47,15.25,15.11,15.01,15,15,15,14.98,14.98,14.97,14.95,14.91,14.88,14.85,14.79,14.76,14.75,14.76,14.79,14.84,14.87,14.87,14.87,14.85,14.84,14.84,14.85,14.87,14.88,14.89,14.90,14.90,14.89,14.87,14.84,14.75,14.66,14.57,14.46,14.34,14.22,14.12,14,13.90,13.78,13.65,13.51,13.38,13.26,13.15,13.09,13.01,13,12.98,12.98,12.97,12.97,12.97,12.97,12.96,12.96,12.96,12.96,12.96,12.96,12.95,12.92,12.91,12.89,12.87,12.85,12.82,12.75,12.67,12.62,12.53,12.47,12.40,12.37,12.36,12.34,12.32,12.27,12.24,12.17,12.12,12.09,12.03,12,12,11.99,11.98,11.97,11.97,11.97,11.96,11.95,11.92,11.90,11.87,11.82,11.74,11.64,11.53,11.45,11.34,11.24,11.14,11.09,11.03,11.01,11,11,11.01,11.01,11.02,11.01,11,10.99,10.98,10.98,10.97,10.97,10.97,10.96,10.96,10.96,10.96,10.95,10.95,10.95,10.95,10.95,10.91,10.88,10.84,10.75,10.63,10.50,10.37,10.24,10.13,10.07,10,9.97,9.95,9.90,9.87,9.82,9.73,9.62,9.49,9.36,9.24,9.12,9.03,8.97,8.89,8.84,8.75,8.64,8.52,8.37,8.21,8.01,7.84,7.64,7.48,7.32,7.16,7.03,6.91,6.78,6.65,6.51,6.36,6.17,6,5.83,5.62,5.41,5.20,4.97,4.75,4.51,4.28,4.08,3.87,3.66,3.50,3.36,3.22,3.10,2.98,2.86,2.75,2.63,2.51,2.38,2.28,2.20,2.12,2.03,1.97,1.88,1.75,1.59,1.37,1.22,1.13,1.22,1.37,1.53,1.36,1.16,1.04,1.02,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.97,0.97,0.97,0.96,0.92,0.83,0.62,0.34,0.12,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.08,0.07,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.08,0.07,0.03,0.07,0.15,0.32,15.41,15.32,15.16,15.07,15.01,15,15,15,14.99,14.98,14.96,14.92,14.89,14.85,14.77,14.72,14.64,14.62,14.62,14.64,14.70,14.73,14.74,14.74,14.74,14.74,14.75,14.77,14.82,14.85,14.87,14.88,14.89,14.89,14.87,14.84,14.77,14.70,14.61,14.49,14.37,14.25,14.13,14.02,13.91,13.78,13.65,13.52,13.38,13.25,13.15,13.08,13.01,13,12.98,12.98,12.97,12.97,12.97,12.96,12.96,12.96,12.96,12.96,12.96,12.95,12.92,12.91,12.89,12.87,12.85,12.78,12.74,12.66,12.60,12.50,12.41,12.35,12.28,12.25,12.24,12.22,12.21,12.17,12.14,12.11,12.08,12.03,12,12,11.99,11.98,11.98,11.97,11.97,11.97,11.96,11.92,11.90,11.87,11.83,11.75,11.67,11.59,11.49,11.38,11.28,11.22,11.13,11.08,11.03,11.01,11.01,11.01,11.01,11.01,11.01,11,11,10.99,10.98,10.98,10.97,10.97,10.97,10.96,10.96,10.95,10.95,10.95,10.95,10.95,10.95,10.92,10.90,10.87,10.83,10.74,10.62,10.49,10.35,10.23,10.12,10.04,10,9.97,9.92,9.89,9.86,9.78,9.71,9.60,9.48,9.35,9.23,9.12,9.03,8.98,8.90,8.86,8.78,8.71,8.60,8.47,8.29,8.12,7.92,7.74,7.54,7.37,7.23,7.08,6.92,6.77,6.62,6.47,6.27,6.09,5.88,5.67,5.48,5.25,5.01,4.77,4.54,4.33,4.10,3.87,3.67,3.50,3.36,3.23,3.10,2.99,2.87,2.75,2.62,2.50,2.37,2.25,2.14,2.08,2,1.91,1.86,1.74,1.59,1.37,1.21,1.10,1.10,1.21,1.53,1.57,1.25,1.07,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.96,0.96,0.95,0.95,0.91,0.83,0.62,0.34,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.07,0.09,0.12,0.11,0.09,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.01,0.01,0.01,0,0,0,0,0,0,0.02,0.03,0.02,0,0,0,0,0.01,0.02,0.03,0.03,0.03,0.08,0.16,0.34,15.22,15.14,15.09,15.02,15,15,15,15,14.99,14.99,14.97,14.91,14.87,14.79,14.72,14.62,14.52,14.48,14.47,14.49,14.51,14.57,14.59,14.60,14.61,14.62,14.65,14.71,14.75,14.79,14.85,14.87,14.87,14.88,14.87,14.83,14.77,14.71,14.62,14.50,14.38,14.26,14.14,14.03,13.91,13.79,13.66,13.52,13.38,13.25,13.15,13.08,13.01,13,12.98,12.98,12.97,12.97,12.96,12.96,12.96,12.96,12.95,12.95,12.95,12.92,12.91,12.89,12.87,12.85,12.78,12.73,12.65,12.59,12.49,12.39,12.32,12.24,12.17,12.14,12.13,12.12,12.12,12.11,12.09,12.04,12.02,12,12,11.99,11.98,11.97,11.97,11.97,11.97,11.96,11.95,11.91,11.88,11.84,11.77,11.71,11.62,11.52,11.45,11.36,11.26,11.21,11.13,11.09,11.04,11.02,11.01,11,11.01,11,11,11,10.99,10.98,10.98,10.98,10.97,10.97,10.96,10.96,10.96,10.95,10.95,10.95,10.92,10.92,10.92,10.90,10.89,10.86,10.78,10.71,10.60,10.47,10.34,10.22,10.12,10.03,9.99,9.95,9.90,9.87,9.84,9.76,9.67,9.58,9.46,9.33,9.22,9.12,9.03,8.98,8.91,8.87,8.82,8.74,8.63,8.51,8.37,8.20,8,7.82,7.62,7.42,7.25,7.09,6.91,6.75,6.59,6.39,6.20,5.99,5.75,5.52,5.28,5.07,4.83,4.59,4.35,4.11,3.88,3.70,3.50,3.36,3.23,3.11,3,2.87,2.75,2.62,2.49,2.36,2.23,2.12,2.03,1.98,1.89,1.77,1.66,1.51,1.37,1.21,1.09,1.02,1.03,1.14,1.25,1.25,1.13,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.91,0.87,0.82,0.82,0.85,0.78,0.62,0.34,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.08,0.10,0.12,0.15,0.16,0.16,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.03,0.01,0,0,0,0.02,0.10,0.12,0.10,0.02,0,0,0,0,0,0.01,0.01,0.02,0.09,0.20,0.35,15.08,15.04,15.02,15,15,15,15,15,14.99,14.99,14.97,14.95,14.87,14.76,14.65,14.52,14.42,14.36,14.33,14.34,14.37,14.39,14.42,14.45,14.47,14.50,14.54,14.61,14.67,14.75,14.78,14.84,14.86,14.86,14.84,14.79,14.75,14.67,14.61,14.50,14.38,14.27,14.16,14.04,13.95,13.82,13.66,13.52,13.38,13.25,13.15,13.08,13.01,13,12.98,12.98,12.97,12.97,12.96,12.96,12.96,12.95,12.95,12.95,12.92,12.91,12.90,12.87,12.85,12.78,12.73,12.64,12.57,12.48,12.38,12.29,12.22,12.15,12.11,12.09,12.09,12.09,12.08,12.07,12.03,12.01,12,12,11.99,11.98,11.98,11.97,11.97,11.97,11.97,11.95,11.91,11.88,11.85,11.78,11.72,11.62,11.54,11.48,11.39,11.34,11.26,11.22,11.15,11.11,11.08,11.03,11.02,11.01,11,11,11,10.99,10.99,10.98,10.98,10.98,10.97,10.97,10.96,10.96,10.95,10.95,10.95,10.92,10.92,10.91,10.90,10.89,10.87,10.83,10.75,10.66,10.57,10.42,10.29,10.20,10.10,10.02,9.98,9.92,9.88,9.85,9.78,9.73,9.63,9.52,9.40,9.28,9.20,9.10,9.02,8.97,8.91,8.87,8.83,8.75,8.65,8.53,8.39,8.24,8.04,7.86,7.64,7.46,7.25,7.08,6.88,6.71,6.51,6.32,6.10,5.86,5.61,5.36,5.11,4.86,4.61,4.37,4.12,3.89,3.70,3.50,3.35,3.22,3.11,3,2.89,2.77,2.64,2.50,2.36,2.24,2.12,2.02,1.96,1.87,1.75,1.60,1.45,1.28,1.20,1.09,1.01,1,1,1.02,1.04,1.03,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.87,0.71,0.57,0.57,0.70,0.74,0.62,0.34,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.08,0.11,0.12,0.12,0.12,0.15,0.24,0.20,0.14,0.11,0.12,0.12,0.09,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.13,0.12,0.01,0,0,0.03,0.11,0.20,0.12,0.03,0,0,0,0,0,0,0,0.02,0.09,0.21,0.36,15,15,15,15,15,15,15,15,14.99,14.99,14.97,14.92,14.87,14.76,14.62,14.47,14.35,14.25,14.22,14.21,14.23,14.25,14.28,14.32,14.35,14.38,14.45,14.51,14.61,14.70,14.75,14.78,14.83,14.83,14.78,14.75,14.70,14.62,14.53,14.46,14.36,14.25,14.15,14.07,13.95,13.83,13.67,13.52,13.38,13.25,13.14,13.08,13.01,13,12.98,12.98,12.97,12.97,12.96,12.96,12.95,12.95,12.95,12.92,12.91,12.90,12.87,12.85,12.78,12.73,12.64,12.57,12.48,12.37,12.28,12.21,12.13,12.10,12.07,12.04,12.04,12.04,12.04,12.03,12.01,12,12,11.99,11.98,11.98,11.97,11.97,11.97,11.96,11.96,11.92,11.89,11.86,11.78,11.72,11.63,11.54,11.49,11.42,11.37,11.34,11.28,11.25,11.21,11.15,11.12,11.08,11.03,11.01,11,11,10.99,10.98,10.98,10.98,10.98,10.98,10.97,10.97,10.96,10.96,10.95,10.95,10.92,10.92,10.91,10.89,10.89,10.87,10.84,10.77,10.72,10.62,10.50,10.38,10.26,10.15,10.08,10,9.95,9.89,9.87,9.82,9.75,9.66,9.59,9.48,9.37,9.25,9.15,9.08,9,8.96,8.90,8.87,8.82,8.75,8.65,8.53,8.39,8.24,8.03,7.85,7.63,7.42,7.24,7.03,6.84,6.63,6.41,6.21,5.96,5.70,5.42,5.15,4.88,4.63,4.37,4.13,3.89,3.70,3.50,3.34,3.21,3.10,3,2.90,2.78,2.65,2.51,2.37,2.24,2.12,2.01,1.95,1.87,1.75,1.59,1.37,1.23,1.12,1.07,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.78,0.50,0.21,0.15,0.37,0.71,0.53,0.33,0.13,0.02,0.01,0.01,0.01,0.01,0.02,0.02,0.01,0,0,0,0.01,0.07,0.11,0.14,0.14,0.12,0.10,0.12,0.23,0.25,0.24,0.20,0.20,0.20,0.16,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.13,0.48,0.14,0.02,0,0,0.02,0.09,0.11,0.09,0.02,0,0,0,0,0,0,0,0.01,0.08,0.20,0.35,15,15,15,15,15,15,15,15,14.99,14.99,14.97,14.92,14.87,14.75,14.59,14.40,14.25,14.16,14.12,14.11,14.12,14.14,14.16,14.20,14.24,14.27,14.36,14.45,14.52,14.62,14.70,14.75,14.77,14.77,14.74,14.67,14.61,14.52,14.46,14.37,14.32,14.23,14.14,14.04,13.96,13.83,13.70,13.53,13.38,13.25,13.14,13.08,13.01,13,12.98,12.98,12.97,12.97,12.96,12.96,12.95,12.95,12.92,12.91,12.90,12.88,12.85,12.78,12.73,12.64,12.57,12.47,12.37,12.27,12.21,12.12,12.09,12.04,12.02,12.02,12.03,12.04,12.03,12.02,12,12,11.99,11.99,11.98,11.98,11.97,11.97,11.97,11.95,11.95,11.90,11.86,11.79,11.72,11.62,11.53,11.48,11.41,11.38,11.37,11.36,11.35,11.33,11.27,11.24,11.17,11.12,11.08,11.02,11,11,10.99,10.98,10.98,10.97,10.97,10.97,10.97,10.97,10.96,10.96,10.95,10.95,10.92,10.91,10.89,10.87,10.87,10.83,10.77,10.72,10.63,10.53,10.42,10.33,10.22,10.11,10.02,9.97,9.90,9.87,9.83,9.76,9.67,9.61,9.50,9.40,9.32,9.22,9.12,9.04,9,8.95,8.89,8.85,8.78,8.72,8.62,8.50,8.36,8.17,8,7.79,7.59,7.37,7.16,6.96,6.75,6.52,6.29,6.04,5.77,5.50,5.22,4.92,4.65,4.39,4.14,3.90,3.70,3.50,3.33,3.20,3.09,3,2.89,2.79,2.66,2.52,2.37,2.24,2.12,2.01,1.92,1.85,1.75,1.59,1.37,1.21,1.09,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.96,0.75,0.37,-0.13,-0.33,0.02,0.29,0.45,0.34,0.23,0.12,0.09,0.07,0.04,0.07,0.07,0.07,0.04,0.03,0.01,0.01,0.03,0.09,0.13,0.20,0.21,0.20,0.16,0.20,0.26,0.35,0.34,0.26,0.24,0.24,0.25,0.24,0.17,0.10,0.04,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.13,0.12,0.01,0,0,0,0.02,0.03,0.02,0,0,0,0,0,0,0,0,0,0.04,0.16,0.34,15,15,15,15,15,15,15,15,14.99,14.99,14.97,14.92,14.87,14.74,14.58,14.38,14.23,14.11,14.03,14.02,14.03,14.07,14.09,14.11,14.13,14.20,14.26,14.36,14.47,14.58,14.62,14.70,14.72,14.71,14.64,14.59,14.50,14.42,14.36,14.29,14.24,14.17,14.12,14.03,13.96,13.84,13.70,13.54,13.39,13.26,13.14,13.08,13.01,13,12.98,12.98,12.97,12.97,12.96,12.96,12.95,12.95,12.92,12.90,12.88,12.86,12.79,12.74,12.64,12.57,12.47,12.37,12.27,12.20,12.12,12.08,12.03,12.01,12,12.01,12.02,12.03,12.02,12.01,12,12,11.99,11.98,11.98,11.98,11.97,11.96,11.96,11.92,11.91,11.87,11.79,11.73,11.62,11.52,11.45,11.38,11.36,11.36,11.37,11.38,11.39,11.39,11.37,11.32,11.25,11.16,11.11,11.04,11.01,11,10.98,10.98,10.97,10.97,10.97,10.97,10.97,10.97,10.96,10.96,10.95,10.95,10.91,10.90,10.87,10.85,10.82,10.76,10.71,10.62,10.53,10.45,10.35,10.24,10.13,10.04,9.98,9.90,9.87,9.82,9.76,9.70,9.62,9.52,9.42,9.35,9.25,9.16,9.10,9.02,8.97,8.91,8.87,8.82,8.75,8.65,8.57,8.42,8.27,8.11,7.90,7.71,7.50,7.27,7.07,6.84,6.62,6.37,6.12,5.85,5.57,5.26,4.99,4.70,4.41,4.15,3.90,3.70,3.50,3.34,3.17,3.08,2.99,2.88,2.78,2.66,2.53,2.38,2.25,2.12,2.01,1.92,1.84,1.72,1.58,1.37,1.21,1.09,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.96,0.76,0.37,-0.12,-0.49,-0.30,-0.08,0.16,0.33,0.25,0.21,0.16,0.12,0.10,0.09,0.10,0.10,0.09,0.07,0.04,0.03,0.07,0.11,0.15,0.22,0.25,0.27,0.29,0.33,0.35,0.40,0.33,0.14,0,0,0.12,0.29,0.24,0.21,0.16,0.12,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.04,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.14,0.33,15,15,15,15,15,15,15,15,15,14.99,14.97,14.92,14.87,14.74,14.58,14.37,14.22,14.10,14.02,14,14,14.01,14.03,14.07,14.10,14.13,14.21,14.28,14.38,14.49,14.54,14.61,14.62,14.60,14.53,14.48,14.39,14.33,14.25,14.22,14.16,14.13,14.10,14.02,13.95,13.84,13.71,13.57,13.40,13.27,13.15,13.09,13.02,13,12.99,12.98,12.97,12.97,12.96,12.96,12.95,12.95,12.91,12.89,12.87,12.82,12.75,12.65,12.57,12.47,12.37,12.26,12.20,12.12,12.08,12.02,12,12,12,12,12.01,12.02,12.02,12.01,12,11.99,11.98,11.98,11.98,11.97,11.96,11.95,11.92,11.90,11.87,11.82,11.73,11.62,11.52,11.41,11.35,11.29,11.28,11.32,11.36,11.40,11.45,11.46,11.45,11.38,11.32,11.22,11.13,11.08,11.01,10.99,10.98,10.97,10.97,10.97,10.96,10.96,10.96,10.96,10.96,10.96,10.95,10.92,10.90,10.87,10.85,10.79,10.75,10.67,10.61,10.51,10.42,10.34,10.24,10.13,10.03,9.97,9.89,9.85,9.78,9.75,9.67,9.61,9.52,9.45,9.36,9.26,9.20,9.12,9.04,9,8.95,8.88,8.85,8.77,8.71,8.60,8.49,8.34,8.16,7.99,7.78,7.58,7.36,7.13,6.90,6.66,6.42,6.15,5.88,5.61,5.29,5.01,4.73,4.45,4.16,3.92,3.70,3.50,3.34,3.20,3.09,2.98,2.88,2.78,2.66,2.53,2.38,2.25,2.12,2.02,1.92,1.83,1.71,1.54,1.38,1.21,1.09,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.96,0.79,0.50,0.07,-0.28,-0.48,-0.29,-0.05,0.10,0.21,0.25,0.25,0.21,0.12,0.11,0.10,0.10,0.09,0.09,0.08,0.07,0.09,0.11,0.14,0.21,0.26,0.35,0.40,0.42,0.35,0.28,0.10,-0.15,-0.34,-0.26,-0.03,0.14,0.22,0.24,0.23,0.22,0.12,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.09,0.09,0.04,0.04,0.13,0.33,15,15,15,15,15,15,15,15,15,14.99,14.97,14.92,14.87,14.75,14.58,14.37,14.21,14.10,14.02,14,14,14,14.01,14.03,14.07,14.10,14.14,14.23,14.32,14.38,14.46,14.50,14.50,14.48,14.42,14.37,14.28,14.23,14.16,14.13,14.11,14.09,14.07,14.01,13.95,13.85,13.72,13.58,13.42,13.28,13.17,13.10,13.03,13,12.99,12.98,12.97,12.97,12.96,12.96,12.95,12.92,12.90,12.87,12.84,12.75,12.66,12.58,12.47,12.37,12.26,12.17,12.12,12.07,12.02,12,12,12,12,12,12,12,12,12,12,11.99,11.98,11.97,11.97,11.96,11.95,11.91,11.89,11.86,11.83,11.74,11.63,11.52,11.41,11.33,11.25,11.23,11.23,11.26,11.34,11.39,11.46,11.48,11.47,11.41,11.34,11.25,11.14,11.08,11.01,10.99,10.98,10.97,10.96,10.96,10.96,10.96,10.96,10.96,10.95,10.95,10.92,10.91,10.88,10.86,10.79,10.75,10.67,10.60,10.50,10.39,10.29,10.21,10.12,10.01,9.92,9.87,9.79,9.75,9.71,9.63,9.58,9.50,9.42,9.36,9.27,9.21,9.12,9.07,9,8.97,8.90,8.86,8.79,8.73,8.63,8.51,8.38,8.23,8.04,7.85,7.63,7.41,7.20,6.96,6.72,6.47,6.21,5.91,5.62,5.35,5.03,4.74,4.46,4.17,3.92,3.71,3.50,3.34,3.20,3.09,2.98,2.88,2.78,2.66,2.53,2.38,2.25,2.12,2.01,1.92,1.83,1.71,1.54,1.38,1.24,1.08,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.87,0.72,0.37,-0.02,-0.35,-0.41,-0.33,-0.17,0,0.16,0.25,0.25,0.14,0.10,0.08,0.08,0.09,0.10,0.09,0.09,0.09,0.10,0.12,0.13,0.23,0.33,0.42,0.37,0.15,-0.13,-0.39,-0.63,-0.72,-0.50,-0.23,-0.02,0,0.09,0.15,0.25,0.17,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.07,0.07,0.07,0.07,0.09,0.17,0.28,0.28,0.17,0.10,0.14,0.35,15,15,15,15,15,15,15,15,15,14.99,14.97,14.95,14.87,14.75,14.58,14.37,14.21,14.10,14.02,14,14,14,14,14.01,14.02,14.07,14.10,14.15,14.24,14.29,14.35,14.38,14.38,14.36,14.32,14.25,14.21,14.14,14.11,14.08,14.07,14.04,14.02,14,13.92,13.85,13.73,13.60,13.47,13.34,13.22,13.12,13.07,13.01,13,12.99,12.98,12.97,12.96,12.96,12.95,12.91,12.88,12.85,12.77,12.70,12.60,12.49,12.37,12.26,12.17,12.12,12.07,12.02,12,12,11.99,11.99,12,12,12,12,12,12,11.99,11.98,11.98,11.97,11.95,11.92,11.90,11.87,11.85,11.77,11.73,11.62,11.51,11.40,11.29,11.23,11.16,11.14,11.15,11.22,11.27,11.36,11.40,11.46,11.45,11.40,11.33,11.24,11.14,11.08,11.01,10.98,10.97,10.96,10.95,10.95,10.95,10.95,10.95,10.95,10.92,10.92,10.91,10.89,10.86,10.79,10.74,10.66,10.59,10.49,10.37,10.27,10.16,10.08,9.98,9.88,9.82,9.75,9.67,9.63,9.58,9.52,9.47,9.40,9.34,9.26,9.20,9.12,9.08,9.01,8.98,8.92,8.88,8.84,8.75,8.67,8.58,8.42,8.27,8.11,7.89,7.70,7.47,7.24,6.99,6.74,6.49,6.22,5.96,5.65,5.36,5.04,4.75,4.47,4.17,3.92,3.71,3.50,3.35,3.21,3.09,2.99,2.88,2.77,2.66,2.53,2.38,2.25,2.12,2,1.90,1.79,1.70,1.53,1.38,1.24,1.12,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.92,0.87,0.70,0.25,-0.10,-0.26,-0.26,-0.27,-0.16,0.14,0.26,0.25,0.15,0.11,0.08,0.08,0.10,0.11,0.11,0.10,0.10,0.08,0.04,0.04,0.12,0.21,0.27,0.14,-0.18,-0.52,-1.83,-12,-11,-2.85,-2.54,-0.10,-0.17,-0.25,0.02,0.24,0.21,0.12,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.08,0.15,0.25,0.33,0.33,0.33,0.33,0.35,0.40,0.59,0.61,0.38,0.36,0.29,0.35,15,15,15,15,15,15,15,15,15,14.99,14.98,14.95,14.87,14.75,14.58,14.37,14.22,14.10,14.02,14,14,14,14,14,14,14.02,14.07,14.11,14.15,14.22,14.25,14.27,14.27,14.25,14.22,14.16,14.12,14.09,14.04,14.02,14.01,14.01,14,13.98,13.92,13.86,13.75,13.62,13.50,13.37,13.26,13.16,13.11,13.04,13.01,13,12.99,12.97,12.96,12.96,12.92,12.90,12.86,12.79,12.72,12.62,12.50,12.38,12.27,12.17,12.11,12.07,12.01,12,11.99,11.99,11.99,11.99,11.99,11.99,11.99,11.99,11.99,11.99,11.98,11.98,11.97,11.95,11.91,11.88,11.85,11.78,11.75,11.66,11.60,11.50,11.39,11.28,11.21,11.13,11.10,11.09,11.11,11.14,11.22,11.27,11.34,11.37,11.37,11.35,11.27,11.21,11.12,11.04,11,10.97,10.95,10.92,10.92,10.92,10.92,10.92,10.91,10.91,10.91,10.90,10.88,10.87,10.82,10.75,10.65,10.59,10.48,10.37,10.25,10.13,10.02,9.92,9.84,9.75,9.67,9.62,9.57,9.50,9.46,9.40,9.36,9.28,9.24,9.17,9.12,9.07,9.01,8.99,8.96,8.90,8.87,8.82,8.74,8.63,8.50,8.36,8.16,7.99,7.75,7.52,7.27,7.02,6.76,6.50,6.24,5.97,5.66,5.37,5.07,4.75,4.47,4.20,3.92,3.70,3.50,3.34,3.20,3.09,3,2.89,2.78,2.66,2.52,2.38,2.25,2.12,2,1.87,1.75,1.62,1.50,1.37,1.24,1.12,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.78,0.50,0.22,0.04,0.02,0.01,0.08,0.20,0.27,0.26,0.17,0.12,0.12,0.12,0.12,0.13,0.12,0.12,0.11,0.07,0,-0.03,-0.02,0.01,0,-0.18,-3.08,-6.28,-10,-19,-13,-7.15,-6.86,-0.25,-0.30,-0.25,0.04,0.27,0.24,0.13,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.14,0.25,0.34,0.42,0.57,0.65,0.70,0.72,0.73,0.72,0.76,0.83,0.79,0.74,0.63,0.62,0.35,15,15,15,15,15,15,15,15,15,14.99,14.98,14.95,14.87,14.75,14.59,14.38,14.22,14.11,14.03,14,14,14,14,14,14,14,14.02,14.07,14.11,14.13,14.15,14.17,14.16,14.15,14.12,14.10,14.07,14.02,14.01,14,14,14,13.99,13.97,13.92,13.87,13.77,13.66,13.57,13.45,13.34,13.25,13.15,13.11,13.07,13.01,13,12.98,12.97,12.95,12.91,12.87,12.83,12.75,12.64,12.52,12.40,12.29,12.20,12.12,12.07,12.01,12,11.99,11.98,11.98,11.98,11.98,11.99,11.99,11.99,11.99,11.99,11.99,11.98,11.97,11.96,11.91,11.88,11.84,11.76,11.70,11.62,11.52,11.46,11.36,11.26,11.20,11.12,11.08,11.03,11.03,11.04,11.10,11.13,11.20,11.24,11.26,11.27,11.25,11.21,11.13,11.09,11.01,10.98,10.95,10.91,10.90,10.89,10.89,10.89,10.89,10.89,10.88,10.88,10.87,10.85,10.79,10.75,10.65,10.59,10.48,10.35,10.23,10.12,10,9.89,9.79,9.71,9.62,9.54,9.49,9.42,9.38,9.34,9.28,9.25,9.21,9.14,9.10,9.04,9,8.98,8.95,8.90,8.87,8.84,8.76,8.67,8.57,8.40,8.24,8.02,7.82,7.58,7.33,7.04,6.78,6.51,6.24,5.96,5.66,5.37,5.09,4.77,4.49,4.21,3.95,3.71,3.50,3.33,3.20,3.09,2.99,2.89,2.79,2.66,2.52,2.38,2.25,2.12,1.99,1.86,1.72,1.58,1.42,1.32,1.21,1.12,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.87,0.72,0.57,0.49,0.48,0.42,0.39,0.37,0.35,0.27,0.22,0.17,0.16,0.16,0.16,0.15,0.14,0.13,0.11,0.04,-0.03,-0.13,-0.15,-0.15,-4.74,-10,-11,-10,-20,-19,-7.29,-8.15,-4.79,-0.42,-0.35,-0.01,0.24,0.37,0.25,0.12,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.03,0.15,0.36,0.57,0.65,0.76,0.87,0.99,1.10,1.17,1.25,1.17,1.11,1.01,1,0.97,0.91,0.83,0.83,15,15,15,15,15,15,15,15,15,15,14.98,14.96,14.88,14.75,14.59,14.39,14.24,14.12,14.04,14.01,14,14,14,14,14,14,14.01,14.03,14.07,14.09,14.10,14.11,14.10,14.09,14.07,14.03,14.01,14,14,13.99,13.99,13.99,13.98,13.97,13.92,13.87,13.82,13.73,13.62,13.52,13.41,13.34,13.25,13.16,13.11,13.07,13.01,12.99,12.97,12.95,12.89,12.86,12.77,12.67,12.58,12.46,12.34,12.23,12.13,12.08,12.02,12,11.99,11.98,11.97,11.98,11.98,11.98,11.98,11.98,11.98,11.98,11.98,11.98,11.97,11.96,11.92,11.88,11.83,11.75,11.65,11.57,11.48,11.38,11.29,11.23,11.15,11.11,11.07,11.02,11,11,11.01,11.03,11.08,11.11,11.13,11.16,11.16,11.15,11.12,11.08,11.01,10.98,10.92,10.90,10.87,10.87,10.86,10.85,10.85,10.85,10.85,10.84,10.84,10.82,10.77,10.73,10.64,10.58,10.46,10.34,10.22,10.09,9.98,9.87,9.76,9.66,9.58,9.49,9.41,9.37,9.32,9.26,9.23,9.20,9.14,9.12,9.08,9.02,9,8.97,8.92,8.89,8.87,8.82,8.76,8.70,8.59,8.45,8.27,8.08,7.86,7.62,7.36,7.09,6.82,6.52,6.24,5.96,5.65,5.37,5.09,4.79,4.50,4.23,3.97,3.73,3.50,3.34,3.20,3.08,2.99,2.88,2.78,2.66,2.53,2.38,2.24,2.11,1.99,1.86,1.71,1.53,1.37,1.24,1.13,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.98,0.98,0.97,0.98,0.98,0.97,0.91,0.86,0.79,0.74,0.67,0.62,0.50,0.37,0.29,0.25,0.23,0.22,0.22,0.21,0.16,0.13,0.12,0.11,0.09,0.01,-0.09,-1.13,-4.04,-12,-14,-10,-9.16,-10,-17,-14,-9.71,-6.32,-0.61,-0.73,-0.25,0.15,0.52,0.42,0.25,0.10,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.10,0.14,0.16,0.36,0.62,0.82,0.96,1.09,1.22,1.33,1.42,1.64,1.75,1.64,1.42,1.34,1.25,1.13,1.01,0.98,0.95,15,15,15,15,15,15,15,15,15,15,14.99,14.96,14.88,14.76,14.60,14.41,14.25,14.13,14.08,14.02,14,14,14,14,14,14,14,14.01,14.02,14.04,14.04,14.04,14.03,14.02,14.01,14,14,14,13.99,13.99,13.98,13.98,13.98,13.96,13.92,13.89,13.85,13.77,13.70,13.61,13.51,13.42,13.34,13.25,13.16,13.11,13.07,13.01,12.98,12.92,12.88,12.83,12.74,12.62,12.50,12.38,12.26,12.16,12.10,12.03,12,11.99,11.98,11.97,11.97,11.97,11.97,11.97,11.98,11.98,11.98,11.98,11.98,11.97,11.96,11.92,11.89,11.84,11.75,11.64,11.53,11.42,11.34,11.25,11.17,11.12,11.09,11.04,11.01,11,11,11,11,11,11.02,11.04,11.07,11.08,11.09,11.07,11.03,11,10.96,10.90,10.87,10.85,10.83,10.79,10.77,10.76,10.75,10.75,10.75,10.75,10.75,10.73,10.67,10.62,10.53,10.42,10.33,10.20,10.08,9.96,9.84,9.74,9.62,9.53,9.46,9.37,9.29,9.25,9.21,9.15,9.12,9.10,9.07,9.02,9,8.97,8.92,8.90,8.87,8.85,8.79,8.75,8.66,8.60,8.47,8.32,8.12,7.88,7.64,7.38,7.12,6.84,6.53,6.25,5.95,5.64,5.37,5.09,4.79,4.51,4.25,4,3.75,3.52,3.35,3.21,3.09,2.99,2.88,2.78,2.66,2.52,2.37,2.24,2.11,1.99,1.87,1.72,1.53,1.37,1.22,1.11,1.03,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.95,0.95,0.95,0.92,0.91,0.89,0.87,0.79,0.64,0.41,0.24,0.13,0.12,0.16,0.21,0.23,0.22,0.17,0.12,0.08,0.03,0.02,0,-0.04,-2.05,-8.42,-9.37,-12,-9.79,-0.38,-0.63,-6.09,-8.53,-5.49,-5.27,-3.04,-0.50,-0.30,-0.04,0.26,0.40,0.36,0.17,0.07,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.12,0.23,0.33,0.40,0.62,0.83,0.99,1.14,1.36,1.57,1.64,1.75,1.96,2.57,1.99,1.82,1.72,1.60,1.37,1.16,1.04,1.01,15,15,15,15,15,15,15,15,15,15,14.99,14.96,14.89,14.77,14.62,14.46,14.28,14.15,14.09,14.03,14,14,14,14,14,14,14,14,14.01,14.01,14.01,14.01,14,14,14,14,14,14,13.99,13.99,13.98,13.98,13.97,13.96,13.95,13.90,13.87,13.83,13.76,13.70,13.62,13.52,13.42,13.35,13.25,13.16,13.11,13.04,13,12.95,12.87,12.79,12.71,12.59,12.46,12.34,12.23,12.12,12.07,12.01,11.99,11.98,11.97,11.97,11.97,11.97,11.97,11.97,11.97,11.97,11.97,11.97,11.97,11.96,11.92,11.89,11.85,11.76,11.65,11.53,11.41,11.29,11.22,11.13,11.10,11.04,11.02,11,11,11,10.99,10.99,10.99,10.99,11,11,11,11,11,11,10.97,10.92,10.88,10.84,10.79,10.75,10.73,10.71,10.67,10.66,10.65,10.64,10.64,10.63,10.62,10.61,10.57,10.49,10.39,10.27,10.16,10.04,9.91,9.82,9.70,9.60,9.50,9.40,9.34,9.25,9.21,9.14,9.11,9.08,9.04,9.01,9,8.97,8.92,8.89,8.87,8.85,8.82,8.77,8.73,8.64,8.57,8.45,8.32,8.13,7.91,7.67,7.41,7.14,6.86,6.54,6.25,5.95,5.63,5.35,5.07,4.78,4.51,4.25,4.01,3.77,3.58,3.37,3.23,3.10,2.99,2.88,2.77,2.65,2.52,2.37,2.23,2.10,1.99,1.86,1.74,1.57,1.37,1.23,1.11,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.96,0.92,0.89,0.85,0.78,0.75,0.72,0.71,0.67,0.57,0.32,-0.04,-0.28,-0.35,-0.22,-0.02,0.12,0.17,0.16,0.12,0.02,-0.03,-0.08,-0.09,-0.10,-5.10,-7.08,-7.46,-5.46,-0.04,0,-0.10,-0.29,-0.55,-3.08,-3.38,-0.79,-0.42,-0.13,0.04,0.17,0.28,0.28,0.21,0.09,0.01,0,0,0,0,0,0,0,0,0,0.01,0.07,0.14,0.26,0.40,0.57,0.73,0.87,1,1.15,1.36,1.62,1.79,1.90,1.96,2.11,2.24,2.32,2.27,2.25,2.08,1.77,1.38,1.26,1.13,15,15,15,15,15,15,15,15,15,15,15,14.98,14.90,14.82,14.65,14.49,14.32,14.17,14.10,14.03,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.98,13.97,13.96,13.95,13.92,13.89,13.87,13.83,13.75,13.70,13.62,13.52,13.45,13.35,13.25,13.16,13.10,13.02,12.96,12.87,12.77,12.66,12.54,12.41,12.29,12.20,12.11,12.04,12,11.99,11.98,11.97,11.97,11.97,11.96,11.96,11.96,11.97,11.97,11.97,11.96,11.95,11.92,11.89,11.85,11.77,11.66,11.54,11.42,11.32,11.21,11.12,11.07,11.02,11.01,11,11,11,11,10.99,10.99,10.98,10.98,10.98,10.98,10.98,10.97,10.96,10.92,10.89,10.86,10.79,10.75,10.71,10.65,10.62,10.59,10.57,10.54,10.53,10.52,10.51,10.50,10.50,10.47,10.40,10.34,10.25,10.13,10.01,9.88,9.76,9.65,9.54,9.47,9.37,9.29,9.23,9.15,9.11,9.08,9.02,9,8.99,8.96,8.92,8.89,8.87,8.84,8.79,8.76,8.74,8.67,8.61,8.52,8.41,8.27,8.12,7.90,7.71,7.45,7.16,6.87,6.58,6.25,5.96,5.63,5.34,5.04,4.76,4.50,4.25,4.02,3.79,3.60,3.40,3.25,3.11,3,2.88,2.77,2.65,2.51,2.37,2.24,2.11,1.98,1.86,1.72,1.57,1.38,1.23,1.11,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.92,0.88,0.79,0.66,0.48,0.34,0.25,0.22,0.21,0.10,-0.15,-0.51,-0.84,-0.77,-0.54,-0.26,-0.04,0.08,0.10,0.03,-0.04,-0.13,-0.16,-2.39,-6.37,-9.13,-5.18,-0.13,0,0.15,0.25,0.25,0.08,-0.15,-0.38,-0.50,-0.33,-0.02,0.17,0.25,0.23,0.21,0.14,0.09,0.02,0,0,0,0,0,0,0,0,0,0.01,0.07,0.14,0.27,0.47,0.64,0.84,1,1.12,1.25,1.42,1.62,1.82,1.95,1.98,2,2.04,2.20,2.57,2.57,2.62,2.59,2.21,1.89,1.62,1.37,15,15,15,15,15,15,15,15,15,15,15,14.98,14.95,14.85,14.70,14.51,14.35,14.20,14.10,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.98,13.97,13.97,13.96,13.95,13.91,13.89,13.87,13.83,13.75,13.70,13.62,13.52,13.42,13.34,13.25,13.14,13.07,12.98,12.87,12.77,12.65,12.53,12.40,12.28,12.17,12.10,12.03,12,11.99,11.98,11.97,11.96,11.96,11.96,11.96,11.96,11.96,11.96,11.95,11.92,11.90,11.87,11.84,11.76,11.67,11.58,11.45,11.33,11.22,11.12,11.07,11.01,11,11,11,11,11,11,10.99,10.99,10.98,10.98,10.98,10.97,10.96,10.95,10.90,10.87,10.85,10.78,10.74,10.65,10.60,10.53,10.49,10.46,10.42,10.41,10.40,10.39,10.38,10.37,10.36,10.32,10.25,10.17,10.10,9.98,9.86,9.74,9.62,9.50,9.41,9.34,9.25,9.20,9.12,9.09,9.02,9,8.98,8.95,8.91,8.89,8.87,8.84,8.79,8.76,8.73,8.66,8.62,8.54,8.48,8.37,8.25,8.09,7.90,7.70,7.45,7.20,6.88,6.59,6.26,5.96,5.63,5.34,5.03,4.75,4.50,4.25,4.01,3.82,3.62,3.42,3.26,3.12,3,2.88,2.77,2.64,2.51,2.37,2.24,2.11,1.98,1.87,1.73,1.57,1.38,1.23,1.11,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.90,0.83,0.67,0.40,0.08,-0.26,-0.48,-0.53,-0.96,-1.33,-1.63,-2.16,-2.67,-2.21,-1.24,-0.51,-0.25,-0.10,-0.02,-0.03,-0.21,-1.17,-8.17,-10,-7.37,-4.20,-0.18,-0.05,0.14,0.35,0.48,0.50,0.37,0.20,0.04,0.07,0.12,0.24,0.27,0.24,0.15,0.10,0.04,0.01,0,0,0,0,0,0,0,0,0,0.01,0.07,0.14,0.27,0.48,0.71,0.92,1.13,1.33,1.40,1.57,1.72,1.84,1.95,1.98,2,2,2.02,2.15,2.42,2.74,2.91,2.87,2.63,2.38,2.07,1.67,15,15,15,15,15,15,15,15,15,15,15,14.99,14.96,14.87,14.74,14.53,14.36,14.20,14.09,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.98,13.97,13.97,13.96,13.95,13.92,13.90,13.88,13.86,13.82,13.75,13.67,13.61,13.51,13.41,13.32,13.22,13.12,13,12.89,12.78,12.65,12.52,12.39,12.27,12.16,12.10,12.02,12,11.99,11.98,11.97,11.96,11.96,11.96,11.96,11.95,11.95,11.95,11.91,11.89,11.87,11.82,11.75,11.66,11.58,11.46,11.35,11.24,11.13,11.08,11.02,11,11,11,11,11,11,11,10.99,10.99,10.98,10.98,10.97,10.96,10.95,10.90,10.87,10.85,10.77,10.72,10.63,10.54,10.48,10.40,10.37,10.34,10.29,10.28,10.27,10.26,10.25,10.24,10.21,10.15,10.11,10.02,9.95,9.83,9.71,9.59,9.48,9.37,9.28,9.22,9.14,9.10,9.04,9,8.98,8.95,8.90,8.88,8.87,8.84,8.79,8.76,8.73,8.66,8.62,8.54,8.49,8.39,8.28,8.16,8.01,7.87,7.66,7.45,7.17,6.89,6.61,6.27,5.97,5.64,5.35,5.03,4.75,4.50,4.25,4.01,3.82,3.62,3.45,3.28,3.14,3.01,2.89,2.77,2.64,2.51,2.37,2.24,2.11,1.98,1.85,1.72,1.57,1.39,1.24,1.10,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.96,0.92,0.87,0.75,0.54,0.15,-0.33,-0.85,-1.25,-2.39,-3.17,-3.73,-4.03,-4.21,-4.15,-3.99,-3.34,-2.63,-2,-1.33,-1,-1.28,-8.98,-10,-11,-9.21,-1.22,-0.25,-0.15,0.02,0.25,0.46,0.59,0.61,0.53,0.41,0.34,0.36,0.32,0.27,0.21,0.12,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.13,0.27,0.48,0.72,0.98,1.23,1.46,1.64,1.74,1.83,1.91,1.97,2.01,2.04,2.07,2.07,2.09,2.21,2.42,2.87,3.15,3.20,2.98,2.74,2.62,1.99,15,15,15,15,15,15,15,15,15,15,15,14.99,14.98,14.89,14.76,14.57,14.37,14.20,14.09,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.98,13.97,13.97,13.96,13.96,13.95,13.92,13.90,13.88,13.86,13.79,13.75,13.66,13.59,13.49,13.37,13.26,13.14,13.03,12.91,12.79,12.66,12.53,12.40,12.27,12.17,12.10,12.03,12,11.99,11.98,11.97,11.96,11.96,11.96,11.95,11.92,11.92,11.90,11.88,11.85,11.79,11.73,11.64,11.54,11.46,11.35,11.25,11.15,11.10,11.04,11.01,11,11,11,11,11,11,10.99,10.99,10.99,10.98,10.98,10.97,10.95,10.91,10.88,10.86,10.78,10.72,10.63,10.53,10.45,10.37,10.29,10.25,10.22,10.20,10.17,10.16,10.15,10.13,10.12,10.09,10.02,9.97,9.88,9.78,9.67,9.57,9.46,9.35,9.25,9.17,9.12,9.07,9.01,8.98,8.95,8.90,8.88,8.86,8.84,8.79,8.76,8.73,8.66,8.62,8.57,8.49,8.40,8.32,8.21,8.09,7.92,7.77,7.60,7.39,7.15,6.89,6.61,6.28,5.99,5.65,5.35,5.03,4.75,4.49,4.25,4.01,3.82,3.62,3.45,3.28,3.14,3.02,2.89,2.77,2.64,2.51,2.37,2.24,2.11,1.98,1.85,1.71,1.54,1.39,1.24,1.12,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.97,0.96,0.91,0.85,0.70,0.40,-0.03,-0.60,-1.25,-2.64,-4.09,-5.27,-5.96,-6.15,-6.09,-5.85,-5.50,-5.21,-4.53,-4.04,-3.83,-6.52,-7.49,-14,-12,-3.10,-1.18,-0.24,-0.21,-0.10,0.10,0.32,0.50,0.62,0.63,0.59,0.50,0.40,0.38,0.28,0.20,0.12,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0.04,0.12,0.25,0.45,0.70,0.97,1.24,1.50,1.72,1.91,1.97,2.01,2.04,2.08,2.15,2.25,2.33,2.33,2.37,2.42,2.72,3.03,3.59,3.61,3.12,2.97,2.78,2.64,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.91,14.77,14.59,14.37,14.20,14.08,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14.01,14,14,14,14,13.99,13.99,13.98,13.98,13.97,13.97,13.96,13.96,13.95,13.92,13.91,13.89,13.87,13.84,13.77,13.72,13.62,13.52,13.42,13.32,13.20,13.08,12.95,12.83,12.70,12.54,12.41,12.29,12.20,12.11,12.03,12,11.99,11.98,11.97,11.96,11.96,11.95,11.92,11.92,11.90,11.88,11.85,11.77,11.72,11.62,11.52,11.42,11.34,11.25,11.16,11.11,11.07,11.02,11,11,11,11,11,11,10.99,10.99,10.99,10.99,10.98,10.97,10.96,10.92,10.89,10.87,10.79,10.73,10.63,10.53,10.45,10.35,10.26,10.21,10.15,10.12,10.12,10.10,10.09,10.08,10.04,10.01,9.98,9.90,9.85,9.75,9.64,9.53,9.42,9.33,9.23,9.14,9.09,9.02,8.99,8.95,8.90,8.88,8.86,8.83,8.78,8.75,8.73,8.66,8.62,8.57,8.49,8.40,8.33,8.23,8.12,7.99,7.85,7.70,7.50,7.33,7.11,6.87,6.60,6.32,6,5.67,5.37,5.04,4.76,4.50,4.25,4.01,3.82,3.62,3.45,3.28,3.15,3.02,2.89,2.77,2.64,2.51,2.37,2.25,2.12,1.99,1.85,1.71,1.54,1.39,1.24,1.12,1.03,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.97,0.96,0.96,0.95,0.90,0.83,0.62,0.32,-0.16,-0.75,-1.43,-3.64,-5.55,-6.99,-7.72,-7.80,-7.58,-7.18,-6.79,-6.64,-5.97,-5.79,-5.91,-9.02,-8.27,-5.83,-3.13,-0.13,-0.15,-0.15,-0.13,-0.01,0.14,0.35,0.50,0.60,0.61,0.54,0.47,0.37,0.28,0.17,0.10,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0.02,0.10,0.21,0.37,0.62,0.89,1.17,1.46,1.70,1.88,2.02,2.14,2.25,2.36,2.40,2.42,2.63,2.73,2.73,2.83,2.99,3.12,3.25,3.29,3.29,3.17,3.03,2.92,2.64,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.98,14.92,14.77,14.58,14.36,14.17,14.08,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.98,13.97,13.97,13.96,13.96,13.95,13.95,13.91,13.90,13.88,13.85,13.79,13.74,13.65,13.57,13.46,13.34,13.22,13.10,12.97,12.84,12.71,12.58,12.45,12.32,12.21,12.12,12.04,12,11.99,11.98,11.97,11.96,11.96,11.95,11.92,11.91,11.88,11.85,11.77,11.71,11.62,11.51,11.40,11.32,11.23,11.15,11.10,11.07,11.03,11.01,11,11,11,11,11,10.99,10.99,10.99,10.99,10.98,10.98,10.97,10.95,10.90,10.87,10.82,10.75,10.65,10.57,10.46,10.36,10.26,10.20,10.12,10.10,10.07,10.04,10.03,10.01,10,9.97,9.92,9.87,9.79,9.72,9.62,9.51,9.40,9.32,9.22,9.12,9.04,9,8.96,8.90,8.87,8.85,8.82,8.77,8.75,8.72,8.66,8.62,8.54,8.49,8.40,8.33,8.24,8.12,8.01,7.88,7.75,7.60,7.41,7.24,7.02,6.82,6.57,6.29,6.01,5.71,5.39,5.09,4.77,4.50,4.25,4.01,3.82,3.62,3.45,3.28,3.15,3.02,2.89,2.77,2.64,2.51,2.37,2.25,2.12,1.99,1.86,1.71,1.54,1.39,1.25,1.12,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.96,0.96,0.95,0.92,0.91,0.87,0.77,0.60,0.25,-0.25,-0.88,-2.02,-4.50,-6.52,-7.97,-8.63,-8.67,-8.37,-7.90,-7.47,-7.38,-6.52,-6.24,-6.26,-6.46,-3.49,-1.03,-0.13,-0.09,-0.08,-0.04,0,0.09,0.23,0.37,0.49,0.53,0.52,0.48,0.38,0.28,0.17,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.15,0.29,0.50,0.76,1.07,1.35,1.61,1.83,2,2.15,2.39,2.71,2.96,3.11,3.23,3.27,3.34,3.35,3.40,3.59,3.61,3.38,3.38,3.37,3.27,3.14,2.97,2.66,15,15,15,15,15,15,15,15,15,14.99,14.99,14.99,14.97,14.90,14.77,14.52,14.33,14.14,14.04,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.98,13.97,13.96,13.95,13.95,13.92,13.91,13.89,13.87,13.85,13.78,13.74,13.65,13.57,13.47,13.35,13.23,13.10,12.98,12.86,12.73,12.60,12.47,12.34,12.23,12.13,12.07,12.01,11.99,11.98,11.97,11.96,11.96,11.92,11.91,11.89,11.86,11.78,11.72,11.62,11.51,11.40,11.32,11.22,11.14,11.10,11.04,11.02,11.01,11,11,11,11,11,11,10.99,10.99,10.99,10.98,10.98,10.97,10.96,10.91,10.88,10.83,10.75,10.66,10.58,10.48,10.37,10.28,10.21,10.13,10.09,10.04,10.01,10,9.99,9.98,9.95,9.89,9.85,9.77,9.71,9.61,9.50,9.39,9.29,9.21,9.12,9.03,8.98,8.91,8.87,8.84,8.78,8.75,8.73,8.70,8.64,8.61,8.53,8.48,8.39,8.32,8.23,8.12,8.01,7.89,7.77,7.63,7.49,7.33,7.13,6.95,6.74,6.51,6.26,6,5.73,5.42,5.12,4.83,4.52,4.26,4.02,3.82,3.62,3.45,3.28,3.14,3.01,2.89,2.77,2.64,2.51,2.37,2.25,2.12,1.99,1.86,1.71,1.54,1.39,1.25,1.13,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.98,0.99,0.99,0.99,0.98,0.98,0.97,0.99,0.99,0.98,0.98,0.97,0.96,0.96,0.96,0.97,0.97,0.96,0.95,0.92,0.91,0.89,0.87,0.83,0.73,0.51,0.21,-0.30,-1.47,-3.16,-5.33,-7.09,-8.27,-8.79,-8.75,-8.37,-7.85,-7.30,-7.10,-6.05,-5.27,-4.66,-4.24,-2,-0.50,-0.05,0,0.04,0.10,0.13,0.21,0.29,0.38,0.46,0.48,0.45,0.37,0.28,0.21,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.11,0.22,0.38,0.61,0.87,1.14,1.40,1.64,1.87,2.09,2.36,2.74,3.23,3.77,4.14,4.27,4.21,4.10,4.11,4.26,4.37,4.32,4.02,3.82,3.70,3.62,3.26,3,2.66,15,15,15,15,15,15,15,15,15,14.99,14.99,14.98,14.95,14.86,14.70,14.48,14.25,14.12,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.99,13.99,13.98,13.98,13.96,13.95,13.92,13.91,13.90,13.88,13.87,13.85,13.82,13.75,13.71,13.62,13.53,13.45,13.34,13.22,13.10,12.98,12.87,12.74,12.62,12.49,12.36,12.25,12.14,12.08,12.02,12,11.98,11.97,11.96,11.95,11.92,11.91,11.87,11.83,11.75,11.64,11.52,11.41,11.32,11.23,11.13,11.09,11.03,11.01,11,11,11,11,11,11,11,11,10.99,10.99,10.99,10.98,10.98,10.96,10.95,10.90,10.84,10.76,10.66,10.58,10.49,10.39,10.33,10.24,10.16,10.11,10.04,10.01,10,9.98,9.96,9.92,9.87,9.84,9.76,9.67,9.60,9.50,9.38,9.28,9.20,9.11,9.02,8.96,8.89,8.85,8.78,8.75,8.71,8.65,8.62,8.58,8.52,8.47,8.39,8.32,8.22,8.12,8,7.89,7.77,7.64,7.51,7.37,7.22,7.03,6.86,6.65,6.46,6.23,5.99,5.74,5.47,5.16,4.87,4.59,4.29,4.04,3.83,3.62,3.45,3.28,3.14,3.01,2.89,2.77,2.64,2.51,2.37,2.25,2.12,1.99,1.85,1.71,1.54,1.39,1.25,1.13,1.04,1,0.99,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.92,0.89,0.88,0.92,0.92,0.89,0.87,0.86,0.87,0.91,0.95,0.95,0.95,0.91,0.88,0.86,0.82,0.77,0.72,0.61,0.40,0.09,-0.47,-2.84,-4.66,-6.11,-7.36,-8.15,-8.40,-8.21,-7.71,-7.08,-6.39,-5.88,-4.76,-3.65,-2.65,-1.28,-0.50,-0.04,0.04,0.13,0.21,0.25,0.28,0.34,0.38,0.41,0.45,0.41,0.37,0.28,0.21,0.12,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.14,0.27,0.46,0.66,0.91,1.16,1.40,1.64,1.88,2.12,2.50,3.03,3.73,4.47,5.53,5.57,5.21,5.10,5.12,5.21,5.60,5.10,4.75,4.37,4.20,3.87,3.35,3.11,2.70,15,15,15,15,15,15,15,15,15,14.99,14.99,14.96,14.87,14.74,14.53,14.34,14.16,14.08,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.99,13.99,13.99,13.99,13.99,13.98,13.97,13.96,13.92,13.90,13.88,13.87,13.85,13.82,13.77,13.75,13.71,13.64,13.59,13.50,13.40,13.29,13.20,13.09,12.98,12.87,12.75,12.62,12.50,12.38,12.26,12.16,12.10,12.02,12,11.98,11.97,11.96,11.95,11.91,11.90,11.86,11.78,11.70,11.58,11.46,11.34,11.24,11.14,11.09,11.03,11,11,11,11,11,11,11,11,11,10.99,10.99,10.99,10.98,10.98,10.98,10.97,10.92,10.87,10.78,10.67,10.58,10.48,10.39,10.34,10.26,10.21,10.14,10.10,10.03,10,9.98,9.95,9.90,9.87,9.82,9.75,9.66,9.59,9.49,9.37,9.27,9.17,9.10,9.01,8.95,8.87,8.82,8.75,8.71,8.64,8.61,8.54,8.50,8.45,8.38,8.32,8.23,8.12,8,7.88,7.76,7.63,7.51,7.38,7.25,7.10,6.95,6.76,6.59,6.38,6.17,5.96,5.73,5.47,5.21,4.91,4.63,4.37,4.11,3.86,3.63,3.46,3.28,3.14,3.01,2.89,2.76,2.64,2.51,2.37,2.25,2.12,1.98,1.85,1.71,1.54,1.38,1.25,1.13,1.04,1,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.97,0.98,0.98,0.98,0.97,0.95,0.89,0.84,0.64,0.52,0.64,0.67,0.67,0.51,0.57,0.74,0.79,0.87,0.90,0.90,0.87,0.82,0.74,0.66,0.61,0.52,0.39,0.14,-1.03,-2.75,-4.38,-5.96,-6.88,-7.62,-7.92,-7.83,-7.35,-6.63,-5.78,-4.93,-4.14,-3.12,-1.91,-1.08,-0.09,0,0.11,0.21,0.28,0.37,0.40,0.45,0.46,0.47,0.46,0.41,0.37,0.29,0.23,0.14,0.09,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.10,0.20,0.34,0.50,0.72,0.92,1.15,1.38,1.62,1.87,2.21,2.66,3.35,4.17,5.09,5.74,6.08,6.13,6.17,6.26,6.27,6.08,5.79,5.62,5.08,4.67,4.27,3.67,3.21,2.70,15,15,15,15,15,15,15,15,15,14.99,14.92,14.86,14.72,14.53,14.37,14.22,14.11,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.99,13.99,13.98,13.98,13.98,13.97,13.96,13.92,13.90,13.87,13.84,13.79,13.76,13.74,13.70,13.65,13.62,13.57,13.50,13.42,13.35,13.25,13.15,13.07,12.97,12.87,12.76,12.64,12.52,12.40,12.28,12.20,12.11,12.03,12,11.99,11.98,11.96,11.95,11.92,11.88,11.84,11.75,11.63,11.51,11.38,11.26,11.16,11.10,11.03,11.01,11,11,11,11,11,11,10.99,10.99,10.99,10.99,10.99,10.99,10.99,10.98,10.97,10.96,10.92,10.85,10.72,10.58,10.45,10.36,10.29,10.26,10.23,10.17,10.12,10.08,10.02,9.99,9.96,9.91,9.87,9.83,9.75,9.66,9.58,9.48,9.37,9.27,9.17,9.09,9,8.91,8.85,8.76,8.72,8.64,8.60,8.53,8.48,8.41,8.37,8.29,8.23,8.13,8.02,7.90,7.77,7.64,7.50,7.37,7.25,7.12,6.98,6.84,6.66,6.50,6.33,6.12,5.91,5.70,5.47,5.22,4.96,4.70,4.40,4.14,3.89,3.66,3.48,3.29,3.14,3.01,2.89,2.76,2.64,2.51,2.38,2.25,2.12,1.99,1.85,1.70,1.53,1.38,1.25,1.13,1.04,1,0.98,0.97,0.97,0.97,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.96,0.95,0.95,0.92,0.90,0.90,0.92,0.92,0.92,0.87,0.66,0.45,0.27,-0.40,-0.52,-0.66,-0.68,-0.59,0.37,0.36,0.58,0.78,0.87,0.86,0.77,0.66,0.54,0.45,0.35,0.25,0.11,-1.41,-3,-4.51,-5.98,-7.14,-7.86,-7.90,-7.75,-7.24,-6.39,-5.33,-4.23,-3.22,-2.26,-1.48,-0.62,0,0.12,0.21,0.27,0.37,0.45,0.50,0.54,0.57,0.54,0.51,0.48,0.40,0.34,0.25,0.16,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.12,0.24,0.37,0.57,0.75,0.92,1.13,1.35,1.61,1.88,2.33,2.89,3.66,4.61,5.61,6.34,6.74,6.88,7.14,7.57,7.59,6.72,6.24,5.74,5.36,5.64,4.66,3.87,3.27,2.72,15,15,15,15,15,15,15,14.99,14.98,14.95,14.87,14.74,14.54,14.37,14.23,14.12,14.04,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.98,13.98,13.98,13.98,13.98,13.97,13.96,13.92,13.89,13.87,13.82,13.75,13.71,13.65,13.62,13.59,13.54,13.50,13.47,13.40,13.35,13.27,13.21,13.12,13.03,12.96,12.87,12.76,12.66,12.54,12.42,12.33,12.22,12.12,12.04,12,11.99,11.97,11.96,11.95,11.91,11.87,11.82,11.73,11.60,11.47,11.34,11.22,11.12,11.04,11.01,11,11,11,11,11,11,11,10.99,10.99,10.99,10.99,10.99,10.99,10.98,10.99,10.97,10.92,10.87,10.74,10.58,10.42,10.33,10.25,10.22,10.20,10.17,10.14,10.11,10.07,10,9.97,9.92,9.88,9.84,9.75,9.66,9.58,9.48,9.37,9.27,9.17,9.09,8.99,8.89,8.83,8.75,8.65,8.60,8.52,8.48,8.40,8.36,8.28,8.23,8.14,8.07,7.97,7.84,7.71,7.54,7.39,7.25,7.11,6.98,6.85,6.72,6.58,6.41,6.25,6.08,5.87,5.66,5.45,5.22,4.98,4.72,4.46,4.20,3.95,3.72,3.50,3.32,3.15,3.01,2.89,2.76,2.64,2.52,2.39,2.26,2.12,2,1.86,1.72,1.54,1.39,1.25,1.13,1.04,1,0.97,0.95,0.95,0.95,0.95,0.97,0.97,0.97,0.97,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.96,0.92,0.89,0.87,0.86,0.84,0.79,0.76,0.73,0.78,0.83,0.77,0.41,-0.09,-0.18,0.28,0.41,0.54,0.66,-0.63,-0.46,-0.26,0.37,0.71,0.82,0.76,0.63,0.48,0.28,0.12,0,-0.15,-1.25,-2.92,-4.51,-5.92,-7.11,-7.97,-8.60,-8.46,-7.77,-6.85,-5.49,-4,-2.25,-1.30,-0.64,0.04,0.22,0.27,0.34,0.37,0.45,0.50,0.58,0.62,0.64,0.64,0.62,0.57,0.49,0.39,0.29,0.22,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.14,0.27,0.42,0.60,0.76,0.95,1.12,1.33,1.58,1.98,2.50,3.17,4,4.97,6.07,7.10,7.25,7.48,7.83,8.52,7.72,7.10,6.61,5.87,5.36,4.99,4.67,3.87,3.27,2.74,15,15,15,15,15,15,14.99,14.98,14.96,14.87,14.73,14.54,14.38,14.24,14.12,14.04,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.98,13.98,13.97,13.96,13.92,13.89,13.86,13.79,13.74,13.65,13.60,13.53,13.50,13.46,13.41,13.38,13.36,13.29,13.25,13.21,13.13,13.08,13,12.92,12.86,12.77,12.67,12.58,12.46,12.35,12.24,12.13,12.07,12.01,11.99,11.97,11.96,11.95,11.90,11.87,11.78,11.70,11.57,11.41,11.28,11.16,11.09,11.01,11,11,11,11,11,11,11,11,11,11,10.99,11,10.99,10.99,10.99,10.97,10.92,10.87,10.74,10.58,10.41,10.29,10.21,10.16,10.13,10.12,10.12,10.11,10.08,10.02,9.99,9.95,9.89,9.84,9.76,9.67,9.59,9.48,9.37,9.27,9.17,9.09,8.99,8.89,8.82,8.72,8.63,8.54,8.48,8.40,8.35,8.27,8.23,8.15,8.10,8,7.90,7.78,7.64,7.49,7.33,7.14,7,6.86,6.73,6.60,6.47,6.34,6.17,6.01,5.84,5.63,5.42,5.21,4.98,4.73,4.48,4.23,3.99,3.75,3.52,3.35,3.16,3.01,2.88,2.76,2.64,2.52,2.39,2.27,2.14,2.02,1.88,1.75,1.59,1.42,1.27,1.14,1.04,0.99,0.95,0.91,0.89,0.89,0.89,0.90,0.92,0.96,0.97,0.97,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.98,0.98,0.97,0.97,0.96,0.91,0.87,0.79,0.75,0.71,0.65,0.59,0.50,0.42,0.39,0.37,0.29,0.12,-0.08,-0.10,0.38,0.72,0.72,0.60,-0.67,-0.50,-0.35,0.37,0.66,0.74,0.63,0.45,0.22,-0.02,-0.24,-0.72,-1.63,-2.79,-4,-5.25,-6.37,-7.25,-7.86,-8.14,-8.51,-7.40,-6.03,-4.28,-2.62,-0.40,-0.11,0.14,0.33,0.41,0.47,0.48,0.50,0.54,0.61,0.65,0.70,0.72,0.70,0.64,0.59,0.49,0.38,0.27,0.17,0.11,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.09,0.17,0.32,0.47,0.63,0.78,0.95,1.11,1.29,1.58,2.03,2.64,3.38,4.25,5.21,6.22,6.98,7.33,7.58,8.26,8.38,7.52,6.99,6.61,5.76,5.15,4.65,4.15,3.71,3.08,2.74,15,15,15,15,15,14.99,14.98,14.95,14.86,14.74,14.57,14.38,14.24,14.12,14.04,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.98,13.98,13.97,13.97,13.96,13.95,13.89,13.86,13.79,13.73,13.63,13.57,13.49,13.41,13.37,13.34,13.29,13.26,13.24,13.21,13.16,13.12,13.08,13.02,12.98,12.90,12.85,12.76,12.67,12.59,12.48,12.36,12.25,12.14,12.08,12.02,12,11.97,11.96,11.95,11.90,11.86,11.77,11.66,11.53,11.39,11.25,11.14,11.07,11.01,11,11,11,11,11,11,11,10.99,11,10.99,10.99,10.99,10.99,10.99,10.97,10.92,10.87,10.74,10.58,10.40,10.27,10.20,10.12,10.10,10.09,10.08,10.07,10.04,10.01,9.99,9.95,9.88,9.84,9.75,9.66,9.58,9.48,9.37,9.27,9.17,9.09,8.99,8.88,8.79,8.71,8.62,8.51,8.42,8.36,8.27,8.22,8.15,8.11,8.03,7.97,7.87,7.76,7.62,7.47,7.28,7.11,6.91,6.75,6.62,6.49,6.37,6.25,6.11,5.96,5.78,5.61,5.40,5.20,4.97,4.73,4.49,4.24,4,3.77,3.57,3.37,3.20,3.02,2.89,2.76,2.64,2.52,2.40,2.28,2.16,2.07,1.95,1.79,1.64,1.49,1.33,1.20,1.08,1,0.92,0.88,0.86,0.82,0.82,0.82,0.84,0.87,0.90,0.95,0.97,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.96,0.91,0.86,0.76,0.64,0.54,0.48,0.40,0.29,0.20,0.09,0.04,0.08,0.03,-0.05,-0.13,-0.01,0.11,0.40,0.59,0.59,0.64,0.58,0.39,0.52,0.64,0.62,0.46,0.21,-0.08,-0.38,-1.14,-2.03,-3.16,-4.10,-5.03,-6.02,-6.88,-7.51,-7.84,-7.86,-7.46,-6.86,-4.96,-2.99,-0.78,-0.03,0.20,0.37,0.48,0.52,0.53,0.53,0.54,0.59,0.62,0.66,0.71,0.72,0.70,0.64,0.58,0.48,0.37,0.25,0.15,0.09,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.10,0.20,0.34,0.50,0.65,0.82,0.96,1.10,1.25,1.59,2.08,2.72,3.46,4.35,5.22,6.04,6.66,7,7.15,7.25,7.16,6.82,6.54,5.87,5.62,4.74,4.24,3.73,3.21,2.73,2,15,15,15,15,14.99,14.97,14.92,14.86,14.73,14.57,14.39,14.24,14.12,14.04,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.98,13.97,13.96,13.92,13.90,13.87,13.78,13.72,13.62,13.53,13.46,13.37,13.29,13.25,13.22,13.20,13.16,13.14,13.12,13.10,13.07,13.02,12.99,12.95,12.88,12.84,12.76,12.67,12.59,12.48,12.37,12.25,12.15,12.09,12.02,12,11.98,11.96,11.92,11.89,11.85,11.76,11.65,11.52,11.38,11.24,11.12,11.04,11,11,11,11,11,11,11,10.99,10.99,10.99,10.99,10.99,10.98,10.99,10.97,10.92,10.87,10.74,10.57,10.39,10.25,10.17,10.12,10.08,10.04,10.02,10.02,10.01,10,9.98,9.92,9.88,9.83,9.75,9.66,9.58,9.48,9.37,9.27,9.17,9.09,8.99,8.88,8.78,8.70,8.60,8.50,8.39,8.32,8.24,8.16,8.11,8.04,8,7.91,7.86,7.75,7.62,7.47,7.27,7.10,6.89,6.72,6.54,6.40,6.27,6.15,6.03,5.89,5.75,5.58,5.37,5.16,4.96,4.72,4.49,4.25,4,3.77,3.58,3.37,3.21,3.03,2.89,2.76,2.63,2.51,2.39,2.28,2.17,2.09,1.98,1.86,1.73,1.57,1.39,1.25,1.12,1.01,0.95,0.87,0.82,0.75,0.71,0.66,0.66,0.72,0.78,0.87,0.91,0.96,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.96,0.92,0.87,0.75,0.62,0.47,0.35,0.26,0.17,0.07,-0.09,-0.16,-0.13,-0.10,-0.11,-0.17,-0.36,-0.22,-0.24,-0.15,0.38,0.72,0.75,0.79,0.71,0.61,0.50,0.37,0.20,-0.04,-0.34,-1.22,-2.26,-4.09,-5.28,-5.33,-6.04,-6.73,-7.36,-7.74,-7.78,-7.42,-6.68,-5.92,-3.51,-1.60,0,0.21,0.35,0.45,0.50,0.50,0.50,0.49,0.49,0.51,0.57,0.62,0.64,0.65,0.64,0.61,0.52,0.42,0.34,0.24,0.14,0.08,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.11,0.21,0.36,0.51,0.67,0.84,0.96,1.08,1.25,1.57,2.03,2.64,3.36,4.16,4.90,5.58,6.03,6.26,6.28,6.24,6.12,5.88,5.53,5.12,4.36,4.25,3.82,3.29,2.75,2.21,1.76,15,15,15,14.98,14.96,14.92,14.85,14.73,14.57,14.39,14.25,14.12,14.04,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.95,13.90,13.87,13.82,13.73,13.63,13.52,13.42,13.35,13.26,13.21,13.15,13.12,13.11,13.09,13.07,13.04,13.02,13,12.98,12.96,12.90,12.87,12.82,12.75,12.66,12.59,12.48,12.36,12.25,12.14,12.08,12.02,12,11.98,11.96,11.92,11.89,11.85,11.76,11.66,11.52,11.37,11.23,11.12,11.04,11,11,11,11,11,11,10.99,10.99,10.99,10.99,10.99,10.98,10.98,10.97,10.92,10.87,10.74,10.57,10.39,10.25,10.15,10.11,10.07,10.02,10,10,9.99,9.98,9.97,9.92,9.88,9.84,9.75,9.66,9.58,9.48,9.37,9.27,9.17,9.09,8.99,8.88,8.78,8.70,8.59,8.50,8.38,8.29,8.22,8.13,8.08,8.01,7.96,7.89,7.83,7.73,7.62,7.48,7.29,7.11,6.90,6.72,6.52,6.37,6.23,6.10,5.98,5.85,5.71,5.53,5.36,5.14,4.92,4.71,4.47,4.24,4,3.77,3.58,3.37,3.21,3.03,2.89,2.75,2.63,2.50,2.39,2.27,2.17,2.10,2,1.89,1.77,1.64,1.50,1.34,1.20,1.08,0.98,0.88,0.79,0.72,0.62,0.52,0.49,0.50,0.57,0.66,0.79,0.88,0.95,0.97,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.96,0.92,0.88,0.78,0.62,0.45,0.28,0.20,0.14,0.07,-0.05,-0.18,-0.23,-0.22,-0.22,-0.23,-0.25,-0.35,-0.22,-0.23,-0.09,0.21,0.35,0.49,0.64,0.57,0.27,0.10,0,-0.13,-1.08,-2.13,-3.23,-5.04,-6.30,-7.32,-7.07,-6.84,-7.33,-7.73,-7.88,-7.63,-6.92,-5.72,-4.55,-1.65,-0.11,0.12,0.25,0.34,0.37,0.37,0.36,0.34,0.32,0.33,0.37,0.41,0.49,0.53,0.57,0.57,0.51,0.46,0.37,0.27,0.20,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.11,0.22,0.36,0.52,0.70,0.86,0.97,1.04,1.22,1.50,1.91,2.47,3.09,3.71,4.36,4.87,5.22,5.37,5.35,5.29,5.17,4.99,4.67,4.26,3.89,3.65,3.70,2.83,2.25,1.77,1.21,15,15,14.98,14.96,14.91,14.85,14.73,14.57,14.39,14.25,14.14,14.09,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.98,13.98,13.97,13.91,13.87,13.82,13.74,13.63,13.52,13.42,13.33,13.25,13.16,13.12,13.09,13.04,13.02,13.01,13,13,12.99,12.97,12.95,12.91,12.88,12.85,12.78,12.74,12.64,12.54,12.45,12.34,12.24,12.13,12.07,12.01,11.99,11.98,11.96,11.92,11.91,11.87,11.77,11.65,11.51,11.37,11.23,11.12,11.03,11,11,10.99,10.99,10.99,10.99,10.99,10.99,10.99,10.98,10.98,10.98,10.96,10.92,10.87,10.74,10.57,10.39,10.25,10.16,10.10,10.04,10.01,9.99,9.98,9.97,9.97,9.95,9.91,9.88,9.84,9.76,9.67,9.59,9.49,9.37,9.27,9.17,9.09,8.99,8.88,8.78,8.70,8.60,8.49,8.38,8.28,8.21,8.12,8.04,8,7.92,7.87,7.79,7.72,7.61,7.47,7.32,7.12,6.92,6.74,6.53,6.37,6.21,6.07,5.92,5.79,5.65,5.50,5.33,5.12,4.90,4.67,4.46,4.22,3.99,3.75,3.54,3.36,3.17,3.02,2.88,2.75,2.62,2.50,2.38,2.27,2.17,2.10,2,1.91,1.83,1.71,1.57,1.40,1.26,1.12,1.01,0.90,0.82,0.71,0.58,0.45,0.34,0.26,0.28,0.40,0.58,0.75,0.87,0.92,0.97,0.98,0.98,0.98,0.98,0.98,0.97,0.96,0.95,0.90,0.87,0.82,0.67,0.50,0.28,0.15,0.13,0.14,0.10,-0.02,-0.14,-0.23,-0.28,-1.89,-1.98,-0.37,-0.11,0.17,0.20,0.04,-0.21,-0.49,-0.61,-0.63,-0.65,-0.60,-1.23,-2,-2.13,-3.45,-5.16,-6.22,-7.28,-8.28,-8.35,-7.83,-7.42,-7.78,-8,-7.91,-7.47,-6.50,-4.91,-1.99,-0.36,-0.11,0.03,0.12,0.16,0.16,0.14,0.11,0.08,0.07,0.09,0.14,0.24,0.32,0.37,0.41,0.41,0.39,0.35,0.27,0.21,0.13,0.09,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.10,0.21,0.35,0.51,0.71,0.87,0.97,1.03,1.16,1.39,1.75,2.17,2.67,3.17,3.63,4.01,4.27,4.41,4.47,4.47,4.37,4.21,3.92,3.59,3.26,3.04,2.72,2.27,1.78,1.24,1.16,15,14.98,14.96,14.91,14.85,14.73,14.57,14.39,14.26,14.15,14.09,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.98,13.98,13.97,13.95,13.89,13.85,13.74,13.63,13.52,13.41,13.33,13.24,13.15,13.10,13.04,13.01,13,12.99,12.98,12.98,12.97,12.96,12.92,12.90,12.89,12.87,12.83,12.76,12.70,12.61,12.50,12.39,12.29,12.21,12.12,12.04,12,11.99,11.98,11.96,11.95,11.90,11.85,11.75,11.63,11.50,11.36,11.22,11.11,11.03,11,10.99,10.99,10.99,10.99,10.99,10.99,10.99,10.98,10.98,10.97,10.96,10.89,10.87,10.74,10.57,10.39,10.25,10.15,10.10,10.03,10,9.99,9.98,9.97,9.96,9.95,9.91,9.88,9.84,9.76,9.67,9.60,9.49,9.37,9.27,9.17,9.09,8.99,8.88,8.78,8.70,8.60,8.49,8.39,8.29,8.21,8.12,8.04,7.99,7.91,7.86,7.78,7.71,7.60,7.47,7.32,7.14,6.97,6.76,6.58,6.38,6.22,6.07,5.91,5.77,5.62,5.48,5.28,5.10,4.88,4.65,4.41,4.20,3.97,3.74,3.52,3.34,3.15,3,2.86,2.73,2.61,2.50,2.37,2.26,2.16,2.09,2,1.91,1.84,1.73,1.61,1.47,1.33,1.17,1.04,0.95,0.84,0.72,0.59,0.42,0.26,0.12,0.07,0.12,0.25,0.50,0.72,0.86,0.92,0.97,0.97,0.98,0.98,0.98,0.97,0.96,0.92,0.87,0.83,0.75,0.70,0.58,0.38,0.22,0.13,0.16,0.24,0.23,0.12,-0.04,-0.23,-1.93,-4.68,-4.83,-2.05,-0.10,0.46,0.33,-0.05,-0.75,-1.38,-1.64,-2.37,-3.21,-3.82,-4.51,-4.61,-5.62,-5.68,-6.58,-7.01,-7.60,-8.07,-8.22,-8.13,-8.07,-8.13,-8.18,-7.97,-7.37,-6.29,-5.33,-3.43,-2.85,-1.63,-0.52,-0.37,-0.25,-0.22,-0.17,-0.17,-0.22,-0.22,-0.16,-0.09,0.02,0.12,0.21,0.25,0.25,0.24,0.20,0.13,0.10,0.04,0.03,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.09,0.17,0.32,0.49,0.67,0.87,0.96,1.01,1.12,1.27,1.52,1.87,2.25,2.64,3,3.26,3.48,3.62,3.73,3.75,3.72,3.54,3.28,2.98,2.67,2.34,2.12,1.76,1.24,1.14,1.01,14.98,14.97,14.91,14.85,14.73,14.54,14.40,14.26,14.15,14.09,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.99,13.99,13.98,13.98,13.97,13.95,13.90,13.86,13.76,13.65,13.53,13.41,13.32,13.23,13.14,13.09,13.03,13,12.99,12.98,12.97,12.96,12.95,12.95,12.91,12.90,12.88,12.87,12.83,12.76,12.72,12.62,12.53,12.45,12.35,12.25,12.15,12.09,12.02,12,11.98,11.97,11.96,11.92,11.88,11.83,11.73,11.61,11.47,11.33,11.20,11.10,11.02,11,10.99,10.99,10.98,10.98,10.98,10.98,10.98,10.97,10.96,10.95,10.89,10.83,10.75,10.58,10.39,10.26,10.16,10.09,10.03,10,9.99,9.98,9.97,9.96,9.92,9.90,9.87,9.84,9.76,9.70,9.60,9.50,9.38,9.28,9.17,9.09,9,8.89,8.79,8.71,8.60,8.50,8.39,8.29,8.22,8.12,8.04,7.99,7.91,7.86,7.77,7.70,7.60,7.48,7.33,7.15,6.99,6.79,6.61,6.41,6.24,6.08,5.91,5.76,5.62,5.46,5.26,5.08,4.87,4.63,4.39,4.16,3.92,3.71,3.50,3.28,3.12,2.96,2.82,2.70,2.58,2.47,2.37,2.26,2.16,2.09,2,1.91,1.84,1.74,1.62,1.50,1.37,1.23,1.10,0.97,0.85,0.72,0.59,0.45,0.27,0.11,-0.03,-0.08,0.03,0.23,0.49,0.72,0.86,0.92,0.96,0.97,0.96,0.97,0.96,0.92,0.90,0.86,0.76,0.66,0.58,0.50,0.42,0.33,0.22,0.17,0.26,0.37,0.37,0.25,0.03,-0.25,-3.53,-6.59,-5.93,-2.86,-0.09,0.20,-0.10,-0.73,-1.38,-2,-3.71,-5.49,-6.79,-8.17,-7.63,-7.40,-6.24,-6.34,-6.88,-7.43,-7.89,-8.23,-8.39,-8.43,-8.45,-8.43,-8.39,-8.05,-7.41,-7.09,-7.05,-6.80,-6.16,-5.15,-3.39,-1.47,-1.28,-1.18,-0.97,-0.74,-0.61,-0.48,-0.35,-0.25,-0.13,-0.03,0.03,0.08,0.08,0.03,0,-0.03,-0.05,-0.08,-0.03,-0.02,-0.01,0,0,0.01,0,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.14,0.26,0.42,0.62,0.83,0.91,1,1.08,1.16,1.35,1.59,1.87,2.20,2.48,2.66,2.86,3.01,3.13,3.16,3.13,2.97,2.73,2.46,2.20,1.97,1.73,1.24,1.12,0.88,0.85,14.98,14.95,14.87,14.73,14.54,14.40,14.26,14.15,14.09,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.99,13.99,13.99,13.97,13.96,13.92,13.89,13.85,13.76,13.66,13.54,13.42,13.32,13.23,13.14,13.09,13.03,13,12.99,12.98,12.97,12.96,12.95,12.92,12.91,12.89,12.87,12.86,12.82,12.76,12.72,12.63,12.54,12.47,12.37,12.27,12.20,12.12,12.07,12.01,11.99,11.98,11.97,11.95,11.90,11.87,11.78,11.67,11.57,11.41,11.28,11.16,11.08,11.02,11,10.99,10.98,10.98,10.98,10.98,10.98,10.97,10.96,10.92,10.88,10.84,10.72,10.58,10.40,10.27,10.16,10.10,10.03,10,9.99,9.98,9.97,9.97,9.95,9.91,9.88,9.84,9.76,9.70,9.60,9.50,9.38,9.28,9.20,9.10,9,8.91,8.83,8.72,8.62,8.50,8.40,8.32,8.23,8.13,8.07,8,7.91,7.86,7.78,7.70,7.60,7.48,7.34,7.16,7,6.83,6.63,6.46,6.26,6.11,5.95,5.77,5.62,5.46,5.25,5.07,4.85,4.62,4.37,4.13,3.90,3.66,3.46,3.25,3.08,2.90,2.76,2.63,2.52,2.42,2.34,2.25,2.15,2.09,2,1.91,1.84,1.74,1.62,1.50,1.38,1.25,1.12,0.99,0.85,0.72,0.58,0.42,0.28,0.14,0,-0.10,-0.08,0.02,0.27,0.53,0.74,0.87,0.92,0.95,0.92,0.92,0.89,0.87,0.84,0.78,0.71,0.59,0.45,0.33,0.25,0.22,0.17,0.16,0.23,0.34,0.46,0.48,0.36,0.09,-0.96,-3.71,-6.50,-4.89,-1.28,-0.01,-0.03,-0.50,-2.77,-5.63,-6.86,-7.29,-8.17,-8.82,-8.39,-7.96,-7.40,-7,-6.88,-7.37,-7.80,-8.21,-8.51,-8.70,-8.79,-8.82,-8.77,-8.63,-8.25,-7.70,-7.53,-7.63,-8.17,-8.40,-7.32,-5.97,-4.42,-3.57,-4.89,-3.86,-1.88,-1.39,-1.10,-0.80,-0.53,-0.33,-0.13,-0.10,-0.10,-0.12,-0.16,-0.22,-0.25,-0.26,-0.23,-0.17,-0.13,-0.08,-0.02,0,0.02,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0.03,0.11,0.21,0.35,0.52,0.74,0.88,0.99,1.04,1.11,1.21,1.37,1.61,1.87,2.11,2.29,2.45,2.57,2.63,2.64,2.58,2.41,2.17,1.95,1.74,1.54,1.26,1.12,0.87,0.83,0.14,14.96,14.90,14.74,14.54,14.39,14.26,14.15,14.09,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.98,13.98,13.98,13.98,13.96,13.92,13.88,13.85,13.76,13.65,13.53,13.41,13.32,13.22,13.13,13.08,13.02,13,12.99,12.98,12.96,12.95,12.92,12.91,12.90,12.89,12.87,12.85,12.79,12.75,12.71,12.63,12.54,12.48,12.37,12.28,12.21,12.13,12.08,12.02,12,11.98,11.97,11.96,11.92,11.89,11.85,11.75,11.63,11.50,11.37,11.25,11.13,11.07,11.01,11,10.99,10.98,10.98,10.98,10.97,10.97,10.96,10.91,10.87,10.82,10.72,10.57,10.40,10.27,10.17,10.10,10.03,10,10,9.99,9.98,9.97,9.96,9.92,9.89,9.85,9.77,9.70,9.61,9.50,9.39,9.28,9.21,9.11,9.02,8.95,8.85,8.75,8.64,8.53,8.42,8.34,8.24,8.14,8.08,8,7.91,7.86,7.77,7.67,7.60,7.48,7.34,7.17,7.01,6.85,6.65,6.48,6.29,6.13,5.98,5.82,5.63,5.46,5.26,5.07,4.84,4.61,4.37,4.12,3.88,3.64,3.42,3.23,3.02,2.86,2.71,2.59,2.48,2.37,2.28,2.22,2.13,2.08,2,1.91,1.84,1.74,1.62,1.50,1.38,1.26,1.14,1.01,0.87,0.73,0.58,0.40,0.27,0.15,0.04,-0.02,-0.02,0.03,0.17,0.40,0.62,0.78,0.89,0.92,0.92,0.89,0.84,0.75,0.67,0.63,0.59,0.50,0.36,0.16,-0.04,-0.16,-0.23,-0.21,-0.10,0.07,0.29,0.42,0.46,0.34,0.09,-1.68,-3.78,-6.37,-4.62,-0.49,-0.09,-0.87,-4.39,-8.82,-13,-15,-12,-10,-9.50,-8.90,-8.27,-7.82,-7.52,-7.57,-7.92,-8.26,-8.60,-8.87,-9.07,-9.16,-9.18,-9.10,-9,-8.59,-8.11,-7.59,-7.66,-7.67,-7.73,-7.75,-7.32,-6.99,-7.87,-8.97,-8.50,-6.17,-3.51,-3.16,-3.45,-2.25,-1.05,-0.62,-0.38,-0.28,-0.28,-0.38,-0.47,-0.51,-0.51,-0.48,-0.38,-0.28,-0.17,-0.09,0,0.03,0.04,0.03,0.01,0,0,0,0,0,0,0,0,0,0.01,0.04,0.12,0.25,0.40,0.62,0.83,0.96,1.02,1.07,1.12,1.24,1.41,1.63,1.86,2.01,2.13,2.20,2.20,2.12,2,1.85,1.63,1.42,1.25,1.15,1.07,0.87,0.82,0.13,0.11,14.95,14.75,14.57,14.39,14.25,14.14,14.09,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.98,13.98,13.98,13.97,13.92,13.88,13.83,13.75,13.64,13.53,13.40,13.28,13.21,13.12,13.08,13.02,13,12.99,12.98,12.97,12.96,12.92,12.91,12.90,12.89,12.87,12.85,12.79,12.75,12.71,12.63,12.54,12.48,12.37,12.28,12.22,12.13,12.09,12.03,12,11.99,11.98,11.97,11.95,11.91,11.88,11.83,11.73,11.61,11.47,11.34,11.22,11.11,11.03,11,11,10.99,10.98,10.98,10.97,10.97,10.95,10.91,10.87,10.79,10.70,10.57,10.40,10.27,10.17,10.11,10.04,10.01,10,9.99,9.98,9.98,9.97,9.95,9.90,9.86,9.78,9.71,9.61,9.50,9.39,9.29,9.21,9.12,9.03,8.97,8.88,8.78,8.70,8.59,8.48,8.37,8.25,8.16,8.09,8,7.91,7.85,7.75,7.67,7.58,7.47,7.34,7.20,7.02,6.86,6.67,6.50,6.33,6.14,6,5.84,5.65,5.48,5.27,5.07,4.84,4.61,4.36,4.11,3.87,3.62,3.39,3.20,3,2.83,2.65,2.52,2.41,2.33,2.25,2.16,2.11,2.04,1.99,1.90,1.83,1.74,1.62,1.50,1.39,1.27,1.16,1.04,0.92,0.77,0.62,0.45,0.27,0.13,0.04,0.02,0.03,0.11,0.23,0.37,0.54,0.72,0.85,0.91,0.92,0.91,0.84,0.67,0.51,0.39,0.35,0.34,0.26,0.12,-0.21,-1,-2.12,-3.04,-3.47,-2.93,-2.23,0.01,0.27,0.32,0.22,0.03,-0.92,-4.30,-8.54,-7.27,-3.28,-2.33,-4.10,-8.72,-13,-17,-17,-13,-11,-9.93,-9.32,-8.78,-8.41,-8.30,-8.33,-8.54,-8.79,-9.04,-9.25,-9.40,-9.48,-9.48,-9.39,-9.22,-8.90,-8.54,-8.25,-7.96,-7.53,-7.10,-7.78,-7.86,-7.96,-9.18,-10,-11,-9.24,-7.36,-7.18,-6.95,-6.98,-4.71,-2.54,-2.07,-1.74,-1.51,-0.75,-0.78,-0.83,-0.85,-0.78,-0.66,-0.50,-0.34,-0.16,-0.04,0.02,0.07,0.07,0.03,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.15,0.28,0.48,0.70,0.87,0.97,1,1.04,1.13,1.28,1.48,1.64,1.76,1.87,1.85,1.75,1.62,1.46,1.28,1.11,0.92,0.76,0.73,0.66,0.83,0.13,0.12,0.09,14.77,14.54,14.38,14.25,14.13,14.08,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.98,13.98,13.97,13.95,13.88,13.83,13.74,13.64,13.52,13.40,13.28,13.20,13.12,13.07,13.02,13,12.99,12.98,12.97,12.96,12.92,12.91,12.90,12.88,12.87,12.84,12.78,12.74,12.67,12.62,12.53,12.46,12.37,12.28,12.22,12.13,12.09,12.03,12,12,11.98,11.97,11.97,11.95,11.91,11.87,11.79,11.70,11.57,11.42,11.28,11.17,11.09,11.02,11,10.99,10.99,10.98,10.98,10.97,10.96,10.91,10.87,10.79,10.70,10.57,10.40,10.27,10.17,10.11,10.07,10.02,10,9.99,9.98,9.98,9.97,9.95,9.91,9.87,9.79,9.72,9.62,9.50,9.39,9.29,9.21,9.12,9.04,8.99,8.91,8.85,8.75,8.64,8.52,8.40,8.29,8.20,8.10,8,7.91,7.84,7.75,7.64,7.54,7.45,7.32,7.17,7.02,6.87,6.70,6.51,6.35,6.16,6,5.84,5.66,5.50,5.28,5.09,4.85,4.61,4.36,4.11,3.86,3.62,3.37,3.15,2.97,2.77,2.62,2.49,2.37,2.27,2.21,2.13,2.08,2.01,1.97,1.89,1.83,1.73,1.62,1.50,1.39,1.27,1.17,1.09,0.99,0.87,0.73,0.57,0.37,0.21,0.08,0.03,0.08,0.16,0.28,0.42,0.58,0.72,0.82,0.88,0.92,0.92,0.87,0.75,0.51,0.26,0.12,0.10,0.14,0.13,-0.03,-0.62,-2.01,-4.02,-6.40,-7.51,-7.62,-6.38,-3.80,0.01,0.11,0.07,-0.07,-1.47,-5.42,-9,-9.61,-6.66,-5.64,-7.75,-9.83,-11,-13,-12,-11,-10,-10,-9.63,-9.30,-9.05,-8.96,-9.01,-9.10,-9.27,-9.43,-9.58,-9.68,-9.73,-9.71,-9.63,-9.50,-9.30,-9.09,-8.83,-8.57,-8.29,-8.16,-8.03,-8.24,-8.05,-7.76,-9.58,-10,-9.12,-8.37,-8.22,-9.02,-9.36,-8.02,-6.24,-5.46,-5.15,-4.87,-4.54,-2.82,-2.45,-2.11,-1.15,-1,-0.78,-0.52,-0.28,-0.10,0.02,0.09,0.09,0.07,0.02,0,0,0,0,0,0,0,0,0,0,0.02,0.10,0.17,0.33,0.51,0.70,0.83,0.89,0.97,1.03,1.15,1.28,1.40,1.49,1.53,1.47,1.29,1.12,0.95,0.78,0.64,0.51,0.38,0.35,0.34,0.17,0.12,0.02,0.08,14.45,14.36,14.23,14.12,14.07,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.98,13.96,13.90,13.83,13.74,13.63,13.52,13.40,13.28,13.17,13.11,13.04,13.01,13,12.99,12.98,12.97,12.96,12.92,12.91,12.89,12.87,12.85,12.82,12.76,12.72,12.65,12.60,12.51,12.45,12.36,12.27,12.21,12.13,12.09,12.03,12,12,11.99,11.98,11.97,11.97,11.95,11.90,11.87,11.77,11.66,11.53,11.39,11.26,11.14,11.07,11.01,11,10.99,10.99,10.98,10.98,10.97,10.95,10.89,10.84,10.73,10.60,10.45,10.29,10.17,10.11,10.04,10.02,10,9.99,9.98,9.97,9.96,9.92,9.90,9.87,9.82,9.74,9.62,9.51,9.40,9.29,9.22,9.12,9.07,9,8.96,8.88,8.82,8.73,8.62,8.50,8.37,8.25,8.13,8.03,7.95,7.84,7.74,7.62,7.50,7.38,7.26,7.13,7,6.86,6.70,6.51,6.36,6.17,6,5.84,5.65,5.50,5.29,5.09,4.86,4.62,4.37,4.11,3.86,3.61,3.37,3.14,2.95,2.75,2.60,2.46,2.34,2.24,2.15,2.10,2.03,1.99,1.92,1.87,1.82,1.72,1.62,1.50,1.38,1.27,1.17,1.10,1.01,0.95,0.85,0.72,0.57,0.39,0.25,0.15,0.14,0.23,0.35,0.49,0.62,0.75,0.84,0.88,0.92,0.95,0.90,0.84,0.67,0.40,0.12,-0.02,0,0.12,0.13,-0.11,-0.99,-2.85,-5.48,-8.73,-11,-13,-12,-7.79,-1.74,-0.12,-0.08,-2.24,-4.09,-6.13,-7.95,-8.29,-7.41,-7.02,-7.73,-9.12,-9.47,-9.29,-9.95,-10,-10,-9.98,-9.86,-9.73,-9.55,-9.48,-9.51,-9.53,-9.63,-9.73,-9.80,-9.86,-9.88,-9.87,-9.83,-9.80,-9.74,-9.59,-9.40,-9.25,-9.12,-9,-8.95,-8.86,-8.75,-8.42,-8.11,-8.49,-8.91,-8.60,-8.70,-9.05,-9.37,-8.89,-7.95,-7.33,-8.11,-8.78,-8.55,-7.26,-5.78,-4.83,-4.22,-2.26,-1.12,-0.75,-0.39,-0.12,0.04,0.14,0.12,0.09,0.04,0.02,0.01,0,0,0,0,0,0,0,0,0,0.04,0.11,0.20,0.34,0.49,0.62,0.74,0.84,0.90,1,1.08,1.12,1.14,1.14,1.03,0.87,0.67,0.51,0.39,0.29,0.22,0.12,0.09,0.07,0.03,0,0,0.08,14.23,14.16,14.11,14.04,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.98,13.98,13.96,13.87,13.75,13.63,13.52,13.40,13.29,13.20,13.12,13.04,13.01,13,12.99,12.98,12.97,12.96,12.95,12.91,12.89,12.87,12.85,12.79,12.75,12.70,12.62,12.54,12.49,12.40,12.34,12.25,12.20,12.12,12.09,12.03,12,11.99,11.98,11.98,11.97,11.97,11.96,11.95,11.90,11.86,11.76,11.64,11.51,11.37,11.25,11.12,11.04,11,10.99,10.99,10.98,10.98,10.97,10.96,10.92,10.87,10.78,10.65,10.50,10.35,10.22,10.12,10.04,10.01,10,9.99,9.98,9.96,9.92,9.90,9.87,9.85,9.79,9.73,9.62,9.51,9.40,9.29,9.22,9.12,9.08,9.01,8.98,8.91,8.87,8.78,8.71,8.59,8.46,8.33,8.21,8.09,7.97,7.86,7.74,7.62,7.49,7.36,7.23,7.09,6.96,6.82,6.65,6.50,6.35,6.17,6,5.84,5.65,5.48,5.29,5.10,4.87,4.62,4.37,4.12,3.87,3.62,3.37,3.14,2.92,2.74,2.58,2.42,2.29,2.21,2.12,2.07,2,1.96,1.90,1.86,1.79,1.71,1.61,1.49,1.37,1.25,1.15,1.09,1.01,0.97,0.90,0.85,0.75,0.62,0.50,0.40,0.35,0.36,0.41,0.52,0.66,0.77,0.86,0.91,0.95,0.92,0.91,0.87,0.78,0.63,0.40,0.15,0.04,0.13,0.27,0.22,-0.18,-1.23,-3.24,-6.33,-9.84,-13,-17,-18,-12,-4.09,-0.53,-2.62,-4.43,-5.74,-6.74,-7.39,-7.54,-7.34,-7.36,-8.09,-8.63,-9.23,-9.48,-9.62,-9.88,-9.93,-9.95,-9.96,-9.93,-9.85,-9.79,-9.82,-9.84,-9.85,-9.90,-9.93,-9.96,-9.97,-9.96,-9.97,-10,-10,-9.95,-9.84,-9.76,-9.73,-9.76,-9.72,-9.67,-9.62,-9.57,-9.42,-9.12,-9.11,-8.89,-8.82,-9.07,-9.18,-9,-8.64,-8.43,-8.55,-9.98,-9.89,-9.27,-8.51,-8.59,-7.76,-5.60,-3.04,-1.11,-0.71,-0.36,-0.12,0.08,0.08,0.07,0.07,0.07,0.07,0.04,0.03,0.02,0,0,0,0,0,0,0.02,0.07,0.11,0.21,0.32,0.45,0.57,0.65,0.75,0.78,0.82,0.79,0.77,0.73,0.63,0.49,0.35,0.23,0.14,0.11,0.07,0.03,0.01,0,0,0,0,0.09,14.09,14.07,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.98,13.96,13.90,13.79,13.65,13.53,13.41,13.32,13.22,13.12,13.07,13.01,13,12.99,12.98,12.97,12.96,12.95,12.92,12.90,12.87,12.85,12.79,12.74,12.66,12.60,12.52,12.46,12.37,12.29,12.24,12.16,12.12,12.08,12.03,12,11.99,11.98,11.97,11.97,11.97,11.97,11.96,11.92,11.89,11.85,11.75,11.63,11.50,11.36,11.23,11.12,11.03,11,10.99,10.99,10.98,10.98,10.97,10.96,10.91,10.86,10.75,10.61,10.42,10.28,10.15,10.08,10.01,10,9.99,9.97,9.96,9.91,9.87,9.85,9.78,9.74,9.67,9.61,9.50,9.39,9.29,9.21,9.12,9.08,9.01,8.99,8.96,8.90,8.86,8.77,8.67,8.57,8.41,8.28,8.14,8.01,7.88,7.75,7.62,7.48,7.34,7.17,7.03,6.89,6.75,6.62,6.48,6.34,6.16,6,5.83,5.64,5.47,5.26,5.08,4.87,4.63,4.39,4.14,3.89,3.64,3.39,3.16,2.95,2.74,2.57,2.40,2.28,2.17,2.10,2.02,1.98,1.92,1.88,1.84,1.76,1.71,1.60,1.48,1.35,1.23,1.12,1.04,0.99,0.96,0.91,0.88,0.84,0.77,0.71,0.63,0.59,0.57,0.59,0.62,0.72,0.82,0.87,0.92,0.95,0.92,0.90,0.87,0.82,0.72,0.60,0.46,0.32,0.28,0.39,0.49,0.25,-0.18,-1.41,-3.47,-6.65,-10,-14,-17,-18,-12,-6.88,-4.66,-5.70,-6.50,-7.13,-7.37,-7.47,-7.35,-7.45,-7.85,-8.42,-8.98,-9.33,-9.59,-9.75,-9.80,-9.88,-9.93,-9.98,-9.99,-9.97,-9.97,-9.96,-9.98,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.74,-9.50,-9.35,-9.35,-9.37,-9.33,-9.14,-9.07,-8.89,-9.58,-10,-9.37,-9.04,-8.83,-8.41,-7.29,-5.39,-3.17,-1.17,-0.80,-0.41,-0.14,-0.04,0,0.04,0.10,0.12,0.11,0.09,0.07,0.03,0.01,0,0,0,0.01,0.03,0.07,0.10,0.15,0.24,0.33,0.40,0.50,0.54,0.58,0.53,0.50,0.46,0.36,0.29,0.22,0.12,0.07,0.02,0.01,0,0,0,0,0,0,0,0.10,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.96,13.90,13.82,13.70,13.53,13.41,13.32,13.23,13.13,13.08,13.02,13,12.99,12.98,12.97,12.97,12.96,12.95,12.91,12.88,12.85,12.79,12.74,12.65,12.59,12.50,12.41,12.35,12.26,12.21,12.14,12.11,12.07,12.02,12,11.99,11.98,11.97,11.96,11.96,11.96,11.95,11.95,11.91,11.87,11.83,11.73,11.61,11.48,11.34,11.21,11.11,11.03,11,11,10.99,10.98,10.98,10.97,10.95,10.90,10.85,10.73,10.58,10.39,10.25,10.12,10.03,10,9.98,9.97,9.95,9.90,9.87,9.79,9.74,9.65,9.60,9.52,9.46,9.37,9.27,9.20,9.12,9.07,9.01,8.99,8.97,8.92,8.88,8.84,8.75,8.64,8.52,8.38,8.24,8.10,7.95,7.79,7.65,7.50,7.34,7.15,7,6.85,6.71,6.57,6.41,6.28,6.13,5.99,5.82,5.63,5.46,5.25,5.07,4.86,4.64,4.41,4.17,3.95,3.70,3.46,3.21,2.98,2.76,2.58,2.40,2.27,2.16,2.09,2,1.96,1.89,1.85,1.79,1.75,1.65,1.59,1.46,1.32,1.16,1.04,0.96,0.89,0.87,0.86,0.84,0.79,0.77,0.76,0.76,0.75,0.75,0.75,0.76,0.82,0.87,0.90,0.92,0.95,0.92,0.90,0.87,0.79,0.73,0.63,0.57,0.51,0.50,0.57,0.64,0.65,0.33,-0.18,-1.58,-3.88,-7.38,-11,-14,-16,-15,-12,-9.10,-8.98,-7.93,-7.85,-7.97,-8.03,-8.01,-8.01,-8.15,-8.42,-8.83,-9.14,-9.43,-9.62,-9.76,-9.82,-9.83,-9.88,-9.95,-9.98,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.99,-10,-10,-10,-9.75,-9.39,-9.12,-8.80,-8.08,-6.88,-5.52,-4.29,-2.95,-0.87,-0.48,-0.26,-0.13,0,0.09,0.15,0.14,0.12,0.11,0.09,0.07,0.03,0.03,0.03,0.04,0.07,0.10,0.13,0.16,0.21,0.24,0.29,0.37,0.39,0.38,0.35,0.29,0.25,0.14,0.12,0.09,0.04,0.02,0.01,0,0,0,0,0,0,0,0,0.10,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.96,13.90,13.84,13.67,13.53,13.41,13.29,13.22,13.14,13.09,13.03,13,13,12.98,12.98,12.97,12.97,12.96,12.92,12.89,12.87,12.82,12.75,12.66,12.59,12.49,12.39,12.32,12.24,12.17,12.12,12.09,12.04,12.01,12,11.98,11.97,11.96,11.96,11.95,11.95,11.92,11.91,11.90,11.88,11.85,11.77,11.70,11.58,11.45,11.29,11.17,11.10,11.03,11,11,11,10.99,10.98,10.96,10.95,10.89,10.83,10.71,10.52,10.36,10.22,10.11,10.02,9.99,9.96,9.92,9.89,9.85,9.77,9.70,9.61,9.51,9.45,9.37,9.29,9.24,9.16,9.12,9.07,9.01,8.99,8.97,8.96,8.91,8.87,8.82,8.73,8.62,8.48,8.34,8.17,8.01,7.87,7.71,7.53,7.37,7.20,7,6.84,6.66,6.51,6.37,6.25,6.11,5.96,5.79,5.62,5.45,5.25,5.03,4.85,4.63,4.42,4.22,4,3.75,3.51,3.27,3.03,2.82,2.62,2.45,2.28,2.16,2.08,2,1.92,1.87,1.82,1.75,1.71,1.62,1.52,1.42,1.27,1.12,0.96,0.82,0.73,0.70,0.70,0.67,0.65,0.63,0.62,0.65,0.75,0.82,0.86,0.88,0.91,0.91,0.91,0.92,0.91,0.90,0.87,0.84,0.76,0.70,0.62,0.54,0.53,0.58,0.64,0.75,0.79,0.74,0.34,-0.22,-1.83,-4.49,-8.33,-12,-15,-16,-14,-11,-9.86,-9.61,-9.04,-8.72,-8.73,-8.74,-8.74,-8.75,-8.83,-8.95,-9.05,-9.17,-9.32,-9.45,-9.57,-9.65,-9.72,-9.78,-9.86,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-9.91,-9.45,-8.92,-8.25,-7.46,-6.84,-6.30,-4.64,-2.98,-0.88,-0.54,-0.29,-0.12,0,0.12,0.12,0.11,0.11,0.11,0.11,0.09,0.08,0.07,0.08,0.10,0.12,0.21,0.16,0.10,0.07,0.13,0.25,0.32,0.29,0.25,0.22,0.20,0.15,0.14,0.13,0.13,0.12,0.12,0.11,0.10,0.10,0.09,0.07,0.04,0,0,0.10,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.96,13.90,13.84,13.70,13.53,13.40,13.29,13.21,13.13,13.09,13.03,13.01,13,12.99,12.98,12.98,12.97,12.96,12.95,12.91,12.87,12.83,12.75,12.66,12.59,12.49,12.38,12.29,12.23,12.15,12.11,12.07,12.02,12,11.99,11.98,11.97,11.96,11.95,11.92,11.91,11.90,11.89,11.88,11.87,11.84,11.78,11.73,11.62,11.51,11.38,11.26,11.15,11.09,11.02,11.01,11,11,10.99,10.98,10.96,10.92,10.87,10.78,10.65,10.49,10.33,10.17,10.08,10,9.97,9.92,9.88,9.84,9.76,9.66,9.57,9.46,9.37,9.28,9.23,9.16,9.12,9.09,9.04,9.01,8.99,8.98,8.96,8.92,8.90,8.86,8.77,8.67,8.54,8.40,8.25,8.10,7.92,7.75,7.60,7.41,7.24,7.04,6.87,6.67,6.50,6.36,6.22,6.08,5.92,5.77,5.62,5.45,5.25,5.03,4.84,4.63,4.45,4.24,4.03,3.84,3.61,3.37,3.13,2.89,2.67,2.49,2.33,2.20,2.09,2,1.92,1.86,1.78,1.73,1.64,1.59,1.49,1.38,1.24,1.07,0.86,0.64,0.48,0.37,0.35,0.45,0.41,0.32,0.23,0.26,0.40,0.62,0.78,0.89,0.91,0.91,0.90,0.89,0.88,0.87,0.83,0.76,0.70,0.62,0.53,0.50,0.48,0.52,0.62,0.74,0.85,0.84,0.71,0.15,-0.51,-1.90,-5.21,-9.24,-13,-17,-16,-13,-10,-10,-10,-9.20,-9.43,-9.42,-9.43,-9.42,-9.39,-9.35,-9.26,-9.13,-9.07,-9.07,-9.12,-9.20,-9.28,-9.38,-9.49,-9.64,-9.90,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-10,-9.98,-9.32,-8.65,-7.98,-7.41,-6.71,-5.54,-4.47,-3.83,-3.09,-0.52,-0.27,-0.14,-0.02,-0.01,0.01,0.08,0.12,0.13,0.12,0.10,0.08,0.04,0.03,0.03,0.12,0,-0.21,-0.27,-0.18,0.01,0.14,0.21,0.20,0.20,0.16,0.24,0.25,0.25,0.25,0.25,0.26,0.23,0.24,0.24,0.29,0.29,0.33,0.12,0.11,0.10,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.82,13.70,13.53,13.39,13.27,13.20,13.12,13.08,13.02,13,13,12.99,12.99,12.98,12.98,12.97,12.96,12.92,12.89,12.85,12.77,12.70,12.60,12.49,12.38,12.28,12.22,12.13,12.09,12.04,12.01,12,11.99,11.98,11.97,11.96,11.92,11.91,11.90,11.88,11.87,11.85,11.83,11.79,11.75,11.72,11.64,11.54,11.45,11.34,11.23,11.12,11.07,11.02,11.01,11,11,10.99,10.97,10.95,10.89,10.84,10.73,10.59,10.41,10.26,10.14,10.04,9.99,9.92,9.88,9.83,9.75,9.65,9.54,9.42,9.33,9.24,9.15,9.12,9.09,9.04,9.02,9,8.99,8.98,8.97,8.95,8.91,8.88,8.83,8.74,8.62,8.48,8.32,8.14,7.99,7.82,7.64,7.48,7.32,7.12,6.92,6.74,6.54,6.37,6.22,6.07,5.91,5.76,5.62,5.42,5.25,5.03,4.84,4.63,4.45,4.25,4.08,3.88,3.70,3.48,3.25,3.01,2.78,2.59,2.39,2.24,2.12,2,1.91,1.85,1.77,1.71,1.62,1.53,1.45,1.33,1.21,1.01,0.79,0.54,0.27,0.03,-0.37,-1.13,-2.50,-2.39,-2.82,-2.15,-0.18,0.04,0.50,0.78,0.87,0.87,0.84,0.78,0.76,0.75,0.73,0.66,0.60,0.50,0.42,0.37,0.37,0.39,0.50,0.62,0.76,0.85,0.74,0.38,-0.23,-1.16,-2.93,-5.90,-10,-14,-16,-15,-13,-11,-11,-10,-10,-10,-10,-10,-9.93,-9.79,-9.63,-9.38,-9.11,-8.82,-8.72,-8.70,-8.74,-8.84,-8.97,-9.13,-9.28,-9.60,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-10,-9.85,-9.13,-8.46,-7.75,-6.99,-6.40,-6.29,-6.70,-6.99,-4.62,-1.27,-0.37,-0.29,-0.25,-0.14,-0.01,0.11,0.16,0.15,0.10,-0.01,-0.11,-0.17,-0.23,-0.22,-0.39,-0.65,-1.51,-2.28,-1.28,-0.17,-0.02,0.04,0.10,0.03,0.01,-0.02,-0.03,-0.02,0,0.16,0.28,0.48,0.29,0.26,0.42,0.61,0.87,0.88,0.89,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.82,13.70,13.54,13.39,13.27,13.17,13.11,13.07,13.02,13,13,12.99,12.99,12.98,12.98,12.98,12.97,12.95,12.90,12.87,12.78,12.71,12.61,12.50,12.38,12.28,12.21,12.13,12.09,12.03,12,12,11.98,11.97,11.97,11.96,11.92,11.91,11.89,11.87,11.85,11.82,11.77,11.74,11.71,11.65,11.62,11.54,11.47,11.37,11.26,11.16,11.10,11.04,11.01,11,11,11,10.99,10.96,10.90,10.86,10.75,10.63,10.50,10.34,10.21,10.10,10,9.96,9.88,9.83,9.74,9.63,9.52,9.41,9.29,9.21,9.12,9.09,9.04,9.01,9,9,8.99,8.98,8.97,8.96,8.92,8.89,8.86,8.77,8.66,8.52,8.37,8.21,8.02,7.86,7.67,7.51,7.36,7.20,7.01,6.84,6.63,6.45,6.26,6.10,5.92,5.76,5.61,5.45,5.25,5.04,4.85,4.63,4.46,4.27,4.11,3.95,3.75,3.58,3.37,3.13,2.91,2.71,2.50,2.33,2.16,2.03,1.92,1.85,1.75,1.66,1.59,1.50,1.39,1.28,1.14,1,0.77,0.50,0.20,-1.02,-2.29,-4.29,-7.68,-9.14,-9.22,-8.09,-5.89,-2.32,0.09,0.53,0.78,0.83,0.75,0.64,0.57,0.51,0.49,0.48,0.42,0.37,0.29,0.24,0.22,0.23,0.29,0.40,0.59,0.71,0.75,0.45,0.09,-0.96,-2.27,-4.34,-7.12,-10,-13,-14,-13,-12,-11,-11,-11,-11,-10,-10,-10,-10,-9.99,-9.89,-9.41,-8.87,-8.47,-8.25,-8.21,-8.25,-8.33,-8.55,-8.78,-9.05,-9.43,-9.98,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.67,-8.97,-8.27,-7.67,-7.39,-7.71,-8.76,-10,-8.63,-4.77,-2.97,-1.40,-0.50,-0.33,-0.13,0.08,0.15,0.13,0.01,-0.15,-0.33,-0.55,-0.67,-0.73,-4.01,-6.72,-7.99,-10,-9.30,-5.86,-2.07,-0.29,-0.13,-0.27,-0.50,-0.73,-0.74,-0.73,-0.59,-0.10,0.13,0.33,0.11,-0.35,-0.58,-0.64,-0.88,-0.89,-0.90,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.90,13.82,13.70,13.54,13.39,13.27,13.17,13.11,13.04,13.01,13,12.99,12.98,12.98,12.98,12.98,12.98,12.97,12.96,12.91,12.87,12.82,12.72,12.62,12.50,12.39,12.29,12.21,12.13,12.08,12.02,12,11.99,11.98,11.97,11.96,11.96,11.92,11.91,11.89,11.87,11.83,11.77,11.74,11.67,11.63,11.59,11.53,11.50,11.45,11.37,11.28,11.21,11.12,11.08,11.02,11,11,11,10.99,10.97,10.92,10.87,10.77,10.65,10.51,10.37,10.25,10.13,10.03,9.97,9.89,9.83,9.74,9.63,9.52,9.40,9.29,9.21,9.12,9.07,9.02,9,9,8.99,8.98,8.98,8.97,8.96,8.95,8.90,8.87,8.79,8.71,8.58,8.41,8.25,8.07,7.88,7.72,7.54,7.38,7.24,7.09,6.91,6.74,6.54,6.36,6.16,5.99,5.82,5.62,5.45,5.25,5.04,4.86,4.64,4.47,4.28,4.12,3.97,3.82,3.63,3.46,3.25,3.04,2.84,2.62,2.41,2.25,2.10,1.97,1.86,1.75,1.65,1.57,1.47,1.37,1.25,1.13,1,0.79,0.53,0.21,-1.04,-3.17,-6.92,-11,-14,-13,-12,-9.47,-6.05,-2.37,0.15,0.63,0.78,0.74,0.59,0.39,0.24,0.14,0.12,0.12,0.13,0.13,0.12,0.10,0.09,0.10,0.15,0.25,0.37,0.49,0.51,0.15,-0.50,-1.76,-3.79,-5.76,-7.97,-10,-11,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.80,-9.23,-8.66,-8.26,-8.04,-8,-8.05,-8.16,-8.40,-8.62,-8.89,-9.29,-9.86,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-11,-10,-10,-9.54,-8.89,-8.34,-8.14,-8.60,-9.86,-11,-11,-9.41,-7.27,-5.45,-2.35,-0.64,-0.35,-0.16,-0.04,0.01,-0.13,-0.37,-2.95,-4.04,-4.01,-5.67,-8.74,-14,-18,-19,-20,-15,-8.47,-4.49,-2.10,-0.76,-1.34,-1.63,-1.83,-1.84,-1.49,-0.95,-0.40,-0.72,-1.39,-1.85,-2.10,-2.13,-2,-1.99,-1.90,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.88,13.82,13.70,13.54,13.39,13.25,13.16,13.11,13.04,13.01,13,12.99,12.98,12.98,12.98,12.98,12.97,12.97,12.96,12.92,12.88,12.83,12.74,12.62,12.50,12.39,12.28,12.21,12.12,12.08,12.02,12,11.99,11.98,11.97,11.96,11.95,11.92,11.91,11.89,11.87,11.82,11.75,11.70,11.63,11.58,11.50,11.47,11.41,11.37,11.33,11.26,11.22,11.14,11.10,11.03,11,11,10.99,10.98,10.97,10.92,10.87,10.78,10.66,10.52,10.38,10.26,10.15,10.07,9.99,9.90,9.84,9.75,9.63,9.51,9.39,9.28,9.20,9.12,9.07,9.01,9,8.99,8.98,8.98,8.98,8.97,8.96,8.95,8.91,8.87,8.82,8.73,8.61,8.47,8.28,8.11,7.91,7.74,7.57,7.39,7.25,7.12,6.98,6.83,6.64,6.47,6.26,6.08,5.87,5.67,5.49,5.26,5.07,4.86,4.65,4.47,4.29,4.13,3.99,3.84,3.67,3.51,3.35,3.14,2.96,2.75,2.54,2.36,2.17,2.01,1.87,1.75,1.64,1.53,1.42,1.33,1.23,1.12,1,0.87,0.63,0.33,-0.10,-3.04,-5.89,-8.71,-12,-13,-11,-7.23,-4.98,-2.77,-0.30,0.36,0.71,0.78,0.65,0.40,0.12,-0.12,-0.25,-0.25,-0.23,-0.15,-0.09,-0.02,0,0,-0.01,0,0.03,0.11,0.14,0.14,-0.43,-1.70,-3.79,-5.67,-7.40,-8.73,-9.89,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.62,-9.08,-8.58,-8.23,-8.03,-8,-8.05,-8.17,-8.38,-8.53,-8.78,-9.16,-9.71,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-10,-10,-9.54,-9.04,-8.82,-9.10,-9.99,-10,-11,-12,-10,-8.15,-5.95,-3.85,-1.67,-0.73,-0.63,-2.23,-3.07,-4.30,-5.79,-7.73,-7.66,-8.37,-10,-14,-18,-18,-19,-18,-12,-8.41,-6.58,-4.98,-3.17,-3.70,-3.34,-4.04,-4.05,-4.08,-4.18,-3.65,-3.16,-3.49,-3.60,-3.48,-3.22,-2.89,-2.75,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.88,13.82,13.70,13.54,13.39,13.25,13.15,13.10,13.04,13.01,13,12.99,12.98,12.98,12.97,12.97,12.97,12.97,12.96,12.92,12.89,12.84,12.75,12.63,12.51,12.39,12.28,12.21,12.12,12.08,12.02,12,11.99,11.98,11.97,11.96,11.95,11.92,11.91,11.89,11.87,11.82,11.75,11.67,11.61,11.52,11.46,11.38,11.34,11.28,11.25,11.23,11.20,11.14,11.11,11.07,11.02,11,10.99,10.97,10.96,10.91,10.87,10.79,10.67,10.53,10.38,10.25,10.15,10.08,10,9.91,9.85,9.75,9.64,9.52,9.40,9.28,9.20,9.12,9.07,9.01,9,8.99,8.98,8.98,8.97,8.97,8.97,8.96,8.91,8.88,8.83,8.74,8.62,8.49,8.34,8.14,7.97,7.75,7.58,7.40,7.25,7.12,6.99,6.86,6.71,6.53,6.36,6.15,5.97,5.75,5.53,5.33,5.10,4.87,4.66,4.48,4.29,4.14,4,3.87,3.72,3.57,3.39,3.23,3.03,2.86,2.65,2.47,2.27,2.10,1.92,1.78,1.64,1.51,1.39,1.26,1.15,1.04,0.97,0.88,0.75,0.52,0.16,-1.86,-4.61,-6.35,-7,-7.27,-6.82,-3.92,-1.43,-0.73,-0.50,0.33,0.58,0.76,0.77,0.62,0.34,-0.01,-0.35,-0.46,-0.47,-0.43,-0.36,-0.24,-0.13,-0.08,-0.05,-0.10,-0.12,-0.13,-0.10,-0.27,-0.35,-1.47,-3.77,-5.86,-8.04,-9.09,-9.43,-9.84,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.89,-9.46,-9.02,-8.60,-8.34,-8.17,-8.15,-8.23,-8.30,-8.46,-8.58,-8.75,-9.05,-9.53,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-9.79,-9.59,-9.64,-10,-10,-11,-11,-12,-9.64,-8.14,-6.80,-4.75,-1.91,-3.89,-5.49,-6.43,-7.27,-8.37,-9.40,-10,-10,-10,-10,-12,-16,-17,-16,-13,-10,-9.53,-9.09,-8.91,-8.35,-7.66,-7.17,-8.23,-8.73,-8.45,-7.16,-5.74,-5.14,-5.12,-4.83,-4.29,-3.64,-2.43,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.88,13.82,13.70,13.54,13.39,13.25,13.15,13.09,13.03,13.01,13,12.99,12.98,12.98,12.97,12.97,12.97,12.96,12.96,12.92,12.89,12.85,12.75,12.64,12.52,12.39,12.28,12.20,12.12,12.07,12.02,12,11.99,11.98,11.97,11.96,11.95,11.92,11.90,11.88,11.86,11.82,11.75,11.66,11.60,11.50,11.41,11.35,11.26,11.23,11.20,11.15,11.13,11.12,11.10,11.07,11.02,11,10.99,10.97,10.95,10.90,10.87,10.78,10.66,10.52,10.38,10.25,10.13,10.08,10,9.92,9.86,9.75,9.65,9.53,9.40,9.29,9.21,9.12,9.07,9.01,9,8.99,8.99,8.98,8.98,8.97,8.97,8.96,8.92,8.88,8.84,8.75,8.63,8.50,8.37,8.21,8.02,7.84,7.62,7.42,7.26,7.12,6.99,6.86,6.72,6.58,6.40,6.23,6.02,5.83,5.61,5.37,5.13,4.90,4.70,4.49,4.29,4.14,4.01,3.87,3.74,3.60,3.45,3.27,3.11,2.92,2.75,2.57,2.37,2.17,2,1.84,1.67,1.52,1.38,1.24,1.09,0.96,0.84,0.78,0.73,0.63,0.45,0.12,-1.91,-4,-4.05,-2.80,-2.18,-1.52,0.63,0.66,0.70,0.50,0.60,0.78,0.85,0.79,0.64,0.38,0.11,-0.14,-0.30,-0.41,-0.47,-0.40,-0.28,-0.14,-0.08,-0.08,-0.11,-0.15,-0.17,-0.40,-0.52,-2.87,-4.58,-6.18,-7.88,-9.37,-9.88,-9.98,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.75,-9.39,-9.08,-8.83,-8.55,-8.48,-8.46,-8.49,-8.53,-8.64,-8.73,-8.83,-9.05,-9.47,-9.98,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-10,-10,-9.95,-9.63,-7.26,-6.58,-7.99,-9.45,-10,-10,-10,-11,-12,-12,-10,-10,-12,-14,-15,-13,-12,-11,-11,-11,-13,-12,-9.92,-8.80,-8.76,-9.01,-8.73,-8.21,-7.54,-6.91,-6.36,-5.76,-5.12,-4.15,-2.40,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.90,13.82,13.70,13.54,13.39,13.25,13.15,13.09,13.02,13,13,12.99,12.99,12.98,12.97,12.97,12.96,12.96,12.95,12.91,12.89,12.85,12.75,12.65,12.52,12.39,12.27,12.20,12.12,12.07,12.02,12,11.99,11.98,11.97,11.96,11.92,11.92,11.90,11.88,11.86,11.82,11.75,11.66,11.59,11.50,11.39,11.32,11.24,11.17,11.13,11.11,11.09,11.08,11.07,11.04,11.02,11,10.99,10.97,10.95,10.90,10.86,10.76,10.65,10.51,10.37,10.24,10.12,10.07,10,9.96,9.87,9.78,9.67,9.54,9.42,9.32,9.21,9.12,9.07,9.01,9,8.99,8.98,8.98,8.98,8.97,8.97,8.96,8.92,8.88,8.84,8.75,8.63,8.50,8.37,8.24,8.09,7.91,7.73,7.51,7.33,7.13,6.99,6.85,6.71,6.54,6.39,6.24,6.04,5.86,5.63,5.40,5.17,4.95,4.72,4.50,4.32,4.14,4.01,3.88,3.75,3.62,3.47,3.32,3.13,2.98,2.79,2.62,2.45,2.25,2.08,1.89,1.73,1.57,1.39,1.24,1.07,0.87,0.71,0.54,0.46,0.42,0.39,0.35,0.04,-0.25,-1.99,-1.15,0.57,0.59,0.61,0.63,0.87,0.87,0.85,0.86,0.89,0.90,0.86,0.73,0.54,0.37,0.20,0,-0.17,-0.30,-0.33,-0.24,-0.11,-0.02,-0.02,-0.05,-0.12,-0.25,-0.46,-2.98,-5.76,-8.18,-8.30,-9.09,-9.72,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.91,-9.72,-9.49,-9.25,-9.09,-8.91,-8.87,-8.86,-8.88,-8.88,-8.98,-9,-9.09,-9.24,-9.50,-9.89,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-12,-10,-10,-11,-13,-14,-13,-12,-13,-15,-15,-12,-10,-11,-12,-13,-12,-11,-11,-12,-12,-12,-11,-10,-9.38,-9.21,-9.27,-9.35,-9.25,-8.95,-8.35,-7.59,-6.72,-5.74,-4.61,-2.67,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.82,13.70,13.54,13.39,13.25,13.15,13.09,13.02,13,13,12.99,12.99,12.98,12.98,12.97,12.96,12.95,12.92,12.91,12.88,12.84,12.75,12.64,12.52,12.39,12.27,12.17,12.11,12.04,12.01,12,11.99,11.98,11.97,11.95,11.92,11.91,11.90,11.88,11.86,11.79,11.75,11.66,11.59,11.49,11.39,11.29,11.23,11.14,11.11,11.07,11.04,11.03,11.02,11.01,11.01,11,10.99,10.97,10.96,10.90,10.85,10.75,10.64,10.50,10.36,10.23,10.12,10.04,10,9.98,9.90,9.84,9.73,9.60,9.46,9.34,9.23,9.13,9.08,9.02,9,8.99,8.98,8.98,8.98,8.97,8.97,8.96,8.92,8.89,8.84,8.75,8.63,8.50,8.37,8.23,8.11,7.98,7.83,7.64,7.45,7.23,7.02,6.85,6.67,6.51,6.36,6.20,6.02,5.85,5.63,5.42,5.20,4.97,4.74,4.52,4.34,4.15,4.01,3.88,3.75,3.62,3.48,3.33,3.16,3,2.84,2.65,2.49,2.32,2.12,1.96,1.76,1.61,1.45,1.26,1.10,0.89,0.66,0.42,0.22,0.04,-0.03,-0.01,0,0.26,-0.39,-0.50,0.51,0.74,0.76,0.78,0.83,0.85,0.86,0.87,0.90,0.95,0.95,0.89,0.83,0.73,0.62,0.50,0.33,0.12,-0.08,-0.13,-0.09,0.03,0.11,0.09,0,-0.05,-0.25,-1.46,-4.72,-8.59,-10,-9.55,-9.68,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.93,-9.80,-9.68,-9.55,-9.47,-9.38,-9.36,-9.36,-9.37,-9.37,-9.38,-9.39,-9.42,-9.51,-9.67,-9.93,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-13,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-13,-16,-16,-15,-14,-14,-14,-14,-12,-10,-11,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.49,-9.38,-9.65,-9.89,-10,-10,-9.60,-8.59,-7.50,-6.35,-5.16,-3.25,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.82,13.70,13.54,13.39,13.25,13.15,13.09,13.02,13,13,13,12.99,12.98,12.98,12.98,12.97,12.95,12.92,12.90,12.87,12.83,12.75,12.63,12.51,12.39,12.27,12.17,12.11,12.04,12.01,12,11.99,11.98,11.97,11.95,11.92,11.91,11.89,11.87,11.85,11.79,11.74,11.66,11.59,11.49,11.38,11.29,11.22,11.13,11.09,11.04,11.02,11,11,11,11,10.99,10.98,10.97,10.92,10.90,10.85,10.75,10.63,10.50,10.36,10.23,10.12,10.04,10,9.98,9.95,9.87,9.77,9.64,9.50,9.37,9.25,9.14,9.09,9.02,9,8.99,8.99,8.98,8.98,8.97,8.97,8.97,8.95,8.90,8.85,8.75,8.62,8.49,8.34,8.20,8.07,7.96,7.84,7.72,7.54,7.35,7.12,6.89,6.67,6.49,6.29,6.12,5.97,5.78,5.61,5.39,5.20,4.97,4.75,4.53,4.35,4.16,4.01,3.89,3.76,3.62,3.49,3.34,3.16,3.01,2.85,2.67,2.50,2.34,2.15,1.99,1.82,1.63,1.48,1.32,1.14,0.98,0.75,0.50,0.15,-0.15,-0.41,-0.53,-0.48,-0.25,-0.46,0.50,0.50,0.51,0.51,0.53,0.57,0.59,0.61,0.62,0.65,0.90,0.95,0.95,0.91,0.87,0.83,0.77,0.71,0.57,0.36,0.17,0.10,0.12,0.22,0.24,0.16,0.04,-0.14,-2.25,-4.12,-5.83,-8.57,-9.88,-9.58,-10,-10,-10,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.90,-9.88,-9.88,-9.88,-9.88,-9.86,-9.85,-9.85,-9.85,-9.88,-9.93,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-13,-15,-16,-15,-14,-14,-13,-12,-10,-10,-11,-11,-11,-10,-10,-10,-11,-11,-11,-10,-9.89,-9.59,-9.68,-9.91,-10,-10,-10,-10,-9.10,-7.99,-6.79,-5.63,-3.88,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.83,13.70,13.54,13.39,13.25,13.15,13.09,13.02,13,13,13,12.99,12.98,12.98,12.98,12.97,12.96,12.95,12.89,12.86,12.79,12.73,12.62,12.50,12.38,12.27,12.17,12.11,12.04,12.01,12,11.99,11.98,11.97,11.96,11.92,11.91,11.89,11.87,11.84,11.78,11.74,11.65,11.59,11.49,11.38,11.29,11.22,11.13,11.09,11.03,11.01,11,11,10.99,10.99,10.98,10.98,10.97,10.95,10.90,10.85,10.75,10.63,10.50,10.37,10.24,10.12,10.04,10,9.99,9.98,9.91,9.85,9.73,9.59,9.42,9.28,9.17,9.10,9.03,9,9,8.99,8.99,8.98,8.98,8.98,8.97,8.96,8.92,8.87,8.77,8.63,8.49,8.32,8.13,8,7.87,7.75,7.65,7.53,7.39,7.21,6.98,6.73,6.47,6.24,6.03,5.87,5.71,5.53,5.36,5.15,4.96,4.74,4.53,4.35,4.17,4.02,3.88,3.76,3.63,3.50,3.35,3.17,3.01,2.86,2.67,2.51,2.35,2.16,2,1.84,1.66,1.50,1.35,1.20,1.04,0.87,0.66,0.39,0.07,-0.27,-0.52,-0.72,-1.03,-0.34,0.45,-0.50,-0.50,-0.50,-0.52,-0.59,-0.60,-0.60,-0.60,-0.63,0.64,0.88,0.92,0.92,0.89,0.84,0.77,0.76,0.74,0.64,0.50,0.36,0.27,0.27,0.32,0.16,-0.08,-0.74,-2.72,-4.48,-6.27,-8.02,-9.43,-10,-10,-10,-10,-11,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-12,-12,-13,-13,-14,-13,-13,-11,-9.12,-9.25,-10,-10,-10,-9.89,-9.95,-10,-10,-10,-10,-10,-9.96,-9.83,-9.88,-10,-10,-10,-10,-9.98,-9.20,-8.17,-7.03,-5.88,-4.29,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.85,13.70,13.54,13.39,13.25,13.14,13.09,13.02,13,13,12.99,12.99,12.99,12.98,12.97,12.97,12.96,12.95,12.91,12.87,12.78,12.71,12.61,12.50,12.37,12.26,12.17,12.11,12.04,12.01,12,11.99,11.98,11.97,11.96,11.95,11.91,11.89,11.87,11.84,11.77,11.73,11.64,11.58,11.49,11.39,11.29,11.22,11.13,11.09,11.03,11,11,10.99,10.99,10.98,10.98,10.97,10.96,10.95,10.91,10.86,10.76,10.64,10.51,10.37,10.25,10.14,10.08,10.01,10,9.98,9.97,9.91,9.82,9.67,9.52,9.37,9.24,9.12,9.07,9.01,9,8.99,8.99,8.99,8.98,8.98,8.97,8.97,8.95,8.89,8.83,8.70,8.50,8.32,8.11,7.91,7.75,7.63,7.52,7.42,7.34,7.20,7,6.76,6.49,6.21,5.96,5.75,5.60,5.45,5.27,5.11,4.90,4.72,4.52,4.36,4.17,4.03,3.89,3.75,3.63,3.50,3.35,3.17,3.01,2.85,2.67,2.50,2.34,2.15,2,1.84,1.66,1.50,1.35,1.21,1.08,0.95,0.82,0.63,0.41,0.14,-0.11,-0.28,-0.37,-0.29,-0.21,0.34,-0.43,-0.50,-0.77,-1.50,-1.63,-1.75,-1.66,-1.60,-0.62,0.62,0.87,0.90,0.89,0.83,0.66,0.52,0.50,0.59,0.51,0.39,0.28,0.24,0.21,-0.01,-0.27,-1.08,-2.71,-4.54,-6.59,-8.34,-10,-10,-11,-11,-11,-10,-11,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.97,-10,-11,-12,-13,-12,-11,-8.41,-7.67,-8.82,-9.51,-9.60,-9.43,-9.68,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.77,-9.09,-8.18,-7.11,-5.93,-4.50,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.85,13.71,13.54,13.39,13.25,13.14,13.09,13.02,13,13,12.99,12.99,12.99,12.98,12.97,12.97,12.96,12.92,12.90,12.87,12.82,12.72,12.61,12.49,12.37,12.26,12.17,12.11,12.04,12.01,12,11.99,11.98,11.97,11.97,11.96,11.92,11.90,11.87,11.84,11.77,11.73,11.64,11.58,11.49,11.38,11.29,11.22,11.13,11.09,11.03,11,11,10.99,10.99,10.98,10.98,10.98,10.97,10.96,10.92,10.88,10.82,10.70,10.54,10.40,10.27,10.15,10.09,10.02,10,9.99,9.98,9.97,9.89,9.77,9.63,9.49,9.34,9.20,9.10,9.03,9,8.99,8.99,8.99,8.99,8.98,8.98,8.97,8.96,8.92,8.87,8.75,8.59,8.37,8.12,7.88,7.67,7.51,7.39,7.28,7.21,7.10,6.97,6.76,6.51,6.22,5.91,5.66,5.48,5.33,5.20,5.03,4.87,4.70,4.50,4.35,4.20,4.03,3.90,3.76,3.63,3.50,3.35,3.17,3.01,2.85,2.66,2.50,2.32,2.13,1.97,1.79,1.64,1.50,1.35,1.17,1.04,0.91,0.84,0.75,0.62,0.47,0.29,0.16,0.12,0.14,0.15,0.10,-0.21,0.35,0.34,-0.92,-1.87,-3.09,-3.30,-2.70,-1.65,-0.60,0.61,0.85,0.84,0.82,0.71,0.47,0.04,0.02,0,-0.01,-0.08,-0.13,-0.17,-0.63,-1.76,-2.54,-3.41,-5.54,-7.14,-8.53,-9.99,-11,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.51,-8.59,-8.68,-9.51,-10,-12,-12,-11,-9.16,-8.28,-8.38,-8.72,-9.05,-9.58,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.59,-8.98,-8.15,-7.12,-5.96,-4.59,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.85,13.73,13.54,13.39,13.25,13.14,13.08,13.02,13,12.99,12.99,12.99,12.98,12.98,12.97,12.96,12.95,12.92,12.89,12.87,12.76,12.70,12.61,12.49,12.37,12.27,12.17,12.12,12.04,12.01,12,11.98,11.98,11.97,11.97,11.96,11.95,11.92,11.89,11.86,11.79,11.73,11.64,11.57,11.48,11.38,11.29,11.22,11.14,11.09,11.03,11,11,10.99,10.98,10.98,10.98,10.98,10.97,10.97,10.95,10.91,10.87,10.75,10.62,10.48,10.33,10.21,10.11,10.04,10,9.99,9.99,9.99,9.97,9.87,9.75,9.61,9.46,9.29,9.16,9.08,9.01,9,8.99,8.98,8.98,8.98,8.98,8.97,8.96,8.92,8.88,8.82,8.66,8.47,8.22,7.95,7.67,7.48,7.32,7.17,7.09,6.98,6.87,6.73,6.52,6.26,5.97,5.66,5.41,5.24,5.10,4.96,4.82,4.64,4.50,4.34,4.20,4.04,3.91,3.78,3.63,3.50,3.36,3.20,3.01,2.85,2.66,2.50,2.29,2.12,1.92,1.75,1.60,1.46,1.32,1.16,1.01,0.87,0.75,0.67,0.63,0.58,0.47,0.37,0.34,0.37,0.42,0.45,0.13,-0.12,0.10,0.13,-1.13,-2.91,-5.42,-5.86,-3.82,-1.87,-0.60,0.61,0.62,0.53,0.42,0.46,0.25,-0.22,-0.62,-0.76,-0.84,-2,-3.21,-2.89,-3.93,-5.20,-4.93,-6.03,-7.57,-8.84,-9.71,-10,-11,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.68,-9.53,-9.59,-9.73,-10,-11,-10,-9.46,-9.35,-9.23,-9.37,-9.63,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.90,-9.55,-8.98,-8.15,-7.17,-6,-4.71,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.85,13.73,13.57,13.39,13.26,13.14,13.08,13.02,13,12.99,12.98,12.98,12.98,12.98,12.97,12.96,12.95,12.91,12.87,12.83,12.75,12.67,12.59,12.49,12.38,12.28,12.20,12.12,12.07,12.01,11.99,11.98,11.97,11.97,11.96,11.96,11.95,11.92,11.90,11.87,11.82,11.75,11.65,11.58,11.49,11.38,11.29,11.22,11.14,11.09,11.03,11.01,11,10.99,10.98,10.98,10.98,10.97,10.97,10.97,10.96,10.95,10.90,10.84,10.72,10.58,10.40,10.26,10.14,10.08,10.02,10,9.99,9.99,9.98,9.96,9.86,9.73,9.58,9.41,9.26,9.14,9.07,9.01,8.99,8.98,8.98,8.98,8.98,8.97,8.96,8.92,8.89,8.84,8.73,8.57,8.35,8.07,7.77,7.51,7.29,7.13,7,6.89,6.77,6.64,6.50,6.32,6.07,5.76,5.49,5.24,5.04,4.89,4.75,4.61,4.47,4.33,4.20,4.08,3.95,3.82,3.66,3.51,3.37,3.21,3.02,2.85,2.65,2.48,2.29,2.11,1.90,1.72,1.53,1.38,1.25,1.12,1,0.85,0.67,0.54,0.50,0.50,0.48,0.37,0.27,0.25,0.34,0.37,0.25,-0.02,-0.09,-0.22,-0.55,-1.21,-4.36,-7.84,-8.27,-4.79,-1.78,-0.59,0.60,0.63,-0.64,-0.50,0.38,0.24,-0.92,-1.60,-2.88,-5.58,-6.91,-6.25,-6.14,-6.23,-6.17,-6.60,-7.48,-8.66,-9.57,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.73,-9.72,-9.89,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.80,-9.10,-8.25,-7.26,-6.13,-4.93,14,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.85,13.73,13.57,13.39,13.26,13.14,13.08,13.02,13,12.99,12.98,12.98,12.98,12.97,12.97,12.96,12.92,12.87,12.85,12.79,12.74,12.65,12.58,12.49,12.38,12.28,12.20,12.12,12.07,12.01,11.99,11.98,11.97,11.96,11.96,11.96,11.95,11.92,11.90,11.87,11.83,11.75,11.66,11.59,11.49,11.38,11.29,11.23,11.14,11.10,11.04,11.01,11,10.99,10.98,10.97,10.97,10.97,10.97,10.97,10.96,10.96,10.92,10.88,10.79,10.66,10.51,10.37,10.23,10.12,10.03,10,10,9.99,9.99,9.98,9.95,9.85,9.71,9.54,9.39,9.25,9.13,9.04,9,8.99,8.98,8.97,8.97,8.97,8.96,8.92,8.89,8.85,8.75,8.62,8.45,8.22,7.92,7.64,7.39,7.17,7.01,6.87,6.74,6.59,6.45,6.28,6.11,5.88,5.62,5.36,5.12,4.91,4.75,4.59,4.45,4.29,4.17,4.08,3.98,3.86,3.73,3.58,3.39,3.24,3.04,2.86,2.65,2.47,2.26,2.09,1.89,1.71,1.50,1.33,1.15,1.02,0.92,0.83,0.67,0.52,0.37,0.34,0.40,0.40,0.29,0.07,0.10,0.20,0.20,-0.13,-0.38,-0.40,-0.53,-1.08,-2.30,-5.70,-8.72,-8.17,-4.68,-1.55,0.58,-0.61,-0.67,-1,-1.13,-1.09,-1.98,-2.58,-3.97,-6.26,-8.95,-9.46,-8.07,-7.61,-7.12,-7.10,-7.39,-8,-8.74,-9.39,-9.88,-10,-10,-10,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-10,-10,-9.98,-9.85,-10,-10,-10,-11,-11,-11,-11,-12,-12,-11,-11,-11,-11,-11,-10,-10,-9.26,-8.42,-7.49,-6.41,-5.30,14,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.85,13.73,13.57,13.39,13.26,13.15,13.09,13.02,13,13,12.99,12.98,12.97,12.97,12.96,12.95,12.91,12.86,12.82,12.76,12.72,12.63,12.57,12.48,12.37,12.28,12.21,12.12,12.07,12.01,11.99,11.97,11.96,11.96,11.96,11.95,11.95,11.91,11.90,11.87,11.83,11.75,11.67,11.59,11.50,11.39,11.29,11.23,11.14,11.10,11.04,11.01,11,10.99,10.98,10.97,10.97,10.97,10.96,10.96,10.96,10.96,10.95,10.90,10.85,10.75,10.62,10.47,10.32,10.17,10.09,10.01,10,9.99,9.99,9.99,9.98,9.92,9.83,9.67,9.52,9.37,9.24,9.12,9.04,9,8.98,8.97,8.97,8.96,8.95,8.91,8.88,8.84,8.75,8.63,8.50,8.32,8.10,7.84,7.58,7.33,7.11,6.90,6.74,6.58,6.40,6.25,6.10,5.91,5.73,5.50,5.25,5.01,4.82,4.62,4.45,4.29,4.16,4.09,3.99,3.88,3.76,3.62,3.47,3.27,3.10,2.89,2.67,2.48,2.25,2.07,1.87,1.70,1.50,1.32,1.11,0.91,0.76,0.66,0.62,0.53,0.45,0.35,0.35,0.42,0.45,0.34,0.12,0.02,-0.03,-0.25,-0.72,-1.39,-1.41,-1.59,-1.78,-4.95,-7.27,-8.95,-7.03,-3.79,-1.57,0.57,-0.83,-1.64,-2.54,-3.14,-3.52,-3.86,-4.55,-5.68,-7.29,-8.77,-8.79,-8.46,-7.96,-7.65,-7.58,-7.80,-8.22,-8.74,-9.24,-9.64,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-14,-14,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-9.84,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.52,-8.72,-7.80,-6.80,-5.74,14,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.85,13.73,13.57,13.39,13.25,13.15,13.09,13.02,13,13,12.99,12.98,12.97,12.96,12.95,12.91,12.87,12.84,12.78,12.74,12.66,12.61,12.52,12.46,12.37,12.27,12.21,12.12,12.07,12.01,11.99,11.97,11.95,11.92,11.92,11.92,11.92,11.91,11.90,11.87,11.83,11.76,11.67,11.60,11.50,11.39,11.29,11.23,11.14,11.10,11.04,11.01,11,10.99,10.98,10.97,10.96,10.96,10.96,10.96,10.96,10.95,10.95,10.91,10.87,10.79,10.70,10.57,10.40,10.26,10.13,10.07,10,9.99,9.99,9.99,9.98,9.97,9.91,9.82,9.65,9.50,9.36,9.22,9.11,9.03,9,8.98,8.97,8.96,8.95,8.91,8.88,8.84,8.75,8.64,8.51,8.37,8.21,8,7.77,7.52,7.27,7.02,6.79,6.60,6.40,6.24,6.09,5.92,5.75,5.57,5.37,5.14,4.95,4.73,4.51,4.34,4.20,4.09,4,3.90,3.82,3.67,3.52,3.35,3.15,2.96,2.74,2.50,2.26,2.03,1.83,1.64,1.48,1.32,1.13,0.91,0.70,0.50,0.38,0.38,0.42,0.47,0.48,0.50,0.57,0.58,0.50,0.33,0.08,-0.25,-0.68,-2.74,-3.47,-3.75,-4.21,-5.53,-7.49,-9.41,-9.90,-7.32,-3.40,-2.07,-2.27,-2.41,-3.65,-4.37,-4.96,-5.26,-5.58,-6.01,-6.75,-7.62,-8.36,-8.46,-8.29,-8.01,-7.88,-7.85,-8.07,-8.36,-8.74,-9.15,-9.50,-9.77,-9.96,-10,-10,-10,-10,-9.99,-9.96,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-9.87,-10,-10,-11,-11,-12,-12,-12,-13,-13,-12,-12,-12,-12,-11,-11,-10,-9.84,-9.04,-8.17,-7.24,-6.18,14,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.85,13.73,13.57,13.39,13.25,13.14,13.09,13.03,13,13,12.99,12.98,12.97,12.96,12.95,12.91,12.86,12.82,12.75,12.70,12.62,12.57,12.49,12.40,12.35,12.26,12.20,12.12,12.04,12,11.97,11.95,11.91,11.91,11.90,11.90,11.90,11.90,11.89,11.87,11.83,11.76,11.67,11.60,11.50,11.39,11.29,11.23,11.14,11.10,11.04,11.01,11,10.99,10.98,10.97,10.96,10.96,10.96,10.95,10.95,10.95,10.92,10.90,10.89,10.86,10.75,10.63,10.49,10.35,10.22,10.11,10.03,10,9.99,9.99,9.98,9.98,9.97,9.89,9.78,9.64,9.49,9.33,9.20,9.10,9.02,8.99,8.97,8.96,8.95,8.91,8.87,8.83,8.75,8.63,8.51,8.38,8.25,8.11,7.95,7.74,7.50,7.25,6.97,6.71,6.48,6.27,6.12,5.96,5.78,5.61,5.41,5.24,5.04,4.87,4.64,4.45,4.25,4.12,4,3.92,3.84,3.73,3.59,3.40,3.23,3.01,2.79,2.57,2.29,2.03,1.78,1.59,1.41,1.28,1.16,1,0.79,0.53,0.26,0.10,0.22,0.39,0.53,0.62,0.67,0.73,0.74,0.70,0.59,0.14,-0.46,-2.96,-5.33,-5.90,-6.84,-7.53,-8.66,-10,-11,-10,-8.32,-5.68,-5.16,-4.96,-5.21,-5.60,-6.10,-6.54,-6.74,-6.96,-7.17,-7.52,-7.93,-8.24,-8.33,-8.22,-8.05,-8.04,-8.07,-8.26,-8.51,-8.82,-9.15,-9.47,-9.72,-9.88,-9.96,-10,-9.99,-9.88,-9.80,-9.80,-9.91,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.38,-8.58,-7.65,-6.63,14,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.85,13.73,13.57,13.39,13.25,13.14,13.08,13.03,13,13,12.99,12.98,12.97,12.96,12.95,12.91,12.86,12.78,12.73,12.64,12.58,12.50,12.42,12.37,12.29,12.24,12.16,12.11,12.03,11.99,11.95,11.89,11.87,11.87,11.87,11.87,11.88,11.87,11.87,11.86,11.83,11.75,11.67,11.60,11.50,11.39,11.29,11.23,11.14,11.10,11.04,11.01,11,10.99,10.98,10.97,10.97,10.97,10.96,10.96,10.95,10.95,10.92,10.91,10.88,10.85,10.75,10.64,10.51,10.38,10.25,10.14,10.08,10.01,10,9.99,9.98,9.98,9.97,9.95,9.87,9.75,9.61,9.45,9.28,9.16,9.08,9,8.98,8.96,8.95,8.90,8.87,8.82,8.74,8.63,8.51,8.39,8.26,8.14,8.01,7.87,7.71,7.48,7.20,6.89,6.61,6.37,6.16,6.01,5.87,5.70,5.49,5.28,5.12,4.98,4.78,4.60,4.37,4.20,4.04,3.95,3.85,3.74,3.61,3.45,3.25,3.07,2.85,2.62,2.35,2.08,1.79,1.54,1.37,1.24,1.13,1.04,0.95,0.75,0.52,0.27,0.12,0.25,0.47,0.63,0.76,0.83,0.85,0.84,0.77,0.63,0.15,-0.65,-3.25,-6.18,-7.72,-9.02,-10,-11,-11,-11,-11,-9.62,-8.35,-7.73,-7.42,-7.38,-7.46,-7.67,-7.91,-7.96,-8.07,-8.12,-8.18,-8.30,-8.36,-8.38,-8.30,-8.21,-8.24,-8.29,-8.45,-8.67,-8.93,-9.23,-9.49,-9.71,-9.86,-9.93,-9.91,-9.87,-9.79,-9.76,-9.79,-9.93,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-9.64,-8.91,-8.09,-7,14,14,14,14,13.99,13.99,13.98,13.97,13.91,13.85,13.73,13.57,13.39,13.25,13.14,13.08,13.02,13,13,12.99,12.98,12.97,12.96,12.95,12.91,12.86,12.78,12.72,12.62,12.53,12.46,12.37,12.32,12.25,12.20,12.13,12.08,12.01,11.97,11.90,11.86,11.82,11.78,11.77,11.77,11.79,11.84,11.85,11.86,11.84,11.75,11.66,11.59,11.50,11.39,11.29,11.22,11.14,11.10,11.04,11.01,11,10.99,10.98,10.98,10.97,10.98,10.97,10.95,10.95,10.92,10.91,10.89,10.87,10.83,10.74,10.63,10.51,10.39,10.27,10.16,10.10,10.03,10,9.99,9.98,9.98,9.97,9.96,9.91,9.84,9.71,9.54,9.38,9.25,9.13,9.04,9,8.97,8.95,8.90,8.87,8.82,8.73,8.62,8.50,8.38,8.26,8.15,8.04,7.95,7.79,7.63,7.39,7.12,6.82,6.51,6.27,6.10,5.96,5.79,5.62,5.39,5.21,5.03,4.88,4.73,4.52,4.33,4.12,3.98,3.86,3.74,3.61,3.46,3.27,3.09,2.87,2.64,2.37,2.10,1.82,1.54,1.34,1.16,1.07,1,0.98,0.90,0.79,0.63,0.49,0.40,0.46,0.59,0.72,0.82,0.86,0.86,0.82,0.74,0.60,0.02,-1.32,-3.01,-5.95,-8.04,-9.75,-11,-12,-12,-12,-11,-10,-10,-9.80,-9.46,-9.22,-8.99,-8.95,-9,-8.92,-8.92,-8.88,-8.77,-8.73,-8.66,-8.60,-8.51,-8.43,-8.45,-8.51,-8.63,-8.83,-9.07,-9.33,-9.55,-9.74,-9.86,-9.90,-9.90,-9.88,-9.86,-9.86,-9.91,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-13,-13,-13,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.79,-9.18,-8.50,-7.63,14,14,14,14,13.99,13.99,13.97,13.91,13.85,13.73,13.57,13.39,13.25,13.13,13.08,13.02,13,13,12.99,12.98,12.98,12.96,12.95,12.91,12.87,12.78,12.72,12.62,12.51,12.41,12.34,12.25,12.20,12.13,12.09,12.03,11.99,11.95,11.87,11.83,11.75,11.72,11.66,11.65,11.66,11.71,11.74,11.76,11.76,11.73,11.65,11.59,11.50,11.39,11.28,11.22,11.13,11.09,11.03,11.01,11,10.99,10.98,10.98,10.98,10.97,10.97,10.96,10.95,10.91,10.90,10.88,10.85,10.78,10.73,10.62,10.50,10.39,10.28,10.17,10.11,10.04,10,10,9.99,9.98,9.97,9.96,9.92,9.88,9.77,9.63,9.49,9.34,9.21,9.11,9.02,8.98,8.95,8.90,8.87,8.79,8.73,8.62,8.50,8.38,8.26,8.15,8.04,7.96,7.85,7.72,7.53,7.29,7,6.71,6.41,6.21,6.02,5.89,5.74,5.54,5.34,5.12,4.97,4.79,4.63,4.45,4.24,4.03,3.87,3.73,3.59,3.42,3.25,3.08,2.87,2.63,2.38,2.11,1.82,1.53,1.28,1.08,0.88,0.79,0.78,0.85,0.87,0.86,0.78,0.70,0.62,0.60,0.62,0.67,0.72,0.73,0.73,0.67,0.50,0.25,-0.89,-2.38,-4.16,-6.16,-8.12,-9.67,-10,-11,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.90,-9.80,-9.63,-9.54,-9.46,-9.27,-9.13,-9,-8.86,-8.74,-8.65,-8.63,-8.68,-8.80,-8.99,-9.21,-9.43,-9.64,-9.80,-9.91,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-12,-10,-9.93,-9.63,-9.41,-9.26,-9.18,-9.18,-9.27,-9.47,-9.73,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-9.85,-9.39,-8.93,-8.50,14,14,14,14,13.99,13.98,13.92,13.86,13.74,13.58,13.39,13.25,13.12,13.08,13.02,13,12.99,12.99,12.98,12.98,12.97,12.95,12.91,12.87,12.78,12.72,12.62,12.50,12.39,12.32,12.23,12.14,12.10,12.03,12,11.95,11.89,11.85,11.77,11.72,11.64,11.59,11.53,11.51,11.53,11.58,11.62,11.64,11.63,11.61,11.54,11.48,11.38,11.28,11.21,11.13,11.09,11.03,11.01,11,10.99,10.98,10.98,10.97,10.97,10.97,10.96,10.95,10.91,10.90,10.87,10.84,10.77,10.71,10.61,10.50,10.39,10.28,10.20,10.12,10.04,10.01,10,9.99,9.98,9.97,9.97,9.95,9.90,9.86,9.73,9.58,9.41,9.27,9.15,9.07,9,8.96,8.90,8.87,8.79,8.72,8.62,8.50,8.38,8.26,8.15,8.04,7.96,7.86,7.75,7.60,7.40,7.15,6.88,6.60,6.33,6.12,5.96,5.82,5.64,5.46,5.25,5.03,4.87,4.70,4.51,4.33,4.12,3.91,3.74,3.57,3.38,3.21,3,2.83,2.61,2.37,2.10,1.79,1.51,1.25,1.01,0.77,0.57,0.42,0.48,0.65,0.79,0.87,0.86,0.82,0.73,0.57,0.37,0.25,0.26,0.37,0.49,0.45,-0.63,-1.73,-2.78,-4.03,-5.50,-6.99,-8.52,-9.87,-11,-12,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-10,-10,-10,-9.86,-9.67,-9.48,-9.30,-9.11,-8.93,-8.82,-8.77,-8.79,-8.89,-9.10,-9.33,-9.55,-9.76,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-12,-12,-13,-14,-14,-13,-12,-9.74,-8.50,-8.22,-8.02,-8.68,-8.62,-7.80,-8.80,-10,-9.89,-9.57,-9.80,-9.49,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-10,-10,-9.79,-9.53,-9.33,-9.21,14,14,14,13.99,13.99,13.97,13.89,13.77,13.61,13.40,13.25,13.12,13.08,13.02,13,12.99,12.99,12.98,12.97,12.97,12.96,12.91,12.88,12.78,12.72,12.62,12.50,12.39,12.28,12.21,12.12,12.07,12,11.96,11.89,11.86,11.78,11.74,11.66,11.60,11.51,11.46,11.39,11.37,11.39,11.42,11.48,11.50,11.50,11.48,11.42,11.36,11.27,11.21,11.12,11.08,11.03,11.01,11,10.99,10.98,10.98,10.97,10.97,10.97,10.96,10.95,10.91,10.90,10.87,10.84,10.76,10.70,10.61,10.50,10.38,10.28,10.20,10.12,10.07,10.01,10,9.99,9.98,9.97,9.97,9.95,9.91,9.87,9.79,9.65,9.50,9.35,9.22,9.11,9.01,8.97,8.90,8.86,8.78,8.72,8.62,8.50,8.37,8.25,8.14,8.04,7.96,7.86,7.75,7.62,7.47,7.25,7,6.74,6.47,6.22,6.01,5.85,5.70,5.52,5.34,5.13,4.92,4.75,4.57,4.37,4.20,3.99,3.77,3.58,3.36,3.14,2.95,2.73,2.52,2.32,2.04,1.75,1.48,1.22,0.98,0.75,0.50,0.25,-0.11,0.20,0.37,0.67,0.75,0.75,0.73,0.65,0.33,-0.03,-0.35,-0.37,-0.16,-0.40,-1.71,-2.71,-3.74,-4.71,-5.75,-6.87,-8.03,-9.15,-10,-11,-12,-14,-14,-15,-14,-14,-13,-13,-12,-11,-11,-10,-10,-10,-10,-9.93,-9.77,-9.57,-9.34,-9.08,-8.88,-8.87,-8.91,-9.05,-9.27,-9.51,-9.76,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.99,-9.88,-9.97,-10,-11,-11,-12,-11,-11,-10,-8.71,-7.86,-7.46,-7.25,-7.99,-8.86,-8.73,-8.72,-10,-11,-11,-10,-9.40,-10,-11,-11,-10,-9.61,-9.91,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.76,-9.65,-9.61,-9.63,14,14,13.99,13.99,13.98,13.91,13.83,13.65,13.49,13.33,13.17,13.10,13.02,13,12.99,12.98,12.98,12.97,12.96,12.95,12.91,12.87,12.78,12.71,12.62,12.50,12.39,12.28,12.21,12.12,12.04,11.99,11.91,11.86,11.79,11.74,11.67,11.62,11.53,11.47,11.38,11.33,11.26,11.25,11.25,11.29,11.34,11.36,11.37,11.35,11.32,11.25,11.17,11.12,11.08,11.03,11,11,10.99,10.98,10.98,10.97,10.97,10.97,10.96,10.95,10.91,10.89,10.87,10.83,10.76,10.67,10.60,10.49,10.37,10.28,10.20,10.12,10.07,10.01,10,9.99,9.98,9.97,9.97,9.95,9.91,9.87,9.83,9.73,9.58,9.40,9.26,9.13,9.03,8.97,8.90,8.85,8.77,8.71,8.60,8.49,8.37,8.25,8.13,8.03,7.96,7.86,7.75,7.62,7.48,7.29,7.10,6.85,6.59,6.34,6.10,5.88,5.72,5.54,5.37,5.20,5,4.82,4.62,4.42,4.24,4.03,3.84,3.61,3.37,3.12,2.87,2.64,2.41,2.20,1.97,1.71,1.42,1.14,0.89,0.70,0.50,0.28,0.10,-0.09,0.04,0.11,0.14,0.20,0.21,0.21,0.29,-0.03,-0.52,-1.04,-1.53,-2.39,-3.03,-3.89,-4.87,-5.78,-6.52,-7.32,-8.14,-9,-9.87,-10,-11,-12,-14,-14,-15,-14,-14,-14,-13,-13,-12,-11,-11,-11,-10,-10,-10,-9.95,-9.83,-9.49,-9.21,-9.01,-9,-9.11,-9.27,-9.51,-9.78,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.93,-9.43,-9.01,-8.67,-9.95,-10,-10,-9.79,-9.37,-8.88,-8.24,-8.20,-7.23,-6.36,-6.98,-6.99,-7.90,-8.84,-8.76,-8.65,-9.50,-10,-9.74,-8.53,-7.99,-9.22,-11,-11,-10,-9.24,-9.73,-10,-10,-11,-11,-12,-13,-13,-14,-14,-14,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.83,-9.80,-9.86,-9.87,14,14,13.98,13.97,13.92,13.86,13.74,13.58,13.38,13.24,13.12,13.04,13.01,13,12.99,12.98,12.97,12.96,12.92,12.90,12.87,12.79,12.71,12.61,12.50,12.39,12.28,12.20,12.12,12.03,11.97,11.89,11.84,11.75,11.67,11.62,11.53,11.48,11.40,11.34,11.26,11.21,11.15,11.14,11.15,11.20,11.22,11.24,11.24,11.23,11.20,11.14,11.11,11.07,11.02,11,11,10.99,10.98,10.98,10.97,10.97,10.97,10.96,10.95,10.92,10.89,10.87,10.83,10.76,10.67,10.60,10.49,10.37,10.27,10.20,10.12,10.07,10.02,10,9.99,9.98,9.97,9.96,9.95,9.91,9.87,9.83,9.74,9.62,9.47,9.29,9.16,9.04,8.97,8.89,8.85,8.76,8.67,8.59,8.47,8.35,8.23,8.11,8,7.91,7.84,7.74,7.62,7.49,7.33,7.13,6.91,6.67,6.42,6.17,5.96,5.75,5.58,5.39,5.24,5.07,4.87,4.67,4.50,4.29,4.11,3.89,3.66,3.40,3.13,2.87,2.60,2.34,2.10,1.87,1.62,1.38,1.13,0.87,0.60,0.41,0.35,0.33,0.27,0.20,0.03,-0.21,-0.42,-0.60,-0.66,-0.61,-0.86,-1.34,-2.43,-3.20,-4.01,-4.68,-5.46,-6.25,-7.02,-7.72,-8.17,-8.68,-9.22,-9.79,-10,-11,-12,-12,-14,-14,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.67,-9.39,-9.23,-9.24,-9.37,-9.58,-9.85,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-15,-15,-14,-14,-13,-12,-12,-12,-11,-11,-11,-11,-11,-12,-12,-11,-11,-11,-10,-10,-9.33,-8.63,-8,-10,-11,-11,-11,-8.59,-7.02,-6.57,-6.77,-6.89,-6.01,-4.98,-4.90,-5.05,-5.32,-6.26,-6.22,-5.25,-5.16,-5.27,-3.59,-3.76,-4.45,-6.28,-9.32,-9.91,-9.47,-9.33,-9.85,-10,-10,-11,-12,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,13.99,13.99,13.98,13.95,13.88,13.78,13.63,13.47,13.29,13.15,13.09,13.02,13,12.99,12.98,12.97,12.96,12.91,12.89,12.86,12.79,12.71,12.61,12.50,12.39,12.28,12.20,12.12,12.03,11.97,11.88,11.82,11.73,11.64,11.54,11.48,11.39,11.34,11.27,11.22,11.15,11.12,11.09,11.09,11.10,11.11,11.12,11.13,11.13,11.12,11.11,11.09,11.04,11.02,11,11,10.99,10.98,10.98,10.97,10.97,10.97,10.96,10.95,10.92,10.89,10.87,10.83,10.76,10.67,10.60,10.49,10.37,10.27,10.20,10.12,10.08,10.02,10,9.99,9.98,9.97,9.96,9.95,9.91,9.87,9.83,9.75,9.63,9.50,9.34,9.17,9.04,8.95,8.86,8.79,8.75,8.66,8.54,8.45,8.32,8.17,8.07,7.97,7.87,7.78,7.71,7.61,7.48,7.34,7.15,6.97,6.75,6.50,6.25,6.01,5.78,5.60,5.41,5.25,5.10,4.92,4.75,4.57,4.37,4.16,3.97,3.74,3.49,3.21,2.88,2.59,2.28,2.01,1.76,1.53,1.36,1.16,0.96,0.71,0.36,0.13,0.35,0.42,0.49,0.58,0.08,-0.41,-1.08,-1.46,-2.70,-3.46,-3.83,-4.02,-4.50,-5.21,-6.13,-6.79,-7.57,-8.23,-8.87,-9.38,-9.63,-9.89,-10,-10,-10,-11,-12,-12,-13,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.88,-9.63,-9.49,-9.51,-9.71,-9.93,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-13,-13,-14,-15,-15,-16,-16,-16,-16,-15,-14,-14,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.52,-8.64,-8.49,-10,-12,-14,-13,-12,-10,-7.32,-5.96,-5.62,-5.33,-4.15,-3.01,-2.23,-2.41,-2.82,-3.08,-3,-2.72,-2.24,-1.08,-0.87,-1.15,-2.61,-4.91,-7.86,-9.54,-9.72,-10,-10,-10,-11,-11,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,13.99,13.98,13.96,13.90,13.83,13.70,13.51,13.36,13.22,13.12,13.04,13,12.99,12.98,12.97,12.96,12.92,12.88,12.85,12.77,12.71,12.60,12.50,12.39,12.28,12.20,12.11,12.02,11.97,11.88,11.82,11.72,11.62,11.51,11.42,11.35,11.26,11.22,11.15,11.12,11.09,11.04,11.02,11.02,11.03,11.03,11.04,11.07,11.07,11.07,11.04,11.02,11.01,11,11,10.99,10.98,10.98,10.98,10.97,10.97,10.96,10.95,10.92,10.90,10.87,10.83,10.75,10.67,10.60,10.49,10.37,10.27,10.20,10.12,10.08,10.02,10,9.99,9.98,9.97,9.96,9.95,9.91,9.87,9.83,9.74,9.63,9.50,9.36,9.21,9.03,8.90,8.79,8.72,8.65,8.61,8.52,8.41,8.27,8.14,8,7.88,7.78,7.71,7.62,7.53,7.45,7.33,7.17,7,6.79,6.58,6.33,6.08,5.85,5.62,5.42,5.26,5.12,4.97,4.82,4.63,4.46,4.25,4.03,3.83,3.58,3.27,2.96,2.62,2.28,1.99,1.67,1.49,1.32,1.15,1.02,0.86,0.65,0.48,0.37,0.47,0.60,0.67,0.60,0.12,-0.50,-1.34,-2.78,-4.59,-6.22,-6.63,-6.24,-6.37,-6.89,-7.68,-8.40,-9.13,-9.73,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.89,-9.80,-9.87,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-13,-13,-14,-15,-15,-16,-16,-16,-16,-15,-14,-13,-12,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-9.99,-8.99,-8.65,-9.27,-10,-10,-11,-11,-9.55,-9.36,-6.58,-4.05,-3.08,-2.77,-1.66,-0.63,-0.53,-0.93,-1.38,-1.66,-1.66,-1.36,-0.88,-0.40,-0.08,-0.46,-1.97,-4.30,-7.95,-9.99,-10,-10,-10,-10,-11,-12,-12,-13,-14,-15,-15,-15,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-10,-10,-10,-10,-10,13.99,13.97,13.92,13.85,13.72,13.53,13.37,13.25,13.13,13.07,13.01,13,12.98,12.97,12.95,12.91,12.89,12.84,12.76,12.70,12.59,12.49,12.38,12.28,12.20,12.11,12.02,11.96,11.88,11.79,11.72,11.62,11.50,11.39,11.32,11.23,11.15,11.12,11.09,11.04,11.02,11.01,11,11,11,11,11.01,11.01,11.01,11.01,11,11,11,11,10.99,10.99,10.98,10.98,10.97,10.97,10.96,10.96,10.95,10.90,10.87,10.83,10.75,10.67,10.60,10.49,10.38,10.27,10.20,10.12,10.08,10.03,10,9.99,9.98,9.97,9.96,9.95,9.91,9.87,9.82,9.74,9.62,9.50,9.36,9.21,9.04,8.88,8.75,8.63,8.54,8.49,8.42,8.36,8.25,8.12,7.97,7.83,7.70,7.59,7.50,7.41,7.35,7.25,7.14,7.01,6.85,6.63,6.38,6.13,5.87,5.64,5.45,5.25,5.10,4.96,4.82,4.65,4.49,4.32,4.12,3.89,3.64,3.37,3.02,2.66,2.33,1.98,1.66,1.45,1.27,1.15,1.07,0.97,0.86,0.73,0.62,0.59,0.63,0.75,0.77,0.62,0.21,-0.40,-1.16,-3.07,-5.86,-8.68,-8.73,-7.89,-7.83,-8.21,-8.89,-9.65,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-13,-13,-13,-14,-14,-14,-13,-13,-13,-12,-12,-12,-13,-13,-14,-15,-15,-16,-16,-16,-16,-15,-14,-13,-11,-10,-10,-10,-11,-10,-10,-10,-10,-11,-12,-12,-12,-10,-9.66,-8.38,-10,-10,-8.10,-7.62,-4.96,-3.62,-4.89,-4.04,-3.01,-1.47,-0.65,-0.48,-0.17,0.11,0.11,-0.26,-0.71,-1,-1,-0.71,-0.28,0,0.15,-0.38,-1.11,-3.37,-7,-9.28,-11,-10,-11,-11,-12,-12,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,13.98,13.96,13.87,13.72,13.54,13.39,13.25,13.14,13.08,13.02,13,12.98,12.97,12.95,12.91,12.88,12.85,12.75,12.67,12.59,12.49,12.37,12.28,12.20,12.11,12.02,11.96,11.87,11.79,11.72,11.61,11.50,11.39,11.28,11.21,11.13,11.09,11.04,11.02,11.01,11,11,11,11,11,11,11,11,11,11,11,10.99,10.99,10.99,10.98,10.98,10.98,10.98,10.97,10.97,10.96,10.95,10.91,10.87,10.83,10.75,10.67,10.59,10.49,10.38,10.28,10.20,10.12,10.08,10.03,10,9.99,9.98,9.97,9.97,9.95,9.91,9.87,9.83,9.74,9.62,9.50,9.36,9.21,9.03,8.87,8.72,8.58,8.46,8.37,8.29,8.25,8.15,8.07,7.91,7.76,7.62,7.48,7.36,7.25,7.17,7.12,7.03,6.97,6.85,6.67,6.47,6.21,5.92,5.67,5.46,5.25,5.08,4.90,4.76,4.62,4.47,4.29,4.12,3.92,3.71,3.46,3.12,2.75,2.37,1.99,1.65,1.41,1.25,1.13,1.07,1,0.95,0.87,0.79,0.75,0.74,0.75,0.77,0.82,0.66,0.36,-0.15,-0.83,-2.20,-6.17,-9.08,-9.57,-8.90,-8.87,-9.27,-9.99,-10,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-15,-15,-13,-14,-13,-10,-9.73,-10,-11,-11,-10,-11,-11,-11,-12,-12,-11,-10,-9.14,-10,-12,-11,-7.90,-3.23,-1.29,-0.30,-0.96,-0.75,0.07,0.12,0.15,0.25,0.39,0.51,0.50,0.25,-0.10,-0.37,-0.38,-0.13,0.14,0.23,0,-0.43,-1.13,-2.59,-5,-8.42,-11,-10,-11,-12,-12,-13,-13,-14,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,13.97,13.92,13.75,13.57,13.39,13.25,13.14,13.08,13.03,13,12.99,12.97,12.95,12.91,12.88,12.85,12.77,12.67,12.59,12.48,12.37,12.27,12.20,12.11,12.02,11.95,11.87,11.78,11.71,11.61,11.50,11.39,11.28,11.21,11.12,11.08,11.03,11.01,11,11,11,10.99,10.99,10.99,10.99,10.99,10.99,10.99,10.99,10.99,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10.97,10.96,10.95,10.91,10.89,10.84,10.75,10.66,10.59,10.49,10.38,10.28,10.20,10.12,10.08,10.02,10,10,9.99,9.98,9.97,9.96,9.92,9.89,9.84,9.75,9.63,9.50,9.37,9.21,9.02,8.86,8.70,8.52,8.37,8.25,8.16,8.11,8.03,7.97,7.86,7.73,7.57,7.39,7.25,7.12,7,6.92,6.87,6.83,6.75,6.65,6.50,6.26,6,5.73,5.48,5.25,5.03,4.87,4.71,4.53,4.38,4.23,4.04,3.87,3.67,3.48,3.20,2.83,2.41,2,1.65,1.40,1.24,1.12,1.04,1,0.98,0.92,0.88,0.85,0.78,0.76,0.76,0.75,0.72,0.67,0.51,0.15,-0.84,-2.47,-6.08,-8.43,-9.32,-9.65,-10,-10,-11,-12,-12,-13,-13,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-14,-14,-14,-17,-17,-12,-9.01,-9.43,-10,-9.80,-9.29,-10,-10,-10,-10,-10,-10,-9.74,-9.17,-11,-13,-10,-6.11,-1.47,-0.23,-0.11,0.03,0.39,0.50,0.61,0.66,0.72,0.75,0.77,0.75,0.60,0.34,0.09,0.02,0.15,0.42,0.25,-0.01,-0.43,-1.11,-2.39,-4.50,-7.70,-10,-12,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,13.91,13.75,13.58,13.39,13.25,13.14,13.08,13.03,13,12.99,12.97,12.96,12.91,12.88,12.85,12.77,12.71,12.61,12.49,12.37,12.27,12.20,12.11,12.01,11.95,11.86,11.76,11.67,11.59,11.49,11.38,11.28,11.21,11.13,11.08,11.02,11,11,10.99,10.99,10.99,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10.97,10.97,10.97,10.97,10.97,10.96,10.95,10.92,10.89,10.86,10.76,10.67,10.59,10.49,10.38,10.28,10.20,10.12,10.08,10.02,10,10,9.99,9.98,9.98,9.97,9.95,9.91,9.87,9.78,9.67,9.53,9.38,9.22,9.02,8.85,8.65,8.48,8.32,8.16,8.04,7.98,7.90,7.85,7.75,7.64,7.51,7.36,7.17,7,6.87,6.75,6.66,6.62,6.60,6.54,6.47,6.29,6.07,5.79,5.51,5.26,5.02,4.83,4.63,4.47,4.28,4.11,3.92,3.75,3.57,3.37,3.15,2.88,2.46,2,1.64,1.38,1.22,1.11,1.03,1,0.98,0.96,0.92,0.87,0.82,0.74,0.66,0.62,0.58,0.52,0.47,0.50,0.49,-0.97,-3.79,-6.57,-8.49,-9.70,-10,-12,-13,-14,-14,-14,-14,-15,-16,-15,-14,-12,-12,-12,-12,-12,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-12,-12,-12,-12,-12,-12,-13,-13,-14,-15,-15,-15,-10,-6.33,-6.92,-8.79,-7.43,-7.95,-9.41,-8.70,-9.04,-9.75,-9.99,-10,-9.80,-9.36,-11,-12,-8.16,-2.70,-0.57,-0.28,-0.16,0.02,0.27,0.54,0.76,0.87,0.91,0.92,0.91,0.90,0.82,0.63,0.41,0.26,0.17,0.16,0.16,0.07,-0.29,-0.98,-1.99,-4.15,-6.98,-11,-13,-14,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,13.74,13.59,13.39,13.25,13.12,13.08,13.03,13,13,12.98,12.96,12.92,12.89,12.86,12.78,12.71,12.61,12.50,12.38,12.27,12.20,12.11,12.01,11.92,11.85,11.75,11.66,11.58,11.48,11.38,11.28,11.22,11.13,11.09,11.03,11,10.99,10.99,10.98,10.99,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10.97,10.97,10.97,10.97,10.97,10.97,10.97,10.97,10.96,10.95,10.92,10.89,10.86,10.78,10.70,10.59,10.49,10.37,10.27,10.20,10.12,10.08,10.02,10,10,9.99,9.99,9.98,9.97,9.97,9.95,9.90,9.85,9.75,9.62,9.45,9.25,9.04,8.85,8.63,8.41,8.23,8.07,7.92,7.84,7.75,7.70,7.62,7.54,7.45,7.32,7.14,6.98,6.78,6.63,6.50,6.41,6.38,6.38,6.36,6.25,6.10,5.87,5.60,5.32,5.04,4.82,4.61,4.40,4.22,4.01,3.82,3.62,3.40,3.21,3.02,2.77,2.39,2,1.62,1.37,1.20,1.10,1.02,1,0.98,0.97,0.95,0.90,0.85,0.74,0.61,0.46,0.34,0.24,0.21,0.14,0.07,-0.05,-3.13,-5.98,-8,-9.45,-10,-13,-14,-16,-17,-16,-15,-15,-17,-20,-18,-14,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-13,-13,-13,-12,-12,-12,-12,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-11,-10,-13,-15,-13,-11,-8.32,-5.93,-5.68,-6.41,-7.73,-8,-9.34,-9.42,-8.68,-8.84,-8.68,-10,-10,-9.92,-10,-11,-10,-5.38,-0.99,-0.65,-0.49,-0.29,-0.09,0.22,0.50,0.74,0.91,0.97,0.98,0.98,0.96,0.90,0.79,0.60,0.29,-0.01,-0.13,-0.03,0.14,-0.02,-0.85,-1.71,-3.38,-5.87,-9.87,-13,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,13.50,13.37,13.24,13.12,13.08,13.02,13,13,12.99,12.97,12.95,12.90,12.86,12.78,12.71,12.61,12.50,12.38,12.27,12.20,12.11,12.01,11.95,11.86,11.75,11.66,11.58,11.48,11.37,11.28,11.22,11.14,11.09,11.03,11,10.99,10.98,10.97,10.98,10.98,10.98,10.97,10.97,10.97,10.97,10.97,10.97,10.97,10.97,10.97,10.97,10.97,10.96,10.96,10.96,10.96,10.96,10.95,10.92,10.89,10.86,10.79,10.72,10.61,10.49,10.38,10.28,10.20,10.12,10.08,10.02,10,10,10,9.99,9.99,9.98,9.97,9.97,9.95,9.89,9.83,9.71,9.54,9.36,9.12,8.88,8.64,8.39,8.16,7.97,7.79,7.67,7.61,7.53,7.49,7.41,7.34,7.24,7.11,6.95,6.76,6.60,6.45,6.32,6.23,6.20,6.20,6.17,6.11,5.90,5.65,5.37,5.10,4.83,4.59,4.36,4.14,3.96,3.75,3.51,3.28,3.07,2.83,2.57,2.25,1.89,1.59,1.34,1.16,1.08,1.01,1,0.98,0.97,0.96,0.92,0.88,0.78,0.64,0.46,0.24,0,-0.11,-0.16,-0.99,-1.32,-1.70,-5.62,-9.38,-10,-10,-12,-15,-18,-18,-19,-19,-16,-15,-20,-20,-20,-16,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-13,-13,-12,-12,-12,-12,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-12,-11,-9.14,-10,-10,-10,-10,-9.87,-11,-13,-10,-5.33,-2.08,-3.04,-3.88,-3.74,-4.12,-6.43,-9.36,-9.68,-9.55,-9.47,-8.80,-9,-11,-10,-8.58,-8.76,-6.99,-2.78,-0.99,-0.79,-0.63,-0.41,-0.15,0.20,0.50,0.75,0.91,0.98,0.98,0.98,0.97,0.96,0.89,0.71,0.35,-0.13,-0.52,-0.14,0.08,0,-0.76,-1.66,-2.64,-4.93,-9.38,-13,-13,-13,-15,-15,-16,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-13,-12,-11,-11,-11,-10,-10,13.25,13.20,13.11,13.07,13.02,13,13,12.99,12.98,12.95,12.91,12.87,12.79,12.72,12.62,12.50,12.38,12.27,12.20,12.11,12.01,11.95,11.86,11.76,11.66,11.58,11.48,11.37,11.28,11.22,11.13,11.09,11.03,11,10.99,10.98,10.97,10.97,10.97,10.97,10.96,10.97,10.97,10.97,10.97,10.97,10.97,10.97,10.97,10.96,10.96,10.95,10.92,10.92,10.92,10.92,10.92,10.91,10.89,10.86,10.79,10.72,10.62,10.50,10.38,10.28,10.20,10.12,10.08,10.02,10,10,10,9.99,9.99,9.99,9.98,9.97,9.97,9.95,9.88,9.82,9.67,9.50,9.26,9,8.73,8.45,8.15,7.90,7.71,7.53,7.45,7.37,7.34,7.28,7.23,7.13,7.03,6.90,6.75,6.59,6.41,6.27,6.15,6.09,6.03,6.01,6,5.88,5.72,5.48,5.17,4.87,4.59,4.33,4.11,3.88,3.70,3.48,3.25,3,2.73,2.40,2.09,1.76,1.50,1.28,1.14,1.07,1.01,1,0.98,0.98,0.97,0.96,0.91,0.87,0.75,0.59,0.36,0.11,-0.13,-0.23,-1.39,-3.85,-5.04,-5.92,-7.54,-10,-13,-12,-15,-17,-18,-18,-18,-17,-14,-15,-19,-20,-20,-17,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-13,-12,-10,-12,-13,-12,-10,-10,-10,-11,-11,-10,-10,-10,-7.72,-1.49,-0.12,-0.05,-0.05,-0.13,-0.37,-2.12,-6.04,-9.02,-7.98,-7.32,-8.29,-9.93,-11,-10,-7.05,-5.51,-3.37,-1.08,-0.86,-0.73,-0.62,-0.41,-0.12,0.25,0.57,0.77,0.89,0.95,0.92,0.91,0.91,0.91,0.87,0.72,0.40,0,-0.26,-0.13,0.08,0,-0.76,-1.66,-2.39,-4.87,-9.27,-12,-12,-12,-14,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,13.10,13.08,13.04,13.01,13,13,12.99,12.99,12.98,12.92,12.88,12.83,12.74,12.62,12.50,12.38,12.27,12.20,12.11,12.02,11.95,11.87,11.76,11.67,11.59,11.48,11.37,11.28,11.22,11.13,11.09,11.03,11,10.99,10.98,10.97,10.96,10.96,10.96,10.95,10.95,10.95,10.96,10.96,10.96,10.96,10.96,10.96,10.96,10.92,10.92,10.91,10.90,10.89,10.89,10.90,10.89,10.87,10.85,10.78,10.72,10.61,10.50,10.38,10.28,10.20,10.12,10.08,10.02,10,10,9.99,9.99,9.99,9.99,9.99,9.98,9.97,9.97,9.95,9.88,9.79,9.65,9.47,9.22,8.90,8.59,8.25,7.92,7.66,7.47,7.33,7.25,7.20,7.15,7.12,7.04,6.97,6.86,6.73,6.58,6.41,6.26,6.14,6.03,5.97,5.90,5.86,5.78,5.70,5.51,5.26,4.97,4.63,4.33,4.03,3.79,3.59,3.37,3.16,2.95,2.66,2.36,2,1.67,1.40,1.23,1.12,1.04,1,0.99,0.99,0.98,0.97,0.96,0.95,0.89,0.83,0.71,0.53,0.35,0.14,-0.04,-0.43,-2.96,-7.85,-10,-9.10,-7.97,-9.24,-12,-15,-15,-16,-14,-13,-17,-15,-12,-14,-16,-19,-19,-16,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-12,-11,-10,-10,-10,-10,-9.53,-11,-14,-14,-11,-10,-11,-9.72,-7.49,-7.29,-7.52,-8.38,-8.90,-8.72,-9.42,-10,-7,-1.64,0.48,0.50,0.49,0.40,0.20,-0.23,-2.91,-7.59,-7.46,-5.85,-9.36,-12,-11,-10,-6.49,-2.33,-1.24,-0.72,-0.54,-0.47,-0.40,-0.26,-0.01,0.37,0.61,0.77,0.85,0.84,0.75,0.72,0.70,0.72,0.72,0.65,0.48,0.17,0,-0.01,0.04,-0.02,-0.86,-1.72,-2.41,-5.72,-9.07,-11,-12,-11,-13,-14,-14,-15,-14,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,13.01,13.01,13,13,13,13,12.99,12.99,12.97,12.90,12.86,12.76,12.65,12.51,12.39,12.28,12.20,12.11,12.02,11.95,11.87,11.77,11.67,11.59,11.49,11.38,11.28,11.21,11.13,11.09,11.03,11,10.99,10.97,10.96,10.96,10.95,10.95,10.95,10.95,10.92,10.92,10.92,10.92,10.95,10.95,10.95,10.95,10.92,10.90,10.88,10.87,10.86,10.85,10.85,10.86,10.84,10.82,10.76,10.70,10.61,10.50,10.37,10.27,10.20,10.12,10.07,10.02,10,10,9.99,9.99,9.99,9.99,9.98,9.98,9.98,9.97,9.97,9.95,9.88,9.79,9.65,9.46,9.17,8.85,8.48,8.10,7.75,7.49,7.28,7.16,7.11,7.04,7.01,6.97,6.89,6.79,6.70,6.57,6.41,6.27,6.15,6.04,5.96,5.86,5.77,5.71,5.62,5.50,5.33,5.04,4.73,4.37,4.02,3.73,3.47,3.24,3.01,2.82,2.58,2.28,1.98,1.64,1.37,1.21,1.10,1.02,1,0.99,0.99,0.98,0.98,0.97,0.95,0.90,0.85,0.74,0.61,0.47,0.34,0.22,0.13,-0.91,-5.08,-11,-14,-11,-9.20,-10,-13,-17,-16,-13,-13,-15,-18,-16,-11,-13,-16,-17,-18,-18,-14,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-12,-11,-10,-9.72,-10,-9.85,-8.49,-7.67,-9.26,-11,-11,-7.86,-4.73,-4.87,-3.17,-0.49,-2.30,-2.76,-2.21,-5.58,-7.23,-7.10,-10,-8.05,-1.30,0.04,0.15,0.13,0.12,0.10,-0.03,-2.33,-7.66,-7.80,-8.14,-11,-10,-10,-9.17,-5.17,-1.48,-0.53,-0.29,-0.16,-0.13,-0.12,-0.03,0.10,0.29,0.52,0.70,0.72,0.58,0.38,0.25,0.22,0.25,0.35,0.39,0.35,0.17,0.04,0,-0.09,-0.38,-1.05,-2.57,-6.15,-7.99,-10,-11,-10,-10,-12,-12,-13,-13,-13,-13,-14,-15,-16,-16,-16,-16,-16,-15,-15,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,13,13,13,13,13,12.99,12.99,12.98,12.97,12.89,12.83,12.71,12.57,12.42,12.32,12.21,12.11,12.02,11.96,11.87,11.77,11.70,11.60,11.49,11.38,11.28,11.22,11.13,11.09,11.03,11,10.99,10.97,10.96,10.95,10.95,10.95,10.95,10.92,10.91,10.90,10.90,10.89,10.89,10.90,10.90,10.91,10.90,10.89,10.86,10.83,10.79,10.76,10.76,10.75,10.76,10.75,10.72,10.65,10.59,10.49,10.37,10.26,10.17,10.12,10.07,10.02,10,9.99,9.98,9.98,9.99,9.99,9.98,9.97,9.97,9.97,9.97,9.96,9.95,9.89,9.82,9.67,9.49,9.21,8.85,8.45,8.03,7.66,7.38,7.20,7.09,7.01,6.97,6.90,6.85,6.75,6.64,6.52,6.40,6.28,6.16,6.08,5.97,5.86,5.75,5.63,5.54,5.46,5.33,5.12,4.84,4.47,4.08,3.71,3.37,3.10,2.86,2.62,2.39,2.15,1.88,1.62,1.37,1.20,1.09,1.01,1,0.99,0.99,0.99,0.98,0.98,0.96,0.91,0.85,0.73,0.58,0.39,0.26,0.20,0.16,0.14,-1.50,-6.09,-11,-13,-11,-11,-11,-14,-16,-13,-12,-12,-15,-18,-16,-11,-14,-17,-16,-17,-17,-16,-15,-15,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-9.86,-9.73,-9.99,-9.72,-8.76,-6.17,-3.80,-2.93,-4.80,-4.55,-2.14,-1.01,-0.73,-0.37,-0.09,0.03,-0.13,-0.48,-4,-7.23,-7.55,-8.12,-5.76,-5.70,-7.32,-5.04,-4.33,-4.22,-3.05,-3.32,-5.47,-9.43,-7.86,-8.30,-9.55,-6.83,-6.73,-5.77,-3.14,-0.47,-0.16,0.02,0.14,0.17,0.17,0.16,0.17,0.25,0.36,0.47,0.41,0.20,-0.11,-0.30,-0.38,-0.29,-0.13,0,0.02,-0.03,-0.10,-0.13,-0.52,-1.57,-3.51,-5.84,-8.80,-11,-12,-12,-10,-9.84,-10,-11,-11,-11,-11,-12,-13,-15,-16,-16,-16,-16,-16,-15,-15,-14,-13,-12,-12,-11,-11,-10,-10,-10,-9.98,-10,-10,13,13,13,13,12.99,12.99,12.99,12.98,12.96,12.87,12.77,12.63,12.50,12.36,12.24,12.12,12.02,11.96,11.87,11.78,11.70,11.60,11.49,11.38,11.28,11.22,11.13,11.09,11.02,11,10.98,10.97,10.95,10.95,10.92,10.92,10.92,10.91,10.91,10.89,10.87,10.87,10.86,10.86,10.86,10.86,10.86,10.86,10.84,10.77,10.74,10.71,10.65,10.64,10.64,10.64,10.62,10.60,10.53,10.46,10.37,10.25,10.16,10.12,10.07,10.02,10,9.99,9.98,9.98,9.98,9.98,9.98,9.97,9.97,9.97,9.97,9.96,9.96,9.95,9.90,9.85,9.73,9.53,9.26,8.91,8.50,8.08,7.67,7.37,7.17,7.04,6.97,6.89,6.82,6.72,6.61,6.49,6.37,6.27,6.20,6.10,6,5.87,5.75,5.62,5.50,5.37,5.25,5.10,4.87,4.54,4.14,3.75,3.37,3.03,2.74,2.47,2.23,2,1.76,1.53,1.34,1.17,1.08,1.01,1,0.99,0.99,0.98,0.98,0.98,0.97,0.95,0.87,0.75,0.54,0.29,0.04,-0.13,-0.21,-0.22,-1.15,-3.63,-6.28,-9.39,-10,-11,-10,-11,-12,-12,-12,-11,-11,-13,-12,-11,-13,-17,-18,-15,-14,-14,-15,-15,-16,-15,-14,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-12,-11,-10,-9.24,-8.73,-8.64,-7.09,-4.58,-2.71,-0.98,-0.78,-0.74,-0.75,-0.74,-0.64,-0.41,-0.15,0.07,0.12,-0.02,-0.36,-1.65,-5.10,-8.32,-6.01,-5.14,-11,-10,-7.37,-8.55,-9.26,-7.02,-6.24,-7.21,-6.72,-7.49,-8.27,-7.82,-5.25,-5.30,-3.72,-0.38,-0.14,0.08,0.25,0.37,0.41,0.37,0.34,0.27,0.22,0.21,0.17,0.12,-0.13,-0.47,-0.74,-0.80,-0.67,-0.40,-0.26,-0.25,-0.30,-0.28,-0.51,-1.63,-3.59,-5.55,-7.42,-7.95,-9.83,-10,-10,-11,-9.90,-8.72,-9.14,-9.77,-10,-10,-11,-12,-14,-15,-16,-16,-16,-16,-15,-14,-13,-13,-12,-11,-11,-10,-10,-9.93,-9.79,-9.76,-9.83,-9.87,13,13,13,12.99,12.99,12.99,12.98,12.98,12.95,12.85,12.72,12.58,12.42,12.28,12.15,12.04,11.97,11.88,11.79,11.71,11.61,11.50,11.38,11.29,11.22,11.13,11.09,11.02,11,10.98,10.96,10.95,10.92,10.92,10.91,10.91,10.90,10.89,10.88,10.86,10.83,10.79,10.78,10.77,10.76,10.76,10.76,10.75,10.73,10.66,10.62,10.58,10.53,10.51,10.50,10.50,10.50,10.47,10.39,10.34,10.25,10.16,10.10,10.04,10.02,10,9.99,9.98,9.97,9.97,9.97,9.97,9.97,9.96,9.95,9.92,9.95,9.95,9.95,9.92,9.91,9.87,9.77,9.62,9.37,9.03,8.63,8.21,7.82,7.48,7.25,7.10,6.97,6.84,6.71,6.58,6.46,6.35,6.25,6.16,6.09,6,5.88,5.75,5.62,5.48,5.33,5.20,5.01,4.83,4.54,4.22,3.85,3.42,3.03,2.70,2.38,2.12,1.87,1.66,1.46,1.28,1.14,1.07,1.01,1,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.92,0.85,0.64,0.35,-0.02,-0.39,-0.64,-0.77,-1.85,-3.59,-5.40,-7.36,-9.15,-10,-10,-10,-10,-10,-11,-11,-12,-12,-10,-10,-11,-15,-19,-17,-13,-10,-11,-11,-13,-14,-14,-14,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-10,-8.52,-7.34,-5.89,-4.71,-3.09,-1.36,-0.40,-0.35,-0.33,-0.35,-0.40,-0.42,-0.38,-0.23,-0.04,0.09,0.10,-0.02,-0.28,-0.63,-1.83,-4.83,-4.91,-4.20,-6.03,-3.67,-2.54,-4.27,-5.12,-4.17,-5.46,-8.26,-5.58,-6.38,-10,-9.18,-6.46,-3.86,-1.42,-0.18,0.02,0.22,0.37,0.48,0.53,0.51,0.46,0.36,0.23,0.08,0,-0.09,-0.26,-0.50,-0.64,-0.59,-0.39,-0.24,-0.21,-0.27,-0.38,-0.41,-0.67,-1.78,-3.71,-4.73,-4.64,-4.76,-4.45,-6.42,-10,-12,-11,-9.30,-7.76,-8.02,-8.37,-9.38,-10,-11,-13,-14,-15,-16,-16,-15,-15,-14,-13,-12,-12,-11,-10,-10,-9.99,-9.75,-9.62,-9.62,-9.67,-9.75,13,13,12.99,12.99,12.99,12.98,12.98,12.97,12.92,12.82,12.66,12.51,12.37,12.23,12.11,12,11.89,11.82,11.72,11.61,11.50,11.39,11.29,11.22,11.13,11.09,11.02,11,10.98,10.96,10.92,10.91,10.90,10.89,10.89,10.88,10.87,10.86,10.84,10.78,10.75,10.72,10.70,10.66,10.65,10.64,10.64,10.62,10.60,10.53,10.49,10.42,10.39,10.37,10.37,10.37,10.36,10.33,10.27,10.22,10.14,10.10,10.03,10.01,10,9.98,9.97,9.97,9.96,9.95,9.92,9.92,9.91,9.89,9.89,9.88,9.88,9.89,9.90,9.90,9.90,9.87,9.82,9.67,9.48,9.16,8.78,8.39,8.01,7.67,7.40,7.17,7,6.82,6.63,6.48,6.35,6.24,6.14,6.08,5.99,5.88,5.76,5.62,5.48,5.33,5.15,4.99,4.77,4.53,4.25,3.89,3.50,3.11,2.74,2.37,2.08,1.83,1.62,1.42,1.27,1.15,1.04,1,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.91,0.79,0.57,0.15,-0.34,-0.79,-1.17,-1.85,-3.61,-5.53,-7.21,-8.49,-9.73,-10,-10,-10,-10,-11,-11,-8.40,-10,-12,-11,-11,-15,-18,-17,-14,-9.14,-9.05,-9.92,-10,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-10,-8.89,-7.17,-4.67,-3.46,-1.64,-0.21,0.01,0.08,0.08,0,-0.12,-0.22,-0.25,-0.18,-0.10,0,0.09,0.08,-0.01,-0.21,-0.42,-0.62,-1.62,-2.70,-1.68,-1.65,-2.50,-1.22,-0.14,-0.13,-0.27,-3.51,-7.99,-8.04,-7.47,-10,-9.67,-6.48,-3.73,-0.37,-0.10,0.11,0.25,0.38,0.50,0.59,0.60,0.54,0.45,0.26,0.03,-0.11,-0.08,-0.12,-0.25,-0.29,-0.13,0.10,0.24,0.17,0,-0.23,-0.37,-0.49,-0.83,-1.65,-2.26,-1.74,-1.07,-1.41,-3.99,-7.87,-10,-10,-8.77,-6.47,-6.17,-7.58,-8.59,-9.66,-11,-12,-13,-14,-15,-15,-14,-14,-13,-12,-12,-11,-11,-10,-10,-9.85,-9.58,-9.50,-9.51,-9.58,-9.59,13,12.99,12.99,12.99,12.98,12.98,12.97,12.96,12.88,12.75,12.62,12.47,12.32,12.15,12.03,11.91,11.83,11.73,11.62,11.50,11.39,11.29,11.22,11.13,11.08,11.02,11,10.98,10.96,10.92,10.90,10.89,10.87,10.87,10.86,10.85,10.83,10.78,10.75,10.71,10.63,10.60,10.57,10.53,10.51,10.50,10.50,10.48,10.45,10.38,10.35,10.29,10.26,10.25,10.24,10.24,10.23,10.21,10.16,10.12,10.08,10.03,10,9.99,9.98,9.97,9.96,9.95,9.91,9.89,9.87,9.85,9.83,9.83,9.78,9.78,9.77,9.78,9.83,9.85,9.86,9.85,9.79,9.67,9.50,9.25,8.91,8.59,8.23,7.88,7.60,7.34,7.09,6.86,6.63,6.45,6.28,6.16,6.08,5.98,5.88,5.77,5.64,5.50,5.33,5.14,4.96,4.75,4.51,4.25,3.91,3.57,3.17,2.82,2.46,2.12,1.85,1.59,1.39,1.25,1.15,1.08,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.88,0.75,0.47,0.02,-0.51,-1.04,-1.46,-3.09,-5.05,-7.08,-8.39,-9.28,-10,-11,-11,-12,-13,-14,-14,-13,-9.61,-10,-12,-13,-16,-20,-20,-12,-7.93,-8.25,-9.73,-10,-11,-12,-12,-12,-12,-13,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-12,-11,-10,-9.43,-7.92,-6.17,-4.21,-2.22,-0.60,-0.08,0.24,0.35,0.34,0.21,0.04,-0.09,-0.11,-0.04,0.03,0.11,0.14,0.13,0.09,-0.02,-0.13,-0.25,-0.33,-0.35,-0.35,-1.38,-2.21,-1.03,-0.02,0.12,-0.16,-1.49,-4.27,-7.66,-10,-11,-11,-7.60,-2.63,-0.28,-0.03,0.12,0.23,0.35,0.48,0.58,0.62,0.62,0.51,0.36,0.10,0.03,0.10,0.15,0.11,0.12,0.33,0.59,0.64,0.59,0.35,0.09,-0.10,-0.14,-0.24,-0.28,-0.29,-0.25,-0.30,-0.61,-1.72,-4.13,-7.22,-7.60,-6.74,-6.83,-6.85,-7.54,-8.29,-9.25,-10,-11,-12,-13,-14,-14,-14,-13,-13,-12,-11,-11,-10,-10,-10,-9.73,-9.51,-9.42,-9.43,-9.50,-9.54,12.99,12.99,12.99,12.98,12.98,12.97,12.96,12.91,12.83,12.70,12.52,12.37,12.23,12.09,11.96,11.84,11.73,11.62,11.50,11.39,11.29,11.22,11.13,11.09,11.02,11,10.98,10.96,10.91,10.89,10.87,10.86,10.84,10.82,10.79,10.77,10.75,10.71,10.65,10.59,10.51,10.47,10.41,10.38,10.36,10.34,10.33,10.29,10.27,10.24,10.21,10.16,10.14,10.13,10.12,10.12,10.12,10.11,10.09,10.04,10.02,10,9.99,9.98,9.97,9.96,9.95,9.90,9.87,9.83,9.75,9.71,9.64,9.62,9.58,9.58,9.59,9.60,9.62,9.66,9.71,9.72,9.66,9.59,9.42,9.23,8.99,8.70,8.38,8.09,7.76,7.49,7.21,6.95,6.67,6.46,6.27,6.13,6,5.88,5.76,5.63,5.50,5.35,5.15,4.97,4.75,4.50,4.24,3.95,3.60,3.25,2.88,2.53,2.22,1.92,1.65,1.46,1.25,1.14,1.08,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.96,0.91,0.84,0.65,0.36,-0.10,-0.60,-1.10,-1.47,-4.03,-6.01,-7.75,-8.74,-9.46,-10,-11,-11,-13,-17,-18,-19,-16,-12,-9.89,-12,-15,-17,-20,-20,-16,-11,-9.04,-9.50,-10,-11,-11,-12,-12,-12,-14,-15,-14,-12,-11,-11,-11,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-15,-15,-14,-14,-13,-13,-12,-11,-10,-8.66,-7.12,-5.43,-3.76,-1.59,-0.65,-0.11,0.26,0.46,0.46,0.33,0.14,0.03,0.02,0.10,0.17,0.25,0.29,0.32,0.28,0.23,0.15,0.10,0.02,-0.02,-0.08,-0.11,-0.13,-0.13,-0.09,-0.12,-0.30,-0.85,-3.36,-7.65,-9.54,-11,-12,-6.02,-0.63,-0.25,-0.02,0.09,0.16,0.27,0.40,0.53,0.63,0.65,0.62,0.49,0.37,0.28,0.36,0.49,0.50,0.52,0.65,0.82,0.87,0.82,0.65,0.47,0.32,0.23,0.17,0.15,0.20,0.25,0.17,-0.10,-0.60,-2.30,-3.97,-5.33,-6.74,-7.41,-7.62,-7.93,-8.49,-9.18,-10,-10,-11,-12,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.76,-9.53,-9.41,-9.41,-9.46,-9.58,12.99,12.99,12.98,12.98,12.97,12.96,12.91,12.83,12.72,12.59,12.45,12.28,12.13,12,11.87,11.74,11.62,11.50,11.39,11.29,11.22,11.13,11.09,11.02,11,10.97,10.95,10.91,10.88,10.87,10.84,10.79,10.76,10.75,10.72,10.67,10.64,10.60,10.53,10.47,10.38,10.33,10.25,10.22,10.17,10.15,10.13,10.12,10.12,10.10,10.08,10.07,10.04,10.03,10.03,10.03,10.03,10.02,10.01,10,9.99,9.97,9.97,9.97,9.96,9.92,9.90,9.87,9.78,9.70,9.59,9.48,9.37,9.32,9.25,9.23,9.23,9.25,9.29,9.36,9.40,9.42,9.40,9.35,9.24,9.08,8.89,8.70,8.47,8.21,7.92,7.63,7.34,7.02,6.75,6.50,6.29,6.12,5.96,5.82,5.65,5.50,5.35,5.16,4.98,4.76,4.53,4.26,3.97,3.63,3.29,2.96,2.62,2.33,2.03,1.77,1.54,1.36,1.21,1.10,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.92,0.87,0.74,0.51,0.22,-0.20,-0.92,-1.84,-3.26,-4.87,-6.52,-7.74,-8.43,-9.21,-10,-10,-11,-12,-14,-17,-17,-13,-10,-10,-12,-13,-17,-20,-20,-18,-12,-9.50,-9.55,-10,-10,-11,-11,-11,-12,-13,-14,-12,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-14,-14,-13,-12,-11,-10,-9.41,-7.93,-6.35,-4.68,-2.77,-1.23,-0.62,-0.10,0.27,0.48,0.49,0.36,0.20,0.11,0.12,0.23,0.35,0.45,0.50,0.52,0.50,0.48,0.45,0.39,0.35,0.27,0.22,0.13,0.04,-0.03,-0.12,-0.16,-0.33,-0.62,-2.10,-4.47,-4.50,-6.98,-7.03,-2.18,-0.55,-0.22,-0.01,0.08,0.13,0.24,0.37,0.52,0.64,0.72,0.71,0.63,0.58,0.54,0.60,0.70,0.76,0.78,0.85,0.90,0.95,0.90,0.82,0.70,0.61,0.54,0.51,0.51,0.53,0.57,0.49,0.25,-0.12,-0.76,-2.41,-4.26,-6.13,-7.18,-8.09,-8.40,-8.86,-9.38,-9.96,-10,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.89,-9.63,-9.49,-9.42,-9.47,-9.41,12.99,12.98,12.98,12.97,12.96,12.89,12.83,12.73,12.62,12.48,12.34,12.17,12.03,11.89,11.76,11.63,11.50,11.39,11.29,11.21,11.12,11.08,11.02,11,10.97,10.95,10.91,10.88,10.86,10.82,10.76,10.73,10.67,10.64,10.61,10.58,10.52,10.48,10.40,10.33,10.24,10.15,10.10,10.03,10,9.97,9.95,9.92,9.92,9.92,9.95,9.96,9.97,9.96,9.97,9.97,9.97,9.96,9.96,9.95,9.92,9.92,9.92,9.92,9.91,9.90,9.86,9.77,9.66,9.50,9.33,9.14,8.99,8.87,8.78,8.72,8.70,8.71,8.75,8.83,8.89,8.96,8.96,8.89,8.83,8.73,8.62,8.50,8.33,8.15,7.96,7.72,7.42,7.12,6.83,6.54,6.32,6.11,5.90,5.72,5.53,5.36,5.16,4.99,4.78,4.57,4.32,4.03,3.73,3.38,3.04,2.72,2.42,2.16,1.95,1.72,1.50,1.32,1.17,1.08,1.01,0.99,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.98,0.96,0.88,0.76,0.58,0.35,0.09,-0.35,-1.43,-2.89,-4.42,-5.77,-6.87,-7.65,-8.12,-8.79,-9.92,-10,-10,-9,-10,-10,-10,-9.80,-7.40,-8.02,-11,-13,-12,-12,-15,-12,-10,-9.60,-9.88,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-12,-12,-12,-13,-14,-14,-14,-15,-15,-15,-15,-14,-14,-13,-12,-11,-10,-8.76,-7.22,-5.55,-3.88,-1.74,-0.88,-0.36,0.08,0.36,0.50,0.48,0.34,0.17,0.12,0.17,0.34,0.49,0.61,0.67,0.70,0.70,0.67,0.65,0.63,0.60,0.53,0.48,0.38,0.27,0.15,0.07,-0.01,-0.13,-0.37,-0.71,-1.08,-1.37,-1.46,-1.23,-0.85,-0.46,-0.14,0.01,0.11,0.15,0.25,0.39,0.54,0.67,0.75,0.78,0.76,0.75,0.75,0.77,0.85,0.88,0.92,0.96,0.97,0.97,0.92,0.88,0.85,0.78,0.76,0.75,0.75,0.75,0.75,0.66,0.50,0.25,-0.13,-1.11,-2.85,-5.08,-7,-8.15,-8.78,-9.18,-9.58,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-9.78,-9.53,-9.50,-9.50,-9.41,12.98,12.98,12.97,12.96,12.89,12.84,12.74,12.62,12.50,12.36,12.22,12.07,11.91,11.77,11.64,11.51,11.40,11.29,11.21,11.12,11.08,11.02,10.99,10.97,10.95,10.90,10.88,10.86,10.82,10.75,10.70,10.62,10.59,10.52,10.49,10.45,10.38,10.34,10.25,10.16,10.09,10,9.91,9.86,9.78,9.75,9.73,9.72,9.73,9.74,9.77,9.82,9.86,9.87,9.88,9.88,9.88,9.87,9.86,9.85,9.85,9.86,9.87,9.88,9.87,9.87,9.79,9.70,9.50,9.26,9,8.75,8.50,8.33,8.17,8.08,8.01,8,7.99,8.07,8.14,8.21,8.24,8.23,8.21,8.15,8.11,8.02,7.97,7.87,7.75,7.60,7.37,7.12,6.84,6.57,6.29,6.07,5.84,5.61,5.38,5.17,4.99,4.78,4.59,4.37,4.12,3.84,3.51,3.17,2.87,2.58,2.32,2.11,1.89,1.71,1.50,1.34,1.17,1.09,1,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.92,0.83,0.62,0.37,0.15,0,-0.53,-2.11,-4.02,-5.71,-6.66,-7.36,-7.78,-8.07,-8.89,-10,-11,-10,-8.36,-7.40,-7.90,-9.32,-10,-9.63,-8.77,-9.93,-10,-8.89,-9.63,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-14,-14,-13,-12,-10,-9.60,-8.11,-6.48,-4.74,-3.01,-0.96,-0.40,0,0.27,0.45,0.49,0.41,0.26,0.13,0.12,0.24,0.40,0.60,0.73,0.79,0.82,0.83,0.82,0.82,0.78,0.76,0.73,0.66,0.61,0.50,0.41,0.35,0.27,0.20,0,-0.26,-0.59,-0.85,-0.93,-0.83,-0.54,-0.25,-0.01,0.12,0.22,0.27,0.37,0.49,0.62,0.74,0.83,0.86,0.87,0.87,0.87,0.88,0.91,0.95,0.97,0.98,0.98,0.97,0.96,0.92,0.90,0.89,0.88,0.87,0.87,0.87,0.86,0.79,0.70,0.50,0.17,-0.36,-1.86,-4.18,-6.41,-8.30,-8.84,-9.23,-9.71,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.96,-9.72,-9.63,-9.55,-9.38,12.98,12.97,12.95,12.89,12.85,12.75,12.62,12.50,12.37,12.23,12.09,11.95,11.79,11.65,11.52,11.40,11.29,11.21,11.12,11.08,11.01,10.99,10.97,10.95,10.90,10.88,10.86,10.82,10.75,10.67,10.61,10.52,10.47,10.40,10.36,10.32,10.25,10.17,10.11,10,9.91,9.83,9.74,9.64,9.58,9.51,9.48,9.47,9.48,9.50,9.57,9.62,9.70,9.74,9.75,9.76,9.75,9.74,9.71,9.67,9.70,9.72,9.75,9.78,9.82,9.76,9.72,9.54,9.29,9,8.64,8.29,7.98,7.73,7.51,7.36,7.24,7.16,7.14,7.17,7.24,7.32,7.37,7.38,7.39,7.37,7.36,7.34,7.33,7.32,7.27,7.21,7.09,6.91,6.73,6.50,6.25,5.99,5.72,5.46,5.21,4.99,4.76,4.58,4.37,4.16,3.92,3.65,3.37,3.04,2.75,2.50,2.29,2.11,1.92,1.75,1.54,1.37,1.22,1.10,1.02,0.99,0.98,0.98,0.97,0.97,0.96,0.96,0.96,0.96,0.90,0.74,0.45,0.15,-0.02,-0.03,-0.96,-3.07,-5.28,-7.05,-7.71,-7.88,-8.05,-8.21,-8.92,-10,-12,-12,-9.99,-8.73,-9.15,-9.92,-10,-11,-9.92,-8.91,-8.89,-9.30,-10,-10,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.97,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-15,-15,-15,-15,-15,-15,-14,-13,-12,-11,-10,-8.99,-7.42,-5.74,-3.90,-1.88,-0.43,-0.04,0.22,0.38,0.45,0.41,0.32,0.17,0.11,0.14,0.29,0.50,0.67,0.78,0.85,0.87,0.88,0.89,0.88,0.88,0.87,0.85,0.82,0.76,0.72,0.66,0.62,0.59,0.51,0.37,0.16,-0.09,-0.28,-0.38,-0.34,-0.17,0.01,0.20,0.29,0.37,0.45,0.52,0.62,0.74,0.83,0.88,0.91,0.92,0.92,0.95,0.95,0.96,0.97,0.97,0.98,0.98,0.97,0.97,0.96,0.96,0.95,0.95,0.95,0.92,0.92,0.91,0.88,0.82,0.67,0.39,-0.13,-1.08,-3.02,-5.58,-7.62,-8.13,-8.83,-9.67,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.97,-9.76,-9.60,-9.12,12.97,12.92,12.89,12.85,12.75,12.63,12.50,12.37,12.24,12.10,11.96,11.79,11.66,11.53,11.40,11.29,11.22,11.12,11.08,11.01,10.99,10.97,10.95,10.91,10.88,10.86,10.82,10.75,10.67,10.60,10.51,10.42,10.36,10.28,10.24,10.16,10.11,10.02,9.95,9.85,9.75,9.64,9.53,9.42,9.34,9.25,9.17,9.15,9.15,9.22,9.25,9.36,9.45,9.51,9.54,9.57,9.54,9.50,9.46,9.42,9.42,9.47,9.51,9.52,9.58,9.58,9.50,9.32,9.03,8.67,8.26,7.86,7.47,7.12,6.86,6.62,6.46,6.34,6.26,6.25,6.28,6.34,6.38,6.41,6.45,6.42,6.45,6.46,6.48,6.50,6.51,6.52,6.50,6.47,6.38,6.25,6.07,5.79,5.51,5.24,4.97,4.74,4.52,4.35,4.15,3.98,3.75,3.50,3.25,2.98,2.73,2.50,2.33,2.15,2,1.83,1.62,1.41,1.25,1.12,1.02,0.99,0.97,0.96,0.97,0.95,0.91,0.88,0.88,0.88,0.86,0.60,0.25,-0.03,-0.26,-0.67,-2.17,-4.32,-6.60,-8.16,-8.45,-8.40,-8.32,-8.39,-8.46,-8.85,-10,-10,-9.07,-9.12,-8.85,-8.62,-9.45,-9.53,-8.75,-8.98,-9.23,-9.75,-10,-10,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.79,-9.75,-9.77,-9.91,-10,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-15,-15,-16,-16,-16,-15,-15,-14,-13,-12,-11,-9.84,-8.36,-6.75,-5.02,-3.18,-1.01,-0.26,0.08,0.22,0.32,0.34,0.29,0.22,0.12,0.13,0.24,0.41,0.61,0.75,0.84,0.88,0.91,0.92,0.95,0.95,0.95,0.92,0.91,0.89,0.87,0.86,0.85,0.83,0.79,0.75,0.66,0.52,0.36,0.21,0.12,0.13,0.22,0.33,0.42,0.51,0.59,0.63,0.71,0.77,0.86,0.91,0.97,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.96,0.96,0.95,0.91,0.87,0.77,0.50,0,-0.75,-2.37,-4.29,-6.04,-7.82,-8.92,-9.48,-10,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.89,-9.59,-8.91,12.91,12.87,12.82,12.73,12.62,12.50,12.37,12.23,12.10,11.96,11.82,11.66,11.53,11.41,11.32,11.22,11.13,11.08,11.01,10.99,10.97,10.95,10.91,10.88,10.86,10.82,10.75,10.67,10.60,10.50,10.41,10.34,10.25,10.17,10.12,10.04,9.98,9.88,9.78,9.70,9.58,9.46,9.34,9.21,9.08,8.96,8.86,8.78,8.77,8.83,8.87,8.99,9.10,9.17,9.25,9.25,9.25,9.20,9.12,9.07,9.01,9.02,9.09,9.15,9.25,9.29,9.25,9.09,8.77,8.37,7.90,7.42,6.97,6.54,6.20,5.90,5.67,5.51,5.40,5.37,5.37,5.38,5.40,5.45,5.47,5.48,5.49,5.50,5.53,5.58,5.61,5.65,5.72,5.76,5.79,5.77,5.66,5.46,5.17,4.89,4.63,4.41,4.24,4.08,3.92,3.76,3.61,3.38,3.15,2.91,2.71,2.51,2.37,2.22,2.07,1.88,1.66,1.46,1.25,1.12,1.01,0.97,0.92,0.91,0.91,0.88,0.84,0.75,0.70,0.65,0.63,0.32,-0.01,-0.39,-0.88,-1.80,-3.67,-5.76,-7.87,-9.09,-9.14,-8.89,-8.68,-8.71,-8.82,-8.89,-8.72,-8.25,-8.65,-8.50,-8.32,-8.54,-8.73,-8.92,-8.96,-9.22,-9.65,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.79,-9.65,-9.62,-9.64,-9.77,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-13,-13,-14,-15,-16,-16,-16,-16,-15,-15,-14,-13,-11,-10,-9.22,-7.68,-6.10,-4.36,-4.13,-2.52,-0.38,-0.09,0.02,0.12,0.15,0.20,0.16,0.15,0.24,0.38,0.58,0.73,0.83,0.87,0.91,0.96,0.97,0.98,0.98,0.98,0.98,0.97,0.96,0.95,0.95,0.92,0.92,0.91,0.89,0.85,0.75,0.65,0.58,0.51,0.50,0.53,0.60,0.65,0.73,0.77,0.84,0.88,0.95,1,1.04,1.08,1.09,1.09,1.07,1.04,1.02,1.01,1,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.96,0.95,0.91,0.84,0.59,0.08,-0.65,-1.54,-3.37,-6.18,-8.77,-9.52,-9.87,-11,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-9.99,-9.47,-8.64,12.83,12.77,12.71,12.62,12.50,12.37,12.23,12.09,11.96,11.82,11.66,11.53,11.41,11.32,11.23,11.13,11.08,11.02,10.99,10.97,10.95,10.91,10.89,10.86,10.82,10.75,10.67,10.61,10.51,10.41,10.34,10.25,10.16,10.10,10.01,9.95,9.86,9.75,9.63,9.52,9.39,9.25,9.11,8.95,8.77,8.62,8.49,8.38,8.35,8.36,8.40,8.51,8.63,8.75,8.83,8.86,8.84,8.76,8.65,8.57,8.50,8.50,8.53,8.62,8.74,8.85,8.87,8.76,8.50,8.11,7.58,7,6.46,5.98,5.58,5.25,4.99,4.77,4.62,4.53,4.50,4.50,4.51,4.52,4.52,4.53,4.54,4.58,4.61,4.63,4.67,4.74,4.82,4.89,5,5.07,5.02,4.88,4.66,4.42,4.21,4.02,3.88,3.76,3.66,3.57,3.41,3.25,3.08,2.87,2.66,2.50,2.36,2.23,2.09,1.87,1.64,1.42,1.24,1.10,0.99,0.90,0.86,0.83,0.76,0.76,0.67,0.52,0.35,0.21,0.11,-0.14,-0.51,-1.07,-1.87,-3.23,-5.17,-7.10,-8.88,-9.74,-9.73,-9.40,-9.20,-9.14,-9.13,-8.90,-8.60,-8.36,-8.30,-8.47,-8.70,-8.89,-9.09,-9.25,-9.39,-9.68,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.90,-9.74,-9.62,-9.55,-9.59,-9.68,-9.76,-10,-10,-10,-11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-15,-15,-16,-16,-16,-16,-15,-14,-13,-12,-11,-10,-8.52,-6.99,-6.11,-6.16,-5.36,-4.47,-2.12,-0.27,-0.23,-0.13,-0.01,0.12,0.20,0.26,0.40,0.57,0.72,0.83,0.87,0.92,0.97,0.99,1,1.02,1.02,1.03,1.03,1.02,1.01,1.01,1,1,0.99,0.99,0.97,0.95,0.89,0.85,0.79,0.76,0.75,0.76,0.79,0.85,0.89,0.96,1,1.07,1.12,1.16,1.23,1.25,1.26,1.25,1.23,1.20,1.14,1.10,1.04,1.01,1,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.96,0.92,0.87,0.62,0.12,-0.60,-1.18,-2.77,-6.96,-9.55,-9.76,-10,-11,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-11,-11,-10,-10,-9.33,-8.26,12.73,12.67,12.60,12.49,12.37,12.23,12.09,11.96,11.82,11.66,11.53,11.41,11.32,11.22,11.13,11.08,11.01,10.98,10.96,10.92,10.89,10.88,10.87,10.82,10.75,10.67,10.61,10.51,10.42,10.35,10.25,10.16,10.11,10.02,9.95,9.86,9.75,9.63,9.50,9.37,9.23,9.07,8.87,8.67,8.48,8.26,8.09,7.95,7.86,7.84,7.87,7.98,8.10,8.23,8.33,8.37,8.35,8.24,8.12,8.01,7.90,7.85,7.86,7.91,8.03,8.20,8.33,8.35,8.20,7.82,7.23,6.54,5.95,5.40,4.98,4.62,4.35,4.12,3.95,3.83,3.75,3.73,3.72,3.73,3.73,3.70,3.71,3.72,3.73,3.75,3.77,3.85,3.90,4,4.11,4.20,4.22,4.13,4,3.84,3.70,3.58,3.49,3.42,3.37,3.32,3.23,3.10,2.92,2.76,2.60,2.42,2.26,2.12,1.98,1.75,1.53,1.33,1.14,1,0.89,0.82,0.73,0.62,0.51,0.48,0.47,0.13,-0.16,-0.42,-0.59,-1.08,-1.52,-2.22,-3.26,-4.79,-6.52,-8.12,-9.51,-10,-10,-9.83,-9.70,-9.61,-9.42,-9.08,-8.75,-8.51,-8.55,-8.84,-9.16,-9.38,-9.51,-9.65,-9.92,-10,-10,-10,-10,-10,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.90,-9.75,-9.63,-9.58,-9.59,-9.53,-9.78,-10,-10,-10,-11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-12,-12,-13,-14,-15,-16,-16,-17,-16,-16,-15,-14,-13,-12,-10,-9.36,-7.74,-7.58,-6.95,-6.16,-5.70,-4.36,-2.09,-0.39,-0.42,-0.36,-0.15,0.07,0.25,0.40,0.58,0.72,0.84,0.89,0.96,1,1.03,1.08,1.10,1.12,1.13,1.13,1.13,1.13,1.12,1.11,1.10,1.08,1.07,1.04,1.03,1.01,0.99,0.96,0.91,0.90,0.89,0.90,0.95,1,1.04,1.12,1.17,1.24,1.32,1.39,1.48,1.53,1.58,1.57,1.50,1.42,1.34,1.24,1.14,1.08,1.02,1,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.95,0.88,0.65,0.15,-0.54,-1.14,-2.79,-6.10,-8.35,-8.62,-8.43,-10,-12,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.24,-8.26,12.61,12.57,12.48,12.36,12.23,12.09,11.96,11.82,11.66,11.53,11.41,11.32,11.22,11.12,11.07,11,10.98,10.95,10.90,10.88,10.87,10.84,10.78,10.75,10.67,10.61,10.51,10.42,10.36,10.26,10.20,10.12,10.04,9.98,9.89,9.78,9.67,9.53,9.38,9.24,9.07,8.87,8.64,8.41,8.15,7.90,7.66,7.48,7.34,7.27,7.29,7.38,7.50,7.62,7.71,7.74,7.72,7.63,7.51,7.37,7.24,7.13,7.09,7.11,7.17,7.29,7.46,7.61,7.63,7.36,6.75,6.01,5.37,4.85,4.41,4.08,3.77,3.53,3.37,3.23,3.13,3.08,3.04,3.01,3.01,3.01,3,2.99,3,3,3,3.01,3.04,3.14,3.25,3.34,3.37,3.36,3.28,3.21,3.12,3.08,3.04,3.04,3.03,3.02,2.98,2.87,2.74,2.59,2.40,2.25,2.08,1.88,1.71,1.50,1.32,1.13,0.99,0.87,0.76,0.65,0.50,0.32,0.12,-0.03,-0.15,-0.57,-0.96,-1.38,-1.82,-2.54,-3.15,-3.95,-5.01,-6.40,-7.78,-9.01,-9.95,-10,-10,-10,-10,-10,-9.73,-9.40,-9.13,-8.99,-9.11,-9.41,-9.72,-9.90,-9.92,-9.95,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.90,-9.75,-9.63,-9.59,-9.59,-9.84,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-12,-13,-14,-14,-15,-16,-16,-16,-16,-15,-14,-13,-12,-11,-10,-8.52,-8.25,-8.09,-6.62,-3.92,-3.36,-2.07,-0.25,-0.37,-0.51,-0.47,-0.23,0.07,0.33,0.53,0.73,0.85,0.92,1,1.04,1.11,1.15,1.21,1.25,1.27,1.29,1.32,1.29,1.28,1.26,1.25,1.24,1.22,1.20,1.17,1.15,1.12,1.09,1.03,1,0.99,0.99,1,1.04,1.12,1.21,1.27,1.36,1.42,1.52,1.63,1.77,1.90,1.99,1.98,1.88,1.75,1.60,1.42,1.28,1.15,1.08,1.01,1,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.89,0.67,0.20,-0.50,-1.14,-2.29,-3.98,-6.22,-6.39,-6.83,-9.75,-12,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.24,-8.35,12.47,12.41,12.33,12.22,12.09,11.95,11.82,11.66,11.53,11.41,11.29,11.21,11.12,11.07,11,10.96,10.91,10.88,10.87,10.84,10.79,10.76,10.72,10.64,10.59,10.50,10.42,10.35,10.27,10.22,10.14,10.09,10.01,9.95,9.86,9.75,9.62,9.48,9.29,9.12,8.91,8.70,8.42,8.14,7.85,7.53,7.25,7,6.83,6.73,6.73,6.77,6.87,6.99,7.08,7.12,7.11,7.01,6.87,6.70,6.52,6.37,6.27,6.25,6.27,6.37,6.52,6.67,6.66,6.46,5.96,5.34,4.75,4.25,3.86,3.52,3.25,3.03,2.87,2.72,2.61,2.52,2.48,2.45,2.41,2.41,2.42,2.45,2.39,2.38,2.36,2.34,2.34,2.38,2.47,2.53,2.60,2.61,2.60,2.58,2.54,2.57,2.60,2.63,2.67,2.71,2.66,2.59,2.46,2.28,2.12,1.96,1.76,1.58,1.37,1.16,1,0.87,0.75,0.67,0.59,0.42,0.21,-0.09,-0.38,-0.63,-1.17,-1.66,-2.23,-2.89,-3.65,-4.47,-5.17,-6.01,-6.95,-8.02,-9.08,-9.80,-10,-10,-10,-10,-10,-10,-10,-9.76,-9.62,-9.58,-9.77,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.89,-9.88,-9.91,-9.90,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-12,-13,-14,-15,-15,-16,-16,-16,-15,-14,-13,-12,-11,-10,-9.87,-8.26,-8.78,-7.72,-4.65,-2.22,-0.46,-0.13,-0.11,-0.29,-0.48,-0.42,-0.17,0.14,0.45,0.66,0.86,0.97,1.03,1.12,1.20,1.26,1.35,1.40,1.48,1.51,1.53,1.53,1.51,1.50,1.47,1.46,1.42,1.40,1.39,1.37,1.35,1.29,1.24,1.16,1.12,1.09,1.09,1.12,1.17,1.26,1.37,1.47,1.53,1.62,1.73,1.87,2.09,2.32,2.46,2.45,2.29,2.12,1.89,1.66,1.46,1.26,1.13,1.04,1,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.96,0.90,0.71,0.26,-0.37,-0.99,-1.48,-3.37,-4.38,-5.43,-7.17,-8.72,-11,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-9.24,-8.38,12.32,12.26,12.17,12.08,11.95,11.79,11.66,11.53,11.41,11.29,11.21,11.12,11.04,11,10.95,10.89,10.86,10.83,10.78,10.75,10.73,10.67,10.62,10.57,10.49,10.40,10.34,10.26,10.21,10.14,10.11,10.04,10,9.91,9.84,9.73,9.59,9.41,9.24,9.02,8.79,8.53,8.24,7.88,7.52,7.16,6.84,6.53,6.35,6.22,6.16,6.20,6.26,6.35,6.41,6.46,6.45,6.36,6.20,5.99,5.77,5.60,5.46,5.37,5.37,5.41,5.50,5.62,5.63,5.42,5.03,4.54,4.09,3.66,3.29,3,2.75,2.53,2.38,2.25,2.14,2.04,2,1.97,1.96,1.96,1.96,1.97,1.96,1.89,1.87,1.83,1.78,1.78,1.83,1.87,1.90,1.95,1.97,2,2.02,2.09,2.14,2.23,2.27,2.32,2.28,2.22,2.09,1.92,1.75,1.59,1.38,1.17,0.99,0.79,0.65,0.58,0.51,0.47,0.36,0.14,-0.15,-0.52,-0.90,-1.50,-2.58,-3.26,-4.01,-4.88,-5.72,-6.48,-7.21,-7.92,-8.76,-9.50,-10,-10,-10,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-12,-12,-13,-14,-15,-15,-15,-15,-14,-14,-13,-12,-11,-10,-10,-9.68,-9.57,-8.58,-6.36,-3,-0.33,-0.13,-0.01,-0.05,-0.13,-0.25,-0.18,0.03,0.36,0.63,0.85,1,1.11,1.21,1.32,1.40,1.50,1.61,1.70,1.76,1.82,1.83,1.79,1.75,1.72,1.67,1.65,1.65,1.64,1.63,1.61,1.59,1.52,1.47,1.38,1.34,1.28,1.28,1.32,1.37,1.48,1.57,1.64,1.72,1.78,1.88,2.03,2.26,2.53,2.98,2.76,2.63,2.45,2.21,1.90,1.62,1.37,1.20,1.08,1,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.97,0.91,0.75,0.41,-0.09,-0.62,-1.13,-2.45,-4.39,-6.17,-7.73,-8.52,-10,-11,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-9.21,-8.33,12.15,12.12,12.03,11.92,11.79,11.66,11.53,11.41,11.29,11.21,11.12,11.04,10.99,10.92,10.87,10.83,10.77,10.74,10.71,10.66,10.62,10.59,10.52,10.46,10.37,10.32,10.25,10.17,10.13,10.10,10.07,10.01,9.97,9.89,9.82,9.70,9.54,9.38,9.20,8.97,8.72,8.40,8.04,7.63,7.22,6.79,6.42,6.13,5.89,5.73,5.64,5.63,5.66,5.73,5.76,5.77,5.74,5.62,5.46,5.24,5,4.79,4.62,4.51,4.46,4.46,4.49,4.52,4.50,4.36,4.09,3.75,3.40,3.09,2.76,2.49,2.25,2.09,1.95,1.84,1.75,1.67,1.62,1.60,1.59,1.60,1.61,1.60,1.59,1.58,1.50,1.47,1.40,1.37,1.34,1.33,1.34,1.37,1.42,1.50,1.58,1.64,1.73,1.79,1.86,1.89,1.87,1.78,1.65,1.51,1.37,1.21,1.01,0.82,0.61,0.41,0.34,0.29,0.28,0.25,0.12,-0.14,-0.52,-1.18,-2.33,-3.54,-4.28,-5.11,-5.97,-6.87,-7.76,-8.43,-8.87,-9.48,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.89,-9.93,-10,-10,-11,-12,-12,-13,-14,-14,-14,-14,-14,-13,-12,-11,-10,-10,-9.22,-10,-10,-9.26,-7.23,-4.51,-1.55,-0.25,0.01,0.10,0.10,0.12,0.09,0.14,0.35,0.62,0.87,1.04,1.21,1.33,1.46,1.57,1.67,1.79,1.91,2.01,2.09,2.11,2.08,2.01,1.95,1.88,1.86,1.86,1.87,1.87,1.87,1.87,1.86,1.85,1.82,1.76,1.72,1.66,1.64,1.65,1.71,1.75,1.78,1.84,1.87,1.89,1.98,2.10,2.28,2.59,2.83,2.92,2.87,2.72,2.47,2.12,1.77,1.48,1.25,1.10,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.95,0.84,0.63,0.28,-0.14,-0.71,-1.26,-4.07,-6.27,-7.25,-8.47,-9.10,-10,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-12,-12,-11,-10,-9.99,-9.13,-8.25,12.02,11.99,11.89,11.78,11.66,11.53,11.40,11.29,11.21,11.12,11.04,10.99,10.92,10.87,10.79,10.75,10.67,10.62,10.59,10.54,10.50,10.47,10.40,10.35,10.27,10.22,10.15,10.11,10.08,10.03,10,9.97,9.90,9.85,9.75,9.64,9.50,9.35,9.14,8.91,8.63,8.32,7.88,7.40,6.91,6.48,6.08,5.74,5.48,5.27,5.16,5.12,5.11,5.12,5.12,5.09,5,4.87,4.66,4.42,4.21,4,3.83,3.70,3.61,3.53,3.51,3.50,3.47,3.37,3.21,3,2.75,2.51,2.27,2.04,1.84,1.66,1.57,1.50,1.42,1.37,1.35,1.34,1.33,1.33,1.34,1.35,1.33,1.32,1.26,1.22,1.14,1.04,0.96,0.86,0.84,0.89,1,1.11,1.20,1.25,1.29,1.36,1.39,1.40,1.38,1.32,1.23,1.11,0.99,0.85,0.67,0.49,0.28,0.10,0.02,0.12,0.14,0.11,-0.09,-0.48,-1.41,-2.76,-4.01,-5.30,-5.99,-6.88,-7.75,-8.49,-9.09,-9.61,-10,-10,-11,-12,-12,-11,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.92,-10,-10,-10,-11,-12,-12,-13,-13,-14,-14,-13,-12,-11,-10,-10,-10,-8.78,-7.79,-8.62,-9.46,-6.97,-5.08,-2.86,-0.72,-0.25,0.12,0.35,0.41,0.50,0.50,0.54,0.70,0.90,1.12,1.32,1.48,1.61,1.74,1.86,1.98,2.10,2.22,2.28,2.32,2.28,2.22,2.12,2.02,1.97,1.95,1.97,2.01,2.07,2.11,2.14,2.20,2.25,2.29,2.33,2.29,2.25,2.21,2.15,2.14,2.12,2.08,2.02,2.01,2.01,2.02,2.09,2.21,2.46,2.73,3,3.07,2.97,2.65,2.29,1.89,1.53,1.26,1.11,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.96,0.90,0.82,0.60,0.27,-0.23,-0.80,-2.27,-5.24,-7.02,-7.91,-8.96,-9.68,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-9.91,-9.05,-8.13,11.88,11.85,11.76,11.65,11.53,11.40,11.29,11.21,11.12,11.04,10.99,10.91,10.86,10.78,10.72,10.63,10.58,10.50,10.47,10.41,10.38,10.35,10.29,10.25,10.17,10.12,10.09,10.03,10,9.98,9.95,9.88,9.83,9.75,9.65,9.53,9.40,9.25,9.09,8.86,8.58,8.25,7.76,7.21,6.65,6.15,5.73,5.37,5.07,4.85,4.71,4.62,4.57,4.52,4.48,4.38,4.26,4.10,3.87,3.62,3.39,3.22,3.08,2.96,2.85,2.75,2.65,2.61,2.54,2.50,2.41,2.33,2.17,2.02,1.86,1.66,1.52,1.39,1.29,1.25,1.22,1.17,1.16,1.15,1.15,1.14,1.15,1.15,1.15,1.13,1.12,1.07,0.98,0.85,0.66,0.47,0.38,0.47,0.63,0.76,0.84,0.86,0.87,0.88,0.90,0.90,0.88,0.85,0.78,0.73,0.64,0.57,0.45,0.28,0.12,-0.01,-0.04,0.04,0.09,0.04,-0.46,-1.60,-2.77,-4.09,-5.30,-6.43,-7.39,-8.27,-8.99,-9.48,-9.88,-10,-10,-11,-12,-12,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.93,-10,-10,-10,-11,-12,-12,-13,-13,-13,-12,-11,-10,-9.77,-9.89,-9.63,-8.82,-7.24,-5.61,-5.38,-5.24,-4.83,-2.95,-1,-0.50,-0.05,0.28,0.52,0.72,0.77,0.78,0.85,0.97,1.15,1.37,1.61,1.78,1.96,2.03,2.13,2.23,2.33,2.39,2.42,2.40,2.33,2.21,2.10,2,1.95,1.96,2,2.11,2.22,2.34,2.46,2.60,2.76,2.92,3.04,3.08,3,2.87,2.76,2.70,2.61,2.50,2.40,2.35,2.25,2.14,2.07,2.12,2.27,2.58,2.90,3.49,3.04,2.79,2.45,2,1.58,1.26,1.10,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.96,0.91,0.82,0.62,0.24,-0.33,-1.09,-3.35,-5.76,-8.64,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-10,-9.88,-9,-8.04,11.75,11.72,11.62,11.52,11.40,11.29,11.21,11.12,11.03,10.99,10.91,10.86,10.78,10.71,10.62,10.52,10.46,10.38,10.34,10.29,10.26,10.24,10.20,10.14,10.10,10.04,10,9.97,9.91,9.89,9.85,9.76,9.67,9.59,9.48,9.36,9.24,9.11,8.95,8.74,8.47,8.17,7.65,7,6.38,5.85,5.37,4.98,4.65,4.40,4.24,4.12,4.02,3.95,3.84,3.71,3.52,3.33,3.08,2.84,2.63,2.50,2.38,2.32,2.22,2.11,2,1.90,1.86,1.83,1.83,1.77,1.72,1.62,1.50,1.37,1.26,1.21,1.14,1.10,1.09,1.07,1.07,1.04,1.04,1.04,1.04,1.07,1.04,1.03,1.01,0.98,0.88,0.74,0.51,0.25,0,0.17,0.38,0.50,0.52,0.50,0.45,0.42,0.42,0.42,0.41,0.40,0.39,0.38,0.39,0.38,0.36,0.26,0.15,0.10,0.07,0.09,0.09,-0.51,-1.38,-2.68,-4.12,-5.50,-6.53,-7.58,-8.33,-9.11,-9.64,-9.89,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-9.98,-9.89,-9.89,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-9.90,-9.07,-9.03,-9.09,-8.13,-6.43,-4.34,-1.79,-2.10,-2.64,-1.75,-0.84,-0.52,-0.15,0.21,0.50,0.71,0.84,0.92,0.99,1.04,1.20,1.40,1.65,1.91,2.13,2.28,2.34,2.34,2.37,2.39,2.41,2.39,2.33,2.21,2.07,1.95,1.87,1.85,1.88,2,2.14,2.34,2.53,2.75,3,3.29,3.63,3.89,3.96,3.79,3.58,3.39,3.27,3.20,3.10,2.95,2.79,2.61,2.37,2.14,2.07,2.13,2.33,2.72,2.96,3.03,2.86,2.54,2.04,1.58,1.25,1.08,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.89,0.78,0.53,-0.01,-0.85,-1.71,-4.49,-8.80,-11,-13,-13,-13,-12,-10,-10,-10,-11,-11,-11,-11,-12,-11,-11,-11,-10,-9.84,-9,-8.03,11.62,11.59,11.50,11.39,11.28,11.21,11.12,11.03,10.99,10.91,10.86,10.77,10.71,10.61,10.50,10.40,10.34,10.26,10.23,10.17,10.15,10.12,10.10,10.04,10.01,9.97,9.91,9.87,9.83,9.75,9.71,9.61,9.49,9.35,9.21,9.07,8.92,8.82,8.67,8.50,8.25,7.95,7.54,6.74,6.09,5.50,5,4.59,4.24,3.98,3.76,3.62,3.49,3.36,3.20,3.01,2.82,2.60,2.36,2.14,1.98,1.89,1.85,1.78,1.73,1.63,1.53,1.47,1.40,1.38,1.37,1.37,1.35,1.28,1.23,1.15,1.11,1.08,1.04,1.02,1,1,1,1,1,1,1,1,0.99,0.99,0.97,0.92,0.85,0.73,0.52,0.26,0.12,0.13,0.26,0.33,0.29,0.20,0.11,0.08,0.08,0.09,0.11,0.12,0.14,0.21,0.27,0.35,0.36,0.34,0.27,0.23,0.17,0.13,-0.39,-1.10,-2.37,-3.87,-5.24,-6.37,-7.38,-8.20,-8.95,-9.40,-9.77,-9.93,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-13,-13,-12,-12,-12,-11,-10,-10,-10,-10,-10,-9.92,-9.88,-9.84,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-11,-11,-10,-9.57,-9.60,-8.52,-6.90,-6.20,-5.21,-3.08,-0.98,-0.79,-0.64,-0.51,-0.38,-0.24,-0.02,0.23,0.47,0.66,0.82,0.90,1,1.10,1.21,1.40,1.67,1.98,2.25,2.45,2.48,2.47,2.41,2.37,2.35,2.32,2.24,2.12,1.99,1.86,1.75,1.67,1.70,1.77,1.96,2.16,2.42,2.71,3,3.34,3.75,4.17,4.72,4.87,4.37,4.16,3.98,3.84,3.72,3.65,3.59,3.37,3.04,2.66,2.24,2.03,2.02,2.14,2.29,2.76,2.96,2.87,2.53,2.07,1.57,1.23,1.04,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.96,0.92,0.90,0.85,0.61,0.10,-0.75,-1.64,-3.86,-6.63,-10,-14,-16,-16,-14,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-9.78,-9.05,-8.09,11.49,11.45,11.37,11.27,11.20,11.12,11.03,10.98,10.91,10.86,10.77,10.71,10.61,10.50,10.39,10.29,10.23,10.16,10.12,10.10,10.07,10.03,10,9.98,9.92,9.87,9.83,9.75,9.67,9.60,9.50,9.37,9.21,9,8.83,8.65,8.50,8.38,8.26,8.12,7.87,7.52,6.97,6.37,5.71,5.12,4.62,4.15,3.78,3.50,3.27,3.10,2.91,2.75,2.57,2.37,2.16,1.97,1.77,1.62,1.50,1.47,1.45,1.40,1.37,1.29,1.24,1.16,1.12,1.08,1.04,1.02,1.01,1,0.98,0.97,0.97,0.97,0.97,0.96,0.96,0.96,0.96,0.96,0.96,0.97,0.97,0.96,0.95,0.92,0.91,0.89,0.85,0.76,0.62,0.48,0.37,0.33,0.32,0.28,0.23,0.13,0.04,0,0,0,0.02,0.07,0.11,0.17,0.28,0.37,0.42,0.46,0.41,0.34,0.25,-0.11,-1.12,-2.25,-3.63,-4.85,-6,-7,-7.79,-8.45,-8.97,-9.36,-9.67,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.90,-9.88,-9.88,-9.89,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-9.59,-9.67,-10,-8.37,-5.07,-2.87,-1.41,-0.34,-0.22,-0.11,0,0.11,0.20,0.28,0.39,0.53,0.67,0.82,0.89,0.99,1.08,1.21,1.38,1.63,1.95,2.25,2.45,2.58,2.62,2.51,2.40,2.29,2.20,2.10,2,1.87,1.75,1.62,1.53,1.50,1.53,1.65,1.87,2.13,2.46,2.78,3.12,3.49,3.91,4.53,4.62,4.67,4.61,4.50,4.46,4.25,4.17,4.08,3.95,3.63,3.62,2.77,2.33,2.02,2,2.03,2.32,2.71,2.92,2.85,2.51,2.02,1.52,1.21,1.04,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.96,0.89,0.84,0.75,0.65,0.51,-0.01,-0.85,-2.37,-3.98,-5.92,-8.15,-11,-13,-14,-12,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-9.76,-9.22,-8.13,11.35,11.29,11.25,11.16,11.11,11.03,10.98,10.91,10.86,10.77,10.71,10.61,10.50,10.39,10.28,10.21,10.13,10.09,10.04,10.01,10,9.98,9.92,9.88,9.83,9.75,9.70,9.60,9.50,9.37,9.23,9.08,8.85,8.61,8.37,8.15,7.98,7.84,7.72,7.58,7.35,6.91,6.42,5.86,5.25,4.71,4.17,3.73,3.34,3.01,2.77,2.58,2.37,2.16,1.99,1.82,1.64,1.50,1.37,1.26,1.22,1.20,1.16,1.14,1.11,1.04,0.99,0.95,0.88,0.83,0.75,0.72,0.71,0.71,0.73,0.75,0.78,0.85,0.87,0.87,0.87,0.88,0.87,0.87,0.89,0.90,0.91,0.90,0.88,0.86,0.84,0.83,0.78,0.76,0.73,0.64,0.54,0.49,0.40,0.37,0.33,0.26,0.22,0.15,0.12,0.09,0.11,0.14,0.22,0.28,0.36,0.42,0.48,0.48,0.41,0.17,-0.15,-0.99,-2.40,-3.59,-4.72,-5.76,-6.72,-7.50,-8.10,-8.54,-8.86,-9.09,-9.27,-9.39,-9.67,-9.97,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-9.99,-9.89,-9.90,-9.98,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-8.68,-10,-10,-7.78,-3.66,-0.22,0.20,0.27,0.35,0.41,0.49,0.53,0.59,0.63,0.70,0.75,0.84,0.88,0.96,1.01,1.12,1.28,1.50,1.83,2.14,2.37,2.57,2.65,2.64,2.50,2.35,2.17,2.01,1.87,1.74,1.62,1.50,1.40,1.35,1.34,1.38,1.51,1.75,2.03,2.38,2.73,3.07,3.39,3.76,4.09,4.29,4.38,4.45,4.53,4.59,4.57,4.34,4.59,3.96,3.62,3.26,2.76,2.33,2.02,2,2.03,2.32,2.71,2.91,2.78,2.48,1.92,1.48,1.20,1.03,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.91,0.82,0.63,0.42,0.25,0.01,-0.41,-1.11,-3.30,-5.50,-6.07,-5.95,-7.70,-9.36,-10,-10,-9.80,-9.91,-9.96,-10,-10,-10,-10,-10,-11,-10,-10,-10,-9.74,-9.34,-8.38,11.22,11.20,11.13,11.10,11.03,10.99,10.91,10.86,10.77,10.70,10.61,10.50,10.38,10.28,10.21,10.12,10.08,10.02,10,9.98,9.95,9.90,9.86,9.77,9.70,9.60,9.49,9.37,9.23,9.07,8.87,8.66,8.41,8.13,7.87,7.62,7.39,7.23,7.09,6.92,6.65,6.32,5.84,5.32,4.76,4.24,3.73,3.26,2.87,2.58,2.33,2.10,1.87,1.67,1.51,1.39,1.28,1.21,1.13,1.09,1.04,1.02,1,0.92,0.85,0.76,0.73,0.71,0.66,0.59,0.48,0.39,0.39,0.42,0.48,0.50,0.53,0.60,0.63,0.66,0.71,0.72,0.73,0.74,0.78,0.86,0.87,0.85,0.76,0.71,0.65,0.63,0.65,0.64,0.67,0.63,0.58,0.52,0.50,0.47,0.40,0.37,0.34,0.32,0.17,0.12,0.14,0.24,0.36,0.41,0.46,0.45,0.40,0.32,-0.09,-0.42,-0.90,-2.13,-3.55,-4.74,-5.72,-6.57,-7.33,-7.92,-8.34,-8.62,-8.79,-8.89,-8.90,-9.02,-9.46,-9.77,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-9.93,-9.99,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-11,-11,-11,-11,-11,-11,-11,-10,-9.55,-8.79,-8.72,-9.11,-5.91,-1.26,0.28,0.52,0.62,0.67,0.73,0.75,0.78,0.82,0.84,0.86,0.87,0.90,0.95,0.98,1.03,1.15,1.33,1.57,1.84,2.12,2.39,2.59,2.66,2.62,2.45,2.26,2.07,1.87,1.67,1.52,1.40,1.32,1.24,1.20,1.20,1.25,1.38,1.60,1.87,2.20,2.51,2.83,3.11,3.37,3.62,3.83,3.98,4.11,4.25,4.37,4.41,4.25,3.97,3.74,3.33,2.98,2.62,2.24,2.02,2.01,2.13,2.29,2.73,2.83,2.75,2.17,1.75,1.38,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.88,0.72,0.40,0.04,-0.26,-0.58,-0.97,-2.22,-4.40,-6.42,-6.03,-5.91,-6.37,-6.91,-8.43,-9.47,-9.55,-10,-10,-9.84,-9.93,-10,-10,-10,-10,-10,-10,-9.97,-9.73,-9.48,-9.01,11.12,11.10,11.07,11.01,10.98,10.92,10.87,10.78,10.71,10.61,10.50,10.38,10.27,10.17,10.11,10.04,10,9.99,9.97,9.95,9.89,9.85,9.75,9.64,9.51,9.37,9.22,9.04,8.87,8.67,8.46,8.22,7.96,7.64,7.36,7.09,6.84,6.63,6.47,6.26,6.01,5.67,5.25,4.76,4.25,3.75,3.26,2.84,2.48,2.17,1.92,1.71,1.50,1.33,1.22,1.13,1.10,1.04,1.02,1,0.98,0.92,0.84,0.71,0.57,0.46,0.41,0.46,0.47,0.37,0.23,0.12,0.16,0.27,0.29,0.28,0.25,0.26,0.32,0.37,0.45,0.49,0.50,0.50,0.64,0.77,0.83,0.75,0.61,0.48,0.39,0.39,0.45,0.50,0.50,0.42,0.37,0.36,0.40,0.39,0.33,0.24,0.17,0.12,0.02,0.02,0.12,0.27,0.48,0.54,0.50,0.37,0.17,-0.30,-0.80,-1.26,-1.98,-3.10,-4.61,-5.83,-6.61,-7.26,-7.85,-8.29,-8.59,-8.77,-8.88,-8.93,-8.86,-9.05,-9.60,-9.98,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-10,-9.23,-8.35,-7.35,-6.10,-2.95,-0.33,0.38,0.66,0.76,0.82,0.85,0.87,0.88,0.89,0.90,0.91,0.92,0.95,0.97,0.99,1.04,1.15,1.33,1.53,1.78,2.07,2.32,2.50,2.60,2.53,2.37,2.20,1.98,1.76,1.57,1.39,1.26,1.16,1.12,1.09,1.10,1.14,1.25,1.42,1.66,1.92,2.22,2.48,2.72,2.95,3.15,3.36,3.51,3.66,3.83,3.95,3.91,3.83,3.59,3.33,2.99,2.66,2.37,2.13,2.01,2.02,2.24,2.70,2.72,2.73,2.25,1.87,1.51,1.26,1.11,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.87,0.65,0.29,-0.15,-0.63,-1.01,-1.43,-3.30,-5.45,-7.36,-7.43,-6.52,-7.80,-7.84,-7.78,-8.77,-10,-12,-11,-10,-9.84,-10,-10,-10,-10,-10,-10,-9.87,-9.73,-9.62,-9.47,11.03,11.02,11,10.98,10.92,10.87,10.78,10.71,10.61,10.50,10.37,10.26,10.16,10.09,10.01,9.98,9.96,9.95,9.92,9.89,9.86,9.76,9.64,9.49,9.28,9.09,8.87,8.65,8.46,8.23,8,7.75,7.48,7.16,6.87,6.61,6.35,6.11,5.88,5.67,5.42,5.12,4.74,4.28,3.79,3.29,2.85,2.47,2.13,1.87,1.63,1.41,1.25,1.12,1.07,1.02,1,1,0.99,0.98,0.92,0.85,0.66,0.46,0.25,0.13,0.15,0.27,0.36,0.29,0.15,0.10,0.22,0.28,0.26,0.14,0,-0.05,0,0.12,0.23,0.27,0.28,0.26,0.51,0.71,0.75,0.62,0.39,0.21,0.10,0.13,0.25,0.35,0.33,0.21,0.08,0.04,0.10,0.09,-0.01,-0.11,-0.15,-0.18,-0.18,-0.14,0.02,0.26,0.51,0.60,0.48,0.14,-0.55,-1.25,-1.80,-2.50,-3.46,-4.43,-5.76,-6.91,-7.40,-7.88,-8.33,-8.67,-8.91,-9.07,-9.17,-9.26,-9.36,-9.61,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-10,-9,-7.34,-6.14,-4.09,-1.21,-0.23,0.39,0.62,0.72,0.76,0.83,0.87,0.90,0.91,0.95,0.96,0.96,0.97,0.97,0.99,1.03,1.13,1.28,1.48,1.70,1.92,2.15,2.34,2.41,2.41,2.27,2.12,1.92,1.73,1.51,1.34,1.21,1.11,1.04,1.02,1.03,1.09,1.16,1.29,1.48,1.67,1.90,2.12,2.35,2.54,2.75,2.95,3.11,3.25,3.37,3.45,3.45,3.38,3.21,2.97,2.64,2.37,2.14,2.02,2,2.01,2.21,2.70,2.27,2.01,1.75,1.51,1.32,1.14,1.04,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.87,0.67,0.36,-0.10,-0.59,-1.10,-1.60,-2.75,-6.13,-8.16,-9.75,-10,-9.14,-9.02,-7.86,-8.85,-11,-13,-12,-10,-9.83,-9.98,-10,-10,-10,-10,-10,-9.83,-9.75,-9.75,-9.88,11,10.99,10.97,10.92,10.87,10.79,10.72,10.62,10.50,10.37,10.26,10.15,10.07,9.99,9.91,9.88,9.87,9.87,9.87,9.86,9.78,9.70,9.51,9.29,9.03,8.75,8.49,8.23,7.99,7.75,7.52,7.27,7.01,6.74,6.47,6.17,5.90,5.63,5.39,5.16,4.92,4.64,4.28,3.87,3.40,2.92,2.50,2.14,1.86,1.62,1.39,1.23,1.10,1.02,1,0.99,0.99,0.98,0.98,0.97,0.90,0.75,0.50,0.24,0,-0.05,0.11,0.29,0.39,0.37,0.27,0.25,0.33,0.42,0.37,0.24,0.07,-0.03,-0.02,0.03,0.09,0.12,0.15,0.23,0.45,0.64,0.65,0.46,0.16,-0.09,-0.14,-0.02,0.17,0.29,0.25,0.07,-0.22,-0.33,-0.36,-0.38,-0.47,-0.51,-0.52,-0.51,-0.47,-0.35,-0.14,0.13,0.37,0.25,-0.03,-0.71,-1.59,-2.58,-3.48,-4.24,-5.18,-6.04,-6.68,-7.63,-8.05,-8.43,-8.79,-9.10,-9.34,-9.51,-9.66,-9.86,-10,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-10,-8.84,-7.17,-5.30,-3.17,-1.13,-0.22,0.27,0.45,0.49,0.58,0.67,0.77,0.86,0.89,0.92,0.96,0.97,0.97,0.98,0.99,1.01,1.11,1.23,1.37,1.57,1.76,1.97,2.12,2.21,2.23,2.13,2.01,1.87,1.70,1.50,1.33,1.17,1.09,1.03,1.01,1.01,1.04,1.12,1.24,1.37,1.53,1.71,1.87,2.07,2.25,2.42,2.61,2.76,2.90,3,3.07,3.07,3,2.86,2.62,2.37,2.13,2,1.97,1.96,1.97,1.98,1.89,1.72,1.34,1.37,1.26,1.14,1.08,1.01,0.99,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.88,0.75,0.51,0.15,-0.28,-0.84,-1.38,-1.88,-4.35,-7.74,-9.70,-11,-10,-8.21,-7.63,-8.53,-11,-12,-11,-9.83,-9.96,-10,-10,-10,-10,-10,-10,-9.79,-9.75,-9.88,-9.96,10.97,10.96,10.92,10.87,10.82,10.73,10.62,10.50,10.38,10.26,10.14,10.03,9.95,9.86,9.79,9.76,9.75,9.76,9.77,9.76,9.72,9.60,9.38,9.12,8.77,8.42,8.10,7.79,7.52,7.29,7.09,6.87,6.62,6.36,6.10,5.82,5.51,5.23,4.98,4.75,4.50,4.25,3.92,3.54,3.12,2.64,2.24,1.89,1.62,1.39,1.23,1.10,1.02,1,0.99,0.99,0.99,0.98,0.98,0.96,0.87,0.70,0.39,0.12,0,0.09,0.27,0.47,0.54,0.50,0.37,0.29,0.38,0.47,0.47,0.37,0.32,0.25,0.16,0.09,0.02,0,0.04,0.20,0.41,0.54,0.48,0.22,-0.09,-0.28,-0.27,-0.03,0.21,0.35,0.25,-0.01,-0.40,-0.73,-0.88,-0.98,-1.13,-1.20,-1.18,-1.21,-1.17,-0.95,-0.63,-0.42,-0.48,-0.61,-0.88,-1.75,-2.98,-3.97,-4.80,-5.63,-6.41,-7.12,-7.74,-8.23,-8.63,-8.97,-9.25,-9.54,-9.82,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-11,-11,-10,-10,-8.71,-7.16,-5.41,-3.50,-1.53,-0.38,0.12,0.10,0.11,0.22,0.39,0.58,0.73,0.83,0.89,0.92,0.96,0.97,0.97,0.98,1,1.07,1.14,1.25,1.40,1.57,1.73,1.86,1.92,1.97,1.90,1.86,1.75,1.62,1.47,1.32,1.17,1.10,1.04,1.01,1.01,1.04,1.13,1.25,1.38,1.52,1.64,1.77,1.90,2.04,2.20,2.35,2.49,2.61,2.71,2.75,2.75,2.66,2.52,2.32,2.12,1.97,1.85,1.75,1.65,1.66,1.70,1.29,1.28,1.20,1.10,1.08,1.04,1.01,0.99,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.91,0.84,0.67,0.45,0.08,-0.41,-0.93,-1.38,-1.72,-4.77,-7.60,-8.35,-8.67,-8.36,-7.90,-8.47,-11,-12,-9.98,-9.72,-10,-10,-10,-10,-10,-10,-10,-9.65,-9.75,-10,-10,10.95,10.92,10.88,10.83,10.74,10.62,10.50,10.38,10.27,10.15,10.03,9.92,9.82,9.72,9.62,9.58,9.58,9.60,9.62,9.63,9.60,9.48,9.25,8.95,8.57,8.15,7.77,7.45,7.16,6.95,6.74,6.53,6.32,6.04,5.77,5.48,5.15,4.86,4.63,4.40,4.15,3.90,3.62,3.27,2.87,2.45,2.03,1.70,1.41,1.23,1.10,1.02,1,0.99,0.98,0.98,0.98,0.98,0.97,0.95,0.85,0.63,0.35,0.11,0.07,0.23,0.48,0.65,0.66,0.51,0.29,0.12,0.08,0.14,0.28,0.46,0.54,0.53,0.36,0.12,-0.05,-0.14,-0.12,0,0.25,0.29,0.17,-0.03,-0.26,-0.38,-0.26,0,0.25,0.34,0.23,-0.12,-0.67,-1.16,-1.59,-2.62,-3.47,-3.74,-3.15,-3.07,-3.54,-2.79,-2.13,-2.30,-2.25,-2.18,-2.25,-3.27,-4.34,-5.22,-6.03,-6.80,-7.51,-8.11,-8.58,-8.93,-9.20,-9.45,-9.67,-9.96,-10,-10,-10,-11,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9.92,-8.74,-7.34,-5.75,-4,-2.37,-1.13,-0.54,-0.34,-0.33,-0.18,0.04,0.29,0.52,0.71,0.82,0.87,0.91,0.95,0.97,0.98,0.98,1,1.03,1.12,1.22,1.33,1.46,1.54,1.62,1.65,1.65,1.63,1.59,1.50,1.37,1.26,1.17,1.11,1.07,1.02,1.02,1.08,1.16,1.29,1.46,1.60,1.70,1.75,1.84,1.90,2.01,2.12,2.24,2.35,2.42,2.47,2.45,2.35,2.21,2.02,1.85,1.72,1.64,1.34,1.34,1.32,1.24,1.15,1.07,1.03,1.01,1,1,0.99,0.98,0.97,0.97,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.95,0.89,0.82,0.64,0.37,0,-0.40,-0.75,-1.01,-1.24,-3.79,-5.29,-5.82,-7.26,-7.89,-10,-13,-13,-11,-10,-11,-11,-11,-11,-10,-10,-10,-9.55,-9.84,-10,-10,10.92,10.89,10.84,10.75,10.62,10.50,10.38,10.27,10.16,10.07,9.95,9.82,9.66,9.52,9.39,9.32,9.27,9.32,9.36,9.40,9.39,9.32,9.11,8.78,8.39,7.98,7.58,7.23,6.95,6.72,6.51,6.33,6.10,5.84,5.51,5.20,4.87,4.61,4.36,4.12,3.87,3.62,3.35,3.02,2.66,2.28,1.91,1.53,1.27,1.11,1.02,1,0.99,0.99,0.98,0.98,0.97,0.95,0.91,0.87,0.76,0.58,0.28,0.08,0.04,0.25,0.53,0.75,0.70,0.45,0.10,-0.25,-0.42,-0.27,0.01,0.37,0.65,0.67,0.39,0.02,-0.26,-0.42,-0.43,-0.36,-0.24,-0.12,-0.14,-0.25,-0.38,-0.41,-0.27,-0.01,0.15,0.13,-0.85,-2.09,-2.86,-3.54,-4.22,-5.43,-7.11,-7.25,-6.37,-6.40,-6.48,-6.24,-5.09,-4.45,-4.42,-4.25,-4.62,-4.98,-5.72,-6.37,-7.07,-7.74,-8.37,-8.88,-9.25,-9.50,-9.76,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9.80,-8.79,-7.64,-6.37,-5,-3.67,-2.58,-1.75,-1.22,-0.78,-0.47,-0.26,-0.03,0.23,0.46,0.62,0.75,0.86,0.91,0.96,0.96,0.90,0.88,0.88,0.90,0.96,1.02,1.12,1.23,1.32,1.37,1.38,1.38,1.37,1.33,1.25,1.20,1.13,1.10,1.07,1.02,1.02,1.08,1.17,1.33,1.49,1.61,1.70,1.72,1.75,1.77,1.85,1.92,2.01,2.09,2.13,2.13,2.10,2,1.87,1.72,1.57,1.42,1.26,1.13,1.02,1.01,1.01,1.01,1,0.99,0.98,0.98,0.97,0.97,0.97,0.97,0.97,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.92,0.88,0.77,0.61,0.36,0.09,-0.14,-0.30,-0.48,-0.74,-2.04,-3.33,-4.59,-6.84,-9.27,-12,-12,-10,-10,-11,-11,-11,-11,-10,-10,-10,-9.85,-9.89,-10,-10,10.90,10.86,10.75,10.63,10.50,10.37,10.26,10.16,10.08,9.98,9.86,9.71,9.50,9.29,9.11,8.97,8.88,8.89,8.98,9.07,9.12,9.09,8.92,8.65,8.28,7.87,7.49,7.15,6.88,6.66,6.49,6.26,6,5.66,5.32,4.96,4.62,4.35,4.10,3.86,3.62,3.37,3.10,2.79,2.48,2.13,1.78,1.49,1.22,1.08,1,0.99,0.98,0.98,0.98,0.96,0.91,0.85,0.75,0.65,0.54,0.38,0.16,0,-0.02,0.16,0.45,0.66,0.64,0.33,-0.12,-0.59,-0.89,-0.75,-0.28,0.20,0.62,0.62,0.26,-0.21,-0.62,-0.95,-1.01,-0.96,-0.82,-0.53,-1.16,-1.88,-1.20,-0.49,-0.38,-0.46,-0.54,-2.38,-4.57,-6.03,-7.66,-7.73,-7.53,-7.77,-8.85,-9.01,-8.29,-8.37,-8.65,-8.18,-6.98,-6.42,-6.23,-6.24,-6.59,-6.88,-7,-7.40,-7.91,-8.47,-9,-9.42,-9.75,-10,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.79,-9,-8.13,-7.16,-6.16,-5.16,-4.22,-3.36,-2.66,-2.63,-1.91,-0.66,-0.37,-0.21,0.04,0.32,0.57,0.75,0.87,0.90,0.83,0.78,0.73,0.67,0.62,0.61,0.63,0.72,0.85,0.99,1.10,1.14,1.16,1.15,1.12,1.10,1.08,1.04,1.02,1,1,1,1.04,1.14,1.27,1.40,1.51,1.59,1.60,1.60,1.62,1.65,1.72,1.77,1.82,1.83,1.78,1.73,1.62,1.52,1.40,1.27,1.15,1.07,1,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.96,0.95,0.95,0.95,0.95,0.97,0.97,0.97,0.97,0.97,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.96,0.92,0.87,0.76,0.62,0.47,0.35,0.25,0.13,-0.09,-0.49,-1.10,-2.57,-4.27,-6.20,-9.55,-10,-9,-10,-11,-11,-11,-11,-10,-10,-10,-10,-9.91,-10,-10,10.87,10.78,10.64,10.49,10.34,10.22,10.13,10.08,10,9.90,9.77,9.60,9.35,9.04,8.76,8.52,8.39,8.37,8.46,8.58,8.67,8.73,8.65,8.47,8.15,7.82,7.49,7.22,7,6.78,6.57,6.28,5.96,5.58,5.15,4.75,4.40,4.12,3.86,3.62,3.38,3.13,2.87,2.59,2.26,1.96,1.65,1.38,1.20,1.04,0.99,0.96,0.98,0.98,0.96,0.90,0.79,0.62,0.40,0.23,0.10,0,-0.10,-0.16,-0.18,-0.03,0.21,0.46,0.49,0.16,-0.25,-0.80,-1.14,-1,-0.58,-0.04,0.40,0.41,0.01,-0.55,-1.36,-2.72,-3.70,-3.49,-2.43,-3.26,-3.68,-4.09,-4.02,-3.70,-3.25,-3.11,-4.33,-5.51,-7.74,-9.30,-9.87,-9.53,-8.37,-8.21,-8.52,-8.74,-8.61,-8.71,-8.87,-8.65,-8.22,-7.89,-7.65,-7.67,-7.93,-8.24,-8.10,-8.29,-8.63,-9.05,-9.49,-9.87,-10,-10,-10,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-15,-14,-14,-14,-14,-15,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.88,-9.33,-8.71,-8.03,-7.35,-6.63,-5.87,-5.17,-5.24,-5.26,-4.91,-3.32,-1.36,-0.79,-0.52,-0.15,0.24,0.57,0.65,0.67,0.63,0.59,0.51,0.40,0.28,0.17,0.14,0.24,0.42,0.66,0.87,0.97,0.98,0.95,0.91,0.89,0.88,0.88,0.87,0.87,0.88,0.91,0.99,1.07,1.15,1.25,1.34,1.37,1.38,1.38,1.39,1.42,1.48,1.50,1.51,1.49,1.41,1.35,1.25,1.20,1.12,1.08,1,0.97,0.92,0.92,0.95,0.96,0.96,0.97,0.97,0.97,0.96,0.92,0.90,0.89,0.89,0.91,0.92,0.95,0.96,0.97,0.97,0.97,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.91,0.87,0.79,0.73,0.65,0.61,0.53,0.36,-0.01,-0.61,-1.42,-3.07,-5.57,-6.77,-7.39,-8.74,-10,-11,-11,-11,-10,-10,-10,-10,-9.99,-9.88,-10,-10,10.77,10.64,10.45,10.25,10.10,10.02,10,9.98,9.95,9.86,9.72,9.49,9.16,8.78,8.38,8.04,7.84,7.75,7.79,7.91,8.08,8.17,8.21,8.11,7.89,7.65,7.45,7.25,7.11,6.91,6.66,6.35,5.96,5.50,5.02,4.59,4.21,3.89,3.64,3.40,3.17,2.91,2.63,2.34,2.02,1.75,1.50,1.28,1.12,1.01,0.95,0.89,0.88,0.89,0.86,0.75,0.58,0.25,-0.11,-0.41,-0.58,-0.59,-0.51,-0.47,-0.43,-0.37,-0.22,-0.02,0.04,-0.12,-1.30,-3.89,-4.26,-3,-1.78,-1.24,-1.13,-0.97,-1.47,-2.43,-3.70,-5.12,-6.71,-6.83,-5.41,-5.28,-5.62,-6.08,-6.25,-6.24,-6.20,-6.39,-7.41,-7.85,-8.35,-8.87,-8.63,-8.70,-8.30,-8.16,-8.59,-8.96,-9.11,-9.26,-9.35,-9.30,-9.15,-9.09,-8.97,-8.89,-8.91,-9.02,-9.01,-9.08,-9.30,-9.62,-9.99,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.71,-9.33,-8.91,-8.51,-8.09,-7.52,-6.95,-7.04,-7.75,-7.54,-6.38,-4.25,-2.20,-1.11,-0.60,-0.08,0.24,0.35,0.37,0.38,0.37,0.29,0.14,-0.05,-0.25,-0.35,-0.25,0,0.33,0.61,0.70,0.72,0.66,0.63,0.60,0.58,0.57,0.58,0.61,0.66,0.76,0.86,0.92,1,1.04,1.10,1.12,1.13,1.13,1.13,1.14,1.16,1.17,1.16,1.11,1.01,0.91,0.86,0.83,0.83,0.86,0.85,0.82,0.77,0.77,0.84,0.87,0.90,0.91,0.92,0.95,0.92,0.89,0.86,0.83,0.82,0.85,0.87,0.89,0.91,0.95,0.96,0.96,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.96,0.92,0.90,0.87,0.85,0.82,0.75,0.61,0.28,-0.24,-1.74,-3.57,-5.03,-6.29,-6.97,-8.21,-9.67,-10,-11,-11,-11,-11,-10,-10,-9.83,-9.89,-10,-10,10.58,10.39,10.12,9.88,9.76,9.76,9.84,9.87,9.87,9.82,9.64,9.38,9,8.52,8.01,7.57,7.24,7.08,7.08,7.15,7.29,7.42,7.50,7.49,7.38,7.25,7.15,7.12,7.13,7.04,6.79,6.39,5.88,5.37,4.85,4.37,3.99,3.70,3.46,3.23,2.98,2.71,2.38,2.08,1.76,1.51,1.33,1.16,1.04,0.97,0.87,0.76,0.71,0.62,0.54,0.45,0.14,-0.27,-0.75,-1.13,-1.52,-1.74,-2.46,-2.49,-1.65,-1.90,-1.85,-1.74,-1.92,-2.97,-4.87,-8.18,-8.34,-6.22,-4.63,-3.78,-3.40,-3.36,-3.58,-4.30,-5.33,-6.65,-7.76,-7.88,-7,-6.76,-6.78,-7.11,-7.49,-7.80,-8.02,-8.22,-8.73,-9.05,-8.68,-8.43,-8.49,-8.71,-8.93,-9.15,-9.29,-9.49,-9.73,-9.92,-10,-10,-10,-10,-10,-9.93,-9.88,-9.83,-9.60,-9.79,-10,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.91,-9.75,-9.61,-9.40,-9.16,-8.61,-7.90,-8.45,-8.93,-8.18,-6.61,-4.34,-2.38,-0.98,-0.35,-0.05,0,0.10,0.15,0.20,0.13,-0.02,-0.27,-0.60,-0.76,-0.66,-0.36,-0.09,0.11,0.16,0.16,0.14,0.11,0.08,0.03,0.03,0.10,0.20,0.35,0.51,0.65,0.74,0.76,0.78,0.82,0.85,0.86,0.85,0.83,0.79,0.78,0.76,0.73,0.62,0.50,0.40,0.37,0.37,0.45,0.52,0.59,0.51,0.40,0.41,0.53,0.67,0.75,0.78,0.85,0.87,0.89,0.85,0.75,0.66,0.64,0.67,0.74,0.82,0.87,0.88,0.89,0.90,0.92,0.95,0.96,0.97,0.97,0.97,0.97,0.97,0.97,0.96,0.95,0.92,0.91,0.89,0.85,0.72,0.46,-0.02,-1.58,-4.01,-5.48,-5.63,-6.18,-7.33,-8.71,-10,-11,-12,-12,-11,-11,-10,-9.71,-9.88,-10,-10,10.24,10,9.67,9.41,9.35,9.42,9.61,9.75,9.78,9.74,9.58,9.27,8.86,8.28,7.67,7.11,6.66,6.40,6.32,6.34,6.41,6.52,6.61,6.57,6.50,6.47,6.47,6.52,6.61,6.63,6.45,6.03,5.53,5,4.50,4.09,3.75,3.50,3.29,3.08,2.78,2.47,2.12,1.78,1.50,1.29,1.15,1.07,0.98,0.87,0.75,0.57,0.36,0.14,-0.02,-0.23,-0.51,-1.16,-2.28,-3.34,-4,-4.72,-5.37,-5.68,-5.22,-4.71,-4.30,-4.07,-4.21,-5.12,-6.72,-8.68,-9.95,-8.24,-6.79,-5.76,-5.48,-5.51,-5.50,-5.76,-6.41,-7.22,-7.84,-7.95,-7.76,-7.60,-7.61,-7.76,-8.09,-8.45,-8.77,-9.09,-9.47,-9.13,-9.58,-9.64,-9.76,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.46,-8.47,-8.89,-8.80,-7.18,-6.01,-4.01,-1.68,-0.43,-0.24,-0.25,-0.18,-0.08,0.03,0.07,-0.05,-0.28,-0.58,-0.75,-0.68,-0.55,-0.50,-0.53,-1.43,-1.49,-0.71,-0.74,-0.74,-0.72,-0.66,-0.54,-0.35,-0.08,0.21,0.38,0.46,0.45,0.41,0.42,0.46,0.48,0.46,0.39,0.35,0.28,0.24,0.14,0.02,-0.12,-0.24,-0.26,-0.25,-0.15,-0.03,0.09,0.11,-0.18,-0.22,0.12,0.29,0.46,0.53,0.63,0.75,0.83,0.77,0.61,0.42,0.36,0.38,0.50,0.62,0.72,0.75,0.77,0.82,0.85,0.88,0.91,0.95,0.96,0.97,0.97,0.97,0.97,0.97,0.97,0.96,0.96,0.92,0.87,0.74,0.50,0.02,-1.52,-4.72,-5.98,-5.33,-5.83,-6.80,-8.14,-10,-11,-12,-12,-11,-11,-10,-10,-9.92,-10,-10,9.78,9.52,9.13,8.87,8.83,9,9.27,9.52,9.63,9.61,9.42,9.12,8.70,8.11,7.40,6.74,6.16,5.78,5.60,5.52,5.54,5.58,5.59,5.59,5.57,5.54,5.60,5.71,5.83,5.87,5.75,5.41,4.97,4.46,4,3.67,3.46,3.29,3.14,2.90,2.59,2.21,1.84,1.51,1.28,1.13,1.03,0.97,0.88,0.75,0.57,0.28,-0.03,-0.38,-0.67,-1,-2,-3.67,-4.78,-5.63,-6.27,-6.91,-7.63,-8.55,-8.09,-7.29,-6.73,-6.29,-6.25,-6.62,-7.33,-8.04,-8.33,-8.10,-7.64,-7.01,-6.89,-6.97,-6.83,-6.79,-7.13,-7.60,-7.99,-8.18,-8.27,-8.27,-8.30,-8.43,-8.74,-9.12,-9.51,-9.84,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-9.85,-8.78,-8.45,-8.11,-7.14,-5.78,-3.48,-1.18,-0.55,-0.60,-0.51,-0.33,-0.11,0.03,0.02,-0.10,-0.25,-0.38,-0.43,-0.54,-0.78,-3.42,-4.65,-4.07,-3.17,-2.34,-2.36,-1.59,-2.12,-1.93,-0.88,-0.47,-0.12,0.08,0.10,0,-0.08,-0.11,-0.10,-0.08,-0.10,-0.14,-0.22,-0.28,-0.38,-0.51,-0.67,-0.85,-0.97,-1,-1.01,-1,-0.90,-0.78,-0.84,-0.92,-0.87,-0.58,-0.17,0.08,0.20,0.32,0.50,0.74,0.73,0.40,0.09,-0.08,-0.01,0.14,0.34,0.45,0.50,0.54,0.62,0.72,0.79,0.87,0.91,0.96,0.96,0.97,0.96,0.96,0.96,0.96,0.95,0.92,0.90,0.85,0.67,0.39,-0.11,-2.29,-5.64,-6.80,-5.77,-5.84,-7.09,-8.50,-9.83,-10,-11,-11,-11,-11,-11,-10,-10,-10,-9.92,9.32,9.01,8.60,8.29,8.26,8.50,8.86,9.17,9.36,9.34,9.15,8.88,8.49,7.90,7.21,6.45,5.76,5.27,5,4.87,4.83,4.75,4.72,4.66,4.63,4.62,4.65,4.72,4.76,4.77,4.66,4.42,4.10,3.74,3.41,3.20,3.07,3.02,2.98,2.74,2.38,1.96,1.61,1.33,1.12,1.02,0.97,0.88,0.77,0.61,0.35,0,-0.42,-1.16,-2.21,-3.58,-4.96,-5.97,-6.91,-7.53,-7.85,-8.16,-8.61,-9.04,-8.96,-8.66,-8.20,-7.75,-7.61,-7.53,-7.64,-7.70,-7.64,-7.66,-7.71,-7.63,-7.58,-7.53,-7.47,-7.50,-7.68,-7.99,-8.33,-8.60,-8.82,-8.95,-9.10,-9.32,-9.61,-9.96,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9.76,-8.74,-8.37,-8.16,-6.96,-4.91,-3.08,-2.77,-2.01,-0.92,-0.63,-0.29,0,0.14,0.16,0.12,0.03,-0.11,-0.39,-2.39,-6.30,-8.50,-7.09,-5.48,-4.89,-4.35,-4.10,-4.07,-4.45,-3.83,-1.77,-0.46,-0.24,-0.30,-1.35,-1.60,-0.84,-1.47,-1.52,-0.78,-0.73,-0.76,-0.87,-1.01,-1.21,-1.41,-1.60,-1.67,-1.86,-1.90,-2.12,-2.23,-2.15,-1.96,-1.64,-1.52,-1.21,-0.63,-0.25,-0.15,-0.15,0.03,0.37,0.53,0.23,-0.26,-0.60,-0.50,-0.30,-0.13,0,0.11,0.21,0.35,0.50,0.67,0.82,0.89,0.92,0.95,0.95,0.92,0.91,0.90,0.90,0.89,0.87,0.85,0.75,0.53,0.20,-0.38,-3.30,-6.61,-7.53,-6.65,-6.46,-7.63,-8.75,-9.76,-10,-11,-11,-11,-11,-11,-10,-10,-10,-9.84,8.87,8.54,8.12,7.78,7.75,7.97,8.35,8.72,8.91,8.90,8.74,8.49,8.14,7.64,6.96,6.16,5.42,4.96,4.61,4.35,4.16,4.03,3.92,3.85,3.77,3.75,3.75,3.76,3.78,3.77,3.67,3.50,3.27,3.01,2.78,2.65,2.60,2.59,2.60,2.41,2.07,1.70,1.37,1.15,1.01,0.92,0.87,0.78,0.64,0.42,0.13,-0.26,-0.99,-2.30,-4.16,-5.92,-7.33,-7.78,-8.36,-8.64,-8.70,-8.72,-8.79,-8.98,-9.07,-8.84,-8.58,-8.35,-8.21,-8.10,-8.03,-7.84,-7.68,-7.71,-7.83,-8.01,-8.02,-7.99,-7.95,-8.05,-8.23,-8.49,-8.83,-9.16,-9.38,-9.62,-9.88,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-11,-10,-9.41,-8.51,-8.33,-7.12,-5.46,-5.03,-4.85,-4.71,-2.91,-1.03,-0.55,-0.11,0.22,0.36,0.38,0.36,0.23,-0.23,-3.18,-6.54,-8.72,-7.45,-5.59,-5.95,-5.59,-5.60,-6.30,-7.55,-7.14,-4.98,-3.39,-2.14,-1.96,-4.34,-4.71,-3.91,-3.91,-3.87,-2.88,-1.93,-1.95,-2.01,-2.14,-2.50,-2.77,-2.91,-3.18,-3.35,-3.83,-4.12,-4.29,-3.55,-4,-3.60,-2.15,-1.65,-0.93,-0.27,-0.49,-0.73,-0.60,-0.10,0.34,0.23,-0.50,-0.91,-0.92,-0.75,-0.62,-0.49,-0.35,-0.16,0.07,0.32,0.57,0.75,0.87,0.90,0.91,0.89,0.87,0.84,0.82,0.78,0.76,0.75,0.67,0.54,0.28,-0.13,-2.21,-4.55,-7.24,-7.90,-6.85,-7.22,-8.15,-9.03,-9.80,-10,-10,-11,-11,-11,-10,-10,-10,-9.90,-9.71,8.53,8.22,7.75,7.39,7.28,7.46,7.78,8.13,8.35,8.32,8.12,7.88,7.61,7.20,6.58,5.79,5.13,4.61,4.20,3.87,3.63,3.42,3.27,3.13,3.02,2.97,2.92,2.91,2.91,2.88,2.82,2.70,2.51,2.35,2.21,2.12,2.12,2.12,2.09,1.95,1.71,1.45,1.17,1,0.87,0.78,0.74,0.65,0.51,0.27,-0.03,-0.48,-1.86,-3.89,-6.09,-7.93,-8.89,-8.92,-9.18,-9.28,-9.29,-9.21,-9.11,-9.08,-9.16,-9.04,-8.88,-8.76,-8.73,-8.66,-8.58,-8.48,-8.39,-8.37,-8.37,-8.46,-8.47,-8.45,-8.45,-8.59,-8.76,-9.01,-9.33,-9.66,-9.95,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-11,-10,-9.76,-9.02,-8.35,-7.54,-6.34,-5.85,-6.39,-6.27,-5.27,-3.07,-0.98,-0.35,0.09,0.35,0.47,0.50,0.34,-0.14,-1.68,-5.60,-6.40,-4.92,-4.92,-5.59,-6.17,-5.75,-7.18,-8.55,-8.28,-7.50,-5.99,-5.28,-6.87,-7.82,-7.74,-6.89,-6.15,-6.72,-7.02,-7.40,-5.88,-5.30,-5.45,-5.15,-5.59,-5.03,-5.24,-5.87,-6.29,-6.60,-6.10,-5.98,-5.78,-5.32,-4.53,-3.45,-2.83,-3.22,-3,-1.37,-1.43,-0.88,-0.22,-0.13,-0.64,-1.02,-2.55,-3.33,-1.83,-0.92,-0.73,-0.46,-0.13,0.21,0.49,0.71,0.84,0.88,0.87,0.83,0.75,0.66,0.60,0.53,0.50,0.46,0.37,0.21,-0.10,-1.26,-3.46,-6.11,-7.60,-7.47,-7.12,-7.97,-8.65,-9.26,-9.77,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.74,-9.54,8.26,7.95,7.48,7.09,6.90,6.98,7.25,7.53,7.71,7.63,7.42,7.16,6.91,6.54,5.96,5.35,4.75,4.25,3.82,3.48,3.17,2.92,2.74,2.54,2.41,2.33,2.26,2.23,2.21,2.16,2.11,2.01,1.90,1.79,1.72,1.67,1.70,1.70,1.63,1.53,1.37,1.16,1,0.84,0.71,0.62,0.54,0.49,0.40,0.17,-0.16,-0.63,-3.09,-5.15,-7.42,-8.85,-9.45,-9.57,-9.76,-9.92,-10,-9.91,-9.77,-9.61,-9.58,-9.51,-9.43,-9.35,-9.28,-9.23,-9.20,-9.17,-9.15,-9.11,-9.05,-9.02,-9,-8.98,-9,-9.09,-9.26,-9.47,-9.71,-10,-10,-10,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.84,-9.26,-8.75,-8.15,-6.91,-5.61,-6.33,-6.87,-6.08,-5.12,-2.96,-0.86,-0.26,0.09,0.33,0.45,0.34,-0.15,-1.61,-4.10,-5.18,-4.91,-5.28,-6.24,-7,-7.50,-7.72,-8.26,-8.48,-7.74,-7.78,-8.63,-9.48,-9.73,-8.50,-5.78,-6.33,-8.33,-10,-12,-11,-9.18,-8.85,-8.50,-6.74,-6.79,-6.41,-8.40,-9.07,-7.87,-7.05,-6.73,-6.75,-6.99,-6.89,-6.48,-7.93,-8.39,-6.97,-4.98,-3.76,-3.23,-1.88,-0.76,-0.65,-3.84,-6.42,-6.73,-5.13,-1.91,-0.85,-0.48,-0.11,0.23,0.50,0.71,0.83,0.87,0.83,0.72,0.57,0.39,0.25,0.14,0.07,-0.02,-0.13,-0.30,-0.62,-2.53,-5,-6.62,-7.25,-7.09,-8.01,-8.63,-9.05,-9.40,-9.68,-9.90,-10,-10,-10,-10,-9.97,-9.77,-9.61,-9.51,-9.39,7.99,7.67,7.23,6.82,6.60,6.61,6.79,7.02,7.13,7.02,6.77,6.50,6.23,5.87,5.40,4.88,4.37,3.88,3.47,3.10,2.77,2.50,2.27,2.10,1.95,1.84,1.76,1.73,1.67,1.64,1.61,1.54,1.48,1.41,1.37,1.36,1.36,1.34,1.27,1.17,1.03,0.89,0.75,0.61,0.49,0.37,0.34,0.33,0.23,-0.14,-0.86,-2.26,-4.09,-6.16,-8,-9.09,-9.61,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.78,-9.77,-9.75,-9.95,-9.93,-9.84,-9.74,-9.65,-9.60,-9.51,-9.50,-9.55,-9.68,-9.92,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.78,-9.33,-8.86,-8.28,-7,-6.18,-5.33,-5.82,-6.33,-5.54,-4.97,-2.92,-0.86,-0.35,-0.02,0.16,0.17,-0.25,-2.63,-4.35,-5.29,-5.89,-6.50,-7.66,-8.67,-9.46,-9.83,-9.67,-9.05,-8.18,-8.72,-9.54,-8.89,-8.64,-6.30,-5.70,-5.63,-5.89,-9.09,-10,-9.23,-8.17,-8.03,-7.82,-6.57,-6.02,-8.43,-10,-10,-9.63,-8.53,-7.38,-7,-7.38,-7.22,-7.86,-9.09,-9.47,-8.55,-7.18,-6.73,-6.52,-4.53,-3.80,-3.88,-5.17,-8.58,-9.88,-6.80,-2.62,-0.72,-0.30,0.07,0.35,0.58,0.73,0.82,0.83,0.74,0.54,0.32,0.04,-0.18,-0.38,-0.53,-0.65,-0.78,-1.70,-3.04,-4.54,-6.54,-7.11,-6.97,-8.02,-8.79,-9.22,-9.38,-9.49,-9.53,-9.58,-9.61,-9.62,-9.63,-9.60,-9.49,-9.38,-9.33,-9.26,-9.18,7.62,7.37,6.97,6.59,6.37,6.37,6.54,6.75,6.78,6.62,6.34,6.02,5.75,5.37,4.95,4.47,3.98,3.51,3.11,2.75,2.41,2.14,1.91,1.74,1.60,1.50,1.41,1.37,1.35,1.32,1.27,1.24,1.21,1.16,1.14,1.12,1.11,1.08,1,0.87,0.75,0.61,0.47,0.33,0.17,0.09,0.03,0.03,-0.23,-0.67,-1.59,-3.15,-5.08,-6.77,-8.16,-9.15,-9.79,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.91,-9.88,-9.91,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-9.75,-9.36,-8.88,-8.13,-7.37,-6.50,-5.53,-4.59,-4.79,-5.82,-5.51,-4.35,-3,-1.68,-0.55,-0.36,-0.29,-1.67,-3.51,-5.92,-6.40,-6.26,-7.63,-8.91,-10,-10,-11,-11,-11,-10,-9.04,-8.79,-8.61,-6.87,-6.73,-7.51,-6.43,-4.27,-3.53,-4.26,-2.73,-3.14,-4.47,-4.34,-4.61,-5.25,-8.42,-11,-11,-10,-9.63,-9.42,-8.25,-7.14,-6.89,-6.62,-5.93,-6.77,-6.46,-5.96,-7.46,-7.37,-7.08,-6.78,-6.91,-6.43,-7.75,-8.43,-6.16,-3.35,-0.61,-0.11,0.26,0.48,0.62,0.72,0.76,0.75,0.62,0.37,0.01,-0.37,-0.71,-0.99,-1.23,-2.25,-3.24,-4.23,-5.77,-6.76,-7.14,-7.36,-7.62,-8.46,-9.04,-9.35,-9.42,-9.43,-9.33,-9.23,-9.17,-9.15,-9.14,-9.16,-9.11,-9.10,-9.12,-9.09,-8.98,7.23,7,6.67,6.37,6.24,6.32,6.51,6.70,6.70,6.48,6.16,5.82,5.45,5.02,4.58,4.10,3.62,3.16,2.76,2.41,2.11,1.85,1.63,1.48,1.35,1.25,1.21,1.15,1.13,1.11,1.08,1.03,1,0.99,0.98,0.96,0.91,0.86,0.75,0.62,0.48,0.34,0.17,0.01,-0.13,-0.28,-0.38,-0.40,-1.14,-1.87,-2.90,-4.30,-6.05,-7.42,-8.53,-9.39,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-15,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-13,-14,-14,-14,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.78,-9.41,-9,-8.53,-7.76,-6.85,-5.88,-4.89,-3.75,-4.68,-5.17,-4.80,-4.33,-3.77,-2.68,-1.13,-1.26,-2.61,-5.09,-6.49,-6.87,-7.34,-8.67,-9.99,-11,-12,-12,-12,-12,-11,-10,-9.61,-8.53,-7.47,-7.87,-8.40,-7.05,-3.72,-1.26,-0.62,-0.28,-0.46,-1.68,-2.28,-2.46,-4.80,-6.92,-9.86,-11,-10,-10,-10,-9.61,-8.37,-7.25,-6.34,-5.63,-5.15,-4.92,-5.55,-6.21,-6.10,-6.71,-7.33,-6.73,-5.87,-4.75,-5.34,-5.86,-4.63,-2.47,-0.28,0.26,0.48,0.57,0.61,0.64,0.62,0.48,0.16,-0.27,-0.77,-1.25,-1.76,-2.88,-4.30,-5.77,-6.49,-6.52,-7.18,-7.28,-7.34,-8.10,-8.77,-9.21,-9.37,-9.35,-9.22,-9.09,-8.90,-8.83,-8.83,-8.86,-8.90,-8.98,-8.98,-9.01,-9,-8.85,6.87,6.70,6.42,6.22,6.16,6.32,6.57,6.74,6.65,6.33,5.99,5.61,5.21,4.76,4.29,3.82,3.36,2.92,2.53,2.21,1.91,1.67,1.50,1.35,1.24,1.14,1.10,1.07,1.01,0.98,0.91,0.87,0.84,0.79,0.78,0.76,0.74,0.65,0.53,0.39,0.25,0.10,-0.14,-0.48,-0.79,-1.01,-1.27,-1.65,-2.75,-3.90,-5.01,-6.11,-7.21,-8.20,-9.03,-9.78,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-17,-16,-16,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.74,-9.30,-8.80,-8.18,-7.48,-6.72,-5.97,-5.33,-4.71,-4.89,-5.09,-5.16,-5.80,-5.14,-3.86,-3.47,-4.02,-5.78,-6.83,-7.03,-8.21,-9.49,-10,-11,-12,-13,-13,-13,-12,-11,-10,-9.89,-8.75,-7.48,-7.58,-5.96,-2.58,-1.21,-0.42,0.03,0,-0.47,-1.15,-2.54,-4.55,-6.90,-9,-10,-11,-11,-10,-10,-9.12,-8.12,-7.35,-6.77,-6.41,-6.23,-6.16,-6.14,-6.04,-5.85,-7,-6.45,-4.34,-3.66,-4.73,-5.90,-5.46,-4.80,-2.59,-0.50,-0.08,0.11,0.20,0.24,0.29,0.34,-0.02,-0.59,-1.42,-2.99,-3.79,-4.33,-5.71,-6.36,-6.83,-6.75,-6.63,-7.13,-7.80,-8.36,-8.80,-9.10,-9.15,-9.12,-9,-8.86,-8.67,-8.63,-8.66,-8.75,-8.84,-8.92,-8.98,-9.02,-8.99,-8.84,6.61,6.45,6.23,6.08,6.08,6.16,6.33,6.42,6.27,6.01,5.67,5.33,4.91,4.48,4,3.54,3.11,2.70,2.32,2,1.73,1.51,1.36,1.23,1.13,1.07,1.01,0.98,0.92,0.87,0.77,0.70,0.61,0.54,0.51,0.50,0.48,0.41,0.34,0.16,-0.10,-0.36,-0.90,-1.39,-1.91,-2.36,-2.89,-3.55,-4.77,-5.97,-7.21,-8.07,-8.51,-9.05,-9.63,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-16,-15,-15,-15,-15,-15,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-17,-17,-17,-17,-16,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-15,-15,-16,-16,-16,-15,-15,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.75,-9.28,-8.75,-8.17,-7.60,-7.03,-6.52,-6.05,-5.43,-4.85,-5.79,-6.47,-6.02,-5.58,-5.32,-5.80,-6.43,-7.13,-7.92,-8.85,-9.85,-11,-12,-12,-13,-13,-13,-13,-12,-11,-10,-9.76,-8.43,-6.90,-5.21,-2.90,-1.14,-0.16,0.47,0.49,-0.03,-0.92,-2.42,-5.37,-7.88,-9.33,-10,-11,-11,-11,-10,-9.54,-8.72,-8.10,-7.68,-7.48,-7.40,-7.47,-7.52,-7.50,-7.34,-7.02,-6.47,-5.79,-5.13,-4.50,-5.40,-6.45,-5.92,-4.52,-3.09,-1.79,-0.63,-0.47,-0.40,-0.42,-0.63,-0.98,-1.63,-3.23,-5.10,-5.96,-5.67,-6.10,-6.59,-6.47,-6.88,-7.26,-7.64,-8.01,-8.40,-8.68,-8.85,-8.88,-8.85,-8.75,-8.66,-8.61,-8.54,-8.65,-8.77,-8.90,-9,-9.08,-9.11,-9.04,-8.91,6.38,6.25,6.02,5.87,5.76,5.75,5.77,5.79,5.71,5.50,5.25,4.96,4.58,4.13,3.72,3.26,2.85,2.46,2.10,1.79,1.58,1.38,1.25,1.13,1.07,1,0.97,0.91,0.86,0.77,0.65,0.52,0.37,0.25,0.14,0.11,0.10,0.05,0,-0.39,-0.75,-1.22,-2.10,-2.87,-3.60,-4.27,-4.97,-5.79,-6.63,-7.86,-8.95,-9.55,-9.59,-9.82,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-17,-17,-16,-16,-15,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-13,-14,-14,-15,-15,-16,-15,-15,-15,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.89,-9.42,-8.93,-8.48,-8.01,-7.60,-7.14,-6.64,-6.14,-5.77,-6.30,-6.52,-6.22,-6.54,-7.16,-7.54,-7.97,-8.52,-9.21,-10,-10,-11,-12,-13,-13,-13,-13,-12,-12,-11,-10,-9.13,-7.62,-5.89,-4,-1.16,-0.13,0.50,0.51,0,-0.93,-3.15,-6.49,-8.54,-9.91,-10,-11,-11,-10,-10,-9.61,-9,-8.59,-8.37,-8.33,-8.41,-8.58,-8.79,-8.88,-8.76,-8.40,-7.93,-7.21,-6.47,-5.78,-5.13,-6,-6.29,-5.77,-5.27,-3.99,-3.41,-2.26,-1.39,-2.15,-2.43,-2.92,-3.47,-4.28,-6.12,-6.99,-6.74,-6.36,-6.75,-7.13,-7.50,-7.74,-7.92,-8.13,-8.29,-8.46,-8.54,-8.59,-8.58,-8.54,-8.55,-8.60,-8.65,-8.75,-8.89,-9.03,-9.13,-9.22,-9.24,-9.15,-8.98,6.14,6,5.79,5.59,5.39,5.26,5.17,5.10,5,4.87,4.67,4.45,4.14,3.77,3.38,2.99,2.60,2.23,1.89,1.63,1.42,1.26,1.15,1.08,1.01,0.98,0.92,0.88,0.82,0.72,0.58,0.38,0.16,-0.03,-0.22,-0.28,-0.36,-0.41,-0.64,-1.37,-1.96,-2.71,-3.77,-4.65,-5.40,-6.15,-7.01,-7.72,-8.07,-8.87,-9.58,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-13,-13,-14,-14,-14,-15,-16,-16,-15,-15,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-12,-13,-13,-14,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.75,-9.34,-8.92,-8.52,-8.13,-7.67,-7.25,-6.93,-6.80,-6.90,-7.21,-7.48,-7.75,-8.12,-8.39,-8.77,-9.28,-9.89,-10,-11,-12,-12,-13,-13,-13,-12,-12,-11,-10,-9.48,-8.08,-6.51,-4.72,-2.27,-0.63,-0.10,-0.04,-0.47,-2.63,-4.80,-7.47,-9.13,-10,-10,-10,-10,-10,-9.78,-9.34,-8.98,-8.76,-8.77,-8.91,-9.16,-9.47,-9.72,-10,-9.96,-9.60,-9.18,-8.41,-7.63,-6.98,-6.27,-5.65,-5.87,-6.15,-5.79,-6.11,-5.65,-4.57,-4.15,-4.26,-5.30,-5.75,-5.49,-5.26,-6.04,-6.83,-6.67,-7.09,-7.41,-7.66,-7.84,-8,-8.09,-8.13,-8.18,-8.25,-8.26,-8.33,-8.38,-8.43,-8.52,-8.64,-8.77,-8.90,-9.05,-9.21,-9.30,-9.38,-9.38,-9.28,-9.14,5.97,5.78,5.57,5.27,5,4.75,4.57,4.41,4.33,4.21,4.08,3.89,3.66,3.37,3.03,2.67,2.33,2,1.72,1.49,1.32,1.17,1.10,1.02,0.99,0.95,0.90,0.87,0.78,0.67,0.51,0.29,0.03,-0.24,-0.53,-0.79,-1.03,-1.41,-1.97,-2.96,-3.76,-4.73,-5.67,-6.47,-7.14,-7.73,-8.37,-8.79,-9.04,-9.41,-9.95,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.93,-9.88,-9.91,-10,-10,-10,-10,-9.92,-9.87,-9.87,-9.97,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-11,-11,-12,-13,-14,-14,-14,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.75,-9.37,-8.96,-8.54,-8.17,-7.89,-7.75,-7.75,-7.85,-8,-8.12,-8.26,-8.49,-8.75,-9.12,-9.59,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-10,-9.52,-8.34,-6.98,-5.48,-3.72,-1.65,-1.40,-1.49,-3.29,-4.97,-6.76,-8.33,-9.53,-10,-10,-10,-10,-9.65,-9.25,-8.92,-8.76,-8.75,-8.89,-9.21,-9.61,-10,-10,-10,-10,-10,-10,-9.27,-8.51,-7.90,-7.25,-6.66,-6.17,-5.78,-6.16,-6.57,-6.30,-5.97,-5.59,-5.63,-6.60,-6.93,-6.58,-6.23,-6.10,-6.71,-7.21,-7.66,-7.89,-8.01,-8.08,-8.10,-8.11,-8.05,-8.05,-8.09,-8.13,-8.16,-8.29,-8.43,-8.60,-8.75,-8.92,-9.10,-9.25,-9.37,-9.48,-9.52,-9.52,-9.46,-9.28,5.77,5.62,5.36,5,4.62,4.26,3.98,3.79,3.67,3.58,3.48,3.35,3.16,2.95,2.66,2.37,2.07,1.77,1.53,1.35,1.21,1.11,1.02,0.99,0.96,0.92,0.89,0.86,0.77,0.65,0.47,0.24,-0.04,-0.37,-0.82,-1.66,-2.29,-3.20,-4.07,-4.91,-5.75,-6.67,-7.42,-8.04,-8.45,-8.80,-9.11,-9.35,-9.57,-9.84,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-11,-10,-11,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.97,-9.80,-9.59,-9.49,-9.50,-9.62,-9.78,-9.97,-10,-9.98,-9.75,-9.59,-9.61,-9.65,-9.84,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.63,-9.22,-8.91,-8.74,-8.68,-8.71,-8.92,-9.27,-9.74,-10,-10,-10,-10,-9.92,-9.77,-10,-10,-11,-12,-13,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.73,-9.34,-8.98,-8.67,-8.50,-8.38,-8.35,-8.35,-8.29,-8.29,-8.37,-8.50,-8.75,-9.11,-9.54,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-9.39,-8.42,-7.35,-6.18,-4.88,-3.85,-3.58,-4.33,-5.53,-7.15,-8.47,-9.46,-10,-10,-10,-10,-9.62,-9.13,-8.74,-8.49,-8.46,-8.60,-8.86,-9.21,-9.71,-10,-10,-10,-10,-10,-10,-9.71,-9.02,-8.51,-7.93,-7.48,-7.10,-6.85,-6.52,-6.27,-6.77,-6.43,-5.43,-6.05,-6.15,-6.38,-6.65,-6.36,-6.87,-7.33,-7.73,-7.99,-8.21,-8.24,-8.21,-8.13,-8.08,-7.98,-7.96,-7.99,-8.05,-8.13,-8.34,-8.52,-8.73,-8.91,-9.10,-9.26,-9.40,-9.52,-9.62,-9.67,-9.66,-9.61,-9.50,5.67,5.51,5.21,4.77,4.29,3.85,3.50,3.25,3.10,2.99,2.89,2.82,2.67,2.50,2.28,2.04,1.79,1.58,1.37,1.23,1.12,1.03,0.99,0.96,0.92,0.90,0.87,0.84,0.75,0.64,0.42,0.17,-0.14,-0.76,-1.70,-3,-4.05,-5.10,-6.25,-6.86,-7.59,-8.33,-8.86,-9.28,-9.49,-9.64,-9.74,-9.84,-10,-10,-10,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.84,-10,-10,-11,-11,-11,-12,-12,-13,-14,-14,-14,-14,-14,-14,-15,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.98,-9.71,-9.49,-9.26,-9.04,-8.95,-8.96,-9.12,-9.35,-9.54,-9.64,-9.61,-9.54,-9.28,-10,-10,-11,-12,-11,-10,-11,-11,-11,-10,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-12,-11,-10,-10,-9.96,-9.58,-9.25,-8.74,-8.25,-7.98,-7.65,-7.38,-7.14,-6.86,-6.71,-6.78,-7.17,-7.97,-8.22,-8.36,-8.68,-9.05,-9.02,-7.91,-8.36,-9.13,-10,-11,-12,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-16,-16,-16,-15,-15,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.66,-9.36,-9.12,-8.90,-8.73,-8.58,-8.38,-8.23,-8.12,-8.13,-8.26,-8.53,-8.89,-9.30,-9.74,-10,-10,-10,-10,-10,-10,-10,-9.83,-9.16,-8.43,-7.63,-6.78,-6,-5.40,-5.53,-6.30,-7.50,-8.71,-9.86,-10,-10,-10,-10,-9.77,-9.24,-8.67,-8.28,-8.12,-8.13,-8.36,-8.68,-9.09,-9.51,-10,-10,-10,-10,-10,-10,-9.72,-9.18,-8.78,-8.37,-8.02,-7.78,-7.66,-7.47,-7.34,-7.15,-6.84,-6.63,-6.47,-6.43,-6.54,-6.78,-7.11,-7.50,-7.79,-8.08,-8.25,-8.36,-8.33,-8.25,-8.14,-8.04,-7.92,-7.91,-7.99,-8.10,-8.23,-8.46,-8.67,-8.89,-9.10,-9.26,-9.43,-9.58,-9.66,-9.75,-9.79,-9.79,-9.75,-9.73,5.61,5.41,5.08,4.60,4.03,3.51,3.09,2.77,2.60,2.47,2.38,2.32,2.23,2.10,1.92,1.75,1.54,1.37,1.23,1.11,1.02,0.98,0.95,0.91,0.89,0.87,0.85,0.79,0.73,0.61,0.30,-0.01,-0.57,-1.73,-3.29,-4.60,-5.75,-6.91,-7.97,-8.40,-9.02,-9.60,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.99,-9.79,-9.71,-9.78,-9.85,-9.90,-9.89,-9.88,-9.91,-10,-10,-10,-11,-11,-12,-13,-13,-13,-14,-14,-14,-14,-15,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.85,-9.58,-9.29,-8.97,-8.65,-8.42,-8.34,-8.36,-8.48,-8.74,-9.03,-9.22,-9.24,-9.30,-9.73,-10,-12,-15,-15,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.72,-9.42,-9.23,-9.29,-9.53,-11,-13,-11,-10,-9.36,-8.91,-8.55,-8.14,-7.71,-7.20,-6.75,-6.64,-6.47,-6.28,-5.90,-5.34,-4.83,-4.64,-4.89,-5.40,-5.53,-5.03,-6.60,-7.71,-7.93,-7.46,-7.18,-7.46,-8.29,-9.30,-10,-11,-12,-13,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-16,-16,-15,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9.98,-9.64,-9.35,-9.03,-8.74,-8.39,-8.08,-7.77,-7.66,-7.73,-7.92,-8.24,-8.61,-8.98,-9.28,-9.62,-9.86,-10,-10,-9.96,-9.74,-9.38,-8.92,-8.40,-7.86,-7.30,-6.89,-6.66,-7.03,-7.83,-8.97,-9.92,-10,-11,-11,-10,-10,-9.55,-8.93,-8.36,-7.99,-7.86,-7.93,-8.13,-8.49,-8.88,-9.27,-9.64,-10,-10,-10,-10,-9.88,-9.50,-9.12,-8.80,-8.54,-8.37,-8.25,-8.25,-8.14,-8.12,-8.03,-7.76,-7.60,-7.41,-7.35,-7.38,-7.50,-7.73,-7.99,-8.17,-8.33,-8.41,-8.42,-8.36,-8.26,-8.16,-8.09,-7.96,-7.99,-8.08,-8.23,-8.38,-8.63,-8.87,-9.09,-9.27,-9.43,-9.60,-9.71,-9.78,-9.86,-9.89,-9.88,-9.90,-9.83,5.41,5.25,4.92,4.37,3.72,3.16,2.73,2.38,2.15,2.02,1.96,1.88,1.83,1.74,1.62,1.48,1.33,1.20,1.09,1,0.95,0.90,0.89,0.87,0.87,0.85,0.78,0.71,0.60,0.42,0.03,-0.53,-1.50,-3.20,-5.17,-6.29,-7.28,-8.15,-8.97,-9.60,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.95,-9.49,-9.27,-9.14,-9.26,-9.43,-9.59,-9.66,-9.73,-9.76,-9.88,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-9.90,-9.78,-9.68,-9.62,-9.53,-9.38,-9.13,-8.78,-8.40,-8.02,-7.80,-7.72,-7.74,-7.77,-8.09,-8.41,-8.70,-8.74,-8.87,-9.26,-10,-12,-14,-14,-12,-11,-10,-10,-9.83,-9.76,-10,-9.99,-9.78,-9.78,-9.63,-9.37,-9.01,-8.63,-8.34,-8.26,-8.87,-10,-11,-10,-8.53,-7.85,-7.51,-7.22,-6.83,-6.41,-6.01,-5.63,-5.54,-5.49,-5.36,-4.88,-4.02,-3.13,-2.63,-2.72,-2.76,-3.04,-3.34,-4.38,-6.12,-6.75,-6.37,-6.11,-6.22,-6.90,-7.83,-8.88,-9.91,-11,-12,-13,-14,-15,-16,-16,-17,-17,-17,-18,-18,-17,-17,-16,-15,-15,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.74,-9.30,-8.87,-8.38,-7.89,-7.40,-7.17,-7.17,-7.36,-7.64,-7.98,-8.30,-8.55,-8.87,-9.11,-9.27,-9.35,-9.30,-9.21,-9,-8.71,-8.37,-7.99,-7.75,-7.63,-7.68,-8.17,-8.93,-9.97,-10,-11,-11,-11,-10,-10,-9.41,-8.78,-8.24,-7.88,-7.76,-7.85,-8.05,-8.30,-8.66,-9,-9.30,-9.54,-9.67,-9.74,-9.62,-9.40,-9.15,-8.90,-8.68,-8.59,-8.52,-8.52,-8.62,-8.62,-8.64,-8.63,-8.43,-8.33,-8.15,-8.05,-8.03,-8.10,-8.23,-8.38,-8.49,-8.53,-8.54,-8.50,-8.40,-8.33,-8.25,-8.17,-8.09,-8.13,-8.24,-8.38,-8.58,-8.83,-9.04,-9.26,-9.43,-9.60,-9.73,-9.83,-9.89,-9.96,-9.98,-9.97,-9.90,-9.85,4.89,4.75,4.49,3.92,3.32,2.78,2.36,2.02,1.82,1.67,1.61,1.54,1.50,1.42,1.35,1.24,1.12,1.01,0.92,0.87,0.85,0.84,0.84,0.83,0.82,0.77,0.70,0.59,0.45,0.26,-0.58,-1.53,-2.93,-4.86,-6.73,-7.62,-8.46,-9.24,-9.98,-10,-11,-11,-12,-13,-13,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.97,-9.52,-9.03,-8.76,-8.59,-8.77,-9.07,-9.32,-9.43,-9.47,-9.42,-9.45,-9.58,-9.82,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-9.93,-9.62,-9.37,-9.17,-9.05,-9.02,-9.02,-8.98,-8.86,-8.61,-8.23,-7.80,-7.40,-7.20,-7.09,-7.07,-7.15,-7.34,-7.64,-7.95,-8.01,-8.10,-8.32,-8.97,-10,-11,-11,-10,-9.96,-9.47,-9.04,-8.63,-8.55,-9.02,-8.88,-8.84,-8.83,-8.86,-8.64,-8.30,-7.89,-7.51,-7.14,-7.30,-7.51,-7.24,-6.75,-6.13,-6,-5.83,-5.60,-5.38,-5.09,-4.84,-4.57,-4.39,-4.36,-4.22,-3.70,-2.76,-1.82,-1.28,-1.28,-1.21,-1.66,-2.14,-2.55,-4.40,-4.98,-5.26,-5.37,-5.53,-6,-6.75,-7.71,-8.82,-9.91,-11,-13,-14,-15,-16,-16,-17,-17,-18,-18,-18,-18,-18,-17,-16,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-9.54,-8.98,-8.37,-7.75,-7.09,-6.77,-6.74,-6.90,-7.18,-7.50,-7.78,-8,-8.27,-8.51,-8.67,-8.77,-8.79,-8.77,-8.66,-8.50,-8.27,-8.16,-8.15,-8.25,-8.49,-9.03,-9.72,-10,-11,-11,-11,-11,-10,-9.98,-9.35,-8.76,-8.29,-8,-7.88,-7.90,-8.05,-8.25,-8.51,-8.77,-9,-9.15,-9.25,-9.24,-9.15,-8.97,-8.83,-8.67,-8.53,-8.54,-8.62,-8.71,-8.80,-8.90,-8.99,-9.01,-8.90,-8.84,-8.72,-8.62,-8.58,-8.59,-8.63,-8.71,-8.75,-8.75,-8.72,-8.62,-8.52,-8.47,-8.40,-8.37,-8.28,-8.35,-8.43,-8.60,-8.77,-9,-9.24,-9.42,-9.60,-9.74,-9.86,-9.92,-10,-10,-10,-10,-9.96,-9.80,4.08,3.96,3.71,3.27,2.82,2.37,2,1.73,1.52,1.40,1.34,1.28,1.25,1.21,1.12,1.03,0.95,0.86,0.78,0.75,0.74,0.75,0.75,0.75,0.75,0.71,0.57,0.42,0.24,-0.27,-1.65,-3.02,-4.58,-6.24,-7.64,-8.61,-9.45,-10,-11,-11,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-9.92,-9.75,-9.49,-9.09,-8.65,-8.26,-8.04,-8.27,-8.67,-9.03,-9.16,-9.15,-8.98,-8.87,-8.83,-8.89,-9.09,-9.39,-9.70,-9.95,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-10,-9.72,-9.51,-9.21,-8.93,-8.70,-8.51,-8.37,-8.25,-8.29,-8.36,-8.40,-8.27,-8.08,-7.64,-7.13,-6.72,-6.43,-6.30,-6.18,-6.32,-6.24,-6.36,-6.64,-6.78,-6.88,-7.02,-7.15,-7.95,-8.84,-9.38,-9.24,-8.78,-8.33,-7.79,-7.33,-7.17,-7.13,-7.57,-7.77,-7.89,-7.95,-7.90,-7.71,-7.37,-6.85,-6.22,-5.54,-4.82,-3.85,-3.07,-3.79,-3.88,-3.80,-3.61,-3.54,-3.53,-3.46,-3.23,-3.04,-2.92,-2.72,-2.25,-1.51,-0.78,-0.40,-0.43,-0.61,-1.03,-1.58,-2.11,-2.49,-3.64,-4.22,-4.70,-5.14,-5.60,-6.10,-6.80,-7.79,-8.89,-10,-12,-13,-14,-15,-16,-17,-17,-17,-18,-18,-18,-18,-18,-17,-16,-15,-15,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.79,-9.12,-8.41,-7.72,-6.91,-6.52,-6.50,-6.66,-6.92,-7.22,-7.48,-7.62,-7.87,-8.10,-8.26,-8.38,-8.43,-8.48,-8.42,-8.30,-8.33,-8.40,-8.55,-8.78,-9.12,-9.66,-10,-10,-11,-11,-11,-10,-10,-9.88,-9.35,-8.87,-8.50,-8.25,-8.13,-8.12,-8.17,-8.28,-8.47,-8.64,-8.78,-8.86,-8.90,-8.86,-8.79,-8.64,-8.54,-8.50,-8.46,-8.54,-8.67,-8.83,-8.97,-9.10,-9.21,-9.26,-9.25,-9.22,-9.13,-9.05,-9.01,-9,-9,-9.01,-9.02,-9,-8.92,-8.83,-8.75,-8.68,-8.65,-8.63,-8.58,-8.61,-8.68,-8.83,-8.98,-9.17,-9.38,-9.58,-9.73,-9.86,-9.97,-10,-10,-10,-10,-10,-10,-9.88,3.20,3.11,2.89,2.62,2.28,1.96,1.65,1.42,1.27,1.17,1.12,1.10,1.07,1.01,0.97,0.88,0.79,0.72,0.65,0.62,0.62,0.64,0.66,0.66,0.62,0.55,0.38,0.15,-0.28,-1.34,-3.08,-4.67,-6.10,-7.29,-8.27,-9.27,-10,-11,-13,-13,-14,-14,-14,-13,-13,-13,-12,-12,-12,-14,-14,-15,-14,-14,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.76,-9.49,-9.20,-8.91,-8.74,-8.76,-8.90,-8.87,-8.57,-8.16,-7.70,-7.46,-7.67,-8.27,-8.77,-8.88,-8.77,-8.45,-8.18,-7.99,-7.80,-7.99,-8.24,-8.47,-8.66,-8.73,-8.70,-8.63,-8.51,-7.89,-8.38,-8.57,-9.10,-9.67,-10,-10,-9.74,-9.14,-8.60,-8.25,-8.10,-7.91,-7.76,-7.66,-7.60,-7.54,-7.51,-7.53,-7.55,-7.58,-7.41,-7.30,-6.80,-6.21,-5.72,-5.29,-5.10,-4.91,-4.87,-4.64,-4.65,-4.87,-5.12,-5.34,-5.51,-5.84,-6.39,-7.12,-7.78,-8.17,-7.85,-7.15,-6.54,-6.17,-6.08,-5.99,-6.47,-6.76,-6.98,-7.15,-7.29,-7.29,-7.07,-6.50,-5.53,-4.09,-2.33,-1.64,-1.62,-1.63,-1.89,-1.83,-1.68,-1.64,-1.80,-1.85,-1.73,-1.53,-1.49,-1.33,-1,-0.55,-0.20,0,-0.02,-0.10,-0.39,-0.91,-1.50,-1.98,-2.54,-3.28,-3.99,-4.71,-5.16,-5.64,-6.18,-7.02,-8.01,-9.41,-10,-11,-13,-14,-15,-16,-16,-17,-17,-18,-18,-18,-18,-17,-17,-16,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.33,-8.59,-7.83,-7.01,-6.62,-6.58,-6.68,-6.90,-7.15,-7.37,-7.47,-7.66,-7.88,-8.03,-8.17,-8.24,-8.30,-8.25,-8.38,-8.53,-8.74,-8.97,-9.25,-9.63,-10,-10,-11,-11,-11,-11,-10,-10,-9.87,-9.43,-9.09,-8.77,-8.59,-8.47,-8.41,-8.41,-8.43,-8.53,-8.63,-8.71,-8.67,-8.72,-8.63,-8.60,-8.49,-8.46,-8.38,-8.49,-8.63,-8.78,-8.97,-9.12,-9.25,-9.38,-9.46,-9.50,-9.50,-9.49,-9.46,-9.41,-9.39,-9.38,-9.36,-9.35,-9.29,-9.23,-9.13,-9.05,-9.01,-8.99,-8.96,-8.90,-8.90,-8.97,-9.03,-9.14,-9.34,-9.51,-9.68,-9.84,-9.97,-10,-10,-10,-10,-10,-10,-10,-9.92,2.37,2.32,2.21,2.01,1.77,1.53,1.34,1.15,1.04,0.99,0.96,0.92,0.91,0.88,0.85,0.76,0.67,0.60,0.53,0.50,0.51,0.54,0.59,0.53,0.48,0.39,0.10,-0.28,-1.04,-2.61,-4.66,-6.09,-7.29,-8.14,-8.98,-10,-11,-12,-13,-14,-14,-13,-13,-12,-12,-12,-12,-12,-13,-14,-16,-15,-15,-15,-15,-15,-15,-15,-14,-13,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.89,-9.55,-9.29,-8.77,-8.30,-7.87,-7.50,-7.14,-6.91,-7.02,-7.36,-7.93,-7.82,-7.36,-6.92,-6.65,-6.80,-7.53,-8.09,-8.24,-8.20,-7.75,-7.34,-7.04,-6.89,-6.95,-7.11,-7.29,-7.48,-7.36,-7.18,-7.08,-6.97,-6.93,-7.02,-7.24,-7.63,-7.93,-8.30,-8.27,-7.82,-7.24,-6.80,-6.55,-6.47,-6.41,-6.39,-6.47,-6.67,-6.72,-6.68,-6.55,-6.36,-6.25,-6.29,-6,-5.53,-4.96,-4.29,-3.77,-3.45,-3.25,-3.03,-2.82,-2.83,-3.10,-3.45,-3.75,-4.01,-4.45,-5,-5.65,-6.34,-7.18,-6.49,-5.63,-5.07,-4.90,-5.12,-5.48,-5.70,-5.85,-6.10,-6.47,-6.91,-7.17,-7.11,-6.54,-5.35,-3.57,-1.57,-0.38,-0.38,-0.33,-0.33,-0.28,-0.30,-0.23,-0.10,-0.15,-0.24,-0.27,-0.27,-0.21,-0.05,0.09,0.21,0.27,0.37,0.34,0.12,-0.26,-0.80,-1.26,-1.67,-2.37,-3.16,-4.03,-4.64,-5.10,-5.67,-6.42,-7.34,-8.61,-9.88,-11,-12,-13,-14,-15,-15,-16,-17,-17,-18,-18,-18,-18,-17,-16,-16,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-9.62,-8.88,-8.13,-7.38,-7.01,-6.90,-6.99,-7.15,-7.34,-7.49,-7.52,-7.72,-7.88,-8.03,-8.12,-8.25,-8.28,-8.48,-8.66,-8.88,-9.12,-9.38,-9.67,-10,-10,-10,-11,-11,-11,-10,-10,-10,-9.92,-9.63,-9.38,-9.14,-8.98,-8.86,-8.78,-8.74,-8.71,-8.73,-8.74,-8.74,-8.67,-8.65,-8.60,-8.52,-8.51,-8.48,-8.52,-8.63,-8.78,-8.96,-9.11,-9.27,-9.41,-9.54,-9.66,-9.75,-9.78,-9.80,-9.80,-9.79,-9.78,-9.75,-9.73,-9.71,-9.65,-9.59,-9.50,-9.43,-9.38,-9.35,-9.30,-9.25,-9.24,-9.24,-9.26,-9.30,-9.47,-9.63,-9.77,-9.91,-10,-10,-10,-10,-10,-10,-10,-10,-9.91,1.72,1.71,1.62,1.50,1.33,1.15,1,0.89,0.83,0.78,0.78,0.79,0.79,0.78,0.75,0.70,0.61,0.51,0.47,0.42,0.45,0.48,0.50,0.37,0.26,0.10,-0.37,-1.02,-2.16,-3.90,-5.83,-7.39,-8.23,-8.77,-9.87,-11,-12,-12,-12,-12,-12,-12,-11,-11,-12,-12,-12,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-13,-13,-12,-11,-11,-11,-10,-10,-10,-9.64,-9.20,-8.66,-8.21,-7.84,-7.77,-7.16,-6.39,-5.98,-5.65,-5.22,-4.59,-4.20,-5.41,-5.82,-5.95,-6.58,-5.83,-5.49,-5.59,-6.07,-6.55,-7.24,-6.95,-6.52,-6.14,-5.79,-5.74,-5.92,-5.98,-6.03,-5.88,-5.55,-5.28,-5.16,-5.46,-5.18,-5.15,-5.41,-5.09,-5.42,-5.48,-4.96,-4.72,-4.58,-4.66,-4.68,-4.71,-4.73,-4.83,-4.99,-5.18,-6.02,-5.83,-5.05,-4.89,-4.17,-4.32,-4.33,-3.92,-3.27,-2.61,-1.98,-1.70,-1.45,-1.32,-1.29,-1.39,-1.68,-2.04,-2.27,-2.67,-3.13,-3.65,-4.17,-4.65,-5.04,-4.51,-3.79,-3.33,-3.36,-3.82,-5.07,-4.99,-4.82,-5.17,-5.83,-6.65,-7.34,-7.51,-7.03,-5.67,-3.71,-1.37,-0.13,0.11,0.24,0.28,0.28,0.26,0.25,0.22,0.17,0.12,0.10,0.10,0.13,0.23,0.33,0.42,0.50,0.57,0.52,0.49,0.24,-0.15,-0.49,-0.82,-1.41,-2.24,-3.07,-3.80,-4.40,-5.07,-5.85,-6.78,-8,-9.25,-10,-11,-12,-13,-14,-14,-15,-16,-17,-17,-18,-18,-18,-17,-17,-16,-16,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.29,-8.62,-7.96,-7.62,-7.49,-7.52,-7.64,-7.76,-7.87,-7.90,-8.04,-8.18,-8.22,-8.36,-8.52,-8.71,-8.88,-9.10,-9.29,-9.53,-9.78,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-9.91,-9.74,-9.55,-9.40,-9.28,-9.21,-9.12,-9.03,-9,-8.93,-8.88,-8.79,-8.75,-8.68,-8.66,-8.66,-8.68,-8.76,-8.88,-9.01,-9.15,-9.30,-9.49,-9.63,-9.77,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.90,-9.84,-9.77,-9.73,-9.67,-9.63,-9.58,-9.52,-9.50,-9.49,-9.58,-9.71,-9.85,-9.98,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.88,1.25,1.22,1.13,1.03,0.90,0.78,0.67,0.62,0.60,0.61,0.63,0.66,0.71,0.72,0.70,0.63,0.57,0.49,0.41,0.39,0.39,0.36,0.30,0.11,-0.12,-0.43,-1.17,-2.09,-3.43,-5.07,-6.63,-7.79,-8.64,-9.33,-10,-11,-12,-12,-11,-11,-10,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-14,-13,-12,-12,-11,-10,-10,-9.91,-9.49,-8.99,-8.39,-7.70,-6.90,-6.20,-5.64,-5.49,-4.88,-4.04,-2.73,-2.26,-1.85,-0.74,-1.05,-1.11,-0.58,-2.39,-3.54,-3.67,-4.05,-3.68,-3.45,-4.32,-4.67,-4.68,-4.42,-4.12,-4.08,-4.13,-4.52,-4.95,-4.13,-3.90,-3.23,-2.42,-2.87,-2.83,-2.11,-2.89,-3.26,-3.26,-3.46,-3.18,-2.87,-2.54,-2.46,-2.79,-2.79,-2.79,-2.93,-3.01,-2.91,-3.38,-3.18,-2.98,-2.85,-2.09,-2.14,-2.22,-2.16,-1.90,-1.50,-0.86,-0.30,0.02,0.12,-0.05,-0.10,-0.25,-0.64,-0.96,-1.28,-1.62,-1.95,-2.33,-2.65,-2.73,-2.51,-2.29,-1.50,-1.40,-1.36,-2.03,-2.80,-3.18,-3.53,-4.08,-5.04,-6.29,-6.82,-7.18,-6.85,-5.86,-4.43,-2.78,-0.47,-0.08,0.17,0.28,0.35,0.37,0.38,0.38,0.37,0.36,0.34,0.34,0.37,0.45,0.51,0.61,0.66,0.73,0.73,0.64,0.50,0.37,0.22,-0.01,-0.55,-1.24,-2.03,-2.79,-3.54,-4.34,-5.21,-6.26,-7.49,-8.74,-9.74,-10,-11,-12,-12,-13,-14,-15,-16,-17,-17,-18,-18,-17,-17,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-9.87,-9.16,-8.67,-8.38,-8.25,-8.26,-8.35,-8.42,-8.42,-8.53,-8.63,-8.73,-8.84,-8.97,-9.11,-9.26,-9.42,-9.61,-9.78,-9.99,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.99,-9.86,-9.74,-9.63,-9.52,-9.41,-9.33,-9.23,-9.12,-9,-8.92,-8.91,-8.91,-8.97,-9,-9.08,-9.15,-9.26,-9.40,-9.58,-9.74,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.90,-9.83,-9.72,-9.66,-9.68,-9.77,-9.88,-9.97,-10,-10,-10,-10,-10,-9.99,-9.93,-9.88,-9.76,0.83,0.76,0.71,0.62,0.51,0.42,0.37,0.36,0.37,0.41,0.49,0.54,0.62,0.64,0.64,0.62,0.54,0.48,0.41,0.37,0.26,0.18,0.10,-0.32,-0.74,-1.33,-2.12,-3.45,-4.86,-6.28,-7.52,-8.43,-9.20,-9.88,-10,-11,-11,-11,-10,-9.90,-9.46,-9.21,-9.34,-9.85,-10,-12,-13,-13,-12,-12,-12,-13,-13,-14,-14,-15,-15,-14,-14,-13,-12,-11,-10,-10,-9.54,-9,-8.50,-7.89,-7.13,-6.18,-5.09,-3.99,-3.26,-2.40,-1.89,-1.30,-0.46,-0.25,-0.24,-0.24,-0.26,-0.34,-0.43,-0.59,-0.86,-1.65,-1.80,-1.01,-1.03,-1.05,-0.90,-1.74,-1.82,-1.24,-1.34,-1.97,-1.92,-1.86,-1.72,-1.01,-0.88,-0.74,-0.78,-0.88,-1.08,-1.30,-1.52,-1.65,-2.12,-2.21,-2.02,-1.74,-1.47,-1.14,-0.90,-1.12,-1.18,-1.12,-1.17,-1.35,-1.26,-1,-0.73,-0.71,-0.73,-0.76,-0.79,-0.75,-0.54,-0.12,0.37,0.70,0.78,0.60,0.58,0.41,0.12,-0.23,-0.51,-0.75,-0.91,-1.08,-1.21,-1.25,-1.13,-0.89,-0.63,-0.53,-0.55,-0.61,-0.65,-1.36,-1.99,-2.74,-3.72,-4.85,-5.96,-6.73,-6.85,-6.30,-5.37,-4,-2.49,-0.51,-0.11,0.10,0.23,0.32,0.37,0.41,0.42,0.42,0.42,0.47,0.50,0.58,0.64,0.73,0.77,0.83,0.83,0.78,0.73,0.64,0.60,0.57,0.34,-0.29,-0.95,-1.73,-2.57,-3.46,-4.51,-5.72,-7.01,-8.30,-9.22,-9.88,-10,-11,-12,-12,-13,-14,-15,-16,-17,-17,-17,-17,-17,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-9.97,-9.53,-9.28,-9.17,-9.16,-9.21,-9.24,-9.29,-9.37,-9.40,-9.50,-9.59,-9.67,-9.78,-9.90,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.83,-9.68,-9.55,-9.40,-9.23,-9.18,-9.24,-9.28,-9.34,-9.36,-9.38,-9.42,-9.53,-9.67,-9.86,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.79,-9.79,-9.91,-10,-10,-10,-10,-10,-9.96,-9.87,-9.80,-9.75,-9.65,0.37,0.34,0.27,0.22,0.14,0.10,0.08,0.11,0.16,0.25,0.35,0.45,0.51,0.59,0.61,0.59,0.48,0.35,0.26,0.18,0,-0.12,-0.28,-1.12,-1.84,-2.73,-3.67,-4.83,-6.29,-7.74,-8.70,-9.45,-9.80,-10,-10,-10,-10,-9.61,-9.01,-8.37,-7.86,-7.63,-7.79,-8.33,-9.37,-10,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-13,-13,-12,-11,-10,-9.92,-9.20,-8.58,-7.99,-7.47,-6.80,-5.95,-4.82,-3.36,-2.07,-0.83,-0.36,-0.09,-0.09,-0.09,-0.09,-0.09,-0.11,-0.15,-0.26,-0.39,-0.50,-0.58,-0.46,-0.38,-0.27,-0.22,-0.15,-0.13,-0.13,-0.17,-0.24,-0.27,-0.29,-0.27,-0.22,-0.14,-0.09,-0.04,-0.03,-0.05,-0.13,-0.27,-0.48,-0.64,-0.74,-0.73,-0.80,-0.76,-0.53,-0.22,0.07,0.08,0.07,0.02,-0.03,-0.12,-0.12,-0.03,0.04,0.11,0.12,0.12,0.12,0.12,0.14,0.23,0.41,0.65,0.83,0.89,0.88,0.87,0.77,0.60,0.38,0.17,0,-0.15,-0.29,-0.41,-0.47,-0.37,-0.15,0.08,0.23,0.24,0.11,-0.05,-0.15,-0.16,-0.89,-2.11,-3.45,-4.87,-6.03,-6.74,-6.78,-6.30,-5.47,-4.04,-1.88,-0.51,-0.25,-0.03,0.12,0.25,0.33,0.36,0.38,0.41,0.48,0.54,0.62,0.72,0.77,0.84,0.87,0.87,0.87,0.85,0.83,0.78,0.71,0.62,0.26,-0.27,-0.88,-1.64,-2.61,-3.80,-5.17,-6.60,-7.92,-8.78,-9.39,-9.80,-10,-11,-12,-12,-13,-14,-15,-16,-17,-17,-17,-17,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.76,-9.52,-9.46,-9.62,-9.72,-9.75,-9.71,-9.65,-9.67,-9.77,-9.96,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.91,-9.83,-9.91,-9.98,-10,-10,-9.98,-9.93,-9.88,-9.75,-9.63,-9.54,-9.48,-0.10,-0.11,-0.12,-0.12,-0.14,-0.15,-0.14,-0.10,-0.03,0.12,0.20,0.26,0.33,0.38,0.42,0.32,0.14,0.04,-0.08,-0.18,-0.58,-0.87,-1.33,-2.49,-3.47,-4.34,-5.18,-6.07,-7,-8,-8.84,-9.45,-9.83,-9.99,-9.86,-9.45,-8.91,-8.32,-7.58,-6.86,-6.30,-6.02,-6.12,-6.52,-7.43,-8.70,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-11,-11,-11,-10,-9.64,-8.86,-8.10,-7.46,-6.83,-6.35,-5.53,-4.70,-3.50,-1.87,-0.30,-0.09,0.02,0.09,0.10,0.11,0.11,0.11,0.09,0.02,-0.05,-0.15,-0.25,-0.28,-0.18,-0.10,0.01,0.12,0.22,0.28,0.34,0.34,0.29,0.25,0.24,0.25,0.32,0.39,0.48,0.53,0.59,0.60,0.54,0.45,0.32,0.20,0.13,0.15,0.24,0.37,0.52,0.63,0.70,0.72,0.73,0.74,0.74,0.71,0.66,0.66,0.66,0.67,0.67,0.67,0.70,0.71,0.71,0.74,0.79,0.87,0.95,1,1.07,1.09,1.08,1,0.88,0.75,0.62,0.50,0.38,0.29,0.27,0.36,0.50,0.63,0.71,0.63,0.45,0.22,0.07,-0.01,-0.10,-0.41,-2.35,-3.96,-5.62,-6.85,-7.21,-6.85,-6.23,-5.34,-3.89,-0.98,-0.63,-0.35,-0.12,0.04,0.14,0.23,0.26,0.34,0.40,0.51,0.62,0.72,0.78,0.84,0.87,0.87,0.87,0.88,0.87,0.87,0.83,0.72,0.59,0.32,-0.03,-0.73,-1.63,-3.01,-4.64,-6.22,-7.52,-8.38,-9.01,-9.46,-10,-11,-11,-12,-13,-13,-14,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-10,-10,-10,-10,-9.88,-9.80,-9.99,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.87,-9.93,-9.99,-9.98,-9.91,-9.83,-9.71,-9.60,-9.41,-9.35,-9.25,-0.52,-0.46,-0.48,-0.53,-0.59,-0.60,-0.54,-0.52,-0.63,-0.36,-0.16,-0.10,-0.23,-0.17,-0.12,-0.35,-0.43,-0.57,-0.73,-0.98,-1.71,-2.26,-3.15,-4.30,-5.24,-6.02,-6.58,-6.97,-7.46,-7.98,-8.53,-9.21,-9.57,-9.49,-8.87,-8.33,-7.82,-7.12,-6.29,-5.46,-4.79,-4.42,-4.40,-4.57,-5.24,-6.23,-7.50,-8.93,-9.80,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.85,-9.59,-9.13,-8.40,-7.58,-6.76,-6.09,-5.41,-4.87,-3.88,-2.86,-1.61,-0.25,0,0.14,0.25,0.28,0.32,0.34,0.35,0.35,0.35,0.32,0.26,0.22,0.17,0.15,0.23,0.33,0.41,0.52,0.62,0.71,0.75,0.76,0.75,0.73,0.72,0.74,0.79,0.87,0.98,1.04,1.12,1.13,1.12,1.07,0.97,0.89,0.89,0.97,1.08,1.20,1.27,1.28,1.27,1.24,1.24,1.28,1.37,1.37,1.28,1.13,1.01,0.97,0.96,0.95,0.95,0.95,0.96,0.98,1.01,1.08,1.13,1.14,1.25,1.36,1.40,1.39,1.35,1.25,1.12,1,0.91,0.87,0.88,0.95,1.01,1.07,1.02,0.89,0.66,0.41,0.24,0.12,-0.05,-0.43,-2.02,-3.67,-5.50,-6.58,-6.92,-6.65,-6.23,-5.65,-4.62,-2.99,-0.93,-0.62,-0.35,-0.14,-0.01,0.08,0.13,0.23,0.33,0.46,0.58,0.67,0.75,0.77,0.79,0.83,0.85,0.87,0.87,0.87,0.85,0.79,0.72,0.62,0.46,0.05,-1.18,-2.59,-4.22,-5.79,-7.10,-8.02,-8.70,-9.29,-10,-10,-11,-12,-12,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.96,-9.97,-9.93,-9.88,-9.76,-9.63,-9.43,-9.24,-9.08,-8.99,-1.21,-1.91,-2.45,-2.16,-1.30,-1,-1.80,-2.38,-2.21,-1.64,-1.17,-1.38,-1.30,-1.24,-1.12,-1.46,-1.61,-1.84,-2.15,-2.66,-3.40,-4.20,-5.27,-6.47,-7.03,-7.48,-7.64,-7.65,-7.72,-7.93,-8.25,-8.48,-8.49,-8.21,-7.77,-7.25,-6.74,-6.04,-5.02,-4,-3.26,-2.85,-2.76,-2.71,-3.16,-3.90,-4.68,-5.95,-6.88,-7.84,-7.91,-7.85,-7.97,-8.12,-8.14,-8.07,-7.97,-8.07,-8.10,-7.98,-7.75,-7,-6.02,-5.09,-4.41,-3.75,-3.08,-1.66,-0.52,-0.18,0.11,0.29,0.41,0.50,0.52,0.57,0.60,0.62,0.64,0.65,0.66,0.65,0.64,0.64,0.65,0.73,0.79,0.88,0.99,1.08,1.12,1.15,1.16,1.15,1.14,1.14,1.17,1.25,1.33,1.41,1.50,1.60,1.64,1.66,1.63,1.58,1.52,1.57,1.67,1.84,1.98,2.01,1.95,1.85,1.74,1.73,1.83,1.96,1.96,1.77,1.50,1.26,1.12,1.08,1.02,1.01,1.01,1.03,1.10,1.20,1.33,1.46,1.49,1.63,1.77,1.85,1.85,1.78,1.67,1.52,1.39,1.32,1.28,1.32,1.36,1.37,1.35,1.24,1.03,0.78,0.53,0.36,0.20,-0.10,-0.88,-2.38,-4.01,-5.54,-6.53,-6.77,-6.51,-6.32,-6.12,-5.66,-4.41,-1.98,-0.75,-0.48,-0.26,-0.13,-0.03,0.03,0.13,0.25,0.38,0.51,0.62,0.65,0.67,0.70,0.72,0.75,0.78,0.82,0.82,0.78,0.76,0.75,0.71,0.67,0.27,-0.72,-2.10,-3.87,-5.53,-6.85,-7.76,-8.48,-9.22,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-14,-14,-14,-13,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.99,-9.98,-9.92,-9.80,-9.65,-9.43,-9.21,-8.87,-8.73,-3.85,-4.97,-5.35,-5.45,-4.78,-4.50,-4.33,-4.72,-4.38,-3.80,-3.12,-3.02,-2.89,-2.82,-2.77,-3,-3.24,-3.59,-4.10,-4.72,-5.41,-6.23,-7.22,-8.18,-8.67,-8.55,-8.30,-8.11,-8.20,-8.14,-8.08,-7.96,-7.75,-7.36,-6.75,-6.07,-5.39,-4.76,-3.42,-2.32,-1.66,-1.37,-1.20,-1.30,-1.59,-1.80,-2.46,-3.30,-4.02,-4.34,-4.58,-4.77,-5.55,-6.13,-6.25,-6,-5.92,-6.11,-6.35,-6.38,-5.89,-5.13,-4.18,-2.88,-2.36,-2.05,-0.93,-0.50,-0.10,0.17,0.41,0.58,0.66,0.74,0.77,0.84,0.87,0.92,0.99,1.02,1.08,1.11,1.12,1.14,1.17,1.25,1.33,1.40,1.49,1.54,1.59,1.60,1.58,1.57,1.54,1.58,1.61,1.66,1.75,1.84,1.92,2.03,2.14,2.23,2.24,2.21,2.17,2.24,2.37,2.57,2.72,2.75,2.58,2.41,2.28,2.26,2.37,2.51,2.48,2.24,1.90,1.62,1.39,1.25,1.13,1.10,1.11,1.15,1.26,1.47,1.72,1.95,2.12,2.24,2.28,2.32,2.29,2.22,2.07,1.87,1.70,1.58,1.53,1.54,1.58,1.54,1.48,1.29,1.07,0.79,0.57,0.37,0.16,-0.12,-1.28,-2.78,-4.39,-5.64,-6.16,-6.36,-6.37,-6.32,-6.34,-6.38,-4.92,-2.75,-0.75,-0.48,-0.27,-0.14,-0.05,0,0.11,0.23,0.36,0.48,0.53,0.54,0.53,0.52,0.57,0.62,0.66,0.71,0.67,0.63,0.62,0.61,0.62,0.62,0.24,-0.73,-2.08,-3.80,-5.35,-6.61,-7.59,-8.43,-9.23,-10,-11,-11,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-16,-16,-15,-15,-15,-15,-15,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.93,-9.80,-9.67,-9.48,-9.21,-8.90,-8.63,-5.90,-7.48,-7.90,-8.13,-8.03,-7.71,-7.53,-7.28,-6.83,-5.97,-5.30,-4.83,-4.58,-4.46,-4.49,-4.61,-4.90,-5.36,-5.96,-6.72,-7.43,-8.03,-8.76,-9.41,-9.67,-9.57,-9.22,-8.92,-8.72,-8.39,-8.01,-7.62,-7.16,-6.57,-5.76,-4.70,-3.66,-2.92,-1.13,-0.11,0.07,0.08,-0.11,-0.30,-0.54,-0.82,-1.13,-1.51,-1.28,-1.23,-1.17,-1.87,-3.42,-4.90,-4.84,-4.05,-3.73,-4.24,-4.58,-4.55,-3.51,-2.58,-2.41,-1.41,-1.14,-0.79,-0.41,-0.04,0.27,0.49,0.66,0.78,0.87,0.96,1.02,1.11,1.20,1.27,1.37,1.46,1.51,1.59,1.62,1.66,1.73,1.78,1.87,1.96,2.02,2.08,2.08,2.04,2,1.98,1.97,1.98,2,2.04,2.11,2.15,2.24,2.35,2.50,2.64,2.75,2.78,2.82,2.87,3,3.16,3.29,3.35,3.12,2.96,2.83,2.82,2.92,3.03,2.98,2.75,2.45,2.14,1.86,1.57,1.36,1.27,1.32,1.39,1.57,1.83,2.13,2.51,2.87,2.95,2.77,2.73,2.64,2.57,2.36,2.11,1.87,1.71,1.62,1.60,1.59,1.53,1.41,1.23,0.97,0.71,0.49,0.29,0.10,-0.24,-1.55,-3.03,-4.46,-5.40,-5.87,-6.03,-6.04,-6.05,-6.22,-5.77,-4.12,-1.72,-0.60,-0.35,-0.17,-0.09,-0.02,0.02,0.12,0.23,0.35,0.42,0.46,0.42,0.38,0.37,0.40,0.49,0.54,0.57,0.50,0.40,0.33,0.28,0.28,0.30,-0.08,-0.71,-2.41,-4.04,-5.48,-6.63,-7.58,-8.51,-9.47,-10,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.92,-9.76,-9.62,-9.42,-9.17,-8.88,-8.58,-7.66,-9.23,-10,-11,-11,-10,-10,-9.51,-8.77,-7.90,-7.07,-6.39,-6.03,-5.86,-5.93,-6,-6.35,-6.83,-7.47,-8.22,-8.99,-9.68,-10,-10,-11,-10,-10,-10,-9.33,-8.64,-7.96,-7.28,-6.53,-5.64,-4.49,-3.13,-1.92,-0.29,-0.10,0.09,0.17,0.22,0.15,0.03,-0.14,-0.36,-0.51,-0.63,-0.67,-0.71,-0.71,-0.71,-1.42,-2.11,-2.07,-1.47,-1.73,-1.95,-2.13,-2.15,-1.36,-1.27,-1.10,-0.87,-0.59,-0.26,0.04,0.35,0.59,0.74,0.87,0.99,1.09,1.17,1.28,1.41,1.54,1.67,1.82,1.91,2,2.08,2.13,2.20,2.25,2.33,2.40,2.50,2.57,2.60,2.58,2.51,2.46,2.38,2.36,2.34,2.34,2.34,2.33,2.29,2.32,2.39,2.58,2.78,3.02,3.17,3.25,3.32,3.39,3.53,3.64,3.67,3.45,3.32,3.21,3.20,3.27,3.37,3.33,3.20,2.99,2.71,2.34,1.95,1.67,1.59,1.63,1.72,1.87,2.13,2.50,2.88,3.24,3.35,3.03,2.85,2.74,2.64,2.48,2.17,1.88,1.65,1.52,1.47,1.41,1.36,1.22,1,0.76,0.53,0.37,0.20,-0.01,-0.57,-1.74,-3.25,-4.68,-5.45,-5.71,-5.72,-5.62,-5.57,-5.24,-4.78,-3.14,-0.71,-0.37,-0.14,-0.01,0.03,0.07,0.09,0.14,0.25,0.34,0.37,0.37,0.29,0.25,0.24,0.28,0.37,0.42,0.36,0.11,-0.05,-0.22,-0.24,-0.24,-0.21,-0.76,-1.52,-2.95,-4.57,-5.93,-6.87,-7.52,-8.47,-9.93,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-17,-17,-17,-16,-16,-15,-15,-15,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-9.78,-9.58,-9.33,-9.10,-8.77,-8.43,-9,-10,-12,-13,-14,-13,-12,-11,-10,-9.27,-8.33,-7.52,-7.02,-6.77,-6.77,-6.97,-7.33,-7.85,-8.52,-9.35,-10,-11,-11,-12,-12,-12,-12,-10,-9.86,-8.85,-7.88,-6.92,-5.84,-4.59,-3.21,-1.62,-0.67,-0.10,0.07,0.16,0.25,0.28,0.28,0.23,0.12,0.02,-0.03,-0.04,-0.11,-0.15,-0.21,-0.25,-0.26,-0.29,-0.38,-0.53,-0.71,-0.78,-0.78,-0.75,-0.71,-0.61,-0.46,-0.25,-0.02,0.23,0.47,0.66,0.84,0.97,1.09,1.20,1.32,1.46,1.61,1.77,1.98,2.14,2.29,2.41,2.51,2.58,2.62,2.67,2.75,2.83,2.92,3.01,3.08,3.08,3,2.91,2.83,2.72,2.63,2.58,2.50,2.42,2.33,2.22,2.14,2.17,2.35,2.61,2.88,3.13,3.27,3.35,3.41,3.52,3.62,3.65,3.50,3.37,3.27,3.24,3.26,3.35,3.38,3.38,3.28,3.03,2.65,2.25,2.03,1.97,1.98,1.98,2.08,2.28,2.60,2.92,3.13,3.13,2.87,2.67,2.52,2.42,2.25,1.98,1.67,1.45,1.27,1.20,1.12,1.03,0.90,0.74,0.53,0.38,0.24,0.09,-0.13,-0.72,-1.96,-3.50,-4.88,-5.46,-5.50,-5.28,-5.03,-4.80,-4.29,-3.57,-2.12,-0.43,-0.13,0.07,0.14,0.15,0.14,0.13,0.17,0.25,0.29,0.29,0.25,0.14,0.07,0.07,0.10,0.10,0.07,-0.22,-0.47,-0.76,-1.01,-1.09,-1.08,-1.13,-1.85,-2.74,-4.07,-5.37,-6.49,-7.32,-8,-9.05,-10,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-17,-16,-16,-16,-15,-15,-15,-15,-16,-16,-16,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-12,-12,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.83,-9.61,-9.34,-9.01,-8.66,-8.28,-9.50,-11,-14,-16,-16,-15,-14,-12,-11,-10,-9.13,-8.27,-7.67,-7.34,-7.26,-7.46,-7.87,-8.47,-9.25,-10,-11,-12,-14,-14,-14,-14,-13,-11,-10,-8.98,-7.78,-6.57,-5.12,-3.60,-2.02,-0.63,-0.14,0.09,0.16,0.24,0.32,0.37,0.40,0.40,0.39,0.37,0.38,0.45,0.39,0.34,0.26,0.21,0.14,0.01,-0.16,-0.40,-0.53,-0.39,-0.26,-0.13,0,0.11,0.22,0.36,0.50,0.66,0.84,0.98,1.10,1.23,1.35,1.49,1.64,1.83,2.01,2.25,2.47,2.64,2.83,2.96,3.01,3.04,3.07,3.11,3.17,3.24,3.34,3.40,3.46,3.41,3.35,3.21,3.03,2.88,2.75,2.61,2.47,2.32,2.12,1.92,1.78,1.77,1.90,2.17,2.48,2.73,2.85,2.90,2.99,3.08,3.16,3.23,3.13,3.01,2.92,2.87,2.85,2.89,3,3.09,3.07,2.87,2.59,2.29,2.16,2.13,2.11,2.01,2.01,2.13,2.36,2.53,2.74,2.73,2.54,2.26,2.10,1.97,1.78,1.58,1.33,1.11,0.95,0.85,0.76,0.71,0.60,0.47,0.33,0.25,0.13,0,-0.18,-0.77,-1.98,-3.50,-4.78,-5.22,-5.08,-4.66,-4.25,-3.85,-3.22,-2.43,-1.37,-0.23,0.07,0.23,0.26,0.25,0.21,0.16,0.16,0.21,0.23,0.15,0.04,-0.25,-0.39,-0.42,-0.59,-0.54,-0.55,-1.08,-1.46,-1.86,-2.15,-2.27,-2.32,-2.51,-3.32,-4.26,-5.38,-6.42,-7.34,-8.05,-8.90,-9.93,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-16,-16,-17,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-16,-16,-15,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.92,-9.61,-9.34,-8.99,-8.64,-8.23,-9.25,-12,-15,-17,-17,-17,-15,-14,-12,-10,-9.70,-8.70,-8.03,-7.64,-7.51,-7.70,-8.14,-8.84,-9.67,-10,-12,-13,-15,-16,-15,-14,-13,-11,-10,-9.02,-7.65,-6.21,-4.42,-2.64,-1.18,-0.18,0.03,0.14,0.24,0.32,0.40,0.50,0.57,0.61,0.62,0.62,0.66,0.73,0.71,0.65,0.60,0.59,0.47,0.33,0.12,-0.11,-0.13,0.08,0.28,0.51,0.67,0.77,0.87,0.95,1.01,1.12,1.22,1.32,1.40,1.52,1.73,1.89,2.09,2.32,2.54,2.77,2.99,3.17,3.34,3.41,3.45,3.42,3.40,3.40,3.47,3.50,3.57,3.61,3.61,3.53,3.40,3.24,3.03,2.84,2.63,2.45,2.24,2.01,1.77,1.54,1.37,1.33,1.41,1.63,1.87,2.07,2.14,2.20,2.25,2.33,2.39,2.45,2.39,2.35,2.25,2.15,2.12,2.15,2.26,2.36,2.37,2.25,2.09,1.95,1.89,1.88,1.83,1.71,1.63,1.67,1.77,1.87,2.04,2.07,1.92,1.70,1.54,1.41,1.26,1.10,0.90,0.74,0.61,0.50,0.46,0.39,0.34,0.25,0.20,0.13,0.08,-0.02,-0.18,-0.65,-1.68,-3,-4.14,-4.50,-4.28,-3.79,-3.32,-2.82,-2.21,-1.46,-0.74,-0.04,0.20,0.32,0.35,0.28,0.23,0.16,0.13,0.13,0.12,-0.01,-0.36,-1.11,-1.54,-1.73,-1.85,-1.83,-1.85,-2.48,-2.92,-3.30,-3.55,-3.72,-3.87,-4.23,-4.98,-6,-6.93,-7.79,-8.51,-9.29,-10,-10,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-16,-17,-17,-18,-18,-19,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-16,-16,-15,-14,-14,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-9.85,-9.48,-9.05,-8.63,-8.17,-8,-10,-14,-16,-17,-17,-16,-14,-12,-11,-9.98,-8.91,-8.16,-7.72,-7.55,-7.74,-8.37,-9.10,-9.89,-10,-11,-13,-14,-15,-15,-14,-13,-11,-10,-8.99,-7.43,-5.78,-3.72,-1.83,-0.64,-0.07,0.10,0.23,0.33,0.42,0.53,0.64,0.72,0.75,0.77,0.79,0.83,0.87,0.85,0.83,0.78,0.77,0.72,0.62,0.49,0.40,0.46,0.61,0.87,1.12,1.33,1.42,1.50,1.52,1.57,1.60,1.65,1.74,1.86,2,2.23,2.45,2.66,2.90,3.12,3.35,3.52,3.65,3.75,3.77,3.75,3.67,3.61,3.58,3.57,3.61,3.57,3.54,3.50,3.38,3.23,3.02,2.83,2.60,2.37,2.13,1.90,1.65,1.40,1.16,0.99,0.89,0.95,1.09,1.24,1.34,1.37,1.37,1.40,1.47,1.50,1.53,1.53,1.51,1.45,1.36,1.29,1.32,1.36,1.39,1.40,1.37,1.29,1.25,1.24,1.22,1.17,1.12,1.07,1.03,1.03,1.03,1.12,1.12,1.12,1.04,0.98,0.88,0.77,0.65,0.52,0.40,0.33,0.25,0.22,0.17,0.14,0.11,0.10,0.08,0.03,-0.02,-0.13,-0.39,-1.10,-2.04,-2.99,-3.32,-3.15,-2.74,-2.30,-1.79,-1.30,-0.67,-0.26,0.11,0.26,0.36,0.36,0.29,0.23,0.14,0.11,0.08,0,-0.40,-1.22,-2.40,-3.36,-3.78,-3.74,-3.75,-3.85,-4.24,-4.60,-4.91,-5.07,-5.24,-5.54,-6.07,-6.90,-7.86,-8.75,-9.43,-10,-11,-12,-12,-12,-13,-13,-12,-12,-12,-12,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-14,-14,-14,-14,-14,-15,-15,-16,-17,-18,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-16,-16,-15,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-10,-10,-10,-9.77,-9.30,-8.77,-8.27,-5.38,-8.64,-11,-15,-16,-16,-15,-14,-12,-11,-9.95,-8.91,-8.22,-7.71,-7.57,-7.85,-8.66,-9.41,-9.92,-10,-11,-12,-13,-13,-13,-13,-12,-11,-10,-8.71,-6.87,-4.92,-2.82,-1.13,-0.34,0.04,0.20,0.29,0.42,0.57,0.66,0.76,0.84,0.87,0.87,0.88,0.89,0.92,0.91,0.90,0.90,0.90,0.89,0.87,0.85,0.87,0.98,1.14,1.42,1.75,1.97,2.09,2.12,2.13,2.12,2.13,2.17,2.26,2.40,2.60,2.84,3.08,3.32,3.53,3.74,3.88,4,4.07,4.04,4,3.89,3.77,3.66,3.59,3.52,3.49,3.40,3.34,3.23,3.08,2.88,2.70,2.48,2.25,2.01,1.78,1.57,1.33,1.10,0.87,0.67,0.58,0.57,0.62,0.67,0.73,0.72,0.71,0.72,0.73,0.75,0.75,0.75,0.79,0.75,0.67,0.63,0.62,0.62,0.63,0.63,0.62,0.61,0.59,0.59,0.57,0.53,0.51,0.49,0.47,0.41,0.37,0.35,0.34,0.36,0.38,0.47,0.45,0.38,0.33,0.25,0.17,0.13,0.10,0.08,0.07,0.03,0.02,0.03,0.02,0.02,0,-0.04,-0.15,-0.51,-1.10,-1.67,-1.96,-1.91,-1.66,-1.33,-0.90,-0.57,-0.17,0.05,0.23,0.32,0.36,0.35,0.27,0.21,0.13,0.09,0.02,-0.08,-0.84,-2.20,-3.88,-5.37,-6.09,-5.74,-5.68,-5.91,-6.07,-6.28,-6.47,-6.55,-6.75,-7.13,-7.80,-8.73,-9.83,-10,-11,-12,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-17,-16,-15,-14,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.63,-9.13,-8.53,-1.75,-4.70,-8.63,-11,-13,-13,-13,-12,-12,-10,-9.45,-8.63,-8.01,-7.34,-7.01,-7.58,-8.87,-9.48,-9.75,-9.98,-10,-11,-12,-11,-12,-12,-12,-11,-9.84,-7.91,-5.97,-3.63,-1.74,-0.58,-0.09,0.12,0.26,0.39,0.53,0.66,0.77,0.86,0.89,0.91,0.92,0.95,0.95,0.96,0.97,0.97,0.99,1.01,1.03,1.12,1.23,1.34,1.50,1.76,2.12,2.45,2.66,2.77,2.76,2.74,2.72,2.72,2.76,2.87,3.03,3.25,3.50,3.74,3.97,4.14,4.27,4.35,4.37,4.33,4.24,4.09,3.92,3.76,3.62,3.48,3.37,3.25,3.13,3,2.86,2.67,2.50,2.29,2.10,1.88,1.67,1.48,1.26,1.07,0.85,0.64,0.48,0.36,0.28,0.27,0.28,0.28,0.27,0.26,0.26,0.26,0.26,0.26,0.25,0.25,0.28,0.25,0.23,0.21,0.20,0.17,0.16,0.16,0.16,0.15,0.15,0.14,0.14,0.13,0.12,0.12,0.09,0.03,0.01,0,0,0.02,0.07,0.15,0.14,0.12,0.10,0.07,0.03,0.01,0.01,0,0,0,0,0.01,0.01,0.02,0.03,0,-0.12,-0.37,-0.64,-0.83,-0.84,-0.71,-0.48,-0.26,-0.01,0.15,0.25,0.29,0.34,0.34,0.29,0.25,0.20,0.13,0.10,0.02,-0.13,-1.26,-2.97,-4.85,-6.60,-7.49,-7.21,-7.35,-7.72,-7.73,-7.85,-7.92,-7.99,-8.15,-8.57,-9.36,-10,-11,-12,-13,-14,-15,-15,-15,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-16,-15,-14,-13,-12,-11,-11,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-9.89,-9.40,-8.79,-0.61,-2.03,-4.41,-8.02,-9.99,-10,-10,-12,-11,-10,-8.47,-7.27,-6.49,-5.85,-5.53,-6.39,-7.76,-8.59,-8.40,-8.71,-9.33,-10,-11,-11,-11,-11,-11,-11,-9.15,-6.88,-3.88,-1.37,-0.65,-0.25,0.01,0.21,0.37,0.51,0.64,0.76,0.86,0.90,0.95,0.96,0.97,0.97,0.98,0.98,0.99,1.01,1.04,1.10,1.22,1.33,1.63,1.89,2.20,2.53,2.87,3.23,3.40,3.42,3.37,3.32,3.27,3.28,3.37,3.50,3.67,3.89,4.14,4.37,4.50,4.63,4.70,4.66,4.59,4.45,4.26,4.07,3.86,3.65,3.48,3.29,3.13,2.99,2.83,2.65,2.49,2.32,2.12,1.92,1.75,1.58,1.39,1.23,1.07,0.87,0.70,0.51,0.36,0.23,0.14,0.11,0.10,0.09,0.08,0.08,0.07,0.07,0.07,0.04,0.04,0.03,0.08,0.07,0.04,0.04,0.04,0.03,0.02,0.02,0.02,0.02,0.02,0.01,0.01,0.01,0.01,0,0,0,0,0,0,0,0,0.01,0.03,0.02,0.01,0,0,0,0,0,0,0,0,0,0.02,0.07,0.10,0.13,0.15,0.14,0.12,0.10,0.08,0.07,0.09,0.14,0.23,0.27,0.32,0.33,0.32,0.28,0.25,0.21,0.16,0.13,0.12,0.08,-0.17,-1.47,-3.24,-5.14,-6.75,-7.71,-7.92,-8.30,-8.84,-9.21,-9.20,-9.34,-9.41,-9.45,-9.83,-10,-11,-13,-14,-15,-16,-15,-15,-15,-14,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-18,-17,-16,-15,-14,-13,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-9.61,-9.04,-0.08,-1.18,-2.50,-4.77,-6.59,-9.04,-10,-11,-10,-9.03,-6,-4.15,-3.75,-2.82,-2.36,-3.18,-3.99,-5.18,-5.67,-6.10,-7.40,-8.42,-8.89,-8.62,-8.75,-9.10,-8.52,-7.59,-5.72,-3.21,-1.62,-0.91,-0.42,-0.10,0.13,0.34,0.50,0.63,0.75,0.86,0.91,0.96,0.98,0.99,0.99,1,1,1.01,1.02,1.03,1.12,1.25,1.37,1.90,2.32,2.75,3.08,3.37,3.65,3.91,4.04,3.95,3.87,3.79,3.77,3.83,3.91,4.07,4.25,4.47,4.66,4.87,4.92,4.96,4.92,4.83,4.64,4.45,4.21,3.97,3.72,3.50,3.27,3.09,2.89,2.71,2.51,2.34,2.15,1.98,1.79,1.62,1.48,1.34,1.20,1.07,0.92,0.77,0.62,0.45,0.28,0.16,0.09,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.03,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.08,0.12,0.20,0.25,0.26,0.26,0.25,0.24,0.23,0.23,0.24,0.26,0.28,0.29,0.28,0.26,0.24,0.20,0.16,0.14,0.14,0.14,0.13,-0.29,-1.63,-3.30,-5.07,-6.48,-7.46,-8.12,-8.78,-9.33,-9.93,-10,-10,-11,-11,-11,-12,-13,-14,-15,-16,-16,-16,-15,-15,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-16,-15,-14,-13,-11,-10,-10,-10,-9.97,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-9.76,-9.23,-0.12,-0.15,-1.36,-2.53,-4.60,-7.02,-8.79,-8.45,-6.84,-4.95,-2.50,-1.21,-0.91,-0.89,-0.91,-1.16,-1.28,-1.50,-2.52,-2.78,-3.18,-4.24,-4.07,-4.52,-4.62,-4.43,-4.73,-3.49,-2.15,-1.54,-1,-0.53,-0.18,0.08,0.29,0.49,0.64,0.76,0.87,0.95,0.99,1,1.02,1.03,1.04,1.07,1.07,1.08,1.12,1.08,1.02,1.91,2.25,2.84,3.45,3.79,3.97,4.11,4.25,4.37,4.40,4.34,4.24,4.20,4.21,4.26,4.38,4.53,4.72,4.87,5.03,5.14,5.21,5.10,5,4.83,4.60,4.34,4.07,3.78,3.52,3.28,3.07,2.86,2.65,2.46,2.25,2.04,1.88,1.72,1.54,1.40,1.27,1.16,1.08,0.97,0.86,0.73,0.59,0.42,0.28,0.15,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.08,0.09,0.08,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.21,0.21,0.10,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.08,0.13,0.21,0.25,0.28,0.29,0.29,0.28,0.27,0.25,0.25,0.25,0.25,0.25,0.24,0.23,0.20,0.15,0.14,0.13,0.14,0.16,0.17,-0.47,-1.71,-3.36,-4.95,-6.29,-7.33,-8.12,-9,-9.97,-10,-12,-13,-14,-14,-13,-13,-13,-14,-15,-15,-15,-15,-15,-14,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-13,-14,-15,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-17,-16,-15,-13,-12,-11,-10,-10,-9.90,-9.74,-9.58,-9.64,-9.76,-9.83,-9.88,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.88,-9.33,-0.13,-0.18,-0.13,-0.98,-2.52,-4.13,-4.99,-4.55,-2.63,-1.30,-0.84,-0.53,-0.38,-0.29,-0.28,-0.36,-0.52,-0.65,-0.79,-1.04,-1.23,-1.43,-1.66,-1.87,-1.92,-1.86,-1.67,-1.41,-1.11,-0.76,-0.50,-0.22,0.07,0.29,0.50,0.66,0.82,0.90,1,1.04,1.10,1.12,1.12,1.14,1.16,1.15,1.22,1.22,1.04,1.96,2.09,2.87,3.26,3.92,4.41,4.95,4.66,4.62,4.62,4.62,4.60,4.53,4.50,4.50,4.52,4.61,4.74,4.87,5.01,5.13,5.23,5.25,5.23,5.12,4.90,4.71,4.45,4.14,3.87,3.60,3.33,3.09,2.86,2.64,2.46,2.25,2.07,1.87,1.67,1.52,1.38,1.26,1.16,1.08,1,0.91,0.84,0.73,0.60,0.46,0.32,0.20,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.10,0.12,0.10,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0.10,0.21,0.21,0.11,0,0.01,0.02,0.01,0,0,0,0,0,0,0,0,0,0.02,0.08,0.13,0.20,0.24,0.25,0.26,0.27,0.28,0.27,0.25,0.24,0.22,0.22,0.22,0.22,0.22,0.21,0.17,0.15,0.15,0.16,0.21,0.20,-0.63,-1.88,-3.42,-5,-6.30,-7.34,-8.25,-9.29,-10,-11,-12,-13,-14,-14,-13,-13,-13,-13,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-16,-15,-14,-13,-12,-11,-10,-9.87,-9.51,-9.42,-9.34,-9.48,-9.60,-9.64,-9.68,-9.79,-9.91,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-16,-15,-15,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.97,-9.39,0.04,0,-0.12,-0.29,-0.83,-1.87,-1.98,-1.11,-0.83,-0.60,-0.36,-0.16,-0.02,0.04,0.08,0.04,-0.01,-0.16,-0.29,-0.40,-0.52,-0.65,-0.76,-0.84,-0.86,-0.84,-0.75,-0.66,-0.51,-0.33,-0.11,0.13,0.36,0.54,0.73,0.87,0.99,1.09,1.15,1.23,1.27,1.32,1.35,1.35,1.37,1.42,1.23,1.92,2.12,2.87,3.75,4.02,4.50,5.32,5.04,5.02,5,4.86,4.82,4.76,4.73,4.70,4.67,4.70,4.75,4.86,4.98,5.10,5.20,5.25,5.25,5.22,5.12,4.98,4.74,4.50,4.23,3.95,3.65,3.38,3.12,2.88,2.66,2.48,2.29,2.12,1.95,1.75,1.59,1.42,1.32,1.21,1.11,1.02,0.98,0.90,0.84,0.74,0.62,0.50,0.36,0.24,0.13,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0,0.04,0.09,0.11,0.09,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0.10,0.21,0.21,0.10,0,0.10,0.10,0.08,0.02,0,0,0,0,0,0,0,0,0.02,0.08,0.12,0.15,0.20,0.22,0.23,0.25,0.26,0.26,0.25,0.24,0.22,0.22,0.23,0.25,0.26,0.26,0.25,0.23,0.22,0.23,0.24,0.21,-0.70,-1.98,-3.49,-5,-6.28,-7.32,-8.24,-9.26,-10,-11,-11,-12,-12,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-12,-13,-14,-15,-17,-18,-19,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-18,-18,-17,-17,-16,-15,-14,-13,-11,-11,-10,-9.88,-9.61,-9.52,-9.37,-9.41,-9.53,-9.63,-9.78,-9.96,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.99,-9.43,0.39,0.24,0.07,-0.18,-0.52,-0.53,-0.55,-0.49,-0.34,-0.15,-0.02,0.10,0.22,0.29,0.34,0.34,0.28,0.22,0.12,0.01,-0.08,-0.15,-0.22,-0.25,-0.26,-0.25,-0.22,-0.13,-0.01,0.13,0.32,0.50,0.66,0.83,0.97,1.10,1.21,1.32,1.40,1.50,1.59,1.65,1.72,1.74,1.65,1.97,2.33,2.75,3.29,3.89,4.42,5.12,5,5.12,5.17,5.10,5.02,4.98,4.90,4.86,4.82,4.78,4.79,4.85,4.89,4.99,5.09,5.16,5.22,5.21,5.14,5.07,4.91,4.74,4.51,4.25,3.99,3.72,3.45,3.17,2.95,2.73,2.53,2.37,2.21,2.04,1.88,1.73,1.54,1.39,1.27,1.16,1.10,1.02,0.97,0.90,0.86,0.76,0.66,0.54,0.41,0.29,0.20,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.07,0.04,0.02,0.01,0.02,0.03,0.04,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0.10,0.21,0.21,0.12,0.02,0,0,0,0,0,0,0.01,0.02,0.04,0.08,0.11,0.12,0.14,0.15,0.17,0.23,0.25,0.24,0.21,0.16,0.16,0.20,0.23,0.25,0.29,0.29,0.28,0.27,0.28,0.32,0.29,0.23,-0.53,-1.99,-3.53,-5.04,-6.28,-7.21,-7.98,-8.80,-9.78,-10,-11,-11,-11,-11,-11,-11,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-12,-13,-15,-16,-17,-18,-19,-19,-20,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-16,-15,-14,-13,-12,-11,-11,-10,-9.93,-9.71,-9.63,-9.49,-9.50,-9.59,-9.75,-9.93,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.96,-9.47,0.71,0.57,0.33,0.09,-0.13,-0.25,-0.15,-0.10,0,0.10,0.21,0.32,0.42,0.52,0.59,0.61,0.61,0.52,0.45,0.37,0.32,0.26,0.25,0.25,0.25,0.27,0.33,0.38,0.49,0.60,0.74,0.87,1,1.12,1.25,1.37,1.50,1.63,1.77,1.90,2.04,2.16,2.29,2.45,2.57,2.97,3.37,3.75,4.12,4.51,4.87,5.08,5.16,5.15,5.14,5.10,5.02,4.99,4.95,4.90,4.87,4.87,4.87,4.90,4.98,5.02,5.08,5.11,5.10,5.03,4.96,4.83,4.65,4.47,4.24,4,3.75,3.50,3.25,3.01,2.79,2.62,2.47,2.33,2.17,2.04,1.89,1.75,1.59,1.41,1.27,1.20,1.12,1.04,0.99,0.95,0.88,0.82,0.73,0.62,0.49,0.37,0.25,0.16,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0.01,0.01,0.01,0.04,0.10,0.12,0.12,0.08,0.02,0,0,0,0,0,0,0,0,0,0.10,0.21,0.32,0.21,0.10,0,0,0,0,0,0.01,0.04,0.08,0.09,0.09,0.10,0.12,0.13,0.15,0.20,0.24,0.25,0.17,0.04,-0.08,-0.13,-0.13,-0.11,-0.05,-0.01,0.01,0.12,0.25,0.37,0.39,0.37,0.27,-0.43,-1.80,-3.57,-5.35,-6.48,-7.10,-7.58,-8.08,-8.66,-9.33,-9.75,-10,-10,-10,-10,-9.93,-9.76,-9.64,-9.55,-9.48,-9.41,-9.38,-9.41,-9.42,-9.41,-9.28,-9.18,-9.17,-9.37,-9.82,-10,-11,-12,-13,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-13,-12,-12,-11,-11,-11,-12,-13,-14,-15,-16,-17,-18,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-16,-16,-15,-14,-13,-12,-11,-11,-10,-9.92,-9.78,-9.68,-9.54,-9.52,-9.66,-9.87,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.88,-9.43,0.87,0.79,0.62,0.47,0.34,0.24,0.22,0.23,0.26,0.33,0.38,0.50,0.62,0.75,0.84,0.86,0.84,0.76,0.72,0.65,0.62,0.62,0.63,0.67,0.73,0.76,0.83,0.88,0.97,1.04,1.15,1.26,1.37,1.49,1.61,1.75,1.91,2.12,2.29,2.49,2.65,2.85,3.07,3.37,3.74,4.04,4.29,4.52,4.74,4.91,5.03,5.12,5.13,5.12,5.09,5.04,5,4.98,4.95,4.91,4.90,4.88,4.89,4.91,4.96,4.99,5,4.97,4.91,4.83,4.70,4.53,4.37,4.17,3.97,3.75,3.52,3.33,3.12,2.90,2.74,2.58,2.45,2.34,2.23,2.11,1.97,1.83,1.65,1.50,1.36,1.24,1.15,1.10,1.02,0.98,0.92,0.87,0.77,0.67,0.57,0.45,0.33,0.22,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.07,0.12,0.16,0.22,0.16,0.11,0.01,0,0,0,0,0,0,0,0,0.11,0.11,0.33,0.22,0.22,0,0,0,0,0,0.03,0.13,0.16,0.15,0.12,0.13,0.20,0.24,0.26,0.29,0.33,0.29,0.10,-0.24,-0.58,-0.76,-0.80,-0.80,-0.76,-0.71,-0.55,-0.21,0.14,0.40,0.45,0.45,0.37,-0.27,-1.58,-3.39,-5.26,-6.46,-6.86,-7.05,-7.23,-7.52,-8.01,-8.43,-8.71,-8.84,-8.88,-8.80,-8.63,-8.45,-8.28,-8.12,-7.96,-7.77,-7.71,-7.83,-8.20,-8.48,-8.37,-8.14,-8.13,-8.35,-8.83,-9.62,-10,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-13,-12,-12,-11,-11,-11,-11,-12,-13,-14,-16,-17,-17,-18,-18,-19,-19,-19,-18,-18,-17,-17,-17,-16,-16,-15,-14,-14,-13,-12,-11,-11,-10,-10,-9.83,-9.73,-9.54,-9.53,-9.75,-9.98,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-12,-12,-11,-11,-11,-10,-10,-9.75,-9.34,1,0.99,0.92,0.87,0.77,0.71,0.64,0.61,0.60,0.61,0.64,0.73,0.84,0.95,1.01,1.07,1.03,0.99,0.92,0.88,0.87,0.90,0.99,1.08,1.16,1.25,1.34,1.39,1.47,1.53,1.62,1.72,1.82,1.92,2.09,2.27,2.51,2.76,3,3.22,3.39,3.60,3.86,4.25,4.87,4.87,4.99,5.01,5.04,5.07,5.09,5.10,5.10,5.08,5.03,5,4.98,4.96,4.92,4.91,4.90,4.88,4.88,4.87,4.87,4.87,4.84,4.77,4.66,4.54,4.39,4.25,4.09,3.90,3.73,3.53,3.36,3.17,3,2.87,2.73,2.60,2.49,2.39,2.29,2.21,2.09,1.95,1.78,1.62,1.48,1.34,1.23,1.14,1.09,1.02,0.98,0.91,0.85,0.75,0.62,0.50,0.37,0.25,0.15,0.09,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.01,0.02,0.07,0.12,0.16,0.23,0.20,0.12,0.03,0,0,0,0,0,0,0,0,0,0,0.22,0.29,0.22,0,0,0,0,0,0.04,0.14,0.20,0.17,0.13,0.24,0.35,0.45,0.47,0.49,0.48,0.29,-0.04,-0.62,-1.14,-1.53,-1.72,-1.74,-1.72,-1.58,-1.27,-0.72,-0.25,0.17,0.35,0.41,0.35,0.11,-1.26,-3,-4.98,-6.28,-6.67,-6.53,-6.37,-6.51,-6.84,-7.16,-7.37,-7.53,-7.60,-7.48,-7.25,-7.03,-6.89,-6.82,-6.64,-6.40,-6.13,-6.30,-6.97,-7.89,-7.15,-6.86,-6.82,-7.04,-7.52,-8.20,-8.98,-9.68,-10,-10,-10,-10,-10,-10,-12,-12,-13,-14,-14,-14,-13,-12,-11,-11,-10,-10,-11,-11,-12,-13,-14,-15,-16,-17,-17,-18,-18,-18,-17,-17,-17,-16,-16,-15,-15,-15,-14,-14,-13,-12,-11,-11,-10,-10,-9.85,-9.67,-9.53,-9.55,-9.80,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-11,-11,-11,-10,-10,-9.63,-9.23,1.20,1.22,1.25,1.25,1.21,1.11,1,0.90,0.85,0.83,0.85,0.89,1,1.11,1.21,1.25,1.24,1.17,1.11,1.08,1.09,1.16,1.32,1.49,1.64,1.79,1.89,1.97,2.01,2.09,2.15,2.25,2.37,2.50,2.72,2.98,3.27,3.61,3.88,4.08,4.20,4.34,4.59,4.95,5.20,5.32,5.28,5.21,5.12,5.10,5.09,5.07,5.04,5.01,5,4.97,4.95,4.90,4.88,4.87,4.86,4.85,4.83,4.79,4.76,4.73,4.62,4.51,4.40,4.26,4.12,3.97,3.82,3.65,3.51,3.37,3.24,3.11,2.98,2.86,2.75,2.66,2.59,2.51,2.45,2.36,2.25,2.11,1.96,1.77,1.62,1.47,1.33,1.22,1.14,1.10,1.02,0.98,0.89,0.79,0.70,0.57,0.42,0.29,0.20,0.11,0.04,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0.03,0.03,0.03,0.04,0.08,0.12,0.16,0.15,0.12,0.02,0,0,0,0,0,0,0,0,0,0,0.11,0.11,0.11,0,0,0,0,0,0.02,0.12,0.14,0.16,0.22,0.38,0.38,0.47,0.47,0.48,0.29,0.13,-0.16,-0.73,-1.43,-1.89,-2.10,-2.13,-2.11,-1.93,-1.63,-1.15,-0.68,-0.14,0.22,0.34,0.15,-0.02,-0.60,-2.24,-4.55,-6.90,-6.52,-5.89,-5.54,-5.46,-5.70,-5.89,-5.92,-5.98,-6.21,-6.04,-5.72,-5.43,-5.36,-5.57,-5.45,-5.11,-4.86,-4.98,-5.47,-5.92,-5.61,-5.26,-5.25,-5.51,-5.98,-6.60,-7.32,-8.02,-8.62,-9.07,-9.17,-9.16,-9.16,-9.64,-10,-10,-12,-13,-13,-13,-12,-12,-11,-10,-10,-10,-10,-10,-11,-12,-13,-14,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-12,-12,-11,-10,-10,-9.79,-9.64,-9.47,-9.63,-9.88,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-11,-11,-10,-10,-9.88,-9.50,-9.08,1.53,1.58,1.63,1.67,1.60,1.42,1.24,1.10,1,0.96,0.97,1,1.11,1.23,1.34,1.40,1.39,1.34,1.25,1.22,1.25,1.40,1.65,1.95,2.23,2.45,2.57,2.62,2.64,2.70,2.75,2.86,2.99,3.16,3.41,3.76,4.16,4.58,4.91,5.01,4.95,4.97,5.13,5.28,5.38,5.37,5.29,5.21,5.13,5.09,5.04,5.02,5,4.98,4.96,4.91,4.88,4.86,4.82,4.77,4.75,4.72,4.67,4.62,4.57,4.48,4.37,4.25,4.12,3.98,3.83,3.67,3.54,3.47,3.35,3.25,3.16,3.09,3,2.90,2.84,2.76,2.73,2.66,2.62,2.53,2.42,2.29,2.13,1.97,1.77,1.60,1.42,1.32,1.23,1.15,1.10,1.03,0.96,0.86,0.74,0.61,0.48,0.35,0.23,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0.02,0.07,0.08,0.08,0.04,0.02,0.03,0.04,0.07,0.07,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.10,0.27,0.34,0.20,0.24,0.38,0.38,0.08,-0.10,-0.25,-0.63,-1.28,-1.65,-1.83,-1.87,-1.85,-1.65,-1.43,-1.22,-0.96,-0.38,0.12,0.25,-0.02,-0.27,-0.30,-0.84,-2.83,-4.51,-4.77,-4.53,-4.25,-4.22,-4.14,-4.15,-4.16,-4.12,-4.10,-3.97,-3.78,-3.63,-3.70,-3.87,-3.92,-3.77,-3.76,-3.88,-4.24,-4.33,-3.66,-3.42,-3.47,-3.74,-4.27,-4.96,-5.68,-6.43,-7.11,-7.71,-8.07,-8.22,-8.21,-8.50,-8.80,-9.53,-10,-11,-12,-12,-12,-11,-10,-10,-9.65,-9.50,-9.65,-10,-10,-11,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.77,-9.65,-9.66,-9.68,-9.96,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-15,-14,-13,-13,-12,-11,-11,-10,-10,-10,-9.65,-9.27,-8.87,2,2.01,2.02,2.04,1.97,1.62,1.36,1.16,1.07,1,1,1.04,1.14,1.26,1.39,1.48,1.48,1.40,1.34,1.33,1.42,1.65,2.02,2.48,2.90,3.22,3.34,3.34,3.33,3.34,3.39,3.50,3.64,3.86,4.13,4.51,5.07,5.66,5.86,5.75,5.42,5.39,5.38,5.38,5.36,5.29,5.24,5.15,5.10,5.04,5.01,4.99,4.97,4.92,4.89,4.86,4.79,4.75,4.70,4.63,4.59,4.52,4.48,4.40,4.32,4.21,4.09,3.96,3.84,3.71,3.60,3.49,3.38,3.32,3.25,3.20,3.14,3.11,3.07,3,2.96,2.90,2.87,2.86,2.83,2.74,2.63,2.50,2.35,2.14,1.96,1.75,1.57,1.41,1.29,1.23,1.15,1.10,1,0.90,0.77,0.64,0.50,0.37,0.25,0.14,0.09,0.03,0.01,0,0,0,0,0,0,0,0,0.03,0.09,0.12,0.11,0.07,0.01,0,0,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.09,0.34,0.39,0.12,0.24,0.38,0.39,0.09,0.07,-0.09,-0.37,-0.80,-0.84,-0.89,-1.09,-1.05,-0.83,-0.62,-0.74,-0.75,-0.37,0.15,0.17,-0.18,-0.49,-0.34,-0.21,-0.18,-1.05,-2.28,-2.52,-2.51,-2.29,-2.11,-2.16,-2.20,-2.03,-1.98,-1.93,-1.83,-1.80,-1.92,-2.13,-2.22,-2.30,-2.43,-3.09,-3.21,-2.43,-1.53,-1.50,-1.66,-2.09,-2.75,-3.50,-4.26,-5,-5.79,-6.58,-7.12,-7.42,-7.59,-7.74,-7.86,-8.39,-9.01,-9.60,-10,-10,-11,-10,-10,-9.40,-8.91,-8.77,-8.93,-9.38,-9.85,-10,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-14,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.79,-9.78,-9.89,-9.99,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-11,-10,-10,-10,-9.77,-9.43,-9.03,-8.63,2.51,2.37,2.32,2.21,2.03,1.63,1.35,1.16,1.07,1,1,1.04,1.12,1.25,1.36,1.45,1.46,1.40,1.37,1.40,1.58,1.88,2.37,2.99,3.61,4.09,4.11,4,3.96,3.96,4,4.10,4.25,4.46,4.73,5.09,5.53,5.92,6,5.73,5.62,5.49,5.40,5.34,5.27,5.23,5.15,5.11,5.04,5.01,4.99,4.96,4.91,4.87,4.83,4.75,4.67,4.60,4.51,4.45,4.37,4.29,4.23,4.14,4.03,3.92,3.82,3.70,3.60,3.50,3.42,3.37,3.29,3.26,3.25,3.24,3.22,3.21,3.17,3.14,3.11,3.09,3.07,3.03,3,2.97,2.87,2.74,2.54,2.35,2.12,1.89,1.70,1.51,1.38,1.28,1.21,1.13,1.04,0.96,0.85,0.67,0.53,0.39,0.27,0.17,0.11,0.08,0.03,0.02,0.01,0,0,0,0,0,0,0.03,0.09,0.11,0.09,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.27,0.29,0.26,0.26,0.41,0.41,0.25,0.27,0.17,0.03,-0.27,-0.30,-0.49,-0.64,-0.50,-0.29,-0.13,-0.40,-0.53,-0.25,0.20,0.32,0.04,-0.16,-0.10,-0.01,0.01,-0.03,-0.12,-0.17,-0.22,-0.21,-0.15,-0.12,-0.43,-0.36,-0.36,-0.40,-0.42,-0.54,-0.33,-0.41,-0.52,-0.52,-1.14,-1.05,-1.03,-0.92,-0.10,-0.20,-0.22,-0.67,-1.39,-2.20,-2.97,-3.77,-4.60,-5.50,-6.18,-6.65,-6.97,-7.21,-7.41,-7.74,-8.08,-8.42,-8.78,-9.21,-9.46,-9.54,-9.17,-8.73,-8.33,-8.23,-8.43,-8.80,-9.23,-9.71,-10,-10,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-9.92,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-11,-10,-10,-9.86,-9.49,-9.13,-8.75,-8.34,2.70,2.54,2.02,1.84,1.66,1.46,1.25,1.12,1.03,1,1,1.02,1.09,1.16,1.25,1.33,1.36,1.35,1.36,1.46,1.66,2.07,2.62,3.33,4.22,5.02,4.64,4.48,4.41,4.42,4.48,4.54,4.67,4.85,5.01,5.22,5.42,5.59,5.60,5.59,5.48,5.38,5.32,5.25,5.21,5.14,5.10,5.07,5.01,4.99,4.95,4.90,4.86,4.79,4.72,4.62,4.51,4.40,4.29,4.21,4.12,4.03,3.96,3.87,3.77,3.66,3.58,3.49,3.41,3.37,3.33,3.29,3.28,3.28,3.28,3.29,3.32,3.33,3.32,3.28,3.26,3.25,3.24,3.23,3.21,3.14,3.04,2.90,2.72,2.50,2.25,2.02,1.78,1.61,1.46,1.34,1.24,1.14,1.07,0.97,0.86,0.72,0.57,0.41,0.29,0.21,0.13,0.11,0.09,0.08,0.04,0.02,0,0,0,0,0,0.01,0.03,0.07,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.17,0.29,0.38,0.38,0.37,0.36,0.36,0.40,0.34,0.27,0.02,-0.09,-0.38,-0.50,-0.24,-0.09,0.07,-0.36,-0.49,-0.23,0.21,0.46,0.26,0.15,0.12,0.15,0.14,0.10,0.03,0,-0.02,-0.02,-0.01,0.01,0.02,0.07,0.07,0.07,0.02,0,-0.02,-0.04,-0.17,-0.29,-0.17,0.03,0.16,0.23,0.24,0.28,0.20,-0.04,-0.51,-1.18,-1.88,-2.63,-3.42,-4.30,-5.08,-5.70,-6.30,-6.65,-7.04,-7.25,-7.46,-7.59,-7.82,-8.17,-8.47,-8.51,-8.37,-8.09,-7.83,-7.83,-8.10,-8.61,-8.83,-9.11,-9.43,-9.92,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-13,-13,-12,-11,-10,-10,-9.86,-9.46,-9.15,-8.80,-8.46,-8.24,1.87,1.75,1.37,1.45,1.35,1.23,1.12,1.03,1,0.99,0.99,1,1.03,1.10,1.14,1.21,1.24,1.25,1.32,1.46,1.73,2.13,2.70,3.37,4.15,4.57,4.66,4.61,4.62,4.65,4.73,4.82,4.83,4.87,4.96,5.03,5.13,5.21,5.25,5.25,5.25,5.23,5.21,5.16,5.13,5.11,5.08,5.03,5,4.97,4.91,4.86,4.78,4.71,4.60,4.48,4.34,4.21,4.07,3.96,3.86,3.76,3.70,3.62,3.53,3.46,3.38,3.34,3.29,3.28,3.28,3.29,3.33,3.35,3.37,3.39,3.42,3.46,3.46,3.45,3.42,3.40,3.39,3.38,3.37,3.32,3.22,3.04,2.86,2.62,2.37,2.12,1.88,1.66,1.50,1.37,1.25,1.14,1.07,0.97,0.86,0.74,0.60,0.47,0.35,0.26,0.22,0.17,0.15,0.13,0.12,0.09,0.04,0.01,0,0,0,0,0,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.08,0.12,0.14,0.14,0.12,0.12,0.12,0.21,0.29,0.47,0.27,0.08,-0.22,-0.22,-0.09,-0.08,-0.08,-0.35,-0.49,-0.23,0.22,0.57,0.47,0.34,0.24,0.17,0.13,0.10,0.08,0.04,0.03,0.03,0.03,0.04,0.03,0.04,0.07,0.07,0.04,0.07,0.11,0.16,0.08,0.01,0.08,0.25,0.42,0.32,0.26,0.25,0.28,0.27,0.10,-0.37,-0.89,-1.51,-2.17,-2.92,-3.71,-4.50,-5.28,-5.91,-6.57,-6.78,-6.93,-7.01,-7.10,-7.37,-7.53,-7.68,-7.64,-7.57,-7.51,-7.52,-7.79,-8.23,-8.41,-8.38,-8.93,-9.46,-9.68,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-11,-11,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-13,-13,-12,-11,-10,-10,-9.43,-9.10,-8.77,-8.58,-8.38,-8.17,1.09,1.10,1.20,1.13,1.12,1.08,1.02,1,0.99,0.99,0.99,0.99,1,1.02,1.07,1.10,1.13,1.17,1.26,1.45,1.72,2.12,2.62,3.21,3.73,4.12,4.34,4.46,4.53,4.62,4.67,4.73,4.74,4.74,4.75,4.78,4.83,4.86,4.90,4.98,5.03,5.09,5.12,5.13,5.13,5.12,5.11,5.07,5.01,4.97,4.88,4.79,4.71,4.60,4.46,4.32,4.14,3.99,3.84,3.71,3.61,3.52,3.47,3.39,3.36,3.29,3.26,3.25,3.25,3.27,3.32,3.35,3.38,3.42,3.47,3.50,3.53,3.57,3.59,3.59,3.58,3.57,3.54,3.53,3.50,3.45,3.34,3.16,2.97,2.73,2.46,2.21,1.97,1.74,1.54,1.39,1.26,1.15,1.07,0.98,0.87,0.75,0.63,0.51,0.41,0.36,0.32,0.28,0.26,0.25,0.21,0.14,0.11,0.07,0.03,0.02,0.01,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0.02,0.01,0.01,0.02,0.07,0.13,0.28,0.28,0.25,0.11,0.14,0.17,0.21,0.21,-0.08,-0.22,-0.09,0.33,0.49,0.35,0.25,0.16,0.12,0.09,0.07,0.04,0.03,0.02,0.02,0.02,0.02,0.02,0.02,0.02,0.02,0.03,0.08,0.12,0.17,0.20,0.21,0.25,0.29,0.29,0.25,0.15,0.12,0.16,0.24,0.26,0.13,-0.15,-0.50,-0.84,-1.39,-2.18,-3.11,-4.02,-5,-5.80,-6.24,-6.41,-6.54,-6.62,-6.77,-6.86,-7.08,-7.10,-7.11,-7.11,-7.17,-7.30,-7.54,-7.77,-7.73,-8.16,-8.66,-8.96,-9.61,-10,-10,-11,-11,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-13,-12,-11,-11,-10,-9.61,-9.08,-8.80,-8.66,-8.50,-8.33,-8.10,1,1,1.01,1.01,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.04,1.09,1.13,1.25,1.41,1.67,2.03,2.47,2.91,3.36,3.71,3.97,4.15,4.29,4.42,4.51,4.54,4.57,4.54,4.50,4.50,4.53,4.60,4.67,4.78,4.90,5.02,5.12,5.16,5.21,5.20,5.16,5.12,5.04,4.97,4.87,4.75,4.62,4.48,4.33,4.14,3.98,3.78,3.62,3.50,3.39,3.34,3.28,3.25,3.23,3.22,3.22,3.23,3.25,3.32,3.37,3.41,3.48,3.52,3.58,3.62,3.64,3.67,3.70,3.71,3.71,3.70,3.67,3.65,3.62,3.54,3.42,3.25,3.04,2.79,2.53,2.27,2.02,1.79,1.61,1.42,1.28,1.16,1.08,0.99,0.89,0.79,0.71,0.62,0.52,0.48,0.46,0.42,0.40,0.37,0.33,0.25,0.17,0.12,0.10,0.08,0.08,0.04,0.02,0.01,0.01,0.01,0.02,0.03,0.03,0.03,0.03,0.02,0.01,0,0.01,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.15,0.25,0.34,0.36,0.40,0.34,0.37,0.41,0.32,0.21,0.16,0.37,0.34,0.25,0.13,0.09,0.04,0.02,0.01,0.01,0,0,0,0,0,0,0,0,0,0.01,0.03,0.10,0.13,0.17,0.24,0.25,0.22,0.16,0.11,0.04,0.03,0.09,0.14,0.23,0.26,0.21,0.09,0,-0.08,-0.73,-1.60,-2.74,-3.82,-4.73,-5.40,-5.79,-5.98,-6.16,-6.34,-6.51,-6.77,-6.83,-6.80,-6.76,-6.75,-6.76,-6.88,-7.01,-7.12,-7.43,-7.92,-8.43,-8.95,-9.42,-9.92,-10,-10,-11,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.93,-10,-10,-10,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-15,-14,-13,-13,-12,-11,-10,-9.98,-9.48,-9.04,-8.74,-8.60,-8.41,-8.23,-8,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.02,1.08,1.12,1.24,1.39,1.63,1.95,2.29,2.67,3.03,3.37,3.63,3.87,4.07,4.22,4.34,4.39,4.39,4.37,4.36,4.39,4.41,4.49,4.60,4.74,4.89,5.04,5.20,5.27,5.32,5.32,5.26,5.21,5.11,4.99,4.85,4.71,4.53,4.37,4.21,4.01,3.83,3.64,3.49,3.36,3.25,3.21,3.16,3.15,3.15,3.16,3.21,3.25,3.32,3.37,3.45,3.50,3.58,3.62,3.66,3.72,3.74,3.76,3.77,3.79,3.79,3.78,3.77,3.75,3.72,3.62,3.50,3.34,3.12,2.87,2.61,2.35,2.10,1.87,1.65,1.48,1.33,1.21,1.11,1.02,0.96,0.87,0.79,0.74,0.66,0.63,0.62,0.60,0.58,0.52,0.47,0.37,0.28,0.22,0.16,0.14,0.13,0.12,0.09,0.08,0.08,0.09,0.12,0.13,0.14,0.13,0.14,0.13,0.12,0.14,0.12,0.10,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.09,0.12,0.13,0.21,0.27,0.37,0.42,0.36,0.38,0.37,0.39,0.25,0.14,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.08,0.11,0.12,0.13,0.12,0.08,0.02,0,0,0.02,0.08,0.13,0.20,0.23,0.22,0.25,0.34,-0.09,-0.87,-1.70,-2.65,-3.54,-4.28,-4.80,-5.29,-5.58,-5.90,-6.35,-6.67,-6.80,-6.68,-6.52,-6.40,-6.24,-6.28,-6.38,-6.53,-6.78,-7.33,-7.87,-8.41,-8.99,-9.52,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.87,-9.76,-9.90,-10,-10,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-11,-10,-10,-9.52,-9.05,-8.62,-8.48,-8.28,-8.12,-7.88,1,1,0.99,0.99,1,1,1,1,1,1,1,1,1.01,1.01,1.02,1.03,1.09,1.14,1.24,1.38,1.60,1.87,2.17,2.50,2.82,3.12,3.38,3.64,3.87,4.07,4.21,4.32,4.37,4.39,4.41,4.45,4.48,4.53,4.64,4.79,4.98,5.15,5.32,5.41,5.46,5.45,5.37,5.27,5.13,4.98,4.83,4.64,4.48,4.29,4.12,3.92,3.75,3.59,3.42,3.32,3.22,3.15,3.13,3.12,3.12,3.16,3.23,3.28,3.37,3.46,3.52,3.61,3.66,3.72,3.75,3.78,3.82,3.84,3.86,3.86,3.87,3.86,3.85,3.82,3.76,3.67,3.54,3.37,3.16,2.91,2.66,2.41,2.17,1.96,1.75,1.54,1.39,1.26,1.16,1.10,1.02,0.99,0.92,0.88,0.85,0.83,0.79,0.78,0.75,0.71,0.62,0.51,0.41,0.33,0.25,0.23,0.21,0.17,0.15,0.15,0.17,0.22,0.25,0.28,0.29,0.32,0.33,0.34,0.36,0.35,0.32,0.25,0.17,0.10,0.04,0.03,0.04,0.04,0.02,0.01,0.02,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.08,0.14,0.24,0.37,0.47,0.53,0.51,0.39,0.24,0.11,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0.02,0.02,0.01,0,0,0,0,0,0.01,0.03,0.09,0.13,0.21,0.32,0.26,-0.08,-0.55,-0.92,-1.51,-2.26,-2.95,-3.61,-4.21,-4.74,-5.39,-6.03,-6.47,-6.83,-6.58,-6.36,-6.15,-5.88,-5.86,-5.95,-6.16,-6.40,-6.90,-7.43,-8.01,-8.63,-9.20,-9.62,-9.88,-10,-10,-10,-9.96,-9.95,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.75,-9.72,-9.88,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-11,-10,-10,-9.63,-9.04,-8.53,-8.34,-8.16,-7.96,-7.74,1,1,1,1,1.01,1.04,1.07,1.08,1.07,1.07,1.08,1.08,1.09,1.09,1.10,1.12,1.12,1.16,1.25,1.35,1.53,1.77,2.10,2.40,2.74,3.03,3.33,3.59,3.83,4.03,4.24,4.38,4.49,4.54,4.59,4.62,4.62,4.66,4.75,4.89,5.08,5.25,5.41,5.52,5.54,5.50,5.40,5.28,5.13,4.98,4.79,4.62,4.42,4.25,4.07,3.88,3.72,3.54,3.39,3.27,3.20,3.13,3.12,3.12,3.14,3.20,3.26,3.35,3.45,3.52,3.62,3.67,3.75,3.78,3.83,3.85,3.87,3.87,3.88,3.89,3.90,3.89,3.88,3.86,3.79,3.72,3.59,3.41,3.22,2.99,2.75,2.50,2.27,2.04,1.85,1.65,1.50,1.37,1.26,1.21,1.14,1.12,1.09,1.07,1.03,1.01,1,0.99,0.95,0.88,0.78,0.67,0.57,0.45,0.36,0.28,0.25,0.25,0.25,0.28,0.35,0.38,0.45,0.48,0.50,0.51,0.54,0.57,0.58,0.59,0.53,0.46,0.34,0.23,0.13,0.12,0.20,0.25,0.28,0.28,0.24,0.13,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.17,0.32,0.45,0.37,0.25,0.25,0.29,0.26,0.12,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.10,0.16,0.26,0.34,-0.05,-0.42,-0.73,-0.86,-0.87,-1.39,-2.12,-2.90,-3.65,-4.42,-5.15,-6.13,-6.36,-6.22,-6.14,-6.01,-5.71,-5.64,-5.88,-6.26,-6.41,-6.75,-7.24,-7.83,-8.49,-9.05,-9.39,-9.52,-9.49,-9.33,-9.27,-9.24,-9.24,-9.27,-9.38,-9.51,-9.66,-9.83,-9.92,-9.96,-9.88,-9.78,-9.75,-9.83,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-14,-15,-15,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-15,-14,-14,-13,-12,-12,-11,-10,-10,-9.71,-9.10,-8.50,-8.14,-8,-7.83,-7.68,1.02,1.15,1.28,1.33,1.33,1.32,1.25,1.17,1.16,1.14,1.16,1.17,1.17,1.17,1.20,1.23,1.27,1.35,1.42,1.53,1.70,1.89,2.21,2.51,2.84,3.13,3.42,3.71,3.96,4.17,4.38,4.57,4.70,4.76,4.79,4.79,4.79,4.82,4.87,4.99,5.13,5.32,5.46,5.53,5.50,5.48,5.39,5.26,5.12,4.97,4.77,4.60,4.39,4.22,4.03,3.87,3.71,3.54,3.40,3.29,3.22,3.15,3.12,3.13,3.16,3.23,3.29,3.38,3.49,3.60,3.67,3.75,3.79,3.85,3.87,3.88,3.89,3.90,3.91,3.92,3.92,3.91,3.90,3.87,3.83,3.74,3.62,3.46,3.25,3.02,2.83,2.60,2.38,2.16,1.98,1.79,1.63,1.50,1.39,1.34,1.28,1.26,1.25,1.25,1.24,1.24,1.22,1.17,1.13,1.07,0.98,0.86,0.73,0.59,0.48,0.38,0.34,0.34,0.37,0.45,0.51,0.59,0.63,0.66,0.70,0.71,0.73,0.75,0.76,0.76,0.74,0.64,0.50,0.38,0.28,0.28,0.39,0.50,0.60,0.62,0.51,0.35,0.13,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.11,0.26,0.28,0.32,0.09,-0.02,0.09,0.24,0.32,0.13,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.09,0.17,0.25,0.29,0.20,0,-0.22,-0.38,-0.46,-0.46,-0.50,-0.60,-1.54,-2.20,-2.92,-3.72,-4.46,-5.05,-5.51,-5.76,-5.88,-5.95,-6.03,-6.49,-6.89,-6.92,-6.99,-7.35,-7.92,-8.62,-9.17,-9.48,-9.38,-9.11,-8.72,-8.57,-8.51,-8.47,-8.52,-8.57,-8.79,-9.13,-9.42,-9.68,-9.87,-9.88,-9.86,-9.84,-9.89,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-9.80,-9.13,-8.47,-8.03,-7.92,-7.77,-7.66,1.84,1.70,1.70,1.71,1.71,1.72,1.61,1.51,1.46,1.41,1.45,1.46,1.46,1.46,1.48,1.50,1.59,1.66,1.75,1.85,1.97,2.16,2.40,2.72,3.03,3.36,3.65,3.96,4.21,4.45,4.63,4.79,4.92,4.99,5,4.99,4.95,4.91,4.95,5,5.12,5.25,5.32,5.38,5.40,5.38,5.33,5.22,5.09,4.91,4.75,4.57,4.37,4.21,4.02,3.87,3.73,3.59,3.46,3.35,3.25,3.20,3.16,3.16,3.21,3.25,3.34,3.41,3.51,3.62,3.73,3.78,3.84,3.87,3.89,3.90,3.91,3.92,3.92,3.92,3.95,3.95,3.91,3.88,3.85,3.75,3.63,3.49,3.28,3.10,2.89,2.71,2.50,2.32,2.12,1.96,1.79,1.66,1.57,1.49,1.45,1.42,1.41,1.42,1.42,1.41,1.40,1.37,1.33,1.25,1.14,1.02,0.89,0.75,0.62,0.51,0.46,0.47,0.51,0.62,0.71,0.76,0.79,0.83,0.84,0.85,0.85,0.87,0.87,0.87,0.86,0.77,0.66,0.57,0.50,0.50,0.60,0.75,0.88,0.95,0.84,0.61,0.36,0.14,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.12,0.29,0.24,0.12,-0.23,-0.37,-0.17,0.10,0.28,0.13,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.11,0.15,0.21,0.26,0.35,0.22,0.08,0.01,0,0.03,0.08,0.07,0,-0.10,-0.18,-0.40,-1.23,-1.85,-2.76,-3.59,-4.37,-5.01,-5.74,-6.15,-6.83,-7.55,-7.96,-7.80,-7.59,-7.72,-8.23,-8.98,-9.55,-9.77,-9.39,-8.80,-8.23,-7.92,-7.79,-7.73,-7.79,-7.86,-8.12,-8.50,-9.05,-9.50,-9.76,-9.88,-9.90,-9.90,-9.98,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-15,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.92,-9.28,-8.61,-8.09,-7.88,-7.75,-7.63,2.28,2.29,2.28,2.26,2.25,2.25,2.09,1.96,1.88,1.86,1.87,1.87,1.87,1.87,1.89,1.92,2,2.10,2.17,2.25,2.33,2.50,2.72,3,3.32,3.63,3.97,4.26,4.52,4.75,4.92,5.08,5.17,5.21,5.21,5.12,5.03,4.97,4.92,4.95,4.99,5.03,5.12,5.20,5.24,5.24,5.21,5.12,5.01,4.87,4.72,4.53,4.37,4.20,4.03,3.89,3.76,3.63,3.52,3.41,3.34,3.25,3.23,3.22,3.24,3.28,3.37,3.46,3.53,3.63,3.73,3.79,3.86,3.88,3.90,3.92,3.95,3.95,3.96,3.95,3.96,3.96,3.92,3.89,3.86,3.76,3.65,3.51,3.35,3.15,2.99,2.82,2.63,2.47,2.28,2.12,1.99,1.85,1.74,1.65,1.61,1.59,1.59,1.59,1.60,1.60,1.58,1.53,1.49,1.40,1.32,1.21,1.09,0.96,0.83,0.72,0.65,0.65,0.72,0.79,0.87,0.91,0.92,0.92,0.92,0.90,0.91,0.90,0.91,0.91,0.89,0.86,0.78,0.72,0.66,0.70,0.75,0.85,0.91,0.95,0.92,0.79,0.58,0.35,0.13,0.03,0.01,0.02,0.03,0.03,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.24,0.12,-0.02,-0.23,-0.22,-0.02,0.12,0.23,0.12,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.20,0.23,0.28,0.23,0.14,0.03,-0.08,0,0.15,0.35,0.48,0.48,0.37,0.25,0.15,0.02,-0.27,-0.74,-1.15,-2.05,-2.98,-3.86,-4.78,-5.99,-7.27,-8.96,-8.71,-8.75,-8.33,-8.05,-8.40,-9.34,-9.97,-10,-9.34,-8.38,-7.72,-7.29,-7.11,-7.03,-7.13,-7.24,-7.55,-7.88,-8.45,-9.05,-9.50,-9.79,-9.85,-9.88,-9.99,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.48,-8.78,-8.15,-7.79,-7.68,-7.55,2.99,2.88,2.79,2.73,2.74,2.70,2.59,2.48,2.41,2.41,2.41,2.45,2.46,2.46,2.46,2.48,2.51,2.60,2.64,2.71,2.75,2.87,3.08,3.34,3.63,3.98,4.29,4.62,4.87,5.08,5.23,5.34,5.40,5.37,5.33,5.21,5.07,4.95,4.85,4.79,4.79,4.85,4.89,4.97,5.02,5.07,5.07,5,4.92,4.79,4.65,4.50,4.35,4.20,4.04,3.92,3.83,3.72,3.61,3.50,3.41,3.35,3.28,3.26,3.27,3.33,3.38,3.48,3.57,3.64,3.74,3.79,3.86,3.89,3.91,3.92,3.95,3.96,3.96,3.96,3.96,3.96,3.95,3.90,3.87,3.78,3.70,3.57,3.39,3.24,3.09,2.91,2.75,2.61,2.46,2.32,2.16,2.02,1.91,1.84,1.76,1.74,1.73,1.73,1.73,1.73,1.71,1.67,1.62,1.57,1.48,1.37,1.26,1.15,1.04,0.97,0.90,0.90,0.95,1,1.04,1.07,1.04,1.01,0.99,0.97,0.96,0.95,0.95,0.95,0.92,0.89,0.87,0.84,0.82,0.83,0.86,0.89,0.95,0.97,0.96,0.90,0.77,0.54,0.34,0.13,0.03,0.12,0.16,0.16,0.11,0.02,0,0,0,0,0,0,0,0,0,0,0,0.02,0.11,0.16,0.14,0.10,0.02,0.02,0.10,0.14,0.16,0.10,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.11,0.20,0.25,0.20,0.09,-0.05,-0.23,-0.34,-0.30,-0.08,0.22,0.48,0.62,0.60,0.46,0.33,0.23,0.12,-0.04,-0.34,-0.62,-0.90,-1.42,-2.14,-3.28,-4.65,-6.04,-7.90,-8.89,-9.62,-8.40,-7.95,-8.03,-8.87,-11,-10,-8.65,-7.66,-6.93,-6.54,-6.40,-6.40,-6.57,-6.74,-7.07,-7.38,-7.85,-8.46,-9,-9.33,-9.54,-9.74,-9.96,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-17,-17,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.62,-8.93,-8.33,-7.77,-7.63,-7.50,3.92,3.73,3.50,3.33,3.24,3.22,3.10,3.03,3.01,3.03,3.08,3.12,3.13,3.12,3.11,3.08,3.08,3.09,3.12,3.13,3.17,3.26,3.45,3.70,3.99,4.32,4.63,4.95,5.17,5.36,5.48,5.53,5.58,5.48,5.37,5.20,5.01,4.85,4.72,4.64,4.62,4.62,4.66,4.74,4.82,4.87,4.89,4.87,4.83,4.73,4.61,4.47,4.33,4.20,4.08,3.97,3.87,3.77,3.70,3.61,3.51,3.45,3.37,3.35,3.34,3.37,3.41,3.50,3.58,3.65,3.74,3.79,3.85,3.88,3.91,3.95,3.96,3.96,3.97,3.96,3.96,3.97,3.95,3.91,3.87,3.82,3.73,3.61,3.47,3.33,3.17,3.02,2.88,2.75,2.62,2.48,2.35,2.22,2.09,1.99,1.90,1.87,1.84,1.83,1.83,1.82,1.79,1.77,1.74,1.67,1.62,1.53,1.46,1.37,1.28,1.23,1.20,1.17,1.20,1.23,1.23,1.21,1.15,1.10,1.04,1,0.99,0.97,0.97,0.96,0.96,0.95,0.91,0.90,0.89,0.90,0.91,0.95,0.96,0.97,0.97,0.95,0.88,0.75,0.53,0.34,0.14,0.26,0.38,0.38,0.25,0.03,0,0,0,0.01,0.01,0,0,0,0,0,0,0.01,0.07,0.12,0.15,0.17,0.17,0.17,0.16,0.14,0.11,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.12,0.22,0.23,0.08,-0.13,-0.35,-0.63,-0.74,-0.58,-0.17,0.21,0.48,0.57,0.49,0.37,0.25,0.17,0.12,0.04,-0.08,-0.18,-0.36,-0.51,-0.75,-1.09,-2.26,-3.38,-3.73,-6.08,-7.90,-8.40,-6.92,-6.72,-7.71,-8.25,-8.13,-7.20,-6.30,-5.80,-5.61,-5.62,-5.78,-6.09,-6.36,-6.74,-6.98,-7.34,-7.73,-8.14,-8.67,-9.09,-9.41,-9.71,-9.96,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-12,-12,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-11,-11,-10,-10,-9.73,-9.03,-8.46,-7.85,-7.54,-7.38,4.88,4.59,4.17,3.85,3.73,3.64,3.61,3.59,3.61,3.65,3.73,3.77,3.83,3.79,3.75,3.64,3.58,3.52,3.51,3.51,3.54,3.62,3.78,4.02,4.32,4.62,4.95,5.22,5.42,5.58,5.64,5.65,5.62,5.48,5.29,5.11,4.89,4.71,4.58,4.49,4.42,4.42,4.47,4.52,4.62,4.67,4.74,4.74,4.71,4.63,4.52,4.41,4.28,4.17,4.09,4,3.91,3.86,3.77,3.71,3.62,3.53,3.48,3.42,3.40,3.41,3.46,3.51,3.60,3.66,3.75,3.79,3.85,3.88,3.91,3.95,3.96,3.96,3.97,3.97,3.97,3.97,3.96,3.91,3.88,3.84,3.75,3.65,3.52,3.39,3.26,3.13,3,2.88,2.75,2.62,2.50,2.37,2.24,2.12,2.02,1.97,1.92,1.89,1.88,1.87,1.87,1.85,1.83,1.77,1.73,1.67,1.62,1.57,1.50,1.47,1.45,1.42,1.42,1.42,1.39,1.35,1.26,1.17,1.11,1.07,1.01,1,0.98,0.98,0.97,0.97,0.97,0.96,0.96,0.96,0.97,0.97,0.98,0.98,0.98,0.97,0.92,0.87,0.74,0.53,0.35,0.46,0.62,0.73,0.42,0.14,0.03,0.03,0.08,0.09,0.08,0.07,0.03,0.02,0,0,0,0,0.02,0.07,0.10,0.12,0.12,0.12,0.11,0.09,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.12,0.22,0.23,0.08,-0.13,-0.36,-0.63,-0.93,-0.92,-0.18,0.20,0.41,0.45,0.36,0.24,0.14,0.11,0.09,0.09,0.04,0.02,-0.05,-0.13,-0.27,-0.54,-0.88,-1.18,-1.41,-2.26,-4.59,-5.43,-4.14,-4.20,-4.82,-4.60,-4.61,-4.51,-4.40,-4.37,-4.48,-4.76,-5.20,-5.70,-6.20,-6.65,-6.86,-7.07,-7.26,-7.36,-7.74,-8.21,-8.68,-9.11,-9.47,-9.88,-10,-10,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.77,-9.09,-8.50,-7.93,-7.43,-7.27,5.73,5.35,4.78,4.37,4.14,4.08,4.04,4.08,4.12,4.21,4.27,4.35,4.37,4.37,4.26,4.12,3.99,3.87,3.82,3.79,3.83,3.91,4.10,4.34,4.62,4.90,5.20,5.42,5.61,5.70,5.72,5.65,5.58,5.36,5.15,4.95,4.74,4.57,4.42,4.34,4.27,4.26,4.29,4.37,4.45,4.51,4.59,4.61,4.59,4.53,4.46,4.37,4.26,4.16,4.10,4.02,3.97,3.90,3.86,3.78,3.72,3.64,3.58,3.51,3.49,3.49,3.50,3.57,3.62,3.70,3.75,3.82,3.86,3.88,3.90,3.95,3.96,3.96,3.97,3.97,3.97,3.97,3.96,3.92,3.89,3.86,3.79,3.72,3.61,3.49,3.37,3.25,3.12,3,2.88,2.76,2.62,2.50,2.36,2.24,2.12,2.04,2,1.96,1.92,1.91,1.90,1.88,1.87,1.85,1.83,1.78,1.75,1.72,1.67,1.65,1.64,1.63,1.62,1.61,1.57,1.48,1.37,1.26,1.17,1.12,1.07,1.02,1.01,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.98,0.98,0.95,0.87,0.74,0.63,0.64,0.75,0.79,0.64,0.47,0.36,0.28,0.25,0.21,0.20,0.15,0.12,0.10,0.04,0.02,0,0,0,0.02,0.03,0.03,0.03,0.03,0.03,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.11,0.17,0.24,0.17,0.09,-0.08,-0.27,-0.43,-0.38,-0.10,0.20,0.33,0.29,0.22,0.12,0.07,0.03,0.03,0.04,0.07,0.04,0.04,0.04,-0.02,-0.17,-0.38,-0.60,-0.74,-0.80,-1.57,-1.58,-1.70,-1.72,-1.65,-1.66,-0.99,-1.48,-2.36,-2.80,-3.23,-3.86,-4.66,-5.52,-6.32,-6.89,-7.13,-7.16,-7.08,-6.83,-7.05,-7.47,-7.98,-8.49,-8.99,-9.40,-9.97,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-9.76,-9.12,-8.54,-7.99,-7.46,-7.16,6.16,5.71,5.15,4.75,4.50,4.47,4.45,4.48,4.52,4.60,4.64,4.71,4.74,4.72,4.62,4.46,4.26,4.12,4.01,3.99,4.01,4.14,4.35,4.60,4.87,5.14,5.39,5.59,5.70,5.72,5.66,5.54,5.39,5.15,4.96,4.75,4.58,4.41,4.29,4.22,4.15,4.14,4.17,4.24,4.32,4.38,4.45,4.48,4.48,4.45,4.37,4.32,4.24,4.16,4.12,4.07,4.01,3.98,3.91,3.87,3.79,3.74,3.66,3.62,3.59,3.57,3.58,3.61,3.65,3.72,3.76,3.83,3.87,3.88,3.91,3.92,3.96,3.96,3.97,3.97,3.97,3.97,3.97,3.95,3.91,3.88,3.84,3.76,3.66,3.57,3.47,3.35,3.24,3.12,3,2.87,2.75,2.61,2.46,2.33,2.21,2.11,2.03,2,1.97,1.96,1.92,1.91,1.90,1.89,1.87,1.87,1.85,1.83,1.82,1.78,1.78,1.77,1.76,1.74,1.67,1.60,1.48,1.36,1.25,1.17,1.12,1.10,1.08,1.07,1.07,1.07,1.08,1.08,1.08,1.08,1.08,1.07,1.04,1.03,1.02,1.02,1.02,1.01,0.99,0.91,0.86,0.83,0.87,0.90,0.84,0.74,0.66,0.60,0.51,0.42,0.36,0.34,0.27,0.21,0.13,0.08,0.03,0.02,0.01,0.01,0.01,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.17,0.22,0.28,0.20,0.09,0,0.01,0.08,0.16,0.21,0.17,0.12,0.04,0.01,0,0,0.01,0.02,0.03,0.07,0.08,0.08,0.01,-0.08,-0.15,-0.23,-0.25,-0.25,-0.23,-0.23,-0.24,-0.24,-0.25,-0.25,-0.25,-0.83,-1.29,-1.96,-2.95,-4.26,-5.61,-6.79,-7.52,-7.76,-7.51,-7.14,-6.70,-6.86,-7.10,-7.57,-8.13,-9.17,-9.76,-10,-10,-10,-11,-11,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-9.77,-9.09,-8.55,-7.98,-7.43,-7.05,6.13,5.82,5.40,5.09,4.87,4.76,4.73,4.75,4.77,4.82,4.86,4.88,4.90,4.87,4.78,4.62,4.45,4.26,4.13,4.11,4.15,4.33,4.53,4.79,5.08,5.34,5.52,5.65,5.70,5.64,5.52,5.36,5.14,4.91,4.73,4.54,4.40,4.27,4.20,4.12,4.09,4.08,4.10,4.14,4.21,4.26,4.33,4.36,4.36,4.34,4.29,4.25,4.22,4.16,4.13,4.11,4.08,4.02,3.99,3.92,3.87,3.83,3.75,3.71,3.66,3.64,3.64,3.66,3.71,3.75,3.79,3.84,3.87,3.89,3.91,3.92,3.95,3.96,3.97,3.97,3.97,3.97,3.97,3.96,3.92,3.90,3.87,3.83,3.74,3.64,3.57,3.45,3.35,3.23,3.12,2.99,2.85,2.70,2.53,2.39,2.26,2.15,2.09,2.02,2,1.98,1.96,1.95,1.95,1.92,1.91,1.91,1.90,1.89,1.88,1.88,1.87,1.87,1.86,1.83,1.76,1.67,1.54,1.45,1.36,1.27,1.23,1.17,1.15,1.15,1.15,1.16,1.17,1.20,1.20,1.20,1.20,1.17,1.16,1.15,1.14,1.15,1.15,1.14,1.13,1.10,1.03,1,0.98,0.97,0.96,0.92,0.89,0.83,0.75,0.70,0.63,0.58,0.48,0.37,0.25,0.16,0.12,0.09,0.09,0.08,0.07,0.03,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.07,0.11,0.14,0.17,0.21,0.17,0.17,0.17,0.12,0.12,0.12,0.09,0.03,0,0,0,0,0,0,0,0.02,0.04,0.07,0.08,0.04,0.03,0.03,0.03,0.07,0.08,0.08,0.07,0.07,0.04,0.04,0.04,-0.07,-0.46,-1.16,-2.37,-4.10,-6.01,-7.63,-8.89,-8.66,-7.92,-7.33,-6.84,-7,-7.33,-7.85,-8.61,-9.53,-10,-11,-11,-10,-11,-11,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-16,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-9.79,-9.09,-8.51,-7.97,-7.41,-6.97,5.92,5.77,5.54,5.33,5.13,5,4.90,4.89,4.90,4.91,4.95,4.97,4.97,4.95,4.86,4.72,4.52,4.35,4.22,4.20,4.26,4.46,4.70,4.96,5.23,5.45,5.60,5.65,5.62,5.50,5.34,5.12,4.87,4.67,4.51,4.38,4.26,4.16,4.11,4.07,4.02,4.02,4.03,4.09,4.12,4.17,4.22,4.25,4.25,4.25,4.24,4.22,4.20,4.17,4.16,4.14,4.12,4.10,4.03,4,3.95,3.88,3.84,3.78,3.75,3.74,3.73,3.74,3.75,3.78,3.83,3.86,3.88,3.90,3.91,3.92,3.95,3.96,3.97,3.97,3.97,3.98,3.97,3.97,3.95,3.92,3.89,3.87,3.79,3.73,3.64,3.53,3.45,3.34,3.22,3.08,2.92,2.76,2.62,2.47,2.33,2.22,2.12,2.07,2.01,2,1.98,1.97,1.97,1.96,1.96,1.96,1.96,1.96,1.96,1.95,1.95,1.92,1.90,1.87,1.83,1.75,1.63,1.53,1.46,1.38,1.34,1.29,1.28,1.28,1.29,1.32,1.34,1.35,1.36,1.36,1.36,1.36,1.36,1.35,1.35,1.36,1.36,1.36,1.34,1.28,1.24,1.15,1.10,1.04,1.01,1.01,1,1,0.97,0.91,0.88,0.85,0.74,0.59,0.42,0.33,0.25,0.22,0.21,0.20,0.15,0.12,0.09,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0,0,0,0.01,0.01,0.02,0.01,0.01,0,0,0,0,0,0,0,0.01,0.01,0.01,0.01,0,0,0,0,0.01,0.01,0.02,0.03,0.07,0.10,0.11,0.12,0.12,0.09,0.08,0.04,0.02,0,0,0,0,0,0,0,0,0,0.01,0.02,0.04,0.07,0.08,0.07,0.09,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.09,0.05,-0.23,-1.72,-3.77,-6.43,-9.63,-10,-9.17,-8.10,-7.38,-7.01,-7.11,-7.48,-8.02,-8.80,-9.84,-11,-12,-12,-11,-11,-11,-12,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.75,-9.13,-8.47,-7.86,-7.33,-6.88,5.75,5.72,5.61,5.50,5.29,5.12,5,4.98,4.97,4.97,4.98,4.98,4.98,4.95,4.87,4.75,4.57,4.38,4.25,4.25,4.35,4.54,4.77,5.04,5.29,5.49,5.59,5.59,5.49,5.32,5.10,4.85,4.62,4.47,4.36,4.25,4.15,4.10,4.04,4.01,4,4,4.01,4.03,4.07,4.10,4.12,4.14,4.15,4.16,4.16,4.16,4.17,4.20,4.21,4.21,4.17,4.14,4.10,4.04,4,3.95,3.88,3.86,3.83,3.79,3.78,3.79,3.82,3.84,3.86,3.87,3.89,3.90,3.91,3.92,3.95,3.95,3.97,3.97,3.97,3.98,3.97,3.97,3.96,3.95,3.91,3.89,3.85,3.78,3.73,3.62,3.53,3.42,3.29,3.15,3,2.85,2.67,2.52,2.38,2.26,2.16,2.11,2.07,2.02,2,1.99,1.99,1.99,1.99,2,2,2,2,2,1.99,1.98,1.96,1.91,1.87,1.82,1.73,1.63,1.57,1.50,1.47,1.45,1.42,1.42,1.46,1.48,1.50,1.52,1.53,1.54,1.54,1.54,1.57,1.58,1.58,1.59,1.59,1.58,1.54,1.50,1.45,1.35,1.24,1.15,1.12,1.12,1.12,1.13,1.13,1.12,1.12,1.09,0.99,0.85,0.70,0.51,0.42,0.42,0.40,0.37,0.32,0.24,0.16,0.12,0.09,0.08,0.08,0.09,0.08,0.07,0.04,0.03,0.03,0.04,0.07,0.09,0.09,0.08,0.07,0.04,0.03,0.03,0.04,0.04,0.04,0.04,0.04,0.07,0.07,0.07,0.04,0.04,0.04,0.04,0.03,0.03,0.02,0.02,0.02,0.02,0.01,0.01,0,0.02,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.01,0.02,0.03,0.03,0.03,0.03,0.03,0.03,0.03,0.03,0.03,0.08,0.10,0.11,-0.03,-0.82,-3.34,-6.10,-9.29,-9.51,-8.75,-7.78,-7.05,-6.90,-7.07,-7.42,-7.90,-8.59,-9.59,-11,-13,-13,-12,-11,-10,-11,-12,-12,-12,-12,-12,-12,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.72,-9.11,-8.46,-7.75,-7.23,-6.76,5.52,5.50,5.48,5.42,5.27,5.12,5.03,5,4.99,4.98,4.98,4.98,4.97,4.95,4.87,4.74,4.57,4.38,4.26,4.26,4.37,4.58,4.79,5.04,5.27,5.45,5.48,5.41,5.27,5.08,4.84,4.61,4.39,4.29,4.22,4.13,4.08,4.03,4.01,4,4,4,4,4,4.01,4.03,4.07,4.08,4.10,4.11,4.12,4.13,4.16,4.21,4.23,4.24,4.23,4.20,4.13,4.09,4.02,3.99,3.95,3.90,3.87,3.87,3.86,3.86,3.86,3.87,3.87,3.89,3.90,3.91,3.92,3.92,3.95,3.95,3.96,3.97,3.98,3.98,3.97,3.97,3.97,3.96,3.95,3.91,3.88,3.84,3.78,3.71,3.62,3.50,3.38,3.24,3.08,2.90,2.75,2.59,2.45,2.33,2.24,2.15,2.11,2.08,2.04,2.02,2.02,2.02,2.03,2.04,2.07,2.07,2.07,2.07,2.03,2,1.98,1.95,1.90,1.86,1.78,1.73,1.66,1.63,1.61,1.59,1.59,1.59,1.61,1.63,1.66,1.70,1.72,1.73,1.73,1.74,1.75,1.75,1.76,1.77,1.76,1.76,1.75,1.71,1.62,1.51,1.40,1.33,1.28,1.27,1.29,1.32,1.34,1.35,1.34,1.29,1.24,1.12,1,0.87,0.78,0.74,0.67,0.62,0.51,0.39,0.27,0.17,0.13,0.12,0.15,0.16,0.15,0.13,0.12,0.10,0.10,0.12,0.14,0.16,0.17,0.16,0.15,0.13,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.13,0.13,0.13,0.13,0.12,0.12,0.12,0.12,0.10,0.09,0.08,0.07,0.04,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.08,0.07,-0.02,-0.32,-2.52,-5,-7.10,-7.93,-7.58,-6.91,-6.47,-6.49,-6.72,-7.05,-7.42,-7.90,-8.64,-9.76,-11,-11,-11,-10,-9.78,-10,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-10,-10,-9.62,-9.01,-8.38,-7.67,-7.09,-6.62,5.28,5.28,5.27,5.24,5.15,5.09,5.02,5,4.99,4.98,4.98,4.98,4.96,4.91,4.84,4.71,4.52,4.36,4.25,4.24,4.35,4.51,4.74,4.96,5.14,5.27,5.28,5.21,5.02,4.83,4.60,4.39,4.24,4.16,4.12,4.07,4.02,4,4,4,4,4,4,4,4,4,4.01,4.02,4.03,4.07,4.09,4.12,4.15,4.21,4.24,4.25,4.25,4.23,4.16,4.12,4.07,4,3.98,3.95,3.91,3.90,3.89,3.89,3.89,3.90,3.90,3.90,3.91,3.91,3.92,3.92,3.95,3.95,3.96,3.97,3.98,3.98,3.98,3.97,3.97,3.96,3.96,3.92,3.90,3.87,3.85,3.76,3.67,3.59,3.46,3.32,3.14,2.98,2.82,2.64,2.51,2.39,2.29,2.23,2.16,2.13,2.11,2.10,2.10,2.10,2.12,2.12,2.13,2.14,2.14,2.12,2.09,2.03,2,1.98,1.95,1.89,1.86,1.79,1.76,1.75,1.73,1.72,1.72,1.73,1.75,1.77,1.79,1.84,1.85,1.86,1.86,1.87,1.87,1.88,1.89,1.89,1.89,1.88,1.87,1.85,1.77,1.67,1.59,1.50,1.48,1.48,1.50,1.51,1.54,1.57,1.54,1.52,1.49,1.40,1.32,1.23,1.13,1.08,1,0.91,0.79,0.65,0.50,0.37,0.32,0.34,0.35,0.35,0.33,0.29,0.25,0.23,0.23,0.24,0.27,0.32,0.33,0.29,0.28,0.26,0.25,0.24,0.23,0.24,0.24,0.24,0.24,0.25,0.25,0.25,0.25,0.25,0.25,0.24,0.23,0.21,0.17,0.15,0.13,0.12,0.10,0.07,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.04,-0.02,-0.16,-1.14,-3.25,-4.65,-5.46,-5.64,-5.58,-5.58,-5.76,-6.04,-6.36,-6.60,-6.84,-7.23,-7.87,-8.65,-9.27,-9.35,-8.61,-8.77,-9.68,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.53,-8.91,-8.25,-7.55,-6.90,-6.42,5.11,5.11,5.11,5.09,5.04,5.02,5,5,4.99,4.98,4.98,4.96,4.92,4.87,4.76,4.62,4.46,4.28,4.20,4.17,4.25,4.41,4.60,4.77,4.92,5.01,5.01,4.91,4.76,4.58,4.38,4.24,4.12,4.10,4.04,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4.01,4.02,4.04,4.10,4.13,4.20,4.24,4.25,4.25,4.23,4.17,4.12,4.08,4.02,4,3.98,3.96,3.95,3.95,3.95,3.92,3.92,3.92,3.92,3.92,3.92,3.92,3.92,3.95,3.95,3.96,3.97,3.98,3.98,3.98,3.98,3.97,3.97,3.96,3.96,3.92,3.90,3.88,3.82,3.74,3.63,3.51,3.37,3.21,3.03,2.87,2.73,2.60,2.48,2.38,2.32,2.25,2.23,2.21,2.20,2.20,2.20,2.22,2.24,2.25,2.25,2.24,2.21,2.14,2.09,2.02,1.99,1.97,1.92,1.89,1.87,1.85,1.84,1.83,1.82,1.83,1.84,1.86,1.87,1.89,1.91,1.92,1.95,1.95,1.95,1.95,1.96,1.96,1.96,1.96,1.96,1.95,1.91,1.87,1.82,1.75,1.67,1.64,1.65,1.70,1.72,1.74,1.75,1.75,1.74,1.70,1.64,1.59,1.52,1.42,1.37,1.32,1.23,1.11,0.96,0.78,0.63,0.59,0.58,0.57,0.54,0.52,0.50,0.46,0.40,0.39,0.40,0.46,0.49,0.50,0.48,0.45,0.41,0.39,0.38,0.37,0.37,0.37,0.37,0.38,0.39,0.40,0.40,0.40,0.40,0.39,0.39,0.37,0.36,0.33,0.29,0.25,0.23,0.20,0.14,0.11,0.08,0.03,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.04,0.01,-0.05,-0.16,-1.05,-2.47,-3.24,-3.80,-4.17,-4.48,-4.77,-5.16,-5.33,-5.48,-5.51,-5.60,-5.83,-6.49,-7.38,-7.97,-7.92,-7.98,-8.52,-9.37,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-13,-13,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.89,-9.36,-8.76,-8.13,-7.38,-6.80,-6.23,5.01,5.01,5.01,5,5,5,5,4.99,4.98,4.98,4.96,4.92,4.87,4.78,4.66,4.51,4.36,4.22,4.12,4.11,4.15,4.28,4.42,4.58,4.67,4.74,4.73,4.63,4.50,4.37,4.23,4.12,4.08,4.03,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.02,4.08,4.12,4.16,4.22,4.24,4.24,4.22,4.16,4.12,4.08,4.02,4,3.99,3.98,3.98,3.97,3.97,3.97,3.96,3.96,3.95,3.95,3.92,3.92,3.92,3.95,3.95,3.96,3.97,3.98,3.98,3.98,3.98,3.98,3.97,3.97,3.96,3.96,3.95,3.90,3.87,3.77,3.67,3.57,3.40,3.25,3.10,2.95,2.79,2.66,2.57,2.49,2.41,2.37,2.34,2.32,2.29,2.32,2.33,2.34,2.36,2.37,2.37,2.34,2.27,2.21,2.12,2.07,2,1.98,1.96,1.92,1.90,1.89,1.88,1.88,1.88,1.88,1.89,1.91,1.95,1.97,1.99,2,2,2,1.99,1.99,1.98,1.99,1.98,1.98,1.98,1.97,1.96,1.92,1.89,1.85,1.82,1.79,1.82,1.83,1.85,1.86,1.87,1.87,1.87,1.85,1.82,1.77,1.72,1.66,1.62,1.54,1.49,1.38,1.25,1.10,0.96,0.87,0.83,0.78,0.77,0.75,0.72,0.65,0.62,0.60,0.61,0.63,0.65,0.65,0.65,0.62,0.59,0.57,0.54,0.53,0.53,0.53,0.54,0.57,0.58,0.59,0.60,0.60,0.60,0.60,0.59,0.57,0.52,0.50,0.47,0.41,0.37,0.33,0.26,0.21,0.13,0.10,0.08,0.07,0.07,0.04,0.04,0.04,0.03,0.02,0.02,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.03,0.03,0.01,-0.01,-0.09,-0.61,-1.41,-2.23,-2.83,-3.28,-3.61,-3.83,-4.01,-4.13,-4.07,-3.92,-3.91,-4.66,-6.13,-7.33,-7.74,-7.18,-8.13,-8.33,-9.21,-10,-10,-11,-11,-11,-10,-10,-10,-11,-11,-12,-12,-13,-14,-14,-15,-15,-15,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-10,-10,-9.68,-9.14,-8.53,-7.89,-7.21,-6.63,-6,5,5,5,5,5,5,4.99,4.98,4.98,4.96,4.92,4.87,4.78,4.67,4.53,4.38,4.25,4.13,4.08,4.04,4.09,4.17,4.27,4.37,4.45,4.48,4.46,4.38,4.29,4.21,4.12,4.04,4.02,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.01,4.04,4.10,4.13,4.17,4.21,4.21,4.17,4.14,4.12,4.08,4.03,4.01,4,4,4,3.99,3.99,3.99,3.98,3.97,3.96,3.95,3.95,3.95,3.95,3.95,3.95,3.96,3.97,3.98,3.98,3.98,3.98,3.98,3.98,3.97,3.97,3.97,3.96,3.92,3.88,3.82,3.72,3.60,3.46,3.29,3.14,3,2.87,2.75,2.65,2.59,2.52,2.49,2.47,2.45,2.45,2.45,2.46,2.48,2.49,2.49,2.48,2.42,2.36,2.25,2.15,2.09,2.01,1.99,1.97,1.96,1.95,1.92,1.92,1.92,1.92,1.92,1.95,1.97,1.99,2,2.01,2.01,2.01,2.01,2,2,1.99,1.99,1.99,1.99,1.99,1.98,1.98,1.97,1.96,1.91,1.90,1.90,1.89,1.91,1.92,1.95,1.95,1.96,1.95,1.95,1.91,1.87,1.86,1.84,1.78,1.75,1.70,1.62,1.51,1.37,1.23,1.12,1.07,1.01,0.99,0.97,0.91,0.87,0.85,0.82,0.79,0.82,0.83,0.83,0.79,0.77,0.75,0.73,0.72,0.71,0.71,0.72,0.73,0.75,0.76,0.78,0.79,0.79,0.82,0.79,0.78,0.76,0.74,0.71,0.65,0.62,0.57,0.50,0.41,0.34,0.25,0.21,0.16,0.15,0.14,0.14,0.14,0.13,0.12,0.12,0.10,0.10,0.08,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.03,0.01,0,-0.03,-0.41,-0.80,-1.46,-1.85,-2.13,-2.33,-2.46,-2.67,-2.60,-2.32,-2.27,-3.14,-5.11,-7.96,-7.87,-7.83,-7.90,-8.40,-9.21,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-13,-14,-14,-15,-15,-15,-14,-14,-15,-15,-15,-15,-15,-15,-14,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.97,-9.46,-8.89,-8.28,-7.64,-7.01,-6.41,-5.77,5,5,5,5,5,4.99,4.98,4.98,4.96,4.92,4.87,4.78,4.67,4.53,4.39,4.25,4.14,4.08,4.02,4.02,4.04,4.12,4.16,4.23,4.25,4.25,4.24,4.21,4.14,4.10,4.03,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.02,4.08,4.11,4.13,4.15,4.16,4.15,4.13,4.11,4.09,4.04,4.02,4.01,4,4,4,4,4,3.99,3.98,3.97,3.96,3.95,3.95,3.95,3.95,3.96,3.96,3.97,3.98,3.99,3.99,3.98,3.98,3.98,3.98,3.97,3.98,3.98,3.96,3.90,3.84,3.74,3.62,3.50,3.35,3.21,3.08,2.96,2.85,2.75,2.70,2.64,2.61,2.59,2.59,2.59,2.59,2.60,2.61,2.62,2.61,2.58,2.50,2.40,2.29,2.17,2.10,2.02,2,1.98,1.97,1.97,1.97,1.96,1.96,1.96,1.97,1.97,1.99,2,2.01,2.02,2.02,2.02,2.01,2,2,2,2,1.99,1.99,1.99,1.99,2,2,1.99,1.99,1.99,1.99,2,2,2,2,2,2.01,2,2,2,1.98,1.97,1.92,1.89,1.87,1.84,1.77,1.71,1.59,1.45,1.35,1.27,1.23,1.17,1.15,1.12,1.10,1.07,1.01,1,1,0.99,0.98,0.97,0.95,0.90,0.88,0.87,0.86,0.86,0.87,0.89,0.92,0.97,1,1.01,1.03,1.02,1.02,1,0.99,0.96,0.90,0.87,0.82,0.75,0.66,0.59,0.49,0.39,0.34,0.29,0.28,0.28,0.28,0.28,0.27,0.25,0.25,0.23,0.21,0.16,0.12,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.01,0.01,0.01,0.01,0.02,0.01,-0.03,-0.54,-0.62,-0.68,-0.88,-1.11,-1.11,-0.66,-0.74,-1.02,-3.54,-5.48,-6.92,-7.48,-7.73,-8.24,-9.03,-9.77,-9.85,-9.77,-10,-10,-10,-9.99,-9.83,-9.87,-10,-10,-11,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-10,-10,-9.79,-9.17,-8.59,-8,-7.33,-6.73,-6.14,-5.52,5,5,5,5,5,4.99,4.98,4.96,4.92,4.87,4.78,4.67,4.54,4.39,4.25,4.14,4.08,4.02,4.01,4.02,4.07,4.10,4.12,4.12,4.13,4.12,4.11,4.09,4.04,4.02,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.01,4.03,4.08,4.11,4.12,4.13,4.13,4.12,4.12,4.10,4.08,4.04,4.02,4.02,4.01,4.01,4,4,3.99,3.98,3.97,3.96,3.96,3.96,3.96,3.96,3.96,3.96,3.97,3.98,3.99,3.99,3.99,3.98,3.98,3.98,3.98,3.98,3.98,3.96,3.91,3.86,3.75,3.64,3.52,3.39,3.26,3.13,3.02,2.92,2.86,2.79,2.75,2.73,2.72,2.71,2.71,2.72,2.72,2.73,2.72,2.71,2.64,2.58,2.46,2.33,2.21,2.11,2.03,2,1.99,1.99,1.99,1.99,1.99,1.99,1.99,1.99,1.99,2,2,2.01,2.02,2.02,2.02,2.02,2.01,2,2,2,2,2,2,2,2.02,2.03,2.07,2.07,2.08,2.09,2.09,2.10,2.10,2.10,2.10,2.10,2.10,2.10,2.10,2.08,2.04,2.02,1.99,1.96,1.90,1.86,1.77,1.70,1.60,1.51,1.46,1.40,1.37,1.35,1.32,1.28,1.25,1.23,1.21,1.17,1.16,1.14,1.12,1.10,1.07,1.02,1,0.99,1,1.01,1.07,1.12,1.16,1.23,1.24,1.25,1.26,1.25,1.24,1.21,1.16,1.12,1.07,1,0.91,0.84,0.74,0.63,0.54,0.49,0.46,0.45,0.46,0.47,0.47,0.46,0.45,0.41,0.39,0.36,0.29,0.23,0.15,0.10,0.04,0.01,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0.02,0,-0.02,-0.13,-0.17,-0.21,-0.22,-0.23,-0.30,-0.59,-1.05,-3.82,-5.59,-6.68,-7.27,-7.92,-8.72,-9.38,-9.47,-8.91,-9.40,-9.71,-9.74,-9.63,-9.42,-9.13,-9.50,-10,-11,-12,-13,-13,-14,-15,-15,-15,-16,-16,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.71,-9.13,-8.46,-7.75,-7.04,-6.46,-5.86,-5.27,5,5,5,5,4.99,4.98,4.97,4.92,4.87,4.78,4.67,4.54,4.39,4.25,4.14,4.08,4.02,4.01,4.02,4.07,4.11,4.12,4.12,4.10,4.08,4.04,4.02,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.02,4.04,4.08,4.10,4.12,4.12,4.12,4.12,4.11,4.09,4.08,4.04,4.03,4.02,4.01,4,4,3.99,3.98,3.97,3.97,3.96,3.96,3.96,3.96,3.96,3.97,3.97,3.99,3.99,3.99,3.99,3.99,3.98,3.99,3.98,3.99,3.98,3.97,3.92,3.87,3.77,3.70,3.58,3.47,3.34,3.23,3.12,3.02,2.96,2.89,2.86,2.83,2.82,2.82,2.82,2.83,2.83,2.82,2.79,2.76,2.72,2.62,2.49,2.35,2.22,2.12,2.04,2.01,2,2,2,2.01,2.01,2.01,2,2,2,2,2,2.01,2.02,2.03,2.03,2.02,2.02,2.01,2.01,2.01,2.02,2.02,2.04,2.07,2.10,2.12,2.15,2.17,2.20,2.21,2.22,2.22,2.22,2.22,2.22,2.22,2.22,2.22,2.21,2.20,2.15,2.12,2.08,2.02,1.99,1.92,1.87,1.79,1.74,1.66,1.62,1.58,1.53,1.51,1.50,1.48,1.45,1.40,1.38,1.36,1.34,1.33,1.28,1.25,1.22,1.16,1.13,1.12,1.13,1.16,1.23,1.28,1.36,1.40,1.46,1.47,1.48,1.48,1.46,1.40,1.37,1.32,1.25,1.16,1.09,0.99,0.87,0.77,0.71,0.63,0.61,0.61,0.62,0.62,0.63,0.62,0.62,0.61,0.60,0.52,0.47,0.37,0.28,0.21,0.13,0.09,0.07,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.01,0.01,0.01,0,0,0,0.01,0,-0.10,-0.35,-0.75,-2.54,-4.23,-5.65,-6.57,-7.41,-8.29,-8.98,-9.17,-8.57,-8.66,-9.13,-9.35,-9.33,-9.13,-8.89,-9.11,-9.76,-10,-11,-12,-13,-14,-15,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9.68,-9.10,-8.43,-7.66,-7.03,-6.50,-5.89,-5.22,5,5,5,4.99,4.99,4.98,4.95,4.87,4.79,4.67,4.54,4.39,4.26,4.14,4.08,4.02,4,4.01,4.07,4.12,4.15,4.16,4.13,4.10,4.04,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.02,4.07,4.09,4.11,4.12,4.12,4.12,4.12,4.11,4.09,4.07,4.03,4.02,4,4,4,3.99,3.98,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.99,3.99,4,3.99,3.99,3.99,3.99,3.99,3.98,3.98,3.98,3.96,3.88,3.83,3.73,3.62,3.52,3.41,3.32,3.22,3.12,3.03,2.99,2.92,2.90,2.89,2.89,2.89,2.89,2.88,2.88,2.87,2.83,2.75,2.63,2.50,2.37,2.24,2.12,2.07,2.03,2.02,2.04,2.07,2.08,2.08,2.08,2.07,2.04,2.04,2.03,2.03,2.03,2.04,2.04,2.07,2.07,2.07,2.08,2.08,2.09,2.10,2.11,2.13,2.16,2.22,2.25,2.29,2.33,2.35,2.36,2.37,2.37,2.37,2.37,2.37,2.37,2.37,2.36,2.35,2.32,2.26,2.23,2.16,2.12,2.07,2,1.95,1.88,1.84,1.78,1.75,1.72,1.70,1.66,1.64,1.62,1.61,1.58,1.53,1.51,1.50,1.49,1.46,1.41,1.37,1.33,1.28,1.27,1.27,1.32,1.37,1.45,1.51,1.59,1.62,1.65,1.66,1.64,1.62,1.61,1.57,1.50,1.40,1.32,1.22,1.11,1,0.89,0.83,0.77,0.75,0.75,0.75,0.76,0.77,0.77,0.77,0.76,0.75,0.70,0.63,0.54,0.47,0.37,0.27,0.21,0.14,0.10,0.07,0.03,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.01,0.02,0.03,0.04,0.07,0,-0.16,-0.50,-1.70,-3.14,-4.55,-5.74,-6.83,-7.99,-9.10,-9.51,-9.02,-8.02,-8.64,-9.02,-9.13,-9.03,-8.93,-8.99,-9.29,-9.97,-10,-11,-12,-13,-15,-16,-17,-17,-17,-17,-16,-15,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.73,-9.13,-8.49,-7.75,-7.12,-6.53,-5.91,-5.27,5,5,4.99,4.99,4.99,4.96,4.90,4.82,4.70,4.57,4.41,4.27,4.15,4.08,4.02,4,4,4.02,4.09,4.15,4.22,4.22,4.16,4.10,4.04,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.01,4.03,4.07,4.10,4.12,4.12,4.13,4.12,4.12,4.10,4.07,4.03,4.01,4,4,3.99,3.98,3.98,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.98,3.99,3.99,4,4,4,4,4,3.99,3.99,3.98,3.98,3.96,3.91,3.86,3.77,3.70,3.61,3.50,3.40,3.32,3.22,3.12,3.07,3,2.98,2.96,2.96,2.96,2.95,2.95,2.91,2.89,2.85,2.76,2.65,2.51,2.37,2.25,2.14,2.10,2.09,2.10,2.12,2.14,2.15,2.15,2.15,2.14,2.13,2.12,2.11,2.10,2.10,2.10,2.11,2.12,2.12,2.14,2.16,2.17,2.20,2.22,2.24,2.27,2.33,2.37,2.42,2.47,2.50,2.51,2.51,2.52,2.52,2.52,2.52,2.53,2.53,2.51,2.50,2.49,2.46,2.39,2.35,2.27,2.21,2.13,2.09,2.01,1.98,1.92,1.88,1.86,1.84,1.82,1.79,1.77,1.75,1.74,1.71,1.67,1.65,1.64,1.62,1.60,1.57,1.51,1.48,1.45,1.42,1.45,1.47,1.51,1.59,1.64,1.72,1.75,1.78,1.79,1.79,1.78,1.76,1.71,1.64,1.57,1.45,1.33,1.21,1.09,0.99,0.91,0.87,0.86,0.87,0.86,0.87,0.87,0.87,0.87,0.87,0.87,0.83,0.77,0.72,0.63,0.57,0.48,0.37,0.29,0.23,0.16,0.12,0.09,0.04,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.07,0.07,-0.03,-0.28,-1.09,-2.23,-3.63,-4.96,-6.29,-7.75,-9.33,-10,-9.75,-7.33,-8.05,-8.59,-8.89,-9.01,-9.03,-9.08,-9.15,-9.46,-9.96,-10,-11,-13,-15,-16,-17,-17,-17,-17,-16,-15,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.72,-9.13,-8.50,-7.79,-7.18,-6.50,-5.88,-5.27,5,4.99,4.99,4.99,4.97,4.92,4.84,4.72,4.60,4.47,4.33,4.20,4.10,4.03,4,4,4,4.03,4.10,4.14,4.17,4.17,4.13,4.09,4.03,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.02,4.04,4.09,4.11,4.12,4.12,4.12,4.12,4.09,4.07,4.02,4.01,4,4,3.99,3.98,3.98,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.98,3.98,3.99,4,4,4,4,4,3.99,3.99,3.99,3.99,3.98,3.97,3.95,3.89,3.83,3.75,3.67,3.60,3.50,3.40,3.32,3.22,3.12,3.07,3.01,2.99,2.98,2.98,2.98,2.97,2.96,2.91,2.87,2.77,2.66,2.52,2.38,2.26,2.17,2.13,2.13,2.16,2.22,2.25,2.26,2.27,2.26,2.25,2.24,2.23,2.21,2.20,2.17,2.17,2.20,2.22,2.25,2.27,2.32,2.34,2.37,2.38,2.41,2.46,2.50,2.57,2.62,2.63,2.65,2.66,2.67,2.67,2.67,2.67,2.67,2.67,2.67,2.65,2.64,2.62,2.59,2.52,2.47,2.38,2.32,2.24,2.15,2.11,2.04,2,1.97,1.95,1.90,1.89,1.88,1.87,1.85,1.83,1.79,1.78,1.76,1.75,1.74,1.72,1.67,1.64,1.62,1.60,1.59,1.60,1.62,1.65,1.72,1.76,1.82,1.86,1.87,1.88,1.88,1.87,1.87,1.84,1.77,1.70,1.58,1.42,1.27,1.14,1.04,0.98,0.95,0.91,0.91,0.91,0.92,0.91,0.92,0.92,0.95,0.95,0.89,0.87,0.84,0.78,0.73,0.64,0.57,0.48,0.39,0.34,0.25,0.20,0.12,0.08,0.04,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.08,0,-0.16,-0.68,-1.57,-2.83,-4.25,-5.78,-7.42,-9.22,-10,-10,-7.70,-7.46,-8.13,-8.65,-9,-9.14,-9.18,-9.24,-9.30,-9.48,-10,-11,-12,-14,-16,-17,-17,-17,-17,-16,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.62,-9.08,-8.41,-7.80,-7.16,-6.50,-5.79,-5.23,4.99,4.99,4.99,4.97,4.92,4.87,4.75,4.64,4.53,4.41,4.28,4.16,4.09,4.01,4,4,4,4.02,4.08,4.12,4.15,4.13,4.11,4.08,4.02,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.01,4.03,4.07,4.10,4.12,4.12,4.12,4.10,4.08,4.04,4.02,4,4,3.99,3.99,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.99,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.96,3.91,3.87,3.82,3.75,3.67,3.61,3.51,3.40,3.29,3.20,3.11,3.03,3,3,2.99,2.98,2.98,2.96,2.91,2.87,2.78,2.67,2.53,2.40,2.29,2.23,2.21,2.23,2.27,2.35,2.38,2.40,2.41,2.40,2.39,2.37,2.36,2.34,2.32,2.29,2.29,2.33,2.36,2.38,2.45,2.49,2.51,2.54,2.58,2.61,2.63,2.67,2.73,2.76,2.77,2.78,2.79,2.79,2.79,2.79,2.79,2.78,2.78,2.77,2.76,2.75,2.74,2.70,2.64,2.58,2.50,2.41,2.34,2.25,2.20,2.12,2.08,2.02,2,1.98,1.96,1.95,1.91,1.90,1.88,1.87,1.87,1.86,1.85,1.84,1.82,1.77,1.75,1.75,1.73,1.73,1.73,1.75,1.77,1.82,1.85,1.88,1.90,1.92,1.92,1.92,1.92,1.91,1.89,1.85,1.75,1.63,1.49,1.34,1.21,1.10,1.01,0.98,0.97,0.96,0.97,0.96,0.96,0.96,0.96,0.97,0.97,0.96,0.92,0.90,0.88,0.86,0.79,0.74,0.65,0.59,0.50,0.41,0.34,0.25,0.15,0.12,0.08,0.03,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.04,0.03,-0.04,-0.27,-1.05,-2.14,-3.58,-5.16,-6.89,-8.60,-9.99,-9.95,-8.50,-6.91,-7.63,-8.42,-8.97,-9.22,-9.27,-9.33,-9.34,-9.30,-9.59,-10,-11,-13,-15,-16,-16,-16,-16,-15,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.49,-8.88,-8.29,-7.75,-7.12,-6.41,-5.64,-5.13,4.97,4.97,4.96,4.91,4.86,4.76,4.66,4.61,4.58,4.49,4.37,4.25,4.14,4.08,4.02,4,4,4.02,4.04,4.09,4.10,4.10,4.08,4.04,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.02,4.04,4.08,4.10,4.10,4.10,4.08,4.04,4.02,4,4,4,3.99,3.99,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.99,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.96,3.91,3.87,3.83,3.76,3.70,3.61,3.50,3.37,3.25,3.13,3.07,3.01,3,2.99,2.98,2.98,2.96,2.92,2.87,2.79,2.70,2.57,2.45,2.35,2.28,2.27,2.34,2.39,2.48,2.52,2.57,2.58,2.57,2.54,2.52,2.50,2.48,2.47,2.46,2.46,2.48,2.50,2.57,2.62,2.65,2.71,2.74,2.75,2.76,2.78,2.83,2.86,2.87,2.87,2.88,2.87,2.88,2.87,2.88,2.87,2.87,2.87,2.86,2.86,2.85,2.83,2.78,2.75,2.67,2.62,2.52,2.45,2.37,2.27,2.22,2.14,2.10,2.07,2.02,2,1.98,1.97,1.95,1.92,1.91,1.90,1.90,1.89,1.88,1.87,1.87,1.86,1.85,1.85,1.85,1.86,1.86,1.87,1.88,1.90,1.92,1.95,1.96,1.97,1.97,1.97,1.96,1.92,1.87,1.79,1.70,1.53,1.38,1.25,1.12,1.04,1,0.98,0.97,0.97,0.97,0.97,0.97,0.97,0.98,0.98,0.98,0.97,0.96,0.95,0.92,0.89,0.86,0.82,0.76,0.70,0.60,0.49,0.37,0.27,0.22,0.14,0.11,0.08,0.03,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.04,0.01,-0.08,-0.45,-1.35,-2.78,-4.41,-6.14,-7.82,-9.23,-10,-9.35,-7.71,-7.05,-8.03,-8.72,-9.05,-9.25,-9.37,-9.41,-9.39,-9.43,-9.80,-11,-12,-14,-15,-15,-15,-15,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-9.90,-9.33,-8.71,-8.17,-7.61,-6.99,-6.27,-5.59,-4.97,4.90,4.88,4.87,4.83,4.75,4.67,4.65,4.65,4.64,4.59,4.48,4.35,4.23,4.12,4.07,4.02,4.01,4.02,4.04,4.08,4.09,4.08,4.07,4.03,4.02,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.02,4.04,4.07,4.08,4.08,4.07,4.04,4.02,4.01,4,4,4,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.97,3.96,3.91,3.88,3.84,3.76,3.67,3.57,3.42,3.28,3.16,3.09,3.02,3,2.99,2.98,2.98,2.96,2.92,2.87,2.82,2.71,2.60,2.49,2.40,2.37,2.38,2.45,2.52,2.62,2.66,2.71,2.72,2.72,2.70,2.66,2.64,2.62,2.61,2.61,2.62,2.63,2.66,2.72,2.76,2.82,2.86,2.87,2.88,2.88,2.89,2.90,2.91,2.92,2.91,2.92,2.91,2.92,2.92,2.91,2.91,2.90,2.90,2.90,2.90,2.89,2.88,2.86,2.83,2.76,2.72,2.63,2.54,2.48,2.38,2.29,2.24,2.16,2.12,2.08,2.03,2.01,1.99,1.98,1.96,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.97,1.97,1.97,1.97,1.98,1.98,1.99,1.99,1.98,1.97,1.95,1.90,1.84,1.74,1.60,1.46,1.29,1.16,1.08,1.01,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.95,0.91,0.88,0.83,0.75,0.63,0.52,0.41,0.34,0.25,0.20,0.14,0.11,0.09,0.07,0.03,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.03,0,-0.12,-0.68,-1.74,-3.36,-5.16,-6.98,-8.76,-10,-10,-9.32,-7.20,-7.35,-8.12,-8.63,-9,-9.27,-9.46,-9.43,-9.43,-9.65,-10,-11,-12,-13,-14,-14,-13,-13,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.83,-9.24,-8.73,-8.11,-7.51,-6.87,-6.15,-5.59,-5,4.75,4.72,4.67,4.65,4.63,4.63,4.67,4.74,4.75,4.70,4.59,4.45,4.32,4.20,4.12,4.08,4.07,4.07,4.09,4.10,4.11,4.11,4.10,4.08,4.04,4.03,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.02,4.03,4.04,4.04,4.03,4.03,4.01,4,4,4,4,4,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.92,3.89,3.84,3.75,3.62,3.48,3.34,3.20,3.10,3.02,3,2.99,2.98,2.98,2.96,2.92,2.88,2.83,2.74,2.63,2.54,2.49,2.47,2.50,2.58,2.65,2.75,2.78,2.84,2.84,2.84,2.82,2.79,2.77,2.75,2.75,2.75,2.75,2.77,2.79,2.85,2.88,2.92,2.97,2.98,2.98,2.97,2.97,2.97,2.97,2.97,2.96,2.97,2.96,2.96,2.95,2.95,2.95,2.95,2.95,2.95,2.95,2.92,2.92,2.90,2.87,2.85,2.78,2.74,2.65,2.58,2.49,2.40,2.33,2.25,2.20,2.13,2.10,2.04,2.01,2,1.98,1.97,1.97,1.97,1.97,1.98,1.99,2,2.01,2.02,2.03,2.04,2.07,2.04,2.04,2.02,2.01,2,2,2,2,2,2,2,1.97,1.92,1.87,1.77,1.65,1.51,1.37,1.23,1.12,1.03,1,0.99,0.98,0.98,0.98,0.99,0.99,1,1,1.01,1.01,1.02,1.02,1.02,1.01,1,0.99,0.97,0.91,0.85,0.76,0.66,0.57,0.47,0.38,0.32,0.25,0.21,0.16,0.13,0.11,0.08,0.04,0.02,0.01,0,0,0,0,0,0,0,0,0,0.01,0.03,0.03,0,-0.13,-0.61,-1.90,-4.14,-6.50,-7.91,-10,-13,-11,-7.78,-6.47,-7.26,-8,-8.61,-9.05,-9.36,-9.47,-9.47,-9.37,-9.72,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.91,-9.46,-8.97,-8.38,-7.74,-7.12,-6.50,-5.89,-5.27,4.50,4.49,4.50,4.53,4.60,4.64,4.74,4.82,4.85,4.79,4.67,4.53,4.39,4.27,4.21,4.15,4.13,4.14,4.15,4.17,4.20,4.17,4.16,4.14,4.12,4.11,4.08,4.04,4.02,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.02,4.03,4.03,4.03,4.02,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.97,3.97,3.97,3.96,3.95,3.88,3.79,3.65,3.50,3.36,3.22,3.11,3.03,3,2.99,2.98,2.98,2.96,2.92,2.89,2.85,2.76,2.70,2.62,2.59,2.58,2.62,2.70,2.77,2.86,2.89,2.92,2.92,2.92,2.91,2.89,2.88,2.87,2.87,2.87,2.87,2.88,2.90,2.95,2.99,3,3.02,3.03,3.02,3,3,2.99,2.99,2.99,2.98,2.98,2.98,2.98,2.97,2.96,2.96,2.96,2.96,2.97,2.97,2.96,2.96,2.95,2.91,2.89,2.87,2.82,2.75,2.66,2.60,2.50,2.41,2.35,2.27,2.22,2.14,2.11,2.07,2.02,2,1.99,1.98,1.98,1.99,2,2.02,2.07,2.10,2.12,2.14,2.15,2.15,2.15,2.14,2.12,2.10,2.08,2.07,2.07,2.07,2.07,2.04,2.02,2,1.97,1.90,1.83,1.72,1.59,1.42,1.27,1.14,1.07,1,0.99,0.99,0.99,0.99,1,1,1.02,1.04,1.08,1.09,1.10,1.10,1.10,1.09,1.08,1.04,1.01,0.99,0.95,0.87,0.78,0.71,0.61,0.51,0.46,0.38,0.34,0.27,0.24,0.20,0.14,0.12,0.08,0.03,0.01,0,0,0,0,0,0,0,0,0,0.01,0.03,0.02,-0.03,-0.42,-1.62,-4,-6.53,-9.11,-12,-16,-13,-9.65,-6.97,-6.32,-7.40,-8.05,-8.65,-9.21,-9.47,-9.42,-9.37,-9.34,-9.66,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.76,-9.27,-8.74,-8.12,-7.39,-6.80,-6.24,-5.63,4.28,4.32,4.38,4.49,4.61,4.72,4.79,4.87,4.89,4.87,4.75,4.63,4.50,4.38,4.32,4.27,4.26,4.27,4.32,4.34,4.35,4.35,4.33,4.28,4.25,4.22,4.17,4.13,4.10,4.07,4.02,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.01,4.01,4.03,4.02,4.01,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.98,3.97,3.97,3.97,3.96,3.95,3.86,3.70,3.52,3.37,3.23,3.11,3.03,3,2.99,2.98,2.98,2.97,2.95,2.90,2.87,2.82,2.75,2.71,2.67,2.70,2.74,2.82,2.88,2.96,3,3.01,3.02,3.01,3,3,2.99,2.98,2.98,2.98,2.98,2.99,3,3.02,3.04,3.08,3.10,3.09,3.08,3.04,3.02,3.01,3,3,3,2.99,2.99,2.98,2.97,2.97,2.96,2.96,2.96,2.97,2.97,2.97,2.96,2.96,2.95,2.92,2.89,2.87,2.83,2.75,2.67,2.61,2.52,2.45,2.37,2.29,2.23,2.16,2.11,2.07,2.02,2,2,2,2,2.03,2.09,2.12,2.16,2.22,2.25,2.27,2.28,2.27,2.26,2.24,2.21,2.16,2.15,2.15,2.14,2.14,2.12,2.10,2.04,2,1.95,1.87,1.76,1.63,1.49,1.34,1.20,1.09,1.01,1,0.99,1,1,1.02,1.07,1.10,1.12,1.14,1.16,1.17,1.20,1.20,1.17,1.15,1.12,1.10,1.04,1,0.96,0.88,0.83,0.74,0.66,0.61,0.53,0.49,0.41,0.36,0.29,0.25,0.20,0.13,0.09,0.03,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0,-0.25,-1.37,-3.61,-6.43,-9.45,-12,-13,-11,-9.99,-8.14,-7.20,-7.07,-7.51,-8.42,-9.05,-9.23,-9.38,-9.26,-9.16,-9.13,-9.46,-9.92,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.58,-9.02,-8.38,-7.75,-7.12,-6.50,-5.89,4.13,4.21,4.34,4.50,4.63,4.75,4.84,4.87,4.88,4.86,4.78,4.70,4.60,4.51,4.47,4.45,4.46,4.49,4.51,4.54,4.57,4.57,4.53,4.50,4.47,4.39,4.35,4.26,4.21,4.14,4.10,4.03,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.01,4.02,4.01,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.98,3.98,3.97,3.97,3.97,3.95,3.87,3.74,3.54,3.37,3.23,3.12,3.03,3,2.99,2.98,2.98,2.97,2.96,2.91,2.89,2.86,2.83,2.78,2.77,2.79,2.86,2.91,2.99,3.04,3.10,3.11,3.12,3.12,3.11,3.10,3.10,3.09,3.09,3.09,3.09,3.10,3.11,3.12,3.13,3.14,3.15,3.14,3.12,3.11,3.08,3.04,3.03,3.02,3.01,3,3,2.99,2.98,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.96,2.95,2.90,2.87,2.82,2.75,2.70,2.62,2.54,2.48,2.39,2.32,2.24,2.16,2.11,2.07,2.02,2.01,2,2.02,2.08,2.12,2.17,2.25,2.32,2.36,2.38,2.40,2.40,2.38,2.37,2.34,2.29,2.28,2.27,2.26,2.25,2.22,2.16,2.11,2.04,1.99,1.90,1.82,1.70,1.54,1.38,1.25,1.12,1.03,1,1,1.01,1.03,1.09,1.12,1.17,1.23,1.26,1.29,1.33,1.33,1.33,1.29,1.26,1.23,1.17,1.13,1.09,1.03,0.98,0.91,0.86,0.79,0.75,0.70,0.63,0.57,0.50,0.41,0.36,0.27,0.22,0.13,0.08,0.02,0,0,0,0,0,0,0,0,0,0.01,0.02,0.01,-0.05,-0.37,-2.35,-5.05,-7.80,-10,-11,-10,-9.76,-8.70,-8.01,-7.23,-7.20,-7.74,-8.38,-8.98,-9.15,-9.03,-8.91,-8.87,-8.96,-9.38,-9.87,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.78,-9.23,-8.62,-8.04,-7.43,-6.75,-6.10,4.08,4.16,4.32,4.49,4.64,4.76,4.85,4.87,4.87,4.84,4.78,4.73,4.65,4.62,4.61,4.62,4.64,4.71,4.75,4.79,4.84,4.84,4.83,4.77,4.73,4.64,4.57,4.47,4.37,4.26,4.17,4.11,4.03,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.98,3.98,3.98,3.98,3.97,3.95,3.87,3.75,3.58,3.37,3.22,3.11,3.03,3,2.99,2.98,2.98,2.97,2.96,2.95,2.91,2.89,2.87,2.87,2.87,2.89,2.96,3.02,3.10,3.15,3.21,3.22,3.23,3.23,3.23,3.23,3.23,3.23,3.23,3.23,3.23,3.23,3.23,3.24,3.25,3.25,3.25,3.25,3.22,3.17,3.14,3.12,3.09,3.07,3.03,3.01,3,2.99,2.98,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.98,2.98,2.98,2.97,2.95,2.90,2.87,2.82,2.75,2.71,2.63,2.58,2.49,2.40,2.33,2.24,2.15,2.11,2.07,2.03,2.03,2.07,2.11,2.16,2.25,2.33,2.39,2.47,2.50,2.52,2.52,2.51,2.50,2.48,2.46,2.42,2.41,2.40,2.37,2.33,2.25,2.16,2.10,2.01,1.95,1.86,1.75,1.61,1.45,1.28,1.16,1.09,1.03,1.02,1.07,1.11,1.15,1.23,1.29,1.36,1.40,1.46,1.49,1.50,1.48,1.45,1.39,1.36,1.29,1.24,1.17,1.12,1.08,1.01,0.98,0.91,0.87,0.84,0.77,0.70,0.62,0.54,0.47,0.37,0.28,0.20,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0.02,0.02,-0.02,-0.21,-0.58,-3.51,-6.09,-8.23,-9.58,-10,-9.86,-9.42,-8.85,-8.07,-7.54,-7.17,-7.77,-8.25,-8.49,-8.61,-8.60,-8.55,-8.72,-9.09,-9.63,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-13,-13,-12,-12,-12,-12,-11,-11,-10,-10,-9.91,-9.36,-8.87,-8.33,-7.71,-6.99,-6.30,4.07,4.13,4.26,4.45,4.61,4.72,4.77,4.82,4.79,4.78,4.75,4.73,4.71,4.70,4.72,4.75,4.82,4.89,4.98,5.04,5.10,5.12,5.11,5.07,5,4.92,4.83,4.71,4.58,4.42,4.29,4.20,4.11,4.03,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.98,3.98,3.97,3.95,3.87,3.75,3.58,3.37,3.20,3.10,3.02,3,2.99,2.99,2.98,2.98,2.97,2.96,2.95,2.92,2.91,2.91,2.95,2.99,3.04,3.12,3.21,3.27,3.33,3.36,3.37,3.37,3.37,3.37,3.37,3.37,3.37,3.37,3.37,3.37,3.37,3.37,3.38,3.38,3.38,3.37,3.34,3.28,3.24,3.17,3.13,3.11,3.08,3.03,3.01,3,2.99,2.98,2.97,2.97,2.97,2.97,2.97,2.98,2.98,2.98,2.98,2.99,2.98,2.96,2.92,2.89,2.86,2.82,2.76,2.73,2.65,2.59,2.50,2.39,2.32,2.23,2.14,2.10,2.08,2.07,2.10,2.13,2.22,2.29,2.38,2.48,2.54,2.61,2.62,2.63,2.63,2.62,2.61,2.60,2.59,2.57,2.53,2.50,2.41,2.34,2.24,2.13,2.04,1.97,1.88,1.78,1.65,1.50,1.36,1.23,1.12,1.09,1.09,1.12,1.17,1.25,1.35,1.41,1.50,1.54,1.61,1.63,1.64,1.63,1.60,1.54,1.50,1.42,1.36,1.27,1.22,1.14,1.11,1.07,1.01,0.99,0.95,0.89,0.82,0.74,0.65,0.58,0.48,0.37,0.26,0.16,0.10,0.04,0.01,0,0,0,0,0,0,0,0,0.01,0.02,-0.01,-0.17,-0.50,-2.11,-4.50,-6.76,-8.62,-9.70,-10,-10,-9.88,-9.13,-8.24,-7.72,-7.09,-7.37,-7.79,-8.01,-8.16,-8.29,-8.38,-9.01,-9.60,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.96,-9.50,-9.01,-8.50,-7.88,-7.15,-6.55,4.03,4.10,4.22,4.35,4.49,4.60,4.66,4.70,4.71,4.70,4.67,4.67,4.70,4.73,4.77,4.86,4.95,5.04,5.14,5.24,5.29,5.35,5.36,5.33,5.26,5.20,5.11,4.97,4.79,4.62,4.46,4.29,4.16,4.09,4.02,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.98,3.97,3.95,3.87,3.75,3.58,3.37,3.21,3.08,3.01,3,3,2.99,2.99,2.98,2.98,2.98,2.97,2.97,2.96,2.97,2.99,3.03,3.12,3.22,3.33,3.39,3.50,3.52,3.52,3.53,3.53,3.54,3.53,3.53,3.53,3.53,3.53,3.53,3.53,3.53,3.53,3.53,3.52,3.50,3.45,3.38,3.34,3.25,3.21,3.13,3.10,3.07,3.02,3,2.99,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.97,2.96,2.95,2.90,2.88,2.86,2.83,2.77,2.73,2.66,2.59,2.49,2.38,2.28,2.22,2.14,2.11,2.10,2.12,2.16,2.25,2.34,2.45,2.53,2.62,2.67,2.72,2.73,2.73,2.73,2.72,2.72,2.71,2.67,2.64,2.60,2.50,2.39,2.27,2.16,2.08,2,1.91,1.83,1.71,1.57,1.41,1.28,1.21,1.15,1.15,1.21,1.27,1.37,1.46,1.53,1.62,1.67,1.74,1.76,1.76,1.76,1.75,1.67,1.62,1.57,1.49,1.39,1.32,1.24,1.16,1.13,1.10,1.07,1.02,0.99,0.89,0.84,0.75,0.66,0.58,0.47,0.35,0.25,0.15,0.10,0.07,0.02,0,0,0,0,0,0,0,0,0.01,0,-0.14,-0.42,-1.39,-3.27,-5.57,-7.86,-9.59,-10,-11,-10,-9.86,-8.67,-7.97,-7.60,-6.84,-7.12,-7.48,-7.73,-8.16,-8.62,-9.13,-9.75,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-9.63,-9.13,-8.61,-8,-7.38,-6.75,4.02,4.08,4.14,4.25,4.36,4.46,4.51,4.53,4.57,4.57,4.58,4.60,4.62,4.67,4.75,4.87,4.99,5.12,5.24,5.35,5.42,5.49,5.50,5.50,5.48,5.40,5.32,5.21,5.03,4.84,4.62,4.42,4.25,4.13,4.07,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.98,3.97,3.92,3.87,3.75,3.58,3.37,3.21,3.08,3.01,3,3,3,3,2.99,2.99,2.99,2.99,2.99,2.99,3,3.01,3.08,3.16,3.27,3.40,3.51,3.60,3.65,3.66,3.71,3.70,3.71,3.72,3.70,3.71,3.70,3.67,3.67,3.67,3.67,3.70,3.67,3.65,3.62,3.57,3.50,3.41,3.34,3.25,3.17,3.12,3.08,3.02,3,3,2.99,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.97,2.97,2.96,2.92,2.91,2.89,2.87,2.86,2.83,2.77,2.72,2.64,2.57,2.46,2.36,2.26,2.20,2.14,2.12,2.14,2.20,2.26,2.37,2.48,2.58,2.65,2.73,2.76,2.78,2.79,2.79,2.82,2.82,2.78,2.76,2.73,2.66,2.58,2.46,2.33,2.21,2.10,2.01,1.95,1.87,1.75,1.62,1.49,1.37,1.27,1.25,1.25,1.32,1.38,1.48,1.58,1.64,1.73,1.77,1.82,1.86,1.87,1.86,1.85,1.79,1.75,1.67,1.61,1.50,1.40,1.32,1.25,1.21,1.15,1.12,1.09,1.03,0.97,0.89,0.84,0.75,0.65,0.54,0.45,0.35,0.25,0.16,0.11,0.07,0.01,0,0,0,0,0,0,0,0.01,0,-0.10,-0.30,-0.92,-2.30,-4.36,-6.53,-8.60,-10,-10,-10,-9.72,-8.60,-7.85,-7.58,-7.45,-6.38,-7.13,-7.64,-8.18,-8.80,-9.46,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-10,-10,-9.68,-9.21,-8.65,-8.09,-7.54,-6.90,4,4.02,4.09,4.15,4.24,4.29,4.36,4.38,4.40,4.41,4.45,4.48,4.51,4.60,4.67,4.79,4.92,5.07,5.20,5.32,5.42,5.50,5.57,5.59,5.58,5.53,5.48,5.36,5.22,5.02,4.78,4.57,4.35,4.20,4.09,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.92,3.87,3.74,3.57,3.37,3.21,3.09,3.01,3,3,3,3,2.99,2.99,2.99,2.99,2.99,2.99,3,3.01,3.08,3.15,3.26,3.38,3.50,3.62,3.71,3.74,3.78,3.84,3.83,3.83,3.83,3.82,3.82,3.82,3.79,3.79,3.79,3.79,3.76,3.75,3.73,3.66,3.60,3.50,3.39,3.29,3.21,3.12,3.08,3.02,3,2.99,2.99,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.97,2.97,2.97,2.96,2.95,2.92,2.91,2.90,2.89,2.87,2.86,2.83,2.76,2.71,2.62,2.52,2.42,2.34,2.25,2.20,2.15,2.16,2.22,2.28,2.37,2.49,2.60,2.67,2.75,2.79,2.84,2.85,2.86,2.86,2.86,2.86,2.84,2.78,2.72,2.62,2.50,2.36,2.23,2.12,2.03,1.97,1.89,1.79,1.67,1.57,1.45,1.37,1.35,1.37,1.41,1.50,1.59,1.66,1.75,1.79,1.85,1.87,1.90,1.90,1.90,1.89,1.87,1.85,1.79,1.71,1.61,1.50,1.39,1.33,1.25,1.23,1.17,1.13,1.09,1.02,0.96,0.88,0.83,0.74,0.64,0.54,0.46,0.36,0.25,0.17,0.11,0.04,0.01,0,0,0,0,0,0,0.01,0.01,-0.03,-0.18,-0.50,-1.43,-2.99,-4.90,-6.75,-8.26,-9.12,-9.24,-8.85,-8.07,-7.34,-7.26,-7.52,-6.96,-6.99,-7.53,-8.23,-9.01,-9.88,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-11,-11,-10,-9.84,-9.22,-8.64,-8.14,-7.63,-7.02,4,4,4.03,4.09,4.12,4.17,4.22,4.25,4.26,4.28,4.32,4.35,4.39,4.48,4.57,4.67,4.79,4.91,5.04,5.16,5.28,5.38,5.48,5.52,5.54,5.54,5.51,5.46,5.32,5.13,4.92,4.65,4.41,4.24,4.11,4.02,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.92,3.87,3.74,3.57,3.37,3.21,3.09,3.01,3,3,3,3,3,3,3,3,3,3,3,3,3.04,3.12,3.22,3.32,3.42,3.54,3.65,3.74,3.82,3.87,3.90,3.88,3.88,3.88,3.87,3.87,3.87,3.88,3.87,3.86,3.85,3.84,3.79,3.75,3.66,3.57,3.45,3.34,3.23,3.13,3.08,3.02,3,2.99,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.97,2.97,2.96,2.96,2.95,2.95,2.92,2.91,2.90,2.89,2.87,2.86,2.82,2.75,2.66,2.59,2.49,2.38,2.29,2.24,2.20,2.20,2.23,2.28,2.37,2.49,2.60,2.67,2.75,2.82,2.86,2.87,2.88,2.88,2.89,2.89,2.87,2.83,2.75,2.64,2.51,2.38,2.25,2.14,2.07,1.99,1.91,1.84,1.74,1.62,1.52,1.47,1.46,1.48,1.52,1.61,1.66,1.75,1.82,1.86,1.88,1.90,1.92,1.95,1.95,1.92,1.91,1.89,1.87,1.79,1.70,1.59,1.49,1.39,1.34,1.28,1.25,1.20,1.13,1.08,1,0.95,0.87,0.82,0.75,0.65,0.58,0.48,0.36,0.25,0.15,0.09,0.02,0,0,0,0,0,0,0,0.01,-0.02,-0.11,-0.32,-0.79,-1.77,-3.18,-4.71,-6.04,-7.04,-7.67,-7.77,-7.41,-6.67,-6.79,-7.17,-7.59,-6.86,-7.33,-7.96,-9.25,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-10,-9.96,-9.18,-8.73,-8.25,-7.68,-7.11,4,4,4,4.02,4.07,4.10,4.12,4.13,4.14,4.16,4.20,4.23,4.26,4.34,4.41,4.51,4.62,4.73,4.84,4.95,5.03,5.13,5.23,5.29,5.35,5.37,5.37,5.34,5.23,5.08,4.87,4.66,4.45,4.26,4.12,4.03,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.92,3.86,3.73,3.54,3.37,3.21,3.09,3.01,3,3,3,3,3,3,3,3,3,3,3,3,3.02,3.07,3.12,3.21,3.32,3.42,3.57,3.67,3.78,3.87,3.88,3.89,3.90,3.90,3.90,3.90,3.90,3.90,3.89,3.88,3.87,3.86,3.83,3.76,3.67,3.59,3.48,3.35,3.24,3.13,3.08,3.02,3,2.99,2.98,2.97,2.97,2.97,2.97,2.97,2.98,2.97,2.97,2.97,2.96,2.96,2.95,2.95,2.92,2.91,2.90,2.89,2.89,2.87,2.84,2.77,2.71,2.62,2.53,2.45,2.35,2.26,2.22,2.20,2.22,2.27,2.37,2.47,2.58,2.66,2.75,2.82,2.86,2.87,2.89,2.90,2.91,2.91,2.88,2.84,2.76,2.65,2.53,2.40,2.27,2.16,2.09,2.01,1.95,1.87,1.77,1.70,1.61,1.57,1.54,1.59,1.62,1.70,1.75,1.82,1.86,1.88,1.90,1.92,1.96,1.96,1.96,1.96,1.95,1.91,1.90,1.86,1.76,1.66,1.58,1.50,1.42,1.37,1.33,1.25,1.20,1.12,1.04,0.99,0.92,0.87,0.83,0.75,0.67,0.59,0.46,0.34,0.23,0.12,0.04,0.01,0,0,0,0,0,0,0,0,-0.03,-0.13,-0.26,-0.48,-1.53,-2.63,-3.54,-4.92,-6.08,-7.05,-6.85,-6.50,-6.18,-7.32,-8.09,-7.40,-7.09,-7.93,-9.28,-10,-10,-11,-10,-10,-11,-11,-11,-11,-11,-12,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-13,-12,-11,-11,-10,-9.28,-8.75,-8.26,-7.73,-7.13,4,4,4,4,4.01,4.02,4.03,4.07,4.08,4.09,4.10,4.12,4.15,4.22,4.28,4.36,4.45,4.53,4.62,4.72,4.80,4.89,4.98,5.05,5.11,5.15,5.17,5.15,5.08,4.95,4.78,4.60,4.41,4.25,4.13,4.04,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.01,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.91,3.85,3.73,3.54,3.37,3.21,3.09,3.01,3,3,3,3,3,3,3,3,3,3,3,3,3,3.02,3.07,3.12,3.20,3.29,3.46,3.59,3.71,3.79,3.87,3.88,3.89,3.90,3.90,3.90,3.90,3.89,3.89,3.88,3.88,3.87,3.84,3.77,3.70,3.60,3.47,3.35,3.24,3.13,3.08,3.02,3,2.98,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.96,2.96,2.95,2.95,2.92,2.92,2.91,2.90,2.89,2.88,2.85,2.79,2.74,2.65,2.59,2.48,2.37,2.28,2.24,2.21,2.22,2.25,2.34,2.42,2.53,2.63,2.72,2.77,2.84,2.87,2.88,2.89,2.90,2.91,2.88,2.85,2.76,2.67,2.57,2.42,2.32,2.21,2.11,2.02,1.97,1.88,1.83,1.75,1.70,1.64,1.64,1.66,1.72,1.76,1.82,1.86,1.88,1.90,1.92,1.95,1.96,1.97,1.97,1.97,1.96,1.95,1.92,1.88,1.84,1.75,1.66,1.61,1.53,1.49,1.41,1.35,1.26,1.17,1.11,1.02,0.98,0.91,0.87,0.84,0.76,0.66,0.53,0.40,0.26,0.15,0.08,0.01,0,0,0,0,0,0,0,0,0,-0.02,-0.12,-0.24,-0.40,-1.12,-1.67,-2.76,-4.28,-5.67,-6.23,-6.21,-6.47,-7.11,-7.85,-8.02,-7.96,-8.05,-8.97,-9.89,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-10,-9.59,-8.78,-8.25,-7.72,-7.16,4,4,4,4,4,4,4,4.01,4.01,4.02,4.03,4.04,4.09,4.12,4.17,4.23,4.29,4.36,4.43,4.51,4.59,4.67,4.75,4.83,4.88,4.93,4.96,4.95,4.88,4.79,4.66,4.51,4.36,4.23,4.13,4.05,4.02,4,4,4,4,4,4,4,4,4,4.02,4.02,4.03,4.03,4.08,4.09,4.09,4.08,4.04,4.02,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.91,3.85,3.72,3.53,3.36,3.20,3.09,3.01,3,3,3,3.01,3.01,3,3,3,3,3,3,3,3,3,3.03,3.09,3.15,3.25,3.37,3.50,3.62,3.71,3.79,3.85,3.87,3.87,3.88,3.88,3.87,3.88,3.88,3.88,3.88,3.87,3.84,3.76,3.67,3.58,3.46,3.34,3.23,3.13,3.07,3.01,2.99,2.98,2.97,2.96,2.96,2.96,2.97,2.97,2.97,2.97,2.97,2.96,2.96,2.96,2.95,2.95,2.95,2.92,2.91,2.91,2.89,2.87,2.86,2.82,2.75,2.66,2.59,2.50,2.39,2.32,2.24,2.20,2.20,2.24,2.29,2.38,2.49,2.59,2.66,2.74,2.79,2.84,2.87,2.87,2.88,2.90,2.87,2.84,2.76,2.67,2.58,2.46,2.33,2.22,2.12,2.04,1.98,1.91,1.86,1.79,1.75,1.74,1.74,1.75,1.77,1.83,1.86,1.88,1.90,1.92,1.95,1.95,1.96,1.97,1.97,1.97,1.97,1.96,1.96,1.91,1.87,1.83,1.76,1.72,1.66,1.62,1.53,1.46,1.35,1.25,1.14,1.08,1,0.96,0.91,0.87,0.83,0.74,0.60,0.46,0.32,0.17,0.10,0.02,0,0,0,0,0,0,0,0,0,0,-0.02,-0.10,-0.18,-0.36,-0.72,-1.34,-2.33,-3.87,-5.03,-5.71,-6.43,-7.28,-8.16,-8.51,-8.42,-8.16,-8.59,-9.25,-9.85,-10,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-11,-10,-10,-8.98,-8.40,-7.79,-7.27,4,4,4,4,4,4,4,4,4,4,4,4.01,4.02,4.07,4.09,4.13,4.17,4.22,4.27,4.34,4.40,4.47,4.53,4.60,4.66,4.71,4.73,4.73,4.68,4.62,4.52,4.40,4.29,4.20,4.12,4.08,4.04,4.03,4.02,4,4,4,4,4,4.01,4.04,4.09,4.12,4.14,4.17,4.22,4.23,4.22,4.17,4.14,4.10,4.04,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.91,3.84,3.71,3.53,3.37,3.21,3.10,3.02,3,3,3,3,3.01,3,3,3,3,3,3,3,3,3,3.01,3.07,3.12,3.21,3.32,3.40,3.51,3.61,3.67,3.74,3.76,3.79,3.82,3.83,3.84,3.85,3.86,3.86,3.86,3.85,3.79,3.74,3.64,3.53,3.42,3.32,3.22,3.12,3.04,3,2.99,2.97,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.95,2.95,2.95,2.92,2.92,2.90,2.89,2.87,2.85,2.82,2.75,2.66,2.59,2.49,2.39,2.29,2.23,2.17,2.16,2.20,2.25,2.34,2.41,2.51,2.61,2.66,2.74,2.77,2.82,2.84,2.85,2.87,2.86,2.82,2.75,2.66,2.57,2.46,2.34,2.22,2.12,2.04,1.99,1.92,1.88,1.85,1.82,1.79,1.79,1.82,1.84,1.86,1.88,1.90,1.91,1.92,1.95,1.95,1.96,1.97,1.97,1.97,1.97,1.97,1.97,1.95,1.91,1.88,1.85,1.82,1.77,1.73,1.65,1.58,1.45,1.32,1.20,1.11,1.02,0.99,0.95,0.90,0.86,0.76,0.62,0.50,0.35,0.22,0.12,0.04,0,0,0,0,0,0,0,0,0,0,0,-0.02,-0.08,-0.14,-0.26,-0.49,-0.76,-2.35,-3.76,-4.97,-6.16,-7.50,-8.55,-8.96,-8.78,-8.35,-8.36,-8.65,-9.21,-9.79,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-11,-10,-9.25,-8.50,-7.97,-7.43,4,4,4,4,4,3.99,3.99,3.99,3.99,3.99,3.99,3.99,4,4.01,4.02,4.04,4.07,4.10,4.14,4.18,4.24,4.29,4.35,4.40,4.45,4.49,4.51,4.51,4.49,4.45,4.38,4.30,4.23,4.17,4.13,4.11,4.10,4.08,4.07,4.04,4.01,4,4,4.02,4.08,4.13,4.22,4.28,4.37,4.41,4.45,4.45,4.41,4.37,4.29,4.22,4.13,4.08,4.02,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.96,3.90,3.84,3.71,3.53,3.37,3.22,3.11,3.03,3.01,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3.03,3.10,3.15,3.25,3.34,3.42,3.50,3.58,3.62,3.64,3.67,3.71,3.74,3.75,3.77,3.79,3.82,3.82,3.79,3.75,3.70,3.61,3.50,3.38,3.27,3.17,3.11,3.03,3,2.97,2.96,2.96,2.95,2.95,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.95,2.95,2.95,2.95,2.92,2.91,2.90,2.88,2.87,2.84,2.78,2.74,2.65,2.58,2.48,2.37,2.28,2.21,2.15,2.13,2.15,2.21,2.26,2.36,2.42,2.51,2.60,2.64,2.71,2.74,2.75,2.77,2.82,2.79,2.75,2.71,2.62,2.52,2.41,2.32,2.22,2.12,2.04,2,1.95,1.90,1.87,1.86,1.85,1.85,1.86,1.87,1.88,1.90,1.91,1.92,1.92,1.95,1.95,1.96,1.96,1.96,1.97,1.97,1.97,1.97,1.96,1.95,1.91,1.89,1.87,1.86,1.82,1.75,1.64,1.51,1.37,1.24,1.12,1.04,1,0.96,0.91,0.87,0.78,0.65,0.52,0.37,0.25,0.14,0.08,0.02,0,0,0,0,0,0,0,0,0,0,-0.01,-0.02,-0.05,-0.10,-0.16,-0.28,-1.17,-2.41,-4.03,-5.68,-7.40,-8.71,-9.21,-9.05,-8.65,-8.38,-8.33,-9.01,-9.76,-10,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-16,-16,-15,-15,-14,-14,-13,-12,-11,-10,-9.38,-8.53,-8.05,-7.53,4,4,4,4,4,3.99,3.99,3.98,3.98,3.98,3.97,3.97,3.97,3.97,3.97,3.98,3.99,4.01,4.03,4.08,4.11,4.15,4.20,4.24,4.27,4.30,4.33,4.33,4.32,4.29,4.25,4.22,4.18,4.16,4.16,4.17,4.18,4.17,4.14,4.11,4.08,4.04,4.03,4.09,4.16,4.28,4.42,4.57,4.65,4.73,4.75,4.74,4.67,4.61,4.50,4.37,4.25,4.13,4.07,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,4,4,4,3.99,3.99,3.99,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.96,3.90,3.84,3.71,3.54,3.37,3.24,3.12,3.07,3.03,3.01,3,3,3,3,3,3,3,3,3,3,3,3,3,3.01,3.07,3.12,3.20,3.26,3.34,3.40,3.47,3.50,3.53,3.57,3.59,3.62,3.65,3.70,3.72,3.74,3.75,3.74,3.70,3.62,3.54,3.46,3.35,3.24,3.14,3.08,3.01,2.98,2.96,2.95,2.92,2.95,2.95,2.95,2.95,2.95,2.95,2.96,2.96,2.96,2.95,2.95,2.95,2.95,2.92,2.92,2.91,2.89,2.87,2.86,2.82,2.75,2.71,2.62,2.52,2.42,2.35,2.25,2.17,2.12,2.11,2.12,2.14,2.21,2.27,2.36,2.41,2.50,2.54,2.60,2.63,2.66,2.70,2.73,2.72,2.67,2.62,2.57,2.48,2.37,2.27,2.17,2.11,2.03,2,1.96,1.91,1.89,1.88,1.88,1.87,1.88,1.89,1.89,1.90,1.91,1.91,1.92,1.92,1.92,1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.97,1.96,1.95,1.92,1.91,1.89,1.86,1.78,1.70,1.57,1.40,1.25,1.13,1.07,1,0.97,0.92,0.88,0.82,0.70,0.57,0.42,0.28,0.20,0.11,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.03,-0.11,-0.52,-1.43,-2.96,-4.76,-6.70,-8.24,-9,-9.09,-8.90,-8.62,-8.48,-9.09,-9.97,-10,-11,-11,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-14,-13,-12,-11,-10,-9.47,-8.62,-8.11,-7.59,4,4,4,4,4,3.99,3.99,3.98,3.97,3.97,3.96,3.93,3.93,3.92,3.91,3.91,3.91,3.93,3.96,3.98,4.01,4.04,4.08,4.11,4.14,4.16,4.17,4.18,4.17,4.17,4.16,4.15,4.16,4.18,4.23,4.27,4.30,4.30,4.27,4.22,4.16,4.13,4.14,4.21,4.34,4.51,4.70,4.85,4.97,5.03,5.08,5.03,4.97,4.86,4.71,4.53,4.37,4.24,4.12,4.04,4,4,4,4,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,4,3.99,3.99,3.99,3.99,3.99,3.99,4,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,4,4,4,4,3.99,3.98,3.96,3.90,3.84,3.71,3.54,3.38,3.25,3.15,3.10,3.04,3.02,3.01,3,3,3,3,3,3,3,3,3,3,3,3,3,3.03,3.09,3.13,3.20,3.25,3.32,3.36,3.38,3.41,3.45,3.48,3.50,3.53,3.58,3.62,3.63,3.64,3.63,3.61,3.53,3.47,3.37,3.27,3.20,3.11,3.02,2.98,2.95,2.91,2.90,2.90,2.91,2.92,2.92,2.95,2.95,2.95,2.95,2.95,2.95,2.95,2.95,2.95,2.92,2.92,2.91,2.90,2.88,2.87,2.84,2.77,2.72,2.64,2.58,2.48,2.38,2.28,2.22,2.13,2.10,2.08,2.08,2.10,2.14,2.21,2.26,2.33,2.38,2.45,2.49,2.51,2.54,2.58,2.62,2.61,2.59,2.52,2.48,2.39,2.32,2.23,2.14,2.09,2.02,1.99,1.97,1.95,1.91,1.90,1.90,1.89,1.90,1.90,1.90,1.90,1.90,1.90,1.90,1.90,1.91,1.91,1.91,1.91,1.92,1.95,1.95,1.96,1.96,1.96,1.96,1.95,1.92,1.90,1.87,1.78,1.70,1.57,1.40,1.26,1.13,1.04,1,0.97,0.92,0.89,0.84,0.73,0.62,0.49,0.37,0.25,0.15,0.10,0.04,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.20,-0.78,-1.93,-3.70,-5.43,-7.16,-8.29,-8.83,-9.02,-8.97,-8.92,-9.35,-9.91,-10,-11,-11,-12,-12,-12,-12,-12,-13,-14,-14,-15,-16,-16,-16,-17,-17,-17,-17,-18,-18,-18,-18,-17,-17,-16,-16,-15,-14,-13,-12,-11,-9.85,-8.65,-8.09,-7.52,4,4,4,4,4,3.99,3.98,3.97,3.97,3.96,3.93,3.91,3.89,3.88,3.86,3.85,3.85,3.86,3.88,3.91,3.93,3.97,4,4.02,4.04,4.07,4.08,4.08,4.08,4.09,4.10,4.12,4.16,4.23,4.30,4.38,4.43,4.46,4.41,4.35,4.27,4.23,4.24,4.33,4.49,4.74,4.96,5.12,5.25,5.34,5.35,5.29,5.21,5.07,4.88,4.71,4.51,4.35,4.20,4.10,4.02,4,4,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.98,3.99,3.99,3.99,3.99,3.99,3.98,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,4,4,4,3.99,3.98,3.96,3.90,3.84,3.72,3.54,3.39,3.27,3.17,3.12,3.07,3.03,3,3,3,3,3,3,3,3,3,3,3,2.99,3,3,3.01,3.04,3.09,3.12,3.16,3.22,3.25,3.27,3.29,3.34,3.36,3.38,3.41,3.46,3.49,3.52,3.53,3.52,3.50,3.45,3.37,3.28,3.21,3.12,3.04,2.99,2.92,2.89,2.87,2.87,2.87,2.88,2.89,2.91,2.92,2.92,2.95,2.95,2.95,2.95,2.95,2.95,2.92,2.92,2.91,2.90,2.89,2.87,2.85,2.78,2.74,2.66,2.59,2.50,2.41,2.33,2.25,2.16,2.11,2.07,2.03,2.03,2.07,2.10,2.13,2.20,2.24,2.28,2.34,2.37,2.39,2.42,2.46,2.49,2.49,2.47,2.41,2.37,2.32,2.24,2.16,2.11,2.04,2,1.99,1.97,1.95,1.92,1.92,1.91,1.91,1.90,1.90,1.90,1.90,1.89,1.88,1.87,1.87,1.87,1.87,1.87,1.88,1.89,1.90,1.91,1.95,1.95,1.95,1.95,1.92,1.90,1.87,1.84,1.75,1.64,1.51,1.37,1.24,1.12,1.03,1,0.97,0.95,0.90,0.86,0.76,0.67,0.58,0.46,0.34,0.24,0.15,0.11,0.07,0.03,0.02,0.02,0.01,0,0,0,0,0,0,0,0,0.01,0,-0.10,-0.42,-1.18,-2.50,-4.22,-5.84,-7.30,-8.33,-9.09,-9.25,-9.39,-9.67,-10,-11,-11,-12,-12,-13,-13,-12,-13,-13,-14,-15,-16,-17,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-13,-12,-11,-10,-8.92,-8,-7.43,4,4,4,4,4,3.99,3.98,3.97,3.96,3.93,3.91,3.88,3.85,3.82,3.78,3.76,3.76,3.77,3.80,3.84,3.87,3.91,3.93,3.97,3.98,3.99,4,4.01,4.01,4.02,4.05,4.10,4.16,4.26,4.38,4.49,4.58,4.60,4.55,4.47,4.38,4.32,4.33,4.41,4.59,4.87,5.13,5.33,5.46,5.50,5.51,5.47,5.35,5.21,5.01,4.84,4.63,4.46,4.28,4.15,4.07,4.02,4,3.99,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.99,3.98,3.98,3.98,3.98,3.98,3.99,3.99,3.99,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.99,3.99,3.99,3.99,3.99,4,3.99,3.98,3.96,3.90,3.84,3.72,3.57,3.40,3.27,3.17,3.12,3.08,3.02,3,3,3,3,3,3,3,3,3,3,2.99,2.99,2.99,2.99,3,3.01,3.03,3.08,3.11,3.13,3.15,3.17,3.21,3.23,3.25,3.27,3.32,3.35,3.37,3.39,3.40,3.40,3.37,3.34,3.27,3.21,3.12,3.04,2.98,2.91,2.87,2.85,2.84,2.84,2.84,2.86,2.87,2.89,2.91,2.91,2.92,2.95,2.95,2.95,2.95,2.92,2.92,2.91,2.90,2.89,2.87,2.85,2.79,2.75,2.67,2.61,2.51,2.45,2.35,2.26,2.20,2.12,2.08,2.03,2.01,2.01,2.02,2.07,2.10,2.13,2.17,2.22,2.25,2.26,2.28,2.32,2.34,2.36,2.36,2.35,2.32,2.26,2.22,2.15,2.11,2.07,2.02,2,1.98,1.97,1.96,1.95,1.92,1.92,1.91,1.91,1.90,1.89,1.88,1.87,1.86,1.84,1.82,1.82,1.79,1.82,1.83,1.85,1.87,1.88,1.90,1.91,1.92,1.91,1.89,1.87,1.83,1.75,1.66,1.57,1.45,1.32,1.20,1.10,1.02,1,0.97,0.95,0.91,0.88,0.83,0.75,0.65,0.54,0.42,0.33,0.23,0.14,0.10,0.07,0.03,0.03,0.01,0,0,0,0,0,0,0,0,0.01,0.01,-0.03,-0.20,-0.66,-1.58,-2.99,-4.68,-6.35,-7.87,-8.87,-9.46,-9.62,-9.91,-10,-11,-12,-12,-13,-13,-13,-13,-13,-14,-15,-16,-17,-18,-18,-18,-18,-18,-18,-18,-18,-19,-18,-18,-18,-18,-17,-17,-16,-15,-14,-12,-11,-10,-9.03,-8.04,-7.28,4,4,3.99,3.99,3.99,3.98,3.98,3.96,3.93,3.91,3.88,3.84,3.79,3.74,3.70,3.67,3.66,3.68,3.72,3.76,3.80,3.85,3.89,3.91,3.93,3.95,3.95,3.96,3.97,3.98,4.01,4.08,4.16,4.27,4.41,4.55,4.66,4.71,4.66,4.57,4.46,4.38,4.37,4.45,4.62,4.88,5.16,5.37,5.48,5.51,5.51,5.48,5.37,5.24,5.08,4.89,4.73,4.54,4.37,4.24,4.12,4.04,4.01,4,3.98,3.98,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.96,3.97,3.98,3.98,3.98,3.98,3.98,3.98,3.97,3.97,3.98,3.98,3.98,3.98,3.98,3.98,3.99,3.99,3.99,3.99,3.99,3.99,3.98,3.97,3.89,3.83,3.70,3.53,3.40,3.27,3.17,3.12,3.07,3.02,3,3,3,3,3,3,2.99,2.99,2.99,2.99,2.99,2.99,2.99,2.99,2.99,3,3.01,3.02,3.04,3.08,3.10,3.11,3.12,3.13,3.15,3.17,3.22,3.24,3.25,3.26,3.27,3.27,3.25,3.23,3.16,3.11,3.03,2.97,2.89,2.85,2.79,2.76,2.76,2.76,2.78,2.82,2.85,2.87,2.89,2.91,2.92,2.92,2.95,2.95,2.92,2.92,2.91,2.91,2.89,2.87,2.86,2.82,2.75,2.70,2.62,2.52,2.46,2.37,2.27,2.21,2.13,2.09,2.03,2.01,2,2,2.02,2.04,2.09,2.12,2.14,2.17,2.20,2.21,2.23,2.24,2.25,2.25,2.25,2.25,2.22,2.17,2.13,2.10,2.07,2.02,2,1.99,1.97,1.96,1.95,1.95,1.92,1.92,1.91,1.90,1.89,1.87,1.86,1.83,1.78,1.75,1.74,1.72,1.71,1.72,1.73,1.75,1.78,1.85,1.87,1.88,1.88,1.87,1.85,1.79,1.74,1.64,1.57,1.46,1.34,1.23,1.12,1.07,1,0.99,0.97,0.96,0.92,0.90,0.87,0.82,0.75,0.65,0.53,0.41,0.29,0.20,0.12,0.08,0.04,0.02,0.01,0,0,0,0,0,0,0,0,0,0.01,0.01,-0.03,-0.17,-0.63,-1.73,-3.45,-5.57,-7.36,-8.61,-9.25,-9.65,-10,-10,-11,-11,-12,-13,-13,-13,-13,-13,-14,-16,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-16,-15,-14,-13,-11,-10,-9.02,-8.04,-7.13,4,3.99,3.99,3.99,3.98,3.97,3.97,3.93,3.91,3.88,3.83,3.77,3.71,3.64,3.59,3.55,3.55,3.58,3.62,3.68,3.74,3.79,3.83,3.86,3.88,3.89,3.90,3.90,3.91,3.93,3.97,4.03,4.13,4.25,4.40,4.55,4.67,4.72,4.70,4.60,4.48,4.38,4.36,4.42,4.57,4.75,5,5.21,5.32,5.37,5.38,5.36,5.27,5.17,5.07,4.91,4.77,4.62,4.47,4.32,4.17,4.10,4.03,4,3.98,3.96,3.95,3.95,3.92,3.92,3.91,3.91,3.92,3.91,3.92,3.95,3.97,3.97,3.97,3.97,3.97,3.95,3.95,3.95,3.96,3.97,3.97,3.98,3.98,3.98,3.98,3.98,3.99,3.99,3.99,3.98,3.98,3.96,3.89,3.82,3.66,3.52,3.39,3.27,3.17,3.11,3.04,3.01,3,3,3,3,3,3,2.99,2.99,2.99,2.99,2.99,2.99,2.98,2.98,2.98,2.99,3,3,3.01,3.02,3.03,3.04,3.07,3.08,3.09,3.11,3.12,3.13,3.15,3.16,3.16,3.15,3.14,3.12,3.08,3,2.96,2.87,2.82,2.75,2.72,2.70,2.67,2.70,2.73,2.75,2.79,2.85,2.87,2.89,2.91,2.92,2.92,2.92,2.92,2.91,2.91,2.89,2.88,2.86,2.82,2.75,2.71,2.62,2.53,2.46,2.37,2.28,2.22,2.14,2.10,2.04,2.01,2,2,2,2.03,2.08,2.11,2.13,2.15,2.17,2.20,2.20,2.20,2.20,2.17,2.16,2.16,2.15,2.13,2.11,2.08,2.04,2.02,2,1.99,1.98,1.97,1.96,1.95,1.92,1.91,1.91,1.90,1.89,1.87,1.85,1.79,1.75,1.72,1.65,1.62,1.60,1.59,1.60,1.62,1.65,1.71,1.76,1.82,1.84,1.84,1.82,1.76,1.71,1.62,1.52,1.42,1.33,1.23,1.13,1.08,1.01,1,0.98,0.98,0.97,0.96,0.92,0.89,0.87,0.83,0.75,0.63,0.50,0.36,0.23,0.13,0.08,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0,-0.10,-0.39,-1.08,-2.96,-4.91,-6.74,-8.13,-9.02,-9.59,-10,-10,-11,-11,-12,-13,-13,-13,-13,-14,-15,-16,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-16,-15,-14,-13,-11,-10,-8.96,-7.96,-7,3.99,3.99,3.99,3.98,3.97,3.96,3.93,3.90,3.86,3.82,3.76,3.70,3.62,3.54,3.48,3.45,3.45,3.47,3.52,3.59,3.65,3.71,3.76,3.79,3.82,3.83,3.84,3.84,3.85,3.87,3.90,3.97,4.05,4.17,4.32,4.47,4.58,4.63,4.61,4.52,4.41,4.32,4.28,4.33,4.43,4.58,4.75,4.93,5.04,5.12,5.14,5.14,5.12,5.07,4.99,4.89,4.79,4.66,4.52,4.37,4.24,4.12,4.04,4,3.96,3.91,3.89,3.87,3.87,3.86,3.85,3.84,3.86,3.87,3.88,3.90,3.92,3.95,3.92,3.91,3.90,3.90,3.88,3.89,3.91,3.95,3.96,3.97,3.97,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.97,3.95,3.88,3.79,3.66,3.52,3.39,3.27,3.16,3.10,3.03,3,3,3,3,3,3,2.99,2.99,2.99,2.99,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.99,2.99,3,3,3,3.01,3.01,3.02,3.03,3.04,3.07,3.07,3.08,3.07,3.07,3.04,3.01,2.98,2.91,2.86,2.78,2.73,2.65,2.62,2.60,2.60,2.62,2.64,2.70,2.75,2.79,2.85,2.87,2.90,2.91,2.91,2.92,2.91,2.91,2.89,2.88,2.86,2.83,2.76,2.71,2.62,2.54,2.47,2.37,2.29,2.23,2.15,2.11,2.07,2.02,2,2,2,2.02,2.08,2.11,2.14,2.17,2.22,2.24,2.24,2.23,2.22,2.20,2.15,2.13,2.12,2.11,2.09,2.07,2.02,2.01,2,2,1.98,1.97,1.96,1.95,1.95,1.92,1.91,1.90,1.88,1.87,1.84,1.78,1.74,1.67,1.62,1.57,1.50,1.47,1.46,1.47,1.50,1.54,1.61,1.67,1.74,1.75,1.75,1.73,1.65,1.59,1.50,1.39,1.29,1.22,1.13,1.08,1.02,1,0.99,0.98,0.98,0.98,0.97,0.97,0.92,0.90,0.87,0.84,0.73,0.58,0.39,0.25,0.13,0.07,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.02,-0.02,-0.24,-0.75,-2.26,-4.40,-6.58,-8.03,-8.93,-9.55,-10,-10,-10,-11,-12,-12,-12,-13,-13,-14,-15,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-13,-11,-10,-8.91,-7.78,-7.01,3.99,3.99,3.98,3.97,3.96,3.93,3.88,3.85,3.79,3.74,3.67,3.59,3.50,3.42,3.36,3.33,3.34,3.37,3.42,3.49,3.55,3.62,3.66,3.70,3.73,3.74,3.75,3.75,3.76,3.77,3.80,3.86,3.93,4.04,4.16,4.29,4.39,4.45,4.42,4.36,4.26,4.17,4.14,4.17,4.25,4.36,4.49,4.61,4.73,4.82,4.87,4.89,4.91,4.90,4.88,4.85,4.77,4.70,4.57,4.42,4.27,4.14,4.04,3.98,3.91,3.87,3.83,3.78,3.75,3.73,3.72,3.71,3.74,3.76,3.82,3.86,3.88,3.88,3.87,3.85,3.83,3.82,3.82,3.84,3.87,3.89,3.91,3.95,3.96,3.97,3.97,3.98,3.97,3.97,3.98,3.98,3.97,3.95,3.88,3.78,3.65,3.52,3.38,3.26,3.16,3.10,3.03,3,3,3,3,3,3,2.99,2.99,2.99,2.98,2.98,2.98,2.98,2.98,2.98,2.97,2.97,2.97,2.98,2.98,2.98,2.98,2.99,2.99,2.99,2.99,2.99,2.99,2.98,2.98,2.98,2.97,2.96,2.93,2.90,2.87,2.82,2.75,2.68,2.62,2.55,2.52,2.50,2.50,2.52,2.58,2.62,2.70,2.75,2.82,2.86,2.88,2.90,2.91,2.91,2.90,2.89,2.88,2.87,2.83,2.76,2.71,2.62,2.54,2.47,2.37,2.29,2.24,2.16,2.12,2.08,2.03,2.01,2,2,2.02,2.08,2.12,2.16,2.23,2.26,2.29,2.33,2.33,2.29,2.25,2.23,2.17,2.13,2.11,2.08,2.04,2.02,2,2,1.99,1.98,1.98,1.97,1.96,1.95,1.92,1.91,1.89,1.88,1.86,1.83,1.77,1.73,1.65,1.59,1.50,1.45,1.37,1.34,1.33,1.34,1.37,1.42,1.50,1.59,1.63,1.65,1.64,1.61,1.53,1.47,1.37,1.27,1.20,1.12,1.07,1.01,1,0.99,0.98,0.98,0.98,0.98,0.98,0.97,0.96,0.95,0.91,0.88,0.79,0.62,0.42,0.25,0.13,0.07,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.03,0.01,-0.12,-0.48,-1.57,-3.84,-6.11,-7.68,-8.70,-9.40,-9.92,-10,-10,-11,-11,-12,-12,-12,-13,-14,-15,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-13,-11,-10,-9.04,-7.78,-7.11,3.99,3.98,3.97,3.96,3.92,3.87,3.83,3.77,3.71,3.64,3.55,3.47,3.39,3.32,3.26,3.23,3.24,3.27,3.33,3.38,3.45,3.51,3.55,3.59,3.61,3.63,3.63,3.64,3.64,3.65,3.68,3.73,3.78,3.87,3.97,4.07,4.14,4.18,4.17,4.12,4.04,3.99,3.97,3.98,4.04,4.12,4.22,4.32,4.40,4.49,4.57,4.62,4.67,4.73,4.75,4.75,4.72,4.65,4.57,4.46,4.28,4.14,4.03,3.95,3.86,3.77,3.72,3.65,3.61,3.58,3.53,3.53,3.58,3.63,3.71,3.75,3.79,3.79,3.77,3.73,3.67,3.66,3.67,3.73,3.76,3.83,3.87,3.90,3.92,3.96,3.96,3.96,3.97,3.97,3.98,3.98,3.97,3.95,3.87,3.77,3.65,3.52,3.38,3.26,3.16,3.09,3.03,3,3,3,3,3,2.99,2.99,2.99,2.98,2.98,2.98,2.98,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.96,2.96,2.93,2.93,2.92,2.91,2.90,2.89,2.87,2.86,2.83,2.79,2.75,2.70,2.64,2.58,2.51,2.46,2.42,2.40,2.40,2.43,2.48,2.54,2.62,2.71,2.74,2.79,2.83,2.85,2.86,2.87,2.86,2.85,2.83,2.79,2.74,2.67,2.61,2.53,2.46,2.38,2.29,2.24,2.17,2.12,2.10,2.04,2.02,2.01,2.01,2.02,2.08,2.12,2.17,2.25,2.32,2.37,2.41,2.42,2.41,2.38,2.35,2.27,2.22,2.15,2.11,2.07,2.02,2,2,1.99,1.98,1.98,1.97,1.96,1.95,1.92,1.91,1.89,1.88,1.86,1.83,1.76,1.72,1.63,1.57,1.49,1.39,1.33,1.25,1.23,1.21,1.22,1.25,1.32,1.38,1.47,1.51,1.53,1.52,1.49,1.40,1.34,1.25,1.16,1.11,1.04,1.01,1,0.99,0.99,0.98,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.95,0.91,0.85,0.65,0.46,0.26,0.14,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.03,-0.02,-0.26,-0.66,-3.23,-5.48,-7.18,-8.38,-9.21,-9.80,-10,-10,-10,-11,-11,-11,-11,-12,-13,-15,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-13,-11,-10,-9.13,-7.90,-7.12,3.98,3.98,3.97,3.92,3.87,3.82,3.74,3.67,3.60,3.52,3.43,3.35,3.27,3.21,3.16,3.14,3.14,3.17,3.23,3.28,3.34,3.39,3.42,3.46,3.49,3.50,3.51,3.51,3.51,3.52,3.54,3.58,3.62,3.67,3.74,3.82,3.87,3.89,3.88,3.85,3.80,3.77,3.76,3.77,3.82,3.88,3.95,4.02,4.10,4.17,4.25,4.35,4.41,4.50,4.54,4.59,4.60,4.58,4.50,4.40,4.25,4.12,3.99,3.87,3.76,3.66,3.59,3.50,3.46,3.39,3.37,3.37,3.41,3.50,3.58,3.64,3.67,3.67,3.63,3.58,3.50,3.49,3.50,3.59,3.64,3.73,3.78,3.86,3.89,3.90,3.92,3.95,3.96,3.97,3.97,3.98,3.97,3.95,3.87,3.76,3.64,3.51,3.38,3.25,3.15,3.09,3.02,3,3,3,3,3,2.99,2.99,2.99,2.98,2.98,2.98,2.97,2.97,2.97,2.97,2.97,2.97,2.96,2.96,2.96,2.96,2.95,2.95,2.92,2.91,2.89,2.88,2.86,2.84,2.82,2.79,2.77,2.74,2.72,2.68,2.64,2.59,2.53,2.47,2.41,2.36,2.33,2.32,2.32,2.35,2.40,2.47,2.53,2.60,2.66,2.72,2.76,2.79,2.82,2.83,2.83,2.80,2.77,2.73,2.67,2.60,2.52,2.45,2.37,2.30,2.25,2.20,2.15,2.12,2.09,2.04,2.02,2.02,2.02,2.07,2.12,2.17,2.25,2.34,2.41,2.49,2.52,2.54,2.52,2.50,2.42,2.36,2.27,2.20,2.12,2.07,2.02,2,1.99,1.98,1.98,1.97,1.97,1.96,1.95,1.91,1.90,1.88,1.86,1.82,1.76,1.71,1.63,1.54,1.47,1.37,1.29,1.22,1.15,1.12,1.12,1.12,1.15,1.21,1.27,1.35,1.38,1.40,1.39,1.36,1.28,1.23,1.14,1.10,1.03,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.95,0.87,0.70,0.47,0.26,0.14,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.02,-0.13,-0.35,-2.67,-4.88,-6.82,-8.18,-9.10,-9.72,-10,-10,-10,-10,-11,-11,-11,-12,-13,-14,-16,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-13,-11,-10,-9.13,-8.01,-7.08,3.98,3.98,3.92,3.88,3.82,3.73,3.64,3.55,3.47,3.39,3.30,3.23,3.17,3.12,3.09,3.07,3.08,3.11,3.14,3.18,3.23,3.27,3.30,3.34,3.35,3.36,3.37,3.38,3.38,3.38,3.39,3.41,3.45,3.49,3.52,3.57,3.60,3.62,3.61,3.59,3.57,3.54,3.55,3.57,3.60,3.64,3.68,3.74,3.80,3.87,3.96,4.03,4.12,4.22,4.28,4.36,4.39,4.40,4.37,4.32,4.16,4.02,3.89,3.77,3.64,3.53,3.45,3.36,3.28,3.25,3.23,3.24,3.27,3.37,3.45,3.50,3.53,3.53,3.49,3.40,3.34,3.29,3.34,3.41,3.50,3.60,3.70,3.76,3.83,3.87,3.90,3.92,3.96,3.97,3.97,3.98,3.97,3.91,3.86,3.75,3.63,3.50,3.37,3.25,3.15,3.09,3.02,3,3,3,3,3,2.99,2.99,2.98,2.98,2.98,2.97,2.97,2.97,2.97,2.96,2.96,2.96,2.96,2.96,2.96,2.95,2.92,2.91,2.89,2.88,2.85,2.82,2.78,2.75,2.73,2.70,2.66,2.64,2.61,2.58,2.53,2.48,2.42,2.37,2.32,2.27,2.25,2.24,2.25,2.28,2.33,2.39,2.46,2.52,2.59,2.65,2.71,2.74,2.76,2.77,2.76,2.75,2.71,2.66,2.60,2.52,2.45,2.37,2.30,2.25,2.21,2.16,2.14,2.12,2.10,2.08,2.04,2.04,2.07,2.10,2.15,2.25,2.35,2.42,2.51,2.60,2.63,2.64,2.63,2.59,2.51,2.42,2.34,2.24,2.14,2.08,2.02,2,1.99,1.98,1.97,1.97,1.96,1.95,1.92,1.90,1.88,1.86,1.82,1.76,1.71,1.62,1.54,1.47,1.37,1.28,1.21,1.13,1.09,1.07,1.04,1.07,1.09,1.12,1.17,1.24,1.26,1.27,1.26,1.23,1.17,1.12,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.96,0.89,0.73,0.49,0.29,0.14,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.03,-0.05,-0.21,-1.79,-4.02,-6.16,-7.71,-8.79,-9.52,-10,-10,-10,-10,-10,-10,-10,-11,-12,-14,-15,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-13,-11,-10,-9.12,-8,-6.99,3.98,3.95,3.89,3.84,3.72,3.62,3.52,3.43,3.35,3.26,3.20,3.13,3.09,3.05,3.03,3.02,3.02,3.04,3.08,3.10,3.13,3.16,3.20,3.22,3.23,3.24,3.25,3.25,3.25,3.26,3.26,3.27,3.29,3.32,3.34,3.36,3.37,3.38,3.37,3.36,3.35,3.35,3.35,3.37,3.39,3.41,3.45,3.49,3.53,3.59,3.64,3.74,3.83,3.90,4,4.08,4.13,4.17,4.17,4.13,4.01,3.88,3.76,3.64,3.51,3.40,3.32,3.23,3.16,3.13,3.12,3.13,3.16,3.25,3.32,3.37,3.38,3.37,3.33,3.25,3.20,3.15,3.20,3.25,3.37,3.47,3.58,3.65,3.75,3.83,3.87,3.89,3.92,3.95,3.96,3.96,3.95,3.90,3.84,3.75,3.62,3.50,3.37,3.25,3.15,3.09,3.02,3,3,3,3,3,2.99,2.99,2.98,2.98,2.98,2.97,2.97,2.97,2.96,2.96,2.96,2.96,2.96,2.96,2.95,2.91,2.90,2.88,2.86,2.83,2.79,2.75,2.71,2.67,2.63,2.60,2.57,2.53,2.50,2.46,2.41,2.37,2.33,2.27,2.23,2.20,2.17,2.16,2.18,2.22,2.26,2.32,2.38,2.45,2.52,2.58,2.63,2.67,2.70,2.71,2.70,2.67,2.63,2.58,2.51,2.45,2.37,2.29,2.24,2.20,2.17,2.15,2.13,2.12,2.11,2.10,2.09,2.09,2.10,2.13,2.23,2.33,2.41,2.52,2.62,2.67,2.73,2.74,2.73,2.67,2.60,2.50,2.39,2.27,2.16,2.09,2.02,2,1.98,1.98,1.97,1.97,1.96,1.95,1.91,1.88,1.86,1.82,1.76,1.71,1.62,1.53,1.46,1.37,1.27,1.21,1.12,1.08,1.02,1,1,1.01,1.02,1.07,1.10,1.13,1.15,1.16,1.15,1.12,1.10,1.07,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.90,0.76,0.50,0.29,0.14,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0,-0.12,-0.30,-3.38,-5.63,-7.33,-8.52,-9.35,-9.91,-10,-10,-10,-10,-10,-10,-11,-12,-13,-15,-16,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-12,-11,-10,-9,-7.88,-6.87,3.97,3.91,3.86,3.74,3.62,3.51,3.41,3.32,3.23,3.15,3.11,3.07,3.02,3,2.99,2.99,2.99,3,3.01,3.03,3.05,3.08,3.10,3.11,3.13,3.13,3.14,3.14,3.15,3.15,3.15,3.16,3.16,3.17,3.18,3.18,3.18,3.18,3.17,3.16,3.16,3.16,3.17,3.17,3.20,3.21,3.23,3.25,3.28,3.33,3.37,3.42,3.50,3.60,3.67,3.76,3.85,3.89,3.91,3.90,3.83,3.72,3.61,3.50,3.38,3.28,3.21,3.12,3.09,3.07,3.04,3.08,3.11,3.14,3.21,3.24,3.25,3.24,3.20,3.13,3.10,3.08,3.10,3.14,3.25,3.36,3.47,3.57,3.66,3.75,3.84,3.87,3.90,3.92,3.95,3.95,3.92,3.87,3.82,3.73,3.62,3.50,3.37,3.25,3.15,3.09,3.02,3,3,3,3,2.99,2.99,2.99,2.98,2.98,2.97,2.97,2.97,2.96,2.96,2.95,2.95,2.95,2.95,2.92,2.91,2.89,2.87,2.85,2.80,2.77,2.73,2.68,2.63,2.59,2.54,2.50,2.46,2.42,2.39,2.35,2.32,2.27,2.23,2.18,2.15,2.13,2.11,2.11,2.12,2.15,2.20,2.25,2.30,2.37,2.43,2.50,2.54,2.59,2.61,2.62,2.61,2.59,2.54,2.49,2.42,2.36,2.29,2.23,2.18,2.15,2.14,2.13,2.13,2.13,2.13,2.12,2.12,2.12,2.12,2.20,2.28,2.39,2.51,2.62,2.71,2.75,2.79,2.79,2.78,2.75,2.66,2.58,2.45,2.32,2.20,2.11,2.03,2,1.98,1.98,1.97,1.96,1.95,1.92,1.89,1.87,1.83,1.76,1.71,1.62,1.53,1.46,1.37,1.27,1.21,1.12,1.08,1.02,1,0.99,0.99,0.99,1,1.01,1.03,1.07,1.08,1.09,1.08,1.07,1.02,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.92,0.79,0.52,0.32,0.15,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.07,-0.09,-0.24,-3.17,-5.45,-7.18,-8.43,-9.32,-9.92,-10,-10,-10,-10,-10,-10,-10,-12,-13,-14,-15,-16,-17,-18,-18,-18,-18,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-16,-15,-13,-12,-11,-10,-8.87,-7.65,-6.63,3.95,3.86,3.76,3.63,3.51,3.40,3.29,3.21,3.13,3.08,3.03,3,2.98,2.97,2.96,2.96,2.96,2.96,2.97,2.98,2.99,3,3.02,3.03,3.04,3.05,3.07,3.07,3.07,3.07,3.07,3.07,3.07,3.07,3.07,3.05,3.05,3.03,3.02,3.01,3,3,3,3.01,3.01,3.02,3.03,3.03,3.05,3.08,3.11,3.14,3.22,3.28,3.37,3.46,3.53,3.61,3.64,3.64,3.60,3.51,3.45,3.35,3.25,3.17,3.12,3.07,3.02,3.01,3.01,3.02,3.04,3.09,3.11,3.12,3.13,3.12,3.10,3.07,3.02,3.02,3.04,3.10,3.16,3.26,3.37,3.49,3.60,3.70,3.77,3.85,3.88,3.91,3.92,3.95,3.90,3.87,3.79,3.72,3.61,3.49,3.37,3.25,3.14,3.09,3.02,3,3,3,3,2.99,2.99,2.99,2.98,2.98,2.97,2.97,2.96,2.96,2.95,2.95,2.92,2.92,2.91,2.90,2.88,2.87,2.84,2.80,2.76,2.72,2.66,2.61,2.55,2.50,2.45,2.40,2.36,2.33,2.28,2.25,2.22,2.18,2.14,2.11,2.08,2.07,2.05,2.05,2.07,2.10,2.13,2.18,2.24,2.29,2.36,2.41,2.46,2.50,2.52,2.53,2.52,2.49,2.46,2.40,2.34,2.27,2.22,2.17,2.14,2.12,2.12,2.13,2.13,2.14,2.15,2.15,2.16,2.17,2.21,2.26,2.37,2.50,2.61,2.71,2.77,2.83,2.86,2.86,2.85,2.78,2.72,2.62,2.49,2.35,2.22,2.12,2.03,2,1.98,1.97,1.97,1.96,1.92,1.90,1.87,1.84,1.77,1.71,1.62,1.54,1.46,1.37,1.27,1.21,1.12,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,1,1,1,1.01,1.01,1.01,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.97,0.92,0.83,0.57,0.33,0.15,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.07,-0.02,-1,-3.16,-5.28,-7.01,-8.33,-9.28,-9.96,-10,-10,-10,-10,-10,-10,-10,-11,-12,-13,-15,-15,-16,-17,-17,-18,-18,-18,-18,-19,-19,-19,-18,-18,-18,-17,-16,-15,-14,-13,-12,-11,-9.99,-8.72,-7.40,-6.47,3.88,3.77,3.65,3.52,3.39,3.28,3.18,3.11,3.04,3,2.97,2.96,2.93,2.92,2.92,2.91,2.91,2.91,2.91,2.91,2.92,2.93,2.96,2.97,2.99,3,3.01,3.01,3.01,3.01,3,3,2.99,2.99,2.97,2.96,2.93,2.91,2.89,2.88,2.87,2.86,2.86,2.86,2.86,2.86,2.86,2.85,2.86,2.86,2.88,2.89,2.95,3,3.09,3.16,3.25,3.34,3.38,3.39,3.37,3.34,3.27,3.22,3.14,3.10,3.04,3.01,3,3,3,3,3.01,3.02,3.04,3.04,3.07,3.04,3.03,3.01,3,3,3.02,3.07,3.12,3.21,3.28,3.39,3.51,3.62,3.73,3.79,3.86,3.89,3.91,3.91,3.89,3.85,3.78,3.71,3.60,3.48,3.37,3.25,3.14,3.08,3.02,3,3,3,2.99,2.99,2.98,2.98,2.98,2.97,2.97,2.96,2.95,2.95,2.92,2.92,2.91,2.90,2.89,2.88,2.86,2.83,2.80,2.76,2.71,2.65,2.59,2.53,2.47,2.41,2.36,2.30,2.26,2.23,2.20,2.16,2.13,2.10,2.08,2.04,2.02,2.01,2,2,2.01,2.04,2.08,2.12,2.16,2.22,2.26,2.32,2.36,2.40,2.42,2.43,2.42,2.39,2.36,2.30,2.25,2.20,2.15,2.12,2.10,2.09,2.10,2.11,2.13,2.14,2.16,2.17,2.20,2.24,2.29,2.37,2.48,2.60,2.71,2.77,2.84,2.87,2.88,2.88,2.87,2.84,2.76,2.64,2.50,2.37,2.23,2.12,2.04,2,1.98,1.97,1.96,1.95,1.91,1.88,1.85,1.78,1.72,1.63,1.54,1.47,1.37,1.27,1.21,1.12,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.95,0.86,0.59,0.35,0.15,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.07,0.01,-1.01,-3.26,-5.27,-7.02,-8.38,-9.40,-10,-10,-10,-11,-11,-10,-10,-10,-11,-12,-13,-14,-15,-15,-16,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-14,-13,-12,-11,-9.96,-8.63,-7.41,-6.30,3.83,3.67,3.53,3.40,3.27,3.16,3.08,3.01,2.96,2.92,2.90,2.89,2.88,2.87,2.87,2.86,2.85,2.84,2.84,2.84,2.85,2.87,2.89,2.91,2.93,2.96,2.97,2.97,2.97,2.97,2.96,2.95,2.92,2.91,2.89,2.87,2.84,2.80,2.77,2.75,2.74,2.73,2.73,2.73,2.73,2.72,2.72,2.70,2.68,2.68,2.68,2.67,2.72,2.76,2.85,2.92,3.02,3.11,3.16,3.20,3.21,3.17,3.14,3.12,3.08,3.03,3,3,2.99,2.99,2.99,2.99,3,3,3,3,3,3,3,3,3,3,3,3.03,3.08,3.13,3.23,3.33,3.42,3.54,3.64,3.74,3.82,3.86,3.88,3.90,3.87,3.83,3.76,3.67,3.59,3.47,3.36,3.25,3.14,3.08,3.02,3,3,2.99,2.99,2.99,2.98,2.98,2.97,2.97,2.96,2.96,2.95,2.92,2.92,2.91,2.91,2.89,2.88,2.86,2.83,2.79,2.75,2.71,2.65,2.59,2.52,2.46,2.39,2.33,2.27,2.22,2.17,2.14,2.11,2.08,2.05,2.03,2.01,1.98,1.97,1.96,1.95,1.96,1.97,1.99,2.01,2.05,2.09,2.13,2.18,2.22,2.26,2.29,2.32,2.33,2.32,2.29,2.25,2.21,2.16,2.12,2.09,2.07,2.04,2.05,2.07,2.09,2.11,2.14,2.16,2.20,2.24,2.29,2.37,2.47,2.59,2.71,2.78,2.86,2.88,2.90,2.91,2.91,2.89,2.87,2.77,2.65,2.51,2.37,2.24,2.12,2.04,2,1.98,1.97,1.96,1.92,1.90,1.87,1.82,1.74,1.64,1.54,1.47,1.37,1.28,1.21,1.12,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.95,0.87,0.61,0.36,0.16,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.07,0,-0.28,-3.29,-5.42,-7.20,-8.59,-9.64,-10,-10,-11,-11,-11,-11,-10,-10,-11,-12,-13,-13,-14,-15,-15,-16,-16,-17,-17,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-14,-13,-12,-11,-9.92,-8.62,-7.33,-5.88,3.71,3.57,3.41,3.28,3.16,3.05,2.97,2.90,2.86,2.83,2.82,2.80,2.79,2.79,2.78,2.77,2.75,2.74,2.74,2.74,2.76,2.79,2.83,2.86,2.89,2.91,2.92,2.93,2.93,2.92,2.91,2.89,2.87,2.84,2.80,2.77,2.73,2.70,2.65,2.63,2.62,2.61,2.61,2.61,2.61,2.61,2.60,2.59,2.55,2.54,2.52,2.50,2.51,2.57,2.63,2.73,2.84,2.91,3,3.03,3.07,3.08,3.07,3.03,3.01,3,2.99,2.99,2.98,2.98,2.98,2.98,2.99,2.99,2.99,2.99,2.99,2.99,2.99,2.99,2.99,2.99,3,3,3.03,3.10,3.15,3.25,3.35,3.46,3.57,3.64,3.74,3.79,3.85,3.87,3.84,3.78,3.74,3.65,3.57,3.46,3.34,3.24,3.13,3.08,3.02,3,2.99,2.99,2.99,2.99,2.98,2.98,2.97,2.96,2.96,2.95,2.95,2.92,2.92,2.91,2.90,2.88,2.86,2.83,2.79,2.75,2.70,2.64,2.58,2.51,2.45,2.37,2.30,2.24,2.20,2.14,2.10,2.07,2.03,2.01,1.99,1.97,1.95,1.92,1.91,1.90,1.90,1.90,1.91,1.93,1.96,1.99,2.02,2.05,2.09,2.12,2.15,2.18,2.21,2.21,2.20,2.18,2.15,2.11,2.08,2.04,2.02,2,2,2.01,2.03,2.05,2.09,2.12,2.15,2.21,2.26,2.34,2.43,2.54,2.66,2.78,2.87,2.89,2.92,2.95,2.95,2.95,2.91,2.87,2.78,2.66,2.51,2.37,2.24,2.12,2.04,2,1.98,1.96,1.95,1.91,1.87,1.83,1.75,1.65,1.58,1.48,1.37,1.28,1.21,1.13,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.89,0.63,0.38,0.20,0.08,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.02,-0.05,-0.33,-2.95,-5.65,-7.53,-8.95,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-14,-15,-15,-16,-16,-17,-17,-17,-18,-17,-17,-17,-17,-16,-15,-15,-14,-13,-12,-11,-9.88,-8.53,-7.17,-5.51,3.58,3.45,3.29,3.16,3.04,2.95,2.86,2.79,2.74,2.72,2.70,2.68,2.67,2.67,2.66,2.65,2.63,2.62,2.62,2.63,2.65,2.70,2.75,2.79,2.84,2.87,2.89,2.90,2.90,2.89,2.87,2.84,2.80,2.76,2.72,2.66,2.62,2.58,2.53,2.51,2.50,2.50,2.50,2.51,2.52,2.52,2.51,2.50,2.47,2.43,2.40,2.37,2.37,2.39,2.47,2.57,2.66,2.77,2.87,2.92,2.97,2.99,3,3,2.99,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,3,3,3.04,3.11,3.16,3.25,3.35,3.45,3.54,3.63,3.73,3.77,3.83,3.77,3.75,3.70,3.62,3.52,3.41,3.32,3.22,3.12,3.07,3.01,3,2.99,2.99,2.99,2.98,2.97,2.97,2.96,2.96,2.95,2.95,2.92,2.92,2.91,2.90,2.88,2.86,2.84,2.79,2.75,2.70,2.64,2.58,2.51,2.43,2.37,2.29,2.23,2.17,2.12,2.08,2.03,2,1.98,1.96,1.93,1.91,1.89,1.87,1.86,1.85,1.85,1.85,1.86,1.88,1.89,1.92,1.95,1.98,2,2.02,2.05,2.07,2.09,2.09,2.08,2.07,2.04,2.02,1.99,1.97,1.96,1.95,1.95,1.97,1.99,2.01,2.04,2.09,2.13,2.20,2.27,2.36,2.46,2.58,2.68,2.78,2.86,2.90,2.92,2.95,2.95,2.96,2.92,2.87,2.77,2.65,2.50,2.37,2.23,2.12,2.03,2,1.98,1.96,1.92,1.89,1.85,1.76,1.67,1.60,1.49,1.38,1.28,1.21,1.13,1.09,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.91,0.64,0.39,0.21,0.09,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.07,0.02,-0.12,-1.73,-4,-6.11,-7.96,-9.40,-10,-11,-11,-12,-12,-12,-12,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-12,-11,-9.79,-8.42,-7.03,-5.10,3.49,3.34,3.21,3.07,2.93,2.83,2.73,2.65,2.61,2.57,2.55,2.53,2.53,2.52,2.52,2.50,2.49,2.48,2.48,2.49,2.53,2.59,2.65,2.72,2.77,2.83,2.85,2.87,2.87,2.85,2.82,2.78,2.73,2.67,2.62,2.57,2.50,2.46,2.41,2.39,2.39,2.39,2.41,2.42,2.45,2.45,2.45,2.43,2.40,2.37,2.33,2.27,2.25,2.27,2.34,2.41,2.52,2.64,2.75,2.85,2.89,2.91,2.95,2.96,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.97,2.98,2.99,3,3.04,3.10,3.15,3.25,3.34,3.41,3.51,3.61,3.66,3.71,3.71,3.66,3.62,3.54,3.48,3.37,3.27,3.17,3.11,3.04,3.01,3,2.99,2.98,2.98,2.97,2.97,2.96,2.96,2.95,2.95,2.92,2.92,2.91,2.90,2.88,2.86,2.83,2.78,2.75,2.70,2.64,2.58,2.51,2.43,2.36,2.29,2.22,2.16,2.11,2.05,2.01,1.98,1.95,1.92,1.89,1.87,1.85,1.83,1.80,1.79,1.79,1.79,1.79,1.80,1.82,1.83,1.85,1.87,1.89,1.90,1.92,1.93,1.96,1.96,1.97,1.96,1.95,1.93,1.91,1.90,1.88,1.88,1.88,1.89,1.90,1.93,1.97,2.01,2.05,2.11,2.17,2.25,2.35,2.45,2.54,2.65,2.75,2.82,2.87,2.90,2.91,2.93,2.92,2.89,2.86,2.77,2.62,2.49,2.35,2.22,2.11,2.02,1.99,1.97,1.95,1.90,1.87,1.82,1.73,1.62,1.50,1.38,1.28,1.22,1.13,1.09,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.96,0.85,0.64,0.40,0.22,0.09,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.04,0,-0.95,-2.86,-5.02,-6.87,-8.54,-9.95,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-12,-11,-9.75,-8.30,-6.92,-4.88,3.38,3.24,3.10,2.95,2.82,2.70,2.60,2.51,2.46,2.42,2.39,2.38,2.37,2.37,2.36,2.36,2.35,2.34,2.35,2.36,2.40,2.47,2.55,2.63,2.71,2.76,2.80,2.83,2.82,2.79,2.76,2.71,2.65,2.59,2.52,2.46,2.39,2.35,2.30,2.29,2.29,2.30,2.33,2.35,2.37,2.39,2.39,2.38,2.36,2.33,2.28,2.24,2.20,2.17,2.23,2.29,2.40,2.52,2.65,2.76,2.84,2.87,2.89,2.91,2.92,2.92,2.95,2.95,2.95,2.96,2.95,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.96,2.97,2.98,2.99,3,3.04,3.10,3.15,3.24,3.32,3.39,3.49,3.57,3.61,3.62,3.60,3.54,3.49,3.40,3.33,3.24,3.14,3.09,3.03,3,2.99,2.98,2.98,2.97,2.97,2.96,2.96,2.95,2.95,2.95,2.92,2.91,2.90,2.88,2.86,2.84,2.78,2.74,2.70,2.64,2.58,2.50,2.43,2.36,2.28,2.22,2.15,2.10,2.04,2,1.97,1.93,1.90,1.87,1.85,1.82,1.78,1.76,1.74,1.73,1.73,1.72,1.73,1.73,1.75,1.76,1.77,1.78,1.79,1.80,1.82,1.83,1.84,1.84,1.84,1.84,1.83,1.82,1.80,1.80,1.79,1.79,1.80,1.82,1.84,1.87,1.91,1.96,2.01,2.07,2.14,2.23,2.32,2.40,2.50,2.59,2.67,2.75,2.80,2.85,2.88,2.88,2.87,2.83,2.76,2.68,2.59,2.47,2.32,2.17,2.09,2.01,1.98,1.96,1.92,1.88,1.84,1.75,1.63,1.51,1.39,1.28,1.22,1.13,1.09,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.96,0.96,0.96,0.97,0.97,0.97,0.97,0.98,0.95,0.84,0.63,0.40,0.21,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.07,0.03,-0.04,-1.77,-4.02,-6.01,-7.72,-9.20,-10,-11,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-13,-14,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-16,-16,-16,-15,-14,-13,-12,-11,-9.77,-8.27,-6.92,-4.91,3.24,3.11,2.97,2.83,2.68,2.57,2.46,2.38,2.32,2.28,2.26,2.24,2.24,2.24,2.23,2.23,2.22,2.22,2.22,2.25,2.30,2.37,2.46,2.54,2.62,2.70,2.74,2.76,2.76,2.74,2.68,2.63,2.57,2.49,2.41,2.35,2.29,2.25,2.22,2.20,2.21,2.22,2.25,2.27,2.30,2.33,2.34,2.34,2.32,2.27,2.24,2.21,2.15,2.12,2.13,2.21,2.29,2.41,2.57,2.67,2.75,2.82,2.85,2.87,2.87,2.88,2.88,2.89,2.90,2.90,2.91,2.92,2.95,2.96,2.95,2.95,2.95,2.95,2.95,2.95,2.95,2.95,2.95,2.96,2.97,2.98,2.99,3.01,3.04,3.10,3.14,3.22,3.28,3.37,3.42,3.48,3.50,3.49,3.46,3.39,3.34,3.25,3.17,3.12,3.07,3.01,3,2.98,2.98,2.97,2.96,2.96,2.96,2.95,2.95,2.95,2.92,2.91,2.90,2.89,2.86,2.84,2.79,2.74,2.70,2.63,2.57,2.50,2.42,2.36,2.28,2.22,2.15,2.10,2.04,2,1.96,1.92,1.89,1.85,1.83,1.79,1.75,1.72,1.70,1.67,1.65,1.65,1.64,1.64,1.65,1.66,1.67,1.68,1.70,1.70,1.71,1.71,1.71,1.72,1.72,1.72,1.71,1.71,1.70,1.70,1.70,1.68,1.70,1.72,1.74,1.77,1.80,1.85,1.90,1.97,2.03,2.10,2.17,2.26,2.35,2.42,2.50,2.58,2.64,2.71,2.76,2.79,2.79,2.76,2.72,2.65,2.58,2.48,2.36,2.24,2.13,2.04,2,1.97,1.95,1.90,1.86,1.77,1.66,1.53,1.39,1.28,1.21,1.12,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.95,0.92,0.92,0.91,0.92,0.95,0.96,0.96,0.96,0.96,0.92,0.84,0.63,0.40,0.21,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.08,0.08,0.01,-0.90,-3.18,-5.15,-7.03,-8.58,-9.96,-11,-12,-13,-13,-14,-13,-13,-12,-12,-11,-11,-11,-12,-12,-12,-13,-14,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-16,-16,-15,-14,-13,-12,-11,-9.97,-8.49,-7.15,-5.09,3.08,2.99,2.84,2.70,2.55,2.43,2.34,2.26,2.21,2.17,2.15,2.14,2.13,2.13,2.12,2.12,2.11,2.11,2.12,2.15,2.21,2.28,2.36,2.45,2.54,2.62,2.66,2.70,2.68,2.66,2.61,2.54,2.47,2.39,2.32,2.25,2.20,2.16,2.13,2.12,2.13,2.15,2.17,2.21,2.24,2.26,2.27,2.27,2.26,2.23,2.18,2.15,2.12,2.10,2.10,2.14,2.21,2.33,2.46,2.59,2.65,2.74,2.76,2.75,2.76,2.77,2.78,2.79,2.82,2.84,2.86,2.87,2.88,2.89,2.90,2.89,2.90,2.90,2.91,2.91,2.92,2.92,2.92,2.95,2.96,2.96,2.97,2.99,3,3.03,3.09,3.13,3.21,3.25,3.32,3.36,3.37,3.37,3.36,3.32,3.25,3.21,3.13,3.09,3.03,3,2.99,2.98,2.97,2.97,2.96,2.95,2.95,2.95,2.92,2.92,2.91,2.90,2.89,2.87,2.83,2.79,2.74,2.70,2.63,2.57,2.50,2.42,2.36,2.28,2.22,2.15,2.10,2.04,2,1.96,1.91,1.88,1.85,1.80,1.77,1.73,1.68,1.65,1.62,1.60,1.58,1.57,1.55,1.55,1.57,1.57,1.58,1.59,1.59,1.60,1.60,1.60,1.60,1.60,1.59,1.59,1.59,1.58,1.58,1.57,1.57,1.58,1.59,1.61,1.64,1.68,1.73,1.79,1.86,1.92,1.99,2.05,2.13,2.20,2.26,2.33,2.39,2.45,2.51,2.58,2.62,2.65,2.65,2.62,2.58,2.51,2.45,2.36,2.27,2.17,2.09,2.02,1.98,1.95,1.90,1.86,1.76,1.66,1.52,1.39,1.26,1.17,1.11,1.07,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.95,0.92,0.90,0.87,0.87,0.85,0.86,0.87,0.89,0.91,0.92,0.92,0.88,0.77,0.61,0.40,0.23,0.10,0.02,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.09,0.10,0.08,-0.03,-2.07,-4.33,-6.27,-7.90,-9.25,-10,-11,-12,-13,-13,-14,-13,-12,-12,-11,-11,-11,-11,-11,-12,-12,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-16,-16,-15,-15,-14,-12,-11,-10,-8.93,-7.65,-5.42,2.93,2.85,2.70,2.55,2.43,2.32,2.23,2.16,2.12,2.09,2.07,2.05,2.05,2.05,2.04,2.04,2.04,2.04,2.05,2.09,2.13,2.21,2.28,2.37,2.45,2.53,2.58,2.61,2.60,2.57,2.51,2.45,2.37,2.29,2.23,2.17,2.13,2.10,2.08,2.07,2.08,2.09,2.12,2.14,2.17,2.20,2.21,2.21,2.20,2.17,2.14,2.11,2.08,2.04,2.07,2.09,2.14,2.24,2.34,2.42,2.51,2.58,2.61,2.62,2.63,2.64,2.66,2.70,2.72,2.75,2.77,2.79,2.83,2.84,2.85,2.86,2.87,2.88,2.89,2.90,2.90,2.91,2.91,2.92,2.95,2.95,2.96,2.97,2.98,3,3.03,3.08,3.12,3.16,3.22,3.25,3.26,3.26,3.25,3.24,3.20,3.13,3.10,3.04,3.01,3,2.98,2.97,2.97,2.96,2.96,2.95,2.92,2.92,2.91,2.90,2.89,2.88,2.86,2.84,2.79,2.75,2.68,2.63,2.57,2.50,2.42,2.36,2.28,2.22,2.15,2.10,2.04,2,1.96,1.91,1.88,1.84,1.80,1.76,1.72,1.67,1.62,1.58,1.54,1.51,1.49,1.47,1.47,1.46,1.47,1.47,1.48,1.48,1.49,1.49,1.49,1.49,1.48,1.48,1.48,1.47,1.47,1.46,1.46,1.45,1.45,1.46,1.48,1.50,1.54,1.60,1.66,1.73,1.80,1.88,1.95,2.01,2.08,2.13,2.17,2.23,2.27,2.32,2.37,2.41,2.46,2.48,2.47,2.45,2.40,2.36,2.30,2.24,2.17,2.10,2.03,1.98,1.93,1.89,1.85,1.76,1.65,1.52,1.38,1.25,1.14,1.10,1.03,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.96,0.95,0.91,0.87,0.82,0.76,0.74,0.74,0.75,0.78,0.85,0.88,0.90,0.90,0.87,0.75,0.60,0.39,0.23,0.10,0.02,0,0,0,0,0,0,0,0,0,0,0.03,0.08,0.10,0.09,0,-0.16,-2.87,-5.49,-7.25,-8.63,-9.77,-10,-12,-13,-13,-13,-14,-13,-12,-11,-11,-11,-11,-11,-11,-11,-12,-13,-13,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-16,-16,-15,-14,-13,-11,-10,-9.52,-8.33,-6.26,2.79,2.68,2.55,2.42,2.32,2.22,2.14,2.09,2.05,2.02,2.01,2,2,2,1.99,1.99,1.99,1.99,2.01,2.03,2.09,2.14,2.22,2.29,2.36,2.42,2.47,2.50,2.50,2.47,2.41,2.35,2.27,2.21,2.15,2.10,2.07,2.04,2.03,2.02,2.02,2.04,2.07,2.09,2.11,2.13,2.14,2.14,2.13,2.11,2.08,2.07,2.02,2,2.01,2.03,2.09,2.14,2.24,2.32,2.37,2.42,2.47,2.49,2.50,2.51,2.53,2.57,2.60,2.62,2.66,2.71,2.73,2.75,2.77,2.79,2.83,2.85,2.87,2.87,2.88,2.89,2.90,2.91,2.92,2.92,2.95,2.96,2.97,2.98,3,3.02,3.07,3.10,3.13,3.15,3.17,3.17,3.16,3.14,3.12,3.09,3.04,3.01,3,2.99,2.97,2.96,2.96,2.95,2.93,2.92,2.91,2.91,2.90,2.89,2.87,2.86,2.83,2.78,2.74,2.70,2.63,2.57,2.49,2.42,2.35,2.28,2.22,2.15,2.10,2.04,2,1.96,1.91,1.88,1.84,1.80,1.76,1.72,1.66,1.60,1.54,1.49,1.46,1.41,1.39,1.37,1.36,1.36,1.36,1.36,1.37,1.37,1.38,1.38,1.38,1.38,1.38,1.37,1.37,1.36,1.36,1.35,1.34,1.34,1.34,1.35,1.37,1.39,1.45,1.51,1.59,1.67,1.76,1.84,1.91,1.98,2.02,2.07,2.10,2.13,2.16,2.20,2.24,2.27,2.29,2.30,2.29,2.27,2.25,2.22,2.17,2.13,2.09,2.03,1.97,1.91,1.86,1.83,1.75,1.64,1.51,1.37,1.25,1.14,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.96,0.95,0.90,0.86,0.77,0.71,0.63,0.61,0.61,0.63,0.70,0.76,0.84,0.88,0.89,0.87,0.75,0.59,0.38,0.22,0.09,0.01,0,0,0,0,0,0,0,0,0,0.01,0.04,0.08,0.08,0,-0.18,-2.36,-4.60,-6.71,-8.37,-9.20,-10,-11,-12,-13,-13,-13,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-16,-15,-15,-14,-13,-12,-11,-10,-8.97,-7.01,2.61,2.51,2.40,2.29,2.21,2.12,2.07,2.02,2,1.98,1.97,1.96,1.96,1.95,1.95,1.93,1.93,1.93,1.96,1.99,2.03,2.10,2.16,2.22,2.28,2.34,2.37,2.38,2.39,2.36,2.30,2.25,2.18,2.13,2.09,2.05,2.02,2.01,2,1.99,1.99,2,2.01,2.03,2.05,2.07,2.08,2.07,2.05,2.04,2.01,2,1.98,1.97,1.97,1.99,2.01,2.08,2.13,2.21,2.25,2.29,2.34,2.36,2.37,2.38,2.40,2.42,2.48,2.50,2.54,2.59,2.62,2.65,2.71,2.74,2.76,2.79,2.83,2.85,2.87,2.87,2.88,2.89,2.90,2.91,2.92,2.95,2.96,2.97,2.98,3,3.01,3.03,3.08,3.10,3.11,3.11,3.11,3.09,3.07,3.03,3.01,3,2.98,2.97,2.97,2.95,2.93,2.93,2.92,2.91,2.90,2.90,2.88,2.87,2.85,2.83,2.79,2.74,2.70,2.62,2.57,2.49,2.42,2.35,2.28,2.22,2.15,2.10,2.04,2,1.96,1.92,1.88,1.85,1.80,1.76,1.71,1.65,1.58,1.51,1.45,1.39,1.35,1.32,1.28,1.27,1.26,1.26,1.25,1.26,1.26,1.26,1.27,1.27,1.27,1.28,1.28,1.28,1.27,1.27,1.26,1.26,1.25,1.24,1.24,1.25,1.26,1.30,1.36,1.43,1.52,1.62,1.72,1.80,1.88,1.95,1.99,2.02,2.04,2.07,2.09,2.11,2.12,2.14,2.15,2.16,2.15,2.14,2.12,2.10,2.08,2.03,2,1.96,1.90,1.84,1.77,1.70,1.61,1.50,1.37,1.25,1.13,1.07,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.97,0.97,0.96,0.95,0.90,0.84,0.75,0.65,0.58,0.50,0.46,0.46,0.50,0.58,0.66,0.76,0.86,0.87,0.84,0.73,0.54,0.36,0.20,0.08,0.01,0,0,0,0,0,0,0,0,0,0.02,0.04,0.04,-0.01,-0.21,-2.33,-4.40,-6.39,-7.98,-9.03,-9.62,-10,-11,-12,-13,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-15,-15,-16,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-12,-11,-10,-9.50,-7.66,2.40,2.34,2.26,2.17,2.11,2.04,1.99,1.96,1.93,1.92,1.91,1.90,1.89,1.88,1.87,1.86,1.85,1.86,1.88,1.92,1.98,2.03,2.10,2.15,2.21,2.25,2.27,2.28,2.27,2.25,2.22,2.16,2.12,2.08,2.04,2.01,1.99,1.98,1.98,1.97,1.97,1.97,1.97,1.98,1.99,2,2,1.99,1.98,1.96,1.95,1.92,1.90,1.89,1.90,1.91,1.97,2,2.07,2.11,2.14,2.20,2.22,2.24,2.25,2.26,2.28,2.32,2.35,2.38,2.42,2.48,2.51,2.57,2.61,2.64,2.70,2.74,2.77,2.82,2.84,2.86,2.87,2.88,2.89,2.89,2.90,2.91,2.92,2.95,2.96,2.98,2.99,3,3.01,3.03,3.04,3.04,3.04,3.02,3.01,3,2.99,2.98,2.97,2.96,2.95,2.93,2.92,2.92,2.91,2.90,2.89,2.88,2.87,2.85,2.83,2.79,2.75,2.70,2.63,2.57,2.49,2.42,2.35,2.28,2.22,2.15,2.10,2.04,2,1.96,1.91,1.88,1.85,1.80,1.75,1.68,1.62,1.57,1.47,1.39,1.34,1.28,1.24,1.21,1.18,1.17,1.16,1.15,1.15,1.16,1.16,1.16,1.17,1.17,1.18,1.18,1.20,1.20,1.20,1.20,1.20,1.18,1.17,1.16,1.16,1.17,1.18,1.22,1.28,1.37,1.47,1.58,1.68,1.78,1.86,1.91,1.96,1.98,2,2.01,2.02,2.03,2.04,2.05,2.05,2.05,2.04,2.03,2.02,2,1.99,1.96,1.92,1.87,1.82,1.75,1.66,1.58,1.47,1.36,1.24,1.13,1.07,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.97,0.97,0.96,0.92,0.89,0.84,0.74,0.63,0.52,0.42,0.36,0.32,0.29,0.35,0.42,0.53,0.66,0.76,0.82,0.76,0.64,0.48,0.29,0.14,0.07,0,0,0,0,0,0,0,0,0,0.01,0.02,0.04,0,-0.21,-1.01,-4.09,-6.67,-7.97,-8.97,-9.40,-9.78,-10,-11,-11,-12,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-15,-15,-16,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-12,-11,-10,-10,-8.39,2.21,2.16,2.12,2.05,2,1.93,1.89,1.86,1.84,1.83,1.82,1.80,1.78,1.76,1.74,1.73,1.72,1.73,1.76,1.82,1.88,1.95,2.01,2.08,2.12,2.16,2.18,2.18,2.18,2.16,2.13,2.10,2.07,2.03,2.01,1.99,1.98,1.97,1.96,1.95,1.93,1.92,1.92,1.92,1.92,1.92,1.91,1.90,1.89,1.87,1.86,1.86,1.85,1.84,1.85,1.87,1.89,1.95,1.99,2.02,2.08,2.10,2.12,2.13,2.14,2.16,2.17,2.22,2.24,2.27,2.32,2.36,2.39,2.46,2.50,2.57,2.62,2.66,2.73,2.76,2.79,2.83,2.85,2.86,2.87,2.87,2.88,2.89,2.91,2.92,2.95,2.96,2.97,2.98,2.99,3,3,3,3,3,2.99,2.98,2.97,2.96,2.95,2.95,2.93,2.92,2.92,2.91,2.90,2.89,2.88,2.87,2.85,2.83,2.79,2.75,2.71,2.63,2.57,2.49,2.42,2.35,2.28,2.22,2.15,2.10,2.04,1.99,1.95,1.89,1.85,1.82,1.77,1.73,1.65,1.57,1.48,1.41,1.33,1.26,1.22,1.17,1.13,1.11,1.10,1.09,1.08,1.08,1.08,1.08,1.08,1.09,1.09,1.10,1.10,1.11,1.12,1.12,1.13,1.13,1.13,1.13,1.12,1.11,1.11,1.11,1.13,1.16,1.23,1.32,1.41,1.53,1.65,1.75,1.84,1.90,1.93,1.97,1.98,1.98,1.99,1.99,1.99,1.99,1.98,1.98,1.97,1.96,1.95,1.92,1.90,1.87,1.83,1.77,1.71,1.63,1.53,1.43,1.34,1.24,1.13,1.07,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.96,0.95,0.92,0.87,0.78,0.72,0.62,0.50,0.40,0.33,0.25,0.22,0.21,0.24,0.29,0.39,0.50,0.59,0.62,0.63,0.51,0.37,0.22,0.11,0.02,0,0,0,0,0,0,0,0,0,0.01,0.01,0,-0.05,-1.62,-3.35,-6.07,-8.32,-8.98,-9.39,-9.54,-9.79,-10,-10,-11,-12,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-16,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-13,-12,-11,-10,-9.14,2,1.99,1.95,1.90,1.85,1.79,1.75,1.72,1.68,1.67,1.66,1.64,1.62,1.60,1.57,1.54,1.54,1.55,1.60,1.66,1.74,1.82,1.89,1.96,2,2.04,2.09,2.09,2.09,2.08,2.07,2.04,2.02,2,1.99,1.97,1.96,1.95,1.92,1.91,1.89,1.88,1.87,1.86,1.85,1.84,1.83,1.82,1.79,1.78,1.77,1.76,1.75,1.75,1.77,1.79,1.85,1.88,1.92,1.98,2,2.02,2.04,2.07,2.08,2.10,2.11,2.12,2.14,2.17,2.22,2.25,2.29,2.35,2.39,2.47,2.52,2.60,2.65,2.72,2.75,2.78,2.82,2.83,2.84,2.85,2.86,2.87,2.88,2.89,2.91,2.92,2.95,2.95,2.96,2.96,2.97,2.97,2.97,2.97,2.96,2.96,2.95,2.93,2.93,2.93,2.92,2.92,2.91,2.90,2.89,2.88,2.87,2.85,2.83,2.79,2.75,2.70,2.64,2.57,2.50,2.42,2.35,2.28,2.22,2.15,2.09,2.03,1.98,1.92,1.86,1.80,1.75,1.70,1.64,1.57,1.47,1.37,1.29,1.22,1.18,1.14,1.11,1.08,1.05,1.04,1.03,1.02,1.02,1.02,1.02,1.02,1.02,1.02,1.03,1.03,1.04,1.04,1.05,1.07,1.07,1.08,1.08,1.08,1.08,1.08,1.08,1.08,1.10,1.13,1.18,1.27,1.37,1.50,1.62,1.72,1.80,1.87,1.91,1.95,1.96,1.97,1.97,1.96,1.95,1.93,1.92,1.91,1.89,1.88,1.86,1.83,1.80,1.77,1.72,1.65,1.58,1.49,1.40,1.30,1.22,1.14,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.96,0.96,0.92,0.89,0.85,0.77,0.70,0.61,0.50,0.38,0.28,0.22,0.14,0.12,0.12,0.13,0.20,0.25,0.34,0.39,0.42,0.40,0.35,0.25,0.13,0.07,0.01,0,0,0,0,0,0,0,0.01,0.01,0.01,0,-0.05,-0.92,-3.59,-5.83,-7.82,-9.29,-9.76,-9.57,-9.58,-9.72,-10,-10,-11,-11,-12,-13,-13,-14,-14,-13,-13,-12,-12,-11,-11,-11,-12,-12,-13,-13,-14,-15,-15,-16,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-13,-12,-11,-11,-9.88,1.79,1.77,1.74,1.68,1.64,1.59,1.54,1.52,1.50,1.48,1.47,1.45,1.42,1.39,1.37,1.35,1.35,1.36,1.40,1.47,1.54,1.63,1.72,1.78,1.85,1.89,1.93,1.97,1.99,1.99,1.99,2,1.99,1.98,1.96,1.95,1.93,1.91,1.89,1.87,1.85,1.82,1.79,1.77,1.75,1.74,1.72,1.71,1.68,1.67,1.66,1.66,1.66,1.67,1.71,1.75,1.78,1.84,1.88,1.92,1.97,1.99,2,2,2.01,2.02,2.03,2.07,2.08,2.11,2.12,2.15,2.21,2.25,2.32,2.37,2.45,2.51,2.59,2.64,2.71,2.74,2.75,2.76,2.78,2.79,2.82,2.84,2.85,2.87,2.88,2.89,2.90,2.91,2.91,2.92,2.92,2.92,2.92,2.95,2.95,2.93,2.92,2.92,2.92,2.91,2.91,2.90,2.90,2.89,2.88,2.87,2.85,2.83,2.79,2.75,2.70,2.64,2.58,2.50,2.42,2.35,2.28,2.22,2.15,2.09,2.02,1.96,1.89,1.82,1.74,1.66,1.59,1.51,1.43,1.35,1.26,1.17,1.12,1.08,1.08,1.05,1.03,1.02,1.01,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1.01,1.01,1.02,1.02,1.03,1.03,1.04,1.04,1.04,1.04,1.05,1.07,1.10,1.15,1.23,1.34,1.45,1.57,1.67,1.77,1.84,1.89,1.91,1.93,1.93,1.93,1.92,1.90,1.88,1.86,1.84,1.82,1.78,1.74,1.71,1.67,1.63,1.58,1.51,1.43,1.35,1.26,1.18,1.12,1.07,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.97,0.97,0.97,0.96,0.96,0.96,0.96,0.96,0.96,0.96,0.96,0.95,0.90,0.88,0.84,0.76,0.67,0.60,0.49,0.38,0.27,0.20,0.12,0.08,0.04,0.04,0.07,0.10,0.14,0.21,0.25,0.26,0.25,0.22,0.14,0.10,0.04,0.01,0.01,0.01,0,0,0,0.01,0.02,0.02,0.02,0,-0.07,-1.47,-3.36,-5.65,-7.90,-9.01,-9.85,-9.92,-9.73,-9.50,-9.61,-10,-10,-11,-11,-12,-13,-13,-14,-14,-14,-13,-12,-12,-11,-11,-11,-12,-12,-13,-13,-14,-15,-16,-16,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-13,-12,-12,-11,-10,1.55,1.53,1.49,1.45,1.40,1.36,1.34,1.32,1.29,1.28,1.27,1.26,1.24,1.21,1.18,1.17,1.17,1.18,1.22,1.27,1.35,1.42,1.50,1.58,1.64,1.70,1.74,1.79,1.84,1.87,1.89,1.91,1.95,1.93,1.93,1.91,1.90,1.87,1.85,1.82,1.77,1.74,1.71,1.67,1.65,1.62,1.60,1.59,1.57,1.57,1.57,1.57,1.58,1.61,1.63,1.70,1.75,1.79,1.85,1.89,1.92,1.96,1.97,1.98,1.99,2,2,2,2.01,2.03,2.07,2.10,2.12,2.16,2.23,2.28,2.37,2.42,2.50,2.58,2.62,2.65,2.70,2.71,2.72,2.74,2.75,2.76,2.78,2.82,2.84,2.86,2.87,2.88,2.88,2.89,2.89,2.90,2.90,2.91,2.91,2.91,2.90,2.90,2.90,2.90,2.90,2.89,2.89,2.88,2.86,2.85,2.83,2.79,2.75,2.70,2.64,2.58,2.50,2.42,2.35,2.28,2.21,2.14,2.07,2,1.92,1.84,1.75,1.66,1.58,1.48,1.40,1.32,1.24,1.16,1.09,1.04,1.02,1,1.01,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1.01,1.01,1.01,1.02,1.03,1.04,1.08,1.12,1.20,1.29,1.40,1.51,1.62,1.71,1.78,1.83,1.87,1.88,1.89,1.89,1.87,1.85,1.82,1.78,1.74,1.70,1.64,1.60,1.55,1.52,1.48,1.42,1.36,1.29,1.23,1.16,1.11,1.05,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.96,0.96,0.96,0.96,0.96,0.96,0.96,0.96,0.92,0.90,0.87,0.84,0.76,0.67,0.59,0.48,0.37,0.27,0.20,0.12,0.07,0.02,0.01,0,0.01,0.03,0.07,0.10,0.12,0.13,0.13,0.12,0.10,0.08,0.04,0.04,0.04,0.03,0.02,0.02,0.02,0.02,0.03,0.02,0,-0.04,-1.45,-3.16,-5.60,-7.55,-9.13,-9.78,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-13,-13,-14,-14,-14,-13,-12,-12,-11,-11,-11,-12,-12,-13,-14,-14,-15,-16,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-13,-12,-11,-11,1.33,1.29,1.26,1.22,1.20,1.17,1.15,1.14,1.14,1.13,1.12,1.11,1.10,1.08,1.07,1.05,1.05,1.07,1.09,1.12,1.17,1.24,1.29,1.36,1.42,1.48,1.52,1.58,1.63,1.68,1.74,1.78,1.83,1.87,1.87,1.86,1.84,1.82,1.77,1.74,1.70,1.65,1.61,1.57,1.53,1.50,1.48,1.46,1.45,1.45,1.45,1.47,1.49,1.52,1.59,1.64,1.72,1.77,1.84,1.87,1.91,1.95,1.96,1.97,1.97,1.97,1.98,1.98,1.99,2,2.01,2.03,2.07,2.11,2.15,2.23,2.28,2.37,2.42,2.50,2.53,2.59,2.61,2.62,2.62,2.63,2.65,2.67,2.72,2.74,2.76,2.79,2.82,2.84,2.85,2.86,2.87,2.87,2.88,2.89,2.89,2.89,2.89,2.89,2.89,2.89,2.88,2.88,2.87,2.86,2.84,2.82,2.78,2.75,2.70,2.64,2.58,2.50,2.43,2.35,2.27,2.21,2.13,2.05,1.97,1.88,1.78,1.67,1.58,1.48,1.38,1.29,1.22,1.15,1.10,1.04,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.01,1.02,1.04,1.09,1.15,1.23,1.33,1.43,1.53,1.62,1.68,1.74,1.78,1.80,1.82,1.80,1.79,1.76,1.73,1.67,1.62,1.55,1.49,1.43,1.39,1.35,1.32,1.27,1.23,1.17,1.13,1.09,1.04,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.96,0.96,0.95,0.95,0.95,0.95,0.92,0.91,0.88,0.84,0.76,0.67,0.59,0.48,0.37,0.26,0.17,0.11,0.04,0.01,0,0,0,0,0,0.01,0.02,0.04,0.07,0.07,0.07,0.07,0.07,0.04,0.03,0.02,0.03,0.02,0,0,0,-0.01,-0.03,-0.09,-0.33,-3.53,-5.93,-7.88,-8.93,-9.77,-10,-10,-10,-11,-11,-11,-10,-10,-10,-11,-12,-12,-13,-14,-14,-14,-13,-12,-12,-11,-11,-12,-12,-13,-13,-14,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-13,-12,-12,-11,1.14,1.12,1.10,1.08,1.05,1.05,1.04,1.04,1.04,1.03,1.03,1.02,1.02,1.01,1,1,1,1,1.01,1.03,1.07,1.10,1.14,1.18,1.23,1.27,1.32,1.36,1.41,1.47,1.53,1.59,1.64,1.72,1.75,1.75,1.74,1.72,1.68,1.63,1.59,1.53,1.49,1.45,1.41,1.38,1.35,1.34,1.33,1.33,1.35,1.37,1.40,1.47,1.53,1.61,1.70,1.75,1.82,1.87,1.90,1.92,1.95,1.95,1.96,1.96,1.96,1.96,1.97,1.98,1.99,2,2.01,2.07,2.11,2.15,2.23,2.28,2.36,2.40,2.46,2.49,2.50,2.50,2.51,2.53,2.54,2.59,2.61,2.63,2.67,2.72,2.74,2.75,2.77,2.79,2.83,2.85,2.86,2.86,2.87,2.87,2.87,2.87,2.87,2.86,2.86,2.85,2.84,2.83,2.80,2.77,2.74,2.68,2.64,2.58,2.50,2.43,2.36,2.28,2.20,2.12,2.04,1.93,1.83,1.71,1.60,1.48,1.38,1.28,1.21,1.14,1.09,1.04,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.05,1.10,1.16,1.25,1.34,1.42,1.50,1.57,1.62,1.65,1.67,1.68,1.68,1.67,1.65,1.61,1.55,1.48,1.40,1.34,1.28,1.24,1.21,1.18,1.15,1.12,1.09,1.05,1.03,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.97,0.97,0.96,0.96,0.96,0.95,0.92,0.91,0.89,0.85,0.77,0.67,0.59,0.47,0.36,0.25,0.16,0.11,0.04,0.01,0,0,0,0,0,0,0,0,0.01,0.02,0.03,0.04,0.07,0.04,0.01,-0.01,-0.05,-0.12,-0.13,-0.13,-0.15,-0.17,-0.18,-0.43,-2.30,-4.14,-6.53,-8.99,-10,-9.98,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-12,-13,-13,-14,-13,-13,-12,-12,-11,-12,-12,-12,-13,-13,-14,-15,-16,-16,-17,-17,-18,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-13,-13,-12,-11,1.03,1.02,1.01,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.02,1.04,1.07,1.09,1.12,1.15,1.18,1.22,1.26,1.32,1.37,1.43,1.49,1.54,1.58,1.59,1.58,1.55,1.52,1.48,1.42,1.38,1.34,1.29,1.26,1.24,1.23,1.22,1.23,1.25,1.28,1.35,1.40,1.50,1.59,1.66,1.75,1.82,1.86,1.89,1.91,1.92,1.92,1.92,1.92,1.95,1.95,1.95,1.96,1.97,1.98,2,2.01,2.07,2.11,2.15,2.22,2.26,2.32,2.36,2.37,2.38,2.39,2.40,2.41,2.45,2.47,2.50,2.52,2.57,2.61,2.63,2.66,2.71,2.74,2.77,2.82,2.83,2.84,2.85,2.85,2.85,2.85,2.84,2.83,2.82,2.80,2.79,2.77,2.75,2.72,2.67,2.62,2.57,2.50,2.42,2.36,2.28,2.21,2.11,2.01,1.90,1.77,1.64,1.51,1.39,1.28,1.20,1.13,1.08,1.04,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.05,1.10,1.16,1.24,1.30,1.37,1.42,1.47,1.50,1.52,1.53,1.53,1.53,1.51,1.48,1.41,1.34,1.26,1.21,1.16,1.12,1.11,1.09,1.07,1.04,1.03,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.96,0.96,0.96,0.95,0.92,0.91,0.89,0.87,0.78,0.70,0.59,0.47,0.35,0.25,0.15,0.10,0.04,0.01,0,0,0,0,0,0,0,0,0,0.01,0.03,0.03,0.03,0.02,-0.01,-0.09,-0.17,-0.29,-0.40,-0.49,-1.40,-2.16,-2.28,-2.21,-3.35,-5.78,-7.71,-8.83,-10,-10,-10,-10,-11,-11,-12,-13,-13,-12,-12,-11,-11,-11,-11,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-16,-17,-17,-17,-18,-18,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-13,-13,-12,-11,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.01,1.03,1.04,1.07,1.09,1.12,1.14,1.18,1.23,1.27,1.32,1.36,1.39,1.40,1.40,1.38,1.35,1.32,1.27,1.23,1.20,1.16,1.14,1.12,1.12,1.13,1.16,1.22,1.28,1.37,1.47,1.54,1.64,1.73,1.78,1.85,1.88,1.91,1.90,1.91,1.91,1.91,1.91,1.92,1.92,1.95,1.96,1.97,1.98,2,2.02,2.07,2.11,2.14,2.20,2.23,2.25,2.26,2.27,2.28,2.28,2.29,2.33,2.35,2.37,2.40,2.45,2.49,2.52,2.58,2.62,2.66,2.73,2.76,2.78,2.80,2.83,2.83,2.82,2.80,2.79,2.77,2.76,2.74,2.73,2.71,2.68,2.64,2.60,2.54,2.49,2.42,2.35,2.28,2.21,2.10,1.98,1.86,1.71,1.57,1.43,1.32,1.21,1.13,1.08,1.04,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.04,1.09,1.14,1.18,1.24,1.27,1.30,1.33,1.35,1.37,1.38,1.38,1.36,1.33,1.28,1.22,1.15,1.11,1.07,1.05,1.03,1.02,1.01,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.95,0.92,0.92,0.89,0.86,0.78,0.70,0.58,0.46,0.34,0.24,0.15,0.10,0.04,0.01,0,0,0,0,0,0,0,0,0,0.02,0.03,0.03,0.01,-0.02,-0.10,-0.26,-1.13,-1.23,-0.85,-1.79,-3.70,-5.01,-6.24,-6.72,-5.40,-6.20,-7.92,-9.04,-9.45,-10,-10,-11,-11,-11,-12,-13,-14,-14,-13,-12,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-12,-12,-12,-13,-13,-13,-13,-14,-14,-15,-16,-17,-17,-17,-18,-18,-17,-17,-17,-17,-16,-16,-15,-15,-15,-14,-14,-13,-12,-12,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.01,1.03,1.04,1.05,1.09,1.12,1.12,1.15,1.18,1.22,1.24,1.24,1.23,1.21,1.17,1.14,1.12,1.10,1.08,1.07,1.07,1.09,1.12,1.17,1.24,1.33,1.42,1.52,1.62,1.72,1.77,1.83,1.86,1.89,1.88,1.89,1.89,1.89,1.90,1.90,1.91,1.92,1.95,1.96,1.97,1.98,2,2.02,2.07,2.10,2.12,2.14,2.16,2.17,2.17,2.17,2.20,2.20,2.22,2.24,2.25,2.28,2.33,2.37,2.40,2.47,2.51,2.59,2.64,2.70,2.74,2.76,2.78,2.77,2.76,2.74,2.73,2.71,2.68,2.66,2.64,2.62,2.60,2.55,2.51,2.46,2.40,2.34,2.27,2.20,2.11,1.96,1.80,1.64,1.50,1.36,1.24,1.14,1.09,1.04,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1.01,1.02,1.05,1.09,1.12,1.15,1.17,1.18,1.20,1.22,1.23,1.23,1.22,1.20,1.16,1.12,1.08,1.04,1.02,1.01,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.99,0.98,0.97,0.97,0.96,0.95,0.91,0.89,0.87,0.79,0.72,0.60,0.46,0.34,0.24,0.14,0.10,0.04,0.01,0,0,0,0,0,0,0,0,0,0.02,0.03,0,-0.04,-0.35,-0.92,-1.85,-2.74,-3.28,-3.77,-4.40,-5.36,-6.57,-8.32,-8.85,-8.61,-7.40,-6.51,-8.15,-9.11,-9.60,-10,-10,-11,-11,-12,-13,-13,-14,-13,-13,-12,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-15,-15,-16,-17,-17,-17,-18,-18,-17,-17,-17,-16,-16,-16,-15,-15,-15,-14,-14,-13,-12,-12,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.01,1.02,1.03,1.05,1.08,1.11,1.12,1.13,1.13,1.12,1.10,1.08,1.05,1.03,1.02,1.02,1.02,1.04,1.08,1.13,1.20,1.28,1.37,1.48,1.58,1.66,1.74,1.78,1.84,1.86,1.86,1.87,1.87,1.87,1.88,1.88,1.89,1.90,1.91,1.95,1.96,1.97,1.98,2,2.01,2.04,2.07,2.09,2.10,2.11,2.11,2.11,2.11,2.11,2.12,2.13,2.15,2.20,2.22,2.25,2.29,2.36,2.41,2.50,2.58,2.63,2.67,2.71,2.72,2.71,2.70,2.66,2.64,2.62,2.59,2.57,2.54,2.52,2.50,2.46,2.41,2.37,2.30,2.24,2.16,2.08,1.95,1.75,1.59,1.42,1.28,1.18,1.10,1.05,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.03,1.04,1.07,1.08,1.08,1.09,1.10,1.11,1.11,1.11,1.10,1.08,1.04,1.02,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.95,0.92,0.90,0.87,0.82,0.72,0.60,0.47,0.34,0.23,0.14,0.09,0.03,0.01,0,0,0,0,0,0,0,0,0,0.01,0.03,0.03,-0.07,-0.40,-1.21,-2.55,-4.11,-5.11,-5.70,-6.20,-6.79,-7.48,-7.85,-7.87,-7.52,-7.29,-7.78,-7.91,-8.62,-9.46,-9.97,-10,-11,-11,-11,-12,-12,-13,-13,-13,-12,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-11,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.02,1.03,1.04,1.04,1.05,1.05,1.04,1.03,1.01,1,0.99,0.99,1,1.01,1.04,1.09,1.15,1.23,1.32,1.41,1.50,1.59,1.66,1.72,1.76,1.78,1.80,1.80,1.82,1.82,1.84,1.86,1.87,1.88,1.90,1.92,1.95,1.96,1.97,1.98,2,2,2.02,2.03,2.03,2.03,2.04,2.04,2.04,2.04,2.07,2.08,2.09,2.11,2.12,2.15,2.21,2.26,2.34,2.41,2.48,2.54,2.60,2.62,2.63,2.63,2.61,2.58,2.54,2.51,2.49,2.47,2.45,2.42,2.39,2.36,2.32,2.26,2.20,2.12,2.02,1.89,1.72,1.52,1.36,1.23,1.12,1.05,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.01,1.02,1.02,1.02,1.03,1.03,1.03,1.03,1.02,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.97,0.96,0.92,0.90,0.87,0.82,0.73,0.61,0.48,0.35,0.23,0.13,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0.02,0.02,0.01,-0.04,-0.49,-1.34,-3,-4.95,-6.39,-7.29,-7.68,-7.98,-8.20,-8.24,-7.99,-7.67,-6.64,-7.36,-8.22,-9.03,-9.77,-10,-10,-11,-11,-11,-12,-12,-13,-13,-12,-12,-11,-11,-11,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-11,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.01,1.01,1.01,1,0.99,0.99,0.98,0.98,0.98,0.99,1.01,1.05,1.11,1.18,1.26,1.35,1.43,1.51,1.58,1.63,1.67,1.71,1.73,1.73,1.74,1.76,1.78,1.80,1.83,1.85,1.88,1.90,1.92,1.95,1.96,1.97,1.98,1.99,2,2,2,2,2,2,2,2,2.01,2.01,2.02,2.04,2.07,2.10,2.12,2.17,2.25,2.33,2.39,2.46,2.50,2.53,2.54,2.53,2.50,2.48,2.45,2.41,2.38,2.36,2.34,2.32,2.28,2.25,2.21,2.14,2.07,1.97,1.83,1.66,1.47,1.32,1.17,1.09,1.03,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.95,0.95,0.92,0.89,0.87,0.79,0.72,0.61,0.49,0.36,0.24,0.13,0.08,0.02,0,0,0,0,0,0,0,0,0.01,0.01,0.01,0,-0.09,-0.21,-0.47,-1.40,-2.80,-4.97,-7.47,-8.22,-8.75,-8.72,-8.62,-8.42,-8.20,-7.89,-7.83,-8,-8.67,-9.40,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-10,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.97,0.97,0.99,1.02,1.07,1.13,1.20,1.27,1.35,1.41,1.47,1.52,1.57,1.60,1.61,1.63,1.65,1.67,1.71,1.74,1.77,1.82,1.85,1.88,1.91,1.92,1.95,1.96,1.97,1.97,1.98,1.98,1.99,1.99,1.99,1.99,2,2,2,2,2,2,2.01,2.03,2.08,2.12,2.17,2.24,2.29,2.36,2.40,2.42,2.43,2.42,2.39,2.36,2.33,2.29,2.27,2.25,2.23,2.21,2.17,2.14,2.09,2.01,1.90,1.76,1.61,1.42,1.26,1.15,1.07,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.95,0.93,0.90,0.89,0.86,0.78,0.72,0.61,0.49,0.37,0.25,0.14,0.08,0.02,0,0,0,0,0,0,0.01,0.01,0.02,0.02,0.01,-0.04,-0.14,-0.35,-0.80,-1.52,-2.88,-4.48,-6.51,-8.88,-9.01,-9.20,-8.92,-8.68,-8.46,-8.27,-8.25,-8.54,-9.12,-9.72,-10,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-15,-15,-14,-14,-13,-12,-12,-10,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.95,0.95,0.96,0.97,0.99,1.02,1.08,1.13,1.20,1.26,1.32,1.37,1.41,1.45,1.48,1.50,1.52,1.54,1.57,1.61,1.65,1.71,1.76,1.82,1.86,1.89,1.92,1.95,1.95,1.96,1.96,1.97,1.97,1.97,1.98,1.98,1.98,1.98,1.98,1.98,1.98,1.98,1.99,1.99,2,2.03,2.07,2.11,2.15,2.21,2.25,2.28,2.30,2.32,2.30,2.28,2.25,2.22,2.18,2.16,2.14,2.12,2.10,2.08,2.02,1.96,1.85,1.72,1.55,1.39,1.24,1.12,1.03,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.97,0.97,0.96,0.96,0.96,0.96,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.95,0.93,0.90,0.87,0.83,0.78,0.72,0.61,0.49,0.37,0.25,0.14,0.09,0.02,0,0,0,0,0,0,0.01,0.02,0.02,0.01,-0.05,-0.09,-0.28,-0.71,-1.34,-2.33,-3.46,-4.58,-5.86,-7.28,-8.58,-9,-9.05,-8.86,-8.68,-8.62,-8.70,-8.96,-9.33,-9.98,-10,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-12,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-16,-16,-17,-17,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-13,-13,-12,-11,-10,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.95,0.93,0.93,0.93,0.96,0.98,1.02,1.07,1.11,1.16,1.22,1.26,1.30,1.34,1.36,1.38,1.40,1.43,1.47,1.51,1.57,1.62,1.70,1.77,1.83,1.87,1.90,1.92,1.95,1.95,1.96,1.96,1.96,1.97,1.97,1.97,1.98,1.98,1.98,1.98,1.97,1.97,1.97,1.98,1.98,1.99,2.01,2.04,2.07,2.11,2.14,2.16,2.18,2.18,2.17,2.15,2.13,2.10,2.08,2.05,2.03,2.02,2,1.96,1.89,1.79,1.66,1.51,1.36,1.22,1.11,1.04,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.96,0.96,0.95,0.95,0.93,0.93,0.93,0.95,0.95,0.95,0.96,0.96,0.96,0.97,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.96,0.95,0.93,0.91,0.87,0.83,0.76,0.70,0.61,0.49,0.37,0.25,0.14,0.08,0.02,0,0,0,0,0,0,0.02,0.02,0.01,-0.01,-0.13,-0.21,-0.35,-1.13,-2.12,-3.24,-4.34,-5.47,-6.18,-6.97,-7.77,-8.42,-8.82,-8.93,-8.93,-8.96,-9.08,-9.28,-9.54,-9.78,-10,-11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-12,-13,-13,-14,-15,-15,-15,-16,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-9.68,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.93,0.92,0.91,0.91,0.91,0.93,0.96,0.99,1.03,1.08,1.11,1.15,1.18,1.22,1.24,1.26,1.28,1.32,1.35,1.40,1.47,1.54,1.63,1.71,1.79,1.85,1.88,1.90,1.91,1.92,1.95,1.95,1.95,1.96,1.96,1.97,1.97,1.97,1.97,1.97,1.97,1.97,1.97,1.95,1.95,1.96,1.97,1.97,1.98,2,2.02,2.03,2.04,2.04,2.04,2.03,2.01,1.99,1.97,1.95,1.93,1.91,1.88,1.84,1.74,1.62,1.48,1.33,1.20,1.10,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.96,0.96,0.95,0.93,0.92,0.91,0.91,0.91,0.91,0.92,0.93,0.95,0.95,0.96,0.96,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.96,0.96,0.93,0.91,0.88,0.83,0.76,0.68,0.59,0.49,0.37,0.25,0.14,0.08,0.02,0,0,0,0,0,0.01,0.02,0.03,0.02,-0.03,-0.14,-0.39,-0.60,-0.75,-2.86,-4.15,-5.24,-6.33,-7.13,-7.63,-7.92,-8.32,-8.66,-8.96,-9.18,-9.27,-9.37,-9.52,-9.70,-9.87,-10,-10,-11,-11,-11,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-13,-13,-14,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-9.29,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.95,0.92,0.90,0.88,0.87,0.88,0.89,0.91,0.95,0.97,1,1.03,1.07,1.09,1.12,1.14,1.16,1.20,1.24,1.30,1.38,1.47,1.55,1.65,1.74,1.80,1.86,1.88,1.89,1.90,1.91,1.92,1.92,1.95,1.95,1.96,1.96,1.97,1.97,1.96,1.96,1.96,1.93,1.92,1.92,1.91,1.90,1.89,1.88,1.89,1.90,1.90,1.90,1.91,1.90,1.89,1.88,1.87,1.85,1.84,1.83,1.79,1.75,1.68,1.58,1.43,1.30,1.17,1.09,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.96,0.96,0.95,0.92,0.91,0.89,0.88,0.87,0.87,0.89,0.90,0.92,0.95,0.96,0.96,0.97,0.97,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.96,0.95,0.92,0.89,0.84,0.77,0.68,0.59,0.48,0.37,0.25,0.14,0.09,0.03,0,0,0,0,0,0,0.01,0,-0.02,-0.13,-0.76,-2.26,-2.71,-2.97,-3.92,-5.09,-6.25,-7.10,-7.58,-7.98,-8.35,-8.66,-8.96,-9.25,-9.59,-9.68,-9.76,-9.75,-9.86,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-8.80,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.97,0.95,0.92,0.89,0.86,0.83,0.82,0.82,0.83,0.85,0.87,0.89,0.91,0.95,0.97,0.99,1.02,1.04,1.09,1.14,1.21,1.28,1.38,1.49,1.59,1.68,1.76,1.82,1.86,1.87,1.88,1.88,1.89,1.90,1.91,1.91,1.92,1.95,1.95,1.95,1.95,1.92,1.90,1.90,1.89,1.87,1.86,1.84,1.80,1.78,1.77,1.77,1.77,1.76,1.76,1.76,1.76,1.75,1.74,1.73,1.72,1.71,1.67,1.61,1.52,1.40,1.27,1.16,1.08,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.96,0.96,0.95,0.92,0.90,0.87,0.84,0.83,0.83,0.85,0.87,0.90,0.93,0.95,0.96,0.97,0.97,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.96,0.93,0.90,0.85,0.78,0.70,0.60,0.48,0.37,0.26,0.15,0.10,0.03,0.01,0,0,0,0,0,0,0,-0.07,-0.51,-1.28,-2.51,-3.71,-4.48,-5.27,-6.41,-7.15,-7.89,-8.21,-8.42,-8.64,-8.90,-9.21,-9.49,-9.86,-9.99,-9.97,-9.96,-9.90,-9.98,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-8.34,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.96,0.92,0.88,0.83,0.78,0.75,0.74,0.73,0.74,0.75,0.77,0.79,0.82,0.85,0.87,0.90,0.93,0.99,1.04,1.12,1.21,1.30,1.41,1.52,1.63,1.72,1.77,1.79,1.82,1.83,1.83,1.85,1.87,1.87,1.88,1.89,1.90,1.90,1.90,1.89,1.87,1.86,1.85,1.83,1.82,1.78,1.75,1.71,1.67,1.65,1.63,1.63,1.62,1.62,1.62,1.62,1.62,1.61,1.60,1.59,1.57,1.52,1.45,1.35,1.24,1.14,1.07,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.96,0.96,0.95,0.92,0.89,0.84,0.79,0.77,0.77,0.80,0.84,0.89,0.92,0.95,0.96,0.97,0.97,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.96,0.93,0.91,0.86,0.79,0.71,0.61,0.49,0.37,0.27,0.17,0.11,0.04,0.01,0,0,0,0,0,0,0,-0.03,-0.43,-1.22,-2.40,-3.84,-5.13,-6.07,-6.91,-7.88,-9,-8.99,-9.08,-9.17,-9.28,-9.45,-9.64,-9.90,-10,-10,-10,-9.97,-9.92,-9.99,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.61,-7.96,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.92,0.88,0.82,0.74,0.68,0.65,0.63,0.63,0.64,0.65,0.67,0.70,0.73,0.76,0.79,0.84,0.89,0.96,1.03,1.13,1.23,1.34,1.43,1.53,1.61,1.66,1.70,1.71,1.72,1.72,1.74,1.76,1.78,1.80,1.84,1.85,1.86,1.85,1.84,1.79,1.77,1.76,1.75,1.72,1.70,1.65,1.60,1.55,1.52,1.50,1.49,1.49,1.49,1.48,1.48,1.48,1.48,1.47,1.46,1.42,1.38,1.29,1.21,1.12,1.05,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.97,0.96,0.95,0.92,0.88,0.83,0.77,0.74,0.74,0.76,0.82,0.87,0.91,0.95,0.96,0.97,0.97,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.98,0.99,0.98,0.98,0.98,0.97,0.96,0.95,0.91,0.87,0.80,0.72,0.62,0.50,0.38,0.27,0.18,0.11,0.05,0.01,0,0,0,0,0,0,0,-0.02,-0.11,-1.03,-2.25,-3.70,-5.02,-6.23,-7.16,-8.03,-8.91,-9.67,-9.90,-9.92,-9.97,-9.98,-10,-10,-10,-10,-10,-10,-9.88,-9.87,-9.91,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-17,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.66,-9.04,-7.55,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.93,0.88,0.80,0.72,0.63,0.57,0.53,0.51,0.51,0.52,0.54,0.58,0.61,0.64,0.68,0.74,0.80,0.88,0.97,1.05,1.15,1.26,1.36,1.45,1.51,1.55,1.59,1.60,1.60,1.61,1.62,1.64,1.66,1.68,1.72,1.73,1.74,1.75,1.71,1.68,1.67,1.65,1.63,1.61,1.58,1.53,1.48,1.43,1.40,1.37,1.36,1.35,1.35,1.35,1.35,1.35,1.35,1.35,1.33,1.29,1.24,1.17,1.10,1.04,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.97,0.97,0.96,0.96,0.93,0.89,0.84,0.78,0.74,0.73,0.75,0.80,0.86,0.90,0.93,0.96,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.95,0.92,0.88,0.82,0.73,0.62,0.51,0.39,0.28,0.18,0.12,0.07,0.02,0,0,0,0,0,0,0,0,-0.05,-0.16,-1.79,-3.39,-5,-6.12,-7.17,-8.08,-8.89,-9.65,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.91,-9.77,-9.77,-9.83,-9.93,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.59,-9.05,-8.46,-7.05,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.89,0.80,0.70,0.59,0.50,0.43,0.40,0.40,0.40,0.42,0.46,0.49,0.54,0.60,0.66,0.74,0.82,0.90,0.99,1.09,1.18,1.27,1.35,1.41,1.45,1.47,1.48,1.48,1.49,1.50,1.51,1.53,1.55,1.58,1.60,1.60,1.59,1.57,1.55,1.54,1.52,1.51,1.48,1.45,1.41,1.36,1.32,1.28,1.26,1.24,1.23,1.23,1.23,1.23,1.23,1.23,1.22,1.21,1.17,1.13,1.08,1.03,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.97,0.97,0.97,0.96,0.93,0.90,0.86,0.80,0.76,0.75,0.76,0.80,0.86,0.90,0.93,0.96,0.96,0.97,0.97,0.97,0.97,0.97,0.97,0.97,0.98,0.98,0.98,0.98,0.98,0.97,0.98,0.97,0.96,0.92,0.89,0.83,0.74,0.63,0.51,0.39,0.28,0.20,0.12,0.07,0.02,0.01,0,0,0,0,0,0,0,-0.01,-0.08,-0.23,-2.36,-4.32,-6.07,-7.14,-8.10,-8.91,-9.63,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.86,-9.71,-9.71,-9.73,-9.80,-10,-10,-10,-10,-10,-10,-11,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.75,-9.38,-8.93,-8.47,-7.87,-6.65,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.90,0.82,0.71,0.57,0.45,0.36,0.32,0.29,0.29,0.32,0.35,0.40,0.46,0.52,0.60,0.67,0.76,0.85,0.93,1.02,1.11,1.18,1.25,1.30,1.34,1.35,1.36,1.36,1.36,1.37,1.38,1.40,1.41,1.43,1.45,1.45,1.43,1.42,1.41,1.40,1.39,1.37,1.35,1.33,1.29,1.25,1.21,1.17,1.15,1.14,1.13,1.12,1.12,1.12,1.12,1.12,1.12,1.11,1.09,1.05,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.98,0.97,0.97,0.95,0.92,0.89,0.85,0.80,0.79,0.79,0.83,0.87,0.91,0.93,0.95,0.96,0.96,0.96,0.96,0.96,0.97,0.97,0.97,0.97,0.98,0.98,0.98,0.97,0.97,0.97,0.96,0.93,0.89,0.83,0.74,0.63,0.51,0.39,0.28,0.20,0.12,0.07,0.02,0.01,0,0,0,0,0,0,0,0,-0.01,-0.09,-0.24,-2.61,-4.89,-6.91,-8.16,-9.05,-9.72,-10,-10,-11,-12,-13,-12,-12,-11,-10,-10,-10,-10,-9.84,-9.68,-9.65,-9.64,-9.68,-9.83,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-17,-17,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.88,-9.50,-9.13,-8.75,-8.36,-7.90,-7.39,-6.50,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.96,0.91,0.84,0.73,0.58,0.43,0.32,0.24,0.21,0.21,0.23,0.27,0.33,0.39,0.46,0.54,0.63,0.72,0.80,0.88,0.97,1.04,1.11,1.16,1.21,1.23,1.24,1.24,1.24,1.24,1.25,1.25,1.27,1.28,1.29,1.30,1.30,1.29,1.28,1.28,1.27,1.26,1.25,1.23,1.21,1.18,1.15,1.12,1.09,1.07,1.05,1.04,1.03,1.03,1.03,1.03,1.04,1.04,1.03,1.02,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.96,0.95,0.92,0.89,0.86,0.84,0.84,0.86,0.88,0.91,0.93,0.95,0.95,0.95,0.96,0.96,0.96,0.96,0.96,0.96,0.97,0.97,0.98,0.97,0.97,0.97,0.95,0.95,0.90,0.85,0.75,0.64,0.52,0.39,0.28,0.20,0.12,0.07,0.02,0.01,0,0,0,0,0,0,0,0,0,0,-0.05,-0.22,-2.65,-5.34,-7.87,-9.35,-10,-10,-10,-11,-11,-12,-13,-12,-11,-11,-10,-10,-10,-10,-9.86,-9.73,-9.63,-9.60,-9.60,-9.67,-9.85,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-9.78,-9.43,-9.01,-8.63,-8.26,-7.91,-7.55,-7.14,-6.74,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.93,0.87,0.76,0.61,0.45,0.30,0.21,0.15,0.15,0.16,0.21,0.26,0.33,0.41,0.50,0.59,0.67,0.76,0.85,0.92,0.98,1.03,1.09,1.11,1.13,1.14,1.14,1.14,1.14,1.14,1.15,1.16,1.17,1.18,1.18,1.18,1.17,1.17,1.16,1.15,1.14,1.13,1.12,1.11,1.09,1.05,1.03,1.01,0.99,0.98,0.97,0.96,0.96,0.96,0.97,0.98,0.99,0.99,0.99,0.99,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.97,0.98,0.97,0.97,0.96,0.95,0.92,0.90,0.89,0.88,0.88,0.89,0.90,0.91,0.91,0.92,0.92,0.93,0.93,0.95,0.95,0.96,0.96,0.96,0.97,0.97,0.97,0.97,0.96,0.93,0.89,0.86,0.77,0.65,0.52,0.39,0.28,0.18,0.11,0.07,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,-0.03,-0.16,-1.96,-5.72,-8.76,-10,-10,-11,-11,-11,-12,-12,-13,-12,-11,-11,-10,-10,-10,-10,-9.90,-9.76,-9.63,-9.54,-9.51,-9.55,-9.71,-9.91,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-9.79,-9.51,-9.15,-8.75,-8.38,-8.01,-7.67,-7.37,-7.02,-6.63,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.90,0.80,0.66,0.50,0.34,0.21,0.14,0.11,0.12,0.15,0.21,0.28,0.37,0.47,0.55,0.64,0.72,0.80,0.87,0.93,0.98,1.02,1.04,1.05,1.05,1.05,1.05,1.05,1.07,1.07,1.08,1.08,1.09,1.09,1.09,1.09,1.08,1.07,1.05,1.04,1.03,1.03,1.01,1,0.98,0.95,0.93,0.91,0.90,0.89,0.88,0.89,0.89,0.91,0.93,0.95,0.97,0.97,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.98,0.97,0.97,0.96,0.95,0.93,0.92,0.90,0.89,0.88,0.87,0.87,0.87,0.88,0.89,0.89,0.90,0.92,0.93,0.95,0.96,0.96,0.97,0.96,0.97,0.96,0.93,0.90,0.85,0.78,0.66,0.53,0.40,0.28,0.18,0.11,0.05,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,-0.02,-0.13,-1.14,-5.80,-9.73,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-10,-10,-10,-10,-10,-9.96,-9.80,-9.64,-9.50,-9.46,-9.48,-9.61,-9.83,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-9.90,-9.64,-9.35,-9,-8.63,-8.22,-7.85,-7.53,-7.24,-6.88,-6.49,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.96,0.92,0.85,0.73,0.57,0.39,0.26,0.15,0.11,0.10,0.12,0.17,0.25,0.34,0.43,0.51,0.61,0.68,0.76,0.83,0.88,0.92,0.96,0.99,1,1,1,1,1,1,1,1.01,1.01,1.01,1.01,1.01,1.01,1,0.99,0.98,0.96,0.96,0.95,0.93,0.91,0.89,0.87,0.86,0.84,0.83,0.82,0.80,0.82,0.83,0.86,0.89,0.92,0.95,0.97,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.97,0.97,0.96,0.96,0.93,0.91,0.88,0.85,0.82,0.79,0.78,0.79,0.80,0.83,0.85,0.88,0.90,0.92,0.95,0.96,0.96,0.96,0.95,0.95,0.91,0.86,0.77,0.65,0.53,0.40,0.28,0.18,0.11,0.05,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.13,-0.36,-4.54,-7.89,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.98,-9.83,-9.63,-9.48,-9.38,-9.40,-9.52,-9.75,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-9.86,-9.59,-9.25,-8.88,-8.52,-8.12,-7.68,-7.39,-7.08,-6.74,-6.35,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.89,0.78,0.64,0.47,0.30,0.20,0.12,0.09,0.10,0.14,0.22,0.30,0.39,0.48,0.57,0.64,0.72,0.78,0.84,0.88,0.92,0.95,0.96,0.96,0.96,0.96,0.96,0.95,0.95,0.96,0.96,0.96,0.96,0.95,0.95,0.93,0.91,0.90,0.88,0.87,0.86,0.84,0.83,0.80,0.79,0.76,0.75,0.73,0.72,0.72,0.73,0.76,0.80,0.86,0.90,0.93,0.96,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.98,0.97,0.97,0.97,0.96,0.95,0.91,0.86,0.79,0.73,0.68,0.67,0.67,0.68,0.72,0.76,0.80,0.86,0.90,0.93,0.95,0.96,0.95,0.93,0.92,0.87,0.78,0.66,0.53,0.39,0.27,0.17,0.11,0.05,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.13,-0.40,-2.48,-6.54,-8.62,-9.68,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.79,-9.62,-9.43,-9.34,-9.33,-9.49,-9.72,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.88,-9.59,-9.25,-8.86,-8.38,-7.96,-7.52,-7.22,-6.91,-6.54,-6.14,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.92,0.84,0.72,0.54,0.38,0.25,0.14,0.10,0.09,0.13,0.20,0.27,0.36,0.45,0.52,0.61,0.67,0.74,0.79,0.85,0.88,0.90,0.92,0.92,0.92,0.92,0.91,0.90,0.89,0.90,0.90,0.90,0.90,0.89,0.88,0.87,0.85,0.83,0.79,0.77,0.75,0.74,0.73,0.71,0.68,0.66,0.65,0.63,0.62,0.62,0.64,0.68,0.75,0.83,0.89,0.93,0.96,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.98,0.98,0.97,0.97,0.93,0.90,0.83,0.73,0.64,0.57,0.53,0.52,0.53,0.57,0.63,0.71,0.78,0.85,0.89,0.92,0.92,0.91,0.89,0.86,0.78,0.67,0.54,0.40,0.27,0.16,0.10,0.04,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.12,-0.46,-3.47,-6.18,-8.20,-9.11,-9.53,-9.91,-10,-10,-10,-10,-9.98,-9.90,-9.88,-9.97,-10,-10,-10,-9.93,-9.75,-9.54,-9.39,-9.29,-9.30,-9.42,-9.63,-9.91,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.93,-9.64,-9.29,-8.89,-8.47,-7.90,-7.36,-7,-6.67,-6.33,-5.92,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.89,0.76,0.61,0.46,0.30,0.18,0.12,0.10,0.13,0.18,0.25,0.33,0.41,0.49,0.57,0.63,0.70,0.75,0.80,0.85,0.87,0.89,0.89,0.89,0.87,0.86,0.85,0.84,0.84,0.84,0.84,0.84,0.83,0.82,0.79,0.77,0.74,0.71,0.68,0.65,0.63,0.61,0.60,0.58,0.55,0.54,0.53,0.52,0.53,0.57,0.63,0.71,0.80,0.88,0.93,0.96,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.93,0.89,0.80,0.70,0.57,0.47,0.40,0.37,0.37,0.40,0.47,0.57,0.66,0.76,0.83,0.85,0.85,0.83,0.78,0.74,0.65,0.53,0.40,0.27,0.17,0.09,0.04,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0,-0.11,-0.76,-4,-6.57,-8.24,-9.08,-9.46,-9.72,-9.92,-9.98,-10,-9.84,-9.63,-9.59,-9.73,-9.85,-9.96,-10,-9.93,-9.80,-9.63,-9.46,-9.29,-9.23,-9.25,-9.38,-9.61,-9.86,-10,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.74,-9.39,-9,-8.54,-8.01,-7.40,-6.88,-6.43,-6.09,-5.67,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.96,0.90,0.80,0.68,0.52,0.37,0.24,0.15,0.14,0.15,0.18,0.24,0.32,0.38,0.46,0.52,0.58,0.64,0.70,0.75,0.79,0.83,0.84,0.85,0.84,0.82,0.79,0.78,0.77,0.77,0.77,0.77,0.76,0.75,0.73,0.71,0.68,0.64,0.61,0.58,0.54,0.52,0.50,0.49,0.47,0.46,0.46,0.45,0.45,0.46,0.51,0.59,0.68,0.79,0.87,0.93,0.96,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.99,0.98,0.98,0.97,0.95,0.89,0.80,0.67,0.53,0.40,0.30,0.25,0.23,0.25,0.32,0.41,0.51,0.62,0.68,0.72,0.71,0.67,0.62,0.54,0.47,0.36,0.25,0.16,0.09,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0,-0.11,-1.54,-4.75,-6.88,-8.33,-9.07,-9.40,-9.61,-9.75,-9.79,-9.75,-9.53,-9.42,-9.48,-9.60,-9.75,-9.86,-9.88,-9.83,-9.68,-9.50,-9.34,-9.22,-9.21,-9.26,-9.41,-9.62,-9.83,-10,-10,-10,-10,-10,-10,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.78,-9.42,-9.05,-8.61,-8.08,-7.48,-6.89,-6.38,-5.83,-5.40,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.92,0.85,0.74,0.60,0.45,0.30,0.23,0.17,0.16,0.20,0.24,0.30,0.37,0.42,0.48,0.53,0.58,0.63,0.68,0.73,0.76,0.78,0.78,0.77,0.74,0.72,0.70,0.68,0.68,0.68,0.68,0.67,0.66,0.64,0.61,0.58,0.54,0.50,0.47,0.45,0.42,0.41,0.41,0.40,0.39,0.39,0.39,0.39,0.42,0.48,0.58,0.68,0.79,0.88,0.93,0.96,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.95,0.90,0.82,0.70,0.54,0.38,0.25,0.17,0.13,0.14,0.17,0.26,0.35,0.43,0.50,0.53,0.52,0.48,0.42,0.36,0.28,0.21,0.13,0.08,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0.01,-0.13,-3.10,-5.49,-7.39,-8.47,-9.04,-9.36,-9.55,-9.67,-9.67,-9.55,-9.39,-9.35,-9.42,-9.54,-9.68,-9.76,-9.76,-9.68,-9.55,-9.39,-9.25,-9.18,-9.22,-9.33,-9.48,-9.66,-9.86,-10,-10,-10,-10,-10,-11,-11,-11,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-9.76,-9.41,-9.02,-8.55,-8.02,-7.42,-6.88,-6.36,-5.75,-5.23,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.93,0.89,0.79,0.66,0.52,0.38,0.27,0.21,0.20,0.21,0.25,0.30,0.36,0.40,0.43,0.48,0.51,0.55,0.60,0.64,0.68,0.70,0.70,0.68,0.65,0.62,0.61,0.59,0.59,0.59,0.58,0.58,0.55,0.53,0.51,0.47,0.43,0.40,0.37,0.36,0.36,0.36,0.37,0.38,0.38,0.37,0.38,0.39,0.42,0.49,0.60,0.71,0.82,0.89,0.93,0.97,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.96,0.91,0.85,0.73,0.58,0.40,0.25,0.14,0.08,0.07,0.09,0.13,0.20,0.26,0.30,0.33,0.32,0.28,0.24,0.18,0.13,0.08,0.05,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.03,0,-0.99,-4.25,-6.33,-7.79,-8.60,-9.05,-9.35,-9.54,-9.64,-9.61,-9.43,-9.36,-9.33,-9.42,-9.53,-9.65,-9.73,-9.67,-9.59,-9.46,-9.30,-9.21,-9.16,-9.23,-9.36,-9.51,-9.72,-9.92,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.67,-9.35,-8.92,-8.47,-7.92,-7.33,-6.77,-6.29,-5.80,-5.24,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.95,0.90,0.84,0.73,0.58,0.45,0.33,0.25,0.22,0.23,0.26,0.30,0.34,0.37,0.39,0.41,0.43,0.47,0.51,0.55,0.59,0.60,0.60,0.58,0.54,0.52,0.50,0.48,0.48,0.47,0.47,0.47,0.45,0.43,0.40,0.38,0.35,0.32,0.29,0.29,0.32,0.34,0.37,0.39,0.40,0.40,0.40,0.42,0.46,0.53,0.63,0.75,0.85,0.91,0.95,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.96,0.93,0.88,0.77,0.63,0.45,0.28,0.14,0.07,0.02,0.03,0.05,0.09,0.12,0.14,0.15,0.15,0.13,0.10,0.08,0.04,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.02,-0.02,-2.52,-5.26,-7.37,-8.16,-8.78,-9.16,-9.43,-9.60,-9.66,-9.62,-9.43,-9.36,-9.37,-9.43,-9.54,-9.63,-9.65,-9.62,-9.50,-9.37,-9.22,-9.13,-9.12,-9.21,-9.36,-9.54,-9.75,-9.97,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-10,-10,-10,-9.85,-9.51,-9.16,-8.78,-8.30,-7.77,-7.23,-6.75,-6.33,-5.84,-5.25,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.92,0.87,0.76,0.63,0.49,0.38,0.29,0.25,0.24,0.26,0.29,0.32,0.34,0.34,0.35,0.36,0.38,0.41,0.45,0.47,0.49,0.48,0.46,0.43,0.40,0.38,0.37,0.36,0.36,0.36,0.36,0.35,0.34,0.32,0.29,0.27,0.25,0.25,0.26,0.29,0.35,0.39,0.43,0.46,0.46,0.47,0.47,0.51,0.59,0.68,0.78,0.87,0.92,0.96,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.95,0.90,0.83,0.68,0.51,0.33,0.16,0.07,0.01,0,0.01,0.02,0.03,0.04,0.05,0.04,0.04,0.03,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0.01,-1.07,-3.71,-5.86,-7.52,-8.49,-9.04,-9.36,-9.59,-9.75,-9.78,-9.68,-9.51,-9.40,-9.42,-9.49,-9.55,-9.61,-9.60,-9.52,-9.42,-9.29,-9.16,-9.11,-9.11,-9.22,-9.37,-9.54,-9.74,-9.93,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.98,-9.62,-9.33,-8.98,-8.62,-8.17,-7.74,-7.17,-6.73,-6.26,-5.75,-5.22,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.93,0.89,0.79,0.66,0.54,0.42,0.33,0.26,0.24,0.25,0.26,0.28,0.28,0.28,0.27,0.27,0.28,0.30,0.34,0.36,0.37,0.36,0.35,0.33,0.29,0.27,0.26,0.25,0.25,0.25,0.26,0.26,0.25,0.24,0.23,0.21,0.20,0.21,0.24,0.29,0.36,0.43,0.49,0.51,0.52,0.51,0.52,0.55,0.63,0.73,0.82,0.89,0.93,0.97,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.96,0.92,0.87,0.75,0.58,0.38,0.21,0.08,0.02,0,0,0,0,0,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.03,-0.05,-1.97,-4.58,-6.37,-7.77,-8.63,-9.18,-9.52,-9.75,-9.86,-9.87,-9.80,-9.63,-9.52,-9.50,-9.53,-9.58,-9.58,-9.52,-9.43,-9.34,-9.22,-9.10,-9.01,-9.04,-9.16,-9.36,-9.53,-9.72,-9.91,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.96,-9.48,-9.18,-8.88,-8.51,-8.09,-7.60,-7.05,-6.63,-6.17,-5.65,-5.13,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.97,0.95,0.90,0.82,0.71,0.58,0.46,0.35,0.27,0.23,0.22,0.23,0.23,0.23,0.22,0.21,0.20,0.21,0.22,0.24,0.25,0.26,0.26,0.24,0.22,0.20,0.18,0.16,0.16,0.16,0.16,0.17,0.18,0.18,0.18,0.17,0.17,0.16,0.18,0.22,0.28,0.37,0.45,0.51,0.54,0.54,0.53,0.53,0.58,0.66,0.75,0.85,0.91,0.95,0.97,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.95,0.90,0.80,0.64,0.45,0.25,0.10,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.02,-0.62,-2.84,-5.21,-7.08,-8.10,-8.88,-9.40,-9.72,-9.90,-9.97,-9.98,-9.92,-9.75,-9.65,-9.61,-9.60,-9.58,-9.51,-9.41,-9.29,-9.17,-9.09,-8.99,-8.88,-8.91,-9.13,-9.35,-9.51,-9.66,-9.87,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.92,-9.41,-9.04,-8.73,-8.35,-7.90,-7.43,-6.89,-6.50,-6.03,-5.52,-5.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.90,0.84,0.74,0.62,0.49,0.37,0.28,0.22,0.18,0.17,0.17,0.16,0.15,0.13,0.13,0.13,0.14,0.15,0.16,0.17,0.16,0.15,0.13,0.12,0.11,0.10,0.09,0.09,0.10,0.11,0.13,0.14,0.15,0.14,0.14,0.14,0.16,0.20,0.27,0.35,0.43,0.49,0.51,0.51,0.50,0.52,0.58,0.67,0.77,0.86,0.92,0.96,0.97,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.99,0.98,0.98,0.98,0.97,0.96,0.92,0.85,0.70,0.50,0.29,0.13,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.07,0.01,-0.92,-3.23,-5.71,-7.50,-8.60,-9.27,-9.72,-10,-10,-10,-10,-10,-9.88,-9.76,-9.71,-9.64,-9.55,-9.42,-9.25,-9.09,-8.93,-8.83,-8.87,-8.61,-8.86,-9.11,-9.29,-9.47,-9.63,-9.77,-9.97,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.80,-9.29,-8.84,-8.50,-8.13,-7.68,-7.23,-6.68,-6.29,-5.85,-5.42,-4.96,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.91,0.86,0.77,0.65,0.52,0.39,0.28,0.21,0.15,0.12,0.11,0.10,0.09,0.08,0.08,0.08,0.09,0.10,0.10,0.10,0.10,0.09,0.07,0.05,0.05,0.04,0.04,0.04,0.05,0.07,0.09,0.10,0.12,0.12,0.12,0.12,0.14,0.17,0.23,0.30,0.37,0.41,0.43,0.43,0.43,0.47,0.55,0.67,0.79,0.88,0.92,0.96,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.95,0.88,0.75,0.55,0.35,0.16,0.05,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.07,0.07,-0.02,-1.33,-3.84,-6.14,-7.84,-8.90,-9.53,-9.97,-10,-10,-10,-10,-10,-9.98,-9.88,-9.79,-9.71,-9.52,-9.28,-9.02,-8.78,-8.60,-8.49,-8.26,-8.52,-8.77,-9.01,-9.22,-9.40,-9.55,-9.67,-9.86,-9.99,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9.62,-9.14,-8.59,-8.25,-7.86,-7.43,-6.91,-6.47,-6.11,-5.75,-5.30,-4.89,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.92,0.87,0.79,0.68,0.55,0.41,0.28,0.18,0.12,0.09,0.07,0.05,0.04,0.03,0.03,0.04,0.05,0.05,0.05,0.05,0.04,0.03,0.02,0.02,0.01,0.01,0.01,0.01,0.02,0.03,0.05,0.08,0.09,0.10,0.10,0.10,0.11,0.13,0.17,0.23,0.28,0.30,0.32,0.32,0.35,0.41,0.51,0.66,0.80,0.89,0.93,0.96,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.96,0.90,0.79,0.61,0.39,0.20,0.08,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.01,0.01,0,0,0,0,0,0,0,0.02,0.08,0.09,0.03,-0.12,-2.13,-4.65,-6.77,-8.28,-9.21,-9.73,-10,-10,-10,-10,-10,-10,-9.93,-9.86,-9.77,-9.62,-9.35,-9.01,-8.68,-8.39,-8.16,-8.10,-8.13,-8.41,-8.71,-8.91,-9.13,-9.29,-9.47,-9.60,-9.72,-9.85,-9.93,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-9.90,-9.38,-8.88,-8.36,-7.96,-7.53,-7.10,-6.66,-6.36,-6,-5.64,-5.25,-4.78,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.92,0.89,0.82,0.71,0.58,0.43,0.30,0.18,0.11,0.07,0.03,0.02,0.01,0.01,0.01,0.02,0.02,0.03,0.03,0.02,0.02,0.01,0,0,0,0,0,0,0,0.01,0.03,0.05,0.07,0.08,0.09,0.09,0.09,0.10,0.12,0.15,0.18,0.20,0.21,0.22,0.26,0.36,0.50,0.68,0.83,0.90,0.96,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.97,0.95,0.93,0.96,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.92,0.83,0.65,0.45,0.24,0.10,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0.03,0.03,0.02,0,0,0,0,0,0.01,0.07,0.10,0.10,0,-0.25,-2.92,-5.54,-7.75,-8.82,-9.51,-9.88,-10,-10,-10,-10,-10,-9.87,-9.74,-9.67,-9.59,-9.38,-9.05,-8.65,-8.28,-7.92,-7.77,-7.75,-8,-8.29,-8.58,-8.80,-9.01,-9.22,-9.36,-9.49,-9.59,-9.66,-9.80,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.63,-9.05,-8.59,-8.03,-7.62,-7.26,-6.88,-6.49,-6.21,-5.87,-5.51,-5.12,-4.65,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.93,0.90,0.84,0.74,0.61,0.47,0.33,0.21,0.12,0.05,0.02,0.01,0,0,0,0.01,0.01,0.02,0.02,0.01,0.01,0.01,0,0,0,0,0,0,0,0.01,0.02,0.04,0.05,0.07,0.08,0.07,0.07,0.08,0.09,0.10,0.10,0.11,0.12,0.14,0.21,0.34,0.50,0.70,0.85,0.93,0.96,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,0.99,0.99,0.99,0.99,0.96,0.95,0.74,0.82,0.90,0.96,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.93,0.85,0.70,0.49,0.28,0.13,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.03,0.05,0.04,0.03,0.01,0,0,0,0,0.02,0.08,0.12,0.09,-0.08,-0.38,-3.72,-6.68,-8.75,-9.54,-9.68,-9.80,-9.92,-10,-9.99,-10,-9.60,-9.34,-9.25,-9.25,-9.22,-9,-8.63,-8.18,-7.80,-7.54,-7.42,-7.60,-7.87,-8.15,-8.40,-8.66,-8.88,-9.05,-9.22,-9.35,-9.43,-9.53,-9.61,-9.71,-9.87,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.93,-9.34,-8.78,-8.35,-7.83,-7.39,-7.08,-6.71,-6.34,-6.03,-5.72,-5.36,-4.91,-4.48,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.95,0.90,0.85,0.76,0.64,0.50,0.36,0.24,0.14,0.09,0.05,0.03,0.02,0.02,0.02,0.02,0.02,0.03,0.03,0.03,0.03,0.03,0.03,0.03,0.03,0.03,0.02,0.02,0.02,0.03,0.04,0.05,0.08,0.09,0.09,0.09,0.08,0.08,0.08,0.08,0.08,0.08,0.09,0.12,0.20,0.34,0.52,0.72,0.87,0.95,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,0.99,0.99,0.99,0.99,0.96,0.17,0.42,0.70,0.85,0.95,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.93,0.86,0.72,0.53,0.34,0.18,0.09,0.03,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0,0,0,0.01,0,0.01,0.02,0.03,0.05,0.08,0.08,0.05,0.03,0,0,0,0,0.03,0.10,0.12,0.08,-0.13,-0.51,-4.48,-8.23,-9.70,-9.72,-9.42,-9.33,-9.33,-9.41,-9.60,-9.05,-8.64,-8.40,-8.36,-8.38,-8.36,-8.18,-7.88,-7.55,-7.29,-7.17,-7.24,-7.43,-7.67,-8,-8.25,-8.49,-8.71,-8.89,-9.03,-9.18,-9.29,-9.38,-9.46,-9.49,-9.55,-9.76,-9.91,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.67,-9.09,-8.51,-8.09,-7.58,-7.13,-6.79,-6.42,-6.13,-5.85,-5.50,-5.13,-4.73,-4.37,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.95,0.91,0.87,0.78,0.67,0.54,0.41,0.29,0.21,0.14,0.11,0.09,0.08,0.08,0.07,0.07,0.08,0.08,0.09,0.09,0.09,0.09,0.09,0.09,0.09,0.09,0.09,0.09,0.09,0.09,0.10,0.11,0.12,0.13,0.13,0.13,0.12,0.11,0.11,0.11,0.11,0.10,0.11,0.15,0.24,0.39,0.57,0.76,0.89,0.96,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,0.99,0.99,0.99,0.99,0.96,0.23,0.48,0.66,0.85,0.95,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.93,0.86,0.73,0.57,0.39,0.25,0.15,0.10,0.07,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.04,0.03,0.04,0.05,0.07,0.04,0.05,0.07,0.09,0.10,0.11,0.11,0.10,0.07,0.03,0.03,0.03,0.04,0.09,0.12,0.15,0.08,-0.16,-0.60,-4.41,-8.95,-10,-9.45,-8.71,-8.53,-8.54,-8.45,-8.27,-7.77,-7.39,-7.22,-7.21,-7.25,-7.25,-7.14,-6.97,-6.76,-6.67,-6.76,-6.99,-7.24,-7.50,-7.78,-8.08,-8.28,-8.50,-8.68,-8.87,-9,-9.12,-9.22,-9.25,-9.29,-9.33,-9.41,-9.60,-9.72,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.87,-9.36,-8.75,-8.24,-7.78,-7.25,-6.85,-6.48,-6.14,-5.90,-5.60,-5.25,-4.92,-4.60,-4.25,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.97,0.95,0.92,0.88,0.82,0.72,0.60,0.48,0.37,0.28,0.24,0.21,0.18,0.17,0.17,0.16,0.16,0.16,0.16,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.18,0.18,0.20,0.21,0.20,0.20,0.18,0.18,0.17,0.17,0.17,0.17,0.20,0.24,0.33,0.47,0.62,0.79,0.90,0.96,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,0.99,0.99,0.99,0.96,0.96,0.58,0.77,0.89,0.96,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.96,0.92,0.85,0.73,0.59,0.45,0.34,0.27,0.22,0.18,0.16,0.16,0.16,0.16,0.16,0.16,0.16,0.15,0.15,0.17,0.20,0.21,0.20,0.22,0.23,0.23,0.22,0.21,0.17,0.16,0.15,0.14,0.14,0.14,0.15,0.17,0.23,0.24,0.12,-0.13,-0.53,-2.73,-5.85,-7.16,-7.36,-7.10,-7.16,-7.22,-7.07,-6.75,-6.23,-5.88,-5.77,-5.86,-5.97,-6.01,-5.99,-5.88,-5.84,-5.88,-6.11,-6.48,-7,-7.23,-7.52,-7.83,-8.09,-8.29,-8.49,-8.66,-8.78,-8.89,-8.99,-9.04,-9.11,-9.12,-9.13,-9.25,-9.36,-9.54,-9.79,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-11,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.89,-9.47,-8.96,-8.30,-7.87,-7.39,-6.87,-6.50,-6.15,-5.89,-5.63,-5.34,-5.05,-4.76,-4.43,-4.22,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.97,0.96,0.93,0.89,0.84,0.75,0.65,0.54,0.45,0.37,0.33,0.30,0.30,0.29,0.29,0.28,0.28,0.28,0.27,0.27,0.26,0.26,0.26,0.26,0.26,0.27,0.27,0.27,0.28,0.28,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.26,0.26,0.26,0.26,0.26,0.27,0.29,0.34,0.42,0.54,0.68,0.84,0.92,0.97,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,0.99,0.99,0.99,0.99,0.96,0.90,0.89,0.95,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.96,0.92,0.85,0.73,0.60,0.50,0.43,0.40,0.37,0.34,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.34,0.35,0.38,0.41,0.43,0.46,0.48,0.51,0.52,0.40,0.34,0.33,0.33,0.33,0.32,0.32,0.32,0.33,0.34,0.37,0.37,0.25,0,-0.36,-0.86,-2.41,-3.35,-3.70,-4.23,-4.93,-5.33,-5.55,-5.17,-4.71,-4.42,-4.41,-4.53,-4.67,-4.76,-4.83,-4.85,-4.89,-4.96,-5.08,-5.50,-6.05,-6.54,-6.88,-7.27,-7.68,-8.04,-8.25,-8.40,-8.55,-8.66,-8.76,-8.84,-8.86,-8.88,-8.88,-8.92,-9,-9.09,-9.33,-9.50,-9.65,-9.75,-9.78,-9.75,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.75,-9.42,-8.96,-8.42,-7.85,-7.47,-6.98,-6.40,-6.11,-5.83,-5.61,-5.37,-5.14,-4.88,-4.61,-4.36,-4.14,];
}

function getTileMap()
{
	return [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,2,2,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,2,0,2,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,2,2,2,0,2,2,0,2,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,2,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,0,3,0,3,3,3,0,3,3,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,2,2,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,1,0,0,0,1,0,0,2,2,2,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,2,0,0,0,0,0,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,0,3,3,3,0,3,3,3,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,0,0,0,1,1,1,0,1,1,1,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,1,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,3,0,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,0,2,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,0,0,0,0,0,0,0,0,3,3,3,3,0,3,0,0,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,2,0,2,2,2,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,1,0,0,0,0,0,0,0,3,0,0,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,3,1,3,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,2,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,1,1,1,0,0,0,0,0,3,3,3,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,3,3,3,0,3,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,2,0,2,2,2,2,2,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,2,2,0,2,2,2,2,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,3,0,0,3,3,3,0,1,0,3,3,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,2,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,1,1,1,1,0,0,0,0,3,3,3,0,2,2,2,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,3,0,3,3,3,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,3,3,3,3,0,3,3,3,3,0,0,0,0,0,0,0,0,2,2,2,0,0,0,3,3,2,2,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,2,2,2,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,1,1,1,0,1,1,1,3,3,3,3,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,2,2,0,0,0,0,0,0,3,0,0,3,3,3,0,3,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,3,3,0,3,3,3,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,2,2,2,0,0,3,3,3,3,2,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,2,0,2,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,3,3,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,3,3,3,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,2,2,2,2,2,0,0,0,0,3,3,3,0,2,3,3,3,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,3,3,0,0,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,2,3,3,3,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,2,2,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,3,3,3,2,2,2,3,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,2,2,0,2,2,2,2,2,2,3,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,3,3,3,0,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,3,3,0,1,1,0,1,0,1,1,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,3,0,3,3,3,3,3,0,0,0,0,0,0,3,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,2,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,1,1,1,1,1,1,1,3,3,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,2,3,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,3,3,3,3,0,3,3,1,1,1,1,1,1,1,1,1,1,1,0,0,2,2,2,2,2,2,0,0,2,2,0,0,0,0,0,3,0,3,3,3,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,2,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,1,1,1,1,1,1,1,1,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,2,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,3,3,3,3,0,1,1,1,1,1,0,1,0,1,1,1,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,3,3,3,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,0,0,2,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,1,1,1,1,1,3,1,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,2,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,3,3,3,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,2,2,2,1,1,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,1,1,1,0,1,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,0,2,2,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,3,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,2,2,1,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,1,1,1,0,1,1,1,0,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,2,2,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,3,1,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,3,2,3,0,0,3,2,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,3,3,3,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,1,1,1,1,1,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,1,1,1,1,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,1,1,1,1,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,1,1,1,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,1,1,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,2,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,2,2,2,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,2,0,2,2,2,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,3,3,3,3,0,0,0,0,0,0,0,2,2,0,0,2,2,2,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,2,2,2,2,2,0,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,2,3,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,1,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,0,3,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,2,3,3,3,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,2,2,2,2,0,0,2,2,2,2,2,2,2,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,3,3,3,3,3,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,3,3,3,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,2,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,2,0,0,3,3,3,3,3,0,0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,2,0,0,0,0,0,0,0,3,3,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,2,2,2,0,3,3,3,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,3,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,2,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,3,3,3,2,2,2,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,3,3,2,3,2,0,3,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,0,0,3,0,3,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,2,2,0,1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,2,2,2,0,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,3,0,0,3,2,2,3,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,0,2,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,0,1,1,0,0,0,1,0,0,1,0,1,1,1,1,1,1,0,0,0,0,2,0,3,3,3,3,3,3,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,1,1,1,1,1,0,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,2,2,3,0,3,3,0,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,3,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,3,3,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,1,0,1,1,1,1,1,3,3,3,3,3,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,1,1,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,2,1,1,0,3,3,3,3,3,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,3,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,2,1,1,1,1,1,1,1,3,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,1,2,1,1,1,1,3,3,1,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,2,1,1,1,2,1,3,3,3,3,3,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,2,2,2,2,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,2,1,2,2,2,2,3,2,3,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,1,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,2,0,0,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,3,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,2,0,0,2,2,2,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,3,3,3,3,3,3,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,3,0,0,0,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,2,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,0,3,3,3,0,0,3,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,2,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,2,2,2,2,0,0,0,0,0,3,3,3,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,0,0,0,2,2,2,2,0,0,0,0,0,0,3,3,3,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,3,3,3,3,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,2,0,2,2,2,2,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,3,0,3,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,3,3,3,3,3,0,0,0,0,0,3,3,3,3,3,3,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,0,0,3,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,0,0,3,3,3,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,2,2,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,2,2,2,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,3,3,3,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,1,2,2,2,2,2,2,2,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,2,2,2,2,3,3,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,1,1,1,2,2,2,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,3,3,3,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,0,1,1,1,1,2,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,2,2,2,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,2,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,1,1,2,2,2,2,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,2,2,2,2,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,1,1,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,3,0,3,0,3,3,3,3,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,2,2,2,0,0,2,2,2,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,2,0,0,2,2,2,2,2,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,2,2,2,0,2,2,2,2,2,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,0,0,0,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,2,0,2,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,2,2,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,0,2,2,2,0,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,2,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,3,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,3,3,3,3,0,3,3,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,3,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,1,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,1,1,1,1,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,3,3,3,3,3,0,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,0,2,0,2,2,2,2,2,2,2,2,0,0,2,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,2,0,0,2,2,2,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,2,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,2,0,2,0,0,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,2,2,2,0,2,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,0,0,2,2,2,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,2,2,2,2,2,2,0,2,2,2,2,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,2,2,0,0,0,2,0,2,2,2,2,2,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,2,2,2,2,2,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,2,0,2,2,2,2,2,2,2,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,2,2,2,2,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,2,2,0,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,2,2,2,2,2,2,0,3,3,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,0,0,2,2,2,0,2,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,2,2,3,2,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,2,0,1,0,1,1,1,0,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,2,2,2,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,3,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,1,0,2,2,1,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,1,1,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,1,1,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1,0,1,0,0,0,2,2,2,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,1,1,0,1,1,2,2,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,2,2,2,2,2,2,2,0,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,3,1,3,0,0,1,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,0,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,2,2,3,3,3,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,2,2,3,3,3,3,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,3,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,2,3,3,3,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,2,3,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,1,3,3,3,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,0,0,0,0,2,3,3,3,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,3,3,3,3,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,2,3,3,3,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,2,3,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,3,3,0,3,0,0,0,0,1,1,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,1,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,2,0,0,2,0,2,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,3,3,3,1,1,0,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,2,2,2,2,2,2,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,2,2,2,2,2,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,1,1,1,1,1,1,1,0,0,0,0,0,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,1,1,1,1,1,0,0,0,0,0,0,0,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,1,0,1,1,1,1,1,2,2,2,2,0,2,2,2,2,0,2,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,1,1,1,1,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,2,2,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,1,1,1,1,0,0,2,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,1,0,0,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,1,1,1,1,1,1,0,2,2,2,0,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,2,2,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,0,2,2,2,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,0,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,2,2,0,0,2,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,3,3,0,0,2,2,2,2,2,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,2,0,2,2,2,2,0,0,0,0,0,0,0,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,2,3,2,3,3,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,2,2,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,2,2,2,2,2,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,2,2,2,2,0,2,0,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,2,2,2,2,1,1,1,2,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,1,2,2,0,0,0,1,1,1,0,0,1,1,1,1,0,3,3,3,0,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,2,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,0,3,3,3,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,2,1,0,1,1,1,1,0,0,0,0,0,1,0,0,0,3,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,3,3,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,3,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,3,0,0,0,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,2,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,3,3,3,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,2,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,2,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,2,2,2,2,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,1,0,0,0,0,2,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,2,2,2,0,2,2,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,2,0,2,0,2,2,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,2,2,2,2,2,2,2,0,2,0,0,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,3,3,2,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,2,2,3,2,0,0,0,0,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,3,2,2,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,3,3,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,2,0,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,2,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,0,0,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,2,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,3,3,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,2,0,0,2,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,2,2,2,0,2,0,0,0,2,0,0,2,2,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,2,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,2,2,0,2,2,2,2,2,2,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,0,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,2,2,2,2,2,0,2,2,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,2,2,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,2,2,2,2,2,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,1,1,0,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,2,0,0,0,2,0,0,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,2,0,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,3,3,3,3,3,3,3,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,2,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,3,1,1,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,3,3,3,3,3,3,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,2,2,2,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,3,2,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,2,2,2,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,2,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,3,3,2,2,2,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,3,3,0,0,2,0,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,2,2,2,2,2,2,2,2,2,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,2,2,2,2,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,2,2,2,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,2,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,0,0,0,0,0,0,0,0,2,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,];
}

function getTilePallet()
{
	return ["desert_dirt_rough_2","desert_dirt_rocks_3","desert_dirt_rocks_3_scrub","desert_sand_stones","sand",];
}
