/* ------------------------------------------------------------------------
 * $Id: DTDHandler.hh,v 1.1 2001/08/16 11:32:21 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-14 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

#ifndef _SAXDTDHandler_hh_
#define _SAXDTDHandler_hh_

// -- System Includes
#include <string>

namespace SAX {

    // -- Class Declarations

    /**
     * Receive notification of basic DTD-related events. 
     **/
    class DTDHandler {
    public:
	
	/**
	 * Constructor.
	 **/
	DTDHandler() { }
	
	/**
	 * Destructor. 
	 **/
	virtual ~DTDHandler() { }

	/**
	 * Receive notification of a notation declaration event. It is
	 * up to the application to record the notation for later
	 * reference, if necessary.
	 *
	 * @param name notation name.
	 * @param publicId notation's public identifier.
	 * @param systemId notation's system identifier.
	 **/
	virtual void notationDecl(const std::string &name,
				  const std::string &publicId,
				  const std::string &systemId) = 0;

	/**
	 * Receive notification of an unparsed entity declaration
	 * event.
	 *
	 * @param name notation name.
	 * @param publicId notation's public identifier.
	 * @param systemId notation's system identifier.
	 * @param notationName name of the associated notation.
	 **/
	virtual void unparsedEntityDecl(const std::string &name,
					const std::string &publicId,
					const std::string &systemId,
					const std::string &notationName) = 0;
    };
    
};

#endif /* DTDHandler.hh */
