/* ------------------------------------------------------------------------
 * $Id: InputSource.hh,v 1.1 2001/08/16 11:32:21 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-14 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

#ifndef _SAXInputSource_hh_
#define _SAXInputSource_hh_

// -- System Includes
#include <iosfwd>
#include <string>

namespace SAX {

    // -- Class Declarations
    
    /**
     * A single input source for an XML entity. 
     **/
    class InputSource {
    public:
	
	/**
	 * Constructor.
	 **/
	InputSource() : _is(0) { }

	/**
	 * Constructor.
	 *
	 * @param systemId system identifier.
	 **/
	InputSource(const std::string &systemId) 
	    : _is(0), _systemId(systemId) { }

	/**
	 * Constructor.
	 *
	 * @param is input stream to use.
	 **/
	InputSource(std::istream &is) : _is(&is) { }

	/**
	 * Destructor.
	 **/
	virtual ~InputSource() { }
	
	/**
	 * Retrieve the input stream (if any).
	 *
	 * @return pointer to input stream (0 if none).
	 **/
	std::istream *getStream() const { return _is; }

	/**
	 * Set input stream to use.
	 *
	 * @param is input stream to use.
	 **/
	void setStream(std::istream &is) { _is = &is; }

	/**
	 * Set the public identifier for this input source. 
	 *
	 * @param publicId public identifier as a string.
	 **/
	void setPublicId(const std::string &publicId) {
	    _publicId = publicId; 
	}

	/**
	 * Get the public identifier for this input source.
	 *
	 * @return public identifier, empty if none was supplied.
	 **/
	const std::string &getPublicId() const { return _publicId; }

	/**
	 * Set the system identifier for this input source. 
	 *
	 * @param systemId system identifier as a string.
	 **/
	void setSystemId(const std::string &systemId) {
	    _systemId = systemId;
	}
	
	/**
	 * Get the system identifier for this input source.
	 *
	 * @return ystem identifier as a string.
	 **/ 
	const std::string &getSystemId() const { return _systemId; }

	/**
	 * Set the character encoding, if known. The encoding must be
	 * a string acceptable for an XML encoding declaration (see
	 * section 4.3.3 of the XML 1.0 recommendation).
	 *
	 * @param encoding string describing the character encoding.
	 **/
	void setEncoding(const std::string &encoding) {
	    _encoding = encoding; 
	}

	/**
	 * Get the character encoding for a byte stream or URI.
	 *
	 * @param encoding, empty if none was supplied.
	 **/
	const std::string &getEncoding() const { return _encoding; }

    private:
	std::istream *_is;
	std::string _systemId;
	std::string _publicId;
	std::string _encoding;
    };

};

#endif /* InputSource.hh */
