/* ------------------------------------------------------------------------
 * $Id: ControllerImpl.hh,v 1.1 2001/08/21 14:43:02 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-21 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _ControllerImpl_hh_
#define _ControllerImpl_hh_

// -- System Includes
#include <vector>

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Controller.hh"
#include "Polhem/NodeImpl.hh"

// -- Class Declarations

/**
 * C++ implementation of the controller.
 **/
class ControllerImpl : public virtual POA_Nobel::Controller,
		       public NodeImpl {
public:

    /**
     * Constructor.
     **/
    ControllerImpl();
    
    /**
     * Destructor
     **/
    virtual ~ControllerImpl();
    
    // IDL functions
    virtual Nobel::Transform_ptr transformation();
    virtual void render(Nobel::Renderer_ptr r);
    virtual void pick(Nobel::Picker_ptr p);
    virtual void traverse(Nobel::Visitor_ptr v);
    virtual Nobel::Volume_ptr getBoundingVolume();
    virtual void setBody(Nobel::Node_ptr b);
    virtual Nobel::Node_ptr getBody();
protected:
    
    /**
     * Handle any node events. 
     *
     * @param e event to handle.
     * @return true if the event is handled, false otherwise.
     **/
    virtual bool handleNodeEvents(const Nobel::Event &e);

private:
    Nobel::Node_var _body;
};

#endif /* ControllerImpl.hh */
