/* ------------------------------------------------------------------------
 * $Id: NodeKitImpl.hh,v 1.5 2001/08/21 21:37:39 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-10-24 by Niklas Elmqvist.
 *
 * Copyright (c) 2000, 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _NodeKitImpl_hh_
#define _NodeKitImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/NodeKit.hh"
#include "Polhem/KitImpl.hh"

// -- Class Declarations

class NodeKitImpl : public virtual POA_Nobel::NodeKit, 
		    public KitImpl {
public:
    
    /**
     * Default constructor.
     **/
    NodeKitImpl() { }

    /**
     * Destructor.
     **/
    virtual ~NodeKitImpl() { }

    // IDL functions
    virtual char *name() { return CORBA::string_dup("NodeKit"); }
    virtual char *description() {
	return CORBA::string_dup("Scene graph node kit."); 
    }
    virtual Nobel::Shape_ptr createShape();
    virtual Nobel::Node_ptr createGroup();
    virtual Nobel::Desktop_ptr createVNCDesktop(const char* host,
						CORBA::Short port,
						const char* passwd);
private:

    // No copy constructor for kits
    NodeKitImpl(const NodeKitImpl &kit);
};

#endif /* NodeKitImpl.hh */
