/* ------------------------------------------------------------------------
 * $Id: VNCDesktop.hh,v 1.3 2001/08/24 14:16:48 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-21 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _VNCDesktop_hh_
#define _VNCDesktop_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Desktop.hh"
#include "Nobel/TextureGenerator.hh"
#include "Polhem/ControllerImpl.hh"

// -- Forward Declarations
class Mutex;
class Thread;
class VNCInterface;

// -- Class Declarations

/**
 * VNC texture generator object. 
 **/
class VNCTextureGenerator : public virtual POA_Nobel::TextureGenerator,
			    public virtual PortableServer::RefCountServantBase {
public:
    
    /**
     * Constructor.
     *
     * @param vnc pointer to VNC interface to use for framebuffer updates.
     **/
    VNCTextureGenerator(VNCInterface *vnc);
    
    /**
     * Destructor.
     **/
    virtual ~VNCTextureGenerator();
    
    // IDL functions
    virtual Nobel::BinaryData* getTextureData();
    virtual CORBA::Boolean getUpdate(Nobel::BinaryData_out texData, 
				     Nobel::Rectangle &rect);
    CORBA::Long getWidth() { return _width; }
    CORBA::Long getHeight() { return _height; }
    CORBA::Short getPixelSize();
    Nobel::PixelType getPixelType();
    
private:

    Nobel::BinaryData *buildUpdate(const Nobel::Rectangle &r);
    
    int _width, _height;
    int _vncWidth, _vncHeight;
    VNCInterface *_vnc;
    Mutex _mutex;
};

/**
 * VNC controller
 **/
class VNCController : public virtual POA_Nobel::DesktopController,
		      public ControllerImpl {
public:
    
    /**
     * Constructor.
     *
     * @param vnc pointer to VNC interface to send events to.
     **/
    VNCController(VNCInterface *vnc);

    /**
     * Destructor.
     **/
    virtual ~VNCController();

    // IDL functions
    virtual void setMapper(Nobel::Mapper_ptr m);
    virtual Nobel::Mapper_ptr getMapper();
protected:
    
    /**
     * Handle any node events. 
     *
     * @param e event to handle.
     * @return true if the event is handled, false otherwise.
     **/
    virtual bool handleNodeEvents(const Nobel::Event &e);
    
private:
    Nobel::Mapper_var _mapper;
    VNCInterface *_vnc;
};

/**
 * VNC desktop implementation of the desktop interface.
 **/
class VNCDesktop : public virtual POA_Nobel::Desktop,
		   public virtual PortableServer::RefCountServantBase {
public:
    
    /**
     * Constructor.
     *
     * @param host host name to connect to.
     * @param port host port.
     * @param pwd VNC desktop password.
     **/
    VNCDesktop(const char* host, CORBA::Short port, const char* pwd);

    /**
     * Destructor.
     **/
    virtual ~VNCDesktop();

    // IDL functions
    virtual Nobel::DesktopController_ptr createController(Nobel::Node_ptr);
    virtual Nobel::TextureGenerator_ptr getTextureGenerator();
    virtual CORBA::Long getWidth();
    virtual CORBA::Long getHeight();
private:
    VNCInterface *_vnc;
    VNCTextureGenerator *_generator;
    Thread *_vnc_thread;
    Mutex _mutex;
};

#endif /* VNCDesktop.hh */
