/* ------------------------------------------------------------------------
 * GeometryImpl.cc
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-06-16 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000, 2001 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- System Includes
#include <algorithm>
#include <cmath>

// -- 3Dwm Includes
#include "Celsius/Mutex.hh"
#include "Celsius/Guard.hh"
#include "Celsius/debug.hh"
#include "Celsius/Logger.hh"
#include "Polhem/VolumeImpl.hh"
#include "Polhem/GeometryImpl.hh"

using namespace Nobel;

// -- Code Segment

GeometryImpl::GeometryImpl()
    : _vertexNumber(0), _dirty(true), _bounds(new VolumeImpl)
{
    // empty
}

GeometryImpl::~GeometryImpl()
{
    deactivate(_bounds);
    delete _bounds;
}

Nobel::Volume_ptr GeometryImpl::getBoundingVolume()
{
    Guard<Mutex> guard(_mutex);

    // Recompute the bounding volume if necessary
    if (_dirty) recomputeBoundingVolume();
    
    return _bounds->_this();
}

void GeometryImpl::findMinMax(const Vertex3DSeq &vs,
			      int vertexNumber,
			      Vertex3D &minimum,
			      Vertex3D &maximum)
{
    // Initialize values to
    minimum.x = minimum.y = minimum.z = HUGE_VAL;
    maximum.x = maximum.y = maximum.z = -HUGE_VAL;
    
    // Step through all vertices and find the extremes
    for (int i = 0; i < vertexNumber; i++) {

	// Retrieve the current vertex
	const Vertex3D &current = vs[i];
	
	// Update minimum and maximums
	if (current.x < minimum.x) minimum.x = current.x;
	if (current.y < minimum.y) minimum.y = current.y;
	if (current.z < minimum.z) minimum.z = current.z;
	if (current.x > maximum.x) maximum.x = current.x;
	if (current.y > maximum.y) maximum.y = current.y;
	if (current.z > maximum.z) maximum.z = current.z;
    }
}

FaceGeometryImpl::FaceGeometryImpl()
    : _normalNumber(0), _texCoordNumber(0), _faceNumber(0)
{
    // empty
}
    
FaceGeometryImpl::~FaceGeometryImpl()
{
    // empty
}
