/* ------------------------------------------------------------------------
 * $Id: SceneManager.cc,v 1.25 2001/08/28 13:18:51 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-10-23 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000, 2001 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- System includes
#include <time.h>

// -- 3Dwm Includes
#include "Celsius/Mutex.hh"
#include "Celsius/Logger.hh"
#include "Polhem/Event.hh"
#include "Polhem/Group.hh"
#include "Polhem/NodeImpl.hh"
#include "Polhem/RendererImpl.hh"
#include "Polhem/ViewSlotImpl.hh"
#include "Polhem/LogGroup.hh"
#include "Polhem/Platform.hh"
#include "Polhem/View.hh"
#include "Polhem/SceneManager.hh"
#include "Polhem/PickerImpl.hh"
#include "Polhem/MapperImpl.hh"

using namespace Nobel;

// -- Code Segment

SceneManager::SceneManager(View *v)
    : _quit(false),
      _view(v)
{
    _root = new Group();

    // Create a root view slot 
    // @@@Refactor this into client-defined slots and N different views.
    ViewSlotImpl *slot = new ViewSlotImpl();
    Nobel::Node_var node_ref = slot->_this();
    Nobel::ViewSlot_var slot_ref = Nobel::ViewSlot::_narrow(node_ref);

    // Add it to the scene graph root and attach the view to the slot
    _root->insert(slot_ref);    
    _view->attachTo(slot_ref);
}

SceneManager::~SceneManager()
{
    // @@@Clean up the scene graph!
}

void SceneManager::run()
{
    const timespec ts = { 0, 500 };

    // Loop until the user exits
    while (_quit == false) {

	// Clear the screen and Z-buffer
	Platform::clearDisplay();
	
	// Render the scene graph from the view object
	_view->render(_root);	
	
	// Finalize rendering
	Platform::swapDisplay();

	// Sleep for a while
	nanosleep(&ts, NULL);
    }
}

NodeImpl *SceneManager::createClientRoot()
{
    NodeImpl *client_root = new Group();
    _root->insert(Nobel::Node_var(client_root->_this()));
    return client_root;
}

//void SceneManager::pick(const Vector2D &p, int button, bool pressed)
void SceneManager::handlePositional(const Vector2D &p, Nobel::Event e)
{
    // Perform a ray picking traversal
    RayPicker *picker = new RayPicker(p, _view);
    _root->traverse(Nobel::Picker_var(picker->_this()));

    // Retrieve the list of picked nodes
    const std::list<RayPicker::HitNode> &hitList = picker->getHitNodeList();
    if (hitList.empty()) return;

    // Set the computed intersection point into the event
    e.pos = hitList.begin()->point;
    
    // @@@Major kludge follows!
    
    // Set focus to the nearest picked node and send the event to it
    _focus = Nobel::Node::_duplicate(hitList.begin()->node);
    _focus->receive(e);
}

void SceneManager::pick(const Vector3D &p)
{
    // Initiate a 3D pick traversal here?
}

void SceneManager::handleNonPositional(Nobel::Event e)
{
    // If no focus, ignore it
    if (CORBA::is_nil(_focus))
	return;
    
    // Send the event to the currently focused node
    _focus->receive(e);
}
