# $Id: io.tcl,v 1.30 1998/10/25 22:11:32 cthulhu Exp $

proc dpos {w {x 300} {y 300}} {
    wm geometry $w +$x+$y
}


proc fileSelection {title defPattern def_filename {mot {}}} {
#    source "[xxl_library]/globalvars.tcl"
   global mother fileSelected currentPattern
   set mother $mot    

    set fileSelected $def_filename
    set currentPattern $defPattern

    if {$mother == {}} {
        catch {destroy .filein}
        toplevel .filein
        dpos .filein
        wm title .filein 
        wm iconname .filein
        wm minsize .filein 1 1        
    } else {
        frame $mother.filein
    }

    if {$title != ""} {
        message $mother.filein.msg -text $title -width 8c 
    }
    frame $mother.filein.frame -borderwidth 10
    button $mother.filein.abort -text Abort \
        -command "set fileSelected {}; destroy $mother.filein"
   button $mother.filein.ok -text OK -command {
       set list [exec ls -a]
       foreach i $list {
	   if { [file isdirectory $i] } {
	       if {$fileSelected==$i} {
		   set fileSelected {}; 
	       }
	   }
       }

       destroy $mother.filein
   }
       
       
   label $mother.filein.label -text [pwd]
   pack $mother.filein.label -side top

    frame $mother.filein.frame.1
    frame $mother.filein.frame.2

    label $mother.filein.frame.1.label -text "Filename:"    
    pack $mother.filein.frame.1.label -side left
    entry $mother.filein.frame.1.file -relief sunken -textvariable fileSelected
    pack $mother.filein.frame.1.file -fill x
    pack $mother.filein.frame.1 -fill x

    label $mother.filein.frame.2.label -text "Filter:"    
    pack $mother.filein.frame.2.label -side left
    entry $mother.filein.frame.2.pat -relief sunken -textvariable currentPattern
    pack $mother.filein.frame.2.pat -fill x
    pack $mother.filein.frame.2 -fill x


    if {$title != ""} {
        pack $mother.filein.msg -side top
    }
    pack $mother.filein.frame -side top -expand yes -fill y
    pack $mother.filein.abort -side bottom -fill x
    pack $mother.filein.ok -side bottom -fill x
    if {$mother != {}} {
        pack $mother.filein
    }

    scrollbar $mother.filein.frame.scroll -relief sunken -command "$mother.filein.frame.list yview"
    listbox $mother.filein.frame.list -yscroll "$mother.filein.frame.scroll set" -relief sunken \
	    -setgrid 1
   pack $mother.filein.frame.scroll -side right -fill y
   pack $mother.filein.frame.list -side left -expand yes -fill both
   
   bind $mother.filein.frame.list <ButtonRelease-1> {
       catch {
	   set fileSelected [$mother.filein.frame.list get [$mother.filein.frame.list curselection]]
       }
       
       $mother.filein.label configure -text [pwd]
   }
   
   bind $mother.filein.frame.list <Double-1> {
       set fileSelected [$mother.filein.frame.list get [$mother.filein.frame.list curselection]]
       if {[file isdirectory $fileSelected]} {
	   displayFiles $mother.filein.frame.list $currentPattern $fileSelected
	   $mother.filein.label configure -text [pwd]
       } else {
	   displayFiles $mother.filein.frame.list $currentPattern
	   $mother.filein.label configure -text [pwd]
	   after 100 {destroy $mother.filein}
       }
       
   }
   
   bind $mother.filein.frame.2.pat <KeyRelease> {
       displayFiles $mother.filein.frame.list $currentPattern
   }
   
   displayFiles $mother.filein.frame.list $defPattern
   
   tkwait window $mother.filein
   return $fileSelected
}

proc lreverse {l} {
        set l2 ""
        for {set i [expr [llength $l]-1]} {$i>=0} {incr i -1} {
                lappend l2 [lindex $l $i]
        }
        return $l2
}

proc displayFiles {lst pat {directorySelected {}} } {
       
    if {$directorySelected=={}} {
#	set list [glob -nocomplain $pat]

	set list [exec ls -a]

	set list2 {}

	foreach i $list {
	    if { [file isdirectory $i] } {
		lappend list2 $i
	    } else {
		if { [string match $pat $i] } {
		    lappend list2 $i
		}
	    }
	}   
	
	
	$lst delete 0 end

	foreach i [lreverse $list2] {
	    $lst insert 0 $i
	}
    } else {

	cd $directorySelected

#	set list [glob -nocomplain $pat]

	set list [exec ls -a]

	set list2 {}

	foreach i $list {
	    if { [file isdirectory $i] } {
		lappend list2 $i
	    } else {
		if { [string match $pat $i] } {
		    lappend list2 $i
		}
	    }
	}


	$lst delete 0 end
	
	foreach i [lreverse $list2] {
	    $lst insert 0 $i
	}
    }
}

proc exportTinySheetFile {mthd} {
    source "[xxl_library]/globalvars.tcl"
    fileSelection "Export Tiny Sheet File" "*.mem" "$activeSheet.mem" 

    getPrintParamsFromSheet
    puts "Exporting tinysheet from $activePrintRange"

    set f [open $fileSelected w]

    for {set c 0} {$c <= [lindex $activePrintRange 3]} {incr c} {
        for {set r 0} {$r <= [lindex $activePrintRange 2]} {incr r} {
	    if {$mthd==0} {
		set text "[CellValue $activeSheet $r $c]"
	    } else {
		set text "[CellGet $activeSheet $r $c]"
	    }
            regsub -all "@" $text "" newtext
            regsub -all {\$} $newtext "" text
            puts -nonewline $f "$text\t"
        }
        puts $f "" 
    }
    close $f

}

proc importTextLine {line r sep} {
    source "[xxl_library]/globalvars.tcl"

    set c 0
    while {$line!=""} {
	set pos_com [string first $sep $line]
	set pos_qot [string first "\"" $line]
	if {$pos_qot==-1 || $pos_qot>=$pos_com} {
	    set val [string range $line 0 [expr $pos_com - 1]]
	    set line [string range $line [expr $pos_com + 1] \
			  [expr [string length $line] - 1] ]
	    if {$pos_com>=0} {
		CellSet $activeSheet $c $r $val
	    } else {
		CellSet $activeSheet $c $r $line
		set line ""
	    }
	    incr c
	} else {
	    set line [string range $line [incr pos_qot] \
			  [expr [string length $line] - 1]]
	    set pos_qot [string first "\"" $line]
	    set val [string range $line 0 [expr $pos_qot - 1]]
	    set line [string range $line [expr $pos_qot + 1] \
			  [expr [string length $line] - 1]]
	    set pos_com [string first $sep $line]
	    set line [string range $line [incr pos_com] \
			  [expr [string length $line] - 1]]
	    CellSet $activeSheet $c $r $val
	    incr c
	}
    }
}

proc importText {sep} {
    source "[xxl_library]/globalvars.tcl"
    
    switch $sep {
	" "  {fileSelection \
		  "Import Space Separated File" "*.prn" "$activeSheet.prn"}
	";"  {fileSelection \
		  "Import Semicolon Separated File" "*.txt" "$activeSheet.txt"}
	"\t" {fileSelection \
		  "Import TAB Separated File" "*.txt" "$activeSheet.txt"}
	","  {fileSelection \
		  "Import CSV File" "*.csv" "$activeSheet.csv"}
    }
    set f [open $fileSelected r]
    set r 0
    
    for {gets $f line} {$line!=""} {gets $f line} {
	importTextLine $line $r $sep
	incr r
    }
    close $f
}

proc exportText {sep mthd} {
    source "[xxl_library]/globalvars.tcl"
    
    switch $sep {
	" "  {fileSelection \
		  "Export Space Separated File" "*.prn" "$activeSheet.prn"}
	";"  {fileSelection \
		  "Export Semicolon Separated File" "*.txt" "$activeSheet.txt"}
	"\t" {fileSelection \
		  "Export TAB Separated File" "*.txt" "$activeSheet.txt"}
	","  {fileSelection \
		  "Export CSV File" "*.csv" "$activeSheet.csv"}
    }
    getPrintParamsFromSheet
    set f [open $fileSelected w]
    for {set c 0} {$c <= [lindex $activePrintRange 3]} {incr c} {
        for {set r 0} {$r <= [lindex $activePrintRange 2]} {incr r} {
	    if {$mthd==0} {
		set text "[CellValue $activeSheet $r $c]"
	    } else {
		set text "[CellGet $activeSheet $r $c]"
	    }
	    if {[string match *$sep* $text]==1} {
		set newtext "\"$text\""
		set text $newtext
	    }
            puts -nonewline $f "$text$sep"
        }
        puts $f "" 
    }
    close $f
}

proc loadSheet {{file {}}} {
    source "[xxl_library]/globalvars.tcl"

    if {$file == ""} {
        fileSelection "Load file" "*.wk1" "$activeSheet.wk1" 
    } else {
        set fileSelected $file
    }

    if {$fileSelected == ""} return
    exec cp $fileSelected $fileSelected.bck
    set s $fileSelected
    set s [getRadix $s]
    if {[SheetEmpty $activeSheet]} {
        changeSheetName $activeSheet $s
        set c [canvasFromSheet $s]
        $c config -cursor watch
        update
        LoadSheet $s $fileSelected
        redrawCanvas $s
        $c config -cursor diamond_cross
    } else {
        newSpreadsheet $s
        puts "Loading $s $fileSelected"
        set c [canvasFromSheet $s]
        $c config -cursor watch
        update 
        LoadSheet $s $fileSelected
        redrawCanvas $s
        $c config -cursor diamond_cross
    }
}

proc saveSheet {} {
    source "[xxl_library]/globalvars.tcl"
    fileSelection "Save file" "*.wk1" "$activeSheet.wk1" 
    if {$fileSelected == ""} return
    puts "Saving $activeSheet $fileSelected"
    set s [getRadix $fileSelected]
    changeSheetName $activeSheet $s
    SaveSheet $s $fileSelected
    puts "Redrawing canvas $s for active sheet $activeSheet"
    redrawCanvas $s
}

proc printCurrentRange {} {
    source "[xxl_library]/globalvars.tcl"

    if {$currentRange == ""} {
	set lastRow 0
	set lastCol 0
	
	while {[RowOrigin $activeSheet $lastRow]<900} {
	    incr lastRow
	}
	while {[ColOrigin $activeSheet $lastCol]<584} {
	    incr lastCol
	}
	set currentRange [list 0 0 [incr lastCol -1] [incr lastRow -1]]
    }
    computePrintParams

#    set fileSelected $activeSheet.ps
#    set currentPattern "*.ps"
    set title "Export Encapsulated Postscript\nRange [rangeName $currentRange]"

    catch {destroy .prt}
    toplevel .prt

    label .prt.msg -text $title -relief raised 
    pack .prt.msg -side top -fill x

    global typeView scaleOption colorMode
    set typeView 0
    set scaleOption ""
    set colorMode mono

    frame .prt.options1 -relief ridge -borderw 2
    frame .prt.options2 -relief ridge -borderw 2
    frame .prt.options3 -relief ridge -borderw 2
    frame .prt.options4 -relief ridge -borderw 2


    radiobutton .prt.options1.fit1 -variable scaleOption \
            -value "" -text "Normal size"
    radiobutton .prt.options1.fit2 -variable scaleOption \
            -value "-pagewidth [join "$paperWidth c" {}]" \
            -text "Fit to page width"
    radiobutton .prt.options1.fit3 -variable scaleOption \
            -value "-pageheight [join "$paperHeight c" {}]" \
            -text "Fit to page height"




    radiobutton .prt.options2.portrait -variable typeView -text "Portrait" \
            -value 0
    radiobutton .prt.options2.landscape -variable typeView -text "Landscape" \
            -value 1
    
    radiobutton .prt.options3.color1 -variable colorMode \
            -value "mono" -text "Black and white"
    radiobutton .prt.options3.color2 -variable colorMode \
            -value "gray" -text "Gray scale"
    radiobutton .prt.options3.color3 -variable colorMode \
            -value "color" -text "Full color"
       
    checkbutton .prt.options4.borders -variable showCellBorders \
            -text "Show cell borders" \
            -command {ToggleDisplayBorders $activeSheet;\
			  toggleCellBordersDisplay } 


    pack .prt.options1 -anchor w -fill x -expand true
    pack .prt.options1.fit1 -anchor w  
    pack .prt.options1.fit2 -anchor w
    pack .prt.options1.fit3 -anchor w 

    pack .prt.options2 -anchor w -fill x -expand true
    pack .prt.options2.portrait -anchor w
    pack .prt.options2.landscape -anchor w

    pack .prt.options3 -anchor w -fill x -expand true
    pack .prt.options3.color1 -anchor w
    pack .prt.options3.color2 -anchor w
    pack .prt.options3.color3 -anchor w

    pack .prt.options4 -anchor w -fill x -expand true
    pack .prt.options4.borders -anchor w


    set fileSelected [fileSelection "" "*.eps" $activeSheet.eps .prt]
    destroy .prt
    if {$fileSelected == {}} {return}

    set c [canvasFromSheet $activeSheet]

    set x1 [colOrigin [lindex $currentRange 0]]
    set y1 [rowOrigin [lindex $currentRange 1]]
    set x2 [colOrigin [expr (1+[lindex $currentRange 2])]]
    set y2 [rowOrigin [expr (1+[lindex $currentRange 3])]]

    unhighlightCurrentRange $c
    unhighlightActiveCell

    set st "$c postscript -file $fileSelected \
              -x $x1 -y $y1 -height [expr $y2-$y1] -width [expr $x2-$x1] \
              -rotate $typeView $scaleOption -colormode $colorMode"
    eval $st
    highlightActiveCell
}



proc printSheet {} {
    source "[xxl_library]/globalvars.tcl"

    set fromPage 1
    set toPage ""

    getPrintParamsFromSheet

    computePrintParams

#    puts "Printing range $activePrintRange"

    toplevel .print

    frame .print.f0 
    label .print.f0.title -text "Print to file"
    pack .print.f0.title .print.f0


    frame .print.f6 -relief ridge -borderw 2
    button .print.f6.preview -text Preview -command {
        set previewFile /tmp/.xxl_prev_[pid]
        doPrintSheet $previewFile $activePrintRange $colorMode $paperWidth \
                $paperHeight $typeView $scale  $fromPage $toPage
        exec ghostview $previewFile &
        after 5000 exec rm $previewFile 
    }
    pack .print.f6.preview -fill x -expand yes

    button .print.f6.setup -text Setup -command {
        printSetup
    }
    pack .print.f6.setup -fill x -expand yes


    pack .print.f6 -fill x

    frame .print.f5 -relief ridge -borderw 2


    entry .print.f5.from -textvariable fromPage -width 3
    label .print.f5.fromtext -text "From page "
    entry .print.f5.to -textvariable toPage -width 3
    label .print.f5.totext -text " to page "
    pack .print.f5.fromtext .print.f5.from .print.f5.totext .print.f5.to \
            -side left -fill x
    pack .print.f5 -fill x 
    


    fileSelection "" "*.ps" "$activeSheet.ps" .print
    destroy .print
    if {$fileSelected == ""} return


    doPrintSheet $fileSelected $activePrintRange $colorMode $paperWidth \
            $paperHeight $typeView $scale $fromPage $toPage

}

proc doViewPages {} {
    source "[xxl_library]/globalvars.tcl"

    set scaleToUse [expr $defaultPrintScale * $scale]

    puts "Called for $activePrintRange $paperWidth $paperHeight $typeView $scaleToUse"

    set c [canvasFromSheet $activeSheet]

    set x1 [colOrigin [lindex $activePrintRange 0]]
    set y1 [rowOrigin [lindex $activePrintRange 1]]
    set x2 [colOrigin [expr (1+[lindex $activePrintRange 2])]]
    set y2 [rowOrigin [expr (1+[lindex $activePrintRange 3])]]
    
    unhighlightCurrentRange $c
    unhighlightActiveCell


# First, we need the header
    
    if {$typeView == 0} {
        set ww [join "$paperWidth c" {}]
        set hh [join "$paperHeight c" {}]
    } else {
        set hh [join "$paperWidth c" {}]
        set ww [join "$paperHeight c" {}]
    }

    set rr [$c create line 0 0 $ww $hh X 0 0 0 0]
    set r [$c coords $rr]
    set w [expr [lindex $r 2]/$scaleToUse]
    set h [expr [lindex $r 3]/$scaleToUse]

    $c delete $rr

    for {set x [lindex $activePrintRange 0]} {$x <= [lindex $activePrintRange 2]} {} {
        set xcoord [colOrigin $x]
        set xf [cellCol $activeSheet [expr $xcoord+$w]]
        set xfcoord [colOrigin $xf]
        
        for {set y [lindex $activePrintRange 1]} {$y <= [lindex $activePrintRange 3]} {} {

            set ycoord [rowOrigin $y]
            set yf [cellRow $activeSheet [expr $ycoord+$h]]
            set yfcoord [rowOrigin $yf]

            set pw [join "$paperWidth c" {}]
            set ph [join "$paperHeight c" {}]

#            puts "Executing $c create line $x $y $xf $yf -fill red -tag pageLimits"
            $c create line $xcoord $ycoord $xfcoord $ycoord  X 0 0 0 0 \
                    -fill red -tag pageLimits
            $c create line $xcoord $ycoord $xcoord $yfcoord  X 0 0 0 0 \
                    -fill red -tag pageLimits
            $c create line $xcoord $yfcoord $xfcoord $yfcoord  X 0 0 0 0 \
                    -fill red -tag pageLimits
            $c create line $xfcoord $ycoord $xfcoord $yfcoord  X 0 0 0 0 \
                    -fill red -tag pageLimits

            set y $yf
        }
        set x $xf
    }

    

}

proc doPrintSheet {fileSelected activePrintRange colorMode paperWidth paperHeight typeView scale fromPage toPage} {
    global activeSheet
    global defaultPrintScale
    global showPageBorders

    computePrintParams

    set scaleToUse [expr $defaultPrintScale * $scale]

    if {$toPage == ""} {set toPage 10000}

    set c [canvasFromSheet $activeSheet]

    set x1 [colOrigin [lindex $activePrintRange 0]]
    set y1 [rowOrigin [lindex $activePrintRange 1]]
    set x2 [colOrigin [expr (1+[lindex $activePrintRange 2])]]
    set y2 [rowOrigin [expr (1+[lindex $activePrintRange 3])]]
    
    unhighlightCurrentRange $c
    unhighlightActiveCell

    $c delete pageLimits

# First, we need the header
    set st "$c postscript -colormode $colorMode\
              -x $x1 -y $y1 -height [expr $y2-$y1] -width [expr $x2-$x1]"
    set header [eval $st]
    
    

# Now, get the header we really need

    set i2 [string first "%%BoundingBox" $header]
    set i3 [string first "%%" [string range $header [expr $i2+2] end]]
    set i4 [string first "%%Page: 1 1" $header]


    set result \
        "[string range $header 0 $i2][string range $header [expr $i2+$i3+3] $i4]"



    set j [string first "%%Trailer" $header]
    set trailer [string range $header $j end]

# Now, get page after page
# Get page width and height, in points

    
    if {$typeView == 0} {
        set ww [join "$paperWidth c" {}]
        set hh [join "$paperHeight c" {}]
    } else {
        set hh [join "$paperWidth c" {}]
        set ww [join "$paperHeight c" {}]
    }

    set rr [$c create line 0 0 $ww $hh X 0 0 0 0]
    set r [$c coords $rr]
    set w [expr [lindex $r 2]/$scaleToUse]
    set h [expr [lindex $r 3]/$scaleToUse]

    $c delete $rr


    set cnt 1
    for {set x [lindex $activePrintRange 0]} {$x <= [lindex $activePrintRange 2]} {} {
        set xcoord [colOrigin $x]
        set xf [cellCol $activeSheet [expr $xcoord+$w]]
        set xfcoord [colOrigin $xf]
        
        for {set y [lindex $activePrintRange 1]} {$y <= [lindex $activePrintRange 3]} {} {

            set ycoord [rowOrigin $y]
            set yf [cellRow $activeSheet [expr $ycoord+$h]]
            set yfcoord [rowOrigin $yf]

            set pw [join "$paperWidth c" {}]
            set ph [join "$paperHeight c" {}]


            if {$cnt <= $toPage && $cnt >= $fromPage} {
                puts "POSTSCRIPT $xcoord $ycoord $xfcoord $yfcoord"
                if {$typeView == 0} {
                    set st "$c postscript -colormode $colorMode\
                            -x $xcoord -y [expr $ycoord] \
                            -height [expr $yfcoord-$ycoord] \
                            -width [expr $xfcoord-$xcoord]  \
                            -pagewidth $pw \
                            -pageheight $ph"
                } else {
                    set st "$c postscript -colormode $colorMode\
                            -x $xcoord -y [expr $ycoord] \
                            -height [expr $yfcoord-$ycoord] \
                            -width [expr $xfcoord-$xcoord]  \
                            -pagewidth $ph \
                            -pageheight $pw -rotate 1"
                }
            
                    
                puts "Printing page $cnt"
                set page [eval $st]

                set i [string first "%%Page: 1 1" $page]
                set j [string first "showpage" $page]
                
                
                set pp "\n%%Page: 1 $cnt\n"
                set pp $pp[string range $page [expr $i+12] [expr $j+9]]
                
                
                set result "$result $pp"
            }
            set y $yf
            incr cnt
        }
        set x $xf
    }
    set result "$result$trailer"
    set f [open $fileSelected w]
    puts $f $result
    close $f

    if {$showPageBorders} {
        computePrintParams
    }
    highlightActiveCell
}

proc oldprintCurrentRange {} {
    source "[xxl_library]/globalvars.tcl"

    if {$currentRange == ""} {
        HelpMessage "First define a range, then chose print range"
        return
    }

    fileSelection "Print range to file" "*.ps" "$activeSheet.ps" 

    if {$fileSelected == ""} return
    set filename $fileSelected


    set c [canvasFromSheet $activeSheet]

    set x1 [colOrigin [lindex $currentRange 0]]
    set y1 [rowOrigin [lindex $currentRange 1]]
    set x2 [colOrigin [expr (1+[lindex $currentRange 2])]]
    set y2 [rowOrigin [expr (1+[lindex $currentRange 3])]]

    unhighlightCurrentRange $c
    unhighlightActiveCell

    $c postscript -file $filename \
            -x $x1 -y $y1 -height [expr $y2-$y1] -width [expr $x2-$x1]

    highlightActiveCell
    

}

proc exitXxl {} {
    source "[xxl_library]/globalvars.tcl"

    foreach i $existingSheets {
        deleteSpreadsheet $i
    }
    if {$existingSheets == ""} {
        destroy .
    }
}

proc getRadix s {
    set i [string first "." $s]
    set s [string range $s 0 [expr $i-1]]
    return $s
}
 
# $Log: io.tcl,v $
# Revision 1.30  1998/10/25 22:11:32  cthulhu
# Fixed bug when importing text files.
#
# Revision 1.29  1998/10/13 21:48:17  cthulhu
# Removed exit puts.
#
# Revision 1.28  1998/10/06 20:17:07  cthulhu
# Removed ugly puts from fileselection.
#
# Revision 1.27  1998/09/30 21:03:17  cthulhu
# Open Save dialog Box now allows user to browse directories.
#
# Revision 1.26  1998/09/28 22:27:43  cthulhu
# File selection dialogue was redone to become nicer :)
#
# Revision 1.25  1998/09/04 02:27:31  cthulhu
# ToggleDisplayBorders was being called with 2 args instead of 1
#
# Revision 1.24  1998/08/22 22:09:36  cthulhu
# Warnings are displayed using HelpMessage instead of WarnUser
#
# Revision 1.23  1998/08/06 21:08:32  aml
# Released alpha version of Abacus.
#
# Revision 1.23  1997/09/30 23:09:33  aml
# Created export for tinysheet format.
# Introduced pow() as alternative to ^.
# Fixed bug in row height setting.
# Fixed bug in composite character insertion.
# Inserted check in exp and power functions.
#
# Revision 1.22  1997/03/27 10:00:36  aml
# Started implementing graphs.
# Fixed bug in tkCanvasPs.c
# Created bindings for composite characters in Portuguese.
#
# Revision 1.21  1997/02/10  15:10:03  aml
# Print settings now are saved to file.
# Fixed buggy error message when loading sheets.
#
# Revision 1.20  1996/12/31 17:38:36  aml
# On-demand calculation improved. Loops are detected.
# Automatic recalculation can now be disabled.
# Printing was improved.
#
# Revision 1.19  1996/11/22 16:29:11  aml
# First cut at transforming canvas into a true cell widget.
# Text, lines and rectangles are now relative to row and colunm numbers.
# It still has a bug with wrong estimation of column widths.
#
# Revision 1.18  1996/10/10 22:55:25  aml
# Print preview. Improvements on print command.
#
# Revision 1.17  1996/10/09 13:55:02  aml
# First cut of full print.
#
# Revision 1.16  1996/09/15 19:24:20  aml
# Rulling and shading.
# Optionally hide cell borders.
# Works well, but is very slow for large spreadsheets.
#
# Revision 1.15  1996/09/04  14:29:53  aml
# Fixed double redrawing of sheets that was taking place.
# Fixed a item reference problem when the sheet is redrawn.
# Fixed misplacement of row labels.
# Created first version of format toolbar.
#
# Revision 1.14  1996/08/28 17:17:48  aml
# Load and save now accept string_value for formula cells.
# This fixes previous thought problem of formula values not
# being stored.
# Functions upper,lower and proper created.
# Function if can now return labels.
# Fixed problem with function count.
# Reasonably stable version, very used to manipulate notas.wk1.
#
# Revision 1.13  1996/08/24 10:16:00  aml
# Scroll almost fixed. We are missing scroll steps.
# Several sheets work again, but need to be fixed right.
#
# Revision 1.12  1996/07/18  10:19:19  aml
# Created formats for cells.
# Load cell now makes copy of old file.
#
# Revision 1.11  1996/03/29 21:45:32  aml
# Changed key based scrolls to be synchronous. Work fine, but are somewhat slow.
# Fixed abnormaly in state machine after range defition causing canvas scroll.
# Solid, working version.
#
# Revision 1.10  1996/03/11 15:47:46  aml
# Made redraw more efficient by removing at once all cells before redrawing.
# Fixed problem with unsufficient difinition of logical expressions.
# Added >=, <=, <>, @and and @or functions.
#
# Revision 1.9  1996/03/09 08:32:38  aml
# Fixed problem in string_single_arg macro
# Created if function, boolean evaluations and so on.
# Improved print controls.
#
# Revision 1.8  1996/03/07  20:32:55  aml
# Created print range ability.
# Set in gray non-working menus.
# Created RangeKill command.
# Created round function and macros for single argument functions.
#
# Revision 1.7  1996/03/01  13:08:44  aml
# Stack references are now pushed instead of double value.
# Fixed problem with integers too large on formulas.
# Scroll with cursors now works better.
#
# Revision 1.6  1996/02/16 23:09:32  aml
# Improved user interf state machine.
# Centralized range definitions.
# Range defined outiside current view work properly.
#
# Revision 1.5  1996/01/27  23:10:25  aml
# CellCopy created.
# CellGet fixed.
# Tcl range operators created.
# User interface improved. Cell references and ranges
# can now be defined with the mouse.
#
# Revision 1.4  1996/01/09  18:34:47  aml
# Load, save, open, close and exit now work properly (hopefuly).
# Sheet utility functions also work : SheetExists, SheetEmpty, SheetModified
#
# Revision 1.3  1996/01/07  09:07:30  aml
# Sheet::save and Sheet::load created.
# Program can now write and read wk1 files.
# Slight changes made to relative references. Bit 14 is now always 0.
#
# Revision 1.2  1996/01/07  08:38:55  aml
# RCS info changed
#
# Revision 1.1  1996/01/07  08:34:30  aml
# Initial revision
#
