!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_hatden
!! NAME 
!! calc_hatden
!!
!! FUNCTION
!! Compute the compensation charge density;
!! Compute also Qij_hat quantities for i,j=(0,0).
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  pawarray
!!    %gnorm(l_size)= Normalisation of qijl for each l
!!    %shapefunc(sph_meshsz)= Normalized shape function
!!    %tvaleden4pr2(rho_meshsz)= Valence density multiplied by 4Pi.r2
!!    %valeden4pr2(rho_meshsz)= Pseudo valence density multiplied by 4Pi.r2
!!  pawdata
!!    %rad(big_meshsz)= Coordinates of the radial grid
!!    %rad_(big_meshsz)= rad(:) + AA where rad(i)=AA*(exp[BB*(i-1)]-1)
!!  pshead
!!    %log_step= Logaritmic step corresponding to radial mesh
!!    %sph_meshsz= Dimension of radial mesh for spheres
!!
!! OUTPUT
!!  pawarray
!!    %hatden4pr2(sph_meshsz)= Compensation charge density
!!    %q00hat(sph_meshsz)= Qij_hat terms with i,j=(0,0)
!!
!! PARENTS
!!      uspp2abinit
!! CHILDREN
!!
!! SOURCE

 subroutine calc_hatden(pawarray,pawdata,pshead)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ------------------------------------
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawdata_type)  :: pawdata
 type(pshead_type)   :: pshead

!Local variables-------------------------------
 integer :: ir
 real(dp) :: intg_diff
 real(dp),allocatable :: diff(:)

! *************************************************************************

!Compute int[4*pi*r^2(n1(r)-tn1(r))dr]
!--------------------------------------------------------
 allocate(diff(pshead%sph_meshsz))
 do ir=1,pshead%sph_meshsz
  diff(ir)=(pawarray%valeden4pr2(ir)&
&          -pawarray%tvaleden4pr2(ir))*pawdata%rad_(ir)
 enddo
 call ctrap(pshead%sph_meshsz,diff,pshead%log_step,intg_diff)
 deallocate(diff)

!Compute hat density
!--------------------------------------------------------
 do ir=1,pshead%sph_meshsz
  pawarray%q00hat(ir)=pawarray%gnorm(1) &
&                    *pawarray%shapefunc(ir)*pawdata%rad(ir)**2
  pawarray%hatden4pr2(ir)=pawarray%q00hat(ir)*intg_diff
 enddo

end subroutine
!!***

