
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: astr.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include "aca.h"

#include <string.h>
#include <ctype.h>

/*
	Print string and chars between '|' print bold and with
	acolor.
 */	
   void mvaddastr(int l, int c, char *astr, int acolor, int color)
   {
      char		*p, buff[BUFSIZ], *loc;
      register int	set=FALSE, size=0;
   
      _D( " mvaddastr()");
   
      if (!astr) 
         return;
   
      strncpy(buff, astr, BUFSIZ);
      p = buff; 
   
      if ((loc = strchr(p, '|'))) {
         do {
            *loc = '\0';
            if (set) {
               aca_c(acolor);
               bold;
            } 
            else {
               ubold;
               aca_c(color);		
            }
            mvaddstr(l, c+size, p);
            size += strlen(p);
            set = set ? FALSE : TRUE;
            p = (++loc);
            loc = strchr(p, '|');
         } while(loc);	
         ubold;
         aca_c(color);		
         mvaddstr(l, c+size, p);
      } 
      else {
         ubold;
         aca_c(color);	
         mvaddstr(l, c, p);
      }	
   }

/*
	Return size of astr (active string).
*/	
   int astrlen(char *astr)
   {
      register int	size=0;
      char 		*loc;
   
      _D( " astrlen()");
   
      if (!astr) 
         return FALSE;
   
      if (!(size = strlen(astr))) 
         return size;
      loc = astr;
      while ((loc=strchr(loc, '|'))) {
         --size;
         ++loc;
      }	
      return size;	  	
   }

/*
	Make string from astr (active string).
*/	
   char *astr2str(char *str, char *astr)
   {
      char 		*aloc, *sloc;
   
      _D( " astr2str() ");
   
      if (!astr) 	
         return FALSE;
      if (!str)	
         return FALSE;	
   
      aloc 	= astr;
      sloc 	= str;
   
      while (*aloc) {
         if (*aloc != '|') {
            *sloc = *aloc;
            ++sloc;
         }	
         ++aloc;
      }	
      return str;	  	
   }

/*
	Return first active char in astr (in widgets used as hotkey).
	- all hotkeys is lower characters.
 */
   int gethotkey(char *astr)	
   {
      char	*loc;
   
      _D(" gethotkey()");
   
      if (!astr) 
         return FALSE;
   
      if (!(loc = strchr(astr, '|')))
         return FALSE;
      else 
         return tolower(*(++loc));	
   }
