
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: key.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */


#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>		/* struct timeval */
#include <sys/select.h>		
#include <ctype.h>
#include <errno.h>
#include <malloc.h> 
#include <time.h>
#include <stdlib.h>

#include "aca.h"

#ifdef HAVE_MOUSE
	#include "mouse.h"
#endif	

#define GET_TIME(tv) (gettimeofday(&tv, (struct timezone *)NULL))

   ACA_BASIC_KEYS basic_keys[] = {
   	#include "key_define.h"
   };
      
   /* learn key buffer */ 
   typedef struct {
      int	key;
      char	seq[33];
   } learn_buff;

   char	*GL_term_name;
   char	GL_seq_buff[256];
   int	GL_last_key;
   int	GL_current_key;	
   int	GL_inlearn_mode = FALSE;

   static int		input_fd;
   static int		learn_std_char	= FALSE;
   static learn_buff	lbuff[21];

   INI_SectionData ini_keys_data[MAX_BASIC_KEYS+2]; 

   void aca_keypad(int x)
   {
   #if DEBUG==1
	if (x)	_D("KEYPAD: true");
	else	_D("KEYPAD: flase");
   #endif
      	keypad(stdscr, (aca.keypad = x));
   }

   void aca_dump_keys(FILE *f, ACA_BASIC_KEYS *k)
   {
      _D( " aca_dump_keys() ");
      
      if (k->seq)
         fprintf(f, "%s=%s\n", keyname(k->curses), k->seq);					
   }

   int learn_keydump_check()
   {
      ACA_BASIC_KEYS	*k;
      int		re=FALSE;
   
      _D( " learn_keydump_check()");
      
      for(k=basic_keys; k->curses!=0; k++) {
         if (k->learn && k->seq)
            re = TRUE;
      }		
      return re;	
   }

   int isfunckey( int key ) 
   {
      ACA_BASIC_KEYS	*k;
   
      _D( " isfunckey()");
   
      for(k=basic_keys; k->curses!=0; k++) {
         if (k->curses == key)
            return TRUE;
      }		
      return FALSE;		
   }

   int set_learn_key(char *name, char *seq) 
   {
      int 		re=FALSE;	
      ACA_BASIC_KEYS	*k;
      
      _D( " set_learn_key()");
      
      for(k=basic_keys; k->curses!=0; k++) {
         if (!strcmp(keyname(k->curses), name)) {
            k->seq	= seq;
            k->learn	= TRUE;
            re 		= TRUE;
            if (isprint(seq[0]))	
               learn_std_char	= TRUE;
         }	
      }
      return re;
   }

   static int load_keys(INI_Section *sect)
   {
       INI_SectionData	*sect_d;   
       int		re=FALSE;
   
      _D( " load_keys()");

      for(sect_d=sect->data; sect_d->value != NULL; sect_d++) {
      	 if (!sect_d->content)
      	 	continue;
      	 if (set_learn_key(sect_d->value, sect_d->content))
         	re = TRUE;
      }
      return re;	
   }

   void load_seqences()
   {
      ACA_BASIC_KEYS	*k;
   
      _D( " load_sequences() ");
   
      for(k=basic_keys; k->curses!=0; k++) {
         if (k->learn) 
            continue;
         if ((k->seq = tigetstr(k->capname)) == (char *)-1 ) 
            k->seq = SeqN;	
         k->learn = FALSE;
      }
   }
   
   void init_keys_ini(INI_Section *sect)
   {
	ACA_BASIC_KEYS	*k;
	INI_SectionData	*sect_d;
   	
   	_D( " init_keys_ini()");
   	
   	for(sect_d=ini_keys_data, k=basic_keys; k->curses!=0; k++, sect_d++) {
   		sect_d->value 	= (char *) keyname(k->curses);
		sect_d->content = chN;
		sect_d->value_call_fn = NULL;
	}
	++sect_d;
	sect_d->value 	= chN; 
	sect_d->content = chN; 
   	sect->data 	= ini_keys_data;
   	sect->name 	= GL_term_name;
   	sect->flag 	|= SECT_LOAD;
   }

   void init_keys(aca_INI *ini)
   {	
      INI_Section	*sect;
      
      _D( " init_keys() ");
      
      input_fd	= fileno(stdin);	
   
      if (!aca.keypad)	
         load_seqences();
   
      if (!ini) return;
      
      if ((sect = INI_section(ini, GL_term_name))) { 
         if (aca.keypad)	
         	load_seqences();
         if (load_keys(sect)) 
            	aca_keypad(FALSE);
      }
   }

   int sig_check() 
   {
      _D( " sig_check()");
   
   /* GL_inter.. is set to FALSE in get_k */
      if (GL_interrupt_flag) {	
         _D( " sig_check(): SIG. INTERRUPT WAS CAUGHT");
         GL_interrupt_flag = FALSE;
         return KEY_F(10);			
      }	
      if (GL_winch_flag) {
         _D( " sig_check(): SIG. WINCH WAS CAUGHT");
         GL_winch_flag	= FALSE;	
         screen_resizer();
         return K_SCREEN_RESIZED;
      }   
      return FALSE;
   }

   int timeout_calls(int current)
   {
      int re;
      
      _D( " timeout_calls()");
      
      if ((re = sig_check()))
      	return re;	
			
      if (aca.extra_timeout_call)
         aca.extra_timeout_call_fn(current);		
   
      return RE_OK;	
   }

   static int getch_timer() 
   {
      register int c, current=0, count=0;	
   
      _D( " getch_timer()");
      
      if (aca.getch_timeout) {
         current = aca.getch_timeout;
         wtimeout(stdscr, current);
      }	
   
   #ifdef HAVE_MOUSE
   refresh();	
   while((c=aca_Gpm_Wgetch(stdscr)) == ERR || c == K_MOUSE_NOT) {
   #else
      while((c=getch()) == ERR) {
      #endif
      /* if mouse move (but not press) mouse_handler return 
         K_MOUSE_NOT and ACA go get up */ 
         if (c==K_MOUSE_NOT) {
            current = aca.getch_timeout;
            count = 0;
         }
         if ((c=timeout_calls(current)) != RE_OK) 
            return c;
      
         if (count < aca.fallasleep) 
            count += current;
         else if (current < 3600000)		/* max. is one hour */	
            current += aca.fallasleep_incr;
         wtimeout(stdscr, current);
      }
      refresh();		
      return c; 	
   }


/* Convert ctrl keys to curses key 
	(ctrl alternative keys are in acakey.h) 
 */ 
   static int convert_ctrl_keys(int c) 
   {
      ACA_BASIC_KEYS	*k;
   
      _D( " convert_ctrl_keys()");
      
      for(k=basic_keys; k->curses!=0; k++) 
         if (c == XCTRL(k->ctrl))
            return k->curses;
      return c;		
   }

   static int convert_esc_keys(int c) {
      
      _D( " convert_esc_keys()");
      
      switch(c) {
      case '1':	
         return KEY_F(1);
      case '2':	
         return KEY_F(2);
      case '3':	
         return KEY_F(3);
      case '4':	
         return KEY_F(4);
      case '5':	
         return KEY_F(5);
      case '6':	
         return KEY_F(6);
      case '7':	
         return KEY_F(7);
      case '8':	
         return KEY_F(8);
      case '9':	
         return KEY_F(9);
      case '0':	
         return KEY_F(10);
      case ESC_CHAR:	
         return KEY_F(10);
      }
      return c;
   }

/* set *key	- independent on keypad TRUE/FALSE 
		- if keypad is FALSE set first char of escape seq. 
   - return TRUE if *key is standard (independent on keypad) key 
     or FALSE if not 
 */		
   static int getkey_independent(int *key)
   {
      _D( " getkey_independent()");
      
      *key = getch_timer (); 
   
      if (*key=='\t' || *key==K_MOUSE_L || *key==K_MOUSE_M 
         || *key==K_MOUSE_R || *key=='\n') 
         return TRUE;
   
      if (*key != ESC_CHAR && T_XCTRL(*key)) {
         *key = convert_ctrl_keys(*key);
         return TRUE;
      }
      return FALSE;	
   }

/******
   void clean_input ()
   {
      int	c;
      fd_set Read_FD_Set;	
      struct timeval endtime;
      struct timeval timeout;
   
   GET_TIME (endtime);
      endtime.tv_usec += MAX_SEQTIME;
      if (endtime.tv_usec > 1000000) {
         endtime.tv_usec -= 1000000;
         endtime.tv_sec++;
      }
      nodelay(stdscr, TRUE);
      for (;;) {
         while ((c = getch()) == ERR) {
         GET_TIME (timeout);
            timeout.tv_usec = endtime.tv_usec - timeout.tv_usec;
            if (timeout.tv_usec < 0)
               timeout.tv_sec++;
            timeout.tv_sec = endtime.tv_sec - timeout.tv_sec;
            if (timeout.tv_sec >= 0 && timeout.tv_usec > 0) {
               FD_ZERO (&Read_FD_Set);
               FD_SET (input_fd, &Read_FD_Set);
               select (FD_SETSIZE, &Read_FD_Set, NULL, NULL, &timeout);		
            } 
            else	
               break;
         }
         if (c == ERR)	
            break;
      }
      nodelay(stdscr, FALSE);	
   }
*****/

   static int getkey_after_esc(int *key)
   {
      int	x;
   
      _D( " getkey_after_esc()");
   
      x = aca.keypad;
      aca_keypad(FALSE);
   
      notimeout(stdscr, TRUE);
      *key = wgetch(stdscr);
      notimeout(stdscr, FALSE);
   
      aca_keypad(x);
   
      if (*key != ERR) 
         *key = convert_esc_keys(*key);
      else 
         return K_STAY;
      return *key;
   }

   static int set_lastkey(int k)
   {
      _D( " set_lastkey()");
      
      GL_last_key = GL_current_key;
      GL_current_key = k;
      return k;
   }

   int find_in_lbuff(char *seq)
   {
      int	i;
      
      _D( " find_in_lbuff()");
      
      for(i=0; i<=MAX_BASIC_KEYS; i++) {
         if (lbuff[i].key) {
            if (!strcmp(lbuff[i].seq, seq)) 
               return lbuff[i].key;
         }
      }
      return FALSE;
   }

   int check_seq(char *buffer)
   {
      ACA_BASIC_KEYS	*k;
      int		x;	
   
      _D(" check_seq()");
   
      for(k=basic_keys; k->curses!=0; k++) {		
         if (GL_inlearn_mode) {
            if ((x=find_in_lbuff(buffer))) 
               return x; 	
         }
         if (k->seq) {
            if (!strcmp(k->seq, buffer)) 
               return k->curses;
         } 
         if (!GL_inlearn_mode) {
            if (!k->learn && !strcmp(k->default_seq, buffer))
               return k->curses;	
         }
         if (aca.forcekey) {
            if (!strcmp(k->default_seq, buffer))
               return k->curses;				
         }		
      }
      return RE_ERROR;
   }

   static void store_key (char *buffer, char **p, int c)
   {
      _D( " store_key()");
      
      if (*p - buffer > 253)
         return;
      if (c == ESC_CHAR) {
         *(*p)++ = ESC_CHAR;  	
      } 
      else if (c < ' ') {
         *(*p)++ = '^';					
         *(*p)++ = c + 'a' - 1;	
      } 
      else if (c == '^') {
         *(*p)++ = '^';		
         *(*p)++ = '^';		
      } 
      else
         *(*p)++ = (char) c;	
   }

/* 
   Read escape sequences of input_fd and write it to 'buffer',
   and write to 'iskey' curses key (of sequencion) if this exist
   in ACA basic_keys
 */ 

   static char *makeseq (char *buffer, int *iskey)
   {
   #define MAX_SEQTIME	200000
      fd_set Read_FD_Set;	
      struct timeval endtime;
      struct timeval timeout;
      char *p = buffer;
   
      _D( " makeseq()");
   
      store_key (buffer, &p, *iskey);        
      if (buffer[0] != ESC_CHAR) {		
         buffer[1] =  '\0';
         if ((*iskey = check_seq(buffer)) != RE_ERROR)	
            return buffer; 
      }
   
      GET_TIME (endtime);
      endtime.tv_usec += MAX_SEQTIME;
      if (endtime.tv_usec > 1000000) {
         endtime.tv_usec -= 1000000;
         endtime.tv_sec++;
      }
      nodelay(stdscr, TRUE);
   
      for (;;) {
         while ((*iskey = getch ()) == ERR) {
            GET_TIME (timeout);
            timeout.tv_usec = endtime.tv_usec - timeout.tv_usec;
            if (timeout.tv_usec < 0)
               timeout.tv_sec++;
            timeout.tv_sec = endtime.tv_sec - timeout.tv_sec;
            if (timeout.tv_sec >= 0 && timeout.tv_usec > 0) {
               int	re=FALSE;
               FD_ZERO (&Read_FD_Set);
               FD_SET  (input_fd, &Read_FD_Set);
               _D( "\tmakeseq: CALL select()");
               select  (FD_SETSIZE, &Read_FD_Set, NULL, NULL, &timeout);		
               if ((re = sig_check())) {
            		*iskey = re;
            		nodelay(stdscr, FALSE);
            		return (char *) NULL;
               }
            } 
            else	
               break;
         }
         
         if (*iskey == ESC_CHAR || *iskey == ERR)	/* == '\e' is next seq */
            break;
         store_key (buffer, &p, *iskey);        
         *p = '\0';
      
         if ((*iskey = check_seq(buffer)) != RE_ERROR)	
            break; 
      }
      *p = 0;
      nodelay(stdscr, FALSE);
   
    /* user press ESC - not seqencion */ 
      if (buffer[1] == '\0' && buffer[0] == ESC_CHAR) {	 
         *iskey = ESC_CHAR;
         return (char *) NULL;
      }	
      else
         return buffer;		
   }

   static int getkey_seq(int *key) 
   {	
      int	x=*key;
   
      _D(" getkey_seq");
   
      GL_seq_buff[0] = '\0';
   
      if (!isprint(*key)) 
         makeseq(GL_seq_buff, key);
      else if (learn_std_char) {
         GL_seq_buff[0] = *key;
         GL_seq_buff[1] = '\0';
         *key = check_seq(GL_seq_buff);			
      }
   
      _D(GL_seq_buff);
   
      if (*key == ESC_CHAR || *key == RE_ERROR) {
         *key = x;
         return FALSE;
      } 
      else
         return TRUE;		
   }

   int get_k()
   {
      int	key;
   
      _D( " get_k()");
      
      if (getkey_independent(&key))
         return set_lastkey(key);
   
      if (!aca.keypad) {
         if (getkey_seq(&key))
            return set_lastkey(key);
      }
   
      if (key == ESC_CHAR) {
         set_lastkey(ESC_CHAR);
         return set_lastkey(getkey_after_esc(&key));
      }	
   
      return set_lastkey(key);	
   }

   void init_lbuff()
   {
      int	i;
      
      _D( " init_lbuff()");
      
      for(i=0; i<=MAX_BASIC_KEYS; i++) {
         lbuff[i].key	= 0;
         lbuff[i].seq[0] = '\0';
      }
   }

   void set_lbuff(int key, char *seq)
   {
      int	i;
      
      _D( " set_lbuff()");
      
      for(i=0; i<=21; i++) {
         if (!lbuff[i].key) {
            lbuff[i].key = key;
            strncpy(lbuff[i].seq, seq, 32);
            return;
         }
      }
   }

   void cpy_lbuff()
   {
      int	i;
      
      _D( " cpy_lbuff()");
      
      for(i=0; i<=MAX_BASIC_KEYS; i++) {
         if (lbuff[i].key) 
            set_learn_key((char *)keyname(lbuff[i].key), lbuff[i].seq);
      }	
   }

   void cpy_learn2ini(aca_INI *ini) 
   {
      INI_Section	*sect;	
      ACA_BASIC_KEYS	*k;
      
      
      _D( " cpy_learn2ini()");
      
      sect = INI_section (ini, GL_term_name);
      
      for(k=basic_keys; k->curses!=0; k++) {
            if (k->learn)
            	INI_set_data(sect->data, (char *) keyname(k->curses), k->seq);
      }
   }

   int learn_key(int key)
   {
      _D( " learn_key()");
      
      get_k();
      if (GL_seq_buff[0] != '\0') {
         set_lbuff(key, GL_seq_buff);		
         return TRUE;
      }
      return FALSE;	
   }

