
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: widget_utils.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include <ctype.h>

#include "aca.h"
#include "aca_widget.h"

#include "widget_utils.h"

int get_astr_size(Widget *w)
{
	_D( "get_astr_size() ");
	
	if (w->widget_fn == menu_fn) {
		Wmenu	*m;
		m = (Wmenu *) w->widget_data;
		return m->astr_size;
	} else  if (w->widget_fn == button_fn) {
		Wbutton	*b;
		b = (Wbutton *) w->widget_data;
		return b->astr_size;
	} else if (w->widget_fn == radio_fn) {
		Wradio	*r;
		r = (Wradio *) w->widget_data;
		return r->astr_size;
	} else  if (w->widget_fn == input_fn) {
		Winput	*inp;
		inp = (Winput *) w->widget_data;
		return inp->astr_size;
	}
	return FALSE;
}

/*
	Init astr or str list  (set locale strings)
	- return max width of string in list   
*/
int init_str_list(char **list, int num, int flag, char *text_domain)
{
	char 	**p;
	int	max=0, i;
	
	_D(" init_str_list() ");
	
	for(p=list; p <= list + num; p++) {
		*p = _aca(*p);
		if (flag & M_ALIST) {
			if ((i=astrlen(*p)) > max)
				max = i; 
		} else if (flag & M_SLIST) {
			if ((i=strlen(*p)) > max)
				max = i; 
		}	
	}
	return max;	
}

void W_mvaddastr(Widget *w, int m, int n, char *astr, int c, int c2) 
{	
	_D(" W_mvaddastr()");
	
	if (!(w->flag & Wf_NOTUSE_ASTR)) { 	
		mvaddastr(m, n, astr, c, c2);	
	} else {				
		aca_c(c2);			
		mvaddstr(m, n, astr);		
	}					
}

int is_mouse_in_widget(Widget *w, SessW *s) 
{   
#ifdef HAVE_MOUSE
	Wmenu	*m;
	  
	_D(" is_mouse_in_widget()");   
	   
	if (!aca.mouse) 
   		return FALSE;
	
	/* is actual widget over widget *w ? */
	if (s->actual != w->id) {
		if ((*(s->wtab+s->actual)).widget_fn == menu_fn) {
   			if (is_mouse_in_menu(s, (s->wtab+s->actual), 
   				(Wmenu *) (*(s->wtab+s->actual)).widget_data))
   				return FALSE;
		} else if (is_mouse_in_widget((s->wtab+s->actual), s)) 
			return FALSE;
	}
   	if (w->widget_fn == menu_fn) {
   		m = (Wmenu *) w->widget_data;
   		return is_mouse_in_menu(s, w, m); 
   	} else if (aca.mouse_x >= w->x && aca.mouse_x <= w->cols+w->x &&
   	    		aca.mouse_y >= w->y && aca.mouse_y <= w->lines+w->y)
   		return TRUE;
#endif   		
   	return FALSE;	
} 
   
int widget_keys(int key, Widget *w, SessW *s) 
{		
	_D(" widget_keys()");

#ifdef HAVE_MOUSE         
         if (!(w->flag & Wf_NOTVISIBLE) && 
             ((key == K_MOUSE_L) && is_mouse_in_widget(w, s))) {
         	set_widget(s->wtab, s, w->id);
         	return TRUE;
         }	
         else 
#endif         
         if (w->hotkey && s->lock != HOTKEY_LOCK) {
            	if ((w->hotkey == key) ||             	
            	    (w->hotkey == tolower(key)) ) {
            		set_widget(s->wtab, s, w->id);
            		return TRUE;
            	}	
         }	
         return FALSE;	
}
   


