/**
 * @file Server_ORBInitializer.cpp
 *
 * Server_ORBInitializer.cpp,v 1.1 2002/11/12 02:08:02 ossama Exp
 *
 * @author Carlos O'Ryan <coryan@atdesk.com>
 */

#include "Server_ORBInitializer.h"
#include "Server_Interceptor.h"

ACE_RCSID (AMI,
           Server_ORBInitializer,
           "Server_ORBInitializer.cpp,v 1.1 2002/11/12 02:08:02 ossama Exp")

Server_ORBInitializer::Server_ORBInitializer (void)
{
}

void
Server_ORBInitializer::pre_init (
    PortableInterceptor::ORBInitInfo_ptr
    ACE_ENV_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
}

void
Server_ORBInitializer::post_init (
    PortableInterceptor::ORBInitInfo_ptr info
    ACE_ENV_ARG_DECL)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  PortableInterceptor::ServerRequestInterceptor_var interceptor(
      new Echo_Server_Request_Interceptor);

  info->add_server_request_interceptor (interceptor.in ()
                                        ACE_ENV_ARG_PARAMETER);
  ACE_CHECK;
}
