// -*- C++ -*-

//=============================================================================
/**
 *  @file LifespanStrategyTransient.h
 *
 *  LifespanStrategyTransient.h,v 1.4 2005/07/26 07:45:11 jwillemsen Exp
 *
 *  @author  Johnny Willemsen  <jwillemsen@remedy.nl>
 */
//=============================================================================

#ifndef TAO_LIFESPANSTRATEGYTRANSIENT_H
#define TAO_LIFESPANSTRATEGYTRANSIENT_H
#include /**/ "ace/pre.h"

#include "LifespanStrategy.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "Creation_Time.h"
#include "tao/Object_KeyC.h"

namespace TAO
{
  namespace Portable_Server
  {
    class LifespanStrategyTransient
      : public LifespanStrategy
    {
    public:
      LifespanStrategyTransient (void);

      virtual void notify_startup (ACE_ENV_SINGLE_ARG_DECL);

      virtual void notify_shutdown (ACE_ENV_SINGLE_ARG_DECL);

      char key_type (void) const;

      virtual CORBA::Boolean is_persistent (void) const;

      CORBA::ULong key_length (void) const;

      virtual void create_key (CORBA::Octet *buffer, CORBA::ULong& starting_at);

      virtual
      bool validate (CORBA::Boolean is_persistent,
                     const TAO::Portable_Server::Temporary_Creation_Time& creation_time) const;

      /// Check the state of the POA.
      virtual void check_state (ACE_ENV_SINGLE_ARG_DECL);

      virtual ::PortableServer::LifespanPolicyValue type() const;

      virtual bool use_imr () const;

    private:
      TAO::Portable_Server::Creation_Time creation_time_;
    };
  } /* namespace Portable_Server */
} /* namespace TAO */

#include /**/ "ace/post.h"
#endif /* TAO_LIFESPANSTRATEGYTRANSIENT_H */
