(in-package "ACL2")

(local (include-book "expt"))
(local (include-book "expt2"))
(local (include-book "expo2"))
(local (include-book "predicate"))
(local (include-book "integerp"))

;(include-book "expo")

(DEFUN BVECP (X K)
  (AND (INTEGERP X)
       (>= X 0)
       (< X (EXPT 2 K))))

(in-theory (disable bvecp))

(defthm bvecp-with-n-not-a-positive-integer
  (implies (or (not (integerp n))
               (<= n 0))
           (equal (bvecp x n)
                  (equal 0 x)))
  :hints (("Goal" :cases ((< x 1))
:in-theory (enable bvecp))))

(defthm bvecp-0
  (bvecp 0 k)
  :hints (("Goal" :in-theory (enable bvecp))))

(defthm bvecp-ones
  (implies (case-split (<= 0 n))
           (BVECP (+ -1 (EXPT 2 N)) N))
    :hints (("Goal" :in-theory (enable bvecp))))

(encapsulate
 ()
;k1 is a free var
 (local (defthm bvecp-longer-aux
          (implies (and (bvecp x k1)
                        (<= k1 k2)
                        (case-split (integerp k1))
                        (case-split (integerp k2))
                        )
                   (bvecp x k2))
          :hints (("Goal" :use (:instance expt-compare (lhs (expt 2 k1)) (rhs (expt 2 k2)))
                   :in-theory (set-difference-theories
                               (enable bvecp)
                               '(EXPT-COMPARE))
                   ))))
;k1 is a free var
 (defthm bvecp-longer
   (implies (and (bvecp x k1)
                 (<= k1 k2)
                 (case-split (integerp k2))
                 )
            (bvecp x k2))
   :hints (("Goal" :cases ((integerp k1)))))
 )

;expensive?
;disable?
;no free var
(defthm bvecp-one-longer
  (implies (and (integerp k)
                (bvecp x (- k 1)))
           (bvecp x k))
  :hints (("Goal" :in-theory (disable bvecp-longer)
           :use ((:instance bvecp-longer (k2 k) (k1 (- k 1))))))
  :rule-classes ((:rewrite :backchain-limit-lst (nil 2))))
(in-theory (disable bvecp-one-longer))

(defthm bvecp-of-non-integer
  (implies (not (integerp x))
           (not (bvecp x n)))
    :hints (("Goal" :in-theory (enable bvecp))))

