#!/bin/sh
#
# RAMS/Overkill System for Regression Testing
#
# File: make/Makefile-overkill.bash - This script calls upon Overkill to do a 
# parallel pcert of a SINGLE library.  It is called from Makefile.top when a 
# user types "make overkill".

readonly SCRIPT="Makefile-overkill.bash"
readonly MYDIR=`pwd -P`
source $MAKEDIR/Makefile-checks.bash
source $MAKEDIR/Overkill-support.bash

Debug "Starting overkill script."

Debug "Checking overkill executable"
CheckOverkill

Debug "Clearing out .okill directory"
rm -rf "$MYDIR/.okill"
mkdir "$MYDIR/.okill"

Debug "Computing $MYDIR/.okill/README"
echo "README FILE for $MYDIR/.okill

This directory is used by Overkill to store work files and output logs from
pcertification attempts.  Once Overkill has finished running, you can feel free
to delete anything in this directory (Indeed, \"make clean\" will remove the
entire .okill directory for you).

You might find the files here useful if you ever encounter trouble with the
Overkill system.  Each \".work\" file contains a series of commands that some
host will be instructed to execute in order to create a pcert file for the
corresponding book.  Each \".log\" file contains the output of the make
command, in case it is useful for you.

Of course, the output of each \"make foo.pcert\" command is stored in the
corresponding \"foo.pout\" file, in your project's directory, so if you want to
examine why, say, your book could not be successfully \"pcertified\", then you
should look there first.  

Good luck!
" > "$MYDIR/.okill/README"


Debug "Computing $MYDIR/.okill/COMMANDS and work files"
IFS=" "
for book in $BOOKS
do

echo "#!/bin/sh
# File: $MYDIR/.okill/$book.work
# This file is automatically generated.  Do not hand edit.

# We simply attempt to make $book.pcert.  We skip the dependency calculation
# and assume that the dependencies are current.  We will write the output of
# our make commands to the file $book.olog.
cd \"$MYDIR\"
make -q $book.pcert
if [[ \"\$?\" == \"1\" ]]
then
    export SKIPDEPS=1 DEBUG=1; \\
        make $book.pcert 2>&1 >> \"$MYDIR/.okill/$book.log\"
else
    echo \"Current: $MYDIR/$book (\$HOSTNAME)\" >> \"$HOME/.overkill-results\"
fi
 " >> "$MYDIR/.okill/$book.work"

echo "sh \"$MYDIR/.okill/$book.work\"" >> "$MYDIR/.okill/COMMANDS"
done

Debug "Ready to launch overkill in `pwd`"