# Base of analysis phase classes.
#
# Author::    Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>
# Copyright:: Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
# License::   GPLv3+: GNU General Public License version 3 or later
#
# Owner::     Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>

#--
#     ___    ____  __    ___   _________
#    /   |  / _  |/ /   / / | / /__  __/           Source Code Static Analyzer
#   / /| | / / / / /   / /  |/ /  / /                   AdLint - Advanced Lint
#  / __  |/ /_/ / /___/ / /|  /  / /
# /_/  |_|_____/_____/_/_/ |_/  /_/   Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
#
# This file is part of AdLint.
#
# AdLint is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# AdLint is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# AdLint.  If not, see <http://www.gnu.org/licenses/>.
#
#++

require "adlint/error"
require "adlint/report"
require "adlint/monitor"

module AdLint #:nodoc:

  # == DESCRIPTION
  # Base of analysis phase classes.
  class Phase
    include MonitorUtil

    # === DESCRIPTION
    # Constructs an analysis pass.
    #
    # === PARAMETER
    # _context_:: PhaseContext -- Analysis context.
    def initialize(context)
      @context = context
    end

    # === DESCRIPTION
    # Executes the analysis.
    def execute
      do_execute(@context)
    rescue Error => ex
      @context.report.add_message(Message.from_exception(ex))
      raise
    end

    private
    # === DESCRIPTION
    # Executes the analysis.
    #
    # Subclasses must implement this method.
    def do_execute(context)
      subclass_responsibility
    end
  end

  class PhaseContext < Hash
    def initialize(report, log_fpath)
      super()
      @report = report
      @log_fpath = log_fpath
    end

    attr_reader :report
    attr_reader :log_fpath

    def msg_fpath
      @report.msg_fpath
    end

    def met_fpath
      @report.met_fpath
    end
  end

end
