/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-23 11:06:55 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _SIMPLE_LIST_HANDLER_
#define _SIMPLE_LIST_HANDLER_

#include "AdunKernel/AdunEnvironment.h"
#include "AdunKernel/AdunMemoryManager.h"
#include "AdunKernel/AdunNonBondedListHandler.h"

/**
SimpleListHandler encapsulates the simplest algorithm for
creating the nonbonded list. Its is impratical for any moderatly
size system but is useful for checking the function of more
complicated handlers.
\ingroup inter
\todo Implement correct handling of createLists. Currenlty this
can only be called once.
*/

@interface SimpleListHandler: AdNonBondedListHandler
{
	ListElement* in_p;
	ListElement* out_p;
	ListElement* endin_p;
	ListElement* endout_p;
	double cutoff;
	int numberOfInteractions;
	AdMatrix *coordinates;
	NSArray* interactions;
	InterTable* parameters;
	id memoryManager;
}
@end

#endif
