/*
   Project: Adun

   Copyright (C) 2006 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-02 15:34:11 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#include "AdunKernel/AdunDataSet.h"

/**
We also need the class of each object that generated the data so we can
search the correct table.

*/

@implementation AdDataSet

- (id) init
{
	return [self initWithName: @"None"];
}

- (id) initWithName: (NSString*) aString
{
	return [self initWithName: aString
			inputReferences: nil];
}

-(id) initWithName: (NSString*) aString inputReferences: (NSDictionary*) aDict;
{
	return [self initWithName: aString
		inputReferences: aDict
		dataGeneratorName: @"Unknown"
		dataGeneratorVersion: @"1.0"];
}

- (id) initWithName: (NSString*) aString 
	inputReferences: (NSDictionary*) aDict 
	dataGenerator: (NSBundle*) aBundle 
{
	NSString* generatorName;
	NSString *version;

	version = [[aBundle infoDictionary] objectForKey: @"PluginVersion"];
	generatorName = [aBundle bundleIdentifier];

	return [self initWithName: aString 
		inputReferences: aDict 
		dataGeneratorName: generatorName 
		dataGeneratorVersion: version];
}

- (id) initWithName: (NSString*) stringOne 
	inputReferences: (NSDictionary*) aDict 
	dataGeneratorName: (NSString*) stringTwo
	dataGeneratorVersion: (NSString*) aNumber
{
	if(self = [super init])
	{
		if(stringOne != nil)
			[metadata setObject: stringOne forKey: @"Name"];

		[inputReferences addEntriesFromDictionary: aDict];

		if(stringTwo != nil)
			[generaldata setObject: stringTwo 
				forKey: @"dataGeneratorName"];
		else
			[generaldata setObject: @"Unknown" 
				forKey: @"dataGeneratorName"];
		
		//FIXME: Possible gnustep bug. 	When encoding aNumber if it
		//was originaly read from a propertyList file (most likely)
		//then it doesnt decode properly.
		//By creating a new string from it it works.
		//Should be invesitagted further.
		
		if(aNumber == nil)
			aNumber = @"1.0";
		
		[generaldata setObject: [NSString stringWithString: aNumber]
				forKey: @"dataGeneratorVersion"];

		dataMatrices = [NSMutableArray new];

		dataGeneratorID = [NSString stringWithFormat: @"%@_%@",
					[generaldata objectForKey: @"dataGeneratorName"],
					aNumber];
		[dataGeneratorID retain];			

	}

	return self;
}

- (void) dealloc
{
	[dataGeneratorID release];
	[dataMatrices release];
	[super dealloc];
}

- (void) addDataMatrix: (AdDataMatrix*) aDataMatrix
{
	if(aDataMatrix != nil)
		[dataMatrices addObject: aDataMatrix];
}

- (void) removeDataMatrix: (AdDataMatrix*) aDataMatrix
{
	if(aDataMatrix != nil)
		[dataMatrices removeObject: aDataMatrix];
}

- (void) removeDataMatrixWithName: (NSString*) aString
{
	id dataMatrix;

	dataMatrix = [self dataMatrixWithName: aString];
	if(dataMatrix != nil)
		[dataMatrices removeObject: dataMatrix];
}

- (NSArray*) dataMatrices
{
	return [[dataMatrices copy] autorelease];
}

- (AdDataMatrix*) dataMatrixWithName: (NSString*) aString
{
	NSEnumerator* dataMatrixEnum = [dataMatrices objectEnumerator];
	id dataMatrix;
	
	if(aString == nil)
		return nil;
	
	dataMatrix = nil;
	while(dataMatrix = [dataMatrixEnum nextObject])
	{
		if([[dataMatrix name] isEqual: aString])
			break;
	}

	return dataMatrix;
}

- (NSString*) dataGeneratorID
{
	return dataGeneratorID;
}

- (NSString*) dataGeneratorName
{
	return [generaldata objectForKey: @"dataGeneratorName"];
}

- (void) setDataGeneratorName: (NSString*) aString
{
	id dataGeneratorName;

	dataGeneratorName = [generaldata objectForKey: @"dataGeneratorName"];
	if(aString != dataGeneratorName)
		[generaldata setObject: aString forKey: @"dataGeneratorName"];
}

- (double) dataGeneratorVersion
{
	return [[generaldata objectForKey: @"dataGeneratorVersion"] doubleValue];	
}

- (void) setDataGeneratorVersion: (double) aNumber
{
	[generaldata setObject: [NSNumber numberWithDouble: aNumber] 
		forKey: @"dataGeneratorVersion"];
}


//Coding

- (id) initWithCoder: (NSCoder*) decoder
{
	if(self = [super initWithCoder: decoder])
	{
		if([decoder allowsKeyedCoding])
		{
			dataGeneratorID = [decoder decodeObjectForKey: @"dataGeneratorID"];
			dataMatrices = [decoder decodeObjectForKey: @"dataMatrices"];

		}
		else
		{
			dataGeneratorID = [decoder decodeObject];
			dataMatrices = [decoder decodeObject];
		}
		
		[dataGeneratorID retain];
		[dataMatrices retain];
	}

	return self;
}

- (void) encodeWithCoder: (NSCoder*) encoder
{
	[super encodeWithCoder: encoder];
	
	if([encoder allowsKeyedCoding])
	{
		[encoder encodeObject: dataGeneratorID forKey: @"dataGeneratorID"];
		[encoder encodeObject: dataMatrices forKey: @"dataMatrices"];
	}
	else
	{
		[encoder encodeObject: dataGeneratorID];
		[encoder encodeObject: dataMatrices];
	}
}

@end
