/*
   Project: Adun

   Copyright (C) 2006 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ADUN_CONTROLLER_
#define _ADUN_CONTROLLER_

#include "AdunKernel/AdunCore.h"
#include "AdunKernel/AdunSimulator.h"
#include "AdunKernel/AdunForceFieldManager.h"
#include "AdunKernel/AdunForceField.h"
#include "AdunKernel/AdunSystem.h"
#include "AdunKernel/AdunSystemNode.h"
#include "AdunKernel/AdController.h"


/**
\ingroup Interfaces
AdController is a simple implementation of a controller and hence
the AdController protocol. It is intended to be a base class for 
other controllers and provides most of the necessary threading functionality
to its subclasses. As a controller it simply calls [simulator production]
to generate a normal trajectory.

<b>Subclassing</b>

Subclasses should override (where necessary)
all of AdControllers methods except for runThreadedSimulation and simulationFinished. 
These methods handle creation of the controller thread and its termination
so subclasses don't have to worry about it.

However in some cases it may be necessary to provide a custom thread creation/termination
solution. In this case it is recommended that you implement a complete
new class based on the AdController protocol.
*/


@interface AdController: NSObject <AdController>
{
	BOOL notifyCore;
	NSConnection* threadConnection; //!< For communicating between the threads
	NSError* controllerError;	//!< For reporting errors in the simulation
	id simulator;			//!< The simulator
}

/**
This method is used by the subthread to notify the main thread controller
that it has finished. It is for internal use only and should not be called
by other objects.
*/
- (void) simulationFinished;
@end

#endif
