/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-05-23 14:11:40 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULSYSTEM_H_
#define _ULSYSTEM_H_

#include <Foundation/Foundation.h>
#include <AdunKernel/AdunModelObject.h>
#include "ULMatrix.h"
#include "ULIndexSetConversions.h"
#include "AdunKernel/RemoteProcessAccess.h"

/**
ULSystem instances represent simulation systems.
It conforms to NSCoding so it can be archived and
transmitted.

\note It is likely that ULSystem will be deprecated in favour
of using AdDataSource directly since they both contain the
same information and can be archived and only differ in their interfaces.
Also this will eliminate the ULSystem->AdDataSource conversion step
aswell as the need to create a AdDataSource->ULSystem conversion if
we wanted to use "Analyse System" on a trajectory.

\ingroup model

\todo Add validators for configuration and topology keys
*/

@interface ULSystem : AdModelObject <RemoteSystemAccess>
{
	NSMutableDictionary* configuration;	//!< See ULConfigurationBuilder for the dictionary format
	NSMutableDictionary* topology;		//!< See UlTopologyFrameBuilder for the dictionary format
}

@end

#endif // _ULSYSTEM_H_

