/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#include <AppKit/AppKit.h>

/**
Handles the preference panel

\ingroup interface
*/

@interface ULPreferences : NSObject
{
	id coreTraceMemory;
	id coreOutputMemoryStatistics;
	id coreRedirectOutput;
	id coreDebugLevels;
	id ulPDBDirectory;
	id ulTheme;
	id ulDebugLevels;
	id preferencesWindow;
	id preferencesTabView;
	id viewController;
	NSMutableDictionary* coreDict;
	NSMutableDictionary* ulDict;
	NSUserDefaults* defaults;
}
- (id) initWithModelViewController: (id) object;
- (void) showPreferences: (id) sender;
- (void) setDefault: (id) sender;
- (void) updateDefaults: (id) sender;
@end
