#ifndef _ADBERENDSENTHERMOSTAT_
#define _ADBERENDSENTHERMOSTAT_
#include "AdunKernel/AdunSimulator.h"

/**
\ingroup Inter
AdBerendenThermostat objects are simulator components that control the simulation temperature 
by scaling the velocities of the systems being integrated.

The scaling is applied on receipt of simulatorDidPerformSecondVelocityUpdateForSystem:().
*/
@interface AdBerendsenThermostat: NSObject <AdSimulatorComponent>
{
	double targetTemperature;
	double timeStep;
	double couplingFactor;
	double timePerCouplingFactor;
}
/**
As initWithTargetTemperature:couplingFactor: with
a target temperature of 300 and a coupling factor of 100
*/
- (id) init;
/**
Designated initialiser.
\param doubleOne The target temperature for the thermostat.
\param doubleTwo The coupling factor for the thermostat.
*/
- (id) initWithTargetTemperature: (double) doubleOne
	couplingFactor: (double) doubleTwo;
/**
Sets the target temperature for the thermostat to \e aDouble.
If \e aDouble is less than 0 an NSInvalidArgumentException is raised.
*/
- (void) setTargetTemperature: (double) aDouble;
/**
Returns the target temperature
*/
- (double) targetTemperature;
/**
Sets the coupling factor. The same coupling factor
is used for all systems.
*/
- (void) setCouplingFactor: (double) aDouble;
/**
Returns the coupling factor.
*/
- (double) couplingFactor;
@end

#endif
