
# ----------------------------------------------------------
# advas
# advanced search algorithms implemented as a python class
#
# (C) 2003 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
#
# example for using the successor variety stemmer
#
# ----------------------------------------------------------

# changed 2003-05-02

# import advas class
from advas_oo import Advas

# a line of text
line = "footnote, footpath, footman, footing, footie, foothold, footprint, footmark, footstep, footwork, footer, footage, football, footballer, footlights, footrest, footwear, footstool, foot, foreign, foreigner, foreleg, forelock, foreman, foremost, forename, forenoon, forensic, foresee, foreseeable, forest, forestry, forever, forge, forger, forgery, forget, forgot"
print "text: " + line + "\n"

# use this word
term = "homework"

# create object - keep standard options
a = Advas()
a.set_line(line)
a.split_line()
print 'version 1:\nused dictionary: word list\n'
# calc successor variety for the list of words
result1 = a.calc_succ_variety ()

# use a file as word_list
file_name = "/usr/share/dict/words"

b = Advas()
b.set_filename(file_name)
b.set_use_filename()
print '\nversion 2:\nused dictionary: %s (45.000 words)\n' % file_name
result2 = b.calc_succ_variety ()

for i in term:
	print '%s : %3d %3d' % (i, result1[i], result2[i])	
# end for

# try stemming
c = Advas()
c.set_line(line)
c.split_line()
words = c.get_words()
result3 = c.successor_variety_stemmer (term, words, 0)
print "version 3:\nused dictionary: wordlist"
print result3

print '\nversion 4:\nused dictionary: %s (45.000 words)\n' % file_name
result4 = b.successor_variety_stemmer (term, file_name, 1)
print result4
