/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __VGROUP__
#define __VGROUP__

#include <qstring.h>
#include <qstringlist.h>

/**
 *	VGroup
 *  @short implements the group structure
 */
class VGroup
{
	QStringList members;
	QString groupName;
public:
	/**
	 * the default constructor
	 * @param groupLine a group definition has the following topology:
	 *  groupName: address1, address2 ...
	 * everything on the same line. For building a group structure, a line 
	 * with this structure has to be provided.
	 */
	VGroup(QString groupLine=QString::null);
	/**
	 *	This method is provided for changing the group's name (by the user)
	 * @param newName the new group name
	 */
	void changeGroupName(QString newName=QString::null);
	/**
	 *	This method is provided for erasing one address from the list
	 * @param address the address we want to delete.
	 * if the address is QString::null, then all the list is cleared.
	 */
	void eraseAddress(QString address=QString::null);
	/**
	 *	This method is provided for erasing one address from the list
	 * @param address the address' index we want to delete.
	 */
	void eraseAddress(int address);
	/**
	 *	Adds one address to the list. First checks for the address' presence.
	 * @param address the new address to be added to the list.
	 */
	void addAddress(QString address);
	/**
	 * Returns the list of addresses in a comma-separated string.
	 */
	QString getCommaList();
	/**
	 * Returns the addresses as a QStringList.
	 */
	QStringList getAddressList();
	/**
	 * returns the group name
	 */
	QString getGroupName();
	#define Name	getGroupName
	/**
	 *  used for recomposing the original string
	 */
	QString recompose();
};

#endif











