/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <qdir.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <kconfig.h>
#include <qdict.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qheader.h>

#include <pixlibrary.h>

#include <accountsconfigbase.h>
#include <accountsconfig.h>

#include <imap4wizard.h>
#include <pop3wizard.h>
#include <editaccountdialog.h>

extern KConfig *GlobalConfig;

#define IDSTRING "AccountsConfig: "

AccountsConfig::AccountsConfig(QWidget *parent, const char *name=0) : AccountsConfigBase(parent, name)
{
	accountsList->header()->hide();
	accountsList->setAllColumnsShowFocus(true);
	accountsDict.setAutoDelete(true);
	load();
}

void AccountsConfig::load()
{
	GlobalConfig->setGroup("Receive Options");
	QStrList accounts;
	if( GlobalConfig->readListEntry("Accounts", accounts) )
	{
  	defaultAccount=GlobalConfig->readEntry("Default");
  	for(QStrListIterator itAcc(accounts); itAcc.current(); ++itAcc)
  	{
  		AccountsConfig::Account *a=new AccountsConfig::Account();
  		a->accountName=(*itAcc);
  		GlobalConfig->setGroup(QString("Account ")+a->accountName);
  		
  		a->enabled=(GlobalConfig->readEntry("Enabled")=="Yes");
  		a->leaveOnServer=(GlobalConfig->readEntry("Leave on server")=="Yes");
  		a->rememberPasswd=(GlobalConfig->readEntry("Remember password")=="Yes");
  		a->sort=(GlobalConfig->readEntry("Sorted")=="Yes");
  		a->sync=(GlobalConfig->readEntry("Sync")=="Yes");
  		a->name=GlobalConfig->readEntry("Name");
  		a->from=GlobalConfig->readEntry("From");
  		a->replyTo=GlobalConfig->readEntry("Reply to");
  		a->org=GlobalConfig->readEntry("Organization");
  		a->passwd=GlobalConfig->readEntry("Password");
  		a->Server=GlobalConfig->readEntry("Server");
  		a->SMTPServer=GlobalConfig->readEntry("Smtp");
  		a->type=GlobalConfig->readEntry("Type");
  		a->user=GlobalConfig->readEntry("User");

  		a->persistence=GlobalConfig->readNumEntry("Persistence");
  		a->port=GlobalConfig->readNumEntry("Port");
  		a->SMTPport=GlobalConfig->readNumEntry("SPort");
  		// the new stuff
  		if(GlobalConfig->hasKey("Speed"))
  			a->speed=GlobalConfig->readEntry("Speed");
  		else
  			a->speed="Normal";
  		if(GlobalConfig->hasKey("Max size"))
  			a->maxSize=GlobalConfig->readNumEntry("Max size");
  		else
  			a->maxSize=0;
  		if(GlobalConfig->hasKey("Max action"))
  			a->maxAction=GlobalConfig->readEntry("Max action");
  		else
  			a->maxAction="Ignore";
  		
  		
  		accountsDict.insert((*itAcc),a);
  		QListViewItem *it=new QListViewItem(accountsList);
  		if(a->enabled)
  			it->setPixmap(0,PixLibrary::thisInstance()->pixmap(PixLibrary::BlankIcon));
  		else
  			it->setPixmap(0,PixLibrary::thisInstance()->pixmap(PixLibrary::CancelIcon));
  		if(a->accountName==defaultAccount)
  		{
  			defaultItem=it;
  			it->setPixmap(1,PixLibrary::thisInstance()->pixmap(PixLibrary::OkIcon));
  		}
  		else
  		{
  			it->setPixmap(1,PixLibrary::thisInstance()->pixmap(PixLibrary::BlankIcon));
  		}
  		it->setText(2,a->accountName);
  		it->setText(3,QString("(") + a->type + ")");
  	}
	}
}
void AccountsConfig::sync(bool visible=false)
{
	bool doSync=(!visible && isVisible()) | (visible);
	if(!doSync)
		return;
		
	QDictIterator<AccountsConfig::Account> it(accountsDict);
	AccountsConfig::Account *a;
	QStringList accList;
	QString t;
	while(it.current())
	{
		printf("Writing [%s]...\n", (const char *)it.currentKey());
		a=it.current();
		GlobalConfig->setGroup(QString("Account ") + it.currentKey());
		accList.append(it.currentKey());
		GlobalConfig->writeEntry("Enabled", ((a->enabled)?"Yes":"No"));
		GlobalConfig->writeEntry("Leave on server", ((a->leaveOnServer)?"Yes":"No"));
		GlobalConfig->writeEntry("Remember password", ((a->rememberPasswd)?"Yes":"No"));
		GlobalConfig->writeEntry("Sorted", ((a->sort)?"Yes":"No"));
		GlobalConfig->writeEntry("Sync", ((a->sync)?"Yes":"No"));
		GlobalConfig->writeEntry("Name", a->name);
		GlobalConfig->writeEntry("From", a->from);
		GlobalConfig->writeEntry("Reply to", a->replyTo);
		GlobalConfig->writeEntry("Organization", a->org);
		GlobalConfig->writeEntry("Password", a->passwd);
		GlobalConfig->writeEntry("Server", a->Server);
		GlobalConfig->writeEntry("Smtp", a->SMTPServer);
		GlobalConfig->writeEntry("Type", a->type);
		GlobalConfig->writeEntry("User", a->user);
		GlobalConfig->writeEntry("Persistence", t.sprintf("%d",a->persistence));
		GlobalConfig->writeEntry("Port", t.sprintf("%d",a->port));
		GlobalConfig->writeEntry("SPort", t.sprintf("%d",a->SMTPport));
		GlobalConfig->writeEntry("Speed", a->speed);
		GlobalConfig->writeEntry("Max size", t.sprintf("%d",a->maxSize));
		GlobalConfig->writeEntry("Max action", a->maxAction);
		if( (*it).type=="IMAP4" )
		{
		  QString IMAPfolder=it.currentKey();
		
			// create an extra VFS folder
			GlobalConfig->setGroup("VFS /Magellan/Mail");
	    QStringList mainFolders=GlobalConfig->readListEntry("Subfolders", ',');
	    if( -1==mainFolders.findIndex( QString("/Magellan/Mail/")+IMAPfolder ) )
	    {
	      mainFolders.append( QString("/Magellan/Mail/")+IMAPfolder );
	      GlobalConfig->writeEntry("Subfolders", mainFolders, ',');
	
  			GlobalConfig->writeEntry("Flags", "c");
  			
  			GlobalConfig->setGroup("VFS /Magellan/Mail/"+IMAPfolder);
  			GlobalConfig->writeEntry("Binding", "thisInstance");
  			GlobalConfig->writeEntry("Type", "imap");
  			GlobalConfig->writeEntry("Flags", "c");
  	    GlobalConfig->writeEntry("MIME type", "");
  	    GlobalConfig->writeEntry("View type", "genmail");
  	
  	    // create the default INBOX folder
  	    QString serverPath=QString("imap_")+IMAPfolder;
  	    QString inboxFolder=QString("/Magellan/Mail/")+IMAPfolder+QString("/Inbox");
  			GlobalConfig->writeEntry("Subfolders", inboxFolder);
  			// the default IMAP mailbox - INBOX
      	GlobalConfig->setGroup("VFS "+inboxFolder);
      	GlobalConfig->writeEntry("Binding", "thisInstance");
      	GlobalConfig->writeEntry("Server Path", serverPath);
      	GlobalConfig->writeEntry("Type", "imap");
      	GlobalConfig->writeEntry("Flags", "c");
      	GlobalConfig->writeEntry("View type", "mail");
      	GlobalConfig->writeEntry("MIME type", "text/rfc822");
      	
      	if(!serverPath.isEmpty() && !inboxFolder.isEmpty())
      	{
        	GlobalConfig->setGroup("Directory");
        	QString aetheraPath=GlobalConfig->readEntry("AetheraDir");
  		    QDir top(aetheraPath);
  		
      		// create an extra IMAP folder
      		top.mkdir(serverPath);
      		// create the IMAP config file
         	GlobalConfig->setGroup("VFS "+inboxFolder);
          QFile f( aetheraPath+"/"+serverPath+"/"+"config" );
          f.open( IO_WriteOnly );
          QDataStream s( &f );
          s << IMAPfolder;
          s << QString("INBOX");
          f.close();
      	}
	    }
	
		}
		++it;
	}
	GlobalConfig->setGroup("Receive Options");
	GlobalConfig->writeEntry("Accounts", accList.join(","));
	GlobalConfig->writeEntry("Default", defaultAccount);
	emit(noChanged());
}

void AccountsConfig::addIMAP4Clicked()
{
	AccountsConfig::Account *a=new AccountsConfig::Account;
	IMAP4Wizard *wizard= new IMAP4Wizard(a, this);
	wizard->show();
	if(a->SMTPServer.isEmpty())
	{
		delete a;
	}
	else
	{
		accountsDict.insert(a->accountName, a);
		populateList(a->accountName);
	}
	emit(changed());
}

void AccountsConfig::addPOP3Clicked()
{
	AccountsConfig::Account *a=new AccountsConfig::Account;
	Pop3Wizard *p3w= new Pop3Wizard(a, this);
	p3w->show();
	printf(" SMTP server: [%s]\n", (const char *)a->SMTPServer);
	if(a->SMTPServer.isEmpty())
	{
		delete a;
	}
	else
	{
		accountsDict.insert(a->accountName, a);
		populateList(a->accountName);
	}
	emit(changed());
}

void AccountsConfig::editClicked()
{
	if(!accountsList->currentItem())
		return;
	AccountsConfig::Account *a=accountsDict[accountsList->currentItem()->text(2)];
	if(!a)
	{
		printf("*FATAL* Accounts list management is buggy. Please report to tevelopers. (Edit)\n");
		return;
	}
	bool isDefault= a->accountName==defaultAccount;
	AccountsConfig::Account tempAcc;
	tempAcc=*a;
	EditAccountDialog *ad=new EditAccountDialog(&tempAcc, this);
	ad->show();
	// test if CANCEL has been pressed
	if(tempAcc.SMTPServer==QString::null)
	{
		printf(IDSTRING "Cancel\n");
		return;
	}
	QString name=a->accountName;
	accountsDict.remove(name);
	a=new Account;
	*a=tempAcc;
	accountsDict.insert(a->accountName,a);
	populateList(a->accountName);
	if(isDefault)
		defaultAccount=a->accountName;
	emit(changed());
}

void AccountsConfig::editView(QListViewItem *)
{
	editClicked();
//	emit(changed());
}

void AccountsConfig::enableClicked()
{
	if(!accountsList->currentItem())
		return;
	AccountsConfig::Account *a=accountsDict[accountsList->currentItem()->text(2)];
	if(!a)
	{
		printf("*FATAL* Accounts list management is buggy. Please report to tevelopers. (Enable)\n");
		return;
	}
	a->enabled=!a->enabled;
	populateList(a->accountName);
	emit(changed());
}

void AccountsConfig::removeClicked()
{
	if(!accountsList->currentItem())
		return;
	AccountsConfig::Account *a=accountsDict[accountsList->currentItem()->text(2)];
	if(!a)
	{
		printf("*FATAL* Accounts list management is buggy. Please report to tevelopers. (remove)\n");
		return;
	}
	bool isDefault=a->accountName==defaultAccount;
	accountsDict.remove(a->accountName);
	populateList();
	if(isDefault && accountsList->firstChild())
	{
		defaultAccount=accountsList->firstChild()->text(2);
	}
	else
		defaultAccount="";
	emit(changed());
}

void AccountsConfig::setDefaultClicked()
{
	if(!accountsList->currentItem())
		return;
	AccountsConfig::Account *a=accountsDict[accountsList->currentItem()->text(2)];
	if(!a)
	{
		printf("*FATAL* Accounts list management is buggy. Please report to tevelopers. (setDefault)\n");
		return;
	}
	defaultAccount=a->accountName;
	populateList(defaultAccount);
	emit(changed());
}

void AccountsConfig::enableButtons()
{
}

void AccountsConfig::populateList(QString focused)
{
	accountsList->clear();
	QDictIterator<Account> it(accountsDict);
	Account *a;
	while((a=it.current())!=0)
	{
		QListViewItem *item=new QListViewItem(accountsList);
		if(focused==a->accountName)
			accountsList->setSelected(item, true);
		if(a->enabled)
			item->setPixmap(0,PixLibrary::thisInstance()->pixmap(PixLibrary::BlankIcon));
		else
			item->setPixmap(0,PixLibrary::thisInstance()->pixmap(PixLibrary::CancelIcon));
		if(a->accountName==defaultAccount)
		{
			defaultItem=item;
			item->setPixmap(1,PixLibrary::thisInstance()->pixmap(PixLibrary::OkIcon));
		}
		else
		{
			item->setPixmap(1,PixLibrary::thisInstance()->pixmap(PixLibrary::BlankIcon));
		}
		item->setText(2,a->accountName);
		item->setText(3,QString("(") + a->type + ")");
		++it;
	}
}






