#ifndef IMAP4WIZARD_H
#define IMAP4WIZARD_H

#include <imap4wizardbase.h>
#include <accountsconfig.h>

class IMAP4Wizard : public IMAP4WizardBase
{
	Q_OBJECT
	public:
		IMAP4Wizard(AccountsConfig::Account *a, QWidget *parent, const char *name=0);
	public slots:
    virtual void emailChanged(const QString &);
    virtual void leaveClicked();
    virtual void nameChanged(const QString &);
    virtual void smtpPortChanged(const QString &);
    virtual void passChanged(const QString &);
    virtual void passClicked();
    virtual void imap4Changed(const QString &);
    virtual void imap4PortChanged(const QString &);
    virtual void replyChanged(const QString &);
    virtual void smtpChanged(const QString &);
    virtual void userChanged(const QString &);
		
    virtual void accountNameChanged(const QString &);
    virtual void sortClicked();
    virtual void syncClicked();
		
	protected slots:
		void accept();
		void reject();
	protected:
		AccountsConfig::Account *element;
};

#endif


