/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <qstring.h>
#include <qfont.h>
#include <qsize.h>
#include <qstring.h>
//widgets used
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qfontdialog.h>
#include <kconfig.h>
#include <notesconfig.h>
#include <miscfunctions.h>

extern KConfig *GlobalConfig;

NotesConfig::NotesConfig(QWidget *parent, const char *name) : NotesConfigBase(parent, name)
{
	// load the values from the config file
	load();
}

void NotesConfig::load()
{
	QString str;
	QSize size;
	QFont font;
	GlobalConfig->setGroup("Notes");
	_color=str=GlobalConfig->readEntry("Default color");
	// set the color (with the function from miscfunctions.cpp)
	updateComboBox(colorsBox, str, false);
	font=GlobalConfig->readFontEntry("Default font");
	fontButton->setFont(font);
	fontButton->setText(font.family()+ " - " + str.sprintf("%dpt",font.pointSize()));
	size=GlobalConfig->readSizeEntry("Default size");
	xEdit->setText(str.sprintf("%d",size.width()));
	yEdit->setText(str.sprintf("%d",size.height()));
}

void NotesConfig::colorChanged(const QString &str)
{
	_color=str;
	emit(changed());
}

void NotesConfig::fontButtonClicked()
{
	bool ok;
	QFont f;
	QString str;
	
	f=QFontDialog::getFont(&ok, _font, this);
	if(ok)
	{
		_font=f;
		fontButton->setFont(_font);
		fontButton->setText(_font.family()+ " - " + str.sprintf("%dpt",_font.pointSize()));
		emit(changed());
	}
}

void NotesConfig::sync(bool visible)
{
	bool doSync=(!visible && isVisible()) | (visible);
	if(doSync)
	{
		GlobalConfig->setGroup("Notes");
		GlobalConfig->writeEntry("Default color",_color.lower());
		GlobalConfig->writeEntry("Default font",_font);
		GlobalConfig->writeEntry("Default size", QSize(_x, _y));
		emit(noChanged());
	}
}

void NotesConfig::xCoordChanged(const QString &str)
{
	_x=str.toInt();
	if(_x<150)
		_x=150;
	emit(changed());
}

void NotesConfig::yCoordChanged(const QString &str)
{
	_y=str.toInt();
	if(_y<150)
		_y=150;
	emit(changed());
}
