/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __MailObject__
#define __MailObject__

#include <clientvfs.h>
#include <vobject.h>
#include <qstring.h>
#include <qcolor.h>
#include <dateclass.h>
#include <addressclass.h>
#include <addresslistclass.h>

class MailObject : public VObject
{
	friend class ClientVFS;
	protected:
		MailObject(QString _path, QByteArray &_data);
		MailObject(QString _path);
	public:
		/**
		 * properties
		 */
			
		AddressClass from();
		void setFrom(const AddressClass &newFrom);

		AddressListClass to();
		void setTo(const AddressListClass &newTo);

		QString subject();
		void setSubject(const QString &newSubject);

		QString status();
		void setStatus(const QString &newStatus);

		QString priority();
		void setPriority(const QString &newPriority);

		DateClass sentDate();
		void setSentDate(const DateClass &newSentDate);

		DateClass receivedDate();
		void setReceivedDate(const DateClass &newReceivedDate);

		QString scheduling();
		void setScheduling(const QString &newScheduling);

		QStringList flags();
		void setFlags(const QStringList &newFlags);

		QColor color();
		void setColor(const QColor &newColor);

		bool flag();
		void setFlag(bool newFlag);

		QString inReplyTo();
		void setInReplyTo(const QString &newInReplyTo);

		QStringList references();
		void setReferences(const QStringList &newReferences);

		QString indexID();
		void setIndexID(const QString &newIndexID);

		QString parentIndexID();
		void setParentIndexID(const QString &newParentIndexID);

		QStringList relatedIndexIDList();
		void setRelatedIndexIDList(const QString &newRelatedIndexIDList);

		AddressClass replyTo();
		void setReplyTo(const AddressClass &newReplyTo);

		AddressListClass cc();
		void setCc(const AddressListClass &newCc);

		AddressListClass bcc();
		void setBcc(AddressListClass &newBcc);

		QString messageID();
		void setMessageID(const QString &newMessageID);

		QString organization();
		void setOrganization(const QString &newOrganization);

		QString uid();
		void setUid(const QString &newUid);

		QStringList extendedStatus();
		void setExtendedStatus(const QStringList &newExtendedStatus);

		QString contentType();
		void setContentType(const QString &newContentType);

		QString contentEncoding();
		void setContentEncoding(const QString &newContentEncoding);

		QString account();
		void setAccount(const QString &newAccount);

		QStringList route();
		void setRoute(const QStringList &newRoute);

		bool requestReceipt();
		void setRequestReceipt(bool newRequestReceipt);

		QString archive();
		void setArchive(const QString &newArchive);

		QString category();
		void setCategory(const QString &newCategory);

		int persistence();
		void setPersistence(int newPersistence);

		// volatile data
		bool attachments();
		unsigned long size();
		
		// server-query data
		QCString message();
		QCString header();
		bool hasHTML();
		bool hasText();
		QCString text();
		QCString html();
		bool textPart();
		int messageText();
		bool htmlPart();
		
		// reply and forward features
		bool isReplied();
		bool isForwarded();
		
		// this is a special kind of object, and we overload sync() from VObject
		bool sync();

		// save/load VObject methods
		QByteArray _stream();
		void _narrow(const QByteArray &);
				
		/**
		 * query handling
		 */
		virtual bool getProperty(const QString &query, Any &property);
		virtual bool setProperty(const QString &query, Any &property);
		virtual QueryProcessor::QueryType queryType(const QString &query);
	private:
		// core
		AddressClass _from;
		AddressListClass _to;
		QString _subject;
		QString _status;
		QString _priority;
		QString _contentType;
		DateClass _sentDate;
		DateClass _receivedDate;
		QString _scheduling;
		QStringList _flags;
		QColor _color;
		Q_UINT8 _flag;
		QString _inReplyTo;
		QStringList _references;
		QString _indexID;
		QString _parentIndexID;
		QStringList _relatedIndexIDList;
		
		// other
		AddressClass _replyTo;
		AddressListClass _cc;
		AddressListClass _bcc;
		QString _messageID;
		QString _organization;
		QString _uid;
		QStringList _extendedStatus;
		QString _contentEncoding;
		QString _account;
		QStringList _route;
		Q_UINT8 _requestReceipt;
		QString _archive;
		QString _category;
		Q_UINT32 _persistence;
		
		/** If it has attachments. */
		Q_UINT8 _attachments;
		/** The message size.*/
		Q_UINT32 _size;
		
		QByteArray _extraData;
		
		bool __cached;
};

// the mail object factory

class MailObjectFactory : public VObjectFactory
{
	public:
	  /** Build a new mail object.*/
		MailObject *_new(QString _path, QByteArray &_data);
		MailObject *_new(QString _path);
};

#endif


