/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __ClientRMI__
#define __ClientRMI__

#include <clientrmistub.h>
#include <qstring.h>
#include <accounts.h>

class CommFrame;
class QStringList;
class CommFrame;
class RMICallData;
class Any;

class ClientRMI : public ClientRMIStub
{
	friend class CommBinder;
	public:
		static ClientRMI *ref();
	
		// server invocations
		QStringList getAccountNames(int accountType=Account::UNDEFINE);
		QString getDefaultAccount();
		bool isAccountActive(QString);
		QString getAccountFromAddress(QString);
		QString getAccountReplyToAddress(QString);
		
		void startSendReceive(QString account=QString::null);
		void startReceive(QString account=QString::null);
		void startSend(QString account=QString::null);
		void stopPOP3Delivery();
		
		void setAutoExpunge(bool);
		
		// methods used by IMAP folders
    /**
      * Mount and unmount some special folders.
      * This feature is used only for the remote folders.
      * IMAP folders needs a mount action for starting the connection
      * and an unmount action for closing the connection.
      * In this way the connection will be open only when you are seeing
      * the IMAP folder.
      * A mount acction will read the folder content too.
      */
    bool mount(QString url);
    /** Unmount a remote folder, see mount.*/
    bool unmount(QString url);
    /** Create all the subfolders.*/
    bool subfolders(QString url);

	private:
		static ClientRMI *thisInstance;
	
		void __RMICall(const RMICallData &);
		Any __RMICallback(const RMICallData &);
	
		void __process(CommFrame &);
		void __process(CommFrame &, CommFrame &);
};

#endif

