/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <videotoolbox.h>
#include <miscfunctions.h>
#include <qapplication.h>

VideoToolBox vtb;

#define IDSTRING "VideoToolBox: "

QFont QPxFont(QString hint, int pxSize=10, int weight=QFont::Normal)
{
	QFont font(hint, pxSize, weight);
	font.setPixelSize(pxSize);
	return font;
}



int VideoToolBox::getMaxAlign(QStringList strings, bool addColon=false)
{
	int result=0, tempres;
	for(int i=0;i<strings.count();i++)
	{
		if(addColon)
			strings[i]=strings[i]+":";
		tempres=stringLength(strings[i]);
		result=(result<tempres)?tempres:result;
	}
	return result;
}



void VideoToolBox::setUpFonts(QFont font)
{
	qf=font;
	qf.setPixelSize(font.pointSize());
	if(fm) delete fm;
	fm=new QFontMetrics(qf);
	char_size=(unsigned)(fm->width('M'));
	font_height=(unsigned)(fm->height()+10);
	offset_def=5;
	offset_y=8;
}

unsigned VideoToolBox::charSize()
{
	return char_size;
}

unsigned VideoToolBox::fontHeight()
{
	return font_height;
}

unsigned VideoToolBox::offsetDef()
{
	return offset_def;
}

unsigned VideoToolBox::offsetY()
{
	return offset_y;
}

unsigned VideoToolBox::stringLength(QString str)
{
	return (unsigned)(fm->width(str)+offsetDef());
}

QLabel *VideoToolBox::setUpLabel( QWidget *parent, QString text,
	int *dx, int *dy)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Enter setUpLabel\n");
#endif
	QLabel *data;
	int localDX=0, localDY=0;
	if(dx) localDX=*dx;
	if(dy) localDY=*dy;
	QString name;
	name=text; 
	data=new QLabel(parent); 
	data->setFont(qf); 
	data->setGeometry(localDX,localDY,stringLength(name),fontHeight()); 
	data->setText(name); 
	data->setFrameStyle(0); 
	data->setMargin(0); 
	if(dx)
		*dx+=stringLength(name);
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpLabel\n");
#endif
	return data;
}


QLabel *VideoToolBox::setUpLabelBgPixmap( QWidget *parent, QString text,
	QString pix,
	int X, int Y, int *dx, int *dy)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpLabelBgPixmap\n");
#endif
	QLabel *data;
	int localDX=0, localDY=0;
	if(dx) localDX=*dx;
	if(dy) localDY=*dy;
	QString name;
	QPixmap p(pix);
	QPixmap np;
	QWMatrix m;
	np=p.xForm(m.scale((1.0*X)/p.width(),(1.0*Y)/p.height()));
	name=text;
	data=new QLabel(parent);
	data->setFont(qf);
	data->setGeometry(localDX,localDY,X,Y);
//	data->setBackgroundMode(QWidget::FixedPixmap);
	data->setBackgroundPixmap(np);
	data->setText(name);
	data->setFrameStyle(QFrame::Box + QFrame::Plain);
	data->setMargin(0);
	if(dx)
		*dx+=stringLength(name);
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpLabelBgPixmap\n");
#endif
	return data;
}

QLabel *VideoToolBox::setUpLabelSize( QWidget *parent, QString text,
	int size, int *dx, int *dy)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Enter setUpLabelSize\n");
#endif
	QLabel *data;
	QString name=text; 
	int localDX=0, localDY=0;
	if(dx) localDX=*dx;
	if(dy) localDY=*dy;
	data=new QLabel(parent); 
	data->setFont(qf); 
	data->setGeometry(localDX,localDY,size,fontHeight()); 
	data->setText(name); 
	data->setFrameStyle(0); 
	data->setMargin(0); 
	if(dx)
		*dx+=size;
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpLabelSize\n");
#endif
	return data;
}

QLineEdit *VideoToolBox::setUpLineEdit( QWidget *parent,
	int length, int height, int *dx, int *dy)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Enter setUpLineEdit\n");
#endif
	int localDX=0, localDY=0;
	if(dx) localDX=*dx;
	if(dy) localDY=*dy;
	QLineEdit *data=new QLineEdit(parent); 
	data->setFont(qf); 
	data->setGeometry(localDX,localDY,length,height); 
	if(dx)
		*dx+=length+offsetDef();
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpLineEdit\n");
#endif
	return data;
}

QMultiLineEdit *VideoToolBox::setUpMultiLineEdit( QWidget *parent,
	int length, int height, int *dx, int *dy)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Enter setUpMultiLineEdit\n");
#endif
	QMultiLineEdit *data=new QMultiLineEdit(parent); 
	int localDX=0, localDY=0;
	if(dx) localDX=*dx;
	if(dy) localDY=*dy;
	data->setFont(qf); 
	data->setGeometry(localDX,localDY,length,height); 
	if(dx)
		*dx+=length+offsetDef();
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpMultiLineEdit\n");
#endif
	return data;
}

QComboBox *VideoToolBox::setUpCombo( QWidget *parent, bool flag,
	int size, int *dx, int *dy)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Enter setUpCombo\n");
#endif
	QComboBox *data=new QComboBox(flag, parent); 
	int localDX=0, localDY=0;
	if(dx) localDX=*dx;
	if(dy) localDY=*dy;
	data->setFont(qf); 
	data->setGeometry(localDX,localDY,size,fontHeight()); 
	data->setDuplicatesEnabled(false); 
	if(dx)
		*dx+=size+offsetDef();
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpCombo\n");
#endif
	return data;
}

bool VideoToolBox::reparent(QWidget *widget, QWidget *frame,
	int &index, int request)
{
	if(index!=request) 
	{ 
		QPoint p; 
		p=widget->pos(); 
		widget->reparent(frame,0,p); 
		index=request; 
		return true;
	}
	return false;
}

void VideoToolBox::setUpBoxContent(QComboBox *box, QString str)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Enter item...\n");
#endif
	bool flag=false; 
	for(int i=0;i<(int) box->count();i++) 
	{ 
		QStringList qsl=enhancedSplit(str,';'); 
		for(int j=0;j<(int) qsl.count() && !flag;j++) 
		{ 
			if(box->text(i).find(qsl[j],0,false)!=-1) 
			{ 
				box->setCurrentItem(i); 
				flag=true; 
				return; 
			} 
		} 
	} 
	if(!flag) 
	{ 
		box->insertItem((str),0); 
		box->setCurrentItem(0); 
	}
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit item...\n");
#endif
}

EButton *VideoToolBox::setUpEButton( QWidget *parent, QFont font,
	QString normalPix, QString focusPix, QString clickedPix,
	int normalFrame, int focusFrame, int clickedFrame,
	QString text,
	int x, int y, int offsetX, int offsetY)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Enter setUpKFB\n");
#endif
	EButton *data=new EButton(parent);
	data->setFont(font);
	QString pix;
	pix=normalPix;
	if(!pix.isEmpty())
		data->setNormalPixmap(QPixmap(pix));
	pix=focusPix;
	if(!pix.isEmpty())
		data->setFocusPixmap(QPixmap(pix));
	pix=clickedPix;
	if(!pix.isEmpty())
		data->setClickedPixmap(QPixmap(pix));
	if(strlen((const char *)text)!=0)
		data->setText(text);
	data->setGeometry(x,y,offsetX, offsetY);
	if(normalFrame)
		data->setNormalFrameStyle(normalFrame);
	if(focusFrame)
		data->setFocusFrameStyle(focusFrame);
	if(clickedFrame)
		data->setClickedFrameStyle(clickedFrame);
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpKFB\n");
#endif
	return data;
}

EToggleButton *VideoToolBox::setUpToggleButton( QWidget *parent, QFont font,
	QString normalPix, QString focusPix, QString clickedPix,
	int normalFrame, int focusFrame, int clickedFrame,
	QColor normalColor, QColor toggledColor,
	QString text,
	int x, int y, int offsetX, int offsetY, bool toggled)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Enter setUpEToggleButton\n");
#endif
	EToggleButton *buttonName=new EToggleButton(parent);
	buttonName->setFont(font);
	QString pix;
	pix=normalPix;
	if(!pix.isEmpty())
		buttonName->setNormalPixmap(QPixmap(pix));
	pix=focusPix;
	if(!pix.isEmpty())
		buttonName->setFocusPixmap(QPixmap(pix));
	pix=clickedPix;
	if(!pix.isEmpty())
		buttonName->setClickedPixmap(QPixmap(pix));
	if(strlen((const char *)text)!=0)
		buttonName->setText(text);
	buttonName->setGeometry(x,y,offsetX, offsetY);
	buttonName->setStyles(clickedFrame, focusFrame, normalFrame);
	buttonName->setToggledColor(toggledColor);
	buttonName->setNormalColor(normalColor);
	buttonName->setToggled(toggled);
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpEEEToggleButton\n");
#endif
	return buttonName;
}

QListBox *VideoToolBox::setUpList(QWidget *parent, QFont font,
	int width, int height, int *dx, int *dy)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Enter setUpList\n");
#endif
	int localDX=0, localDY=0;
	if(dx) localDX=*dx;
	if(dy) localDY=*dy;
	QListBox *name=new QListBox(parent);	
	name->setFont(font);
	name->setGeometry(localDX,localDY,width,height);
	if(dx)
		dx+=width;
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpList\n");
#endif
	return name;
}

QPushButton *VideoToolBox::setUpQPushButton( QWidget *parent, QString text,
	int width, int height, int *dx, int *dy)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Enter setUpQPushButton\n");
#endif
	QPushButton *b;
	int localDX=0, localDY=0;
	if(dx) localDX=*dx;
	if(dy) localDY=*dy;
	b=new QPushButton(parent);
	b->setText(text);
	b->setGeometry(localDX,localDY,width,height);
	if(dx)
		dx+=width;
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpQPushButton\n");
#endif
	return b;
}

QRadioButton *VideoToolBox::setUpQRadioButton( QWidget *parent, QString text,
	int *dx, int *dy)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Entering setUpQRadioButton\n");
#endif
	QRadioButton *data;
	int localDX=0, localDY=0;
	if(dx) localDX=*dx;
	if(dy) localDY=*dy;
	data=new QRadioButton(parent); 
	// The fontHeight in dx is for the actual radio button.
	data->setGeometry(localDX,localDY,
			stringLength(text)+fontHeight(),fontHeight()); 
	data->setText(text); 
	if(dx)
		*dx+=stringLength(text)+fontHeight();
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpQRadioButton\n");
#endif
	return data;
}
QCheckBox *VideoToolBox::setUpQCheckBox( QWidget *parent, QString text,
	int *dx, int *dy)
{
#ifdef DEBUG_VTB
	printf(IDSTRING"Entering setUpQRadioButton\n");
#endif
	QCheckBox *data;
	int localDX=0, localDY=0;
	if(dx) localDX=*dx;
	if(dy) localDY=*dy;
	data=new QCheckBox(parent); 
	// The fontHeight in dx is for the actual radio button.
	data->setGeometry(localDX,localDY,
			stringLength(text)+fontHeight(),fontHeight());
	data->setText(text);
	if(dx)
		*dx+=stringLength(text)+fontHeight();
#ifdef DEBUG_VTB
	printf(IDSTRING"Exit setUpQRadioButton\n");
#endif
	return data;
}

QTextView *VideoToolBox::setUpTextView(QWidget *parent, int frameStyle,
	QColor bgcolor,
	QString text,
	int width, int height, int dx, int dy)
{
	QTextView *data;
	data=new QTextView(parent);
	data->setGeometry(dx,dy,width,height);
	data->setFrameStyle(frameStyle);
	data->setPaper(QBrush(bgcolor));
	data->setText(text);
	return data;
}

void VideoToolBox::centerWindow(QWidget *w)
{
	int posx=QApplication::desktop()->width(), posy=QApplication::desktop()->height();
	posx=(posx-w->width())/2;
	posy=(posy-w->height())/2;
	w->move(posx, posy);
}
