/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
 #ifndef __ELineEdit__
#define __ELineEdit__

#include <qlineedit.h>
#include <qstringlist.h>
#include <qlabel.h>
#include <qevent.h>

class MatchLineEdit : public QLineEdit
{
	Q_OBJECT
	public:
		enum { Unmatched=0, Matched=1, SpecialMatched=2 };
		enum { Normal=0, Cut=1, Paste=2 };
		MatchLineEdit(QWidget *parent=0, const char *name=0);
		~MatchLineEdit();
		void setChunk(int pos, int len, int value=Unmatched);
	public slots:
		void updateMatchesLength(const QString &);
		void updateBuffer(const QString &, int);
	signals:
		void signalTextChanged(const QString &, int);
	protected:
		virtual void paintEvent(QPaintEvent *);
		QPainter *p;
		QString matches;
		int cPos;
};


class ELineEdit : public QWidget
{
	Q_OBJECT
	public:
		ELineEdit(QWidget *parent=0, const char *name=0);
		~ELineEdit();
		QLineEdit *lineEdit();
		QLabel *menuLabel();
		
		void setMenuXOffset(int x) { xRel=x; }
		void setMenuYOffset(int y) { yRel=y; }
		
		void setCompletionTreshold(int t) { thd=t; }
		void setOptionLimit(int l) { limit=l; }
		
		void setMultiString(bool m) { multiString=m; }
		
		// to use an external function to display something else than the match in the list
		virtual QString translateString(QString);
		
		virtual QString text();
	signals:
		void textChanged(const QString &);
		void returnPressed();
	public slots:
		void setCompletions(QStringList cList);
	private slots:
		void getTextChanged(const QString &);
		void getReturnPressed();
	private:
		QLabel *menu;
		MatchLineEdit *edit;
		QStringList compList;
		int activeOption, xRel, yRel, limit, thd;
		bool multiString;
		
		bool eventFilter(QObject *obj, QEvent *ev);
		void updateMenu();
		void resizeEvent(QResizeEvent *ev);
		void getCurrentChunkPos(int &pos, int &len);
		QString getCurrentChunk();
		void setCurrentChunk(const QString&);
		QString htmlFormat(const QString &);
		QString textFormat(const QString &);
};

#endif
