/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <epixbar.h>
#include <stdio.h>
#include <qpainter.h>
#include <qimage.h>
#include <kapp.h>
#define IDSTRING "EPixWidget: "

// #define DEBUG_EPIX
extern KApplication *Kapp;

EPixWidget::EPixWidget(QWidget *parent=0, const char *name=0):
	QLabel(parent,name)
{
	initialised=false;
	active=false;
	style=EPixBar::FixedSize;
	pixLabel=new QLabel(this);
	pixLabel->setAlignment(AlignHCenter | AlignVCenter);
	currentTick=0;
	_widthMargin=12;
	_heightMargin=2;
	ticksPerProgress=5;
	progressColor=QColor(0,0,70);
	if(parent)
	{
		setBackgroundColor(parent->backgroundColor());
		pixLabel->setBackgroundColor(parent->backgroundColor());
	}
}

void EPixWidget::loadPixmap(QPixmap smallGrayed, QPixmap smallColoured,
														QPixmap largeGrayed, QPixmap largeColoured)
{
	small0=smallGrayed;
	small1=smallColoured;
//	small0=smallColoured;
//	small1=smallColoured;
	large0=largeGrayed;
	large1=largeColoured;
}

void EPixWidget::setActive(bool act)
{
	active=act;
	if(style & EPixBar::FixedSize)
		setActiveFixedSize(act);
	if(style & EPixBar::DynamicSize)
		setActiveDynamicSize(act);
	if(style & EPixBar::PixmapProgress)
		setActivePixmapProgress(act);
	if(style & EPixBar::SmallProgress)
		setActiveSmallProgress(act);
}

void EPixWidget::setId(int newId)
{
	_id=newId;
}

int EPixWidget::id()
{
	return _id;
}

bool EPixWidget::isActive()
{
	return active;
}

void EPixWidget::setTicker(int numTicks)
{
	ticks=numTicks;
#ifdef DEBUG_EPIX
	printf(IDSTRING"setTicker[%d] %d\n", _id, ticks);
#endif
}

int EPixWidget::ticker()
{
	return ticks;
}

void EPixWidget::tick()
{
#ifdef DEBUG_EPIX
	printf(IDSTRING"tick(%d), %d of %d\n",_id, currentTick, ticks);
#endif
	currentTick++;
	if(style & EPixBar::SmallProgress)
		tickSmallProgress();
	if(currentTick>=ticks)
	{
#ifdef DEBUG_EPIX
		printf(IDSTRING"Exceeding the count! (%d vs. %d)\n", ticks, currentTick);
#endif
		return;
	}
	if(style & EPixBar::FixedSize)
		tickFixedSize();
	if(style & EPixBar::DynamicSize)
		tickDynamicSize();
	if(style & EPixBar::PixmapProgress)
		tickPixmapProgress();
	Kapp->processEvents();
}

int EPixWidget::getTicks()
{
	return currentTick;
}

void EPixWidget::forceTicks(int value)
{
	currentTick=value;
	setActive(active);
}

void EPixWidget::reset()
{
	currentTick=0;
}

void EPixWidget::setStyle(int newStyle)
{
//	if(initialised) return;
	style=newStyle;
	if(style & EPixBar::FixedSize)
		initFixedSize();
	if(style & EPixBar::DynamicSize)
		initDynamicSize();
	if(style & EPixBar::PixmapProgress)
		initPixmapProgress();
	if(style & EPixBar::SmallProgress)
		initSmallProgress();
	initialised=true;
}

void EPixWidget::setWidthMargin(int m)
{
	_widthMargin=m;
	if(style & EPixBar::FixedSize)
		initFixedSize();
	if(style & EPixBar::DynamicSize)
		initDynamicSize();
}

void EPixWidget::setHeightMargin(int m)
{
	_heightMargin=m;
	if(style & EPixBar::FixedSize)
		initFixedSize();
	if(style & EPixBar::DynamicSize)
		initDynamicSize();
}

int EPixWidget::widthMargin()
{
	return _widthMargin;
}

int EPixWidget::heightMargin()
{
	return _heightMargin;
}

void EPixWidget::initFixedSize()
{
	resize(large0.width()+2*widthMargin(), large0.height()+2*heightMargin());
#ifdef DEBUG_EPIX
	printf(IDSTRING"initFixedSize: pix Size: (%d, %d)\n",large0.width(), large0.height());
	printf(IDSTRING"initFixedSize: Size: (%d, %d)\n",width(), height());
#endif
	pixLabel->setGeometry(widthMargin(), heightMargin(), large0.width(), large0.height());
#ifdef DEBUG_EPIX
	printf(IDSTRING"initFixedSize: pixmap Size: (%d, %d)\n",pixLabel->width(), pixLabel->height());
#endif
	pixLabel->setPixmap(small0);
	initPixmap=true;
}

void EPixWidget::initDynamicSize()
{
	resize(small0.width()+2*widthMargin(), small0.height()+2*heightMargin());
#ifdef DEBUG_EPIX
	printf(IDSTRING"initDynamicSize: Size: (%d, %d)\n",width(), height());
#endif
	pixLabel->resize(small0.width(), small0.height());
#ifdef DEBUG_EPIX
	printf(IDSTRING"initDynamicSize: pixmap Size: (%d, %d)\n",pixLabel->width(), pixLabel->height());
#endif
	if(!initPixmap)
	{
		pixLabel->setPixmap(small0);
		initPixmap=true;
	}
}

void EPixWidget::initPixmapProgress()
{
	activePix0=large0;
	activePix1=large1;
	if(!initPixmap)
	{
		pixLabel->setPixmap(small0);
		initPixmap=true;
	}
}

void EPixWidget::initSmallProgress()
{
	if(!initPixmap)
	{
		pixLabel->setPixmap(small0);
		initPixmap=true;
	}
	resize(width(), height()+2); // make place for the new small bar
#ifdef DEBUG_EPIX
	printf(IDSTRING"initSmallProgress: Size: (%d, %d)\n",width(), height());
#endif
}

void EPixWidget::setActiveFixedSize(bool act)
{
	if(act)
	{
#ifdef DEBUG_EPIX
		printf("\tACTIVE\n");
#endif
		activePix0=large0;
		activePix1=large1;
		if(ticks<=currentTick)
			pixLabel->setPixmap(large1);
		else
			pixLabel->setPixmap(large0);
	}
	else
	{
#ifdef DEBUG_EPIX
		printf("\tInactive\n");
#endif
//		activePix0=small0;
//		activePix1=small1;
		if(ticks<=currentTick)
		{
#ifdef DEBUG_EPIX
			printf("\tfinished\n");
#endif
			pixLabel->setPixmap(small1);
		}
		else
		{
#ifdef DEBUG_EPIX
			printf("\tincomplete %d %d\n", ticks, currentTick);
#endif
			pixLabel->setPixmap(small0);
		}
	}
	pixLabel->show();
}

void EPixWidget::setActiveDynamicSize(bool act)
{
	if(act)
	{
		resize(large0.width()+2*widthMargin(), large0.height()+2*heightMargin());
		pixLabel->resize(large0.width(), large0.height());
	}
	else
	{
		resize(small0.width()+2*widthMargin(), small0.height()+2*heightMargin());
		pixLabel->resize(small0.width(), small0.height());
	}
	setActiveFixedSize(act); // the same thing as fixed + resize
	emit sizeChanged(width(), height(), id());
}

void EPixWidget::setActivePixmapProgress(bool act)
{
}

void EPixWidget::setActiveSmallProgress(bool act)
{
}

void EPixWidget::tickFixedSize()
{
#ifdef DEBUG_EPIX
	printf(IDSTRING"Nothing to do with the size\n");
#endif
}

void EPixWidget::tickDynamicSize()
{
#ifdef DEBUG_EPIX
	printf(IDSTRING"Nothing to do with the size\n");
#endif
}

//#define LINEAR_PROGRESS
#define ALPHA_BLENDING

void EPixWidget::tickPixmapProgress()
{
#ifdef LINEAR_PROGRESS
	QPixmap temp=activePix0;
	QPainter p;
	p.begin(&temp);
	int perc=(int)((double)activePix0.width()*currentTick/(double)ticks);
	p.drawPixmap(0,0,activePix1,0,0,perc,activePix1.height());
	p.end();
	pixLabel->setPixmap(temp);
#ifdef DEBUG_EPIX
	printf(IDSTRING"Ticks: %d out of %d.\n",currentTick, ticks);
#endif
#endif // linear progress

#ifdef ALPHA_BLENDING
	QPixmap temp=activePix0;
	QImage 	i1=activePix0.convertToImage(), 
					i2=activePix1.convertToImage();
	QPainter p;
	int r,g,b;
	QRgb rgb0, rgb1;
	p.begin(&temp);
	p.eraseRect(0,0,temp.width(), temp.height());
	for(int i=0; i<temp.width(); i++)
		for(int j=0; j<temp.width(); j++)
		{
			rgb0=i1.pixel(i,j);
			rgb1=i2.pixel(i,j);
			r=(int)(((double)qRed(rgb0)*(ticks-currentTick))/(double)(ticks) +
				((double)qRed(rgb1)*(currentTick))/(double)(ticks));
			g=(int)(((double)qGreen(rgb0)*(ticks-currentTick))/(double)(ticks) +
				((double)qGreen(rgb1)*(currentTick))/(double)(ticks));
			b=(int)(((double)qBlue(rgb0)*(ticks-currentTick))/(double)(ticks) +
				((double)qBlue(rgb1)*(currentTick))/(double)(ticks));
			p.setPen(QPen(QColor(r,g,b)));
			p.drawPoint(i,j);
		}
	p.end();
	pixLabel->setPixmap(temp);
#ifdef DEBUG_EPIX
	printf(IDSTRING"Ticks: %d out of %d.\n",currentTick, ticks);
#endif
#endif // alpha blending
}

void EPixWidget::tickSmallProgress()
{
	QPainter p;
	p.begin(this);
	int plen=(int)(((width()-2*widthMargin())*
		(double)(currentTick%ticksPerProgress))/(double)(ticksPerProgress-1));
	if((currentTick%ticksPerProgress)==0)
	{
		p.eraseRect(widthMargin(),height()-heightMargin(),
			width()-2*widthMargin(),1);
	}
	p.setPen(QPen(progressColor));
	if(plen>(width()-2*widthMargin()-1)) plen=width()-2*widthMargin()-1;
	p.drawLine(widthMargin(),height()-heightMargin(),widthMargin()+plen,height()-heightMargin());
	p.end();
}

void EPixWidget::setTicksPerProgress(int tpp)
{
	ticksPerProgress=tpp;
}
void EPixWidget::setProgressColor(QColor c)
{
	progressColor=c;
}

/****************************************************************/
/* EPixBar                                                      */
/****************************************************************/
EPixBar::EPixBar(QWidget *parent=0, const char *name=0) :QLabel(parent, name)
{
	dx=0; dy=0; x=0; y=0;
	setActiveType();
	setBackgroundColor(QColor("white"));
	defaultMargins[0]=25;
	defaultMargins[1]=2;
}

void EPixBar::setActiveType(int type=ExclusiveActives)
{
	_activeType=type;
}

int EPixBar::activeType()
{
	return _activeType;
}

void EPixBar::loadWidget(QPixmap p1, QPixmap p2, QPixmap p3, QPixmap p4)
{
	EPixWidget *w = new EPixWidget(this);
	widgets.append(w);
	w->setId(widgets.count());
	w->loadPixmap(p1, p2, p3, p4);
	w->setStyle(EPixBar::FixedSize | 
							EPixBar::PixmapProgress |
								EPixBar::SmallProgress);
	w->setWidthMargin(defaultMargins[0]);
	w->setHeightMargin(defaultMargins[1]);
	w->setTicker(100);
	w->move(dx,0);
	w->setActive(false);
	dx+=w->width();
	dy=w->height();
#ifdef DEBUG_EPIX
	printf("new size: %d %d \n", dx, dy);
#endif
	resize(dx,dy);
}

void EPixBar::setActive(int index, bool value)
{
	if(_activeType==ExclusiveActives)
	{
		for(int i=0;i<widgets.count();i++)
			if(index>=0 && widgets[i] && widgets[i]->isActive()) 
				widgets[index]->setActive(false);
	}
	if(index>=0 && index<widgets.count() && widgets[index])
	{
#ifdef DEBUG_EPIX
		printf("------------ SET Active %s\n",((value)?"true":"false"));
#endif
		widgets[index]->setActive(value);
		widgets[index]->update();
	}
}

int EPixBar::active()
{
	for(int i=0;i<widgets.count();i++)
		if(widgets[i] && widgets[i]->isActive()) return i;
	return -1;
}

void EPixBar::setProgressColor(QColor value, int pos)
{
	if(pos==-1)
	{
		for(int i=0;i<widgets.count();i++)
			if(widgets[i]) 
				widgets[i]->setProgressColor(value);
	}
	else
		if(widgets.count()>pos && widgets[pos])
			widgets[pos]->setProgressColor(value);
}

void EPixBar::setTicksPerProgress(int value, int pos)
{
	if(pos==-1)
	{
		for(int i=0;i<widgets.count();i++)
			if(widgets[i]) 
				widgets[i]->setTicksPerProgress(value);
	}
	else
		if(widgets.count()>pos && widgets[pos])
			widgets[pos]->setTicksPerProgress(value);
}

void EPixBar::setTicker(int value, int pos)
{
#ifdef DEBUG_EPIX
	printf("EPixBar::setTicker (%d, %d)\n", value, pos);
#endif
	if(pos==-1)
	{
		for(int i=0;i<widgets.count();i++)
			if(widgets[i]) 
				widgets[i]->setTicker(value);
#ifdef DEBUG_EPIX
		printf("pos is -1\n");
#endif
	}
	else
		if(widgets.count()>pos && widgets[pos])
		{
#ifdef DEBUG_EPIX
			printf("---------- ok\n");
#endif
			widgets[pos]->setTicker(value);
		}
#ifdef DEBUG_EPIX
		else
			printf("invalid %d, %d!\n",widgets.count(),pos);
#endif
}

void EPixBar::tick()
{
	for(int i=0;i<widgets.count();i++)
		if(widgets[i] && widgets[i]->isActive())
			widgets[i]->tick();
}

void EPixBar::reset(int pos=-1)
{
	if(pos==-1)
	{
		for(int i=0;i<widgets.count();i++)
			if(widgets[i]) 
				widgets[i]->reset();
	}
	else
		if(widgets.count()>pos && widgets[pos])
			widgets[pos]->reset();
}

void EPixBar::setStyle(int value, int pos)
{
	if(pos==-1)
	{
		for(int i=0;i<widgets.count();i++)
			if(widgets[i]) 
				widgets[i]->setStyle(value);
	}
	else
		if(widgets.count()>pos && widgets[pos])
			widgets[pos]->setStyle(value);
}

void EPixBar::setWidthMargin(int value, int pos)
{
	defaultMargins[0]=value;
	if(pos==-1)
	{
		for(int i=0;i<widgets.count();i++)
			if(widgets[i]) 
				widgets[i]->setWidthMargin(value);
	}
	else
		if(widgets.count()>pos && widgets[pos])
			widgets[pos]->setWidthMargin(value);
}

void EPixBar::setHeightMargin(int value, int pos)
{
	defaultMargins[1]=value;
	if(pos==-1)
	{
		for(int i=0;i<widgets.count();i++)
			if(widgets[i]) 
				widgets[i]->setHeightMargin(value);
	}
	else
		if(widgets.count()>pos && widgets[pos])
			widgets[pos]->setHeightMargin(value);
}

int EPixBar::widthMargin(int pos=-1)
{
	if(pos==-1)
	{
		if(widgets.count())
			return widgets[0]->widthMargin();
		else
			return 0;
	}
	else
		if(widgets.count()>pos)
			return widgets[pos]->widthMargin();
		else
			return 0;		
}

int EPixBar::heightMargin(int pos)
{
	if(pos==-1)
	{
		if(widgets.count())
			return widgets[0]->heightMargin();
		else
			return 0;
	}
	else
		if(widgets.count()>pos)
			return widgets[pos]->heightMargin();
		else
			return 0;		
}

void EPixBar::sizeChanged(int newWidth, int newHeight, int id)
{
}

int EPixBar::getTicks(int pos)
{
	if(pos==-1)
	{
		for(int i=0;i<widgets.count();i++)
			if(widgets[i] && widgets[i]->isActive()) 
				return widgets[i]->getTicks();
	}
	else
	{
		if(widgets[pos]) 
			return widgets[pos]->getTicks();
	}
	return 0;	
}

void EPixBar::forceTicks(int value, int pos)
{
	if(pos==-1)
	{
		for(int i=0;i<widgets.count();i++)
			if(widgets[i])
				widgets[i]->forceTicks(value); 
	}
	else
	{
		if(widgets[pos]) 
			widgets[pos]->forceTicks(value);
	}
}

void EPixBar::setupGeometry()
{
	// no geometry changes...
}
