/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */


#include <vector>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netgroup.h>
#include <netprotocol.h>
#include <netpop3.h>

NetPOP3::NetPOP3():NetProtocol()
{
}

NetPOP3::NetPOP3(const char *category):NetProtocol(category)
{
}

bool NetPOP3::connect(const string &host, int port)
{
	string rep;
	
	// connect
	NetProtocol::connect(host, port);
	
	// check connection
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	// set line mode
	setMode(POP3_Read_Line);
	
	// server greeting message
	(*this)>>rep;
	
	if(rep.substr(0,4)=="-ERR" || rep.substr(0,4)=="-err")
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
	
	return true;
}

bool NetPOP3::user(const string &username)
{
	string rep;

	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	// set line mode
	setMode(POP3_Read_Line);
	
	// user command
	rep="user " + username + "\r\n";
	(*this)<<rep;
	rep="";
	(*this)>>rep;
	
	if(rep.empty() || rep.substr(0,4)=="-ERR" || rep.substr(0,4)=="-err")
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return false;
	}	
	
	return true;
}

bool NetPOP3::pass(const string &password)
{
	string rep;

	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	// set line mode
	setMode(POP3_Read_Line);
	
	// pass command
	rep="pass " + password + "\r\n";
	(*this)<<rep;
	rep="";
	(*this)>>rep;
	
	if(rep.empty() || rep.substr(0,4)=="-ERR" || rep.substr(0,4)=="-err")
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return false;
	}
	
	return true;
}

bool NetPOP3::dele(int message)
{
	string rep;
	char szMessage[MAX_MESSAGE_DIGITS_NR+1];
	
//	bzero(szMessage, MAX_MESSAGE_DIGITS_NR+1);
	sprintf(szMessage,"%d",message);

	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	// set line mode
	setMode(POP3_Read_Line);
	
	// dele command
	rep="dele ";
	rep+=szMessage;
	rep+="\r\n";
	(*this)<<rep;
	rep="";
	(*this)>>rep;
	
	if(rep.empty()|| rep.substr(0,4)=="-ERR" || rep.substr(0,4)=="-err")
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return false;
	}
	
	return true;	
}

bool NetPOP3::rset()
{
	string rep;

	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	// set line mode
	setMode(POP3_Read_Line);
	
	// rset command
	rep="rset\r\n";
	(*this)<<rep;
	rep="";
	(*this)>>rep;
	
	if(rep.empty() || rep.substr(0,4)=="-ERR" || rep.substr(0,4)=="-err")
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return false;
	}
	
	return true;	
}

bool NetPOP3::stat(unsigned &messagecount, unsigned &totalsize)
{
	string rep;

	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	// set line mode
	setMode(POP3_Read_Line);
	
	// stat command
	rep="stat\r\n";
	(*this)<<rep;
	rep="";
	(*this)>>rep;

	if(rep.empty() || rep.substr(0,4)=="-ERR" || rep.substr(0,4)=="-err")
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return false;
	}
	
	// parse response
	vector<string> replist=split(' ', rep);
	messagecount=atoi(replist[1].c_str());
	totalsize=atoi(replist[2].c_str());
	
	return true;
}

int NetPOP3::last()
{
	string rep;

	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	// set line mode
	setMode(POP3_Read_Line);
	
	// last command
	rep="last\r\n";
	(*this)<<rep;
	rep="";
	(*this)>>rep;	
	
	if(rep.empty() || rep.substr(0,4)=="-ERR" || rep.substr(0,4)=="-err" || rep.empty())
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return -1;
	}
	
	// parse response
	return atoi(split(' ', rep)[1].c_str());
}

int NetPOP3::list(int message)
{
	string rep;
	char szMessage[MAX_MESSAGE_DIGITS_NR+1];

//	bzero(szMessage, MAX_MESSAGE_DIGITS_NR+1);
	sprintf(szMessage,"%d",message);
	
	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	// set line mode
	setMode(POP3_Read_Line);
	
	// list command
	rep="list ";
	rep+=szMessage;
	rep+="\r\n";
	(*this)<<rep;
	rep="";
	(*this)>>rep;
		
	// workaround Lotus Notes list bug
	if(rep.find('\n')!=rep.npos) rep=rep.substr(0, rep.find('\n'));
	if(rep.find('\r')!=rep.npos) rep=rep.substr(0, rep.find('\r'));
	
	if(rep.empty() || rep.substr(0,4)=="-ERR" || rep.substr(0,4)=="-err")
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return -1;
	}
	
	// parse response
	return atoi(split(' ', rep)[2].c_str());
}

bool NetPOP3::list(vector<int> &listRep)
{
	string rep;
	
	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	// list command
	rep="list\r\n";
	(*this)<<rep;
	rep="";
		
	if(!dotRead(rep))
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return false;
	}
	
	// strip server line and trailing dot
	rep=rep.substr(rep.find("\n")+1);
//	rep=rep.substr(0, rep.rfind("."));
	
	// parse response
	vector<string> lines=split('\n', rep);
	for(unsigned int i=0;i<lines.size();i++)
	{
		string line=lines[i];
		if(!line.empty())
		{
			if(line[line.length()-1]=='\r') line[line.length()-1]=0;
			listRep[i]=atoi(split(' ', line)[1].c_str());
		}
	}
	return true;
}

bool NetPOP3::uidl(vector<string> &listRep)
{
	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	string rep;
	
	// list command
	rep="uidl\r\n";
	(*this)<<rep;
	rep="";
	
	if(!dotRead(rep))
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return false;
	}
	
	// strip server line and trailing dot
	rep=rep.substr(rep.find("\n")+1);
//	rep=rep.substr(0, rep.rfind("."));
	
	// parse response
	vector<string> lines=split('\n', rep);
	for(unsigned int i=0;i<lines.size();i++)
	{
		string line=lines[i];
		if(!line.empty())
		{
			if(line[line.length()-1]=='\r') line[line.length()-1]=0;
			listRep[i]=split(' ', line)[1];
		}
	}
	
	return true;
}

string NetPOP3::uidl(int message)
{
	string rep;
	char szMessage[MAX_MESSAGE_DIGITS_NR+1];

//	bzero(szMessage, MAX_MESSAGE_DIGITS_NR+1);
	sprintf(szMessage,"%d",message);

	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return string("");
	}
	
	// set line mode
	setMode(POP3_Read_Line);
	
	// uidl command
	rep="uidl ";
	rep+=message;
	rep+="\r\n";
	(*this)<<rep;
	rep="";
	(*this)>>rep;	

	// workaround Lotus Notes uidl bug
	if(rep.find('\n')!=rep.npos) rep=rep.substr(0, rep.find('\n'));
	if(rep.find('\r')!=rep.npos) rep=rep.substr(0, rep.find('\r'));
	
	if(rep.substr(0,4)=="-ERR" || rep.substr(0,4)=="-err")
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return string("");
	}
		
	// parse response
	return split(' ', rep)[1];
}

bool NetPOP3::top(int message, int lines, string &rep)
{
	char szMessage[MAX_MESSAGE_DIGITS_NR+1];
	char szLines[MAX_MESSAGE_DIGITS_NR+1];

//	bzero(szMessage, MAX_MESSAGE_DIGITS_NR+1);
//	bzero(szLines, MAX_MESSAGE_DIGITS_NR+1);
	sprintf(szMessage,"%d",message);
	sprintf(szLines,"%d",lines);
	
	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	// top command
	rep="top ";
	rep+=szMessage;
	rep+=" ";
	rep+=szLines;
	rep+="\r\n";
	(*this)<<rep;
	rep="";
		
	if(!dotRead(rep))
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return false;
	}
	
	// parse response; strip server line and trailing dot
	rep=rep.substr(rep.find("\n")+1);
//	rep=rep.substr(0, rep.rfind("."));
	
	return true;
}

bool NetPOP3::retr(int message, string &rep)
{
	char szMessage[MAX_MESSAGE_DIGITS_NR+1];

//	bzero(szMessage, MAX_MESSAGE_DIGITS_NR+1);
	sprintf(szMessage,"%d",message);
	
	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return false;
	}
	
	// retr command
	rep="retr ";
	rep+=szMessage;
	rep+="\r\n";
	(*this)<<rep;
	rep="";
	
	if(!dotRead(rep))
	{
		pop3_error=rep.empty()?string("no response from server"):rep;
		return false;
	}
	// parse response; strip server line and trailing dot
	rep=rep.substr(rep.find("\n")+1);
//	rep=rep.substr(0, rep.rfind("."));
	
	return true;
}

void NetPOP3::quit()
{
	// check connection	
	if(!NetProtocol::isConnected())
	{
		pop3_error=netsock.error();
		return;
	}
	
	// quit command
	(*this)<<"quit\r\n";
}

bool NetPOP3::dotRead(string &buf)
{
	setMode(POP3_Read_MultiLine);
	(*this)>>buf;
	return !buf.empty();
}

bool NetPOP3::isConnected()
{
	return NetProtocol::isConnected();
}

NetSocket& NetPOP3::socket()
{
	return NetProtocol::socket();
}

string NetPOP3::error()
{
	return pop3_error;
}

bool NetPOP3::checkEndOfResponse(const string &answer) const
{
  if( mode == NetProtocol::POP3_Read_MultiLine )
    return( answer.substr(answer.length()-5, 5) != "\r\n.\r\n" );
  else
    return( answer.substr(answer.length()-2, 2) != "\r\n" );
}
