/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <string.h>
#include <time.h>
#include <unistd.h>
#include <stdio.h>
#include <netprotocol.h>
#include <netgroup.h>

NetProtocol::NetProtocol():NetGroup(), netsock()
{
	mode=Read_Default;
}

NetProtocol::NetProtocol(const char *category):NetGroup(category), netsock()
{
	netsock.setReadTimeout(getReadTimeout());
}

NetProtocol::~NetProtocol()
{
	if(isConnected()) disconnect();
}

bool NetProtocol::connect(string host, int port)
{
	return netsock.connect(host.c_str(), port, getConnectionTimeout());
}

void NetProtocol::disconnect()
{
	netsock.disconnect();
}

bool NetProtocol::isConnected()
{
	return netsock.isConnected();
}

NetProtocol& NetProtocol::operator>>(string &s)
{
	time_t server_reply_timeout=getReplyTimeout(), initial_time=time(0);
	int received=0, chunk=0;
	bool bMode=true;
	int receive_size=netsock.srSize();
	char buffer[receive_size+1];

	s="";

	while( received<MAX_READ_BUFFER_SIZE &&          // max read buffer size
	       bMode &&                                  // depends on iMode
	       time(0)-initial_time<server_reply_timeout )// reply timeout
	{
	  bzero(buffer, sizeof(buffer));
	  initial_time=time(0);
	
		chunk=netsock.read(buffer, MAX_READ_BUFFER_SIZE-received<receive_size ? MAX_READ_BUFFER_SIZE-received : receive_size);
		if( chunk==-1 ) break; // receiving error
		received+=chunk;
		// !!! It is possible to receive a null char
		s.append(buffer,chunk);
		
		switch( mode )
		{
		  case POP3_Read_MultiLine :
		    if( s[0]!='+' ) // It isn't a multiline. Try single line.
		      mode=POP3_Read_Line;
		    else
		    {
		      bMode = checkEndOfResponse(s);
  		      break;
		    }
		  case POP3_Read_Line :
		  case SMTP_Read_Line :
		  case IMAP4_Read_Line :
	    	bMode = checkEndOfResponse(s);
 	    	break;
 	    case Read_One_Line :
	    	bMode = NetProtocol::checkEndOfResponse(s);
 	    	break;
		  case Read_Default :
		  default:
		    break;
		}
	}
		
	if( !bMode ) // line or multiline
	{
  	// strip the \n and \r and .
  	if( mode==POP3_Read_MultiLine )
  	{
      int iPos=0;

      while( -1 != (iPos=s.find("\r\n.",iPos)) )
      {
        s.erase(iPos+2,1);// remove the point
        iPos+=2;// 3-1
      }
  	}
    s.erase(s.length()-2,2);
	}
	else if( chunk!=-1 )
	  s="";
	else if( received > MAX_READ_BUFFER_SIZE )
	{
	  printf("The message size is too big");
	  s="";
	}
	else
	{
    printf("Reply timeout or an unknown error");
    s="";
	}

	return *this;
}


NetProtocol& NetProtocol::operator<<(const string &s)
{
	if(netsock.canWrite())
	  netsock.write(s.c_str());
	return *this;
}

NetProtocol& NetProtocol::operator<<(int n)
{
	char buf[MAX_MESSAGE_DIGITS_NR+1];
//	bzero(buf, MAX_MESSAGE_DIGITS_NR+1);
	sprintf(buf, "%d", n);

	(*this)<<string(buf);

	return *this;
}

NetSocket& NetProtocol::socket()
{
	return netsock;
}

void NetProtocol::setMode(Mode m)
{
	mode=m;
}

bool NetProtocol::checkEndOfResponse(const string &answer) const
{
  return( answer.substr(answer.length()-2, 2) != "\r\n" );
}



