/***************************************************************************
                uidjar.h  -  the UID jar interface class 
                             -------------------
    begin                : Wed Mar 14 19:02:00 EET 2001
    copyright            : (C) 2001 by theKompany (www.thekompany.com>
    author               : Eugen Constantinescu
    email                : eug@thekompany.com
 ***************************************************************************/

#ifndef __UIDJar__
#define __UIDJar__

#include <string>
#include <map>
#include <fstream.h>

/** The data format we need in UID list.*/
typedef struct uidInfo
{
  /** 
    * The string information we need.
    * Ex: IMAP is using it for storing the message url.
    */
  string info;
  /** The receiving time.*/
  unsigned int rcvTime;
} UIDINFO;

typedef map<string, UIDINFO, less<string> > UIDMap;
typedef UIDMap::value_type  UIDValuePair;

/** 
  * The UID list class.
  * It is an interface for POP3 and IMAP4 UIDJar classes.
  */
class UIDJar
{
	public:
		UIDJar();
		virtual ~UIDJar();
		
		/** Load the UID map from the file.*/
		void loadLists();
		/** Save the UID map into the file.*/
		void saveLists();
		
		/** The receiving UID list.*/
		UIDMap rcvList;
		/** The UID list marked for deletion.*/
		UIDMap trashList;
		
	protected:
	  /** Setup the files name.*/
	  virtual void setupFiles()=0;
	  
	  /** The file name of receiving UID.*/
		string rcvFileName;
		/** The file name of deleting UID.*/
		string delFileName;
		/** UID limited number.*/
		const static int UID_LIMIT=20000;
};

#endif
