/***************************************************************************
                commandsprocessor.cpp  -  a smart command list
                             -------------------
    begin                : Thu Jul  5 17:35:17 EEST 2001
    copyright            : (C) 2001 by Eugen C.
    email                : eug@thekompany.com
 ***************************************************************************/

#include <netimap4.h>
#include <imap4handler.h>
#include <commandsprocessor.h>

CommandProcessor::CommandProcessor()
{
  lastCommand.type=IMAP4Handler::NO_COMMANDS;
  lastCommand.account="";
  lastCommand.mailbox="";
  lastCommand.other="";
  lastCommand.parameters="";
  commands.clear();
}

CommandProcessor::~CommandProcessor()
{
  commands.clear();
}

bool CommandProcessor::insertCommand(unsigned type, string account, string mailbox, string other, string parameters)
{
  CommandsListIterator itFind;
  COMMAND_STRUCT  oldCommand=lastCommand;

  lastCommand.type=type;
  lastCommand.account=account;
  lastCommand.mailbox=mailbox;
  lastCommand.other=other;
  lastCommand.parameters=parameters;

  switch( type )
  {
    case IMAP4Handler::SYNC :
    case IMAP4Handler::NOOP :
      itFind=find(type, account);
      if( itFind==commands.end() )
        commands.push_back(lastCommand);
      break;
    case IMAP4Handler::ADD_MESSAGE :
      commands.push_back(lastCommand);
      lastCommand.type=IMAP4Handler::LOGOUT;
      commands.push_back(lastCommand);
      break;
    case IMAP4Handler::DELETE_MESSAGE :
      commands.push_back(lastCommand);
      break;
    case IMAP4Handler::UPDATE_MESSAGE :
      commands.push_back(lastCommand);
      break;
    case IMAP4Handler::EXPUNGE :
      commands.push_back(lastCommand);
      break;
    case IMAP4Handler::CLOSE :
      commands.push_back(lastCommand);
      break;
    case IMAP4Handler::LOGOUT :
      commands.push_back(lastCommand);
      break;
    case IMAP4Handler::LOGIN :
      commands.push_back(lastCommand);
      break;
    case IMAP4Handler::SELECT :
      commands.push_back(lastCommand);
      break;
    case IMAP4Handler::MOUNT :
      commands.push_back(lastCommand);
      break;
    case IMAP4Handler::UNMOUNT :
      commands.push_back(lastCommand);
      break;
    case IMAP4Handler::CREATE_FOLDER :
      commands.push_back(lastCommand);
      if( oldCommand.type!=IMAP4Handler::LOGOUT )
      {
        lastCommand.type=IMAP4Handler::LOGOUT;
        commands.push_back(lastCommand);
      }
      break;
    case IMAP4Handler::DELETE_FOLDER :
      commands.push_back(lastCommand);
      if( oldCommand.type!=IMAP4Handler::LOGOUT )
      {
        lastCommand.type=IMAP4Handler::LOGOUT;
        commands.push_back(lastCommand);
      }
      break;
    case IMAP4Handler::SUBFOLDERS :
      commands.push_back(lastCommand);
      if( oldCommand.type!=IMAP4Handler::LOGOUT )
      {
        lastCommand.type=IMAP4Handler::LOGOUT;
        commands.push_back(lastCommand);
      }
      break;
    default:
      break;
  }

  // start the thread
  IMAP4Handler::startThread();
}

bool CommandProcessor::popCommand(COMMAND_STRUCT& commandBuffer)
{
  if( commands.empty() )
    return false;

  COMMAND_STRUCT &firstCommand=commands.front();

  commandBuffer.type=firstCommand.type;
  commandBuffer.account=firstCommand.account;
  commandBuffer.mailbox=firstCommand.mailbox;
  commandBuffer.other=firstCommand.other;
  commandBuffer.parameters=firstCommand.parameters;

  // remove it from the list
  commands.pop_front();
  return true;
}

bool CommandProcessor::isEmpty()
{
  return commands.empty();
}

void CommandProcessor::clear()
{
  commands.clear();
}

CommandsListIterator CommandProcessor::find(unsigned type, string account)
{
  CommandsListIterator it;

  for(it=commands.begin(); it!=commands.end(); ++it)
    if( (*it).type==type && (*it).account==account )
      break;

  return it;
}













