/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __IMAP_Defs__
#define __IMAP_Defs__

#include <qcstring.h>
#include <qstringlist.h>

namespace IMAPdefs
{
	enum IMAPCmdCode
	{
		Connect=0,
		Disconnect,
		Sync,
		Delete,
		DeleteAll,
		Expunge,
		Get,
		Put,
		Copy,
		CopyAll,
		Search,
		Shutdown
	};

	enum IMAPStat
  {
    OK=0,
    NO,
    BAD,
    INVALID
  };
    
  enum Alert
  {
    Warning,
    RevisionCheck
  };

	struct IMAPCmdData
	{
		QCString account, sourceFolder, destFolder, mbox, uid;
		bool allFlag;
		void *data;
	};

	struct IMAPCmd
	{
		IMAPCmdCode instrCode;
		IMAPCmdData params;
	};
	
	struct IMAPRetValue
	{
		QCString msg;
		int data;
	};
  
  struct TaggedStatus
  {
    TaggedStatus(QCString);
    QCString tag, cmd, rcode;
    IMAPStat stat;
  };
  
  struct UntaggedStatus
  {
    UntaggedStatus(QCString);
    QCString rcode, data;
    IMAPStat stat;
  };
	
	struct SyncData
	{
		QStringList uidList;
		int messages, unseen, maxdl;
		QString nextuid, uidvalidity;
		void *folder;
	};
	
	struct SyncDeleteData
	{
		void *folder;
		QCString uid;
	};
	
	struct SyncCreateData
	{
		void *folder;
		QStringList mimedefs;
		QCString header, uid, account;
	};
	
	struct SyncGetData
	{
		void *folder;
		QCString uid, data;
		int part;
	};
	
};

bool connected(QCString);
void connectIMAPAccount(QCString);
void disconnectIMAPAccount(QCString);
void syncIMAPFolder(QCString, QCString, IMAPdefs::SyncData *);

// various small parsers
QCString seqData(QCString, QCString);
QString parseMimeDef(QString);
QString unfold(QString);

#endif








