/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <orb.h>
#include <magellan.h>
#include <mailclasses.h>
#include <indexclass.h>
#include <transactionserver.h>
#include <attributemarshall.h>
#include <conversions.h>
#include <messagedescriptor.h>
#include <messagedevice.h>
#include <mailfolder.h>
#include <accounts.h>
#include <accountmanager.h>
#include <smtphandler.h>

bool ObjectRequestBroker::send(QString url)
{
  if(!exists(url))
  {
		printf("Warning: cannot send a non-existent object\n");
    err="Cannot send a non-existent object";
    return false;
  }
  if(isFolder(url))
  {
		printf("Warning: cannot send a folder\n");
    err="Cannot send a folder";
    return false;
  }
  if(subtype(url)!=Magellan::Message)
  {
		printf("Warning: cannot send a non-mail object\n");
    err="Cannot send a non-mail object";
    return false;
  }
  QString fname=folder(url);
  if(mailfolderReference(fname)->getFolderType()!=MailFolder::Outbox)
  {
		printf("Warning: cannot send messages except from Outbox\n");
    err="Cannot send a non-outgoing message";
    return false;
  }

  IndexClass *idx=indexReference(url);
  if(!idx)
  {
  	printf("Warning: indexReference() returned null when a valid pointer was expected, bailing out\n");
  	err="Internal error in URLManager::indexReference()";
  	return false;
  }
	
	if(idx->isLocked())
	{
		printf("Warning: message is already locked by the mail spooler, cannot send\n");
		err="Message was locked by the mail spooler, cannot send";
		return false;
	}
	
	MessageDevice *dev=new MessageDevice(idx);
	dev->loadDescriptor();
	
	Account *acc=AccountManager::ref()->getAccount(dev->getDescriptor().account);
	if(!acc)
	{
		printf("Warning: no account was set on the message, cannot send\n");
		err="No account was set on the message, cannot send";
		return false;
	}

	// debug
	printf("orb: trying to send message %s using account %s...\n", (const char *)idx->getID(), (const char *)acc->accname);
		
	SMTPHandler::ref()->send(idx, acc);
	return true;
}

