/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <pop3mailframe.h>
#include <videotoolbox.h>
#include <names.h>
#include <definedmessages.h>
#include <qdir.h>
#include <qfiledialog.h>

extern VideoToolBox vtb;

Pop3MailFrame::Pop3MailFrame(QWidget *parent, QString name,
	int x, int y, int dx, int dy, int idx) :
	QFrame(parent, name)
{
	index=idx;
	setGeometry(x, y, dx, dy);
	setFrameStyle(0);
	// Creating the continue-cancel buttons
	// The buttons are going to be in the bottom right
	int x,y;
	x=dx-280, y=dy-vtb.fontHeight();
	backButton=vtb.setUpQPushButton(this,"Back",
		80, vtb.fontHeight(), &x, &y);
	x=dx-180, y=dy-vtb.fontHeight();
	continueButton=vtb.setUpQPushButton(this,"Next",
		80, vtb.fontHeight(), &x, &y);
	continueButton->setDefault(true);
	x=dx-80, y=dy-vtb.fontHeight();
	finishButton=vtb.setUpQPushButton(this,"Cancel",
		80, vtb.fontHeight(), &x, &y);
	// create the text
	int DX=5, DY=5;
	vtb.setUpFonts(QFont("helvetica",12,QFont::Normal));
	text=vtb.setUpLabelSize(this,"This will create a POP3 account.",
		dx-vtb.fontHeight()-10, &DX, &DY);
	DY+=vtb.fontHeight()+vtb.offsetY();
	DX=5;
	QString m("Server name:");
	int align=vtb.stringLength(m);
	serverLabel=vtb.setUpLabelSize(this, m,align, &DX, &DY);
	serverEdit=vtb.setUpLineEdit(this, 120, vtb.fontHeight(), &DX, &DY);
	portLabel=vtb.setUpLabel(this,"Port:", &DX, &DY);
	portEdit=vtb.setUpLineEdit(this, vtb.stringLength("MMM"), vtb.fontHeight(), &DX, &DY);
	DY+=vtb.fontHeight()+vtb.offsetY();
	DX=5;
	leaveOnServerBox=vtb.setUpQCheckBox(this,"Leave messages on server.", &DX, &DY);	
	DY+=vtb.fontHeight()+vtb.offsetY();
	DX=5;
	deleteAllBox=vtb.setUpQCheckBox(this,"Delete from server when deleted"
		" locally.", &DX, &DY);
	DY+=vtb.fontHeight()+vtb.offsetY();
	DX=5;
	timeBox=vtb.setUpQCheckBox(this,"Delete messages from server after", &DX, &DY);
	timeEdit=vtb.setUpLineEdit(this, vtb.stringLength("MM"), vtb.fontHeight(),
		&DX, &DY);
	days=vtb.setUpLabel(this,"days.", &DX, &DY);
	DY+=vtb.fontHeight()+vtb.offsetY();
	DX=5;
	accountLabel=vtb.setUpLabelSize(this,"User name:" ,align, &DX, &DY);
	accountEdit=vtb.setUpLineEdit(this, 120, vtb.fontHeight(), &DX, &DY);
	DX+=10;
	passwordLabel=vtb.setUpLabel(this,"Password:", &DX, &DY);
	passwordEdit=vtb.setUpLineEdit(this, 120, vtb.fontHeight(), &DX, &DY);
	passwordEdit->setEchoMode(QLineEdit::Password);
	DY+=vtb.fontHeight()+vtb.offsetY();
	DX=5;
	rememberPassBox=vtb.setUpQCheckBox(this,"Remember password.",
		&DX, &DY);	

	connect(backButton, SIGNAL(clicked()), this, SLOT(backClicked()));
	connect(continueButton, SIGNAL(clicked()), this, SLOT(continueClicked()));
	connect(finishButton, SIGNAL(clicked()), this, SLOT(finishClicked()));
	connect(leaveOnServerBox, SIGNAL(clicked()), this, SLOT(leaveClicked()));
	connect(rememberPassBox, SIGNAL(clicked()), this, SLOT(passClicked()));
	connect(timeBox, SIGNAL(clicked()), this, SLOT(timeClicked()));
	init();
}
void Pop3MailFrame::continueClicked()
{
	QStringList rez;
	rez.append("[POP3]");
	printf("1\n");
	rez.append(QString("Server=")+serverEdit->text());
	printf("2\n");
	rez.append(QString("Port=")+portEdit->text());
	printf("3\n");
	rez.append(QString("LeaveOnServer=")	+
		QString((leaveOnServerBox->isChecked())?"Yes":"No"));
	printf("4\n");
	rez.append(QString("RemoteDelete=")	+
		QString((deleteAllBox->isChecked())?"Yes":"No"));
	printf("5\n");
	rez.append(QString("RememberPassword=")	+
		QString((rememberPassBox->isChecked())?"Yes":"No"));
	printf("6\n");
	if(timeBox->isChecked())
		rez+="DeleteAfter="+timeEdit->text();
	printf("7\n");
	rez.append(QString("UserName=")+accountEdit->text());
	printf("8\n");
	if(rememberPassBox->isChecked())
		rez.append(QString("Password=")+passwordEdit->text());
	printf("9\n");
	emit result(ContinueMessage, index, rez);
	close();
}

void Pop3MailFrame::finishClicked()
{
	emit result(CancelMessage, index, QStringList(""));
	close();
}

void Pop3MailFrame::backClicked()
{
	emit result(BackMessage, index, QStringList(""));
	close();
}

void Pop3MailFrame::init()
{
	portEdit->setText("110");
	serverEdit->setText(Names::systemHostDomainName());
	accountEdit->setText(Names::systemLoginName());
	timeEdit->setText("10");
	timeEdit->setEnabled(false);
	timeBox->setEnabled(false);
	days->setEnabled(false);
	passwordEdit->setEnabled(false);
	passwordLabel->setEnabled(false);
	deleteAllBox->setEnabled(false);
}
void Pop3MailFrame::passClicked()
{
	bool b=rememberPassBox->isChecked();
	passwordEdit->setEnabled(b);
	passwordLabel->setEnabled(b);
}
void Pop3MailFrame::leaveClicked()
{
	bool b=leaveOnServerBox->isChecked();
	timeEdit->setEnabled(timeBox->isChecked());
	timeBox->setEnabled(b);
	days->setEnabled(b);
	deleteAllBox->setEnabled(b);
}

void Pop3MailFrame::timeClicked()
{
	bool b=timeBox->isChecked();
	timeEdit->setEnabled(b);
}


