/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef HAS_SETUP_WIZARD
	#define HAS_SETUP_WIZARD

#include <qmainwindow.h>
#include <qlabel.h>
#include <qstringlist.h>
#include <qwidgetstack.h>

// The frames' classes
#include <licenseframe.h>
#include <welcomeframe.h>
#include <toobadframe.h>
#include <choosedirframe.h>
#include <existsframe.h>
#include <identityframe.h>
#include <mailoptionsframe.h>
#include <localmailframe.h>
#include <pop3mailframe.h>
#include <smtpframe.h>
#include <summaryframe.h>
#include <congratsframe.h>
#include <imapmailframe.h>
#include <pluginframe.h>

class SetupWizardDialog : public QMainWindow
{
	Q_OBJECT
	public:
		SetupWizardDialog(QWidget *parent=0, const char *name=0);
	signals:
		void result(int);
		void sendConfig(QStringList);
	private slots:
		void processor(int, int, QStringList);
	private:
		QWidgetStack *frames;
		QStringList script;
		QStringList titles;
		QValueList<int> stack;
		QLabel *picture;
		QLabel *top;
		WelcomeFrame *f1;
		LicenseFrame *f2;
		ChooseDirFrame *f3; // aici intra dialogul pentru create
		ExistsFrame *f4; // dialogul pentru pastrare/nu de date.
		IdentityFrame *f5; // aici apare un bulon pentru deschis vcarddialog
		MailOptionsFrame *f6; // (local/remote)
		LocalMailFrame *f7;
		Pop3MailFrame *f8; // POP3 settings
		IMAPMailFrame *f9;
		SMTPFrame	*f10;
		/** The plug in support frame.*/
		PlugInFrame *f11;
		SummaryFrame *f12;
		CongratsFrame *f13;
		TooBadFrame  *f14;
};

#endif

