/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __CardListViewItem__
#define __CardListViewItem__

#include <cardlistview.h>
#include <elistviewitem.h>
#include <templateview.h>
#include <vobject.h>
#include <contactobj.h>

#define NAME_FIELD							1
#define HOME_ADDRESS_FIELD			2
#define PHONE_FIELD							3
#define WORK_ADDRESS_FIELD			4
#define DEFAULT_EMAIL_FIELD			6
#define URL_FIELD								7
#define TITLE_FIELD							8
#define ROLE_FIELD							9
#define ORGANIZATION_FIELD			10
#define CLASS_FIELD							11
#define FN_FIELD								12


class CardListViewItem : public EListViewItem, public TemplateView
{
	
  public:
    CardListViewItem(ContactObject *object, CardListView *parent, QStringList *f=0);
    ~CardListViewItem();
    
    void update();
		void setCard(ContactObject *newCard);
		ContactObject *card();
		void openYourself();
	protected:
		void mouseDoubleClickEvent(QMouseEvent *e);
	
	private:
		void setFields(int offset, ContactObject *, QStringList *, bool isRecursed=false, QWidget *parent=0);
		void paintCell(QPainter * p, const QColorGroup & cg, int column, int w, int align);
		void paintFocus (QPainter *, const QColorGroup & cg, const QRect & r);
		
		QString getField(int which, ContactObject *card, QString codes=QString::null);
		QString processName(QStringList n, QString codes);
		QString processAddress(QStringList adr, QString codes);
		QString processPhone(ContactObject *card, QString codes);
		
		
		
		ContactObject *_card;
		QStringList *fields;
		CardListView *_parent;
		QStringList contents;
};

#endif
