/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __CardTileWidget__
#define __CardTileWidget__

#include <stdio.h>
#include <cardtileview.h>
#include <tilewidget.h>
#include <qlist.h>
#include <qstringlist.h>
#include <qlabel.h>
#include <templateview.h>
#include <vobject.h>
#include <contactobj.h>


#define NAME_FIELD							1
#define HOME_ADDRESS_FIELD			2
#define PHONE_FIELD							3
#define WORK_ADDRESS_FIELD			4
#define DEFAULT_EMAIL_FIELD			6
#define URL_FIELD								7
#define TITLE_FIELD							8
#define ROLE_FIELD							9
#define ORGANIZATION_FIELD			10
#define CLASS_FIELD							11
#define FN_FIELD								12

class CardTileWidget : public TileWidget, public TemplateView
{
  Q_OBJECT
  public:
    CardTileWidget(CardTileView *parent, ContactObject *c, const char *name=0);
    ~CardTileWidget();
    ContactObject *card();
		void setCard(ContactObject *);
		void allocateNewFields(QStringList *fields=0);
		void allocateTitle(QString titleName=QString::null);
		/**Get the view parent.*/
		QWidget* localParent();

		// tile specific functions
    int keyCount();
    QString key(int number);
    QString keyName(int number);
  signals:
    void fieldChanged(QString fn, QString fv);
	public slots:
		void setState(ViewState state);
		void open();
    virtual void update();
		virtual void resize(int, int);
		
		void removeDialog(QString);
 	private:
    void setTitle(QString tn, QWidget *parent=0);
    void addField(int fieldNo, QString fn, QString fv, bool multiline=false, QWidget *parent=0);
		void setFields(int offset, ContactObject *, QStringList *, bool isRecursed=false, QWidget *parent=0);
		QString getField(int which, ContactObject *card, QString codes=QString::null);
		QString processName(QStringList n, QString codes);
		QString processAddress(QStringList adr, QString codes);
		QString processPhone(ContactObject *card, QString codes);
    QStringList nameList;
    QList<QLabel> fieldList;
    QList<QLabel> valueList;
    QLabel *title;
    int fCount, spacing;
		ContactObject *_card;
		QStringList *localFields;
		QWidget *_localParent;
	public:
		QWidget *dialogContactQuery(QString);
		static void addContactDialog(QString, QWidget *);
		static void removeContactDialog(QString);
	private:
		static QDict<QWidget> contactEditDialogs;
};

#endif
